/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.protocol.http.auth;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.protocol.http.HttpRequest;
import com.sap.caf.mp.base.protocol.http.HttpResponse;
import com.sap.caf.mp.base.protocol.http.auth.IAuthenticator;
import com.sap.caf.mp.base.util.Base64Encoder;

public class BasicAuthenticator
implements IAuthenticator {
    public static final String AUTH_SCHEMA_BASIC = "Basic";
    private String m_credentials;
    private String m_realm;
    private String m_uniqueKey;

    public BasicAuthenticator(String userName, String password) {
        this.m_credentials = Base64Encoder.encode(userName + ":" + password);
        this.m_realm = null;
        this.m_uniqueKey = "[BASIC][null]" + this.m_credentials;
    }

    public BasicAuthenticator(String userName, String password, String realm) {
        this.m_credentials = Base64Encoder.encode(userName + ":" + password);
        this.m_realm = realm;
        this.m_uniqueKey = "[BASIC][" + this.m_credentials + "]" + this.m_credentials;
    }

    public String getName() {
        return AUTH_SCHEMA_BASIC;
    }

    public String getRealm() {
        return this.m_realm;
    }

    private boolean enrichServer(HttpRequest request, HttpResponse response) throws EngineException {
        if (response != null) {
            try {
                if (response.getResponseHeader(17) != null) {
                    return false;
                }
            }
            catch (InvocationException e) {
                return false;
            }
        }
        try {
            request.setRequestHeader(13, "Basic " + this.m_credentials);
        }
        catch (InvocationException ex) {
            throw new EngineException((Exception)((Object)ex));
        }
        return true;
    }

    private boolean enrichProxy(HttpRequest request, HttpResponse response) throws EngineException {
        if (response != null) {
            try {
                if (response.getResponseHeader(13) != null) {
                    return false;
                }
            }
            catch (InvocationException e) {
                return false;
            }
        }
        try {
            request.setRequestHeader(23, "Basic " + this.m_credentials);
        }
        catch (Exception ex) {
            throw new EngineException(ex);
        }
        return true;
    }

    public boolean enrich(HttpRequest request, HttpResponse response, boolean proxy) throws EngineException {
        if (proxy) {
            return this.enrichProxy(request, response);
        }
        return this.enrichServer(request, response);
    }

    public String getUniqueKey() {
        return this.m_uniqueKey;
    }
}

