/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.protocol.http;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.base.protocol.http.HttpClient;
import com.sap.caf.mp.base.protocol.http.HttpRequest;
import com.sap.caf.mp.base.protocol.http.HttpResponse;
import com.sap.caf.mp.base.protocol.http.auth.IAuthenticator;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;

public class HttpClientConnection {
    public static final int PROTOCOL_VERSION_HTTP_1_0 = 0;
    public static final int PROTOCOL_VERSION_HTTP_1_1 = 1;
    public static final int PROTOCOL_HTTP = 0;
    public static final int PROTOCOL_HTTPS = 1;
    private static final int OUTPUT_BUFFER_SIZE = 4096;
    private static final String HTTP_MESSAGE_ENCODING = "ISO-8859-1";
    private static final int RETRY_COUNT = 2;
    protected int m_protocol;
    protected String m_hostName;
    protected int m_port;
    protected IAuthenticator m_authenticator;
    protected boolean m_useProxy;
    protected String m_proxyHostName;
    protected int m_proxyPort;
    protected boolean m_useTunneling;
    protected IAuthenticator m_proxyAuthenticator;
    private Socket m_socket;
    private InputStream m_socketInput;
    private OutputStream m_socketOutput;
    private BufferedOutputStream m_output;

    private void initStreams() throws IOException {
        this.m_socketInput = this.m_socket.getInputStream();
        this.m_socketOutput = this.m_socket.getOutputStream();
        this.m_output = new BufferedOutputStream(this.m_socketOutput, 4096);
    }

    private Socket createSocket() throws IOException {
        if (this.m_socket != null) {
            return this.m_socket;
        }
        switch (this.m_protocol) {
            case 0: {
                if (this.m_useProxy) {
                    if (HttpClient.isTraceEnabled()) {
                        HttpClient.traceEvent("HttpClientConnection::createSocket()", "Creating basic socket to proxy: " + this.m_proxyHostName + ":" + this.m_proxyPort);
                    }
                    this.m_socket = new Socket(this.m_proxyHostName, this.m_proxyPort);
                    break;
                }
                if (HttpClient.isTraceEnabled()) {
                    HttpClient.traceEvent("HttpClientConnection::createSocket()", "Creating basic socket to: " + this.m_hostName + ":" + this.m_port);
                }
                this.m_socket = new Socket(this.m_hostName, this.m_port);
                break;
            }
            case 1: {
                if (this.m_useProxy && this.m_useTunneling) {
                    if (!HttpClient.isTraceEnabled()) break;
                    HttpClient.traceEvent("HttpClientConnection::createSocket()", "Creating tunneling ssl socket to proxy: " + this.m_proxyHostName + ":" + this.m_proxyPort);
                    break;
                }
                if (this.m_useProxy) {
                    if (!HttpClient.isTraceEnabled()) break;
                    HttpClient.traceEvent("HttpClientConnection::createSocket()", "Creating plain ssl socket to proxy: " + this.m_proxyHostName + ":" + this.m_proxyPort);
                    break;
                }
                if (!HttpClient.isTraceEnabled()) break;
                HttpClient.traceEvent("HttpClientConnection::createSocket()", "Creating plain ssl socket to: " + this.m_hostName + ":" + this.m_port);
            }
        }
        return this.m_socket;
    }

    protected HttpClientConnection(int protocol, String hostName, int port, IAuthenticator authenticator) throws InvocationException {
        if (protocol < 0 || protocol > 1) {
            throw new InvocationException("Invalid protocol.");
        }
        this.m_protocol = protocol;
        this.m_hostName = hostName;
        this.m_port = port;
        this.m_authenticator = authenticator;
    }

    public HttpRequest constructHttpRequest(int requestMethod, String requestUri, int protocolVersion) throws InvocationException {
        HttpRequest request = new HttpRequest(requestMethod, requestUri, this, protocolVersion);
        return request;
    }

    public HttpRequest constructHttpRequest(String requestMethod, String requestUri, int protocolVersion) throws InvocationException {
        HttpRequest request = new HttpRequest(requestMethod, requestUri, this, protocolVersion);
        return request;
    }

    public void setProxy(boolean useProxy, String proxyHostName, int proxyPort, boolean useTunneling, IAuthenticator proxyAuthenticator) {
        this.m_useProxy = useProxy;
        this.m_proxyHostName = proxyHostName;
        this.m_proxyPort = proxyPort;
        this.m_useTunneling = useTunneling;
        this.m_proxyAuthenticator = proxyAuthenticator;
    }

    public HttpResponse executeRequest(HttpRequest request) throws InvocationException, EngineException {
        HttpResponse response = null;
        boolean done = false;
        do {
            boolean cont = true;
            if (this.m_authenticator != null) {
                cont = this.m_authenticator.enrich(request, response, false);
            }
            if (cont && this.m_proxyAuthenticator != null) {
                cont = this.m_proxyAuthenticator.enrich(request, response, true);
            }
            if (cont) {
                response = this.internalExecuteRequest(request);
                if (response.getResonseCode() == 401) {
                    if (this.m_authenticator != null) {
                        done = false;
                        continue;
                    }
                    done = true;
                    continue;
                }
                if (response.getResonseCode() == 407) {
                    if (this.m_proxyAuthenticator != null) {
                        done = false;
                        continue;
                    }
                    done = true;
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        } while (!done);
        return response;
    }

    public HttpResponse internalExecuteRequest(HttpRequest request) throws InvocationException, EngineException {
        long start = System.currentTimeMillis();
        int retriesLeft = 2;
        HttpResponse response = null;
        do {
            --retriesLeft;
            if (this.m_socket == null) {
                try {
                    this.createSocket();
                }
                catch (UnknownHostException e) {
                    if (HttpClient.isTraceEnabled()) {
                        HttpClient.traceEvent("HttpResponse::executeRequest()", e);
                    }
                    this.closeConnection();
                    throw new InvocationException(e.getMessage(), e);
                }
                catch (IOException e) {
                    if (HttpClient.isTraceEnabled()) {
                        HttpClient.traceEvent("HttpClientConnection::executeRequest()", e);
                    }
                    this.closeConnection();
                    if (retriesLeft != 0) continue;
                    throw new EngineException(e.getMessage(), e);
                }
            }
            try {
                this.initStreams();
            }
            catch (IOException e) {
                if (HttpClient.isTraceEnabled()) {
                    HttpClient.traceEvent("HttpClientConnection::executeRequest()", e);
                }
                this.closeConnection();
                if (retriesLeft != 0) continue;
                throw new EngineException(e.getMessage(), e);
            }
            StringBuffer msg = new StringBuffer();
            request.constructRequestLine(msg);
            request.constructMessageHeader(msg);
            String message = msg.toString();
            BaseLogManager.info(this.getClass(), message);
            try {
                byte[] body;
                byte[] data = message.getBytes(HTTP_MESSAGE_ENCODING);
                this.m_output.write(data);
                if (HttpClient.isTraceEnabled()) {
                    HttpClient.traceEvent("HttpClientConnection::executeRequest(): sending request header", data);
                }
                if ((body = request.getRequestBody()) != null) {
                    this.m_output.write(body);
                    if (HttpClient.isTraceEnabled()) {
                        HttpClient.traceEvent("HttpClientConnection::executeRequest(): sending request body", body);
                    }
                }
                this.m_output.flush();
            }
            catch (IOException ex) {
                if (HttpClient.isTraceEnabled()) {
                    HttpClient.traceEvent("HttpClientConnection::executeRequest(): sending request: EXCEPTION", ex);
                }
                this.closeConnection();
                if (retriesLeft != 0) continue;
                throw new EngineException(ex.getMessage(), ex);
            }
            try {
                response = new HttpResponse(request, this.m_socketInput);
                if (!response.isCloseRequired()) continue;
                this.closeConnection();
            }
            catch (IOException e) {
                if (HttpClient.isTraceEnabled()) {
                    HttpClient.traceEvent("HttpClientConnection::executeRequest(): receiving response: EXCEPTION", e);
                }
                this.closeConnection();
                if (retriesLeft != 0) continue;
                throw new EngineException(e.getMessage(), e);
            }
        } while (retriesLeft > 0 && response == null);
        long end = System.currentTimeMillis();
        BaseLogManager.performanceInfo(this.getClass(), "HttpClientConnection::executeRequest()", end - start);
        return response;
    }

    public void closeConnection() {
        try {
            this.m_socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_socketInput = null;
        this.m_socketOutput = null;
        this.m_output = null;
        this.m_socket = null;
    }
}

