/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.protocol.http;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.protocol.http.HttpClientConnection;
import com.sap.caf.mp.base.protocol.http.HttpRequest;
import com.sap.caf.mp.base.protocol.http.HttpResponse;
import com.sap.caf.mp.base.protocol.http.auth.IAuthenticator;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.GregorianCalendar;

public class HttpClient {
    private static String m_traceFileName = null;
    public static final String USER_AGENT = "com.sap.xapps.kn/1.0";
    private static final String TRACE_ENCODING = "UTF-8";

    public static void setTraceFileName(String traceFileName) {
        m_traceFileName = traceFileName;
    }

    public static void traceEvent(String eventName, String message) {
        HttpClient.traceEvent(eventName, message.getBytes());
    }

    public static void traceEvent(String eventName, Exception ex) {
        try {
            String info = "[" + ex.getClass().getName() + "] " + ex.getMessage();
            HttpClient.traceEvent(eventName, info.getBytes(TRACE_ENCODING));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static synchronized void traceEvent(String eventName, byte[] message) {
        if (m_traceFileName == null) {
            return;
        }
        try {
            FileOutputStream stream = new FileOutputStream(m_traceFileName, true);
            String timeStamp = GregorianCalendar.getInstance().getTime().toString() + " ";
            stream.write(timeStamp.getBytes(TRACE_ENCODING));
            stream.write(eventName.getBytes(TRACE_ENCODING));
            stream.write("\r\n".getBytes(TRACE_ENCODING));
            stream.write(message);
            stream.write("\r\n".getBytes(TRACE_ENCODING));
            stream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isTraceEnabled() {
        return m_traceFileName != null;
    }

    public static HttpClientConnection getConnection(int protocol, String hostName, int port, IAuthenticator authenticator) throws InvocationException {
        HttpClientConnection result = new HttpClientConnection(protocol, hostName, port, authenticator);
        return result;
    }

    public static void main(String[] args) {
        try {
            HttpClient.setTraceFileName("c:\\temp\\httpclient.trc");
            String url = "http://www.schemaweb.info/webservices/soap/SchemaWebSoap.asmx?wsdl";
            HttpClientConnection connection = HttpClient.getConnection(0, "www.schemaweb.info", 80, null);
            connection.setProxy(true, "proxy", 8080, false, null);
            HttpRequest request = connection.constructHttpRequest(0, "/", 1);
            HttpResponse response = connection.executeRequest(request);
            response = connection.executeRequest(request);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

