/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.portalclient;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.util.ByteArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class PortalResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Exception m_exception;
    private transient Object m_responseObject;

    public PortalResponse(Exception exception, Object responseObject) {
        this.m_exception = exception;
        this.m_responseObject = responseObject;
    }

    public Object getResponseObject() {
        return this.m_responseObject;
    }

    public Exception getException() {
        return this.m_exception;
    }

    public byte[] serialize() throws EngineException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(stream);
            os.writeObject(this);
            return stream.toByteArray();
        }
        catch (Exception ex) {
            throw new EngineException("Unable to serialize the portal response object: " + ex.getMessage(), ex);
        }
    }

    public static PortalResponse createInstance(byte[] stream) throws EngineException {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(stream);
            ObjectInputStream ois = new ObjectInputStream(is);
            return (PortalResponse)ois.readObject();
        }
        catch (Exception ex) {
            throw new EngineException("Unable to deserialize the portal response object: " + ex.getMessage(), ex);
        }
    }

    public static PortalResponse createInstance(InputStream stream) throws EngineException {
        byte[] data = null;
        try {
            data = new ByteArray(stream).toByteArray(false);
        }
        catch (Exception ex) {
            throw new EngineException("Unable to deserialize the portal response object: " + ex.getMessage(), ex);
        }
        if (data == null) {
            return null;
        }
        return PortalResponse.createInstance(data);
    }
}

