/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.portalclient;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.base.portalclient.IPortalClientAuthInfo;
import com.sap.caf.mp.base.portalclient.PortalCommand;
import com.sap.caf.mp.base.portalclient.PortalResponse;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class PortalClient {
    public static final String PORTAL_CLIENT_MIME_TYPE_REQUEST = "application/xap-kn-portalclientrequest";
    public static final String PORTAL_CLIENT_MIME_TYPE_RESPONSE = "application/xap-kn-portalclientresponse";
    private String m_protocol;
    private String m_host;
    private int m_port;
    private String m_targetResource;
    private IPortalClientAuthInfo m_authInfo;

    public PortalClient(String protocol, String host, int port, String targetResource, IPortalClientAuthInfo authInfo) {
        this.m_protocol = protocol;
        this.m_host = host;
        this.m_port = port;
        this.m_targetResource = targetResource;
        this.m_authInfo = authInfo;
    }

    private void closeConnection(HttpURLConnection connection) {
        if (connection != null) {
            connection.disconnect();
        }
    }

    public Object executeCommand(PortalCommand command) throws Exception {
        HttpURLConnection conn = null;
        try {
            long start = System.currentTimeMillis();
            URL url = new URL(this.m_protocol, this.m_host, this.m_port, this.m_targetResource);
            conn = (HttpURLConnection)url.openConnection();
            conn.setUseCaches(false);
            HttpURLConnection.setFollowRedirects(false);
            conn.setAllowUserInteraction(false);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            if (this.m_authInfo != null) {
                this.m_authInfo.setAuthentication(conn);
            }
            byte[] cmdData = command.serialize();
            conn.setRequestProperty("Content-Type", PORTAL_CLIENT_MIME_TYPE_REQUEST);
            conn.setRequestProperty("Content-Length", PORTAL_CLIENT_MIME_TYPE_RESPONSE);
            OutputStream stream = conn.getOutputStream();
            stream.write(cmdData);
            stream.close();
            long end = System.currentTimeMillis();
            BaseLogManager.performanceInfo(this.getClass(), "PortalClient: prepare request", end - start);
            start = System.currentTimeMillis();
            int responseCode = conn.getResponseCode();
            BaseLogManager.info(this.getClass(), "Portal connector response code: " + responseCode);
            end = System.currentTimeMillis();
            BaseLogManager.performanceInfo(this.getClass(), "PortalClient: execute the portal command", end - start);
            start = System.currentTimeMillis();
            if (responseCode != 200) {
                this.closeConnection(conn);
                throw new EngineException("An error occured while executing a portal command: " + conn.getResponseMessage());
            }
            int contentLength = Integer.parseInt(conn.getHeaderField("Content-Length"));
            PortalResponse response = null;
            if (contentLength != 0) {
                response = PortalResponse.createInstance(conn.getInputStream());
            }
            this.closeConnection(conn);
            end = System.currentTimeMillis();
            BaseLogManager.performanceInfo(this.getClass(), "PortalClient: interpret the response", end - start);
            if (response == null) {
                return null;
            }
            if (response.getException() != null) {
                throw response.getException();
            }
            return response.getResponseObject();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            this.closeConnection(conn);
            throw new InvocationException("The specified request parameters are incorrect.", ex);
        }
    }
}

