/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.logging;

import com.sap.caf.mp.base.logging.ILogManager;
import java.util.Calendar;

public class StandardStreamLogManager
implements ILogManager {
    private String getTimeStamp() {
        return Calendar.getInstance().getTime().toString();
    }

    public void info(Class context, String msg) {
        System.out.println("[" + context.getName() + "] " + this.getTimeStamp() + " INFO: " + msg);
    }

    public void warn(Class context, String msg) {
        System.out.println("[" + context.getName() + "] " + this.getTimeStamp() + " WARNING: " + msg);
    }

    public void error(Class context, String msg) {
        System.err.println("[" + context.getName() + "] " + this.getTimeStamp() + " ERROR: " + msg);
    }

    public void error(Class context, String msg, Exception ex) {
        System.err.println("[" + context.getName() + "] " + this.getTimeStamp() + " ERROR: " + msg + ", " + ex.toString());
        ex.printStackTrace(System.err);
    }

    public void performanceInfo(Class context, String msg, long time) {
        System.out.println("[" + context.getName() + "] " + this.getTimeStamp() + " PERFORMANCE: " + msg + ": " + time + " ms.");
    }

    public void error(Class context, Exception ex) {
        ex.printStackTrace(System.err);
    }
}

