/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.device;

import com.sap.caf.mp.base.device.DeviceTypeDefParser;
import com.sap.caf.mp.base.device.DeviceTypeDefinition;
import com.sap.caf.mp.base.exception.EngineException;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class DeviceTypeDefinitions {
    private Hashtable m_definitions;
    private String m_fallbackLanguage;
    private DeviceTypeDefinition m_default;

    public DeviceTypeDefinitions(InputStream stream, String fallbackLanguage) throws EngineException {
        this.m_fallbackLanguage = fallbackLanguage;
        this.m_definitions = new Hashtable();
        DeviceTypeDefParser parser = new DeviceTypeDefParser(stream, this, fallbackLanguage);
        if (this.m_default == null) {
            throw new EngineException("Invalid definitions document: no default device type defined.");
        }
    }

    public void addDefinition(DeviceTypeDefinition definition) {
        this.m_definitions.put(definition.getName(), definition);
        if (definition.isDefault()) {
            this.m_default = definition;
        }
    }

    public DeviceTypeDefinition getDefaultDefinition() {
        return this.m_default;
    }

    public int size() {
        return this.m_definitions.size();
    }

    public Enumeration getDefinitions() {
        return this.m_definitions.elements();
    }

    public DeviceTypeDefinition getDefinition(String name) {
        return (DeviceTypeDefinition)this.m_definitions.get(name);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DeviceTypeDefinitions:\r\n");
        Enumeration enumeration = this.m_definitions.elements();
        while (enumeration.hasMoreElements()) {
            DeviceTypeDefinition def = (DeviceTypeDefinition)enumeration.nextElement();
            buffer.append(def.toString());
            buffer.append("\r\n");
        }
        return buffer.toString();
    }

    public DeviceTypeDefinition createDeviceTypeDefintionInstance(String name, boolean isDefault, String masterLanguage, Hashtable titles, Hashtable userAgents) {
        DeviceTypeDefinition definition = new DeviceTypeDefinition(name, this.m_fallbackLanguage, isDefault);
        definition.setMasterLanguage(masterLanguage);
        definition.setTitles(titles);
        definition.setUserAgents(userAgents);
        return definition;
    }

    public static void main(String[] args) {
        try {
            FileInputStream stream = new FileInputStream("c:\\temp\\device_type_definitions.xml ");
            DeviceTypeDefinitions deviceTypeDefinitions = new DeviceTypeDefinitions(stream, "en");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

