/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.device;

import com.sap.caf.mp.base.device.DeviceTypeDefinition;
import com.sap.caf.mp.base.device.DeviceTypeDefinitions;
import com.sap.caf.mp.base.exception.EngineException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DeviceTypeDefParser
extends DefaultHandler {
    private DeviceTypeDefinitions m_parent;
    private int m_state = 0;
    private DeviceTypeDefinition m_current = null;
    private String m_fallbackLanguage;
    private static final int SECTION_NONE = 0;
    private static final int SECTION_DEFINITIONS = 1;
    private static final int SECTION_DEFINITION = 2;
    private static final int SECTION_TITLELIST = 3;
    private static final int SECTION_TITLE = 4;
    private static final int SECTION_USERAGENTLIST = 5;
    private static final int SECTION_USERAGENT = 6;
    private static Hashtable m_elements = new Hashtable();

    protected DeviceTypeDefParser(InputStream stream, DeviceTypeDefinitions parent, String fallbackLanguage) throws EngineException {
        this.m_fallbackLanguage = fallbackLanguage;
        this.m_parent = parent;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            parser.parse(stream, (DefaultHandler)this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new EngineException(ex);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        Integer tp = (Integer)m_elements.get(localName);
        if (tp == null) {
            return;
        }
        switch (tp) {
            case 2: {
                this.m_state = 1;
                break;
            }
            case 1: {
                this.m_state = 0;
                break;
            }
            case 4: {
                this.m_state = 3;
                break;
            }
            case 3: {
                this.m_state = 2;
                break;
            }
            case 6: {
                this.m_state = 5;
                break;
            }
            case 5: {
                this.m_state = 2;
            }
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Integer tp = (Integer)m_elements.get(localName);
        if (tp == null) {
            return;
        }
        switch (tp) {
            case 1: {
                if (this.m_state != 0) {
                    return;
                }
                this.m_state = 1;
                break;
            }
            case 2: {
                if (this.m_state != 1) {
                    return;
                }
                this.m_state = 2;
                String name = null;
                boolean def = false;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getLocalName(i).equals("name")) {
                        name = attributes.getValue(i);
                        continue;
                    }
                    if (!attributes.getLocalName(i).equals("default")) continue;
                    def = attributes.getValue(i).equals("true");
                }
                if (name == null) {
                    throw new SAXException("Invalid DeviceTypeDefinition element: name attribute is missing.");
                }
                this.m_current = new DeviceTypeDefinition(name, this.m_fallbackLanguage, def);
                this.m_parent.addDefinition(this.m_current);
                break;
            }
            case 3: {
                if (this.m_state != 2) {
                    return;
                }
                this.m_state = 3;
                String masterLang = null;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getLocalName(i).equals("masterLanguage")) continue;
                    masterLang = attributes.getValue(i);
                }
                if (masterLang == null) {
                    throw new SAXException("Invalid TitleList element for device type definition named " + this.m_current.getName() + ": masterLanguage attribute is missing.");
                }
                this.m_current.setMasterLanguage(masterLang);
                break;
            }
            case 4: {
                if (this.m_state != 3) {
                    return;
                }
                this.m_state = 4;
                String language = null;
                String text = null;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getLocalName(i).equals("language")) {
                        language = attributes.getValue(i);
                        continue;
                    }
                    if (!attributes.getLocalName(i).equals("text")) continue;
                    text = attributes.getValue(i);
                }
                if (language == null) {
                    throw new SAXException("Invalid Title element for device type definition named " + this.m_current.getName() + ": language attribute is missing.");
                }
                if (text == null) {
                    throw new SAXException("Invalid Title element for device type definition named " + this.m_current.getName() + ": text attribute is missing.");
                }
                this.m_current.addTitle(language, text);
                break;
            }
            case 5: {
                if (this.m_state != 2) {
                    return;
                }
                this.m_state = 5;
                break;
            }
            case 6: {
                if (this.m_state != 5) {
                    return;
                }
                this.m_state = 6;
                String agentName = null;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getLocalName(i).equals("name")) continue;
                    agentName = attributes.getValue(i);
                }
                if (agentName == null) {
                    throw new SAXException((Exception)((Object)new EngineException("Invalid UserAgent element for device type definition named " + this.m_current.getName() + ": name attribute is missing.")));
                }
                this.m_current.addUserAgent(agentName);
            }
        }
    }

    static {
        m_elements.put("DeviceTypeDefinitions", new Integer(1));
        m_elements.put("DeviceTypeDefinition", new Integer(2));
        m_elements.put("TitleList", new Integer(3));
        m_elements.put("Title", new Integer(4));
        m_elements.put("UserAgentList", new Integer(5));
        m_elements.put("UserAgent", new Integer(6));
    }
}

