/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.db;

import com.sap.caf.mp.base.db.CNConnection;
import com.sap.caf.mp.base.db.ICNConnectionPool;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import java.util.Vector;

public class ConnectionPoolOpenSQLStandalone
implements ICNConnectionPool {
    public static final String DATABASE_URL = "DATABASE_URL";
    public static final String DATABASE_PWD = "DATABASE_PWD";
    public static final String DATABASE_USER = "DATABASE_USER";
    public static final String POOL_MIN = "POOL_MIN";
    public static final String POOL_MAX = "POOL_MAX";
    private String m_databaseUrl;
    private String m_databaseUser;
    private String m_databasePwd;
    private int m_poolMin;
    private int m_poolMax;
    private int m_allocated;
    private boolean m_invalidateOnReturn;
    private Vector m_pooledConnections;

    public void initialize(Properties props) throws InvocationException, EngineException {
        this.m_databaseUrl = props.getProperty(DATABASE_URL);
        this.m_databaseUser = props.getProperty(DATABASE_USER);
        this.m_databasePwd = props.getProperty(DATABASE_PWD);
        BaseLogManager.info(this.getClass(), this.m_databaseUrl + ", " + this.m_databaseUser + ", " + this.m_databasePwd);
        this.m_poolMin = Integer.parseInt(props.getProperty(POOL_MIN));
        this.m_poolMax = Integer.parseInt(props.getProperty(POOL_MAX));
        if (this.m_poolMax == 0) {
            this.m_invalidateOnReturn = true;
            this.m_poolMax = this.m_poolMin;
        }
        this.m_allocated = 0;
        this.m_pooledConnections = new Vector();
        try {
            Class.forName("com.sap.sql.jdbc.common.CommonDriver");
        }
        catch (Exception ex) {
            throw new EngineException(ex.getMessage(), ex);
        }
        BaseLogManager.info(this.getClass(), "Common SQL Driver loaded.");
        try {
            for (int i = 0; i < this.m_poolMin; ++i) {
                Connection baseConn = DriverManager.getConnection(this.m_databaseUrl, this.m_databaseUser, this.m_databasePwd);
                CNConnection wrapper = new CNConnection(baseConn, this);
                this.m_pooledConnections.add(wrapper);
            }
        }
        catch (Exception ex) {
            throw new EngineException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws EngineException {
        Vector vector = this.m_pooledConnections;
        synchronized (vector) {
            Connection conn;
            if (this.m_pooledConnections.size() > 0) {
                Connection result = (Connection)this.m_pooledConnections.remove(0);
                return result;
            }
            if (this.m_allocated >= this.m_poolMax) {
                throw new EngineException("Unable to allocate more connections, no connection available at this time.");
            }
            try {
                conn = DriverManager.getConnection(this.m_databaseUrl, this.m_databaseUser, this.m_databasePwd);
            }
            catch (Exception ex) {
                throw new EngineException(ex.getMessage(), ex);
            }
            CNConnection result = new CNConnection(conn, this);
            ++this.m_allocated;
            BaseLogManager.info(this.getClass(), "Connection to " + this.m_databaseUrl + " allocated.");
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ReturnConnection(Connection conn, boolean invalid) {
        Vector vector = this.m_pooledConnections;
        synchronized (vector) {
            if (invalid || this.m_invalidateOnReturn) {
                --this.m_allocated;
            } else {
                this.m_pooledConnections.add(conn);
            }
        }
    }

    public static void main(String[] args) {
        try {
            Properties props = new Properties();
            props.put(DATABASE_PWD, "admin");
            props.put(DATABASE_URL, "jdbc:microsoft:sqlserver://p34255");
            props.put(DATABASE_USER, "sa");
            props.put(POOL_MIN, "1");
            props.put(POOL_MAX, "5");
            ConnectionPoolOpenSQLStandalone pool = new ConnectionPoolOpenSQLStandalone();
            pool.initialize(props);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

