/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.config;

import com.sap.caf.mp.base.config.FileSystemConfigStore;
import com.sap.caf.mp.base.config.IConfigFile;
import com.sap.caf.mp.base.config.IConfigStore;
import com.sap.caf.mp.base.exception.EngineException;

public class BaseConfigStore {
    private static IConfigStore m_store;

    public static void setConfigStore(IConfigStore store) {
        m_store = store;
    }

    public static IConfigStore getConfigStore() {
        return m_store;
    }

    public static IConfigFile getConfigFile(String name) throws EngineException {
        if (m_store == null) {
            return null;
        }
        return m_store.getConfigFile(name);
    }

    private BaseConfigStore() {
    }

    public static void main(String[] args) {
        try {
            IConfigFile file = BaseConfigStore.getConfigFile("etc/xap_kn_metamodel_v1.xsd");
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
    }

    static {
        String localHome = System.getProperty("java.home");
        String localPath = System.getProperty("configstore.path", localHome);
        m_store = new FileSystemConfigStore(localPath);
    }
}

