/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.syncdb.internal.mget;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.util.TimeUtilities;
import com.tssap.dtr.client.lib.vfs.syncdb.internal.mget.SyncDbMget;
import com.tssap.dtr.client.lib.vfs.syncdb.internal.mget.SyncEntryImplMget;
import java.util.Date;
import java.util.Iterator;

public class TouchTimeConsistencyMget {
    private static final TouchTimeConsistencyMget TOUCH_TIME_CONSISTENCY = new TouchTimeConsistencyMget();
    private long _lastTouchTime = System.currentTimeMillis();
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$syncdb$internal$mget$TouchTimeConsistencyMget == null ? (class$com$tssap$dtr$client$lib$vfs$syncdb$internal$mget$TouchTimeConsistencyMget = TouchTimeConsistencyMget.class$("com.tssap.dtr.client.lib.vfs.syncdb.internal.mget.TouchTimeConsistencyMget")) : class$com$tssap$dtr$client$lib$vfs$syncdb$internal$mget$TouchTimeConsistencyMget));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$syncdb$internal$mget$TouchTimeConsistencyMget;

    private TouchTimeConsistencyMget() {
    }

    public static TouchTimeConsistencyMget getInstance() {
        return TOUCH_TIME_CONSISTENCY;
    }

    long getTouchTime() {
        long now = System.currentTimeMillis();
        this._lastTouchTime = this._lastTouchTime > now ? ++this._lastTouchTime : now;
        return this._lastTouchTime;
    }

    void correctTouchTimesAfterDepersisting(SyncDbMget syncDb) {
        long validTouchTime = this.getTouchTime();
        Iterator iterator = syncDb.resourcePaths();
        while (iterator.hasNext()) {
            String absoluteLocalPath = (String)iterator.next();
            SyncEntryImplMget entry = (SyncEntryImplMget)syncDb.getEntry(absoluteLocalPath);
            if (entry.getTouchTime() <= validTouchTime) continue;
            String METHOD = "updateTouchTimesAfterDepersisting";
            LOCATION.warningT("updateTouchTimesAfterDepersisting", "Touch time is in future ({0}), resetting to {1} for entry {2}.", new Object[]{TimeUtilities.toTimeString(new Date(entry.getTouchTime())), TimeUtilities.toTimeString(new Date(validTouchTime)), entry});
            entry.setTouchTime(validTouchTime);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

