/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.syncdb.internal.mget;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.util.Assert;
import com.tssap.dtr.client.lib.util.TimeUtilities;
import com.tssap.dtr.client.lib.util.persistence.IDepersistFactory;
import com.tssap.dtr.client.lib.util.persistence.IPersistable;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncEntryMget;
import com.tssap.dtr.client.lib.vfs.syncdb.internal.mget.ISyncDbChangesMget;
import com.tssap.dtr.client.lib.vfs.syncdb.internal.mget.SyncDbPropertiesMget;
import com.tssap.dtr.client.lib.vfs.syncdb.internal.mget.TouchTimeConsistencyMget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;

public class SyncEntryImplMget
implements IPersistable,
SyncEntryMget {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$syncdb$internal$mget$SyncEntryImplMget == null ? (class$com$tssap$dtr$client$lib$vfs$syncdb$internal$mget$SyncEntryImplMget = SyncEntryImplMget.class$("com.tssap.dtr.client.lib.vfs.syncdb.internal.mget.SyncEntryImplMget")) : class$com$tssap$dtr$client$lib$vfs$syncdb$internal$mget$SyncEntryImplMget));
    private static final byte SYNCENTRY_VERSION = 1;
    ISyncDbChangesMget _journal;
    private long _localLastModified;
    private String _mountPointRelativeLocalPath;
    private long _remoteSyncTime;
    private SyncDbPropertiesMget _syncDbProperties;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$syncdb$internal$mget$SyncEntryImplMget;

    SyncEntryImplMget(ISyncDbChangesMget journal, SyncDbPropertiesMget syncDbProperties) {
        this.touch();
        String METHOD = "SyncEntryImplMget(journal,properties)";
        LOCATION.pathT("SyncEntryImplMget(journal,properties)", "empty SyncEntryImplMget created");
        Assert.isNotNull(journal);
        this._journal = journal;
        Assert.isNotNull(syncDbProperties);
        this._syncDbProperties = syncDbProperties;
    }

    SyncEntryImplMget(ISyncDbChangesMget journal, SyncDbPropertiesMget syncDbProperties, String mountPointRelativeLocalPath) {
        this.touch();
        String METHOD = "SyncEntryImpl(journal,properties,mountPointRelativeLocalPath)";
        LOCATION.pathT("SyncEntryImpl(journal,properties,mountPointRelativeLocalPath)", "empty SyncEntryImplMget created");
        Assert.isNotNull(journal);
        this._journal = journal;
        Assert.isNotNull(mountPointRelativeLocalPath);
        this._mountPointRelativeLocalPath = mountPointRelativeLocalPath;
        Assert.isNotNull(syncDbProperties);
        this._syncDbProperties = syncDbProperties;
    }

    public String getAbsoluteLocalPath() {
        return this._syncDbProperties.getMointPointAbsoluteLocalPath().concat(this._mountPointRelativeLocalPath);
    }

    String getMountPointRelativeLocalPath() {
        return this._mountPointRelativeLocalPath;
    }

    public long getRemoteSyncTime() {
        return this._remoteSyncTime;
    }

    public void setRemoteSyncTime(long timestamp) {
        String METHOD = "setRemoteSyncTime";
        LOCATION.debugT("setRemoteSyncTime", "=> {0} ({1})", new Object[]{new Date(timestamp), this});
        this._remoteSyncTime = timestamp;
        this.touchAndJournalChange();
    }

    private void touch() {
        this._localLastModified = TouchTimeConsistencyMget.getInstance().getTouchTime();
    }

    public long getLocalLastModified() {
        return this._localLastModified;
    }

    public String getId() {
        return "SYNCENTRY-MGET";
    }

    public void persist(DataOutputStream dataOutputStream) throws IOException {
        String METHOD = "persist";
        if (this._mountPointRelativeLocalPath == null) {
            throw new IllegalStateException("No local path for sync entry.");
        }
        LOCATION.debugT("persist", "+ Persisting {0}.", new Object[]{this});
        dataOutputStream.writeByte(1);
        dataOutputStream.writeUTF(this._mountPointRelativeLocalPath);
        dataOutputStream.writeLong(this._remoteSyncTime);
        dataOutputStream.writeLong(this._localLastModified);
    }

    public IPersistable depersist(DataInputStream dataInputStream, IDepersistFactory childrenFactory) throws IOException {
        String METHOD = "depersist";
        LOCATION.pathT("depersist", "Depersisting entry ...");
        byte version = dataInputStream.readByte();
        LOCATION.debugT("depersist", "found version {0}", new Object[]{new Byte(version)});
        switch (version) {
            case 1: {
                this.depersist_v1(dataInputStream);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown sync entry version. Update to latest client.");
            }
        }
        return this;
    }

    private void depersist_v1(DataInputStream dataInputStream) throws IOException {
        String METHOD = "depersist_v1";
        this._mountPointRelativeLocalPath = dataInputStream.readUTF();
        Assert.isNotNull(this._mountPointRelativeLocalPath);
        this._remoteSyncTime = dataInputStream.readLong();
        this._localLastModified = dataInputStream.readLong();
        LOCATION.debugT("depersist_v1", "+ Depersisted {0}.", new Object[]{this});
    }

    public boolean isEqual(SyncEntryImplMget second) {
        SyncEntryImplMget first = this;
        return first.getAbsoluteLocalPath().equals(second.getAbsoluteLocalPath()) && first.getRemoteSyncTime() == second.getRemoteSyncTime();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(512);
        buffer.append("SyncEntryImplMget[");
        buffer.append(this._mountPointRelativeLocalPath == null ? "<undefined>" : this.getAbsoluteLocalPath());
        buffer.append("]{touch=");
        buffer.append(TimeUtilities.toUrlTimeString(new Date(this._localLastModified)));
        buffer.append(", sync=");
        buffer.append(TimeUtilities.toTimeString(new Date(this.getRemoteSyncTime())));
        buffer.append("}");
        return buffer.toString();
    }

    private void touchAndJournalChange() {
        this.touch();
        this._journal.onChangeEntry(this);
    }

    public long getTouchTime() {
        return this._localLastModified;
    }

    void setTouchTime(long localLastModified) {
        this._localLastModified = localLastModified;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

