/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.syncdb.internal;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.util.Assert;
import com.tssap.dtr.client.lib.util.TimeUtilities;
import com.tssap.dtr.client.lib.util.persistence.IDepersistFactory;
import com.tssap.dtr.client.lib.util.persistence.IPersistable;
import com.tssap.dtr.client.lib.vfs.VfsRuntimeException;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncEntry;
import com.tssap.dtr.client.lib.vfs.syncdb.internal.ISyncDbChanges;
import com.tssap.dtr.client.lib.vfs.syncdb.internal.SyncDbProperties;
import com.tssap.dtr.client.lib.vfs.syncdb.internal.TouchTimeConsistency;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;

public class SyncEntryImpl
implements IPersistable,
SyncEntry {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$syncdb$internal$SyncEntryImpl == null ? (class$com$tssap$dtr$client$lib$vfs$syncdb$internal$SyncEntryImpl = SyncEntryImpl.class$("com.tssap.dtr.client.lib.vfs.syncdb.internal.SyncEntryImpl")) : class$com$tssap$dtr$client$lib$vfs$syncdb$internal$SyncEntryImpl));
    private static final byte SYNCENTRY_VERSION = 1;
    ISyncDbChanges _journal;
    private long _localLastModified;
    private String _mountPointRelativeLocalPath;
    private String _serverRelativeVersionUrl;
    private long _remoteSyncTime;
    private long _localUploadTime;
    private long _remoteDownloadTime;
    private String _objectId;
    private SyncDbProperties _syncDbProperties;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$syncdb$internal$SyncEntryImpl;

    SyncEntryImpl(ISyncDbChanges journal, SyncDbProperties syncDbProperties) {
        this.touch();
        String METHOD = "SyncEntryImpl(journal)";
        LOCATION.pathT("SyncEntryImpl(journal)", "empty SyncEntryImpl created");
        Assert.isNotNull(journal);
        this._journal = journal;
        this._objectId = "UNKNOWN_OBJECT_ID";
        Assert.isNotNull(syncDbProperties);
        this._syncDbProperties = syncDbProperties;
    }

    SyncEntryImpl(ISyncDbChanges journal, SyncDbProperties syncDbProperties, String mountPointRelativeLocalPath, String objectId) {
        this.touch();
        String METHOD = "SyncEntryImpl(journal,mountPointRelativeLocalPath,objectId)";
        LOCATION.pathT("SyncEntryImpl(journal,mountPointRelativeLocalPath,objectId)", "empty SyncEntryImpl created");
        Assert.isNotNull(journal);
        this._journal = journal;
        Assert.isNotNull(mountPointRelativeLocalPath);
        this._mountPointRelativeLocalPath = mountPointRelativeLocalPath;
        Assert.isStringNotEmpty(objectId);
        this._objectId = objectId;
        Assert.isNotNull(syncDbProperties);
        this._syncDbProperties = syncDbProperties;
    }

    public String getAbsoluteLocalPath() {
        return this._syncDbProperties.getMointPointAbsoluteLocalPath().concat(this._mountPointRelativeLocalPath);
    }

    public String getMountPointRelativeLocalPath() {
        return this._mountPointRelativeLocalPath;
    }

    public long getRemoteSyncTime() {
        return this._remoteSyncTime;
    }

    public long getLocalUploadTime() {
        return this._localUploadTime;
    }

    public long getRemoteDownloadTime() {
        return this._remoteDownloadTime;
    }

    public String getVersionUrl() {
        if (this._serverRelativeVersionUrl == null) {
            return null;
        }
        if ("UNKNOWN_VERSION_URL".equals(this._serverRelativeVersionUrl)) {
            return "UNKNOWN_VERSION_URL";
        }
        return this._syncDbProperties.getServerUrl().concat(this._serverRelativeVersionUrl);
    }

    public void setLocalUploadTime(long localUploadTime) {
        String METHOD = "setLocalUploadTime";
        LOCATION.debugT("setLocalUploadTime", "=> {0} ({1})", new Object[]{new Date(localUploadTime), this});
        this._localUploadTime = localUploadTime;
        this.touchAndJournalChange();
    }

    public void setRemoteDownloadTime(long remoteDownloadTime) {
        String METHOD = "setRemoteDownloadTime";
        LOCATION.debugT("setRemoteDownloadTime", "=> {0} ({1})", new Object[]{new Date(remoteDownloadTime), this});
        this._remoteDownloadTime = remoteDownloadTime;
        this.touchAndJournalChange();
    }

    public void setVersionUrlAndRemoteSyncTime(String versionUrl, long timestamp) {
        String METHOD = "setVersionUrlAndRemoteSyncTime";
        if (versionUrl != null) {
            String serverUrl = this._syncDbProperties.getServerUrl();
            if (versionUrl.equals("UNKNOWN_VERSION_URL")) {
                versionUrl = "UNKNOWN_VERSION_URL";
            } else {
                if (!versionUrl.startsWith(serverUrl)) {
                    throw new VfsRuntimeException("Given versionUrl \"" + versionUrl + "\" doesn't start with serverUrl \"" + serverUrl + "\"");
                }
                versionUrl = versionUrl.substring(serverUrl.length());
            }
        } else {
            LOCATION.warningT("setVersionUrlAndRemoteSyncTime", "parameter 'versionUrl' is <null>.");
        }
        LOCATION.debugT("setVersionUrlAndRemoteSyncTime", "=> {0} / {1} ({2})", new Object[]{versionUrl, new Date(timestamp), this});
        this._serverRelativeVersionUrl = versionUrl;
        this._remoteSyncTime = timestamp;
        this.touchAndJournalChange();
    }

    private void touch() {
        this._localLastModified = TouchTimeConsistency.getInstance().getTouchTime();
    }

    public long getLocalLastModified() {
        return this._localLastModified;
    }

    public String getId() {
        return "SYNCENTRY";
    }

    public void persist(DataOutputStream dataOutputStream) throws IOException {
        String METHOD = "persist";
        if (this._mountPointRelativeLocalPath == null) {
            throw new IllegalStateException("No local path for sync entry.");
        }
        LOCATION.debugT("persist", "+ Persisting {0}.", new Object[]{this});
        dataOutputStream.writeByte(1);
        dataOutputStream.writeUTF(this._mountPointRelativeLocalPath);
        dataOutputStream.writeUTF(this._serverRelativeVersionUrl != null ? this._serverRelativeVersionUrl : "");
        dataOutputStream.writeLong(this._remoteSyncTime);
        dataOutputStream.writeLong(this._localUploadTime);
        dataOutputStream.writeLong(this._remoteDownloadTime);
        dataOutputStream.writeUTF(this._objectId);
        dataOutputStream.writeLong(this._localLastModified);
    }

    public IPersistable depersist(DataInputStream dataInputStream, IDepersistFactory childrenFactory) throws IOException {
        String METHOD = "depersist";
        LOCATION.pathT("depersist", "Depersisting entry ...");
        byte version = dataInputStream.readByte();
        LOCATION.debugT("depersist", "found version {0}", new Object[]{new Byte(version)});
        switch (version) {
            case 1: {
                this.depersist_v1(dataInputStream);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown sync entry version. Update to latest client.");
            }
        }
        return this;
    }

    private void depersist_v1(DataInputStream dataInputStream) throws IOException {
        String METHOD = "depersist_v1";
        this._mountPointRelativeLocalPath = dataInputStream.readUTF();
        Assert.isNotNull(this._mountPointRelativeLocalPath);
        this._serverRelativeVersionUrl = dataInputStream.readUTF();
        Assert.isNotNull(this._serverRelativeVersionUrl);
        if (this._serverRelativeVersionUrl.equals("UNKNOWN_VERSION_URL")) {
            this._serverRelativeVersionUrl = "UNKNOWN_VERSION_URL";
        } else if (this._serverRelativeVersionUrl.length() == 0) {
            this._serverRelativeVersionUrl = null;
        }
        this._remoteSyncTime = dataInputStream.readLong();
        this._localUploadTime = dataInputStream.readLong();
        this._remoteDownloadTime = dataInputStream.readLong();
        this._objectId = dataInputStream.readUTF();
        this._localLastModified = dataInputStream.readLong();
        LOCATION.debugT("depersist_v1", "+ Depersisted {0}.", new Object[]{this});
    }

    public boolean isEqual(SyncEntryImpl second) {
        SyncEntryImpl first = this;
        return first.getAbsoluteLocalPath().equals(second.getAbsoluteLocalPath()) && first.getVersionUrl().equals(second.getVersionUrl()) && first.getRemoteSyncTime() == second.getRemoteSyncTime() && first.getLocalUploadTime() == second.getLocalUploadTime() && first.getRemoteDownloadTime() == second.getRemoteDownloadTime();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(512);
        buffer.append("SyncEntryImpl[");
        buffer.append(this._mountPointRelativeLocalPath == null ? "<undefined>" : this.getAbsoluteLocalPath());
        buffer.append("]{touch=");
        buffer.append(TimeUtilities.toUrlTimeString(new Date(this._localLastModified)));
        buffer.append(", sync=");
        buffer.append(TimeUtilities.toTimeString(new Date(this.getRemoteSyncTime())));
        buffer.append(", upload=");
        buffer.append(TimeUtilities.toTimeString(new Date(this.getLocalUploadTime())));
        buffer.append(", download=");
        buffer.append(TimeUtilities.toTimeString(new Date(this.getRemoteDownloadTime())));
        buffer.append(", version=");
        buffer.append(this._serverRelativeVersionUrl == null ? "<undefined>" : this.getVersionUrl());
        buffer.append(", objectId=");
        buffer.append(this.getObjectId());
        buffer.append("}");
        return buffer.toString();
    }

    public boolean isSynced() {
        return this.getRemoteSyncTime() != 0L;
    }

    public boolean isSynced(long referringTimestamp) {
        if (!this.isSynced()) {
            return false;
        }
        long timeDiff = this.getRemoteSyncTime() - referringTimestamp;
        if (timeDiff >= 0L) {
            return true;
        }
        if (timeDiff > -1000L) {
            return referringTimestamp / 1000L == this.getRemoteSyncTime() / 1000L;
        }
        return false;
    }

    public boolean isUploaded() {
        return this.getLocalUploadTime() != 0L;
    }

    public boolean isUploaded(long referringTimestamp) {
        return !this.isUploaded() ? false : this.getLocalUploadTime() == referringTimestamp;
    }

    public void reset() {
        String METHOD = "reset";
        LOCATION.debugT("reset", "Reset (remoteSyncTime, localUploadTime, versionUrl) of {0}", new Object[]{this});
        this._remoteSyncTime = 0L;
        this._localUploadTime = 0L;
        this._serverRelativeVersionUrl = null;
        this.touchAndJournalChange();
    }

    public void resetSyncData() {
        String METHOD = "resetSyncData";
        LOCATION.debugT("resetSyncData", "Reset (remoteSyncTime, versionUrl) of {0}", new Object[]{this});
        this._remoteSyncTime = 0L;
        this._serverRelativeVersionUrl = null;
        this.touchAndJournalChange();
    }

    public void resetUploadTimestamp() {
        String METHOD = "resetUploadTimestamp";
        LOCATION.debugT("resetUploadTimestamp", "Reset (localUploadTime) of {0}", new Object[]{this});
        this._localUploadTime = 0L;
        this.touchAndJournalChange();
    }

    private void touchAndJournalChange() {
        this.touch();
        this._journal.onChangeEntry(this);
    }

    public String getObjectId() {
        return this._objectId;
    }

    public long getTouchTime() {
        return this._localLastModified;
    }

    void setTouchTime(long localLastModified) {
        this._localLastModified = localLastModified;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

