/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.syncdb.internal;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.IFileLock;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.util.Platform;
import com.tssap.dtr.client.lib.util.PlatformType;
import com.tssap.dtr.client.lib.util.impl.FileOutputStreamSecuredFileLock;
import com.tssap.dtr.client.lib.util.ipc.IpcSecuredFileLock;
import com.tssap.dtr.client.lib.util.persistence.IDepersistFactory;
import com.tssap.dtr.client.lib.util.persistence.IPersistable;
import com.tssap.dtr.client.lib.util.persistence.PersistableContainer;
import com.tssap.dtr.client.lib.util.persistence.RootContainer;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsRuntimeException;
import com.tssap.dtr.client.lib.vfs.fileservice.IFileService;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncDB;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncDBMget;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncEntry;
import com.tssap.dtr.client.lib.vfs.syncdb.internal.ISyncDbChanges;
import com.tssap.dtr.client.lib.vfs.syncdb.internal.LazyJournal;
import com.tssap.dtr.client.lib.vfs.syncdb.internal.SyncDbProperties;
import com.tssap.dtr.client.lib.vfs.syncdb.internal.SyncEntryImpl;
import com.tssap.dtr.client.lib.vfs.syncdb.internal.TouchTimeConsistency;
import com.tssap.dtr.client.lib.vfs.syncdb.internal.mget.SyncDbMget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class SyncDb
extends PersistableContainer
implements ISyncDbChanges,
SyncDB {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$syncdb$internal$SyncDb == null ? (class$com$tssap$dtr$client$lib$vfs$syncdb$internal$SyncDb = SyncDb.class$("com.tssap.dtr.client.lib.vfs.syncdb.internal.SyncDb")) : class$com$tssap$dtr$client$lib$vfs$syncdb$internal$SyncDb));
    private static final short SYNCDB_VERSION = 1;
    private boolean _isOpen;
    private static final String LOCK_SUFFIX = ".lock";
    private static final String SYNCDB_FOLDER = ".syncdbs";
    private static final String SYNCDB_SUFFIX = ".syncdb";
    private static final String MAPPING_SUFFIX = ".xml";
    private static final String NEW_SUFFIX = ".new";
    HashMap _syncDb = new HashMap();
    private IVirtualFile _syncDbFile;
    private ISyncDbChanges _journal;
    private IFileLock _lock;
    private IVirtualFile _syncDbFolder;
    private SyncDbProperties _properties;
    private boolean _hasChanged;
    private static Map _weakSyncDbs = new HashMap();
    private IVirtualFile _configFolder;
    private String _mountPointAbsoluteLocalRoot;
    private int depersistedEntries;
    private SyncDBMget _syncDBMget;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$syncdb$internal$SyncDb;

    protected void finalize() throws Throwable {
        this.close();
    }

    public static synchronized SyncDb open(IVirtualFile configFolder, String mountPointAbsoluteLocalRoot, String serverUrl) {
        String canonicalizedMountPointAbsoluteLocalRoot = PathUtilities.preventTrailingSeparator(mountPointAbsoluteLocalRoot, true);
        WeakReference weakReference = (WeakReference)_weakSyncDbs.get(canonicalizedMountPointAbsoluteLocalRoot);
        if (weakReference == null || weakReference.get() == null) {
            IVirtualFile syncDbFolder = configFolder.getFileService().constructFile(configFolder, SYNCDB_FOLDER);
            SyncDb syncDb = new SyncDb(syncDbFolder, canonicalizedMountPointAbsoluteLocalRoot, serverUrl);
            syncDb._configFolder = configFolder;
            syncDb._mountPointAbsoluteLocalRoot = mountPointAbsoluteLocalRoot;
            syncDb.open();
            _weakSyncDbs.put(canonicalizedMountPointAbsoluteLocalRoot, new WeakReference<SyncDb>(syncDb));
            return syncDb;
        }
        return (SyncDb)weakReference.get();
    }

    public static String getMountPointId(String mountPointAbsoluteLocalRoot) {
        byte[] md5Bytes;
        String canonicalizedMountPointAbsoluteLocalRoot = PathUtilities.preventTrailingSeparator(mountPointAbsoluteLocalRoot, true);
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            md5Bytes = digest.digest(canonicalizedMountPointAbsoluteLocalRoot.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new VfsRuntimeException("Failed to compute mount point ID (" + e.getMessage() + ").", e);
        }
        return Encoder.toHexString((byte[])md5Bytes);
    }

    public SyncDbProperties getProperties() {
        return this._properties;
    }

    private void createInfoFile(IVirtualFile syncDbFolder, String mointPointId, String mountPointAbsoluteLocalRoot, String serverUrl) throws FileNotFoundException {
        IVirtualFile infoFile = this.getFileService().constructFile(syncDbFolder, mointPointId + MAPPING_SUFFIX);
        OutputStream infoOutputStream = this.getFileService().constructFileOutputStream(infoFile);
        PrintWriter printWriter = new PrintWriter(infoOutputStream);
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println("<syncDbInfo");
        printWriter.print("\tid=\"" + mointPointId + "\" ");
        printWriter.print("mountPointAbsoluteLocalRoot=\"" + mountPointAbsoluteLocalRoot + "\" ");
        printWriter.println("serverUrl=\"" + serverUrl + "\"");
        printWriter.println("/>");
        printWriter.close();
    }

    private SyncDb(IVirtualFile syncDbFolder, String canonicalizedMountPointAbsoluteLocalRoot, String serverUrl) {
        this._syncDbFolder = syncDbFolder;
        serverUrl = PathUtilities.preventTrailingSeparator(serverUrl, PathUtilities.REMOTE_FILESERVICE);
        this._properties = new SyncDbProperties(canonicalizedMountPointAbsoluteLocalRoot, serverUrl);
        syncDbFolder.mkdirs();
        String mointPointId = SyncDb.getMountPointId(canonicalizedMountPointAbsoluteLocalRoot);
        try {
            this.createInfoFile(syncDbFolder, mointPointId, canonicalizedMountPointAbsoluteLocalRoot, serverUrl);
        }
        catch (FileNotFoundException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
        this._syncDbFile = this.getFileService().constructFile(syncDbFolder, mointPointId + SYNCDB_SUFFIX);
        this._journal = new LimitedJournal();
    }

    private void depersist() throws VfsException {
        this._journal.onNoMoreChanges();
        LimitedJournal futureJournal = new LimitedJournal();
        this.depersistSyncDb(futureJournal);
        LazyJournal.importAndDeleteJournals(this, futureJournal);
        TouchTimeConsistency.getInstance().correctTouchTimesAfterDepersisting(this);
        this._journal = futureJournal;
    }

    /*
     * Loose catch block
     */
    private void depersistSyncDb(final ISyncDbChanges futureJournal) throws VfsException {
        block11: {
            String METHOD = "depersistSyncDb";
            try {
                IVirtualFile temporaryNewFile = this.getFileService().constructFile(this._syncDbFile.getAbsolutePath() + NEW_SUFFIX);
                this.replaceSyncDbFileWithNewFileIfNecessary(temporaryNewFile);
            }
            catch (IOException e) {
                throw new VfsException("Previous session was not closed correctly and repair did not work - maybe locked file (" + e.getMessage() + ").", e);
            }
            if (!this._syncDbFile.isFile() || this._syncDbFile.length() == 0L) {
                LOCATION.infoT("depersistSyncDb", "SyncDB file ({0}) does not yet exist, creating new SyncDB in memory.", new Object[]{this._syncDbFile});
                return;
            }
            LOCATION.infoT("depersistSyncDb", "Depersisting SyncDB from file ({0}) ...", new Object[]{this._syncDbFile});
            DataInputStream dataInputStream = null;
            dataInputStream = new DataInputStream(this.getFileService().constructFileInputStream(this._syncDbFile));
            IDepersistFactory childrenFactory = new IDepersistFactory(){

                public IPersistable newInstance(String id) {
                    if ("SYNCDB".equals(id)) {
                        return new SyncDb(SyncDb.this._syncDbFolder, SyncDb.this._properties.getMointPointAbsoluteLocalPath(), SyncDb.this._properties.getServerUrl());
                    }
                    if ("SYNCENTRY".equals(id)) {
                        return new SyncEntryImpl(futureJournal, SyncDb.this._properties);
                    }
                    if ("SYNCDB_PROPERTIES".equals(id)) {
                        return new SyncDbProperties(SyncDb.this._properties.getMointPointAbsoluteLocalPath(), SyncDb.this._properties.getServerUrl());
                    }
                    return null;
                }
            };
            SyncDb depersistedSyncDb = (SyncDb)new RootContainer(childrenFactory).depersist(dataInputStream);
            this._syncDb = depersistedSyncDb._syncDb;
            Object var7_8 = null;
            if (dataInputStream == null) break block11;
            try {
                dataInputStream.close();
            }
            catch (IOException e) {
                LOCATION.errorT("depersistSyncDb", "Exception occured: ", new Object[]{e.getMessage()});
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
            dataInputStream = null;
            {
                break block11;
                catch (IOException e) {
                    LOCATION.errorT("depersistSyncDb", "Exception occured: ", new Object[]{e.getMessage()});
                    throw new VfsException("Failed to depersist SyncDB from file " + this._syncDbFile + ".", e);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (dataInputStream != null) {
                    try {
                        dataInputStream.close();
                    }
                    catch (IOException e) {
                        LOCATION.errorT("depersistSyncDb", "Exception occured: ", new Object[]{e.getMessage()});
                        LogUtil.logException((Location)LOCATION, (Throwable)e);
                    }
                    dataInputStream = null;
                }
                throw throwable;
            }
        }
    }

    public void persist() throws IOException {
        if (this._syncDBMget != null) {
            this._syncDBMget.persist();
        }
        String METHOD = "persist";
        if (this._syncDb == null || !this.hasChanged() && this._syncDbFile.exists()) {
            LOCATION.infoT("persist", "Skipped persisting of {0} - no changes made.", new Object[]{this});
            return;
        }
        IVirtualFile newFile = this.getFileService().constructFile(this._syncDbFile.getAbsolutePath() + NEW_SUFFIX);
        IVirtualFile tempFile = this.getFileService().createTempFile("dtr-syncdb", ".tmp", newFile.getParentFile());
        DataOutputStream dataOutputStream = new DataOutputStream(this.getFileService().constructFileOutputStream(tempFile));
        try {
            new RootContainer(this).persist(dataOutputStream);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                dataOutputStream.close();
            }
            catch (IOException e) {
                LOCATION.errorT("persist", "Exception occured when closing file: ", new Object[]{e.getMessage()});
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
            throw throwable;
        }
        try {
            dataOutputStream.close();
        }
        catch (IOException e) {
            LOCATION.errorT("persist", "Exception occured when closing file: ", new Object[]{e.getMessage()});
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
        if (!tempFile.renameTo(newFile)) {
            throw new IOException("Could not rename persisted temp file to \"" + newFile + "\".");
        }
        this.replaceSyncDbFileWithNewFileIfNecessary(newFile);
        this._journal.onDiscardChanges();
        this._hasChanged = false;
    }

    private void replaceSyncDbFileWithNewFileIfNecessary(IVirtualFile newFile) throws IOException {
        String METHOD = "replaceSyncDbFileWithNewFileIfNecessary";
        if (!newFile.exists()) {
            LOCATION.infoT("replaceSyncDbFileWithNewFileIfNecessary", "Ignoring silently: new file {0} does not exist.", new Object[]{newFile});
            return;
        }
        if (this._syncDbFile.exists() && !this._syncDbFile.delete()) {
            String message = "Could not delete original SyncDB file '" + this._syncDbFile.getAbsolutePath() + "'.";
            LOCATION.errorT("replaceSyncDbFileWithNewFileIfNecessary", message);
            throw new IOException(message);
        }
        if (!newFile.renameTo(this._syncDbFile)) {
            String message = "Could not rename new SyncDB file '" + newFile.getAbsolutePath() + "' to actual name '" + this._syncDbFile.getAbsolutePath() + "'.";
            LOCATION.errorT("replaceSyncDbFileWithNewFileIfNecessary", message);
            throw new IOException(message);
        }
        this._syncDbFile.setReadOnly();
    }

    private IFileService getFileService() {
        return this._syncDbFolder.getFileService();
    }

    public void onChangeEntry(SyncEntryImpl syncEntry) {
        this._hasChanged = true;
        String METHOD = "onChangeEntry";
        SyncEntryImpl formerEntry = (SyncEntryImpl)this.getEntry(syncEntry.getAbsoluteLocalPath());
        if (formerEntry == null) {
            LOCATION.warningT("onChangeEntry", "+ Expected sync entry does not exist - creating {0}.", new Object[]{syncEntry});
        } else {
            if (formerEntry.getLocalLastModified() > syncEntry.getLocalLastModified()) {
                LOCATION.errorT("onChangeEntry", "Current entry ({0}) is newer than entry to update ({1}) - discarding journaled entry.", new Object[]{formerEntry, syncEntry});
                return;
            }
            LOCATION.debugT("onChangeEntry", "+ Updating {0}", new Object[]{syncEntry});
        }
        this.put(syncEntry);
    }

    private void put(SyncEntryImpl syncEntry) {
        this._syncDb.put(syncEntry.getMountPointRelativeLocalPath(), syncEntry);
    }

    public void onCreateEntry(SyncEntryImpl syncEntry) {
        this._hasChanged = true;
        String METHOD = "onCreateEntry";
        SyncEntryImpl formerEntry = (SyncEntryImpl)this.getEntry(syncEntry.getAbsoluteLocalPath());
        if (formerEntry != null) {
            if (formerEntry.getLocalLastModified() > syncEntry.getLocalLastModified()) {
                LOCATION.errorT("onCreateEntry", "+ Sync entry already exists ({0}) and is newer then entry to update ({1}) - discarding journaled entry.", new Object[]{formerEntry, syncEntry});
                return;
            }
            LOCATION.warningT("onCreateEntry", "+ Older sync entry already exists - updating {0}.", new Object[]{syncEntry});
        } else {
            LOCATION.debugT("onCreateEntry", "+ Creating {0}", new Object[]{syncEntry});
        }
        this.put(syncEntry);
    }

    public void onDeleteEntry(String localPath) {
        this._hasChanged = true;
        String METHOD = "onDeleteEntry";
        if (this._syncDb.remove(localPath) == null) {
            LOCATION.warningT("onDeleteEntry", "+ Sync entry for ''{0}'' does not exist - ignoring.", new Object[]{localPath});
        } else {
            LOCATION.debugT("onDeleteEntry", "+ Deleting sync entry for ''{0}''.", new Object[]{localPath});
        }
    }

    public void onNoMoreChanges() {
        throw new UnsupportedOperationException("Unexpected call as SyncDb implements ISyncDbChanges only for depersisting.");
    }

    public void onDiscardChanges() {
        throw new UnsupportedOperationException("Deletion of SyncDB must be done with explicit delete() method!");
    }

    public void setRecordChanges(boolean record) {
        throw new UnsupportedOperationException();
    }

    public boolean hasChanged() {
        return this._hasChanged || this._journal.hasChanged();
    }

    public String getId() {
        return "SYNCDB";
    }

    protected void onNextChild(IPersistable child) {
        String METHOD = "onNextChild";
        if (child instanceof SyncEntryImpl) {
            SyncEntryImpl syncEntry = (SyncEntryImpl)child;
            LOCATION.debugT("onNextChild", "+ Updated SyncDB with {0}.", new Object[]{syncEntry});
            this.put(syncEntry);
            ++this.depersistedEntries;
        } else if (!(child instanceof SyncDbProperties)) {
            LOCATION.warningT("onNextChild", "+ Skipping unknown child ''{0}''.", new Object[]{child});
        }
    }

    public IPersistable depersist(DataInputStream dataInputStream, IDepersistFactory childrenFactory) throws IOException {
        IPersistable iPersistable;
        String METHOD = "depersist";
        LOCATION.entering("depersist");
        long start = System.currentTimeMillis();
        try {
            LOCATION.infoT("depersist", "Depersisting {0} ...", new Object[]{this});
            byte version = dataInputStream.readByte();
            if (version != 1) {
                throw new IllegalStateException("Unsupported sync DB format (" + version + "), get latest DTR client.");
            }
            LOCATION.pathT("depersist", "depersisting children ...");
            this.depersistedEntries = 0;
            iPersistable = super.depersist(dataInputStream, childrenFactory);
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            long end = System.currentTimeMillis();
            LOCATION.infoT("depersist", "Depersisted {0} entries in {1} ms.", new Object[]{new Integer(this.depersistedEntries), new Long(end - start)});
            LOCATION.exiting();
            throw throwable;
        }
        long end = System.currentTimeMillis();
        LOCATION.infoT("depersist", "Depersisted {0} entries in {1} ms.", new Object[]{new Integer(this.depersistedEntries), new Long(end - start)});
        LOCATION.exiting();
        return iPersistable;
    }

    public void persist(DataOutputStream dataOutputStream) throws IOException {
        String METHOD = "persist";
        LOCATION.entering("persist");
        long start = System.currentTimeMillis();
        try {
            LOCATION.infoT("persist", "Persisting {0} ...", new Object[]{this});
            dataOutputStream.writeByte(1);
            this.persistChild(dataOutputStream, this._properties);
            LOCATION.pathT("persist", "Persisting children ...");
            long sortStart = System.currentTimeMillis();
            TreeSet sortedSet = new TreeSet(this._syncDb.keySet());
            long sortEnd = System.currentTimeMillis();
            LOCATION.infoT("persist", "Sorting took {0} ms.", new Object[]{new Long(sortEnd - sortStart)});
            Iterator iterator = sortedSet.iterator();
            while (iterator.hasNext()) {
                String path = (String)iterator.next();
                SyncEntryImpl syncEntry = (SyncEntryImpl)this._syncDb.get(path);
                this.persistChild(dataOutputStream, syncEntry);
            }
            this.persistNoMoreChildren(dataOutputStream);
            Object var14_10 = null;
        }
        catch (Throwable throwable) {
            Object var14_11 = null;
            long end = System.currentTimeMillis();
            LOCATION.infoT("persist", "Persisted {0} entries in {1} ms.", new Object[]{new Integer(this._syncDb.size()), new Long(end - start)});
            LOCATION.exiting();
            throw throwable;
        }
        long end = System.currentTimeMillis();
        LOCATION.infoT("persist", "Persisted {0} entries in {1} ms.", new Object[]{new Integer(this._syncDb.size()), new Long(end - start)});
        LOCATION.exiting();
    }

    public SyncEntry createEntry(String absoluteLocalPath, String objectId) {
        this.open();
        String METHOD = "createEntry";
        String mountPointRelativeLocalPath = this.canonicalizeResourcePath(absoluteLocalPath);
        SyncEntryImpl syncEntry = (SyncEntryImpl)this._syncDb.get(mountPointRelativeLocalPath);
        if (syncEntry != null) {
            LOCATION.warningT("createEntry", "+ {0} already exists - returning existing.", new Object[]{syncEntry});
            return syncEntry;
        }
        syncEntry = new SyncEntryImpl(this._journal, this._properties, mountPointRelativeLocalPath, objectId);
        this._syncDb.put(mountPointRelativeLocalPath, syncEntry);
        LOCATION.debugT("createEntry", "+ Created {0}.", new Object[]{syncEntry});
        this._journal.onCreateEntry(syncEntry);
        return syncEntry;
    }

    public SyncEntry getEntry(String localPath) {
        this.open();
        localPath = this.canonicalizeResourcePath(localPath);
        return (SyncEntry)this._syncDb.get(localPath);
    }

    public void removeEntry(String localPath) {
        String METHOD = "removeEntry";
        this.open();
        localPath = this.canonicalizeResourcePath(localPath);
        Object syncEntry = this._syncDb.remove(localPath);
        if (syncEntry == null) {
            LOCATION.warningT("removeEntry", "Ignoring try to remove not existing sync entry for {0}.", new Object[]{localPath});
        } else {
            LOCATION.debugT("removeEntry", "+ Removed {0}", new Object[]{syncEntry});
        }
        this._journal.onDeleteEntry(localPath);
    }

    private String canonicalizeResourcePath(String absoluteLocalPath) {
        String mointPointAbsoluteLocalPath = this._properties.getMointPointAbsoluteLocalPath();
        if (!absoluteLocalPath.startsWith(mointPointAbsoluteLocalPath)) {
            throw new VfsRuntimeException("Given absoluteLocalPath \"" + absoluteLocalPath + "\" doesn't start with mointPointAbsoluteLocalRoot \"" + mointPointAbsoluteLocalPath + "\"");
        }
        return PathUtilities.preventTrailingSeparator(absoluteLocalPath.substring(mointPointAbsoluteLocalPath.length()), this._syncDbFolder.getFileService());
    }

    IVirtualFile getSyncDbFile() {
        return this._syncDbFile;
    }

    public boolean isEqual(SyncDb second) {
        Iterator firstEntries = this._syncDb.entrySet().iterator();
        while (firstEntries.hasNext()) {
            Map.Entry firstEntry = firstEntries.next();
            SyncEntryImpl secondValue = (SyncEntryImpl)second._syncDb.get(firstEntry.getKey());
            if (secondValue == null) {
                return false;
            }
            SyncEntryImpl firstValue = (SyncEntryImpl)firstEntry.getValue();
            if (secondValue.isEqual(firstValue)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this._syncDbFile != null) {
            return "SyncDB[" + this._syncDbFile + "]";
        }
        return "SyncDB[unknown stream]";
    }

    public void close() throws IOException {
        if (this._syncDBMget != null) {
            this._syncDBMget.close();
        }
        if (!this._isOpen) {
            return;
        }
        String METHOD = "close";
        LOCATION.infoT("close", "Closing SyncDB ({0}) ...", new Object[]{this._syncDbFile.getAbsolutePath()});
        this.persist();
        this._lock.release();
        this._lock = null;
        _weakSyncDbs.remove(this._properties.getMointPointAbsoluteLocalPath());
        this._syncDb = null;
        this._isOpen = false;
    }

    public boolean delete() {
        if (this._syncDBMget != null) {
            this._syncDBMget.delete();
        }
        try {
            this.close();
        }
        catch (IOException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
        String METHOD = "delete";
        LOCATION.infoT("delete", "Deleting SyncDB file ({0}).", new Object[]{this._syncDbFile.getAbsolutePath()});
        return this._syncDbFile.delete();
    }

    public void open() throws VfsRuntimeException {
        if (this._isOpen) {
            return;
        }
        this.getSyncDbMget();
        String METHOD = "open";
        LOCATION.infoT("open", "Opening SyncDB ({0}) ...", new Object[]{this._syncDbFile});
        IVirtualFile lockFile = this.getFileService().constructFile(this._syncDbFile.getAbsolutePath() + LOCK_SUFFIX);
        try {
            this._lock = new IpcSecuredFileLock(lockFile);
        }
        catch (IllegalStateException e1) {
            if (Platform.getPlatform().getPlatformType().equals(PlatformType.WINDOWS)) {
                this._lock = new FileOutputStreamSecuredFileLock(lockFile);
            }
            throw e1;
        }
        this._isOpen = true;
        try {
            this.depersist();
        }
        catch (VfsException e) {
            throw new VfsRuntimeException("Failed to depersist SyncDB " + this._syncDbFile + ".", e);
        }
    }

    public Iterator resourcePaths() {
        return new Iterator(){
            private Iterator _internalIterator;
            {
                this._internalIterator = Collections.unmodifiableSet(SyncDb.this._syncDb.keySet()).iterator();
            }

            public boolean hasNext() {
                return this._internalIterator.hasNext();
            }

            public Object next() {
                return SyncDb.this._properties.getMointPointAbsoluteLocalPath() + this._internalIterator.next();
            }

            public void remove() {
                this._internalIterator.remove();
            }
        };
    }

    public SyncDBMget getSyncDbMget() {
        if (this._syncDBMget == null) {
            this._syncDBMget = SyncDbMget.open(this._configFolder, this._mountPointAbsoluteLocalRoot);
        }
        return this._syncDBMget;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ IVirtualFile access$000(SyncDb x0) {
        return x0._syncDbFile;
    }

    static /* synthetic */ IFileService access$100(SyncDb x0) {
        return x0.getFileService();
    }

    class LimitedJournal
    implements ISyncDbChanges {
        private final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$syncdb$internal$SyncDb$LimitedJournal == null ? (class$com$tssap$dtr$client$lib$vfs$syncdb$internal$SyncDb$LimitedJournal = LimitedJournal.class$("com.tssap.dtr.client.lib.vfs.syncdb.internal.SyncDb$LimitedJournal")) : class$com$tssap$dtr$client$lib$vfs$syncdb$internal$SyncDb$LimitedJournal));
        ISyncDbChanges _journal = new LazyJournal(SyncDb.access$100(SyncDb.this).constructFile(SyncDb.access$000(SyncDb.this).getAbsolutePath() + "." + System.currentTimeMillis() + ".journal"));
        private int _entriesJournaled;
        private static final int MAX_ENTRIES_PER_JOURNAL = 16384;
        private boolean _recordChanges = true;
        private boolean _hasChanged;
        static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$syncdb$internal$SyncDb$LimitedJournal;

        LimitedJournal() {
        }

        private void changed() {
            this._hasChanged = true;
        }

        private void entryDone() {
            if (++this._entriesJournaled % 16384 == 0) {
                String METHOD = "entryDone";
                this.LOCATION.infoT("entryDone", "Maximum number of entries in journal reached ({0}), persisting SyncDB and deleting journal file.", new Object[]{new Integer(this._entriesJournaled)});
                try {
                    SyncDb.this.persist();
                    this._entriesJournaled = 0;
                }
                catch (IOException e) {
                    LogUtil.logException((Location)this.LOCATION, (Throwable)e);
                    this.LOCATION.errorT("entryDone", "Persisting failed, leaving journal open for another 16384 entries.");
                }
            }
        }

        public void onChangeEntry(SyncEntryImpl syncEntry) {
            this.changed();
            if (this._recordChanges) {
                this._journal.onChangeEntry(syncEntry);
                this.entryDone();
            }
        }

        public void onCreateEntry(SyncEntryImpl syncEntry) {
            this.changed();
            if (this._recordChanges) {
                this._journal.onCreateEntry(syncEntry);
                this.entryDone();
            }
        }

        public void onDeleteEntry(String localPath) {
            this.changed();
            if (this._recordChanges) {
                this._journal.onDeleteEntry(localPath);
                this.entryDone();
            }
        }

        public void onNoMoreChanges() {
            this._journal.onNoMoreChanges();
        }

        public void onDiscardChanges() {
            this._journal.onDiscardChanges();
            this._hasChanged = false;
        }

        public void setRecordChanges(boolean record) {
            this._recordChanges = record;
        }

        public boolean hasChanged() {
            return this._hasChanged;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

