/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.syncdb.internal;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.persistence.IDepersistFactory;
import com.tssap.dtr.client.lib.util.persistence.IPersistable;
import com.tssap.dtr.client.lib.util.persistence.PersistableContainer;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsRuntimeException;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.syncdb.internal.IJournalEntry;
import com.tssap.dtr.client.lib.vfs.syncdb.internal.ISyncDbChanges;
import com.tssap.dtr.client.lib.vfs.syncdb.internal.SyncDb;
import com.tssap.dtr.client.lib.vfs.syncdb.internal.SyncEntryChanged;
import com.tssap.dtr.client.lib.vfs.syncdb.internal.SyncEntryCreated;
import com.tssap.dtr.client.lib.vfs.syncdb.internal.SyncEntryDeleted;
import com.tssap.dtr.client.lib.vfs.syncdb.internal.SyncEntryImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;

class LazyJournal
extends PersistableContainer
implements ISyncDbChanges {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$syncdb$internal$LazyJournal == null ? (class$com$tssap$dtr$client$lib$vfs$syncdb$internal$LazyJournal = LazyJournal.class$("com.tssap.dtr.client.lib.vfs.syncdb.internal.LazyJournal")) : class$com$tssap$dtr$client$lib$vfs$syncdb$internal$LazyJournal));
    private ISyncDbChanges _syncDbToUpdate;
    private DataOutputStream _dataOutputStream;
    private static final byte SYNCDB_JOURNAL_VERSION = 1;
    static final String JOURNAL_SUFFIX = ".journal";
    private static final String SYNCDBJOURNAL_ID = "SYNCDBJOURNAL";
    private IVirtualFile _journalFile;
    private boolean _recordChanges = true;
    private boolean _hasChanged;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$syncdb$internal$LazyJournal;

    public String getId() {
        return SYNCDBJOURNAL_ID;
    }

    public void persist(DataOutputStream dataOutputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void changed() {
        this._hasChanged = true;
    }

    public void onChangeEntry(SyncEntryImpl syncEntry) {
        this.changed();
        if (!this._recordChanges) {
            return;
        }
        SyncEntryChanged changed = new SyncEntryChanged(syncEntry);
        try {
            this.openJournal();
            this.persistChild(this._dataOutputStream, changed);
            this._dataOutputStream.flush();
        }
        catch (IOException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void onCreateEntry(SyncEntryImpl syncEntry) {
        this.changed();
        if (!this._recordChanges) {
            return;
        }
        SyncEntryCreated created = new SyncEntryCreated(syncEntry);
        try {
            this.openJournal();
            this.persistChild(this._dataOutputStream, created);
            this._dataOutputStream.flush();
        }
        catch (IOException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void onDeleteEntry(String localPath) {
        this.changed();
        if (!this._recordChanges) {
            return;
        }
        SyncEntryDeleted deleted = new SyncEntryDeleted(localPath);
        try {
            this.openJournal();
            this.persistChild(this._dataOutputStream, deleted);
            this._dataOutputStream.flush();
        }
        catch (IOException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void onNoMoreChanges() {
        try {
            this.close();
        }
        catch (IOException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
    }

    public void onDiscardChanges() {
        if (this._journalFile != null) {
            try {
                if (this._dataOutputStream != null) {
                    this._dataOutputStream.close();
                    this._dataOutputStream = null;
                }
            }
            catch (IOException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
            if (this._journalFile.exists() && !this._journalFile.delete()) {
                throw new VfsRuntimeException("Could not delete journal file (" + this._journalFile.getAbsolutePath() + ")");
            }
        }
        this._hasChanged = false;
    }

    public void setRecordChanges(boolean record) {
        this._recordChanges = record;
    }

    public boolean hasChanged() {
        return this._hasChanged;
    }

    LazyJournal(ISyncDbChanges syncDb) {
        this._syncDbToUpdate = syncDb;
    }

    LazyJournal(IVirtualFile journalFile) {
        this._journalFile = journalFile;
    }

    private void openJournal() throws IOException {
        if (this._dataOutputStream == null) {
            String METHOD = "openJournal";
            LOCATION.infoT("openJournal", "Creating {0}", new Object[]{this});
            this._journalFile.getParentFile().mkdirs();
            OutputStream outputStream = this._journalFile.getFileService().constructFileOutputStream(this._journalFile);
            this._dataOutputStream = new DataOutputStream(outputStream);
            this._dataOutputStream.writeUTF(SYNCDBJOURNAL_ID);
            this._dataOutputStream.writeByte(1);
        }
    }

    void close() throws IOException {
        if (this._dataOutputStream != null) {
            this._dataOutputStream.close();
        }
        this._dataOutputStream = null;
    }

    boolean delete() {
        try {
            this.close();
        }
        catch (IOException e) {
            String METHOD = "delete";
            LOCATION.errorT("delete", "Exception occured at deleting a journal when closing the stream: {0}", new Object[]{e.getMessage()});
        }
        return this._journalFile.delete();
    }

    public IPersistable depersist(DataInputStream dataInputStream, IDepersistFactory childrenFactory) throws IOException {
        byte version = dataInputStream.readByte();
        if (version != 1) {
            throw new StreamCorruptedException("Unknown journal version " + version + " (expected " + 1 + ").");
        }
        return super.depersist(dataInputStream, childrenFactory);
    }

    protected void onNextChild(IPersistable child) {
        if (!(child instanceof IJournalEntry)) {
            throw new IllegalStateException();
        }
        IJournalEntry journalEntry = (IJournalEntry)child;
        journalEntry.updateSyncDb(this._syncDbToUpdate);
    }

    public String toString() {
        return "LazyJournal[" + this._journalFile + "]";
    }

    private static Collection getJournalFiles(IVirtualFile syncDbFile) {
        IVirtualFile[] files = syncDbFile.getParentFile().listFiles();
        TreeSet<IVirtualFile> journalFiles = new TreeSet<IVirtualFile>();
        int i = 0;
        while (i < files.length) {
            IVirtualFile file = files[i];
            if (file.getName().startsWith(syncDbFile.getName()) && file.getName().endsWith(JOURNAL_SUFFIX)) {
                journalFiles.add(file);
            }
            ++i;
        }
        return journalFiles;
    }

    static void importAndDeleteJournals(SyncDb syncDb, ISyncDbChanges futureJournal) throws VfsException {
        Collection journalFiles = LazyJournal.getJournalFiles(syncDb.getSyncDbFile());
        Iterator iterator = journalFiles.iterator();
        while (iterator.hasNext()) {
            LazyJournal.importAndDeleteJournalFile((IVirtualFile)iterator.next(), syncDb, futureJournal);
        }
    }

    /*
     * Loose catch block
     */
    private static void importAndDeleteJournalFile(IVirtualFile journalFile, final SyncDb syncDb, final ISyncDbChanges futureJournal) throws VfsException {
        block24: {
            IOException e222;
            boolean successfullyDepersisted;
            DataInputStream dataInputStream;
            block22: {
                String METHOD = "importAndDeleteJournalFile";
                LOCATION.infoT("importAndDeleteJournalFile", "Importing journal ''{0}'' ...", new Object[]{journalFile});
                dataInputStream = null;
                successfullyDepersisted = false;
                dataInputStream = new DataInputStream(journalFile.getFileService().constructFileInputStream(journalFile));
                LazyJournal journalToImport = new LazyJournal(syncDb);
                String id = dataInputStream.readUTF();
                if (!journalToImport.getId().equals(id)) {
                    throw new StreamCorruptedException("Wrong ID: found " + id + " (expected " + journalToImport.getId() + ")");
                }
                IDepersistFactory childrenFactory = new IDepersistFactory(){

                    public IPersistable newInstance(String id) {
                        if ("SYNCENTRY".equals(id)) {
                            return new SyncEntryImpl(futureJournal, syncDb.getProperties());
                        }
                        if ("CREATED".equals(id)) {
                            return new SyncEntryCreated();
                        }
                        if ("CHANGED".equals(id)) {
                            return new SyncEntryChanged();
                        }
                        if ("DELETED".equals(id)) {
                            return new SyncEntryDeleted();
                        }
                        return null;
                    }
                };
                journalToImport.depersist(dataInputStream, childrenFactory);
                Object var10_11 = null;
                if (dataInputStream == null) break block22;
                try {
                    dataInputStream.close();
                }
                catch (IOException e222) {
                    LOCATION.errorT("importAndDeleteJournalFile", "Exception occured at importing a journal {0} when closing the stream: {1}", new Object[]{journalFile, e222.getMessage()});
                }
                dataInputStream = null;
            }
            if (successfullyDepersisted) {
                try {
                    syncDb.persist();
                    LOCATION.infoT("importAndDeleteJournalFile", "Deleting imported journal ''{0}''.", new Object[]{journalFile});
                    if (!journalFile.delete()) {
                        LOCATION.errorT("importAndDeleteJournalFile", "Failed to delete imported journal ''{0}''.", new Object[]{journalFile});
                        throw new VfsException("Failed to delete unjournaled file " + journalFile + ".");
                    }
                    break block24;
                }
                catch (IOException e222) {
                    LOCATION.errorT("importAndDeleteJournalFile", "Exception occured: ", new Object[]{e222.getMessage()});
                    throw new VfsException("Persisting SyncDB failed (after unjournaling " + journalFile + ").", e222);
                }
            }
            LOCATION.warningT("importAndDeleteJournalFile", "Problem occurred during importing journal ''{0}''.", new Object[]{journalFile});
            {
                break block24;
                catch (EOFException e3) {
                    IOException e222;
                    successfullyDepersisted = true;
                    Object var10_12 = null;
                    if (dataInputStream != null) {
                        try {
                            dataInputStream.close();
                        }
                        catch (IOException e222) {
                            LOCATION.errorT("importAndDeleteJournalFile", "Exception occured at importing a journal {0} when closing the stream: {1}", new Object[]{journalFile, e222.getMessage()});
                        }
                        dataInputStream = null;
                    }
                    if (successfullyDepersisted) {
                        try {
                            syncDb.persist();
                            LOCATION.infoT("importAndDeleteJournalFile", "Deleting imported journal ''{0}''.", new Object[]{journalFile});
                            if (!journalFile.delete()) {
                                LOCATION.errorT("importAndDeleteJournalFile", "Failed to delete imported journal ''{0}''.", new Object[]{journalFile});
                                throw new VfsException("Failed to delete unjournaled file " + journalFile + ".");
                            }
                            break block24;
                        }
                        catch (IOException e222) {
                            LOCATION.errorT("importAndDeleteJournalFile", "Exception occured: ", new Object[]{e222.getMessage()});
                            throw new VfsException("Persisting SyncDB failed (after unjournaling " + journalFile + ").", e222);
                        }
                    }
                    LOCATION.warningT("importAndDeleteJournalFile", "Problem occurred during importing journal ''{0}''.", new Object[]{journalFile});
                    break block24;
                }
                catch (IOException e4) {
                    LOCATION.errorT("importAndDeleteJournalFile", "Exception occured: {0}", new Object[]{e4.getMessage()});
                    throw new VfsException("Failed to unjournal file " + journalFile + ".", e4);
                }
            }
            catch (Throwable throwable) {
                block26: {
                    IOException e222;
                    Object var10_13 = null;
                    if (dataInputStream != null) {
                        try {
                            dataInputStream.close();
                        }
                        catch (IOException e222) {
                            LOCATION.errorT("importAndDeleteJournalFile", "Exception occured at importing a journal {0} when closing the stream: {1}", new Object[]{journalFile, e222.getMessage()});
                        }
                        dataInputStream = null;
                    }
                    if (successfullyDepersisted) {
                        try {
                            syncDb.persist();
                            LOCATION.infoT("importAndDeleteJournalFile", "Deleting imported journal ''{0}''.", new Object[]{journalFile});
                            if (!journalFile.delete()) {
                                LOCATION.errorT("importAndDeleteJournalFile", "Failed to delete imported journal ''{0}''.", new Object[]{journalFile});
                                throw new VfsException("Failed to delete unjournaled file " + journalFile + ".");
                            }
                            break block26;
                        }
                        catch (IOException e222) {
                            LOCATION.errorT("importAndDeleteJournalFile", "Exception occured: ", new Object[]{e222.getMessage()});
                            throw new VfsException("Persisting SyncDB failed (after unjournaling " + journalFile + ").", e222);
                        }
                    }
                    LOCATION.warningT("importAndDeleteJournalFile", "Problem occurred during importing journal ''{0}''.", new Object[]{journalFile});
                }
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

