/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import java.io.IOException;

class WrongCaseOfFolderPathUtil {
    WrongCaseOfFolderPathUtil() {
    }

    static void rememberWrongCaseOfFolderPathAfterLocalWrite(IVfsContext context, IVirtualFile file) {
        if (file.isFile()) {
            file = file.getParentFile();
        }
        try {
            String canonicalPath = file.getCanonicalPath();
            String mountedPath = file.getAbsolutePath();
            if (!canonicalPath.equals(mountedPath)) {
                context.storeWrongAbsoluteLocalFolderpath(canonicalPath, mountedPath);
            }
        }
        catch (IOException e) {
            new VfsException("Could not get canonical path for " + file.getAbsolutePath(), e);
        }
    }

    static String getResolvedAbsoluteLocalPath(IVfsContext context, IVirtualFile virtualFile) throws VfsException {
        String correctLocalFolderPath;
        String absoluteLocalPath = null;
        try {
            absoluteLocalPath = virtualFile.getCanonicalPath();
        }
        catch (IOException x) {
            throw new VfsException("Could not get canonical filename for '" + absoluteLocalPath + "'", x);
        }
        if (!virtualFile.exists()) {
            return absoluteLocalPath;
        }
        String folderPath = absoluteLocalPath;
        if (virtualFile.isFile()) {
            try {
                folderPath = virtualFile.getParentFile().getCanonicalPath();
            }
            catch (IOException e) {
                throw new VfsException("Could not get canonical filename.", e);
            }
        }
        if ((correctLocalFolderPath = context.resolveWrongAbsoluteLocalFolderpath(folderPath)) != null) {
            absoluteLocalPath = correctLocalFolderPath + virtualFile.getFileService().getSeparatorChar() + virtualFile.getName();
        }
        return absoluteLocalPath;
    }
}

