/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.ICollection;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IWorkspace;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.PropertyFactoryAccess;
import com.tssap.dtr.client.lib.deltavlib.factory.ResourceFactoryManager;
import com.tssap.dtr.client.lib.deltavlib.properties.IMutableProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspaceFolder;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemCategory;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.impl.FolderItemCache;
import com.tssap.dtr.client.lib.vfs.impl.FolderUtil;
import com.tssap.dtr.client.lib.vfs.impl.Util;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.impl.VfsRepository;
import com.tssap.dtr.client.lib.vfs.impl.VfsRootFolder;
import com.tssap.dtr.client.lib.vfs.impl.VfsXcmProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

class VfsWorkspaceFolder
extends VfsFolderItem
implements IVfsWorkspaceFolder {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$VfsWorkspaceFolder == null ? (class$com$tssap$dtr$client$lib$vfs$impl$VfsWorkspaceFolder = VfsWorkspaceFolder.class$("com.tssap.dtr.client.lib.vfs.impl.VfsWorkspaceFolder")) : class$com$tssap$dtr$client$lib$vfs$impl$VfsWorkspaceFolder));
    private VersionedFileSystemManager m_vfsManager = null;
    IVfsFolderItem[] m_folderItems = IVfsFolderItem.NO_ITEMS;
    IVfsContext m_context;
    static final boolean USE_FOLDER_ITEM_CACHE = true;
    static final boolean NOT_USE_FOLDER_ITEM_CACHE = false;
    static final boolean TOP_LEVEL_ROOT = true;
    static final boolean NOT_TOP_LEVEL_ROOT = false;
    boolean m_isRefreshedOnce = false;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$VfsWorkspaceFolder;

    VfsWorkspaceFolder(VersionedFileSystemManager vfsManager, IResource resource, IVirtualFile localFile) {
        super(resource, localFile);
        this.m_vfsManager = vfsManager;
        this.m_context = vfsManager.getCurrentContext();
        this.m_locationState = !this.isMounted() ? VfsFolderItemLocationState.NOT_MOUNTED : (this.m_localFile.exists() && this.m_dvVcr == null ? VfsFolderItemLocationState.LOCAL_ONLY : (!this.m_localFile.exists() && this.m_dvVcr != null ? VfsFolderItemLocationState.SERVER_ONLY : VfsFolderItemLocationState.MOUNTED));
    }

    static VfsWorkspaceFolder getVfsWorkspaceFolder(VersionedFileSystemManager vfsManager, IResource dvResource, IVirtualFile localFolder) throws VfsException {
        if (vfsManager == null || dvResource == null || localFolder == null) {
            String msg = "Internal error: factory method call with null dvResource";
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.ERROR_LOG, localFolder.getAbsolutePath(), msg);
            throw new VfsException(msg);
        }
        if (dvResource == VfsFolderItem.NULL_DELTAV_RESOURCE || dvResource == VfsFolderItem.KEEP_DELTAV_RESOURCE) {
            String msg = "Internal error: factory method call with null dvResource";
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.ERROR_LOG, localFolder.getAbsolutePath(), msg);
            throw new VfsException(msg);
        }
        try {
            if (!dvResource.isCollection() || dvResource.getAsCollection().isWorkspace() || dvResource.isVersioned()) {
                String msg = "Internal error: invalid DeltaV resource given for creation of workspace folder";
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.ERROR_LOG, localFolder.getAbsolutePath(), msg);
                throw new VfsException(msg);
            }
        }
        catch (VcmFailure vcmFailure) {
            String msg = "Get category (versioned, collection, ...) of DeltaV resource failed";
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.ERROR_LOG, localFolder.getAbsolutePath(), msg);
            throw new VfsException(msg, vcmFailure);
        }
        try {
            VfsFolderItem.checkIsVisible(vfsManager.getCurrentContext(), new VfsRemoteLocator(dvResource.getConnectionTemplID(), dvResource.getDecodedPath(), dvResource.getDecodedPath()), dvResource.getName());
        }
        catch (VfsException e) {
            Logbook.getInfoChapter(2).println(e.getMessage());
            return null;
        }
        if (localFolder != VfsFolderItem.NULL_LOCAL_FILE && localFolder != VfsFolderItem.KEEP_LOCAL_FILE && localFolder.isFile()) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.ERROR_LOG, localFolder.getAbsolutePath(), "Name clash between local file and remote workspace folder");
            throw new VfsException("Name clash between local file and remote workspace folder: " + localFolder.getAbsolutePath());
        }
        VfsFolderItemCategory folderItemCategory = null;
        boolean topLevelRoot = true;
        if (folderItemCategory == null) {
            IVfsRemoteLocator[] browseRoots = vfsManager.getCurrentContext().getBrowseRootRemoteLocators();
            ArrayList<IVfsRemoteLocator> foundBrowseRoots = new ArrayList<IVfsRemoteLocator>();
            int i = 0;
            while (i < browseRoots.length) {
                IVfsRemoteLocator browseRoot = browseRoots[i];
                if (dvResource.getDecodedPath().equals(browseRoot.getAbsoluteRemotePath())) {
                    foundBrowseRoots.add(browseRoot);
                }
                ++i;
            }
            if (foundBrowseRoots.size() == 1) {
                folderItemCategory = VfsFolderItemCategory.ROOT;
            } else if (foundBrowseRoots.isEmpty()) {
                folderItemCategory = VfsFolderItemCategory.WORKSPACE_FOLDER;
            } else {
                throw new VfsException("Internal error: Ambiguous root folders are still not supported");
            }
        }
        VfsWorkspaceFolder folderItem = null;
        folderItem = folderItemCategory == VfsFolderItemCategory.WORKSPACE_FOLDER ? VfsWorkspaceFolder.pureUnsecuredGetVfsWorkspaceFolder(vfsManager, dvResource, localFolder, true) : VfsRootFolder.pureUnsecuredGetVfsRootFolder(vfsManager, dvResource, localFolder, topLevelRoot, true);
        return folderItem;
    }

    static VfsWorkspaceFolder pureUnsecuredGetVfsWorkspaceFolder(VersionedFileSystemManager vfsManager, IResource dvResource, IVirtualFile localFile, boolean useFolderItemCache) throws VfsException {
        VfsFolderItem folderItem = null;
        if (useFolderItemCache) {
            FolderItemCache folderItemCache = vfsManager.getFolderItemCache();
            String absoluteLocalPath = VfsFolderItem.getAbsoluteLocalPath(localFile, dvResource, vfsManager.getCurrentContext(), VfsFolderItemCategory.WORKSPACE_FOLDER);
            if (absoluteLocalPath != null) {
                folderItem = folderItemCache.getFolderItemWithLocalPath(absoluteLocalPath);
            }
            if (folderItem != null) {
                VfsFolderItem.checkAndAdaptCachedFolderItem(folderItem, dvResource, absoluteLocalPath, VfsFolderItemCategory.WORKSPACE_FOLDER);
            }
            if (folderItem == null) {
                if (localFile == VfsFolderItem.KEEP_LOCAL_FILE) {
                    localFile = absoluteLocalPath != null ? vfsManager.getCurrentContext().getFileService().constructFile(absoluteLocalPath) : VfsFolderItem.NULL_LOCAL_FILE;
                }
                folderItem = new VfsWorkspaceFolder(vfsManager, dvResource, localFile);
                try {
                    boolean doOverwrite = true;
                    folderItemCache.addFolderItem(folderItem, doOverwrite);
                }
                catch (VfsException e) {
                    String msg = "Internal error: Add file to cache failed";
                    VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.ERROR_LOG, folderItem, msg);
                    throw new VfsException(msg, e);
                }
            }
        } else {
            folderItem = new VfsWorkspaceFolder(vfsManager, dvResource, localFile);
        }
        return (VfsWorkspaceFolder)folderItem.asWorkspaceFolder();
    }

    public IVfsContext getContext() {
        this.getVfsManager().checkState();
        return this.m_context;
    }

    IVfsWorkspace getWorkspace() {
        return null;
    }

    public VfsActionOnFolderItem[] getActionsForCurrentState() {
        this.getVfsManager().checkState();
        return this.getVfsManager().getAllowedActionsFeature().getAllowedActionsForCurrentState(this);
    }

    public void removeFromClient() throws VfsException {
        this.getVfsManager().checkState();
        this.getVfsManager().getSyncRemoveFeature().removeFromClient(this);
    }

    public IVfsFolderItem[] refreshFolderItems() throws VfsException {
        this.getVfsManager().checkState();
        VersionedFileSystemManager manager = (VersionedFileSystemManager)VersionedFileSystemManager.getVersionedFileSystemManager(this.m_context);
        ICollection dvWorkspaceFolder = null;
        try {
            dvWorkspaceFolder = this.m_dvVcr.getAsCollection();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Internal error: invalid DeltaV resource for workspace folder(" + vcmFailure.getMessage() + ")", vcmFailure);
        }
        IResource[] dvResources = null;
        try {
            dvResources = dvWorkspaceFolder.listMembers();
        }
        catch (VcmFailure vcmFailure) {
            if (vcmFailure.getStatusCode() == 403) {
                throw new VfsException("Access to remote workspace folder \"" + this.getName() + "\" is denied.", vcmFailure);
            }
            throw new VfsException("Get members in workspace folder failed (" + vcmFailure.getMessage() + ")", vcmFailure);
        }
        return this.initializeChildren(dvResources, manager);
    }

    IVfsFolderItem[] initializeChildren(IResource[] dvResources, VersionedFileSystemManager manager) throws VfsException {
        HashSet<IVfsFolderItem> oldFolderItems = new HashSet<IVfsFolderItem>(Arrays.asList(this.m_folderItems));
        ArrayList<IResource> filteredResources = new ArrayList<IResource>(dvResources.length);
        int i = 0;
        while (i < dvResources.length) {
            IResource dvResource = dvResources[i];
            try {
                VfsFolderItem.checkIsVisible(this.m_context, new VfsRemoteLocator(dvResource.getConnectionTemplID(), dvResource.getDecodedPath(), dvResource.getCanonicalPath()), dvResource.getName());
                filteredResources.add(dvResource);
            }
            catch (VcmFailure e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
            catch (VfsException e) {
                LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
            }
            ++i;
        }
        dvResources = filteredResources.toArray(new IResource[filteredResources.size()]);
        VfsRepository repository = manager.getRepositoryByConnectionTemplateId(this.getConnectionTemplateId());
        ArrayList<VfsWorkspaceFolder> folderItemList = new ArrayList<VfsWorkspaceFolder>(dvResources.length);
        ArrayList<IResource> dvWorkspaces = new ArrayList<IResource>();
        int i2 = 0;
        while (i2 < dvResources.length) {
            block15: {
                VfsWorkspaceFolder workspaceFolder;
                IResource dvResource;
                block14: {
                    dvResource = dvResources[i2];
                    try {
                        ICollection dvCollection = dvResource.getAsCollection();
                        if (dvCollection == null || !dvCollection.isWorkspace()) break block14;
                        dvWorkspaces.add(dvResource);
                        break block15;
                    }
                    catch (VcmFailure vcmFailure1) {
                        throw new VfsException("Internal error: found a member under a workspace folder that is no folder", vcmFailure1);
                    }
                }
                IVirtualFile localFolder = Util.getLocalFile(this.m_context, null, dvResource.getName(), dvResource.getConnectionTemplID(), this.getAbsoluteRemotePath());
                if (localFolder == null) {
                    localFolder = VfsFolderItem.NULL_LOCAL_FILE;
                }
                if ((workspaceFolder = VfsWorkspaceFolder.getVfsWorkspaceFolder(this.getVfsManager(), dvResource, localFolder)) != null) {
                    folderItemList.add(workspaceFolder);
                }
            }
            ++i2;
        }
        Collection vfsWorkspaces = repository.refreshCachesForWorkspacesUnderWorkspaceFolder(dvWorkspaces);
        Iterator vfsWorkspacesIterator = vfsWorkspaces.iterator();
        while (vfsWorkspacesIterator.hasNext()) {
            folderItemList.add((VfsWorkspaceFolder)vfsWorkspacesIterator.next());
        }
        this.m_isRefreshedOnce = true;
        this.m_folderItems = folderItemList.toArray(new IVfsFolderItem[folderItemList.size()]);
        if (oldFolderItems.size() != this.m_folderItems.length) {
            this.getVfsManager().fireEventFolderItemsAddedOrRemoved(this);
            return this.m_folderItems;
        }
        int i3 = 0;
        while (i3 < this.m_folderItems.length) {
            IVfsFolderItem folderItem = this.m_folderItems[i3];
            if (!oldFolderItems.remove(folderItem)) {
                this.getVfsManager().fireEventFolderItemsAddedOrRemoved(this);
                return this.m_folderItems;
            }
            ++i3;
        }
        if (!oldFolderItems.isEmpty()) {
            this.getVfsManager().fireEventFolderItemsAddedOrRemoved(this);
        }
        return this.m_folderItems;
    }

    public IVfsFolderItem[] getFolderItems() throws VfsException {
        this.getVfsManager().checkState();
        if (!this.m_isRefreshedOnce) {
            this.refreshFolderItems();
        }
        return this.m_folderItems;
    }

    public String getBrowsePath() throws VfsException {
        this.getVfsManager().checkState();
        IVfsRemoteLocator[] rootLocators = this.m_context.getBrowseRootRemoteLocators();
        int connectionTemplateId = this.m_dvVcr.getConnectionTemplID();
        int i = 0;
        while (i < rootLocators.length) {
            IVfsRemoteLocator rootLocator = rootLocators[i];
            if (rootLocator.getConnectionTemplateId() == connectionTemplateId && this.getPath().startsWith(rootLocator.getAbsoluteRemotePath())) {
                return this.getPath().substring(rootLocator.getAbsoluteRemotePath().length() - 1);
            }
            ++i;
        }
        return null;
    }

    public IVfsWorkspaceFolder createSubfolder(String name) throws VfsException {
        this.getVfsManager().checkState();
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Creating sub folder is not allowed because workspace folder is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        try {
            String absoluteRemotePath = Util.assureTrailingSlash(this.getAbsoluteRemotePath()) + name;
            VfsFolderItem.checkIsVisible(this.getContext(), new VfsRemoteLocator(this.getConnectionTemplateId(), absoluteRemotePath, absoluteRemotePath), name);
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Creating sub folder is not allowed because it would not visible", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        try {
            String decodedPath = this.getPath() + name;
            ICollection collection = ResourceFactoryManager.getInstance().getPersistenceFactory().createCollection(this.m_dvVcr.getConnectionTemplID(), decodedPath);
            IVirtualFile localSubFolder = Util.getLocalFile(this.getContext(), this.m_localFile, name, this.getConnectionTemplateId(), this.getAbsoluteRemotePath());
            VfsWorkspaceFolder workspaceFolder = VfsWorkspaceFolder.getVfsWorkspaceFolder(this.getVfsManager(), collection, localSubFolder);
            this.refreshFolderItems();
            return workspaceFolder;
        }
        catch (Exception x) {
            throw new VfsException("Creating WorkspaceFolder " + name + " failed.", x);
        }
    }

    public IVfsWorkspace createWorkspace(String name) throws VfsException {
        this.getVfsManager().checkState();
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Creating workspace is not allowed because workspace folder is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        try {
            try {
                IMutableProperty workspaceEnabled = PropertyFactoryAccess.getFactory().createProperty(VfsXcmProperty.getNamespacePrefix(), VfsXcmProperty.WORKSPACE_ENABLED.getPropertyName());
                workspaceEnabled.setValue(Boolean.TRUE.toString());
                this.m_dvVcr.setProperties(new IProperty[]{workspaceEnabled});
            }
            catch (VcmFailure vcmFailure) {
                LogUtil.traceCaughtException((Location)LOCATION, (Throwable)vcmFailure, (int)300);
            }
            String decodedPath = this.getPath() + name;
            IWorkspace workspace = ResourceFactoryManager.getInstance().getPersistenceFactory().createWorkspace(this.m_dvVcr.getConnectionTemplID(), decodedPath);
            this.refreshFolderItems();
            return this.getVfsManager().getWorkspaceByUrl(workspace.getPersistentURL());
        }
        catch (Exception x) {
            throw new VfsException("Creating Workspace " + name + " failed.", x);
        }
    }

    public boolean isEmpty() throws VfsException {
        this.getVfsManager().checkState();
        if (this.m_folderItems.length == 0) {
            this.refreshFolderItems();
            if (this.m_folderItems.length == 0) {
                return true;
            }
        }
        return false;
    }

    public void removeProperty(String name) throws VfsException {
        this.getVfsManager().checkState();
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Removing property is not allowed because workspace folder is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        this.internalRemoveProperty(this.getNewestDeltaVResource(), name);
    }

    public void setProperty(String name, String value) throws VfsException {
        this.getVfsManager().checkState();
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Setting property is not allowed because workspace folder is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        this.getVfsManager().getPropertiesFeature().setProperty(this, name, value);
    }

    public IVersionedFileSystemManager getVersionedFileSystemManager() {
        if (this.m_vfsManager == null || this.m_vfsManager.isReleased()) {
            throw new IllegalStateException("Versioned file system manager was released");
        }
        return this.m_vfsManager;
    }

    public Date getCreationDate() throws VfsException {
        this.getVfsManager().checkState();
        if (this.m_dvVcr != null) {
            try {
                return this.m_dvVcr.created();
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Getting creation date failed.", vcmFailure);
            }
        }
        return null;
    }

    public String getCreatorName() throws VfsException {
        this.getVfsManager().checkState();
        if (this.m_dvVcr != null) {
            try {
                return this.m_dvVcr.getAuthor();
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Getting creator name failed.", vcmFailure);
            }
        }
        return null;
    }

    void removeFolderItems(Map folderItems) {
        this.m_folderItems = FolderUtil.removeFolderItems(this.m_folderItems, folderItems);
    }

    public boolean isReleased() {
        return this.m_vfsManager == null || this.m_vfsManager.isReleased();
    }

    public void sync() throws VfsException {
        this.getVfsManager().checkState();
        this.getVfsManager().getSyncRemoveFeature().sync(this, false, false);
    }

    public void syncToDate(Calendar vfsCal) throws VfsException {
        this.getVfsManager().checkState();
        this.refreshFolderItems();
        IVfsFolderItem[] folderItems = this.getFolderItems();
        int i = 0;
        while (i < folderItems.length) {
            IVfsFolderItem folderItem = folderItems[i];
            if (folderItem.asWorkspace() != null) {
                folderItem.asWorkspace().syncToDate(vfsCal);
            } else if (folderItem.asWorkspaceFolder() != null) {
                folderItem.asWorkspaceFolder().syncToDate(vfsCal);
            } else {
                throw new VfsException("Unknown object type for syncToDate: " + folderItem.getClass());
            }
            ++i;
        }
    }

    public void syncForce() throws VfsException {
        this.getVfsManager().checkState();
        this.getVfsManager().getSyncRemoveFeature().sync(this, true, false);
    }

    public void syncPreview() throws VfsException {
        this.getVfsManager().checkState();
        this.getVfsManager().getSyncRemoveFeature().sync(this, false, true);
    }

    void refreshForMountPointDeletion() throws VfsException {
        super.refreshForMountPointDeletion();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

