/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.IActivity;
import com.tssap.dtr.client.lib.deltavlib.IActivityCollection;
import com.tssap.dtr.client.lib.deltavlib.IAssociatedResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.ICheckedOutResource;
import com.tssap.dtr.client.lib.deltavlib.ICollection;
import com.tssap.dtr.client.lib.deltavlib.IPersistentResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.IWorkspace;
import com.tssap.dtr.client.lib.deltavlib.PathEncodingFlag;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.PropertyFactoryAccess;
import com.tssap.dtr.client.lib.deltavlib.factory.ResourceFactoryManager;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.IMutableProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.xcm.ActivityCompositeDef;
import com.tssap.dtr.client.lib.deltavlib.xcm.ActivityReportFactory;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityComposite;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityQuery;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityReport;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICheckinCollision;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.util.Platform;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.IVfsRepository;
import com.tssap.dtr.client.lib.vfs.IVfsVersionSet;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsChangeModel;
import com.tssap.dtr.client.lib.vfs.VfsCollisionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemCategory;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.impl.FolderItemCache;
import com.tssap.dtr.client.lib.vfs.impl.FolderUtil;
import com.tssap.dtr.client.lib.vfs.impl.Util;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivity;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolder;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.impl.VfsListenerHandler;
import com.tssap.dtr.client.lib.vfs.impl.VfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.impl.VfsRepository;
import com.tssap.dtr.client.lib.vfs.impl.VfsSpecialPaths;
import com.tssap.dtr.client.lib.vfs.impl.VfsXcmClientProperty;
import com.tssap.dtr.client.lib.vfs.impl.VfsXcmProperty;
import java.net.MalformedURLException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class VfsWorkspace
extends VfsFolderItem
implements IVfsWorkspace {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$VfsWorkspace == null ? (class$com$tssap$dtr$client$lib$vfs$impl$VfsWorkspace = VfsWorkspace.class$("com.tssap.dtr.client.lib.vfs.impl.VfsWorkspace")) : class$com$tssap$dtr$client$lib$vfs$impl$VfsWorkspace));
    private VersionedFileSystemManager m_vfsManager = null;
    private VfsChangeModel m_changeModel = null;
    private VfsRepository m_repository;
    private IVfsFolderItem[] m_folderItems = IVfsFolderItem.NO_ITEMS;
    private VfsActivity m_currentActivity = null;
    private VfsActivity m_defaultActivity = null;
    private HashMap m_openActivities = new HashMap();
    private boolean m_isOpenActivityCacheInitialized = false;
    private HashMap m_closedActivities = new HashMap();
    boolean m_isRefreshedOnce = false;
    private IActivityReport m_activityReport = null;
    private IActivityQuery m_openActivityQuery = null;
    private IActivityQuery m_closedActivityQuery = null;
    private HashMap m_integrateCollisions = new HashMap();
    private static final IVfsActivity[] ACTIVITIES = new IVfsActivity[0];
    private static final boolean LOGGING_ON = true;
    private static final boolean USE_FOLDER_ITEM_CACHE = true;
    private static final boolean NOT_USE_FOLDER_ITEM_CACHE = false;
    private static final boolean REFRESH_OPEN_ACTIVITIES = true;
    private static final boolean NOT_REFRESH_OPEN_ACTIVITIES = false;
    static final VfsWorkspace NULL_WORKSPACE = null;
    private static final IVfsActivityRecordedFolderItem[] EMPTY_ACTIVITY_RECORDED_FOLDERITEMS_ARRAY = new IVfsActivityRecordedFolderItem[0];
    private static final IVfsIntegrateCollision[] EMPTY_COLLISIONS_ARRAY = new IVfsIntegrateCollision[0];
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$VfsWorkspace;

    private VfsWorkspace(VfsRepository repository, IResource deltaVWorkspaceResource, IVirtualFile localFolder, boolean refreshOpenActivities) throws VfsException {
        super(deltaVWorkspaceResource, localFolder);
        this.m_vfsManager = repository.getVersionedFileSystemManager();
        this.m_repository = repository;
        this.m_locationState = !this.isMounted() ? VfsFolderItemLocationState.NOT_MOUNTED : (this.m_localFile.exists() && this.m_dvVcr == null ? VfsFolderItemLocationState.LOCAL_ONLY : (!this.m_localFile.exists() && this.m_dvVcr != null ? VfsFolderItemLocationState.SERVER_ONLY : VfsFolderItemLocationState.MOUNTED));
        this.initializeOpenActivityReportForWorkspace();
        this.initializeClosedActivityReportForWorkspace();
        if (refreshOpenActivities) {
            this.refreshOpenActivitiesFromRepository();
        }
    }

    static VfsWorkspace pureCreateVfsWorkspace(VfsRepository repository, IResource dvWorkspaceResource, IVirtualFile localFolder) throws VfsException {
        return VfsWorkspace.getVfsWorkspace(repository, dvWorkspaceResource, localFolder, false, false);
    }

    static VfsWorkspace getVfsWorkspace(VfsRepository repository, IResource dvWorkspaceResource, IVirtualFile localFolder) throws VfsException {
        return VfsWorkspace.getVfsWorkspace(repository, dvWorkspaceResource, localFolder, true, true);
    }

    private static VfsWorkspace getVfsWorkspace(VfsRepository repository, IResource dvWorkspaceResource, IVirtualFile localFolder, boolean useFolderItemCache, boolean refreshOpenActivities) throws VfsException {
        if (repository == null || dvWorkspaceResource == null || localFolder == null) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, localFolder != null ? localFolder.getAbsolutePath() : "<null local path>", "Internal error");
            throw new VfsException("Internal error: factory method call with null resource");
        }
        if (dvWorkspaceResource == VfsFolderItem.NULL_DELTAV_RESOURCE || dvWorkspaceResource == VfsFolderItem.KEEP_DELTAV_RESOURCE) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, localFolder.getAbsolutePath(), "Internal error");
            throw new VfsException("Internal error: invalid DeltaV workspace");
        }
        try {
            if (!dvWorkspaceResource.isCollection() || !dvWorkspaceResource.getAsCollection().isWorkspace()) {
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, localFolder.getAbsolutePath(), "Internal error");
                throw new VfsException("Internal error: invalid DeltaV workspace");
            }
        }
        catch (VcmFailure vcmFailure) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, localFolder.getAbsolutePath(), "Get category (collection, workspace, ...) of DeltaV resource failed - " + vcmFailure.getMessage());
            throw new VfsException("Get category (collection, workspace, ...) of DeltaV resource failed", vcmFailure);
        }
        try {
            VfsFolderItem.checkIsVisible(repository.getContext(), new VfsRemoteLocator(dvWorkspaceResource.getConnectionTemplID(), dvWorkspaceResource.getDecodedPath(), dvWorkspaceResource.getCanonicalPath()), dvWorkspaceResource.getName());
        }
        catch (VcmFailure e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return null;
        }
        catch (VfsException e) {
            Logbook.getInfoChapter(2).println(e.getMessage());
            return null;
        }
        if (localFolder != VfsFolderItem.NULL_LOCAL_FILE && localFolder != VfsFolderItem.KEEP_LOCAL_FILE && localFolder.isFile()) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, localFolder.getAbsolutePath(), "Name clash between local file and remote workspace");
            throw new VfsException("Name clash between local file and remote workspace: " + localFolder.getAbsolutePath());
        }
        VfsWorkspace workspace = null;
        if (useFolderItemCache) {
            FolderItemCache cache = repository.getFolderItemCache();
            if (cache == null) {
                return new VfsWorkspace(repository, dvWorkspaceResource, localFolder, refreshOpenActivities);
            }
            workspace = cache.getWorkspace(dvWorkspaceResource.getPersistentURL());
        }
        if (workspace == null) {
            if (localFolder == VfsFolderItem.KEEP_LOCAL_FILE) {
                String absoluteLocalPath = VfsFolderItem.getAbsoluteLocalPath(localFolder, dvWorkspaceResource, repository.getContext(), VfsFolderItemCategory.WORKSPACE);
                localFolder = absoluteLocalPath != null ? repository.getContext().getFileService().constructFile(absoluteLocalPath) : VfsFolderItem.NULL_LOCAL_FILE;
            }
            workspace = new VfsWorkspace(repository, dvWorkspaceResource, localFolder, refreshOpenActivities);
        } else {
            workspace.m_dvVcr = dvWorkspaceResource;
            if (localFolder == VfsFolderItem.NULL_LOCAL_FILE) {
                workspace.m_localFile = null;
            } else if (localFolder != VfsFolderItem.KEEP_LOCAL_FILE) {
                workspace.m_localFile = localFolder;
            }
        }
        return workspace;
    }

    IVfsWorkspace getWorkspace() {
        return this;
    }

    IActivityReport getActivityReport() {
        return this.m_activityReport;
    }

    IActivityQuery getOpenActivityQuery() {
        return this.m_openActivityQuery;
    }

    ActivityCompositeDef getOpenActivityCompositeDef() {
        return VfsActivity.OPEN_ACTIVITY_COMPOSITE_DEF;
    }

    IActivityQuery getClosedActivityQuery() {
        return this.m_closedActivityQuery;
    }

    ActivityCompositeDef getClosedActivityCompositeDef() {
        return VfsActivity.CLOSED_ACTIVITY_COMPOSITE_DEF;
    }

    void setOpenActivityCacheInitialized() {
        this.m_isOpenActivityCacheInitialized = true;
    }

    boolean isOpenActivityCacheInitialized() {
        return this.m_isOpenActivityCacheInitialized;
    }

    void refreshOpenActivitiesFromRepository() throws VfsException {
        IActivityComposite[] activityComposites;
        block3: {
            if (this.isOpenActivityCacheInitialized()) {
                return;
            }
            activityComposites = null;
            try {
                activityComposites = this.m_activityReport.select(this.m_openActivityQuery, this.getOpenActivityCompositeDef());
            }
            catch (VcmFailure vcmFailure) {
                if (vcmFailure.getStatusCode() == 404) break block3;
                throw new VfsException("Activity report (get open activities for current workspace and user) failed", vcmFailure);
            }
        }
        this.refreshActivityCache(activityComposites);
        this.setOpenActivityCacheInitialized();
    }

    private void initializeOpenActivityReportForWorkspace() throws VfsException {
        if (this.m_activityReport == null) {
            this.m_activityReport = ActivityReportFactory.getInstance().createReport(this.getConnectionTemplateId(), this.getPath());
        }
        this.m_openActivityQuery = ActivityReportFactory.getInstance().createQuery();
        this.m_openActivityQuery.setWorkspace(this.m_dvVcr.getDecodedPath());
        this.m_openActivityQuery.setUser(this.getContext().getUserName(this.m_repository.getConnectionTemplateId()));
        this.m_openActivityQuery.setOpenedOnly(true);
        if (this.getContext().getClientFilter() != null) {
            IProperty clientIDProperty = PropertyFactoryAccess.getFactory().createStringProperty(VfsXcmClientProperty.getNamespacePrefix(), VfsXcmClientProperty.CLIENT_ID.getPropertyName(), this.getContext().getClientFilter());
            this.m_openActivityQuery.addPropertyEqualsConstraint(clientIDProperty);
        }
    }

    private void initializeClosedActivityReportForWorkspace() throws VfsException {
        if (this.m_activityReport == null) {
            this.m_activityReport = ActivityReportFactory.getInstance().createReport(this.getConnectionTemplateId(), this.getPath());
        }
        this.m_closedActivityQuery = ActivityReportFactory.getInstance().createQuery();
        this.m_closedActivityQuery.setWorkspace(this.m_dvVcr.getDecodedPath());
        this.m_closedActivityQuery.setUser(this.getContext().getUserName(this.m_repository.getConnectionTemplateId()));
        this.m_closedActivityQuery.setClosedOnly(true);
    }

    Collection refreshClosedActivitiesFromRepository() throws VfsException {
        Collection vfsActivities;
        boolean lazy_retrieval = true;
        if (lazy_retrieval) {
            IActivity[] dvActivities;
            block6: {
                dvActivities = new IActivity[]{};
                try {
                    dvActivities = this.m_activityReport.select(this.m_closedActivityQuery);
                }
                catch (VcmFailure vcmFailure) {
                    if (vcmFailure.getStatusCode() == 404) break block6;
                    throw new VfsException("Activity report (get closed activities for current workspace and user) failed", vcmFailure);
                }
            }
            vfsActivities = this.refreshClosedActivityCache(dvActivities, (IVfsWorkspace)this);
        } else {
            IActivityComposite[] activityComposites;
            block7: {
                activityComposites = null;
                try {
                    activityComposites = this.m_activityReport.select(this.m_closedActivityQuery, this.getClosedActivityCompositeDef());
                }
                catch (VcmFailure vcmFailure) {
                    if (vcmFailure.getStatusCode() == 404) break block7;
                    throw new VfsException("Activity report (get closed activities for current workspace and user) failed", vcmFailure);
                }
            }
            vfsActivities = this.refreshClosedActivityCache(activityComposites, (IVfsWorkspace)this);
        }
        return vfsActivities;
    }

    Collection refreshClosedActivityCache(IActivityComposite[] activityComposites, IVfsWorkspace vfsWorkspace) throws VfsException {
        ArrayList<VfsActivity> vfsActivities = new ArrayList<VfsActivity>(activityComposites.length);
        int i = 0;
        while (i < activityComposites.length) {
            IActivity dvActivity = activityComposites[i].getActivity();
            VfsActivity vfsActivity = new VfsActivity(this.m_repository, dvActivity);
            vfsActivity.refreshElementsFromClosedActivity(activityComposites[i]);
            vfsActivity.setWorkspaceForClosedActivity(vfsWorkspace);
            vfsActivities.add(vfsActivity);
            ++i;
        }
        return vfsActivities;
    }

    Collection refreshClosedActivityCache(IActivity[] dvActivities, IVfsWorkspace vfsRetrievingWorkspace) throws VfsException {
        List<IActivity> visibleClosedDvActivities = Arrays.asList(dvActivities);
        return VfsActivity.getClosedVfsActivities((VfsRepository)this.getRepository(), visibleClosedDvActivities);
    }

    void refreshActivityCache(IActivityComposite[] activityComposites) throws VfsException {
        if (activityComposites == null || activityComposites.length == 0) {
            return;
        }
        ArrayList<VfsActivity> vfsActivities = new ArrayList<VfsActivity>(activityComposites.length);
        VfsException exception = null;
        int i = 0;
        while (i < activityComposites.length) {
            if (!VfsActivity.isDvActivityVisible(this.m_repository, activityComposites[i].getActivity(), this)) {
                Logbook.getInfoChapter(2).println("Filtered out activity: " + VfsActivity.getIdentifyingString(activityComposites[i].getActivity()));
            } else {
                try {
                    vfsActivities.add(this.refreshActivityCache(activityComposites[i]));
                }
                catch (VfsException e) {
                    exception = e;
                }
            }
            ++i;
        }
        if (exception != null) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, "Refreshing open activities on workspace failed");
            throw new VfsException("Refreshing open activities on workspace failed: " + this.getAbsoluteRemotePath(), exception);
        }
    }

    VfsActivity refreshActivityCache(IActivityComposite activityComposite) throws VfsException {
        IActivity dvActivity = activityComposite.getActivity();
        boolean foundOpenActivity = false;
        boolean foundEmptyActivity = false;
        VfsActivity vfsActivity = (VfsActivity)this.m_openActivities.get(dvActivity.getDecodedPath());
        if (vfsActivity != null) {
            foundOpenActivity = true;
        } else {
            vfsActivity = ((VfsRepository)this.getRepository()).getEmptyActivity(dvActivity.getDecodedPath());
            if (vfsActivity != null) {
                foundEmptyActivity = true;
            }
        }
        if (foundOpenActivity || foundEmptyActivity) {
            vfsActivity.setDeltaVActivity(dvActivity);
        } else {
            vfsActivity = new VfsActivity(this.m_repository, dvActivity);
        }
        vfsActivity.refreshElementsFromOpenActivity(this, activityComposite);
        if (foundOpenActivity) {
            if (vfsActivity.isEmpty()) {
                this.removeActivityFromOpenActivityCache(vfsActivity);
            }
        } else if (foundEmptyActivity) {
            if (!vfsActivity.isEmpty()) {
                this.addActivityToOpenActivityCache(vfsActivity);
            }
        } else if (vfsActivity.isEmpty()) {
            this.m_repository.addEmptyActivity(vfsActivity);
        } else {
            this.addActivityToOpenActivityCache(vfsActivity);
        }
        if (vfsActivity.isDvActivityDefaultActivity()) {
            this.initializeDefaultActivityOnWorkspace(vfsActivity);
        }
        this.setOpenActivityCacheInitialized();
        return vfsActivity;
    }

    public VfsActionOnFolderItem[] getActionsForCurrentState() {
        this.getVfsManager().checkState();
        return this.getVfsManager().getAllowedActionsFeature().getAllowedActionsForCurrentState(this);
    }

    public String getDescription() throws VfsException {
        this.getVfsManager().checkState();
        try {
            return this.getProperty(DAV.COMMENT.qualifiedName).getValue();
        }
        catch (VfsException e) {
            throw new VfsException("Getting description workspace failed", e);
        }
    }

    public VfsChangeModel getChangeModel() throws VfsException {
        this.getVfsManager().checkState();
        if (this.m_changeModel == null) {
            IProperty changeModel;
            try {
                changeModel = this.m_dvVcr.getProperty(VfsXcmProperty.CHANGE_MODEL_PROPERTY_NAME.getCompletePropertyName());
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Getting change model failed.", vcmFailure);
            }
            if (changeModel != null) {
                String value = changeModel.getValue();
                if (value != null) {
                    if (value.equals(VfsXcmProperty.CHANGE_MODEL_XCM)) {
                        this.m_changeModel = VfsChangeModel.XCM;
                    } else if (value.equals(VfsXcmProperty.CHANGE_MODEL_UCM)) {
                        this.m_changeModel = VfsChangeModel.UCM;
                    }
                }
            } else {
                this.m_changeModel = VfsChangeModel.UNKNOWN_CM;
            }
        }
        return this.m_changeModel;
    }

    public IVfsRepository getRepository() {
        this.getVfsManager().checkState();
        return this.m_repository;
    }

    public IVfsContext getContext() {
        this.getVfsManager().checkState();
        return this.m_repository.getContext();
    }

    public void setProperty(String name, String value) throws VfsException {
        this.getVfsManager().checkState();
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Changing properties is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        this.getVfsManager().getPropertiesFeature().setProperty(this, name, value);
    }

    public void removeProperty(String name) throws VfsException {
        this.getVfsManager().checkState();
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Changing of properties is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        this.internalRemoveProperty(this.getNewestDeltaVResource(), name);
    }

    public IVfsFolderItem[] refreshFolderItems() throws VfsException {
        this.getVfsManager().checkState();
        this.refreshOpenActivitiesFromRepository();
        return this.initializeChildren(FolderUtil.getRefreshedFolderItems(this, false));
    }

    IVfsFolderItem[] initializeChildren(IVfsFolderItem[] newFolderItems) {
        HashSet<IVfsFolderItem> oldFolderItems = new HashSet<IVfsFolderItem>(Arrays.asList(this.m_folderItems));
        boolean wasRefreshedOnce = this.m_isRefreshedOnce;
        this.m_folderItems = newFolderItems;
        this.m_isRefreshedOnce = true;
        if (wasRefreshedOnce) {
            int i = 0;
            while (i < this.m_folderItems.length) {
                IVfsFolderItem folderItem = this.m_folderItems[i];
                if (!oldFolderItems.remove(folderItem)) {
                    this.getVfsManager().fireEventFolderItemsAddedOrRemoved(this);
                    return this.m_folderItems;
                }
                ++i;
            }
            if (!oldFolderItems.isEmpty()) {
                this.getVfsManager().fireEventFolderItemsAddedOrRemoved(this);
            }
        }
        return this.m_folderItems;
    }

    public IVfsFolderItem[] getFolderItems() {
        this.getVfsManager().checkState();
        if (!this.m_isRefreshedOnce) {
            try {
                this.refreshFolderItems();
            }
            catch (VfsException ignoreAlreadyLogged) {
                Logbook.getErrorChapter().println(ignoreAlreadyLogged.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
            }
        }
        return this.m_folderItems;
    }

    public IVfsActivity createActivity(String name) throws VfsException {
        this.getVfsManager().checkState();
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Creating activity is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        String activityName = VfsActivity.generateNameForActivityInWorkspace(this);
        String displayName = name;
        IVfsActivity activity = this.createActivityWithName(activityName);
        activity.setDisplayName(displayName);
        this.setOpenActivityCacheInitialized();
        return activity;
    }

    private IVfsActivity createActivityWithName(String name) throws VfsException {
        IActivity dvActivity;
        String activityName;
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Creating activity is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        String displayName = null;
        if (name == null || name.length() == 0) {
            activityName = VfsActivity.generateNameForActivityInWorkspace(this);
        } else {
            VfsActivity.checkActivityName(name, true);
            activityName = name;
            displayName = name;
        }
        IActivityCollection[] dvActivityCollections = new IActivityCollection[]{};
        try {
            dvActivityCollections = ((VfsRepository)this.getRepository()).getActivityCollections();
        }
        catch (VfsException e) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, null, "Creating activity failed: " + displayName + " ( " + activityName + " ) - " + e.getMessage());
            throw new VfsException("Get folders containing activities failed", e);
        }
        String guid = Platform.getPlatform().createGuid();
        String decodedActivityPath = dvActivityCollections[0].getDecodedPath().endsWith("/") ? dvActivityCollections[0].getDecodedPath() + activityName + '_' + guid : dvActivityCollections[0].getDecodedPath() + '/' + activityName + '_' + guid;
        String activityString = displayName == null || displayName.equals(activityName) ? activityName + '_' + guid : displayName + " ( " + activityName + '_' + guid + " ) ";
        IPersistentResourceFactory dvResourceFactory = ResourceFactoryManager.getInstance().getPersistenceFactory();
        try {
            dvActivity = dvResourceFactory.createActivity(this.m_dvVcr.getConnectionTemplID(), decodedActivityPath);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.SUCCEEDED, null, "Created activity " + activityString);
        }
        catch (VcmFailure vcmFailure) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, null, "Creating activity failed: " + activityString + " - " + vcmFailure.getMessage());
            throw new VfsException("Creating activity failed", vcmFailure);
        }
        if (displayName != null) {
            try {
                dvActivity.setDisplayName(displayName);
                dvActivity.refresh();
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Refresh new activity failed: " + activityString, vcmFailure);
            }
        }
        VfsActivity activity = new VfsActivity(this.m_repository, dvActivity);
        this.m_repository.addEmptyActivity(activity);
        activity.setInitialSetOfClientProperties(this);
        this.getVfsManager().fireEventActivityCreated(activity);
        return activity;
    }

    VfsActivity createActivity(String namePrefix, String displayName, String defaultDisplayName, String description) throws VfsException {
        String activityName = VfsActivity.generateNameForActivityInWorkspace(this, namePrefix);
        VfsActivity activity = (VfsActivity)this.createActivityWithName(activityName);
        this.setOpenActivityCacheInitialized();
        activity.setDisplayName(displayName != null && displayName.length() > 0 ? displayName : defaultDisplayName);
        if (description != null && description.length() > 0) {
            activity.setDescription(description);
        }
        return activity;
    }

    public IVfsActivity[] getEmptyActivities() throws VfsException {
        this.getVfsManager().checkState();
        IVfsActivity[] allEmptyActivities = this.m_repository.getEmptyActivities();
        ArrayList<VfsActivity> emptyActivities = new ArrayList<VfsActivity>();
        int i = 0;
        while (i < allEmptyActivities.length) {
            VfsActivity activity = (VfsActivity)allEmptyActivities[i];
            if (activity.getXcmClientWorkspace() == this) {
                emptyActivities.add(activity);
            }
            ++i;
        }
        return emptyActivities.toArray(ACTIVITIES);
    }

    public IVfsActivity[] getOpenActivities(String displayName) throws VfsException {
        this.getVfsManager().checkState();
        if (displayName == null) {
            throw new IllegalStateException("Null dipslay name parameter");
        }
        ArrayList<IVfsActivity> activities = new ArrayList<IVfsActivity>();
        Iterator openActivityIterator = this.m_openActivities.values().iterator();
        while (openActivityIterator.hasNext()) {
            IVfsActivity activity = (IVfsActivity)openActivityIterator.next();
            if (!displayName.equals(activity.getDisplayName())) continue;
            activities.add(activity);
        }
        return activities.toArray(ACTIVITIES);
    }

    public IVfsActivity[] getClosedActivities(String displayName) throws VfsException {
        this.getVfsManager().checkState();
        if (displayName == null) {
            throw new IllegalStateException("Null dipslay name parameter");
        }
        throw new UnsupportedOperationException("Method is not yet realized");
    }

    public IVfsActivity getCurrentActivity() {
        this.getVfsManager().checkState();
        return this.m_currentActivity;
    }

    void setCurrentActivity(IVfsActivity activity) {
        this.m_currentActivity = (VfsActivity)activity;
    }

    void resetCurrentActivity() {
        this.m_currentActivity = null;
    }

    boolean isDefaultActivityInitial() {
        return this.m_defaultActivity == null || this.m_defaultActivity.isInvalid();
    }

    public IVfsActivity getDefaultActivity() throws VfsException {
        this.getVfsManager().checkState();
        if (this.m_defaultActivity == null || this.m_defaultActivity.isInvalid() || !this.m_defaultActivity.isOpen()) {
            this.createDefaultActivity();
        }
        return this.m_defaultActivity;
    }

    IVfsActivity pureGetDefaultActivity() {
        return this.m_defaultActivity;
    }

    public IVfsActivity createDefaultActivity() throws VfsException {
        this.getVfsManager().checkState();
        this.resetDefaultActivity();
        String currentDefaultActivityName = VfsActivity.generateNameForDefaultActivityInWorkspace(this);
        try {
            this.m_defaultActivity = (VfsActivity)this.createActivityWithName(currentDefaultActivityName);
        }
        catch (VfsException e) {
            throw new VfsException("Create default activity of workspace failed", e);
        }
        this.m_defaultActivity.markAsDefaultActivity();
        return this.m_defaultActivity;
    }

    void initializeDefaultActivityOnWorkspace(IVfsActivity activity) {
        this.m_defaultActivity = (VfsActivity)activity;
    }

    public void setDefaultActivity(IVfsActivity activity) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(activity);
        ((VfsActivity)activity).checkWorkspace(this);
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Setting default activity is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        if (activity == null) {
            throw new IllegalArgumentException("Internal error: Null argument for parameter 'activity'");
        }
        if (!activity.isOpen()) {
            throw new VfsException("Activity is closed");
        }
        this.resetDefaultActivity();
        this.m_defaultActivity = (VfsActivity)activity;
        this.m_defaultActivity.markAsDefaultActivity();
    }

    void resetDefaultActivity() throws VfsException {
        if (this.m_defaultActivity != null && !this.m_defaultActivity.isInvalid() && this.m_defaultActivity.isOpen()) {
            this.m_defaultActivity.unmarkAsDefaultActivity();
        }
        this.m_defaultActivity = null;
    }

    public IVfsActivity[] getActivities(VfsActivityState state) throws VfsException {
        this.getVfsManager().checkState();
        if (state == VfsActivityState.OPEN) {
            return this.m_openActivities.values().toArray(ACTIVITIES);
        }
        Collection closedActivities = this.refreshClosedActivitiesFromRepository();
        return closedActivities.toArray(ACTIVITIES);
    }

    private IVfsActivity getActivity(int integrationSequenceNumber) throws VfsException {
        this.getVfsManager().checkState();
        String absoluteRemotePathOfIntegration = VfsSpecialPaths.getAbsoluteRemotePathForIntegrationObject(this, integrationSequenceNumber);
        IResourceFactory proxyFactory = ResourceFactoryManager.getInstance().getProxyFactory();
        try {
            IResource dvResource = proxyFactory.createResource(this.getConnectionTemplateId(), absoluteRemotePathOfIntegration, PathEncodingFlag.DECODED);
            IProperty sourceVset = dvResource.getProperty(VfsXcmProperty.SOURCE_VSET.getCompletePropertyName());
            String absoluteRemotePathOfActivity = sourceVset.getFirstChild().getValue();
            IActivity dvActivity = proxyFactory.createActivity(this.getConnectionTemplateId(), absoluteRemotePathOfActivity, PathEncodingFlag.DECODED);
            VfsActivity vfsActivity = new VfsActivity(this.m_repository, dvActivity);
            if (vfsActivity.getWorkspace() == null) {
                throw new VfsException("Found integration object for empty activity ( " + vfsActivity.getIdentifyingString() + " ): " + absoluteRemotePathOfIntegration);
            }
            vfsActivity.setWorkspaceForClosedActivity(this);
            return vfsActivity;
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting activity for given ISN " + integrationSequenceNumber + " from workspace " + this + " failed " + " (" + vcmFailure.getMessage() + ")", vcmFailure);
        }
    }

    public int getLatestIntegrationSequenceNumber() throws VfsException {
        this.getVfsManager().checkState();
        String value = this.getProperty(VfsXcmProperty.LAST_ISN.getCompletePropertyName()).getValue();
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new VfsException("Illegal ISN number: " + value, e);
        }
    }

    public void removeFromClient() throws VfsException {
        this.getVfsManager().checkState();
        this.getVfsManager().getSyncRemoveFeature().removeFromClient(this);
    }

    int getConnectionTemplateId() {
        return this.m_dvVcr.getConnectionTemplID();
    }

    void addActivityToOpenActivityCache(IVfsActivity activity) throws VfsException {
        if (activity.isEmpty()) {
            throw new VfsException("Changelist is empty.");
        }
        this.m_repository.removeEmptyActivity(activity);
        this.m_openActivities.put(activity.getAbsoluteRemotePath(), activity);
        ((VfsActivity)activity).addWorkspace(this);
    }

    void removeActivityFromOpenActivityCache(IVfsActivity activity) throws VfsException {
        if (activity.isOpen() && activity.isEmpty()) {
            this.m_repository.addEmptyActivity(activity);
            ((VfsActivity)activity).removeWorkspace(this);
        }
        this.m_openActivities.remove(activity.getAbsoluteRemotePath());
    }

    VfsActivity getActivityFromCache(String absoluteRemotePath) {
        return (VfsActivity)this.m_openActivities.get(absoluteRemotePath);
    }

    public String getBrowsePath() throws VfsException {
        this.getVfsManager().checkState();
        IVfsRemoteLocator[] rootLocators = this.getContext().getBrowseRootRemoteLocators();
        int connectionTemplateId = this.m_dvVcr.getConnectionTemplID();
        int i = 0;
        while (i < rootLocators.length) {
            IVfsRemoteLocator rootLocator = rootLocators[i];
            if (rootLocator.getConnectionTemplateId() == connectionTemplateId && this.getPath().startsWith(rootLocator.getAbsoluteRemotePath())) {
                return this.getPath().substring(rootLocator.getAbsoluteRemotePath().length() - 1);
            }
            ++i;
        }
        return null;
    }

    IWorkspace getDvWorkspace() throws VfsException {
        try {
            return this.m_dvVcr.getAsCollection().getAsWorkspace();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Get DeltaV workspace failed", vcmFailure);
        }
    }

    public IVfsFolder createSubFolder(String name) {
        this.getVfsManager().checkState();
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Creating folder is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            return null;
        }
        try {
            String decodedPath = this.getPath() + name;
            ICollection collection = ResourceFactoryManager.getInstance().getPersistenceFactory().createCollection(this.m_dvVcr.getConnectionTemplID(), decodedPath);
            IVirtualFile localFile = Util.getLocalFile(this.getContext(), this.m_localFile, collection.getName(), this.m_dvVcr.getConnectionTemplID(), this.m_dvVcr.getCanonicalPath());
            VfsActivityRecordedFolderItem folderItem = VfsActivityRecordedFolderItem.getVfsActivityRecordedFolderItem(this, collection.getAsVersionControlled(), localFile);
            if (folderItem.asFolder() == null) {
                VfsException e = new VfsException("Create subfolder failed because of local file with same name");
                e.printStackTrace();
                return null;
            }
            this.refreshFolderItems();
            return folderItem.asFolder();
        }
        catch (Exception x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
            return null;
        }
    }

    IVfsActivity getOpenActivityByAbsoluteRemotePath(String absoluteRemotePath) {
        return (IVfsActivity)this.m_openActivities.get(absoluteRemotePath);
    }

    public IVfsActivity getActivityByName(String name) throws VfsException {
        this.getVfsManager().checkState();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Null name parameter");
        }
        String absoluteRemotePath = this.m_repository.computeAbsoluteRemotePathOfActivity(name);
        IVfsActivity activity = (VfsActivity)this.m_openActivities.get(absoluteRemotePath);
        if (activity == null) {
            activity = this.m_repository.getActivityFromRepository(absoluteRemotePath);
        }
        if (activity != null && activity.getWorkspace() == this) {
            return activity;
        }
        return null;
    }

    public boolean doesDefaultActivityExist() {
        this.getVfsManager().checkState();
        return !this.isDefaultActivityInitial();
    }

    public IVfsIntegrateCollision[] getIntegrateCollisions() {
        this.getVfsManager().checkState();
        return this.m_integrateCollisions.values().toArray(new IVfsIntegrateCollision[this.m_integrateCollisions.size()]);
    }

    public IVfsIntegrateCollision getIntegrateCollision(String collisionPath) {
        this.getVfsManager().checkState();
        return (IVfsIntegrateCollision)this.m_integrateCollisions.get(PathUtilities.assureTrailingSeparator(collisionPath, PathUtilities.REMOTE_FILESERVICE));
    }

    public boolean hasIntegrateCollision() {
        this.getVfsManager().checkState();
        return this.m_integrateCollisions.size() > 0;
    }

    public void addToIntegrateCollisionCache(IVfsIntegrateCollision collision) {
        String key = PathUtilities.assureTrailingSeparator(collision.getPath(), PathUtilities.REMOTE_FILESERVICE);
        this.m_integrateCollisions.put(key, collision);
    }

    void clearCollisionCache() {
        this.m_integrateCollisions.clear();
    }

    public boolean isEmpty() throws VfsException {
        this.getVfsManager().checkState();
        if (this.m_folderItems.length == 0) {
            this.refreshFolderItems();
            if (this.m_folderItems.length == 0) {
                return true;
            }
        }
        return false;
    }

    public void syncToDate(Calendar vfsCal) throws VfsException {
        this.getVfsManager().checkState();
        this.getVfsManager().getSyncRemoveFeature().syncToCalendar(this, vfsCal);
    }

    public void syncForce() throws VfsException {
        this.getVfsManager().checkState();
        this.getVfsManager().getSyncRemoveFeature().sync(this, true, false);
    }

    public void syncPreview() throws VfsException {
        this.getVfsManager().checkState();
        this.getVfsManager().getSyncRemoveFeature().sync(this, false, true);
    }

    public void sync() throws VfsException {
        this.getVfsManager().checkState();
        this.getVfsManager().getSyncRemoveFeature().sync(this, false, false);
    }

    public IVersionedFileSystemManager getVersionedFileSystemManager() {
        if (this.m_vfsManager == null || this.m_vfsManager.isReleased()) {
            throw new IllegalStateException("Versioned file system manager was released");
        }
        return this.m_vfsManager;
    }

    void checkParameterState(IVfsActivity activity) {
        if (activity.getVersionedFileSystemManager() != this.getVersionedFileSystemManager()) {
            throw new IllegalArgumentException("Internal error: parameter with different versioned file system manager");
        }
    }

    void checkParameterState(IVfsIntegrateCollision integrateCollision) {
        if (integrateCollision.getWorkspace().getVersionedFileSystemManager() != this.getVersionedFileSystemManager()) {
            throw new IllegalArgumentException("Internal error: parameter with different versioned file system manager");
        }
    }

    public Date getCreationDate() throws VfsException {
        this.getVfsManager().checkState();
        if (this.m_dvVcr != null) {
            try {
                return this.m_dvVcr.created();
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Getting creation date failed.", vcmFailure);
            }
        }
        return null;
    }

    public String getCreatorName() throws VfsException {
        this.getVfsManager().checkState();
        if (this.m_dvVcr != null) {
            try {
                return this.m_dvVcr.getAuthor();
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Getting creator name failed.", vcmFailure);
            }
        }
        return null;
    }

    void checkParameterState(IVfsActivityRecordedFolderItem[] folderItems) {
        if (folderItems != null) {
            int i = 0;
            while (i < folderItems.length && folderItems[i] != null) {
                if (folderItems[i].getVersionedFileSystemManager() != this.getVersionedFileSystemManager()) {
                    throw new IllegalArgumentException("Internal error: parameter with different versioned file system manager");
                }
                ++i;
            }
        }
    }

    public void createAndCheckout(IVfsActivityRecordedFolderItem[] folderItems, IVfsActivity activity, int depth) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(activity);
        this.checkParameterState(folderItems);
        try {
            ((VfsActivity)activity).checkWorkspace(this);
        }
        catch (VfsException e) {
            VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, activity, e.getMessage());
            throw e;
        }
        int i = 0;
        while (i < folderItems.length) {
            if (folderItems[i] == null) {
                LogUtil.logException((Location)LOCATION, (Throwable)new IllegalArgumentException("Internal error: null folder item"));
            } else if (folderItems[i].getWorkspace() != this) {
                throw new VfsException("Folder item from another workspace cannot be checked out in activity from workspace " + this.getBrowsePath());
            }
            ++i;
        }
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Checkout is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        VfsListenerHandler listenerHandler = this.getVfsManager().getListenerHandler();
        boolean wasInternalDelayedListeningTurnedOn = listenerHandler.isVfsInternalDelayedListeningTurnedOn();
        if (!wasInternalDelayedListeningTurnedOn) {
            listenerHandler.startVfsInternalDelayedListening();
        }
        try {
            int i2 = 0;
            while (i2 < folderItems.length) {
                IVfsActivityRecordedFolderItem folderItem = folderItems[i2];
                if (folderItem != null) {
                    IVfsFolder folder = folderItem.asFolder();
                    if (folder != null) {
                        try {
                            folder.createAndCheckout(activity, depth);
                        }
                        catch (VfsException ignoreAlreadyLogged) {
                            LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
                        }
                    } else {
                        try {
                            folderItem.createAndCheckout(activity);
                        }
                        catch (VfsException ignoreAlreadyLogged) {
                            LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
                        }
                    }
                }
                ++i2;
            }
            Object var12_16 = null;
            if (!wasInternalDelayedListeningTurnedOn) {
                listenerHandler.stopVfsInternalDelayedListening();
            }
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (!wasInternalDelayedListeningTurnedOn) {
                listenerHandler.stopVfsInternalDelayedListening();
            }
            throw throwable;
        }
    }

    public IVfsActivityRecordedFolderItem[] checkoutAndDelete(IVfsActivityRecordedFolderItem[] folderItems, IVfsActivity activity) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(activity);
        this.checkParameterState(folderItems);
        try {
            ((VfsActivity)activity).checkWorkspace(this);
        }
        catch (VfsException e) {
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        int i = 0;
        while (i < folderItems.length) {
            Exception e;
            if (folderItems[i] == null) {
                e = new IllegalArgumentException("Internal error: null folder item");
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            } else if (folderItems[i].getWorkspace() != this) {
                e = new VfsException("Folder item from another workspace cannot be checked out in activity from workspace " + this.getBrowsePath());
                VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, e.getMessage());
                throw e;
            }
            ++i;
        }
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Checkout is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        VfsListenerHandler listenerHandler = this.getVfsManager().getListenerHandler();
        boolean wasInternalDelayedListeningTurnedOn = listenerHandler.isVfsInternalDelayedListeningTurnedOn();
        if (!wasInternalDelayedListeningTurnedOn) {
            listenerHandler.startVfsInternalDelayedListening();
        }
        ArrayList<VfsActivityRecordedFolderItem> failedFolderItems = new ArrayList<VfsActivityRecordedFolderItem>();
        try {
            int i2 = 0;
            while (i2 < folderItems.length) {
                VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)folderItems[i2];
                if (folderItem != null) {
                    try {
                        folderItem.checkOutAndDelete(activity, false, false);
                    }
                    catch (VfsException ignoreAlreadyLogged) {
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
                        failedFolderItems.add(folderItem);
                    }
                }
                ++i2;
            }
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            ((VfsActivity)activity).refreshOpenActivityAndActivityElements();
            if (!wasInternalDelayedListeningTurnedOn) {
                listenerHandler.stopVfsInternalDelayedListening();
            }
            throw throwable;
        }
        ((VfsActivity)activity).refreshOpenActivityAndActivityElements();
        if (!wasInternalDelayedListeningTurnedOn) {
            listenerHandler.stopVfsInternalDelayedListening();
        }
        return failedFolderItems.toArray(EMPTY_ACTIVITY_RECORDED_FOLDERITEMS_ARRAY);
    }

    public IVfsActivityRecordedFolderItem[] uncheckout(IVfsActivityRecordedFolderItem[] folderItems, IVfsActivity activity, boolean removeFilesFromClient) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(activity);
        this.checkParameterState(folderItems);
        try {
            ((VfsActivity)activity).checkWorkspace(this);
        }
        catch (VfsException e) {
            VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        int i = 0;
        while (i < folderItems.length) {
            Exception e;
            if (folderItems[i] == null) {
                e = new IllegalArgumentException("Internal error: null folder item");
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            } else if (folderItems[i].getWorkspace() != this) {
                e = new VfsException("Folder item from another workspace cannot be checked out in activity from workspace " + this.getBrowsePath());
                VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.FAILED, this, e.getMessage());
                throw e;
            }
            ++i;
        }
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Uncheckout is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        VfsListenerHandler listenerHandler = this.getVfsManager().getListenerHandler();
        boolean wasInternalDelayedListeningTurnedOn = listenerHandler.isVfsInternalDelayedListeningTurnedOn();
        if (!wasInternalDelayedListeningTurnedOn) {
            listenerHandler.startVfsInternalDelayedListening();
        }
        ArrayList<VfsActivityRecordedFolderItem> failedFolderItems = new ArrayList<VfsActivityRecordedFolderItem>();
        try {
            int i2 = 0;
            while (i2 < folderItems.length) {
                VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)folderItems[i2];
                if (folderItem != null) {
                    try {
                        folderItem.uncheckout(activity, removeFilesFromClient ? VfsActivityRecordedFolderItem.ActionOnLocalDisc.REMOVE_FILE_FROM_CLIENT : VfsActivityRecordedFolderItem.ActionOnLocalDisc.RESYNC_CHECKED_OUT_FILE_VERSION);
                    }
                    catch (VfsException ignoreAlreadyLogged) {
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
                        failedFolderItems.add(folderItem);
                    }
                }
                ++i2;
            }
            Object var12_14 = null;
            if (!wasInternalDelayedListeningTurnedOn) {
                listenerHandler.stopVfsInternalDelayedListening();
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (!wasInternalDelayedListeningTurnedOn) {
                listenerHandler.stopVfsInternalDelayedListening();
            }
            throw throwable;
        }
        return failedFolderItems.toArray(EMPTY_ACTIVITY_RECORDED_FOLDERITEMS_ARRAY);
    }

    void removeFolderItems(Map folderItems) {
        this.m_folderItems = FolderUtil.removeFolderItems(this.m_folderItems, folderItems);
    }

    public IVfsActivity[] getClosedActivitiesBy(String user, Date from, Date to) throws VfsException {
        this.getVfsManager().checkState();
        return ((VfsRepository)this.getRepository()).getClosedActivitiesBy(this, user, from, to, VfsActivity.EMPTY_PROPERTIES_ARRAY, false);
    }

    public IVfsVersionSet[] getVersionSetsBy(String user, Date from, Date to) throws VfsException {
        this.getVfsManager().checkState();
        return ((VfsRepository)this.getRepository()).getVersionSetsBy(this, user, from, to, true, VfsActivity.EMPTY_PROPERTIES_ARRAY, false, false);
    }

    public IVfsActivity[] getClosedActivitiesBy(String user, Date from, Date to, String[] additionalProperties, boolean containingFiles) throws VfsException {
        this.getVfsManager().checkState();
        return ((VfsRepository)this.getRepository()).getClosedActivitiesBy(this, user, from, to, additionalProperties, containingFiles);
    }

    public IVfsVersionSet[] deprecated_specialGetVersionSetsBy(String user, boolean returnPropagationLists, String[] additionalProperties, boolean containingFiles) throws VfsException {
        this.getVfsManager().checkState();
        Date from = null;
        Date to = null;
        boolean withoutPropagationRequestID = true;
        return ((VfsRepository)this.getRepository()).getVersionSetsBy(this, user, from, to, returnPropagationLists, additionalProperties, containingFiles, true);
    }

    public IVfsActivity[] getClosedActivitiesBy(Date from, Date to) throws VfsException {
        this.getVfsManager().checkState();
        return this.getClosedActivitiesBy(this.getContext().getUserName(this.getConnectionTemplateId()), from, to);
    }

    public IVfsVersionSet[] getVersionSetsBy(Date from, Date to) throws VfsException {
        this.getVfsManager().checkState();
        return this.getVersionSetsBy(this.getContext().getUserName(this.getConnectionTemplateId()), from, to);
    }

    public void immediateMassDelete(IVfsActivityRecordedFolderItem[] folderItems, boolean deleteLocalOnlyItems, String activityDisplayName, String activityDescription) throws VfsException {
        this.getVfsManager().checkState();
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Checkout is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        if (folderItems == null || folderItems.length == 0) {
            IllegalArgumentException e = new IllegalArgumentException("Internal error: Empty list of folder items given for deletion");
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            throw e;
        }
        Collection condensedFolderItems = VfsFolderItem.condenseFolderItems(folderItems);
        Iterator folderItemIterator = condensedFolderItems.iterator();
        while (folderItemIterator.hasNext()) {
            IVfsActivityRecordedFolderItem folderItem = (IVfsActivityRecordedFolderItem)folderItemIterator.next();
            if (folderItem.getWorkspace() != this) {
                String msg = "Folder item belongs to other workspace";
                VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, folderItem, msg);
                throw new VfsException(msg + ": " + folderItem.getLocalPath());
            }
            if (folderItem.getLocationState() == VfsFolderItemLocationState.NOT_MOUNTED) {
                throw new VfsException("Folder item is not mounted: " + folderItem.getLocalPath());
            }
            if (folderItem.asFolder() == null) continue;
            if (this.getVersionedFileSystemManager().isSomethingCheckedOutUnderFolder(folderItem.asFolder())) {
                String message = "Folder and subtree cannot be deleted, because there is something checked out";
                VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, folderItem, message);
                throw new VfsException(message + ": " + folderItem.getLocalPath());
            }
            if (deleteLocalOnlyItems || !((VfsFolder)folderItem.asFolder()).hasLocalOnlyFolderItems()) continue;
            String msg = "Folder or subtree contains local only files or folders";
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, folderItem, msg);
            throw new VfsException(msg + ": " + folderItem.getLocalPath());
        }
        VfsActivity activity = this.createActivity("default_hierarchical_deletion", activityDisplayName, "Immediate hierarchical deletion", activityDescription);
        try {
            folderItemIterator = condensedFolderItems.iterator();
            while (folderItemIterator.hasNext()) {
                IVfsActivityRecordedFolderItem folderItem = (IVfsActivityRecordedFolderItem)folderItemIterator.next();
                if (folderItem.asFolder() != null) {
                    ((VfsFolder)folderItem.asFolder()).checkOutAndDelete_preliminaryIncompleteImplementation(deleteLocalOnlyItems, activity);
                    continue;
                }
                folderItem.checkOutAndDelete(activity);
            }
        }
        catch (VfsException e) {
            activity.uncheckout();
            activity.delete();
            throw e;
        }
        activity.checkInWithoutUpload();
    }

    public void immediateDiscardCollidingVersion(IVfsIntegrateCollision integrateCollision, String activityDisplayName, String activityDescription) throws VfsException {
        VfsActivity activity = this.createActivity("default_immediate_discard", activityDisplayName, "Immediate discard colliding version", activityDescription);
        try {
            ((VfsIntegrateCollision)integrateCollision).discardCollidingVersion((IVfsActivity)activity, false);
        }
        catch (VfsException e) {
            integrateCollision.undoDiscardCollidingVersion(activity);
            activity.delete();
            throw e;
        }
        try {
            this.checkInSpecialActionActivity(activity);
        }
        catch (VfsException e) {
            integrateCollision.undoDiscardCollidingVersion(activity);
            activity.delete();
            throw e;
        }
        ((VersionedFileSystemManager)this.getVersionedFileSystemManager()).fireEventActivityStateChanged(activity, VfsActivityState.OPEN);
    }

    /*
     * Unable to fully structure code
     */
    public IVfsIntegrateCollision[] immediateMassDiscardCollidingVersion(IVfsIntegrateCollision[] integrateCollisions, String activityDisplayName, String activityDescription) throws VfsException {
        block5: {
            folderItems = new VfsActivityRecordedFolderItem[integrateCollisions.length];
            validCollisionsIndex = new ArrayList<E>();
            notResolvedCollisionsIndex = new ArrayList<E>();
            this.massCheckPreconditionsForDiscard(integrateCollisions, folderItems, validCollisionsIndex, notResolvedCollisionsIndex, true);
            if (integrateCollisions.length == notResolvedCollisionsIndex.size()) {
                return integrateCollisions;
            }
            activity = this.createActivity("default_immediate_discard", activityDisplayName, "Immediate discard colliding versions", activityDescription);
            this.pureDiscardCollidingVersions(activity, integrateCollisions, folderItems, validCollisionsIndex, notResolvedCollisionsIndex);
            if (integrateCollisions.length == notResolvedCollisionsIndex.size()) {
                activity.delete();
                return integrateCollisions;
            }
            try {
                this.checkInSpecialActionActivity(activity);
                break block5;
            }
            catch (VfsException e) {
                validCollisionsIterator = validCollisionsIndex.iterator();
                ** while (validCollisionsIterator.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                collisionIndex = (Integer)validCollisionsIterator.next();
                collision = integrateCollisions[collisionIndex];
                collision.undoDiscardCollidingVersion(activity);
                continue;
            }
lbl22:
            // 1 sources

            activity.delete();
            return integrateCollisions;
        }
        ((VersionedFileSystemManager)this.getVersionedFileSystemManager()).fireEventActivityStateChanged(activity, VfsActivityState.OPEN);
        return notResolvedCollisionsIndex.toArray(VfsWorkspace.EMPTY_COLLISIONS_ARRAY);
    }

    private void massCheckPreconditionsForDiscard(IVfsIntegrateCollision[] integrateCollisions, VfsActivityRecordedFolderItem[] folderItems, ArrayList validCollisionsIndex, ArrayList notResolvedCollisionsIndex, boolean allowDiscardForNullFolderItem) {
        int i = 0;
        while (i < integrateCollisions.length) {
            block3: {
                folderItems[i] = integrateCollisions[i] == null ? null : (VfsActivityRecordedFolderItem)integrateCollisions[i].getActiveVersionFolderItem();
                try {
                    this.checkPreconditionsForDiscard(integrateCollisions[i], folderItems[i], allowDiscardForNullFolderItem);
                }
                catch (VfsException e) {
                    VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
                    notResolvedCollisionsIndex.add(new Integer(i));
                    break block3;
                }
                validCollisionsIndex.add(new Integer(i));
            }
            ++i;
        }
    }

    private void pureDiscardCollidingVersions(VfsActivity activity, IVfsIntegrateCollision[] integrateCollisions, VfsActivityRecordedFolderItem[] folderItems, ArrayList validCollisionsIndex, ArrayList notResolvedCollisionsIndex) throws VfsException {
        Iterator validCollisionsIterator = ((AbstractList)validCollisionsIndex).iterator();
        while (validCollisionsIterator.hasNext()) {
            Integer index = (Integer)validCollisionsIterator.next();
            int collisionIndex = index;
            IVfsIntegrateCollision collision = integrateCollisions[collisionIndex];
            if (collision.getCollisionType().equals(VfsCollisionType.NAME_CLASH)) {
                try {
                    this.solveNameClashByDeletingInactiveVcr((VfsIntegrateCollision)collision, activity.getName() + "_ NameConflict resolutions", activity.getDescription());
                }
                catch (VfsException e1) {
                    ((AbstractCollection)validCollisionsIndex).remove(index);
                    notResolvedCollisionsIndex.add(index);
                }
                try {
                    if (folderItems[collisionIndex] == null) continue;
                    ((VersionedFileSystemManager)this.getVersionedFileSystemManager()).fireEventVersionDiscarded(folderItems[collisionIndex], collision, collision.getCollidingVersion());
                }
                catch (Exception e) {
                    LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
                }
                continue;
            }
            try {
                ((VfsIntegrateCollision)collision).discardCollidingVersion((IVfsActivity)activity, false);
            }
            catch (VfsException e) {
                collision.undoDiscardCollidingVersion(activity);
                ((AbstractCollection)validCollisionsIndex).remove(index);
                notResolvedCollisionsIndex.add(index);
            }
        }
    }

    private void pureDiscardActiveVersions(VfsActivity activity, IVfsIntegrateCollision[] integrateCollisions, VfsActivityRecordedFolderItem[] folderItems, ArrayList validCollisionsIndex, ArrayList notResolvedCollisionsIndex) throws VfsException {
        Iterator validCollisionsIterator = ((AbstractList)validCollisionsIndex).iterator();
        while (validCollisionsIterator.hasNext()) {
            Integer index = (Integer)validCollisionsIterator.next();
            int collisionIndex = index;
            IVfsIntegrateCollision collision = integrateCollisions[collisionIndex];
            if (collision.getCollisionType().equals(VfsCollisionType.NAME_CLASH)) {
                try {
                    IVfsActivityRecordedFolderItem activeResourceFolderItem = collision.getActiveVersionFolderItem();
                    if (activeResourceFolderItem != null) {
                        if (activeResourceFolderItem.getActivityState().equals(VfsFolderItemActivityState.NOT_CHECKED_OUT)) {
                            activeResourceFolderItem.asFile().checkOutAndDelete(activity);
                        } else {
                            ((AbstractCollection)validCollisionsIndex).remove(index);
                            notResolvedCollisionsIndex.add(index);
                        }
                    } else {
                        ((AbstractCollection)validCollisionsIndex).remove(index);
                        notResolvedCollisionsIndex.add(index);
                    }
                }
                catch (VfsException e1) {
                    ((AbstractCollection)validCollisionsIndex).remove(index);
                    notResolvedCollisionsIndex.add(index);
                }
                try {
                    if (folderItems[collisionIndex] == null) continue;
                    ((VersionedFileSystemManager)this.getVersionedFileSystemManager()).fireEventVersionDiscarded(folderItems[collisionIndex], collision, collision.getActiveVersion());
                }
                catch (Exception e) {
                    LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
                }
                continue;
            }
            try {
                ((VfsIntegrateCollision)collision).discardActiveVersion((IVfsActivity)activity, false);
            }
            catch (VfsException e) {
                collision.undoDiscardActiveVersion(activity);
                ((AbstractCollection)validCollisionsIndex).remove(index);
                notResolvedCollisionsIndex.add(index);
            }
        }
    }

    public void immediateDiscardActiveVersion(IVfsIntegrateCollision integrateCollision, String activityDisplayName, String activityDescription) throws VfsException {
        VfsActivity activity = this.createActivity("default_immediate_discard", activityDisplayName, "Immediate discard active version", activityDescription);
        try {
            ((VfsIntegrateCollision)integrateCollision).discardActiveVersion((IVfsActivity)activity, false);
        }
        catch (VfsException e) {
            integrateCollision.undoDiscardActiveVersion(activity);
            activity.delete();
            throw e;
        }
        try {
            this.checkInSpecialActionActivity(activity);
        }
        catch (VfsException e) {
            integrateCollision.undoDiscardActiveVersion(activity);
            activity.delete();
            throw e;
        }
        ((VersionedFileSystemManager)this.getVersionedFileSystemManager()).fireEventActivityStateChanged(activity, VfsActivityState.OPEN);
    }

    /*
     * Unable to fully structure code
     */
    public IVfsIntegrateCollision[] immediateMassDiscardActiveVersion(IVfsIntegrateCollision[] integrateCollisions, String activityDisplayName, String activityDescription) throws VfsException {
        block8: {
            folderItems = new VfsActivityRecordedFolderItem[integrateCollisions.length];
            validCollisionsIndex = new ArrayList<E>();
            notResolvedCollisionsIndex = new ArrayList<E>();
            this.massCheckPreconditionsForDiscard(integrateCollisions, folderItems, validCollisionsIndex, notResolvedCollisionsIndex, true);
            if (integrateCollisions.length == notResolvedCollisionsIndex.size()) {
                return integrateCollisions;
            }
            activity = this.createActivity("default_immediate_discard", activityDisplayName, "Immediate discard active version", activityDescription);
            folderItemsWithDeletionsIndex = this.computeFolderItemsWithDeletions(integrateCollisions, folderItems, validCollisionsIndex);
            try {
                this.pureDiscardActiveVersions(activity, integrateCollisions, folderItems, validCollisionsIndex, notResolvedCollisionsIndex);
            }
            catch (VfsException e1) {
                LogUtil.traceCaughtException((Location)VfsWorkspace.LOCATION, (Throwable)e1, (int)300);
            }
            if (integrateCollisions.length == notResolvedCollisionsIndex.size()) {
                activity.delete();
                return integrateCollisions;
            }
            try {
                this.checkInSpecialActionActivity(activity);
                break block8;
            }
            catch (VfsException e) {
                validCollisionsIterator = validCollisionsIndex.iterator();
                ** while (validCollisionsIterator.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                collisionIndex = (Integer)validCollisionsIterator.next();
                collision = integrateCollisions[collisionIndex];
                collision.undoDiscardActiveVersion(activity);
                continue;
            }
lbl27:
            // 1 sources

            activity.delete();
            return integrateCollisions;
        }
        this.refreshFolderItemsAfterDiscardActiveVersions(folderItems, validCollisionsIndex, folderItemsWithDeletionsIndex, integrateCollisions);
        ((VersionedFileSystemManager)this.getVersionedFileSystemManager()).fireEventActivityStateChanged(activity, VfsActivityState.OPEN);
        resolvedCollisions = new IVfsIntegrateCollision[validCollisionsIndex.size()];
        validCollisionsIterator = validCollisionsIndex.iterator();
        i = 0;
        while (validCollisionsIterator.hasNext()) {
            collisionIndex = (Integer)validCollisionsIterator.next();
            resolvedCollisions[i] = integrateCollisions[collisionIndex];
            ++i;
        }
        return resolvedCollisions;
    }

    private void refreshFolderItemsAfterDiscardActiveVersions(VfsActivityRecordedFolderItem[] folderItems, ArrayList discardedFolderItemsIndex, ArrayList folderItemsWithDeletionsIndex, IVfsIntegrateCollision[] integrateCollisions) throws VfsException {
        Iterator validCollisionsIterator = ((AbstractList)discardedFolderItemsIndex).iterator();
        while (validCollisionsIterator.hasNext()) {
            Integer index = (Integer)validCollisionsIterator.next();
            int collisionIndex = index;
            IVfsIntegrateCollision collision = integrateCollisions[collisionIndex];
            VfsActivityRecordedFolderItem folderItem = folderItems[collisionIndex];
            if (folderItemsWithDeletionsIndex.contains(index)) {
                try {
                    ((VfsIntegrateCollision)collision).refreshParentFolderAfterDiscardActive(folderItem);
                }
                catch (VfsException e) {}
                continue;
            }
            try {
                ((VfsIntegrateCollision)collision).refreshFolderItemAfterDiscardActive(folderItem);
            }
            catch (VfsException e) {
                // empty catch block
            }
        }
    }

    private ArrayList computeFolderItemsWithDeletions(IVfsIntegrateCollision[] integrateCollisions, VfsActivityRecordedFolderItem[] folderItems, ArrayList validCollisionsIndex) {
        ArrayList<Integer> folderItemsWithDeletionsIndex = new ArrayList<Integer>();
        Iterator validCollisionIterator = ((AbstractList)validCollisionsIndex).iterator();
        while (validCollisionIterator.hasNext()) {
            Integer index = (Integer)validCollisionIterator.next();
            int collisionIndex = index;
            VfsActivityRecordedFolderItem folderItem = folderItems[collisionIndex];
            IVfsIntegrateCollision integrateCollision = integrateCollisions[collisionIndex];
            if (folderItem != null && folderItem.getLocationState() != VfsFolderItemLocationState.DELETED) continue;
            folderItemsWithDeletionsIndex.add(index);
        }
        return folderItemsWithDeletionsIndex;
    }

    private void checkPreconditionsForDiscard(IVfsIntegrateCollision integrateCollision, VfsActivityRecordedFolderItem folderItem, boolean allowDiscardForNullFolderItem) throws VfsException {
        this.getVfsManager().checkState();
        if (integrateCollision == null) {
            IllegalArgumentException e = new IllegalArgumentException("Null integrate collision as argument for discard");
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            throw e;
        }
        this.checkParameterState(integrateCollision);
        if (integrateCollision.getWorkspace() != this) {
            VfsException e = new VfsException("Folder item belongs to another workspace: " + integrateCollision.getWorkspace().getBrowsePath());
            Logbook.getErrorChapter().println(e.getMessage());
            throw e;
        }
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Discard is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, folderItem, e.getMessage());
            throw e;
        }
    }

    private void checkInSpecialActionActivity(VfsActivity activity) throws VfsException {
        IActivity dvActivity = activity.getDeltaVActivity();
        IConnection connection = VfsActivityRecordedFolderItem.getConnection(dvActivity.getConnectionTemplID());
        int oldReadTimeout = connection.getSocketReadTimeout();
        int INFINITE_TIMEOUT = 0;
        connection.setSocketReadTimeout(INFINITE_TIMEOUT);
        try {
            try {
                ICheckinCollision[] dvCollisions = dvActivity.checkin(2);
                if (dvCollisions != null && dvCollisions.length > 0) {
                    String msg = "Checkin of activity failed due to check-in collisions";
                    VfsException e = new VfsException(msg + " : " + activity.getIdentifyingString());
                    VfsActionRecorder.log(VfsActionType.CHECKIN, VfsActionStatus.FAILED, activity, msg);
                    throw e;
                }
                VfsActionRecorder.log(VfsActionType.CHECKIN, VfsActionStatus.SUCCEEDED, activity, null);
            }
            catch (VcmFailure vcmFailure) {
                VfsException e = new VfsException("Checkin of activity failed: " + vcmFailure.getMessage(), vcmFailure);
                VfsActionRecorder.log(VfsActionType.CHECKIN, VfsActionStatus.FAILED, activity, e.getMessage());
                throw e;
            }
            Object var10_14 = null;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            connection.setSocketReadTimeout(oldReadTimeout);
            throw throwable;
        }
        connection.setSocketReadTimeout(oldReadTimeout);
        if (activity.isOpen()) {
            return;
        }
        VfsWorkspace workspace = (VfsWorkspace)activity.getWorkspace();
        if (workspace.getCurrentActivity() == activity) {
            workspace.setCurrentActivity(null);
        }
        if (!workspace.isDefaultActivityInitial() && workspace.pureGetDefaultActivity() == activity) {
            workspace.resetDefaultActivity();
        }
        try {
            workspace.removeActivityFromOpenActivityCache(activity);
        }
        catch (Exception e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
        try {
            ((VfsRepository)workspace.getRepository()).removeEmptyActivity(activity);
        }
        catch (Exception e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
    }

    IVfsActivityRecordedFolderItem solveCollisionByUndeletingActiveVcr(String deletedVcrUrl) throws VfsException {
        String urlInWorkspace;
        IVersionControlledResource dvDeletedResource;
        URL specialVcrUrl = null;
        try {
            specialVcrUrl = new URL(deletedVcrUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Internal error: invalid URL as argument for undeleting DeltaV resource: " + deletedVcrUrl);
        }
        IVfsRemoteLocator vcrRemoteLocator = this.getContext().getRemoteLocatorFromUrl(deletedVcrUrl);
        IResourceFactory dvFactory = ResourceFactoryManager.getInstance().getProxyFactory();
        try {
            dvDeletedResource = dvFactory.createResource(this.getConnectionTemplateId(), vcrRemoteLocator.getAbsoluteRemotePath(), PathEncodingFlag.DECODED).getAsVersionControlled();
        }
        catch (VcmFailure vcmFailure) {
            VfsException e = new VfsException("Get DeltaV resource for deleted version failed: " + deletedVcrUrl);
            VfsActionRecorder.log(VfsActionType.UNDELETE, VfsActionStatus.FAILED, deletedVcrUrl, e.getMessage());
            throw e;
        }
        try {
            urlInWorkspace = Util.assureTrailingSlash(this.getUrl()) + dvDeletedResource.getProperty(VfsXcmProperty.PATH.getCompletePropertyName()).getValue().substring(1);
        }
        catch (VcmFailure vcmFailure) {
            VfsException e = new VfsException("Get workspace path for deleted DeltaV resource failed: " + deletedVcrUrl);
            VfsActionRecorder.log(VfsActionType.UNDELETE, VfsActionStatus.FAILED, deletedVcrUrl, e.getMessage());
            throw e;
        }
        VfsActivityRecordedFolderItem folderItem = VfsActivityRecordedFolderItem.getVfsActivityRecordedFolderItem(this, dvDeletedResource, VfsFolderItem.NULL_LOCAL_FILE);
        if (folderItem.getLocationState() != VfsFolderItemLocationState.DELETED) {
            VfsException e = new VfsException("Checkout for undelete is not possible because the folder item would get a name clash");
            VfsActionRecorder.log(VfsActionType.UNDELETE, VfsActionStatus.FAILED, folderItem, e.getMessage());
            throw e;
        }
        String displayName = "Collision resolution for deleted version";
        String description = "Collision resolution for deleted version: " + urlInWorkspace + " ( " + deletedVcrUrl + " ) ";
        VfsActivity activity = this.createActivity("default_integratecollision_undeletion", displayName, displayName, description);
        try {
            folderItem.checkOutForUndelete_preliminaryUncompleteImplementation(activity);
        }
        catch (VfsException e) {
            activity.delete();
            throw e;
        }
        try {
            this.checkInSpecialActionActivity(activity);
        }
        catch (VfsException e) {
            IActivity dvActivity = activity.getDeltaVActivity();
            IAssociatedResourceFactory factory = ResourceFactoryManager.getInstance().getAssocFactory();
            try {
                ICheckedOutResource[] checkedOutResources = factory.createCoResourcesFromReference(dvActivity, VfsXcmProperty.ACTIVITY_CONTENT_SET.getCompletePropertyName());
                if (checkedOutResources != null && checkedOutResources.length > 0) {
                    checkedOutResources[0].remove();
                    activity.removeActivityElement(folderItem);
                    activity.delete();
                }
            }
            catch (Exception e1) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e1);
            }
            throw e;
        }
        URL urlOfUndeletedResource = null;
        try {
            urlOfUndeletedResource = new URL(urlInWorkspace);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("Internal error: invalid URL: " + urlOfUndeletedResource);
        }
        IVfsRemoteLocator remoteLocatorOfUndeletedResource = this.getContext().getRemoteLocatorFromUrl(urlInWorkspace);
        String absoluteLocalPath = this.getContext().getAbsoluteLocalPath(remoteLocatorOfUndeletedResource.getConnectionTemplateId(), remoteLocatorOfUndeletedResource.getAbsoluteRemotePath());
        folderItem = (VfsActivityRecordedFolderItem)this.getVfsManager().getFolderItem(absoluteLocalPath).asActivityRecordedFolderItem();
        folderItem.sync();
        return folderItem;
    }

    void solveNameClashByDeletingInactiveVcr(VfsIntegrateCollision integrateCollision, String activityDisplayName, String activityDescription) throws VfsException {
        ICheckedOutResource dvCheckedOutResource;
        IVersionControlledResource dvInactiveResource;
        String inactiveVcrPath;
        String string = inactiveVcrPath = integrateCollision == null ? null : integrateCollision.getInactiveVcrPath();
        if (inactiveVcrPath == null || inactiveVcrPath.length() == 0) {
            IllegalArgumentException e = new IllegalArgumentException("Null integrate collision as argument for deletion of inactive VCR");
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            throw e;
        }
        if (integrateCollision.getWorkspace() != this) {
            IllegalStateException e = new IllegalStateException("Invalid integrate collision as argument for deletion of inactive VCR");
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            throw e;
        }
        IResourceFactory dvFactory = ResourceFactoryManager.getInstance().getProxyFactory();
        try {
            dvInactiveResource = dvFactory.createResource(this.getConnectionTemplateId(), inactiveVcrPath, PathEncodingFlag.DECODED).getAsVersionControlled();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Get DeltaV resource for inactive DeltaV resource failed: " + inactiveVcrPath);
        }
        VfsActivity activity = this.createActivity("default_nameclash_deletion", activityDisplayName, activityDisplayName, activityDescription);
        IActivity[] singleActivityArray = new IActivity[]{activity.getDeltaVActivity()};
        try {
            dvCheckedOutResource = dvInactiveResource.getAsCheckedIn().checkout(singleActivityArray, 2);
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.SUCCEEDED, dvCheckedOutResource, "Checked-out for delete inactive DeltaV resource");
        }
        catch (VcmFailure vcmFailure) {
            VfsException e = new VfsException("Checkout inactive DeltaV resource failed: " + vcmFailure.getMessage(), vcmFailure);
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, dvInactiveResource, e.getMessage());
            activity.delete();
            throw e;
        }
        IMutableProperty property = PropertyFactoryAccess.getFactory().createProperty(VfsXcmProperty.getNamespacePrefix(), VfsXcmProperty.DELETED.getPropertyName());
        property.setValue("T");
        IProperty[] properties = new IProperty[]{property};
        try {
            dvCheckedOutResource.setProperties(properties);
        }
        catch (VcmFailure vcmFailure) {
            VfsException e = new VfsException("Set deletion property on DeltaV resource failed: " + vcmFailure.getMessage(), vcmFailure);
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, dvInactiveResource, e.getMessage());
            try {
                dvCheckedOutResource.remove();
                activity.delete();
            }
            catch (Exception e1) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e1);
            }
            throw e;
        }
        try {
            this.checkInSpecialActionActivity(activity);
        }
        catch (VfsException e) {
            try {
                dvCheckedOutResource.remove();
                activity.delete();
            }
            catch (Exception e1) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e1);
            }
            throw e;
        }
        VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)integrateCollision.getActiveVersionFolderItem();
        folderItem.setDvReplacingVcr(null);
    }

    public boolean isReleased() {
        return this.m_vfsManager == null || this.m_vfsManager.isReleased();
    }

    void refreshForMountPointDeletion() throws VfsException {
        super.refreshForMountPointDeletion();
        int numberOfRemovedFolderItems = 0;
        int i = 0;
        while (i < this.m_folderItems.length) {
            if (VfsActivityRecordedFolderItem.shouldFolderItemBeInvalidDueToMountPointDeletion(this.m_folderItems[i])) {
                this.m_folderItems[i] = null;
                ++numberOfRemovedFolderItems;
            }
            ++i;
        }
        if (numberOfRemovedFolderItems > 0) {
            VfsFolderItem[] folderItems = new VfsFolderItem[this.m_folderItems.length - numberOfRemovedFolderItems];
            int i2 = 0;
            int j = 0;
            while (i2 < this.m_folderItems.length) {
                if (this.m_folderItems[i2] != null) {
                    folderItems[j] = this.m_folderItems[i2];
                    ++j;
                }
                ++i2;
            }
            this.m_folderItems = folderItems;
            this.getVfsManager().fireEventFolderItemsAddedOrRemoved(this);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

