/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.IVersion;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.ResourceFactoryManager;
import com.tssap.dtr.client.lib.deltavlib.xcm.CollisionState;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICollisionProxy;
import com.tssap.dtr.client.lib.deltavlib.xcm.IPersistentCollision;
import com.tssap.dtr.client.lib.deltavlib.xcm.VersionRelation;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersionRelation;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsVersionRelationType;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.impl.VfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.impl.VfsRepository;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersion;
import java.util.Date;

public class VfsVersionRelation
implements IVfsVersionRelation {
    private final String m_targetVersionPath;
    private final VfsVersionRelationType m_relationType;
    private final Date m_creationDate;
    private final IVfsVersion m_sourceVersion;
    private IVfsVersion m_targetVersion;
    private final VersionRelation m_dvRelation;
    private boolean m_visible;
    private IVfsIntegrateCollision m_collision;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$VfsVersionRelation == null ? (class$com$tssap$dtr$client$lib$vfs$impl$VfsVersionRelation = VfsVersionRelation.class$("com.tssap.dtr.client.lib.vfs.impl.VfsVersionRelation")) : class$com$tssap$dtr$client$lib$vfs$impl$VfsVersionRelation));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$VfsVersionRelation;

    public VfsVersionRelation(VersionRelation deltavRelation, IVfsVersion sourceVersion, IVfsVersion targetVersion) {
        this.m_relationType = VfsVersionRelationType.getRelationType(deltavRelation.getRelationType());
        this.m_creationDate = deltavRelation.getCreationDate();
        this.m_sourceVersion = sourceVersion;
        this.m_targetVersion = targetVersion;
        this.m_dvRelation = deltavRelation;
        this.m_targetVersionPath = this.m_dvRelation.getVersionPath();
        this.m_visible = true;
        this.m_collision = null;
    }

    public String getTargetVersionPath() {
        return this.m_targetVersionPath;
    }

    public VfsVersionRelationType getRelationType() {
        return this.m_relationType;
    }

    public Date getRelationCreationDate() {
        return this.m_creationDate;
    }

    public IVfsActivity getCreatingActivity() {
        if (this.m_relationType != VfsVersionRelationType.DISCARD_MERGE) {
            if (this.m_targetVersion == null) {
                this.m_targetVersion = this.m_sourceVersion.getVersionHistory().getVersion(this.m_dvRelation.getTargetId());
            }
            return this.m_targetVersion.getCreatingActivity();
        }
        try {
            String activityPath = this.m_dvRelation.getCreatingActivityPath();
            IVfsVersion version = this.m_targetVersion == null ? this.m_sourceVersion : this.m_targetVersion;
            VersionedFileSystemManager vfsManager = (VersionedFileSystemManager)version.getVersionedFileSystemManager();
            VfsRepository repository = vfsManager.getRepositoryByConnectionTemplateId(((VfsVersion)version).getDvVersion().getConnectionTemplID());
            IVfsActivity activity = repository.getActivityFromRepository(activityPath);
            return activity;
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return null;
        }
    }

    public IVfsIntegrateCollision getIntegrateCollision() {
        if (this.m_collision == null) {
            IVfsVersion version = this.m_targetVersion == null ? this.m_sourceVersion : this.m_targetVersion;
            VersionedFileSystemManager vfsManager = (VersionedFileSystemManager)version.getVersionedFileSystemManager();
            try {
                IPersistentCollision dvCollision = this.m_dvRelation.getCollisionProxy().getCollision();
                IVfsWorkspace workspace = vfsManager.getWorkspaceByUrl(dvCollision.getWorkspace().getPersistentURL());
                this.m_collision = workspace.getIntegrateCollision(dvCollision.getCollisionResource().getPath());
                if (this.m_collision == null) {
                    this.m_collision = new VfsIntegrateCollision(vfsManager, dvCollision, workspace);
                    workspace.addToIntegrateCollisionCache(this.m_collision);
                }
            }
            catch (VcmFailure e) {
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, null, "get Integrate Collision failed: " + e.getMessage());
            }
        } else {
            this.m_collision = this.m_collision.getWorkspace().getIntegrateCollision(this.m_collision.getPath());
        }
        return this.m_collision;
    }

    public String getCreator() {
        return null;
    }

    public boolean isVisibleInWorkspace(String workspacePath) {
        if (this.m_relationType.equals(VfsVersionRelationType.PRED_SUCC_COLLISION) || this.m_relationType.equals(VfsVersionRelationType.CYCLIC_MERGE_COLLISION)) {
            ICollisionProxy collisionProxy = this.m_dvRelation.getCollisionProxy();
            if (collisionProxy.getState() == CollisionState.OPEN) {
                return PathUtilities.assureTrailingSeparator(collisionProxy.getWorkspacePath(), PathUtilities.REMOTE_FILESERVICE).equalsIgnoreCase(PathUtilities.assureTrailingSeparator(workspacePath, PathUtilities.REMOTE_FILESERVICE));
            }
            return false;
        }
        if (this.m_relationType.equals(VfsVersionRelationType.DISCARD_MERGE)) {
            String[] visibleInWorkspaces = this.m_dvRelation.getDiscardMergeVisibleInWorkspaceSet();
            if (visibleInWorkspaces != null) {
                int i = 0;
                while (i < visibleInWorkspaces.length) {
                    if (PathUtilities.assureTrailingSeparator(workspacePath, PathUtilities.REMOTE_FILESERVICE).endsWith(PathUtilities.assureTrailingSeparator(visibleInWorkspaces[i], PathUtilities.REMOTE_FILESERVICE))) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return true;
        }
        return this.m_visible;
    }

    public void setAsVisible(boolean visible) {
        this.m_visible = visible;
    }

    public String getURL() {
        return this.m_dvRelation.getRelationResourcePath();
    }

    public String getSourceVersionId() {
        return this.m_dvRelation.getSourceId();
    }

    public String getTargetVersionId() {
        return this.m_dvRelation.getTargetId();
    }

    public IVfsVersion getSourceVersion() {
        if (this.m_sourceVersion == null) {
            int conTemplId = ((VfsVersion)this.m_targetVersion).getDvVersion().getConnectionTemplID();
            try {
                IVersion dvVersion = ResourceFactoryManager.getInstance().getProxyFactory().createVersion(conTemplId, this.m_dvRelation.getSourceHref());
                return new VfsVersion((VersionedFileSystemManager)this.m_targetVersion.getVersionedFileSystemManager(), dvVersion);
            }
            catch (VcmFailure e) {
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, null, "get Source version failed: " + e.getMessage());
                return null;
            }
        }
        return this.m_sourceVersion;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

