/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.IVersion;
import com.tssap.dtr.client.lib.deltavlib.IVersionHistory;
import com.tssap.dtr.client.lib.deltavlib.IWorkingResource;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.xcm.IEnhancedVersion;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsRevision;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersionGraph;
import com.tssap.dtr.client.lib.vfs.IVfsVersionHistory;
import com.tssap.dtr.client.lib.vfs.IVfsVersionRelation;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VersionedFileSystemFactory;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsRevisionComparator;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivity;
import com.tssap.dtr.client.lib.vfs.impl.VfsRevision;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersion;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersionGraph;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

class VfsVersionHistory
implements IVfsVersionHistory {
    private final IVersionHistory m_versionHistory;
    private HashMap m_allVersions;
    private VersionedFileSystemManager m_vfsManager = null;
    private HashMap m_workspaceRevisionSets;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$VfsVersionHistory == null ? (class$com$tssap$dtr$client$lib$vfs$impl$VfsVersionHistory = VfsVersionHistory.class$("com.tssap.dtr.client.lib.vfs.impl.VfsVersionHistory")) : class$com$tssap$dtr$client$lib$vfs$impl$VfsVersionHistory));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$VfsVersionHistory;

    public VfsVersionHistory(VersionedFileSystemManager vfsManager, IVersionHistory versionHistory) throws VfsException {
        this.m_vfsManager = vfsManager;
        this.m_versionHistory = versionHistory;
        this.setInternalCollections();
    }

    public IVfsVersion[] getVersionSet() {
        this.getVfsManager().checkState();
        try {
            IEnhancedVersion[] versionSet = this.m_versionHistory.getEnhancedVersionSet();
            IVfsVersion[] vfsVersionSet = new IVfsVersion[versionSet.length];
            int i = 0;
            while (i < versionSet.length) {
                vfsVersionSet[i] = new VfsVersion(this.getVfsManager(), versionSet[i], this);
                ++i;
            }
            return vfsVersionSet;
        }
        catch (VcmFailure e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return null;
        }
    }

    public IVfsVersion getRootVersion() {
        this.getVfsManager().checkState();
        try {
            IEnhancedVersion rootVersion = (IEnhancedVersion)this.m_allVersions.get(this.m_versionHistory.getRootVersion().getVersionId());
            if (rootVersion != null) {
                return new VfsVersion(this.getVfsManager(), rootVersion, this);
            }
            return null;
        }
        catch (VcmFailure e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return null;
        }
    }

    public IVfsVersion getActiveVersion(IVfsWorkspace workspace) {
        this.getVfsManager().checkState();
        this.checkParameterState(workspace);
        return this.getActiveVersion(workspace.getAbsoluteRemotePath());
    }

    public IVfsVersion getActiveVersion(String workspaceRemotePath) {
        this.getVfsManager().checkState();
        ArrayList revisionsInWorkspace = (ArrayList)this.m_workspaceRevisionSets.get(workspaceRemotePath);
        if (revisionsInWorkspace == null || revisionsInWorkspace.size() == 0) {
            return null;
        }
        Collections.sort(revisionsInWorkspace, new VfsRevisionComparator(workspaceRemotePath));
        return ((IVfsRevision)revisionsInWorkspace.get(0)).getVersion();
    }

    public String getPath() {
        this.getVfsManager().checkState();
        return this.m_versionHistory.getDecodedPath();
    }

    public void refreshVersionSet() {
        this.getVfsManager().checkState();
        try {
            this.m_versionHistory.refreshVersionSet();
            this.setInternalCollections();
        }
        catch (VcmFailure e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
    }

    private void setInternalCollections() {
        try {
            this.m_allVersions = new HashMap();
            IEnhancedVersion[] versionSet = this.m_versionHistory.getEnhancedVersionSet();
            int i = 0;
            while (i < versionSet.length) {
                this.m_allVersions.put(versionSet[i].getVersionId(), versionSet[i]);
                ++i;
            }
            this.createWorkspaceRevisionSets();
        }
        catch (VcmFailure e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
    }

    public IVfsVersion getVersionInClientWorkspace(IVfsWorkspace workspace) {
        this.getVfsManager().checkState();
        this.checkParameterState(workspace);
        try {
            VfsVersion rootVersion = (VfsVersion)this.getRootVersion();
            String vcrPath = rootVersion.getVcrPathForWorkspace(workspace);
            IVersionedFileSystemManager manager = VersionedFileSystemFactory.getVersionedFileSystemManager(workspace.getContext());
            String absoluteLocalPath = workspace.getContext().getAbsoluteLocalPath(rootVersion.getDvVersion().getConnectionTemplID(), vcrPath);
            if (absoluteLocalPath == null) {
                return null;
            }
            IVfsFolderItem folderItem = manager.getFolderItem(absoluteLocalPath);
            if (folderItem == null) {
                return null;
            }
            IVfsVersion syncdVersion = folderItem.asFile().getSyncedVersion();
            if (syncdVersion == null) {
                return null;
            }
            if ((syncdVersion = this.getVersion(((VfsVersion)syncdVersion).getVersionId())) == null) {
                return null;
            }
            if (!folderItem.asFile().getActivityState().equals(VfsFolderItemActivityState.NOT_CHECKED_OUT)) {
                IVfsVersionRelation[] successorRelations = syncdVersion.getSuccessorRelationSet();
                int i = 0;
                while (i < successorRelations.length) {
                    IVfsVersion successor = this.getVersion(successorRelations[i].getTargetVersionId());
                    if (successor != null && successor.isOpen() && successor.isSyncedOnClient(workspace)) {
                        syncdVersion = successor;
                        break;
                    }
                    ++i;
                }
            }
            return syncdVersion;
        }
        catch (VfsException vfsException) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vfsException);
            return null;
        }
        catch (Exception exception) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)exception);
            return null;
        }
    }

    public IVfsVersion getLatestVersion(IVfsActivity activity) {
        this.getVfsManager().checkState();
        this.checkParameterState(activity);
        try {
            IVersion deltavVersion = this.m_versionHistory.getLatestVersion(((VfsActivity)activity).getDeltaVActivity());
            IEnhancedVersion enhancedVersion = (IEnhancedVersion)this.m_allVersions.get(deltavVersion.getVersionId());
            return new VfsVersion(this.getVfsManager(), enhancedVersion, this);
        }
        catch (VcmFailure e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return null;
        }
    }

    public IVfsVersion getVersion(String versionId) {
        this.getVfsManager().checkState();
        IEnhancedVersion version = (IEnhancedVersion)this.m_allVersions.get(versionId);
        if (version != null) {
            return new VfsVersion(this.getVfsManager(), version, this);
        }
        return null;
    }

    public IVersionedFileSystemManager getVersionedFileSystemManager() {
        return this.getVfsManager();
    }

    public VersionedFileSystemManager getVfsManager() {
        if (this.m_vfsManager == null || this.m_vfsManager.isReleased()) {
            throw new IllegalStateException("Versioned file system manager was released");
        }
        return this.m_vfsManager;
    }

    private void checkParameterState(IVfsWorkspace workspace) {
        if (workspace.getVersionedFileSystemManager() != this.getVersionedFileSystemManager()) {
            throw new IllegalArgumentException("Internal error: parameter with different versioned file system manager");
        }
    }

    private void checkParameterState(IVfsActivity activity) {
        if (activity.getVersionedFileSystemManager() != this.getVersionedFileSystemManager()) {
            throw new IllegalArgumentException("Internal error: parameter with different versioned file system manager");
        }
    }

    static IVersion preliminary__getLatestPredecessor(IWorkingResource dvWorkingResource, VfsWorkspace workspace) throws VfsException {
        VfsVersion latestPredecessor = null;
        IVersion[] dvVersions = new IVersion[]{};
        try {
            dvVersions = dvWorkingResource.getPredecessorSet();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Accessing DeltaV working resource failed", vcmFailure);
        }
        if (dvVersions.length == 0) {
            throw new VfsException("Predecessor set is empty");
        }
        if (dvVersions.length == 1) {
            latestPredecessor = new VfsVersion(workspace.getVfsManager(), dvVersions[0]);
        } else {
            String workspacePath = workspace.getAbsoluteRemotePath();
            IVfsVersionHistory versionHistory = new VfsVersion(workspace.getVfsManager(), dvVersions[0]).getVersionHistoryWithRefresh();
            int maxRevisionNumber = 0;
            VfsVersion versionWithMaxRevisionNumber = null;
            int i = 0;
            while (i < dvVersions.length) {
                VfsVersion version = new VfsVersion(workspace.getVfsManager(), dvVersions[i]);
                int revisionNumber = versionHistory.getRevisionNumber(version, workspacePath);
                if (revisionNumber > maxRevisionNumber) {
                    maxRevisionNumber = revisionNumber;
                    versionWithMaxRevisionNumber = version;
                }
                ++i;
            }
            latestPredecessor = versionWithMaxRevisionNumber;
        }
        return latestPredecessor.getDvVersion();
    }

    public IVfsVersion getClosedVersionWithMaxSequenceNumber(IVfsWorkspace workspace) {
        VfsVersionGraph vGraph = new VfsVersionGraph(this);
        IVfsVersionGraph.IVfsLineOfDescent lineOfDescent = vGraph.getDescentLine(workspace.getAbsoluteRemotePath());
        if (lineOfDescent == null) {
            return null;
        }
        IVfsVersionGraph.IVfsVersionElement[] rootElements = lineOfDescent.getRootElements();
        IVfsVersionGraph.IVfsVersionElement closedRootElement = null;
        int i = 0;
        while (i < rootElements.length) {
            if (!rootElements[i].getVersion().isOpen()) {
                closedRootElement = rootElements[i];
            }
            ++i;
        }
        if (closedRootElement == null) {
            return null;
        }
        IVfsVersionGraph.IVfsVersionElement lastElementInLineOfDescent = closedRootElement;
        while (lastElementInLineOfDescent.getLineSuccessors().size() > 0) {
            IVfsVersionGraph.IVfsVersionElement firstLineSuccessor = (IVfsVersionGraph.IVfsVersionElement)lastElementInLineOfDescent.getLineSuccessors().get(0);
            if (!firstLineSuccessor.getVersion().isOpen()) {
                lastElementInLineOfDescent = firstLineSuccessor;
                continue;
            }
            return lastElementInLineOfDescent.getVersion();
        }
        return lastElementInLineOfDescent.getVersion();
    }

    private void createWorkspaceRevisionSets() {
        this.m_workspaceRevisionSets = new HashMap();
        VersionedFileSystemManager vfsManager = this.getVfsManager();
        Iterator iter = this.m_allVersions.values().iterator();
        while (iter.hasNext()) {
            IEnhancedVersion dvVersion = (IEnhancedVersion)iter.next();
            VfsVersion vfsVersion = new VfsVersion(vfsManager, dvVersion, this);
            if (vfsVersion.isOpen()) continue;
            String[] visibleWorkspaces = vfsVersion.getActivatedInWorkspaceSet();
            int i = 0;
            while (i < visibleWorkspaces.length) {
                ArrayList revisionsInWorkspace = (ArrayList)this.m_workspaceRevisionSets.get(PathUtilities.assureTrailingSeparator(visibleWorkspaces[i], PathUtilities.REMOTE_FILESERVICE));
                if (revisionsInWorkspace == null) {
                    ArrayList<VfsRevision> revisions = new ArrayList<VfsRevision>();
                    int[] ISNs = vfsVersion.getISNs(visibleWorkspaces[i]);
                    int j = 0;
                    while (j < ISNs.length) {
                        revisions.add(new VfsRevision(vfsVersion, ISNs[j], visibleWorkspaces[i]));
                        ++j;
                    }
                    this.m_workspaceRevisionSets.put(PathUtilities.assureTrailingSeparator(visibleWorkspaces[i], PathUtilities.REMOTE_FILESERVICE), revisions);
                } else {
                    int[] ISNs = vfsVersion.getISNs(visibleWorkspaces[i]);
                    int j = 0;
                    while (j < ISNs.length) {
                        revisionsInWorkspace.add(new VfsRevision(vfsVersion, ISNs[j], visibleWorkspaces[i]));
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public IVfsRevision[] getRevisionsInWorkspace(String workspacePath) {
        if (workspacePath == null) {
            return new IVfsRevision[0];
        }
        ArrayList revisionsInWorkspace = (ArrayList)this.m_workspaceRevisionSets.get(workspacePath);
        if (revisionsInWorkspace == null || revisionsInWorkspace.size() == 0) {
            return new IVfsRevision[0];
        }
        Collections.sort(revisionsInWorkspace, new VfsRevisionComparator(workspacePath));
        return revisionsInWorkspace.toArray(new IVfsRevision[revisionsInWorkspace.size()]);
    }

    public int getRevisionNumber(IVfsVersion version, String workspacePath) {
        if (version == null || workspacePath == null) {
            return 0;
        }
        ArrayList revisionsInWorkspace = (ArrayList)this.m_workspaceRevisionSets.get(workspacePath);
        if (revisionsInWorkspace == null || revisionsInWorkspace.size() == 0) {
            return 0;
        }
        if (version.isOpen()) {
            return revisionsInWorkspace.size() + 1;
        }
        Collections.sort(revisionsInWorkspace, new VfsRevisionComparator(workspacePath));
        IVfsRevision[] revisions = revisionsInWorkspace.toArray(new IVfsRevision[revisionsInWorkspace.size()]);
        int i = 0;
        while (i < revisions.length) {
            if (revisions[i].getVersion().equals(version)) {
                return revisions.length - i;
            }
            ++i;
        }
        return 0;
    }

    public IVfsVersion[] getVersionsInWorkspace(String workspacePath) {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

