/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersionGraph;
import com.tssap.dtr.client.lib.vfs.IVfsVersionHistory;
import com.tssap.dtr.client.lib.vfs.IVfsVersionRelation;
import com.tssap.dtr.client.lib.vfs.VfsVersionRelationType;
import com.tssap.dtr.client.lib.vfs.impl.Util;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class VfsVersionGraph
implements IVfsVersionGraph {
    private final IVfsVersionHistory m_versionHistory;
    private final HashMap m_descentLines;
    private final IVfsVersionGraph.IVfsLineOfDescent m_rootLine;
    private int m_currentDisplacement;
    private final HashMap m_allElements;
    private final HashMap m_branchPoints;
    private final HashMap m_visitorNodes;
    private final HashMap m_versionsWithMultipleLineSuccessors;
    private static final IVfsVersion[] NULL_VERSION_ARRAY = new IVfsVersion[0];
    private static final boolean DEBUG_MODE = false;

    public VfsVersionGraph(IVfsVersionHistory vh) {
        this.m_versionHistory = vh;
        this.m_currentDisplacement = 0;
        this.m_allElements = new HashMap();
        this.m_branchPoints = new HashMap();
        this.m_versionsWithMultipleLineSuccessors = new HashMap();
        this.m_visitorNodes = new HashMap();
        this.m_descentLines = new HashMap();
        IVfsVersion[] rootVersions = new IVfsVersion[]{vh.getRootVersion()};
        this.m_rootLine = new VfsLineOfDescent(vh, rootVersions, 1, null);
        this.m_descentLines.put(vh.getRootVersion().getCreatorWorkspaceName(), this.m_rootLine);
        Iterator it = this.m_descentLines.values().iterator();
        while (it.hasNext()) {
            int pushCount;
            IVfsVersionGraph.IVfsLineOfDescent currentLine = (IVfsVersionGraph.IVfsLineOfDescent)it.next();
            IVfsVersionGraph.IVfsVersionElement element = (IVfsVersionGraph.IVfsVersionElement)this.m_versionsWithMultipleLineSuccessors.get(currentLine.getWorkspaceName());
            if (element != null) {
                pushCount = element.getLineSuccessors().size() - 1;
                this.pushLines(currentLine.getStartDisplacement(), pushCount);
                currentLine.setContainedDisplacements(element.getLineSuccessors().size());
                continue;
            }
            if (currentLine.getRootElements().length <= 1) continue;
            pushCount = currentLine.getRootElements().length - 1;
            this.pushLines(currentLine.getStartDisplacement(), pushCount);
            currentLine.setContainedDisplacements(currentLine.getRootElements().length);
        }
    }

    private void pushLines(int startDisplacement, int pushCount) {
        Iterator it = this.m_descentLines.values().iterator();
        while (it.hasNext()) {
            IVfsVersionGraph.IVfsLineOfDescent currentLine = (IVfsVersionGraph.IVfsLineOfDescent)it.next();
            if (currentLine.getStartDisplacement() <= startDisplacement) continue;
            ((VfsLineOfDescent)currentLine).pushStartDisplacement(pushCount);
        }
    }

    public IVfsVersionGraph.IVfsLineOfDescent getRootLine() {
        return this.m_rootLine;
    }

    public IVfsVersionGraph.IVfsLineOfDescent getDescentLine(String workspaceName) {
        return (IVfsVersionGraph.IVfsLineOfDescent)this.m_descentLines.get(Util.assureTrailingSlash(workspaceName));
    }

    public HashMap getDescentLines() {
        return this.m_descentLines;
    }

    class VfsLineOfDescent
    implements IVfsVersionGraph.IVfsLineOfDescent {
        private final ArrayList m_rootElements = new ArrayList();
        private final String m_workspaceName;
        private final int m_startLevel;
        private int m_startDisplacement;
        private final IVfsVersionGraph.IVfsLineOfDescent m_parentLine;
        private int m_containedDisplacements;

        VfsLineOfDescent(IVfsVersionHistory vh, IVfsVersion[] rootVersions, int startLevel, IVfsVersionGraph.IVfsLineOfDescent parent) {
            int j = 0;
            while (j < rootVersions.length) {
                this.m_rootElements.add(this.getElement(rootVersions[j]));
                ++j;
            }
            this.m_startLevel = startLevel;
            this.m_startDisplacement = parent != null ? VfsVersionGraph.this.m_currentDisplacement : 0;
            this.m_parentLine = parent;
            this.m_containedDisplacements = 1;
            this.m_workspaceName = rootVersions[0].getCreatorWorkspaceName();
            IVfsVersion[] versions = vh.getVersionSet();
            if (this.m_parentLine == null) {
                int i = 0;
                int n = versions.length;
                while (i < n) {
                    this.add(versions[i]);
                    ++i;
                }
            }
            Iterator it = VfsVersionGraph.this.m_branchPoints.values().iterator();
            while (it.hasNext()) {
                IVfsVersionGraph.IVfsBranchPoint branchPt = (IVfsVersionGraph.IVfsBranchPoint)it.next();
                if (!branchPt.getSourceVersion().getCreatorWorkspaceName().equalsIgnoreCase(this.m_workspaceName)) continue;
                int sourceLevel = branchPt.getSourceVersion().getBranchSequenceNumber();
                int thisLevel = sourceLevel + this.m_startLevel - 1;
                VfsVersionGraph.this.m_currentDisplacement++;
                VfsLineOfDescent nextLine = new VfsLineOfDescent(vh, branchPt.getTargetVersions(), thisLevel + 1, this);
                ((VfsBranchPoint)branchPt).setTargetLineOfDescent(nextLine);
                VfsVersionGraph.this.m_descentLines.put(branchPt.getTargetVersions()[0].getCreatorWorkspaceName(), nextLine);
            }
        }

        void add(IVfsVersion version) {
            IVfsVersionGraph.IVfsVersionElement maxSuccessorElement;
            VfsVersionElement element = (VfsVersionElement)this.getElement(version);
            IVfsVersionRelation[] succRelationSet = version.getSuccessorRelationSet();
            if (succRelationSet.length == 0) {
                return;
            }
            IVfsVersion[] lineSuccSet = this.GetLineSuccessorSetAndLocateBranchPoints(version);
            if (lineSuccSet.length > 1 && ((maxSuccessorElement = (IVfsVersionGraph.IVfsVersionElement)VfsVersionGraph.this.m_versionsWithMultipleLineSuccessors.get(version.getCreatorWorkspaceName())) == null || maxSuccessorElement.getLineSuccessors().size() < lineSuccSet.length)) {
                VfsVersionGraph.this.m_versionsWithMultipleLineSuccessors.put(version.getCreatorWorkspaceName(), element);
            }
            int i = 0;
            while (i < succRelationSet.length) {
                IVfsVersion successorVersion = VfsVersionGraph.this.m_versionHistory.getVersion(succRelationSet[i].getTargetVersionId());
                VfsVersionElement child = (VfsVersionElement)this.getElement(successorVersion);
                element.addSuccessor(child);
                if (succRelationSet[i].getRelationType() == VfsVersionRelationType.PRED_SUCC) {
                    element.addLineSuccessor(child);
                }
                child.addPredecessor(element);
                ++i;
            }
        }

        IVfsVersion[] GetLineSuccessorSetAndLocateBranchPoints(IVfsVersion sourceVersion) {
            ArrayList<IVfsVersion> lineSuccessors = new ArrayList<IVfsVersion>();
            IVfsVersionRelation[] allSuccessorRelations = sourceVersion.getSuccessorRelationSet();
            if (allSuccessorRelations != null && allSuccessorRelations.length > 0) {
                int i = 0;
                while (i < allSuccessorRelations.length) {
                    VfsVersionRelationType successorRelationType = allSuccessorRelations[i].getRelationType();
                    if (successorRelationType != null) {
                        IVfsVersion successorVersion = VfsVersionGraph.this.m_versionHistory.getVersion(allSuccessorRelations[i].getTargetVersionId());
                        if (successorRelationType == VfsVersionRelationType.BRANCH) {
                            if (VfsVersionGraph.this.m_branchPoints.get(successorVersion.getCreatorWorkspaceName()) == null) {
                                VfsVersionGraph.this.m_branchPoints.put(successorVersion.getCreatorWorkspaceName(), new VfsBranchPoint(sourceVersion, successorVersion, null, String.valueOf(sourceVersion.getBranchSequenceNumber())));
                            } else {
                                VfsBranchPoint existingBranchPoint = (VfsBranchPoint)VfsVersionGraph.this.m_branchPoints.get(successorVersion.getCreatorWorkspaceName());
                                existingBranchPoint.m_targetVersions.add(successorVersion);
                            }
                        } else if (successorRelationType == VfsVersionRelationType.PRED_SUCC) {
                            lineSuccessors.add(successorVersion);
                        }
                    }
                    ++i;
                }
                return lineSuccessors.toArray(new IVfsVersion[lineSuccessors.size()]);
            }
            return NULL_VERSION_ARRAY;
        }

        public IVfsVersionGraph.IVfsLevelIterator getLevelIterator() {
            return new VfsLevelIterator();
        }

        public void applyVisitor(IVfsVersionGraph.IVfsLinkVisitor visitor) {
            if (this.m_parentLine != null) {
                return;
            }
            LinkedList queue = new LinkedList();
            queue.add(this.m_rootElements.get(0));
            while (!queue.isEmpty()) {
                IVfsVersionGraph.IVfsVersionElement from = (IVfsVersionGraph.IVfsVersionElement)queue.removeFirst();
                Iterator it = ((AbstractList)from.getSuccessors()).iterator();
                while (it.hasNext()) {
                    IVfsVersionGraph.IVfsVersionElement to = (IVfsVersionGraph.IVfsVersionElement)it.next();
                    IVfsVersionRelation[] versionRelations = from.getVersion().getSuccessorRelations(to.getVersion());
                    int i = 0;
                    while (i < versionRelations.length) {
                        visitor.oneMoreLink(from, to, versionRelations[i]);
                        ++i;
                    }
                    if (VfsVersionGraph.this.m_visitorNodes.get(to.getVersion().getUrl()) != null) continue;
                    queue.add(to);
                    VfsVersionGraph.this.m_visitorNodes.put(to.getVersion().getUrl(), to);
                }
            }
        }

        private boolean isVisible(IVfsVersionRelation versionRelation) {
            return versionRelation != null;
        }

        IVfsVersionGraph.IVfsVersionElement getElement(IVfsVersion version) {
            IVfsVersionGraph.IVfsVersionElement elem;
            String key = this.createKey(version);
            if (!VfsVersionGraph.this.m_allElements.containsKey(key)) {
                elem = new VfsVersionElement(version);
                VfsVersionGraph.this.m_allElements.put(key, elem);
            } else {
                elem = (IVfsVersionGraph.IVfsVersionElement)VfsVersionGraph.this.m_allElements.get(key);
                ((VfsVersionElement)elem).setVersion(version);
            }
            return elem;
        }

        private String createKey(IVfsVersion version) {
            return version.getUrl();
        }

        public IVfsVersionGraph.IVfsBranchPoint[] getBranchPoints() {
            return VfsVersionGraph.this.m_branchPoints.values().toArray(new IVfsVersionGraph.IVfsBranchPoint[VfsVersionGraph.this.m_branchPoints.size()]);
        }

        public int getContainedDisplacements() {
            return this.m_containedDisplacements;
        }

        public void setContainedDisplacements(int displacement) {
            this.m_containedDisplacements = displacement;
        }

        public IVfsVersionGraph.IVfsLineOfDescent getParentLine() {
            return this.m_parentLine;
        }

        public IVfsVersionGraph.IVfsVersionElement[] getRootElements() {
            return this.m_rootElements.toArray(new IVfsVersionGraph.IVfsVersionElement[this.m_rootElements.size()]);
        }

        public int getStartDisplacement() {
            return this.m_startDisplacement;
        }

        void pushStartDisplacement(int pushCount) {
            this.m_startDisplacement += pushCount;
        }

        public int getStartLevel() {
            return this.m_startLevel;
        }

        public String getWorkspaceName() {
            return this.m_workspaceName;
        }

        class VfsVersionElement
        implements IVfsVersionGraph.IVfsVersionElement {
            private IVfsVersion version;
            private final ArrayList predecessors = new ArrayList(3);
            private final ArrayList successors = new ArrayList(3);
            private final ArrayList lineSuccessors = new ArrayList(3);
            private int level;
            private int displacement;
            private Object arbitraryData;

            VfsVersionElement() {
            }

            VfsVersionElement(IVfsVersion version) {
                this();
                this.version = version;
            }

            void addPredecessor(IVfsVersionGraph.IVfsVersionElement elem) {
                int i = 0;
                while (i < this.predecessors.size()) {
                    if (this.predecessors.get(i).equals(elem)) {
                        return;
                    }
                    ++i;
                }
                this.predecessors.add(elem);
            }

            void addSuccessor(IVfsVersionGraph.IVfsVersionElement elem) {
                int i = 0;
                while (i < this.successors.size()) {
                    if (this.successors.get(i).equals(elem)) {
                        return;
                    }
                    ++i;
                }
                this.successors.add(elem);
            }

            void addLineSuccessor(IVfsVersionGraph.IVfsVersionElement elem) {
                if (!elem.getVersion().isOpen()) {
                    this.lineSuccessors.add(0, elem);
                } else {
                    this.lineSuccessors.add(elem);
                }
            }

            public void setLevel(int level) {
                this.level = level;
            }

            public void setDisplacement(int displacement) {
                this.displacement = displacement;
            }

            public IVfsVersion getVersion() {
                return this.version;
            }

            void setVersion(IVfsVersion version) {
                this.version = version;
            }

            public void setUIElement(Object data) {
                this.arbitraryData = data;
            }

            public Object getUIElement() {
                return this.arbitraryData;
            }

            public ArrayList getLineSuccessors() {
                return this.lineSuccessors;
            }

            public ArrayList getSuccessors() {
                return this.successors;
            }

            public ArrayList getPredecessors() {
                return this.predecessors;
            }
        }

        class VfsBranchPoint
        implements IVfsVersionGraph.IVfsBranchPoint {
            private final IVfsVersion m_sourceVersion;
            private final ArrayList m_targetVersions;
            private IVfsVersionGraph.IVfsLineOfDescent m_targetDescentLine;
            private final int m_sourceLevel;

            VfsBranchPoint(IVfsVersion source, IVfsVersion target, IVfsVersionGraph.IVfsLineOfDescent targetLine, String srcLevel) {
                this.m_sourceVersion = source;
                this.m_targetVersions = new ArrayList();
                this.m_targetVersions.add(target);
                this.m_targetDescentLine = targetLine;
                this.m_sourceLevel = new Integer(srcLevel);
            }

            public int getSourceLevel() {
                return this.m_sourceLevel;
            }

            public IVfsVersion getSourceVersion() {
                return this.m_sourceVersion;
            }

            public IVfsVersion[] getTargetVersions() {
                return this.m_targetVersions.toArray(new IVfsVersion[this.m_targetVersions.size()]);
            }

            public IVfsVersionGraph.IVfsLineOfDescent getTargetLineOfDescent() {
                return this.m_targetDescentLine;
            }

            void setTargetLineOfDescent(IVfsVersionGraph.IVfsLineOfDescent targetLineOfDescent) {
                this.m_targetDescentLine = targetLineOfDescent;
            }
        }

        class VfsLevelIterator
        implements IVfsVersionGraph.IVfsLevelIterator {
            ArrayList currentLevelElements;
            int currentLevel;

            private VfsLevelIterator() {
            }

            public IVfsVersionGraph.IVfsVersionElement[] nextLevel() {
                ++this.currentLevel;
                if (this.currentLevelElements.isEmpty()) {
                    return new VfsVersionElement[0];
                }
                return this.currentLevelElements.toArray(new VfsVersionElement[this.currentLevelElements.size()]);
            }

            public boolean hasNextLevel() {
                if (this.currentLevelElements == null) {
                    this.currentLevelElements = new ArrayList();
                    this.currentLevel = VfsLineOfDescent.this.m_startLevel;
                    this.currentLevelElements.addAll(VfsLineOfDescent.this.m_rootElements);
                } else {
                    ArrayList newList = new ArrayList();
                    Iterator it = ((AbstractList)this.currentLevelElements).iterator();
                    while (it.hasNext()) {
                        ArrayList lineSuccessors = ((IVfsVersionGraph.IVfsVersionElement)it.next()).getLineSuccessors();
                        newList.addAll(lineSuccessors);
                    }
                    this.currentLevelElements = newList;
                }
                return !this.currentLevelElements.isEmpty();
            }

            public int getCurrentLevel() {
                return this.currentLevel;
            }
        }
    }
}

