/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.IActivity;
import com.tssap.dtr.client.lib.deltavlib.ICheckedOutResource;
import com.tssap.dtr.client.lib.deltavlib.IFile;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.IVersion;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.IVersionHistory;
import com.tssap.dtr.client.lib.deltavlib.IWorkingResource;
import com.tssap.dtr.client.lib.deltavlib.IWorkspace;
import com.tssap.dtr.client.lib.deltavlib.PathEncodingFlag;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.ResourceFactoryManager;
import com.tssap.dtr.client.lib.deltavlib.xcm.IEnhancedVersion;
import com.tssap.dtr.client.lib.deltavlib.xcm.IIntegration;
import com.tssap.dtr.client.lib.deltavlib.xcm.VersionRelation;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityElement;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsMergeVersion;
import com.tssap.dtr.client.lib.vfs.IVfsProperty;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersionHistory;
import com.tssap.dtr.client.lib.vfs.IVfsVersionRelation;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VersionedFileSystemFactory;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.VfsVersionRelationType;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivity;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivityElement;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsFile;
import com.tssap.dtr.client.lib.vfs.impl.VfsRepository;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersionHistory;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersionRelation;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspace;
import com.tssap.dtr.client.lib.vfs.impl.VfsXcmProperty;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;

public class VfsVersion
implements IVfsVersion {
    private static final String WORKING_RESOURCE = "WORKING_RESOURCE";
    private static final IVfsVersion[] NULL_VERSION_ARRAY = new IVfsVersion[0];
    private static final IVfsActivity[] NULL_ACTIVITY_ARRAY = new IVfsActivity[0];
    private static final IVfsVersionRelation[] NULL_VERSION_RELATION_ARRAY = new IVfsVersionRelation[0];
    private VersionedFileSystemManager m_vfsManager = null;
    private IVersion m_version;
    private IEnhancedVersion m_enhancedVersion;
    private IVfsVersionHistory m_versionHistory;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$VfsVersion == null ? (class$com$tssap$dtr$client$lib$vfs$impl$VfsVersion = VfsVersion.class$("com.tssap.dtr.client.lib.vfs.impl.VfsVersion")) : class$com$tssap$dtr$client$lib$vfs$impl$VfsVersion));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$VfsVersion;

    public VfsVersion(VersionedFileSystemManager vfsManager, IVersion version) {
        this.m_vfsManager = vfsManager;
        this.m_version = version;
        this.m_enhancedVersion = null;
        this.m_versionHistory = null;
    }

    public VfsVersion(VersionedFileSystemManager vfsManager, IEnhancedVersion version) {
        this.m_vfsManager = vfsManager;
        this.m_version = version;
        this.m_enhancedVersion = version;
        this.m_versionHistory = null;
    }

    public VfsVersion(VersionedFileSystemManager vfsManager, IEnhancedVersion version, IVfsVersionHistory versionHistory) {
        this.m_vfsManager = vfsManager;
        this.m_version = version;
        this.m_enhancedVersion = version;
        this.m_versionHistory = versionHistory;
    }

    public String getVersionName() {
        this.getVfsManager().checkState();
        try {
            return this.m_version.getVersionName();
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
            return null;
        }
    }

    public String getObjectID() throws VfsException {
        this.getVfsManager().checkState();
        try {
            return this.m_version.getXCMObjectId();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Get object id of version failed", vcmFailure);
        }
    }

    public IVfsVersion[] getPredecessorSet() {
        this.getVfsManager().checkState();
        try {
            IVersion[] versions = this.m_version.getPredecessorSet();
            if (versions != null) {
                IVfsVersion[] vfsVersions = new IVfsVersion[versions.length];
                int i = 0;
                while (i < versions.length) {
                    vfsVersions[i] = new VfsVersion(this.getVfsManager(), versions[i]);
                    ++i;
                }
                return vfsVersions;
            }
            return NULL_VERSION_ARRAY;
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
            return NULL_VERSION_ARRAY;
        }
    }

    public IVfsVersion[] getSuccessorSet() {
        this.getVfsManager().checkState();
        try {
            IVersion[] versions = this.m_version.getSuccessorSet();
            if (versions != null) {
                IVfsVersion[] vfsVersions = new IVfsVersion[versions.length];
                int i = 0;
                while (i < versions.length) {
                    vfsVersions[i] = new VfsVersion(this.getVfsManager(), versions[i]);
                    ++i;
                }
                return vfsVersions;
            }
            return NULL_VERSION_ARRAY;
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
            return NULL_VERSION_ARRAY;
        }
    }

    public IVfsVersionHistory getVersionHistory() {
        this.getVfsManager().checkState();
        try {
            IVersionHistory versionHistory = this.m_version.getVersionHistory();
            return new VfsVersionHistory(this.getVfsManager(), versionHistory);
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
            return null;
        }
        catch (VfsException vfsException) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vfsException);
            return null;
        }
    }

    public IVfsVersionHistory getVersionHistoryWithRefresh() {
        this.getVfsManager().checkState();
        try {
            IVersionHistory versionHistory = this.m_version.getVersionHistoryWithRefresh();
            return new VfsVersionHistory(this.getVfsManager(), versionHistory);
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
            return null;
        }
        catch (VfsException vfsException) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vfsException);
            return null;
        }
    }

    public IVfsVersion[] getCheckoutSet() {
        this.getVfsManager().checkState();
        try {
            ICheckedOutResource[] checkedOutResources = this.m_version.getCheckoutSet();
            IVfsVersion[] checkedOutVersions = new IVfsVersion[checkedOutResources.length];
            int id = this.m_version.getConnectionTemplID();
            int i = 0;
            while (i < checkedOutResources.length) {
                IResourceFactory resFactory = ResourceFactoryManager.getInstance().getProxyFactory();
                IVersion deltavVersion = resFactory.createVersion(id, checkedOutResources[i].getEncodedPath(), PathEncodingFlag.ENCODED);
                checkedOutVersions[i] = new VfsVersion(this.getVfsManager(), deltavVersion);
                ++i;
            }
            return checkedOutVersions;
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
            return NULL_VERSION_ARRAY;
        }
    }

    public String getUrl() {
        this.getVfsManager().checkState();
        return this.m_version.getPersistentURL();
    }

    public String getDisplayName() {
        this.getVfsManager().checkState();
        try {
            String displayName = this.m_version.getDisplayName();
            if (displayName == null || displayName.trim().length() == 0) {
                displayName = this.m_version.getDecodedPath();
            }
            return displayName;
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
            return null;
        }
    }

    public String getSequenceNumber() {
        this.getVfsManager().checkState();
        try {
            return this.m_version.getSequenceNumber();
        }
        catch (Exception e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return null;
        }
    }

    public int getBranchSequenceNumber() {
        this.getVfsManager().checkState();
        try {
            return Integer.parseInt(this.getSequenceNumber());
        }
        catch (NumberFormatException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return 0;
        }
    }

    public String getCreatorWorkspaceName() {
        this.getVfsManager().checkState();
        try {
            return PathUtilities.assureTrailingSeparator(this.m_version.getCreatorWorkspaceDecodedPath(), PathUtilities.REMOTE_FILESERVICE);
        }
        catch (Exception e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return null;
        }
    }

    public IVfsWorkspace getCreatorWorkspace() {
        this.getVfsManager().checkState();
        String wsRemotePath = this.getCreatorWorkspaceName();
        String webLocator = this.getVfsManager().getCurrentContext().getWebLocator(this.m_version.getConnectionTemplID());
        IVfsWorkspace workspace = this.getVfsManager().getWorkspaceByUrl(webLocator + Encoder.encodePath((String)wsRemotePath));
        return workspace;
    }

    public String getAuthor() {
        this.getVfsManager().checkState();
        try {
            return this.m_version.getAuthor();
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
            return null;
        }
    }

    public Date getLastModifiedDate() {
        this.getVfsManager().checkState();
        try {
            return this.m_version.lastModified();
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
            return null;
        }
    }

    public String getLastModifier() {
        this.getVfsManager().checkState();
        return null;
    }

    public String[] getPropertyNames() throws VfsException {
        this.getVfsManager().checkState();
        return this.getVfsManager().getPropertiesFeature().getPropertyNames(this.getDvVersion());
    }

    public IVfsProperty getProperty(String propertyName) throws VfsException {
        this.getVfsManager().checkState();
        return this.getVfsManager().getPropertiesFeature().getProperty(this.getDvVersion(), propertyName);
    }

    public Map getProperties(String[] propertyNames) throws VfsException {
        this.getVfsManager().checkState();
        return this.getVfsManager().getPropertiesFeature().getProperties(this.getDvVersion(), propertyNames);
    }

    public IVfsProperty[] getAllProperties() throws VfsException {
        this.getVfsManager().checkState();
        return this.getVfsManager().getPropertiesFeature().getAllProperties(this.getDvVersion());
    }

    public IVfsVersion[] getDiscardSourceVersions() {
        this.getVfsManager().checkState();
        ArrayList<IVfsVersion> sourceVersions = new ArrayList<IVfsVersion>();
        IVfsVersionRelation[] relations = this.getPredecessorRelationSet();
        int i = 0;
        while (i < relations.length) {
            if (relations[i].getRelationType().equals(VfsVersionRelationType.DISCARD_MERGE)) {
                sourceVersions.add(relations[i].getSourceVersion());
            }
            ++i;
        }
        return sourceVersions.toArray(new IVfsVersion[sourceVersions.size()]);
    }

    public IVfsVersion[] getDiscardSourceVersions(IVfsWorkspace workspace) {
        this.getVfsManager().checkState();
        this.checkParameterState(workspace);
        ArrayList<IVfsVersion> sourceVersions = new ArrayList<IVfsVersion>();
        IVfsVersionRelation[] relations = this.getPredecessorRelationSet();
        int i = 0;
        while (i < relations.length) {
            if (relations[i].getRelationType().equals(VfsVersionRelationType.DISCARD_MERGE) && relations[i].isVisibleInWorkspace(workspace.getAbsoluteRemotePath())) {
                sourceVersions.add(relations[i].getSourceVersion());
            }
            ++i;
        }
        return sourceVersions.toArray(new IVfsVersion[sourceVersions.size()]);
    }

    public IVfsVersion getDiscardSourceVersion(IVfsWorkspace workspace, IVfsActivity activity) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(workspace);
        this.checkParameterState(activity);
        IVfsVersionRelation[] relations = this.getPredecessorRelationSet();
        ArrayList<IVfsVersion> sourceVersions = new ArrayList<IVfsVersion>();
        int i = 0;
        while (i < relations.length) {
            if (relations[i].getRelationType().equals(VfsVersionRelationType.DISCARD_MERGE) && relations[i].isVisibleInWorkspace(workspace.getAbsoluteRemotePath())) {
                sourceVersions.add(relations[i].getSourceVersion());
            }
            ++i;
        }
        int count = sourceVersions.size();
        if (count == 1) {
            return (IVfsVersion)sourceVersions.get(0);
        }
        String errorMessage = "Unable to determine the source version of the discard";
        if (count > 1) {
            errorMessage = errorMessage + " (found " + count + " source versions).";
        }
        throw new VfsException(errorMessage);
    }

    public IVfsVersion[] getDiscardDestinationVersions() {
        this.getVfsManager().checkState();
        return NULL_VERSION_ARRAY;
    }

    public IVfsVersion[] getDiscardDestinationVersions(IVfsWorkspace workspace) {
        this.getVfsManager().checkState();
        this.checkParameterState(workspace);
        return NULL_VERSION_ARRAY;
    }

    public String toString() {
        this.getVfsManager().checkState();
        try {
            return "..." + this.m_version.getXCMPath();
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
            return this.getPath();
        }
    }

    public String getPath() {
        this.getVfsManager().checkState();
        return this.m_version.getDecodedPath();
    }

    public String toString(IVfsWorkspace workspace) {
        this.getVfsManager().checkState();
        this.checkParameterState(workspace);
        return this.getVcrPathForWorkspace(workspace);
    }

    public String getWorkspaceRelativePath() {
        this.getVfsManager().checkState();
        try {
            return this.m_version.getXCMPath().substring(1);
        }
        catch (VcmFailure e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return null;
        }
    }

    public String getVcrPathForWorkspace(IVfsWorkspace workspace) {
        String workspacePath;
        this.getVfsManager().checkState();
        this.checkParameterState(workspace);
        try {
            workspacePath = ((VfsWorkspace)workspace).m_dvVcr.getCanonicalPath();
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
            return this.getPath();
        }
        try {
            return PathUtilities.assureTrailingSeparator(workspacePath, PathUtilities.REMOTE_FILESERVICE) + this.m_version.getXCMPath().substring(1);
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
            return this.getPath();
        }
    }

    String getVcrPath(VfsWorkspace workspace) throws VfsException {
        try {
            IVersionControlledResource dvVCR = this.m_version.getVersionSelector(workspace.getDvWorkspace());
            if (dvVCR != null) {
                return dvVCR.getCanonicalPath();
            }
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Get version controlled resource corresponding to a version failed", vcmFailure);
        }
        return null;
    }

    IVersion getDvVersion() {
        return this.m_version;
    }

    public boolean isOpen() {
        this.getVfsManager().checkState();
        try {
            return this.getProperty(VfsXcmProperty.RESOURCE_TYPE.getCompletePropertyName()).getValue().equalsIgnoreCase(WORKING_RESOURCE);
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return false;
        }
    }

    public boolean isFile() throws VfsException {
        this.getVfsManager().checkState();
        try {
            return this.m_version.isFile();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Checking whether is file version or not failed.", vcmFailure);
        }
    }

    public boolean isVirtual() {
        this.getVfsManager().checkState();
        try {
            return this.m_version.isVirtual();
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
            return false;
        }
    }

    public boolean isDeleted() {
        this.getVfsManager().checkState();
        try {
            if (this.m_version.markedAsDeleted()) {
                return true;
            }
        }
        catch (VcmFailure e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
        return false;
    }

    public int getLengthToAncestor(IVfsVersion ancestorVersion) {
        this.getVfsManager().checkState();
        this.checkParameterState(ancestorVersion);
        return this.findAncestorLength(ancestorVersion, this.getPredecessorSet(), 0);
    }

    private int findAncestorLength(IVfsVersion version, IVfsVersion[] predecessors, int currentLength) {
        int currentShortestLength = 0;
        int i = 0;
        while (i < predecessors.length) {
            if (predecessors[i].equals(version)) {
                return currentLength + 1;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < predecessors.length) {
            int nextLength = this.findAncestorLength(version, predecessors[i2].getPredecessorSet(), currentLength + 1);
            if (nextLength > 0 && (currentShortestLength == 0 || nextLength < currentShortestLength)) {
                currentShortestLength = nextLength;
            }
            ++i2;
        }
        return currentShortestLength;
    }

    public String getLocationInGraph() {
        this.getVfsManager().checkState();
        return "Branch Seq No. " + String.valueOf(this.getSequenceNumber()) + " in workspace : " + this.getCreatorWorkspaceName();
    }

    public String getLocationInGraph(String workspacePath) {
        this.getVfsManager().checkState();
        StringBuffer locationInGraph = new StringBuffer(this.getLocationInGraph());
        if (this.m_versionHistory != null && workspacePath != null) {
            locationInGraph = locationInGraph.append(" [ Rev No. ");
            locationInGraph = locationInGraph.append(this.m_versionHistory.getRevisionNumber(this, workspacePath));
            locationInGraph = locationInGraph.append(" in workspace ");
            locationInGraph = locationInGraph.append(workspacePath);
            locationInGraph = locationInGraph.append(" ]");
        }
        return locationInGraph.toString();
    }

    public IVfsActivity[] getActivitySet() {
        this.getVfsManager().checkState();
        try {
            IActivity[] activities = this.m_version.getActivitySet();
            if (activities != null && activities.length > 0) {
                IVfsActivity[] vfsActivities = new IVfsActivity[activities.length];
                VfsRepository repository = this.getVfsManager().getRepositoryByConnectionTemplateId(activities[0].getConnectionTemplID());
                int count = 0;
                int i = 0;
                while (i < activities.length) {
                    IVfsActivity act = repository.getActivityByName(activities[i].getName());
                    if (act != null) {
                        vfsActivities[count++] = act;
                    } else {
                        System.out.println("Could not retrieve activity " + activities[i].getName());
                    }
                    ++i;
                }
                return vfsActivities;
            }
            return NULL_ACTIVITY_ARRAY;
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
            return NULL_ACTIVITY_ARRAY;
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return NULL_ACTIVITY_ARRAY;
        }
    }

    public IVfsActivity getCreatingActivity() {
        IVfsActivity[] activitySet = this.getActivitySet();
        if (activitySet.length == 0) {
            return null;
        }
        if (activitySet.length == 1) {
            return activitySet[0];
        }
        try {
            IVfsActivity earliestCheckedInActivity = activitySet[0];
            int i = 1;
            while (i < activitySet.length) {
                if (activitySet[i].getCheckedInDate().before(earliestCheckedInActivity.getCheckedInDate())) {
                    earliestCheckedInActivity = activitySet[i];
                }
                ++i;
            }
            return earliestCheckedInActivity;
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return null;
        }
    }

    public IVfsVersionRelation[] getPredecessorRelationSet() {
        this.getVfsManager().checkState();
        try {
            VersionRelation[] relations = this.m_version.getPredecessorRelationSet();
            if (relations != null) {
                int count = 0;
                IVfsVersionRelation[] vfsPredecessorRelations = new IVfsVersionRelation[relations.length];
                int i = 0;
                while (i < relations.length) {
                    vfsPredecessorRelations[count++] = new VfsVersionRelation(relations[i], null, this);
                    ++i;
                }
                return vfsPredecessorRelations;
            }
            return NULL_VERSION_RELATION_ARRAY;
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
            return NULL_VERSION_RELATION_ARRAY;
        }
    }

    public IVfsVersionRelation[] getPredecessorRelations(IVfsVersion predecessor) {
        this.getVfsManager().checkState();
        this.checkParameterState(predecessor);
        try {
            IVfsVersionRelation[] relations = this.getPredecessorRelationSet();
            ArrayList<IVfsVersionRelation> predecessorRelations = new ArrayList<IVfsVersionRelation>();
            if (relations != null) {
                int i = 0;
                while (i < relations.length) {
                    if (predecessor.getUrl().indexOf(relations[i].getSourceVersionId()) > 0) {
                        predecessorRelations.add(relations[i]);
                    }
                    ++i;
                }
                return predecessorRelations.toArray(new IVfsVersionRelation[predecessorRelations.size()]);
            }
        }
        catch (Exception e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
        return NULL_VERSION_RELATION_ARRAY;
    }

    public IVfsVersionRelation[] getSuccessorRelationSet() {
        this.getVfsManager().checkState();
        try {
            VersionRelation[] relations = this.m_version.getSuccessorRelationSet();
            if (relations != null) {
                int count = 0;
                IVfsVersionRelation[] vfsSuccessorRelations = new IVfsVersionRelation[relations.length];
                int i = 0;
                while (i < relations.length) {
                    vfsSuccessorRelations[count++] = new VfsVersionRelation(relations[i], this, null);
                    ++i;
                }
                return vfsSuccessorRelations;
            }
            return NULL_VERSION_RELATION_ARRAY;
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
            return null;
        }
    }

    public IVfsVersionRelation[] getSuccessorRelations(IVfsVersion successor) {
        this.getVfsManager().checkState();
        this.checkParameterState(successor);
        try {
            IVfsVersionRelation[] relations = this.getSuccessorRelationSet();
            ArrayList<IVfsVersionRelation> successorRelations = new ArrayList<IVfsVersionRelation>();
            if (relations != null) {
                int i = 0;
                while (i < relations.length) {
                    if (successor.getUrl().indexOf(relations[i].getTargetVersionId()) > 0 || successor.getVersionId().equalsIgnoreCase(relations[i].getTargetVersionId())) {
                        successorRelations.add(relations[i]);
                    }
                    ++i;
                }
                return successorRelations.toArray(new IVfsVersionRelation[successorRelations.size()]);
            }
        }
        catch (Exception e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
        return NULL_VERSION_RELATION_ARRAY;
    }

    public void getContent(OutputStream os) {
        this.getVfsManager().checkState();
        try {
            IFile versionFile = this.m_version.getAsFile();
            versionFile.getContent(os);
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
        }
    }

    public boolean equals(Object o) {
        this.getVfsManager().checkState();
        if (this == o) {
            return true;
        }
        if (!(o instanceof IVfsVersion)) {
            return false;
        }
        IVfsVersion version = (IVfsVersion)o;
        try {
            return version.getVersionId().equalsIgnoreCase(this.getVersionId());
        }
        catch (VfsException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return false;
        }
    }

    public int hashCode() {
        this.getVfsManager().checkState();
        try {
            return this.getVersionId().hashCode();
        }
        catch (VfsException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return 0;
        }
    }

    public IVfsFile getRepresentingFile(IVfsWorkspace workspace) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(workspace);
        return this.getFileOfThisVersion(workspace, this.getObjectID());
    }

    private IVfsFile getFileOfThisVersion(IVfsWorkspace workspace, String objectId) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(workspace);
        if (this.isDeleted()) {
            return null;
        }
        VersionedFileSystemManager manager = this.getVfsManager();
        IVfsFolderItem folderItem = manager.getFolderItemByObjectId(workspace, objectId);
        if (folderItem != null) {
            IVfsFile file = folderItem.asFile();
            if (this.isOpen()) {
                if (file.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                    return null;
                }
                if (!((VfsFile)file).getNewestDeltaVResource().getPersistentURL().equalsIgnoreCase(this.getUrl())) {
                    return null;
                }
            } else {
                if (file.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                    return null;
                }
                if (file.getSyncedVersion() == null || !file.getSyncedVersion().equals(this)) {
                    return null;
                }
            }
            return file;
        }
        throw new VfsException("Unable to get folder item for version in this workspace ");
    }

    public void syncToVersion(IVfsWorkspace workspace) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(workspace);
        VfsFile file = (VfsFile)this.getCorrespondingFile(workspace);
        this.getVfsManager().getSyncRemoveFeature().syncToVersion(file, this.getDvVersion(), true);
    }

    public IVfsFile getCorrespondingFile(IVfsWorkspace workspace) throws VfsException {
        if (this.isFile()) {
            return this.getCorrespondingFolderItem(workspace).asFile();
        }
        throw new VfsException("Version does not represent a file resource ");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IVfsFolderItem getCorrespondingFolderItem(IVfsWorkspace workspace) throws VfsException {
        IVfsFolderItem folderItem;
        this.getVfsManager().checkState();
        this.checkParameterState(workspace);
        String remotePath = this.getVcrPathForWorkspace(workspace);
        IVfsContext context = workspace.getContext();
        String absoluteLocalPath = context.getAbsoluteLocalPath(this.m_version.getConnectionTemplID(), remotePath);
        if (absoluteLocalPath == null || absoluteLocalPath.length() == 0) {
            if (!workspace.getLocationState().equals(VfsFolderItemLocationState.NOT_MOUNTED)) throw new VfsException("Unable to determine absolute local path of version ");
            String workspaceRelativePath = this.getWorkspaceRelativePath();
            String browsePath = workspace.getBrowsePath().concat(workspaceRelativePath);
            folderItem = this.getVfsManager().getFolderItemByBrowsePath(browsePath);
        } else {
            folderItem = this.getVfsManager().getFolderItem(workspace, absoluteLocalPath);
        }
        if (folderItem == null) throw new VfsException("Unable to get folder item for version in this workspace ");
        return folderItem;
    }

    public IVfsFile getCorrespondingFile(String workspacePath, IVfsContext context) throws VfsException {
        if (this.isFile()) {
            return this.getCorrespondingFolderItem(workspacePath, context).asFile();
        }
        throw new VfsException("Version does not represent a file resource ");
    }

    public IVfsFolderItem getCorrespondingFolderItem(String workspacePath, IVfsContext context) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(context);
        String remotePath = this.getVcrPath(workspacePath);
        String absoluteLocalPath = context.getAbsoluteLocalPath(this.m_version.getConnectionTemplID(), remotePath);
        if (absoluteLocalPath == null || absoluteLocalPath.length() == 0) {
            throw new VfsException("Unable to obtain absolute local path of version from remote path : " + remotePath);
        }
        IVersionedFileSystemManager manager = VersionedFileSystemFactory.getVersionedFileSystemManager(context);
        IVfsWorkspace[] workspaces = manager.getWorkspacesForLocalPath(absoluteLocalPath);
        if (workspaces == null || workspaces.length == 0) {
            throw new VfsException("Unable to obtain workspaces for local path " + absoluteLocalPath);
        }
        if (workspaces.length > 1) {
            throw new VfsException("More than one workspace found for local path " + absoluteLocalPath);
        }
        IVfsWorkspace workspace = workspaces[0];
        IVfsFolderItem folderItem = manager.getFolderItem(workspace, absoluteLocalPath);
        if (folderItem != null) {
            return folderItem;
        }
        throw new VfsException("Unable to get folder item for version in this workspace ");
    }

    public String getAbsolutePath(IVfsWorkspace workspace) {
        this.getVfsManager().checkState();
        this.checkParameterState(workspace);
        String remotePath = this.getVcrPathForWorkspace(workspace);
        IVfsContext context = workspace.getContext();
        String absoluteLocalPath = context.getAbsoluteLocalPath(this.m_version.getConnectionTemplID(), remotePath);
        return absoluteLocalPath;
    }

    public IVfsFile getRepresentingFile(String workspacePath, IVfsContext context) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(context);
        String remotePath = this.getVcrPath(workspacePath);
        String absoluteLocalPath = context.getAbsoluteLocalPath(this.m_version.getConnectionTemplID(), remotePath);
        if (absoluteLocalPath == null || absoluteLocalPath.length() == 0) {
            throw new VfsException("Unable to obtain absolute local path of version from remote path : " + remotePath);
        }
        IVersionedFileSystemManager manager = VersionedFileSystemFactory.getVersionedFileSystemManager(context);
        IVfsWorkspace[] workspaces = manager.getWorkspacesForLocalPath(absoluteLocalPath);
        if (workspaces == null || workspaces.length == 0) {
            throw new VfsException("Unable to obtain workspaces for local path " + absoluteLocalPath);
        }
        if (workspaces.length > 1) {
            throw new VfsException("More than one workspace found for local path " + absoluteLocalPath);
        }
        IVfsWorkspace workspace = workspaces[0];
        try {
            return this.getFileOfThisVersion(workspace, this.m_version.getXCMObjectId());
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Unable to get object ID of version from remote path: " + remotePath + "(" + vcmFailure.getMessage() + ")", vcmFailure);
        }
    }

    private String getVcrPath(String workspacePath) {
        try {
            return PathUtilities.assureTrailingSeparator(workspacePath, PathUtilities.REMOTE_FILESERVICE) + this.m_version.getXCMPath().substring(1);
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
            return this.getPath();
        }
    }

    public void syncToVersion(String workspacePath, IVfsContext context) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(context);
        VfsFile file = (VfsFile)this.getCorrespondingFile(workspacePath, context);
        this.getVfsManager().getSyncRemoveFeature().syncToVersion(file, this.getDvVersion(), true);
    }

    public boolean isSyncedOnClient(IVfsWorkspace workspace) {
        this.getVfsManager().checkState();
        this.checkParameterState(workspace);
        try {
            IVfsFile versionFile = this.getRepresentingFile(workspace);
            if (versionFile == null) {
                return false;
            }
            if (versionFile.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_LATEST || versionFile.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_FORMER) {
                IResource dvResource = ((VfsActivityRecordedFolderItem)((Object)versionFile)).getNewestDeltaVResource();
                if (dvResource instanceof IWorkingResource && this.isOpen() && dvResource.getDecodedPath().equalsIgnoreCase(this.m_version.getDecodedPath())) {
                    return true;
                }
                return dvResource instanceof IVersion && dvResource.getDecodedPath().equalsIgnoreCase(this.m_version.getDecodedPath());
            }
            return false;
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return false;
        }
    }

    public void discard(IVfsVersion discardTarget, IVfsActivity activity, IVfsWorkspace workspace) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(discardTarget);
        this.checkParameterState(activity);
        this.checkParameterState(workspace);
        ((VfsActivity)activity).checkWorkspace(workspace);
        try {
            ((VfsWorkspace)workspace).checkIsModifiable();
        }
        catch (VfsException e) {
            VfsException ex = new VfsException("Changes are not allowed because workspace is not modifiable", e);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, ex.getMessage());
            throw ex;
        }
        IWorkspace deltaVWorkspace = ((VfsWorkspace)workspace).getDvWorkspace();
        try {
            this.m_version.discard(((VfsVersion)discardTarget).getDvVersion(), ((VfsActivity)activity).getDeltaVActivity(), deltaVWorkspace);
        }
        catch (VcmFailure e) {
            throw new VfsException(e.getMessage());
        }
    }

    public void undoDiscard(IVfsVersion discardTarget, IVfsActivity activity) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(discardTarget);
        this.checkParameterState(activity);
        try {
            ((VfsWorkspace)activity.getWorkspace()).checkIsModifiable();
        }
        catch (VfsException e) {
            VfsException ex = new VfsException("Changes are not allowed because workspace is not modifiable", e);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, ex.getMessage());
            throw ex;
        }
        try {
            this.m_version.undoDiscard(((VfsVersion)discardTarget).getDvVersion(), ((VfsActivity)activity).getDeltaVActivity());
            IVfsActivityElement activityElement = ((VfsActivity)activity).getActivityElement(discardTarget.getUrl());
            if (activityElement != null) {
                ((VfsActivityElement)activityElement).setInvalid(true);
            }
        }
        catch (VcmFailure e) {
            throw new VfsException(e.getMessage());
        }
    }

    public void undoDiscard(IVfsActivity activity) throws VfsException {
        this.undoDiscard(activity, true, true);
    }

    void undoDiscard(IVfsActivity activity, boolean refreshActivityStateAfterUndo, boolean notifyActivityListenerAfterUndo) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(activity);
        if (!activity.isOpen()) {
            throw new VfsException("Undo discard is not possible because activity is already closed.");
        }
        try {
            ((VfsWorkspace)activity.getWorkspace()).checkIsModifiable();
        }
        catch (VfsException x) {
            VfsException ex = new VfsException("Changes are not allowed because workspace is not modifiable", x);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, ex.getMessage());
            throw ex;
        }
        IVfsVersion sourceVersion = this.getDiscardSourceVersion(activity.getWorkspace(), activity);
        sourceVersion.undoDiscard(this, activity);
        ((VfsActivity)activity).removeActivityElement(this);
        if (refreshActivityStateAfterUndo) {
            ((VfsActivity)activity).refreshActivityWorkspaceStateAfterUncheckout();
        }
        if (notifyActivityListenerAfterUndo) {
            this.getVfsManager().fireEventActivityItemsAddedOrRemoved(activity);
        }
    }

    public IVfsVersion[] getAncestors() {
        this.getVfsManager().checkState();
        HashSet ancestors = new HashSet();
        IVfsVersion[] predecessors = this.getPredecessorSet();
        this.addVersionsAndPredecessors(predecessors, ancestors);
        return ((AbstractCollection)ancestors).toArray(new IVfsVersion[ancestors.size()]);
    }

    private void addVersionsAndPredecessors(IVfsVersion[] versions, HashSet ancestors) {
        int i = 0;
        while (i < versions.length) {
            ancestors.add(versions[i]);
            this.addVersionsAndPredecessors(versions[i].getPredecessorSet(), ancestors);
            ++i;
        }
    }

    public IVfsVersion getLatestPredecessor(IVfsWorkspace workspace) throws VfsException {
        IVfsVersion syncedPredecessor;
        this.getVfsManager().checkState();
        this.checkParameterState(workspace);
        IVfsVersion[] versions = this.getPredecessorSet();
        if (versions.length == 0) {
            throw new VfsException("Predecessor set is empty");
        }
        if (versions.length == 1) {
            syncedPredecessor = versions[0];
        } else {
            String workspacePath = workspace.getAbsoluteRemotePath();
            this.m_versionHistory = versions[0].getVersionHistoryWithRefresh();
            int maxRevisionNumber = 0;
            IVfsVersion versionWithMaxRevisionNumber = null;
            int i = 0;
            while (i < versions.length) {
                IVfsVersion version = versions[i];
                int revisionNumber = this.m_versionHistory.getRevisionNumber(version, workspacePath);
                if (revisionNumber > maxRevisionNumber) {
                    maxRevisionNumber = revisionNumber;
                    versionWithMaxRevisionNumber = version;
                }
                ++i;
            }
            syncedPredecessor = versionWithMaxRevisionNumber;
        }
        return syncedPredecessor;
    }

    public boolean isVisibleInWorkspace(String workspaceRemotePath) throws VfsException {
        if (PathUtilities.assureTrailingSeparator(workspaceRemotePath, PathUtilities.REMOTE_FILESERVICE).equalsIgnoreCase(PathUtilities.assureTrailingSeparator(this.getCreatorWorkspaceName(), PathUtilities.REMOTE_FILESERVICE))) {
            return true;
        }
        if (this.m_enhancedVersion != null) {
            String[] activatedInWorkspaces = this.m_enhancedVersion.getActivatedInWorkspaceSet();
            int i = 0;
            while (i < activatedInWorkspaces.length) {
                if (PathUtilities.assureTrailingSeparator(workspaceRemotePath, PathUtilities.REMOTE_FILESERVICE).equalsIgnoreCase(PathUtilities.assureTrailingSeparator(activatedInWorkspaces[i], PathUtilities.REMOTE_FILESERVICE))) {
                    return true;
                }
                ++i;
            }
        } else {
            throw new VfsException("Unable to calculate visibility in workspace : version not created through version history report");
        }
        return false;
    }

    public boolean isIntegratedIntoWorkspace(String workspaceURL) throws VfsException {
        IVfsActivity[] activitySet = this.getActivitySet();
        int i = 0;
        while (i < activitySet.length) {
            IVfsActivity activity = activitySet[i];
            if (activity.isIntegratedIn(workspaceURL)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getVersionId() throws VfsException {
        try {
            return this.m_version.getVersionId();
        }
        catch (VcmFailure e) {
            throw new VfsException(e.getMessage());
        }
    }

    public String[] getActivatedInWorkspaceSet() {
        HashSet<String> wsSet = new HashSet<String>();
        String[] activatedInWorkspaceSet = this.m_enhancedVersion.getActivatedInWorkspaceSet();
        int i = 0;
        while (i < activatedInWorkspaceSet.length) {
            wsSet.add(activatedInWorkspaceSet[i]);
            ++i;
        }
        return ((AbstractCollection)wsSet).toArray(new String[wsSet.size()]);
    }

    public int[] getISNs(String workspacePath) {
        try {
            IIntegration[] activatingIntegrationSet = this.m_enhancedVersion.getActivatingIntegrationSet(workspacePath);
            if (activatingIntegrationSet != null && activatingIntegrationSet.length > 0) {
                int[] ISNs = new int[activatingIntegrationSet.length];
                int i = 0;
                while (i < activatingIntegrationSet.length) {
                    ISNs[i] = activatingIntegrationSet[i].getIsn();
                    ++i;
                }
                return ISNs;
            }
            return new int[0];
        }
        catch (VcmFailure e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return new int[0];
        }
    }

    public Date[] getIntegrationDates(String workspacePath) {
        try {
            IIntegration[] activatingIntegrationSet = this.m_enhancedVersion.getActivatingIntegrationSet(workspacePath);
            if (activatingIntegrationSet != null && activatingIntegrationSet.length > 0) {
                Date[] integrationDates = new Date[activatingIntegrationSet.length];
                int i = 0;
                while (i < activatingIntegrationSet.length) {
                    integrationDates[i] = activatingIntegrationSet[i].created();
                    ++i;
                }
                return integrationDates;
            }
            return new Date[0];
        }
        catch (VcmFailure e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return new Date[0];
        }
    }

    IIntegration[] getIntegrations(String workspacePath) {
        IIntegration[] activatingIntegrationSet = this.m_enhancedVersion.getActivatingIntegrationSet(workspacePath);
        if (activatingIntegrationSet != null) {
            return activatingIntegrationSet;
        }
        return new IIntegration[0];
    }

    public IVersionedFileSystemManager getVersionedFileSystemManager() {
        return this.getVfsManager();
    }

    public VersionedFileSystemManager getVfsManager() {
        if (this.m_vfsManager == null || this.m_vfsManager.isReleased()) {
            throw new IllegalStateException("Versioned file system manager was released");
        }
        return this.m_vfsManager;
    }

    private void checkParameterState(IVfsWorkspace workspace) {
        if (workspace == null) {
            throw new IllegalArgumentException("Internal error: workspace parameter is null");
        }
        if (workspace.getVersionedFileSystemManager() != this.getVfsManager()) {
            throw new IllegalArgumentException("Internal error: parameter with different versioned file system manager");
        }
    }

    private void checkParameterState(IVfsVersion version) {
        if (version == null) {
            throw new IllegalArgumentException("Internal error: version parameter is null");
        }
        if (version.getVersionedFileSystemManager() != this.getVfsManager()) {
            throw new IllegalArgumentException("Internal error: parameter with different versioned file system manager");
        }
    }

    private void checkParameterState(IVfsContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Internal error: context parameter is null");
        }
        if (context != this.getVfsManager().getCurrentContext()) {
            throw new IllegalArgumentException("Internal error: context parameter differs from context of versioned file system manager");
        }
    }

    private void checkParameterState(IVfsActivity activity) {
        if (activity == null) {
            throw new IllegalArgumentException("Internal error: activity parameter is null");
        }
        if (activity.getVersionedFileSystemManager() != this.getVfsManager()) {
            throw new IllegalArgumentException("Internal error: context parameter differs from context of versioned file system manager");
        }
    }

    public Date getWorkspaceActivationTime(String workspacePath) throws VfsException {
        return null;
    }

    public int getISN(String workspacePath) {
        return 0;
    }

    public Date getIntegrationDate(String workspacePath) {
        return null;
    }

    public Object[] getChildrenObjects() throws VfsException {
        return this.getVfsManager().getPropertiesFeature().getChildrenObjects(this.getDvVersion());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class VfsMergeVersion
    extends VfsVersion
    implements IVfsMergeVersion {
        IVfsActivityRecordedFolderItem m_workingResource;

        public VfsMergeVersion(VfsVersion version, IVfsActivityRecordedFolderItem workingResource) {
            super(version.getVfsManager(), version.getDvVersion());
            this.m_workingResource = workingResource;
        }

        public void setContent(InputStream content) {
        }

        public String[] getModifiablePropertyNames() {
            return null;
        }

        public boolean isPropertyModifiable(String name) {
            return false;
        }

        public void setProperty(String name, String value) {
        }

        public void addProperty(String name, String value) {
        }

        public void removeProperty(String name) {
        }

        public IVirtualFile getLocalFile() {
            return this.m_workingResource.asFile().getLocalFile();
        }

        IVfsActivityRecordedFolderItem getActivityRecordedFolderItem() {
            return this.m_workingResource;
        }
    }
}

