/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.ResourceFactoryManager;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.util.TimeUtilities;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsProperty;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.impl.VfsRepository;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspace;
import com.tssap.dtr.client.lib.vfs.impl.VfsXcmProperty;
import java.net.MalformedURLException;
import java.util.Calendar;

public class VfsSpecialPaths {
    private static final String BY_TIMESTAMP_OID_FOLDERNAME = "bytsoid";
    private static final String BY_INTEGRATION = "byintegration";
    private static final String BY_ISN_OID_FOLDERNAME = "byisnoid";
    private static final String BY_TIME = "bytime";
    private static final String BY_ANY_TIME = "bytime/all";
    private static final String VCR = "vcr/";
    private static final String INT = "int/";
    private static final String KNOWNWS = "knownws";
    private static final int KNOWNWS_OFFSET = 8;
    private static final String NONVRESBYID = "nonvresbyid";

    static String getAbsoluteRemotePathBasedOnObjectID(IVfsWorkspace workspace, String objectID) throws VfsException {
        return ((VfsRepository)workspace.getRepository()).getAbsoluteRemotePath() + VCR + workspace.getObjectID() + "_" + objectID;
    }

    static boolean isRemotePathBasedOnObjectID(VfsRepository repository, String path) {
        return VfsSpecialPaths.isPathWithSpecialPrefix(repository, path, VCR);
    }

    static String getAbsoluteRemotePathOfDeletedVcr(IVfsWorkspace workspace, String objectID) throws VfsException {
        return VfsSpecialPaths.getAbsoluteRemotePathBasedOnObjectID(workspace, objectID);
    }

    static String getBrowsePath(IVfsWorkspace workspace, String folderItemObjectId) throws VfsException {
        String workspaceBrowsePath = workspace.getBrowsePath();
        String absoluteRemotePath = VfsSpecialPaths.getAbsoluteRemotePathBasedOnObjectID(workspace, folderItemObjectId);
        IResource resource = null;
        try {
            resource = ResourceFactoryManager.getInstance().getProxyFactory().createResource(((VfsWorkspace)workspace).getConnectionTemplateId(), absoluteRemotePath);
            String xcmPath = resource.getProperty(VfsXcmProperty.XCM_PATH_PROPERTY_NAME).getValue();
            return workspaceBrowsePath + xcmPath.substring(1);
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting XCM path property failed.", vcmFailure);
        }
    }

    static String getAbsoluteRemoteVersionPath(IVfsWorkspace workspace, Calendar calendar, String workspaceRelativePath) throws VfsException {
        IVfsProperty workspaceHistoryProperty = workspace.getProperty(VfsXcmProperty.WORKPSPACE_HISTORY.getCompletePropertyName());
        String workspaceHistoryPath = workspaceHistoryProperty.getChildren()[0].getValue();
        Calendar correctedCalendar = (Calendar)calendar.clone();
        if (correctedCalendar.get(14) == 0) {
            correctedCalendar.add(14, 999);
        }
        StringBuffer timeStampPath = new StringBuffer();
        timeStampPath.append(workspaceHistoryPath);
        timeStampPath.append('/');
        timeStampPath.append(BY_ANY_TIME);
        timeStampPath.append('/');
        timeStampPath.append(TimeUtilities.toUrlTimeString(correctedCalendar.getTime()));
        timeStampPath.append('/');
        timeStampPath.append(workspaceRelativePath);
        return timeStampPath.toString();
    }

    static String getAbsoluteRemoteVersionPath(IVfsActivityRecordedFolderItem activityRecordedFolderItem, int sequenceNumber) throws VfsException {
        IVfsProperty workspaceHistoryProperty = activityRecordedFolderItem.getWorkspace().getProperty(VfsXcmProperty.WORKPSPACE_HISTORY.getCompletePropertyName());
        String workspaceHistoryPath = workspaceHistoryProperty.getChildren()[0].getValue();
        StringBuffer isnPath = new StringBuffer();
        isnPath.append(workspaceHistoryPath);
        isnPath.append('/');
        isnPath.append(BY_ISN_OID_FOLDERNAME);
        isnPath.append('/');
        isnPath.append(sequenceNumber);
        isnPath.append("_");
        isnPath.append(activityRecordedFolderItem.getProperty(VfsXcmProperty.OBJECT_ID.getCompletePropertyName()).getValue());
        return isnPath.toString();
    }

    static String getAbsoluteRemotePathForIntegrationObject(IVfsWorkspace workspace, int isn) throws VfsException {
        String repositoryUrl = workspace.getRepository().getUrl();
        URL serverUrl = null;
        try {
            serverUrl = new URL(repositoryUrl);
        }
        catch (MalformedURLException e) {
            throw new VfsException("Bad repository URL \"" + repositoryUrl + "\" (" + e.getMessage() + ")", e);
        }
        IVfsRemoteLocator locator = workspace.getContext().getRemoteLocatorFromUrl(repositoryUrl);
        String serverRoot = PathUtilities.assureTrailingSeparator(locator.getAbsoluteRemotePath(), false);
        return serverRoot + INT + workspace.getObjectID() + "_" + isn;
    }

    static String getOIDFromSpecialWorkspacePath(String specialWorkspacePath) {
        int startIndexOfOID;
        int startIndexOfKnownws = specialWorkspacePath.indexOf(KNOWNWS);
        int n = startIndexOfOID = startIndexOfKnownws == -1 ? -1 : startIndexOfKnownws + 8;
        if (startIndexOfOID == -1) {
            return null;
        }
        String workspaceOID = specialWorkspacePath.substring(startIndexOfOID);
        if (workspaceOID == null || workspaceOID.length() == 0) {
            return null;
        }
        return PathUtilities.preventTrailingSeparator(workspaceOID, PathUtilities.REMOTE_FILESERVICE);
    }

    static boolean isSpecialWorkspacePath(VfsRepository repository, String path) {
        return VfsSpecialPaths.isPathWithSpecialPrefix(repository, path, KNOWNWS);
    }

    static String getSpecialVersionSetPath(VfsRepository repository, String oid) {
        return repository.getAbsoluteRemotePath() + NONVRESBYID + "/" + oid;
    }

    static String getSpecialVersionSetUrl(VfsRepository repository, String oid) {
        return repository.getUrl() + NONVRESBYID + "/" + oid;
    }

    static boolean isSpecialVersionSetPath(VfsRepository repository, String path) {
        return VfsSpecialPaths.isPathWithSpecialPrefix(repository, path, NONVRESBYID);
    }

    private static boolean isPathWithSpecialPrefix(VfsRepository repository, String path, String prefix) {
        int startIndex;
        return path.startsWith(repository.getAbsoluteRemotePath()) && path.indexOf(prefix, startIndex = repository.getAbsoluteRemotePath().length()) == startIndex;
    }
}

