/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.vfs.IVfsRepository;
import com.tssap.dtr.client.lib.vfs.IVfsRootFolder;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemCategory;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.impl.FolderItemCache;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspaceFolder;

final class VfsRootFolder
extends VfsWorkspaceFolder
implements IVfsRootFolder {
    boolean m_isTopLevelRoot;

    private VfsRootFolder(VersionedFileSystemManager vfsManager, IResource resource, IVirtualFile localFile, boolean isTopLevelRoot) {
        super(vfsManager, resource, localFile);
        this.m_isTopLevelRoot = isTopLevelRoot;
    }

    static VfsRootFolder pureUnsecuredGetVfsRootFolder(VersionedFileSystemManager vfsManager, IResource dvResource, IVirtualFile localFile, boolean topLevelRoot, boolean useFolderItemCache) throws VfsException {
        VfsFolderItem folderItem = null;
        if (useFolderItemCache) {
            FolderItemCache folderItemCache = vfsManager.getFolderItemCache();
            String absoluteLocalPath = VfsFolderItem.getAbsoluteLocalPath(localFile, dvResource, vfsManager.getCurrentContext(), VfsFolderItemCategory.WORKSPACE_FOLDER);
            if (absoluteLocalPath != null) {
                folderItem = folderItemCache.getFolderItemWithLocalPath(absoluteLocalPath);
            }
            if (folderItem != null) {
                VfsFolderItem.checkAndAdaptCachedFolderItem(folderItem, dvResource, absoluteLocalPath, VfsFolderItemCategory.ROOT);
            }
            if (folderItem == null) {
                if (localFile == VfsFolderItem.KEEP_LOCAL_FILE) {
                    localFile = absoluteLocalPath != null ? vfsManager.getCurrentContext().getFileService().constructFile(absoluteLocalPath) : VfsFolderItem.NULL_LOCAL_FILE;
                }
                folderItem = new VfsRootFolder(vfsManager, dvResource, localFile, topLevelRoot);
                try {
                    boolean doOverwrite = true;
                    folderItemCache.addFolderItem(folderItem, doOverwrite);
                }
                catch (VfsException e) {
                    VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, folderItem, "Internal error");
                    throw new VfsException("Internal error: Add file to cache failed", e);
                }
            }
        } else {
            folderItem = new VfsRootFolder(vfsManager, dvResource, localFile, topLevelRoot);
        }
        return (VfsRootFolder)folderItem.asRoot();
    }

    public String getName() {
        this.getVfsManager().checkState();
        if (this.m_isTopLevelRoot) {
            return this.m_context.toString();
        }
        return super.getName();
    }

    public String getBrowsePath() {
        this.getVfsManager().checkState();
        return "/";
    }

    public IVfsRepository[] getRepositories() {
        this.getVfsManager().checkState();
        return this.getVfsManager().getRepositories();
    }
}

