/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.IActivity;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.xcm.IIntegration;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsRevision;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsRevisionAction;
import com.tssap.dtr.client.lib.vfs.impl.Util;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsRepository;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersion;
import java.util.Date;

public class VfsRevision
implements IVfsRevision {
    private VersionedFileSystemManager m_vfsManager = null;
    private IVfsVersion m_vfsVersion;
    private int m_ISN;
    private String m_workspacePath;
    private IVfsActivity m_creatingActivity;
    private IIntegration m_integration;
    private String m_creatingActivityName;
    private String m_creatingActivityDescription;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$VfsRevision == null ? (class$com$tssap$dtr$client$lib$vfs$impl$VfsRevision = VfsRevision.class$("com.tssap.dtr.client.lib.vfs.impl.VfsRevision")) : class$com$tssap$dtr$client$lib$vfs$impl$VfsRevision));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$VfsRevision;

    public VfsRevision(IVfsVersion vfsVersion, int ISN, String workspacePath) {
        this.m_vfsVersion = vfsVersion;
        this.m_ISN = ISN;
        this.m_workspacePath = Util.assureTrailingSlash(workspacePath);
        this.m_vfsManager = (VersionedFileSystemManager)this.m_vfsVersion.getVersionedFileSystemManager();
        this.m_integration = this.getIntegrationOfRevision();
        this.m_creatingActivityName = null;
        this.m_creatingActivityDescription = null;
        this.m_creatingActivity = null;
    }

    public int getISN() {
        this.getVersionedFileSystemManager().checkState();
        return this.m_ISN;
    }

    public IVfsVersion getVersion() {
        this.getVersionedFileSystemManager().checkState();
        return this.m_vfsVersion;
    }

    public String getWorkspaceRemotePath() {
        this.getVersionedFileSystemManager().checkState();
        return this.m_workspacePath;
    }

    public Date getIntegrationDate() {
        this.getVersionedFileSystemManager().checkState();
        try {
            if (this.m_integration != null) {
                return this.m_integration.created();
            }
        }
        catch (VcmFailure e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
        return null;
    }

    private IIntegration getIntegrationOfRevision() {
        IIntegration[] integrations = ((VfsVersion)this.m_vfsVersion).getIntegrations(this.m_workspacePath);
        try {
            int i = 0;
            while (i < integrations.length) {
                if (integrations[i].getIsn() == this.m_ISN) {
                    return integrations[i];
                }
                ++i;
            }
        }
        catch (VcmFailure e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
        return null;
    }

    public VfsRevisionAction getAction() {
        this.getVersionedFileSystemManager().checkState();
        try {
            IIntegration[] integrations = ((VfsVersion)this.m_vfsVersion).getIntegrations(this.m_workspacePath);
            if (integrations.length > 1) {
                int i = 0;
                while (i < integrations.length) {
                    if (integrations[i].getIsn() < this.m_ISN) {
                        return VfsRevisionAction.DISCARD;
                    }
                    ++i;
                }
            }
            if (!this.m_workspacePath.equalsIgnoreCase(Util.assureTrailingSlash(this.m_vfsVersion.getCreatorWorkspaceName()))) {
                return this.getIntegrateRelatedAction();
            }
            if (this.m_vfsVersion.isDeleted()) {
                return VfsRevisionAction.DELETE;
            }
            return VfsRevisionAction.EDIT;
        }
        catch (VcmFailure e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return VfsRevisionAction.UNKNOWN;
        }
    }

    private VfsRevisionAction getIntegrateRelatedAction() {
        try {
            IProperty integrationOptions = this.m_integration.getProperty(XCM.INTEGRATION_OPTIONS.qualifiedName);
            if (integrationOptions != null && integrationOptions.getFirstChild() != null && integrationOptions.getFirstChild().getName().equalsIgnoreCase(XCM.FORCE_INTEGRATE.localName)) {
                return VfsRevisionAction.FORCE_INTEGRATE;
            }
            return VfsRevisionAction.INTEGRATE;
        }
        catch (VcmFailure e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return null;
        }
    }

    public IVfsActivity getCreatingActivity() {
        this.getVersionedFileSystemManager().checkState();
        if (this.m_creatingActivity == null) {
            try {
                if (this.m_integration != null) {
                    this.m_creatingActivity = this.getVfsActivity(this.m_integration.getActivity());
                }
            }
            catch (VcmFailure e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
        }
        return this.m_creatingActivity;
    }

    public String getCreatingActivityName() {
        this.getVersionedFileSystemManager().checkState();
        if (this.m_creatingActivityName == null) {
            try {
                if (this.m_integration != null) {
                    this.m_creatingActivityName = this.m_integration.getActivity().getDisplayName();
                }
            }
            catch (VcmFailure e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
        }
        return this.m_creatingActivityName;
    }

    public String getCreatingActivityDescription() {
        this.getVersionedFileSystemManager().checkState();
        if (this.m_creatingActivityDescription == null) {
            try {
                if (this.m_integration != null) {
                    this.m_creatingActivityDescription = this.m_integration.getActivity().getComment();
                    if (this.m_creatingActivityDescription == null) {
                        this.m_creatingActivityDescription = "";
                    }
                }
            }
            catch (VcmFailure e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
        }
        return this.m_creatingActivityDescription;
    }

    private IVfsActivity getVfsActivity(IActivity dvActivity) {
        VfsRepository repository = this.getVersionedFileSystemManager().getRepositoryByConnectionTemplateId(dvActivity.getConnectionTemplID());
        IVfsActivity activity = null;
        try {
            String objectId = dvActivity.getXCMObjectId();
            activity = repository.getActivityById(objectId);
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
        catch (VcmFailure e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
        return activity;
    }

    public VersionedFileSystemManager getVersionedFileSystemManager() {
        if (this.m_vfsManager == null || this.m_vfsManager.isReleased()) {
            throw new IllegalStateException("Versioned file system manager was released");
        }
        return this.m_vfsManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

