/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.tssap.dtr.client.lib.deltavlib.IRepositoryFunctionality;
import com.tssap.dtr.client.lib.deltavlib.IRepositoryOptions;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.RepositoryOptionsAccess;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

class VfsRepositoryOptions {
    private HashMap m_repositoryFunctionalities = new HashMap();
    private HashMap m_repositoryFunctionalityRetrieval = new HashMap();
    private int m_expirationTime;
    private IVfsRemoteLocator m_repositoryRootLocator;
    private static final Map EMPTY_FUNCTIONALITY_OPTIONS = new HashMap();

    VfsRepositoryOptions(IVfsRemoteLocator repositoryRootLocator, int expirationTime) {
        this.m_repositoryRootLocator = repositoryRootLocator;
        this.m_expirationTime = expirationTime;
    }

    IVfsRemoteLocator getRepositoryRootLocator() {
        return this.m_repositoryRootLocator;
    }

    int getExpirationTime() {
        return this.m_expirationTime;
    }

    void setExpirationTime(int expirationTime) {
        this.m_expirationTime = expirationTime;
    }

    private void addFunctionality(Functionality functionality, String[] functionalityOptions, Date retrievalDate) {
        this.m_repositoryFunctionalityRetrieval.put(functionality, retrievalDate);
        if (functionalityOptions == null || functionalityOptions.length == 0) {
            return;
        }
        HashMap<Object, Object> options = new HashMap<Object, Object>(functionalityOptions.length);
        if (functionality == Functionality.ACTIVITY_QUERY) {
            int i = 0;
            while (i < functionalityOptions.length) {
                ActivityQueryOption option = ActivityQueryOption.getOptionForName(functionalityOptions[i]);
                if (option != null) {
                    options.put(option, option);
                }
                ++i;
            }
        } else if (functionality == Functionality.LIST_COLLECTION_REPORT) {
            int i = 0;
            while (i < functionalityOptions.length) {
                ListCollectionReportOption option = ListCollectionReportOption.getOptionForName(functionalityOptions[i]);
                if (option != null) {
                    options.put(option, option);
                }
                ++i;
            }
        } else {
            return;
        }
        this.m_repositoryFunctionalities.put(functionality, options);
    }

    private boolean isFunctionalityRetrievalUpToDate(Functionality functionality) {
        Date functionalityRefreshingDate = (Date)this.m_repositoryFunctionalityRetrieval.get(functionality);
        if (functionalityRefreshingDate != null) {
            long now = System.currentTimeMillis();
            long expirationTimeHoursBack = now - (long)this.getExpirationTime();
            if (functionalityRefreshingDate.getTime() > expirationTimeHoursBack) {
                return true;
            }
        }
        return false;
    }

    private Map pureGetFunctionalityOptions(Functionality functionality) {
        Map options = (Map)this.m_repositoryFunctionalities.get(functionality);
        return options != null && options.size() > 0 ? options : EMPTY_FUNCTIONALITY_OPTIONS;
    }

    Map getFunctionalityOptions(Functionality functionality) throws VfsException {
        if (!this.isFunctionalityRetrievalUpToDate(functionality)) {
            IRepositoryFunctionality dvRepositoryFunctionality;
            IRepositoryOptions dvOptions = RepositoryOptionsAccess.getInstance();
            try {
                dvRepositoryFunctionality = dvOptions.getFunctionality(this.getRepositoryRootLocator().getConnectionTemplateId(), functionality.getName());
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Getting the available server functionality for " + functionality.getTask() + " failed: " + vcmFailure.getMessage(), vcmFailure);
            }
            Date now = new Date();
            String[] functionalityOptions = dvRepositoryFunctionality == null ? null : dvRepositoryFunctionality.getOptions();
            this.addFunctionality(functionality, functionalityOptions, now);
        }
        return this.pureGetFunctionalityOptions(functionality);
    }

    static class ListCollectionReportOption {
        private String m_name;
        static ListCollectionReportOption END_OF_RESPONSE_RESOURCE = new ListCollectionReportOption("end-of-response-resource");
        static ListCollectionReportOption ISN = new ListCollectionReportOption("isn");
        static ListCollectionReportOption PATTERNS = new ListCollectionReportOption("patterns");
        static ListCollectionReportOption HIDE_FOLDERS = new ListCollectionReportOption("hide-folders");

        private ListCollectionReportOption(String option) {
            this.m_name = option;
        }

        String getName() {
            return this.m_name;
        }

        static ListCollectionReportOption getOptionForName(String optionName) {
            if (END_OF_RESPONSE_RESOURCE.getName().equals(optionName)) {
                return END_OF_RESPONSE_RESOURCE;
            }
            if (PATTERNS.getName().equals(optionName)) {
                return PATTERNS;
            }
            if (ISN.getName().equals(optionName)) {
                return ISN;
            }
            if (HIDE_FOLDERS.getName().equals(optionName)) {
                return HIDE_FOLDERS;
            }
            return null;
        }
    }

    static class ActivityQueryOption {
        private String m_name;
        static ActivityQueryOption CONTAINS_FILES = new ActivityQueryOption("contains-files");

        private ActivityQueryOption(String option) {
            this.m_name = option;
        }

        String getName() {
            return this.m_name;
        }

        static ActivityQueryOption getOptionForName(String optionName) {
            if (CONTAINS_FILES.getName().equals(optionName)) {
                return CONTAINS_FILES;
            }
            return null;
        }
    }

    static class Functionality {
        private String m_name;
        private String m_task;
        static Functionality ACTIVITY_QUERY = new Functionality("activity-query-report", "retrieval of activities");
        static Functionality LIST_COLLECTION_REPORT = new Functionality("list-collection-report", "mass retrieval of resources");

        private Functionality(String functionality, String task) {
            this.m_name = functionality;
            this.m_task = task;
        }

        String getName() {
            return this.m_name;
        }

        String getTask() {
            return this.m_task;
        }
    }
}

