/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.ConnectionPool;
import com.tssap.dtr.client.lib.deltavlib.IActivity;
import com.tssap.dtr.client.lib.deltavlib.IActivityCollection;
import com.tssap.dtr.client.lib.deltavlib.IAssociatedResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.ICollection;
import com.tssap.dtr.client.lib.deltavlib.IRepositoryOptions;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.IWorkspace;
import com.tssap.dtr.client.lib.deltavlib.PathEncodingFlag;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.DefaultPropertyManagerAccess;
import com.tssap.dtr.client.lib.deltavlib.factory.PropertyFactoryAccess;
import com.tssap.dtr.client.lib.deltavlib.factory.RepositoryOptionsAccess;
import com.tssap.dtr.client.lib.deltavlib.factory.ResourceFactoryManager;
import com.tssap.dtr.client.lib.deltavlib.properties.Converter;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.IElement;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyCacheControl;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.xcm.ActivityCompositeDef;
import com.tssap.dtr.client.lib.deltavlib.xcm.ActivityReportFactory;
import com.tssap.dtr.client.lib.deltavlib.xcm.CollectionSynchronizerFactory;
import com.tssap.dtr.client.lib.deltavlib.xcm.CollectionSynchronizerOptions;
import com.tssap.dtr.client.lib.deltavlib.xcm.CollisionReportFactory;
import com.tssap.dtr.client.lib.deltavlib.xcm.CollisionState;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityComposite;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityContent;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityQuery;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityReport;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICollectionSynchronizer;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICollisionQuery;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICollisionReport;
import com.tssap.dtr.client.lib.deltavlib.xcm.IPersistentCollision;
import com.tssap.dtr.client.lib.deltavlib.xcm.IResourceResultSet;
import com.tssap.dtr.client.lib.deltavlib.xcm.SelectResourcesOption;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.pool.IConnectionPool;
import com.tssap.dtr.client.lib.protocol.pool.OutOfConnectionsException;
import com.tssap.dtr.client.lib.protocol.requests.http.OptionsRequest;
import com.tssap.dtr.client.lib.protocol.templates.TemplateException;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.EnvironmentVariables;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsCollisionQuery;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.IVfsRepository;
import com.tssap.dtr.client.lib.vfs.IVfsVersionSet;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsExceptionCategory;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.impl.FolderItemCache;
import com.tssap.dtr.client.lib.vfs.impl.Util;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivity;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.impl.VfsRepositoryOptions;
import com.tssap.dtr.client.lib.vfs.impl.VfsSpecialPaths;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspace;
import com.tssap.dtr.client.lib.vfs.impl.VfsXcmClientProperty;
import com.tssap.dtr.client.lib.vfs.impl.VfsXcmProperty;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

final class VfsRepository
implements IVfsRepository {
    private VersionedFileSystemManager m_vfsManager = null;
    private IVfsContext m_context = null;
    private String m_url = null;
    private IVfsRemoteLocator m_repositoryRootLocator = null;
    private IActivityCollection[] m_activityCollections = new IActivityCollection[0];
    private String m_userPricipalFilePath;
    private String m_userNameFromUserStore;
    private final HashMap m_workspaces = new HashMap();
    private final HashMap m_workspacesByOID = new HashMap();
    private final HashMap m_emptyActivities = new HashMap();
    private FolderItemCache m_folderItemCache = null;
    private IActivityReport m_activityReport = null;
    private IActivityQuery m_openActivityQuery = null;
    private IActivityQuery m_emptyActivityQuery = null;
    private IActivityQuery m_closedActivityQuery = null;
    private ICollisionReport m_collisionReport = null;
    private ICollisionQuery m_collisionQuery = null;
    private final int m_repositoryOptionsExpirationTime = 43200000;
    private VfsRepositoryOptions m_repositoryOptions;
    private static final boolean REFRESH_OPEN_ACTIVITIES = true;
    private static final boolean NOT_REFRESH_OPEN_ACTIVITIES = false;
    private static final IVfsActivity[] EMPTY_ACTIVITY_ARRAY = new IVfsActivity[0];
    private static final IActivity[] EMPTY_DV_ACTIVITY_ARRAY = new IActivity[0];
    private static final IVfsWorkspace[] EMPTY_WORKSPACE_ARRAY = new IVfsWorkspace[0];
    private static final IWorkspace[] EMPTY_DV_WORKSPACE_ARRAY = new IWorkspace[0];
    private static Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$VfsRepository == null ? (class$com$tssap$dtr$client$lib$vfs$impl$VfsRepository = VfsRepository.class$("com.tssap.dtr.client.lib.vfs.impl.VfsRepository")) : class$com$tssap$dtr$client$lib$vfs$impl$VfsRepository));
    private Boolean _supportsMget;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$VfsRepository;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$IWorkspace;

    VfsRepository(IVfsRemoteLocator serverRoot, VersionedFileSystemManager vfsManager, FolderItemCache folderItemCache) throws VfsException {
        this.m_vfsManager = vfsManager;
        this.m_context = vfsManager.getCurrentContext();
        this.m_url = this.m_context.getUrl(serverRoot);
        this.m_repositoryRootLocator = serverRoot;
        this.m_folderItemCache = folderItemCache;
        this.m_repositoryOptions = new VfsRepositoryOptions(this.m_repositoryRootLocator, 43200000);
        boolean oldRealization = false;
        try {
            this.pureRefreshWorkspacesFromRepository(serverRoot);
        }
        catch (VfsException e) {
            throw new VfsException("Get workspaces from repository " + this.m_url + " failed", e);
        }
        this.initializeOpenActivityReportForRepository();
        this.initializeEmptyActivityReportForRepository();
        this.initializeClosedActivityReportForRepository();
        this.refreshOpenActivitiesFromRepository();
    }

    public String toString() {
        return this.getUrl();
    }

    public void refreshOpenActivitiesFromRepository() throws VfsException {
        Iterator workspaceIterator = this.m_workspaces.values().iterator();
        ArrayList<IVfsActivity> oldOpenActivities = new ArrayList<IVfsActivity>();
        oldOpenActivities.addAll(Arrays.asList(this.getEmptyActivities()));
        while (workspaceIterator.hasNext()) {
            VfsWorkspace workspace = (VfsWorkspace)workspaceIterator.next();
            oldOpenActivities.addAll(Arrays.asList(workspace.getActivities(VfsActivityState.OPEN)));
        }
        boolean separatelyRequestEmptyActivities = false;
        IActivityComposite[] activityComposites = null;
        try {
            activityComposites = this.m_activityReport.select(this.m_openActivityQuery, this.getOpenActivityCompositeDef());
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Activity report (get open activities for current repository and user) failed: " + vcmFailure.getMessage(), vcmFailure);
        }
        VfsException e = null;
        VfsException fatalException = null;
        VfsException mountpointException = null;
        ArrayList<IVfsActivity> newOpenActivities = new ArrayList<IVfsActivity>(activityComposites.length);
        ArrayList<IActivity> newEmptyActivities = new ArrayList<IActivity>();
        int i = 0;
        while (i < activityComposites.length) {
            block24: {
                VfsWorkspace workspace;
                IActivityContent activityContent;
                IActivityComposite activityComposite;
                block23: {
                    block22: {
                        activityComposite = activityComposites[i];
                        activityContent = activityComposite.getActivityContentComponent();
                        workspace = null;
                        try {
                            workspace = VfsActivity.getWorkspaceForDvActivity(this, activityComposite.getActivity());
                            if (workspace == null) {
                                Logbook.getInfoChapter(2).println("Filtered out open activity of excluded workspace: " + VfsActivity.getIdentifyingString(activityComposite.getActivity()));
                            }
                            break block22;
                        }
                        catch (VfsException e1) {
                            e = new VfsException("Get workspace of activity failed: " + VfsActivity.getIdentifyingString(activityComposite.getActivity()), e1);
                        }
                        break block24;
                    }
                    try {
                        if (!VfsActivity.isDvActivityVisible(this, activityComposite.getActivity(), workspace)) {
                            Logbook.getInfoChapter(2).println("Filtered out activity: " + VfsActivity.getIdentifyingString(activityComposite.getActivity()));
                        }
                        break block23;
                    }
                    catch (VfsException e1) {
                        e = e1;
                    }
                    break block24;
                }
                if (activityContent == null || activityContent.checkedOutCount() + activityContent.createdCount() + activityContent.closedCount() == 0) {
                    newEmptyActivities.add(activityComposite.getActivity());
                } else {
                    try {
                        newOpenActivities.add(workspace.refreshActivityCache(activityComposite));
                    }
                    catch (VfsException e1) {
                        if (e1.getCategory() == VfsExceptionCategory.NO_MOUNTPOINT_FOR_ADDED_FILE) {
                            mountpointException = e1;
                        }
                        fatalException = e1;
                    }
                }
            }
            ++i;
        }
        if (separatelyRequestEmptyActivities) {
            this.refreshEmptyActivitiesFromRepository();
            newOpenActivities.addAll(this.m_emptyActivities.values());
        } else if (!newEmptyActivities.isEmpty()) {
            newOpenActivities.addAll(Arrays.asList(this.refreshActivityCacheForEmptyActivities(newEmptyActivities.toArray(EMPTY_DV_ACTIVITY_ARRAY))));
        }
        if (!oldOpenActivities.isEmpty()) {
            VfsActivity.repairOldOpenActivities(oldOpenActivities, newOpenActivities);
        }
        if (mountpointException != null) {
            throw mountpointException;
        }
        if (fatalException != null) {
            String msg = "Refreshing open activities on repository failed";
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, msg);
            throw new VfsException(msg + ": " + this.getAbsoluteRemotePath(), fatalException);
        }
        if (e != null) {
            throw e;
        }
    }

    void refreshWorkspacesFromRepository(IVfsRemoteLocator serverRoot) throws VfsException {
        this.refreshWorkspacesFromRepository(serverRoot, true);
    }

    private void pureRefreshWorkspacesFromRepository(IVfsRemoteLocator serverRoot) throws VfsException {
        this.refreshWorkspacesFromRepository(serverRoot, false);
    }

    private void refreshWorkspacesFromRepository(IVfsRemoteLocator serverRoot, boolean refreshOpenActivities) throws VfsException {
        try {
            IWorkspace[] dvWorkspaces = new IWorkspace[]{};
            boolean gotWorkspaceByMget = false;
            if (this.supportsMget()) {
                IVfsRemoteLocator[] filteredWorkspaceRemoteLocators = this.getContext().getWorkspaceFilters(this.getRemoteLocator());
                String[] filteredWorkspacePaths = new String[filteredWorkspaceRemoteLocators.length];
                int i = 0;
                while (i < filteredWorkspaceRemoteLocators.length) {
                    filteredWorkspacePaths[i] = filteredWorkspaceRemoteLocators[i].getCanonicalAbsoluteRemotePath();
                    ++i;
                }
                if (filteredWorkspacePaths.length > 0) {
                    try {
                        dvWorkspaces = this.getDvWorkspaces_usingMget(this.getConnectionTemplateId(), filteredWorkspacePaths);
                        gotWorkspaceByMget = true;
                    }
                    catch (VfsException e) {
                        LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)e, (int)500);
                    }
                }
            }
            if (!gotWorkspaceByMget) {
                dvWorkspaces = VfsRepository.getDvWorkspaces_usingXcmProperty(serverRoot);
            }
            long start = System.currentTimeMillis();
            try {
                int k = 0;
                while (k < dvWorkspaces.length) {
                    IWorkspace dvWorkspace = dvWorkspaces[k];
                    if (dvWorkspace.isCollection() && dvWorkspace.getAsCollection().isWorkspace()) {
                        String absoluteLocalPath = this.m_context.getAbsoluteLocalPath(dvWorkspace.getConnectionTemplID(), dvWorkspace.getDecodedPath());
                        IVirtualFile localFolder = absoluteLocalPath == null ? VfsFolderItem.NULL_LOCAL_FILE : this.getContext().getFileService().constructFile(absoluteLocalPath);
                        VfsWorkspace workspace = refreshOpenActivities ? VfsWorkspace.getVfsWorkspace(this, dvWorkspace, localFolder) : VfsWorkspace.pureCreateVfsWorkspace(this, dvWorkspace, localFolder);
                        if (workspace != null) {
                            this.addWorkspace(workspace);
                        }
                    }
                    ++k;
                }
                Object var13_16 = null;
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                long elapsed = System.currentTimeMillis() - start;
                LogUtil.logElapsedTime((long)elapsed, (String)("Initialized/filtered " + dvWorkspaces.length + " workspaces"));
                throw throwable;
            }
            long elapsed = System.currentTimeMillis() - start;
            LogUtil.logElapsedTime((long)elapsed, (String)("Initialized/filtered " + dvWorkspaces.length + " workspaces"));
            {
            }
        }
        catch (VcmFailure vcmFailure) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, "Getting workspaces for server " + this.getContext().getUrl(serverRoot) + " failed.");
            throw new VfsException("Getting workspaces for server " + this.getContext().getUrl(serverRoot) + " failed.", vcmFailure);
        }
        catch (VfsException ex) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, "Getting workspaces for server " + this.getContext().getUrl(serverRoot) + " failed.");
            throw new VfsException("Getting workspaces for server " + this.getContext().getUrl(serverRoot) + " failed.", ex);
        }
    }

    private static IWorkspace[] getDvWorkspaces_usingStandardDeltaV(IVfsRemoteLocator serverRoot) throws VfsException {
        ICollection[] workspaceFolders = new ICollection[]{};
        try {
            IRepositoryOptions repositoryOptions = RepositoryOptionsAccess.getInstance();
            workspaceFolders = repositoryOptions.getWorskpaceCollectionSet(serverRoot.getConnectionTemplateId(), serverRoot.getAbsoluteRemotePath());
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Get workspace collection set failed", vcmFailure);
        }
        if (workspaceFolders == null) {
            workspaceFolders = new ICollection[]{};
        }
        ArrayList<IWorkspace> dvWorkspaceList = new ArrayList<IWorkspace>();
        int j = 0;
        while (j < workspaceFolders.length) {
            block11: {
                ICollection workspaceFolder = workspaceFolders[j];
                IResource[] dvWorkspaces = new IResource[]{};
                try {
                    dvWorkspaces = workspaceFolder.listMembers();
                }
                catch (VcmFailure vcmFailure) {
                    if (vcmFailure.getStatusCode() != 403) {
                        throw new VfsException("Get members from workspace folder failed", vcmFailure);
                    }
                    break block11;
                }
                int i = 0;
                while (i < dvWorkspaces.length) {
                    IResource dvWorkspace = dvWorkspaces[i];
                    try {
                        if (dvWorkspace.isCollection() && dvWorkspace.getAsCollection().isWorkspace()) {
                            dvWorkspaceList.add(dvWorkspace.getAsCollection().getAsWorkspace());
                        }
                    }
                    catch (VcmFailure vcmFailure) {
                        throw new VfsException("Get category of DeltaV workspace resource failed", vcmFailure);
                    }
                    ++i;
                }
            }
            ++j;
        }
        return dvWorkspaceList.toArray(new IWorkspace[dvWorkspaceList.size()]);
    }

    private IWorkspace[] getDvWorkspaces_usingMget(int connectionTemplateId, String[] decodedAbsoluteRemotePaths) throws VfsException {
        String[] propertyNames = VfsRepository.getDefaultPropertyNames(class$com$tssap$dtr$client$lib$deltavlib$IWorkspace == null ? (class$com$tssap$dtr$client$lib$deltavlib$IWorkspace = VfsRepository.class$("com.tssap.dtr.client.lib.deltavlib.IWorkspace")) : class$com$tssap$dtr$client$lib$deltavlib$IWorkspace);
        IResourceResultSet resultSet = this.getDvResources_usingMget(connectionTemplateId, decodedAbsoluteRemotePaths, propertyNames);
        IWorkspace[] foundDvWorkspaces = resultSet.getWorkspaces();
        if (decodedAbsoluteRemotePaths.length > foundDvWorkspaces.length) {
            VfsRepository.handleErrorsFromMgetWorkspaces(decodedAbsoluteRemotePaths, resultSet);
        }
        return resultSet.getWorkspaces();
    }

    static String[] getDefaultPropertyNames(Class dvResourceType) {
        IPropertyNameIterator propertyNameIterator = DefaultPropertyManagerAccess.getInstance().getResourceCachedProperties(dvResourceType);
        String[] propertyNames = new String[propertyNameIterator.size()];
        int i = 0;
        while (i < propertyNames.length) {
            propertyNames[i] = propertyNameIterator.next();
            ++i;
        }
        return propertyNames;
    }

    private static void handleErrorsFromMgetWorkspaces(String[] decodedAbsoluteRemotePaths, IResourceResultSet resultSet) {
        HashSet<String> givenPaths = new HashSet<String>(Arrays.asList(decodedAbsoluteRemotePaths));
        IResource[] dvResources = resultSet.getWorkspaces();
        int i = 0;
        while (i < dvResources.length) {
            if (!givenPaths.remove(PathUtilities.assureTrailingSeparator(dvResources[i].getDecodedPath(), PathUtilities.REMOTE_FILESERVICE))) {
                givenPaths.remove(PathUtilities.preventTrailingSeparator(dvResources[i].getDecodedPath(), PathUtilities.REMOTE_FILESERVICE));
            }
            ++i;
        }
        if (givenPaths.size() == 0) {
            return;
        }
        boolean DO_DEBUG_LOG_EXCEPTION = true;
        dvResources = resultSet.getNotFoundResources();
        int i2 = 0;
        while (i2 < dvResources.length) {
            if (givenPaths.remove(PathUtilities.assureTrailingSeparator(dvResources[i2].getDecodedPath(), PathUtilities.REMOTE_FILESERVICE)) || givenPaths.remove(PathUtilities.preventTrailingSeparator(dvResources[i2].getDecodedPath(), PathUtilities.REMOTE_FILESERVICE))) {
                Logbook.getWarnChapter().println("Inconsistent configuration: Workspace was not found on repository: " + dvResources[i2].getDecodedPath());
            } else {
                LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception("Internal error: Server response for not requested resource in list-collection-report: " + dvResources[i2].getDecodedPath()), (boolean)true);
            }
            ++i2;
        }
        if (givenPaths.size() > 0) {
            dvResources = resultSet.getNotApplicableResources();
            int i3 = 0;
            while (i3 < dvResources.length) {
                if (givenPaths.remove(PathUtilities.assureTrailingSeparator(dvResources[i3].getDecodedPath(), PathUtilities.REMOTE_FILESERVICE)) || givenPaths.remove(PathUtilities.preventTrailingSeparator(dvResources[i3].getDecodedPath(), PathUtilities.REMOTE_FILESERVICE))) {
                    Logbook.getWarnChapter().println("Inconsistent configuration: Resource is not a workspace: " + dvResources[i3].getDecodedPath());
                } else {
                    LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception("Internal error: Server response for not requested resource in list-collection-report: " + dvResources[i3].getDecodedPath()), (boolean)true);
                }
                ++i3;
            }
        }
        if (givenPaths.size() > 0) {
            String[] invalidResourcePaths = resultSet.getInvalidResourcePaths();
            int i4 = 0;
            while (i4 < invalidResourcePaths.length) {
                if (givenPaths.remove(invalidResourcePaths[i4])) {
                    Logbook.getWarnChapter().println("Inconsistent configuration: Invalid path for a workspace given: " + invalidResourcePaths[i4]);
                } else {
                    LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception("Internal error: Server response for not requested resource in list-collection-report: " + invalidResourcePaths[i4]), (boolean)true);
                }
                ++i4;
            }
        }
        if (givenPaths.size() > 0) {
            dvResources = resultSet.getVcrFiles();
            int i5 = 0;
            while (i5 < dvResources.length) {
                if (givenPaths.remove(dvResources[i5].getDecodedPath())) {
                    Logbook.getWarnChapter().println("Inconsistent configuration: Resource is not a workspace, but a file: " + dvResources[i5].getDecodedPath());
                } else {
                    LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception("Internal error: Server response for not requested resource in list-collection-report: " + dvResources[i5].getDecodedPath()), (boolean)true);
                }
                ++i5;
            }
        }
        if (givenPaths.size() > 0) {
            dvResources = resultSet.getVcrCollections();
            int i6 = 0;
            while (i6 < dvResources.length) {
                if (givenPaths.remove(PathUtilities.assureTrailingSeparator(dvResources[i6].getDecodedPath(), PathUtilities.REMOTE_FILESERVICE)) || givenPaths.remove(PathUtilities.preventTrailingSeparator(dvResources[i6].getDecodedPath(), PathUtilities.REMOTE_FILESERVICE))) {
                    Logbook.getWarnChapter().println("Inconsistent configuration: Resource is not a workspace, but a folder: " + dvResources[i6].getDecodedPath());
                } else {
                    LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception("Internal error: Server response for not requested resource in list-collection-report: " + dvResources[i6].getDecodedPath()), (boolean)true);
                }
                ++i6;
            }
        }
        if (givenPaths.size() > 0) {
            Iterator<String> pathIterator = givenPaths.iterator();
            while (pathIterator.hasNext()) {
                String path = pathIterator.next();
                LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception("Internal error: No server response in list-collection-report for requested resource: " + path), (boolean)true);
                Logbook.getWarnChapter().println("Inconsistent configuration: Resource is not a workspace: " + path);
                pathIterator.remove();
            }
        }
    }

    private IResourceResultSet getDvResources_usingMget(int connectionTemplateId, String[] decodedAbsoluteRemotePaths, String[] requestedProperties) throws VfsException {
        IResourceResultSet resultSet;
        ICollectionSynchronizer collectionSynchronizer = CollectionSynchronizerFactory.createSynchronizer(this.getSyncOptions());
        SelectResourcesOption selectOptions = new SelectResourcesOption();
        selectOptions.setDepth(0);
        selectOptions.setPropertiesOnly(true);
        selectOptions.setProperties(requestedProperties);
        try {
            resultSet = collectionSynchronizer.findSelectedResources(connectionTemplateId, decodedAbsoluteRemotePaths, selectOptions);
            if (!resultSet.getCompleted() && this.getListCollectionReportOptions().containsKey(VfsRepositoryOptions.ListCollectionReportOption.END_OF_RESPONSE_RESOURCE)) {
                throw new VfsException("List-Collection-Report request not completed : " + this.formatPathsIntoStringWithNewlines(decodedAbsoluteRemotePaths));
            }
        }
        catch (VcmFailure vcmFailure) {
            if (vcmFailure.getStatusCode() == 400) {
                selectOptions.setDepth(1);
                try {
                    resultSet = collectionSynchronizer.findSelectedResources(connectionTemplateId, decodedAbsoluteRemotePaths, selectOptions);
                }
                catch (VcmFailure vcmFailure1) {
                    throw new VfsException(vcmFailure.getMessage(), vcmFailure);
                }
            }
            throw new VfsException(vcmFailure.getMessage(), vcmFailure);
        }
        return resultSet;
    }

    CollectionSynchronizerOptions getSyncOptions() {
        CollectionSynchronizerOptions options = new CollectionSynchronizerOptions();
        try {
            options.setEnsureFinished(this.getListCollectionReportOptions().containsKey(VfsRepositoryOptions.ListCollectionReportOption.END_OF_RESPONSE_RESOURCE));
        }
        catch (VfsException e) {
            LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception("Could not get Collection Report Functionality options " + e.getMessage()), (boolean)true);
            options.setEnsureFinished(false);
        }
        return options;
    }

    private String formatPathsIntoStringWithNewlines(String[] paths) {
        StringBuffer allPaths = new StringBuffer();
        int i = 0;
        while (i < paths.length) {
            allPaths.append(paths[i]);
            allPaths.append("\n");
            ++i;
        }
        return allPaths.toString();
    }

    private static IWorkspace[] getDvWorkspaces_usingXcmProperty(IVfsRemoteLocator serverRoot) throws VfsException {
        try {
            IResourceFactory proxyFactory = ResourceFactoryManager.getInstance().getProxyFactory();
            ICollection dvRepositoryRoot = proxyFactory.createCollection(serverRoot.getConnectionTemplateId(), serverRoot.getAbsoluteRemotePath(), PathEncodingFlag.DECODED);
            IAssociatedResourceFactory associatedResourceFactory = ResourceFactoryManager.getInstance().getAssocFactory();
            return associatedResourceFactory.createWorkspacesFromReference(dvRepositoryRoot, VfsXcmProperty.WORKPSPACE_SET.getCompletePropertyName());
        }
        catch (VcmFailure vcmFailure) {
            if (vcmFailure.getStatusCode() == 404) {
                return EMPTY_DV_WORKSPACE_ARRAY;
            }
            throw new VfsException("Getting workspaces from repository by XCM:workspace-set failed");
        }
    }

    private void initializeOpenActivityReportForRepository() {
        if (this.m_activityReport == null) {
            this.m_activityReport = ActivityReportFactory.getInstance().createReport(this.getConnectionTemplateId(), this.m_repositoryRootLocator.getAbsoluteRemotePath());
        }
        this.m_openActivityQuery = ActivityReportFactory.getInstance().createQuery();
        this.m_openActivityQuery.setUser(this.getContext().getUserName(this.getConnectionTemplateId()));
        this.m_openActivityQuery.setOpenedOnly(true);
        if (this.getContext().getClientFilter() != null) {
            IProperty clientIDProperty = PropertyFactoryAccess.getFactory().createStringProperty(VfsXcmClientProperty.getNamespacePrefix(), VfsXcmClientProperty.CLIENT_ID.getPropertyName(), this.getContext().getClientFilter());
            this.m_openActivityQuery.addPropertyEqualsConstraint(clientIDProperty);
        }
    }

    private void initializeEmptyActivityReportForRepository() {
        if (this.m_activityReport == null) {
            this.m_activityReport = ActivityReportFactory.getInstance().createReport(this.getConnectionTemplateId(), this.m_repositoryRootLocator.getAbsoluteRemotePath());
        }
        this.m_emptyActivityQuery = ActivityReportFactory.getInstance().createQuery();
        this.m_emptyActivityQuery.setUser(this.getContext().getUserName(this.getConnectionTemplateId()));
        this.m_emptyActivityQuery.setOpenedOnly(true);
        this.m_emptyActivityQuery.setSelectEmptyActivitiesOnly();
        if (this.getContext().getClientFilter() != null) {
            IProperty clientIDProperty = PropertyFactoryAccess.getFactory().createStringProperty(VfsXcmClientProperty.getNamespacePrefix(), VfsXcmClientProperty.CLIENT_ID.getPropertyName(), this.getContext().getClientFilter());
            this.m_emptyActivityQuery.addPropertyEqualsConstraint(clientIDProperty);
        }
    }

    private void initializeClosedActivityReportForRepository() throws VfsException {
        if (this.m_activityReport == null) {
            this.m_activityReport = ActivityReportFactory.getInstance().createReport(this.getConnectionTemplateId(), this.m_repositoryRootLocator.getAbsoluteRemotePath());
        }
        this.m_closedActivityQuery = ActivityReportFactory.getInstance().createQuery();
        this.m_closedActivityQuery.setUser(this.getContext().getUserName(this.getConnectionTemplateId()));
        this.m_closedActivityQuery.setClosedOnly(true);
    }

    ActivityCompositeDef getOpenActivityCompositeDef() {
        return VfsActivity.OPEN_ACTIVITY_COMPOSITE_DEF;
    }

    ActivityCompositeDef getEmptyActivityCompositeDef() {
        return VfsActivity.EMPTY_ACTIVITY_COMPOSITE_DEF;
    }

    IVfsActivity[] refreshEmptyActivitiesFromRepository() throws VfsException {
        IActivity[] dvActivities;
        block2: {
            dvActivities = new IActivity[]{};
            try {
                dvActivities = this.m_activityReport.select(this.m_emptyActivityQuery);
            }
            catch (VcmFailure vcmFailure) {
                if (vcmFailure.getStatusCode() == 404) break block2;
                throw new VfsException("Activity report (get empty activities for current repository and user) failed", vcmFailure);
            }
        }
        return this.refreshActivityCacheForEmptyActivities(dvActivities);
    }

    Collection refreshCachesForWorkspacesUnderWorkspaceFolder(Collection dvWorkspaces) throws VfsException {
        ArrayList<VfsWorkspace> vfsWorkspaces = new ArrayList<VfsWorkspace>(dvWorkspaces.size());
        Iterator dvWorkspaceIterator = dvWorkspaces.iterator();
        while (dvWorkspaceIterator.hasNext()) {
            IResource dvWorkspace = (IResource)dvWorkspaceIterator.next();
            String absoluteLocalPath = null;
            try {
                absoluteLocalPath = this.m_context.getAbsoluteLocalPath(dvWorkspace.getConnectionTemplID(), dvWorkspace.getCanonicalPath());
            }
            catch (VcmFailure vcmFailure) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
            }
            IVirtualFile localFolder = absoluteLocalPath == null ? VfsFolderItem.NULL_LOCAL_FILE : this.getContext().getFileService().constructFile(absoluteLocalPath);
            VfsWorkspace workspace = VfsWorkspace.getVfsWorkspace(this, dvWorkspace, localFolder);
            if (workspace == null) continue;
            this.addWorkspace(workspace);
            this.getVersionedFileSystemManager().addWorkspaceToCache(workspace);
            vfsWorkspaces.add(workspace);
        }
        return vfsWorkspaces;
    }

    void setFolderItemCache(FolderItemCache folderItemCache) {
        this.m_folderItemCache = folderItemCache;
    }

    FolderItemCache getFolderItemCache() {
        return this.m_folderItemCache;
    }

    IVfsRemoteLocator getRemoteLocator() {
        return this.m_repositoryRootLocator;
    }

    int getConnectionTemplateId() {
        return this.m_repositoryRootLocator.getConnectionTemplateId();
    }

    String getAbsoluteRemotePath() {
        return this.m_repositoryRootLocator.getAbsoluteRemotePath();
    }

    public String getUrl() {
        this.getVersionedFileSystemManager().checkState();
        return this.m_url;
    }

    public IVfsWorkspace[] getWorkspaces() {
        this.getVersionedFileSystemManager().checkState();
        return this.m_workspaces.values().toArray(EMPTY_WORKSPACE_ARRAY);
    }

    public IVfsWorkspace[] getWorkspacesContainingActivities(VfsActivityState activityState) {
        ArrayList<IVfsWorkspace> workspaces;
        block15: {
            this.getVersionedFileSystemManager().checkState();
            IVfsWorkspace[] allWorkspaces = this.getWorkspaces();
            workspaces = new ArrayList<IVfsWorkspace>(allWorkspaces.length);
            if (activityState == VfsActivityState.CLOSED && !EnvironmentVariables.INCLUDE_WORKSPACES_WITH_INTEGRATED_ACTIVITIES) {
                try {
                    IActivity[] dvActivities = this.m_activityReport.select(this.m_closedActivityQuery);
                    HashSet<String> workspaceUrls = new HashSet<String>();
                    int j = 0;
                    while (j < dvActivities.length) {
                        if (dvActivities[j].getWorkspace() != null) {
                            workspaceUrls.add(dvActivities[j].getWorkspace().getPersistentURL());
                        }
                        ++j;
                    }
                    int i = 0;
                    while (i < allWorkspaces.length) {
                        IVfsWorkspace workspace = allWorkspaces[i];
                        if (workspaceUrls.contains(workspace.getUrl())) {
                            workspaces.add(workspace);
                        }
                        ++i;
                    }
                }
                catch (VfsException e) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                }
                catch (VcmFailure vcmFailure) {
                    if (vcmFailure.getStatusCode() == 404) break block15;
                    LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
                }
            } else {
                int i = 0;
                while (i < allWorkspaces.length) {
                    try {
                        IVfsWorkspace workspace = allWorkspaces[i];
                        if (workspace.getActivities(activityState).length > 0) {
                            workspaces.add(workspace);
                        } else if (activityState == VfsActivityState.OPEN && workspace.getEmptyActivities().length > 0) {
                            workspaces.add(workspace);
                        }
                    }
                    catch (VfsException x) {
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                    }
                    ++i;
                }
            }
        }
        return workspaces.toArray(new IVfsWorkspace[0]);
    }

    boolean hasEmptyActivity(IVfsActivity activity) {
        return this.m_emptyActivities.get(activity.getAbsoluteRemotePath()) != null;
    }

    VfsActivity getEmptyActivity(String absoluteRemotePath) {
        return (VfsActivity)this.m_emptyActivities.get(absoluteRemotePath);
    }

    public IVfsActivity[] getEmptyActivities() throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        if (!this.m_emptyActivities.isEmpty()) {
            return this.m_emptyActivities.values().toArray(EMPTY_ACTIVITY_ARRAY);
        }
        return EMPTY_ACTIVITY_ARRAY;
    }

    private IVfsActivity[] refreshActivityCacheForEmptyActivities(IActivity[] dvActivities) throws VfsException {
        ArrayList<VfsActivity> vfsActivities = new ArrayList<VfsActivity>(dvActivities.length);
        int i = 0;
        while (i < dvActivities.length) {
            IActivity dvActivity = dvActivities[i];
            if (!VfsActivity.isDvActivityVisible(this, dvActivity, VfsWorkspace.NULL_WORKSPACE)) {
                Logbook.getInfoChapter(2).println("Filtered out empty activity: " + VfsActivity.getIdentifyingString(dvActivity));
            } else {
                IVfsWorkspace workspace;
                VfsActivity vfsActivity = (VfsActivity)this.m_emptyActivities.get(dvActivity.getDecodedPath());
                if (vfsActivity != null) {
                    vfsActivity.setDeltaVActivity(dvActivity);
                } else {
                    workspace = (VfsWorkspace)VfsActivity.getXcmClientWorkspaceForDvActivity(this, dvActivity);
                    vfsActivity = ((VfsWorkspace)workspace).getActivityFromCache(dvActivity.getDecodedPath());
                    if (vfsActivity != null) {
                        vfsActivity.setDeltaVActivity(dvActivity);
                        vfsActivity.resetActivityElementsAndState();
                    } else {
                        vfsActivity = new VfsActivity(this, dvActivity);
                        this.m_emptyActivities.put(vfsActivity.getAbsoluteRemotePath(), vfsActivity);
                    }
                }
                if (vfsActivity.isDvActivityDefaultActivity()) {
                    workspace = vfsActivity.getXcmClientWorkspace();
                    ((VfsWorkspace)workspace).initializeDefaultActivityOnWorkspace(vfsActivity);
                }
                vfsActivities.add(vfsActivity);
            }
            ++i;
        }
        return vfsActivities.toArray(EMPTY_ACTIVITY_ARRAY);
    }

    private boolean isActivityUrl(URL url) throws VfsException {
        if (url == null) {
            return false;
        }
        String path = url.getPath();
        if (path == null || path.length() == 0) {
            return false;
        }
        IActivityCollection[] activityCollections = this.getActivityCollections();
        int i = 0;
        while (i < activityCollections.length) {
            IActivityCollection activityCollection = activityCollections[i];
            if (path.startsWith(activityCollection.getDecodedPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IVfsActivity getActivityByUrl(String activityUrl) throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        return this.getActivityByUrl(activityUrl, false);
    }

    IVfsActivity getActivityByUrl(String activityUrl, boolean returnPropagationList) throws VfsException {
        IVfsRemoteLocator locator;
        if (activityUrl == null || activityUrl.length() == 0) {
            throw new IllegalArgumentException("Null activity Url as parameter");
        }
        URL url = null;
        try {
            url = new URL(activityUrl);
            locator = this.m_context.getRemoteLocatorFromUrl(activityUrl);
            if (locator == null) {
                throw new VfsException("Server for activity URL is unknown: " + activityUrl);
            }
        }
        catch (MalformedURLException x) {
            throw new VfsException("Invalid activity URL (" + x.getMessage() + "): " + activityUrl, x);
        }
        if (!VfsSpecialPaths.isSpecialVersionSetPath(this, url.getPath()) && !this.isActivityUrl(url)) {
            throw new VfsException("Invalid activity URL (URL does not belong to an activity): " + activityUrl);
        }
        VfsActivity cachedActivity = (VfsActivity)this.m_emptyActivities.get(locator.getAbsoluteRemotePath());
        if (cachedActivity == null) {
            Iterator workspaceIterator = this.m_workspaces.values().iterator();
            while (workspaceIterator.hasNext() && cachedActivity == null) {
                cachedActivity = ((VfsWorkspace)workspaceIterator.next()).getActivityFromCache(locator.getAbsoluteRemotePath());
            }
        }
        if (cachedActivity != null) {
            return cachedActivity;
        }
        return this.getActivityFromRepository(locator.getAbsoluteRemotePath(), returnPropagationList);
    }

    public IVfsActivity getActivityById(String activityId) throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        return this.getActivityById(activityId, false);
    }

    IVfsActivity getActivityById(String activityId, boolean returnPropagationList) throws VfsException {
        if (activityId == null || activityId.length() == 0) {
            throw new IllegalStateException("Null activity Id as parameter");
        }
        String activityUrl = VfsSpecialPaths.getSpecialVersionSetUrl(this, activityId);
        return this.getActivityByUrl(activityUrl, returnPropagationList);
    }

    public IVfsActivity[] getActivitiesById(String[] activityIds) throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        if (activityIds == null || activityIds.length == 0) {
            throw new IllegalStateException("Null array of activity Ids as parameter");
        }
        return this.getActivitiesById(activityIds, false);
    }

    IVfsActivity[] getActivitiesById(String[] activityIds, boolean returnPropagationLists) throws VfsException {
        ArrayList<IVfsActivity> activities = new ArrayList<IVfsActivity>();
        int i = 0;
        while (i < activityIds.length) {
            String oid = activityIds[i];
            IVfsActivity activity = this.getActivityById(oid, returnPropagationLists);
            if (activity != null) {
                activities.add(activity);
            }
            ++i;
        }
        return activities.toArray(VfsActivity.EMPTY_ACTIVITY_ARRAY);
    }

    public IVfsVersionSet[] getVersionSetsBy(String[] oids) throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        return this.getActivitiesById(oids, true);
    }

    public IVfsVersionSet getVersionSetById(String oid) throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        return this.getActivityById(oid, true);
    }

    public IVfsVersionSet getVersionSetByUrl(String versionSetUrl) throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        return this.getActivityByUrl(versionSetUrl, true);
    }

    IVfsActivity[] getClosedActivitiesBy(IVfsWorkspace workspace, String user, Date from, Date to, String[] additionalProperties, boolean containingFiles) throws VfsException {
        return (IVfsActivity[])this.getVersionSetsBy(workspace, user, from, to, false, additionalProperties, containingFiles, false);
    }

    IVfsVersionSet[] getVersionSetsBy(IVfsWorkspace workspace, String user, Date from, Date to, boolean returnPropagationList, String[] additionalProperties, boolean containingFiles, boolean withoutPropagationRequestID) throws VfsException {
        IActivityQuery closedActivityQuery = ActivityReportFactory.getInstance().createQuery();
        closedActivityQuery.setClosedOnly(true);
        if (returnPropagationList) {
            closedActivityQuery.applyToPropagations(true);
        }
        if (workspace != null) {
            closedActivityQuery.addWorkspace(workspace.getAbsoluteRemotePath());
        }
        if (user != null) {
            closedActivityQuery.setUser(user);
        }
        if (from != null || to != null) {
            closedActivityQuery.setIntegrationDate(from, to);
        }
        if (withoutPropagationRequestID) {
            closedActivityQuery.applyToActivitiesWithoutPropagationRequestId(true);
        }
        return VfsActivity.getActivities(this, closedActivityQuery, additionalProperties, containingFiles);
    }

    IVfsWorkspace[] getWorkspacesContainingClosedActivities(IVfsWorkspace workspace, String user, Date from, Date to) throws VfsException {
        IVfsActivity[] closedActivities = this.getClosedActivitiesBy(workspace, user, from, to, VfsActivity.EMPTY_PROPERTIES_ARRAY, false);
        HashSet<IVfsWorkspace> workspaces = new HashSet<IVfsWorkspace>();
        int i = 0;
        while (i < closedActivities.length) {
            IVfsActivity closedActivity = closedActivities[i];
            if (closedActivity.getWorkspace() != null) {
                workspaces.add(closedActivity.getWorkspace());
            }
            ++i;
        }
        return workspaces.toArray(EMPTY_WORKSPACE_ARRAY);
    }

    public IVfsWorkspace[] getWorkspacesContainingClosedActivitiesBy(Date from, Date to) throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        return this.getWorkspacesContainingClosedActivities(VfsWorkspace.NULL_WORKSPACE, this.getContext().getUserName(this.getConnectionTemplateId()), from, to);
    }

    public IVfsWorkspace[] getWorkspacesContainingClosedActivitiesBy(String user, Date from, Date to) throws VfsException {
        return this.getWorkspacesContainingClosedActivities(VfsWorkspace.NULL_WORKSPACE, user, from, to);
    }

    public IVfsActivity[] getClosedActivitiesBy(Date from, Date to) throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        return this.getClosedActivitiesBy(VfsWorkspace.NULL_WORKSPACE, this.getContext().getUserName(this.getConnectionTemplateId()), from, to, VfsActivity.EMPTY_PROPERTIES_ARRAY, false);
    }

    public IVfsActivity[] getClosedActivitiesBy(String user, Date from, Date to) throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        return this.getClosedActivitiesBy(VfsWorkspace.NULL_WORKSPACE, user, from, to, VfsActivity.EMPTY_PROPERTIES_ARRAY, false);
    }

    IVfsContext getContext() {
        return this.m_context;
    }

    void addEmptyActivity(IVfsActivity activity) throws VfsException {
        if (!activity.isEmpty()) {
            throw new VfsException("Changelist is not empty.");
        }
        this.m_emptyActivities.put(activity.getAbsoluteRemotePath(), activity);
    }

    void removeEmptyActivity(IVfsActivity activity) {
        this.m_emptyActivities.remove(activity.getAbsoluteRemotePath());
    }

    public IVfsActivity getActivityByName(String name) throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Null name parameter");
        }
        String absoluteRemotePath = this.computeAbsoluteRemotePathOfActivity(name);
        IVfsActivity activity = (IVfsActivity)this.m_emptyActivities.get(absoluteRemotePath);
        if (activity != null) {
            return activity;
        }
        Iterator workspaceIterator = this.m_workspaces.values().iterator();
        while (workspaceIterator.hasNext()) {
            IVfsWorkspace vfsWorkspace = (IVfsWorkspace)workspaceIterator.next();
            activity = ((VfsWorkspace)vfsWorkspace).getOpenActivityByAbsoluteRemotePath(absoluteRemotePath);
            if (activity == null) continue;
            return activity;
        }
        return this.getActivityFromRepository(absoluteRemotePath, false);
    }

    IVfsActivity getActivityFromRepository(String absoluteRemotePath) throws VfsException {
        return VfsActivity.getVfsActivityFromRepository(this, absoluteRemotePath, false);
    }

    IVfsActivity getActivityFromRepository(String absoluteRemotePath, boolean returnPropagationList) throws VfsException {
        return VfsActivity.getVfsActivityFromRepository(this, absoluteRemotePath, returnPropagationList);
    }

    String computeAbsoluteRemotePathOfActivity(String name) throws VfsException {
        IActivityCollection[] activityCollections = this.getActivityCollections();
        String absoluteRemotePath = Util.assureTrailingSlash(activityCollections[0].getDecodedPath()) + name;
        return absoluteRemotePath;
    }

    public void refreshIntegrateCollisions(IVfsCollisionQuery query) throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        IVfsWorkspace[] workspaces = null;
        workspaces = query.getWorkspaceSet() == null || query.getWorkspaceSet().length == 0 ? this.getWorkspaces() : this.getWorkspacesFromPaths(query.getWorkspaceSet());
        this.fireCollisionQueryReport(query, workspaces);
    }

    private void fireCollisionQueryReport(IVfsCollisionQuery query, IVfsWorkspace[] workspaces) throws VfsException {
        IPersistentCollision[] collisions;
        if (this.m_collisionReport == null) {
            this.m_collisionReport = CollisionReportFactory.getInstance().createReport(this.getConnectionTemplateId(), this.m_repositoryRootLocator.getAbsoluteRemotePath());
        }
        if (this.m_collisionQuery == null) {
            this.m_collisionQuery = CollisionReportFactory.getInstance().createQuery();
        }
        if (query.getOwner() == null) {
            this.m_collisionQuery.setOwner(null);
        } else if (query.getOwner().equalsIgnoreCase("ALL")) {
            this.m_collisionQuery.setOwner(null);
        } else {
            this.m_collisionQuery.setOwner(this.getContext().getUserName(this.getConnectionTemplateId()));
        }
        if (query.getCollisionState() != null) {
            this.m_collisionQuery.setCollisionState(CollisionState.getEnumFromName(query.getCollisionState().getName()));
        }
        int i = 0;
        int workspacesLength = workspaces.length;
        while (i < workspacesLength) {
            if (i == 0) {
                this.m_collisionQuery.setWorkspace(workspaces[i].getAbsoluteRemotePath());
            } else {
                this.m_collisionQuery.addWorkspaceQuery(workspaces[i].getAbsoluteRemotePath());
            }
            ++i;
        }
        try {
            collisions = this.m_collisionReport.select(this.m_collisionQuery);
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Collision report (get open collision for current repository and user) failed", vcmFailure);
        }
        VfsRepository.clearCollisionCacheOfWorkspaces(this.getWorkspacesContainingCollisions());
        VfsException vfsException = null;
        int i2 = 0;
        while (i2 < collisions.length) {
            String workspacePath = collisions[i2].getWorkspace().getDecodedPath();
            VfsWorkspace workspace = (VfsWorkspace)this.getWorkspaceByPathFromCache(workspacePath);
            if (workspace != null) {
                VfsIntegrateCollision vfsIntCollision = new VfsIntegrateCollision(this.getVersionedFileSystemManager(), collisions[i2], workspace);
                workspace.addToIntegrateCollisionCache(vfsIntCollision);
            } else {
                vfsException = vfsException != null ? vfsException : new VfsException("Internal Error: workspace containing collision not found");
            }
            ++i2;
        }
    }

    private static void clearCollisionCacheOfWorkspaces(IVfsWorkspace[] workspaces) {
        int i = 0;
        while (i < workspaces.length) {
            try {
                VfsWorkspace workspace = (VfsWorkspace)workspaces[i];
                workspace.clearCollisionCache();
            }
            catch (Exception x) {
                LogUtil.logException((Location)LOCATION, (Throwable)x);
            }
            ++i;
        }
    }

    public IVfsWorkspace[] getWorkspacesContainingCollisions() {
        this.getVersionedFileSystemManager().checkState();
        IVfsWorkspace[] allWorkspaces = this.getWorkspaces();
        ArrayList<IVfsWorkspace> workspaces = new ArrayList<IVfsWorkspace>(allWorkspaces.length);
        int i = 0;
        while (i < allWorkspaces.length) {
            try {
                IVfsWorkspace workspace = allWorkspaces[i];
                if (workspace.getIntegrateCollisions().length > 0) {
                    workspaces.add(workspace);
                }
            }
            catch (Exception x) {
                LogUtil.logException((Location)LOCATION, (Throwable)x);
            }
            ++i;
        }
        return workspaces.toArray(new IVfsWorkspace[0]);
    }

    private IVfsWorkspace[] getWorkspacesFromPaths(String[] workspacePaths) {
        IVfsWorkspace[] workspaces = new IVfsWorkspace[workspacePaths.length];
        int i = 0;
        while (i < workspacePaths.length) {
            workspaces[i] = this.getWorkspaceByPathFromCache(workspacePaths[i]);
            ++i;
        }
        return workspaces;
    }

    VersionedFileSystemManager getVersionedFileSystemManager() {
        if (this.m_vfsManager == null || this.m_vfsManager.isReleased()) {
            throw new IllegalStateException("Versioned file system manager was released");
        }
        return this.m_vfsManager;
    }

    void addWorkspace(IVfsWorkspace workspace) throws VfsException {
        this.m_workspaces.put(workspace.getAbsoluteRemotePath(), workspace);
        try {
            this.m_workspacesByOID.put(workspace.getObjectID(), workspace);
        }
        catch (VfsException e) {
            if (e.getCause() != null && e.getCause() instanceof VcmFailure && ((VcmFailure)e.getCause()).getStatusCode() == 403) {
                return;
            }
            throw e;
        }
    }

    IVfsWorkspace getWorkspaceByOIDFromCache(String oid) {
        return (IVfsWorkspace)this.m_workspacesByOID.get(oid);
    }

    IVfsWorkspace getWorkspaceByPathFromCache(String absoluteRemotePath) {
        return (IVfsWorkspace)this.m_workspaces.get(absoluteRemotePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date getServerTime() throws VfsException {
        Date date;
        OptionsRequest request = new OptionsRequest(this.getAbsoluteRemotePath());
        IConnectionPool connectionPool = ConnectionPool.getInstance();
        IConnection connection = null;
        try {
            connection = connectionPool.acquireConnection(this.getConnectionTemplateId());
        }
        catch (OutOfConnectionsException outOfConnections) {
            throw new VfsException("Could not aquire connection (" + outOfConnections.getMessage() + ").", outOfConnections);
        }
        catch (TemplateException e) {
            throw new VfsException("Could not aquire connection (" + e.getMessage() + ").", e);
        }
        try {
            try {
                IResponse response = request.perform(connection);
                String httpDate = response.getHeaderValue("Date");
                Date date2 = Converter.parseHTTPDate(httpDate);
                if (date2 == null) {
                    throw new VfsException("Could not parse date (" + httpDate + ").");
                }
                date = date2;
                Object var9_11 = null;
            }
            catch (Exception e) {
                throw new VfsException("Getting date failed (" + e.getMessage() + ").", e);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            connectionPool.releaseConnection(connection, false);
            throw throwable;
        }
        connectionPool.releaseConnection(connection, false);
        return date;
    }

    boolean supportsMget() {
        block6: {
            if (EnvironmentVariables.FORCE_CLASSIC_SYNC) {
                return false;
            }
            if (this._supportsMget == null) {
                IResourceFactory proxyFactory = ResourceFactoryManager.getInstance().getProxyFactory();
                try {
                    this._supportsMget = Boolean.FALSE;
                    IResource dvResource = proxyFactory.createResource(this.getConnectionTemplateId(), this.getAbsoluteRemotePath(), PathEncodingFlag.DECODED);
                    IProperty dvProperty = dvResource.getProperty(DAV.SUPPORTED_REPORT_SET.qualifiedName);
                    if (dvProperty == null) break block6;
                    IElement element = dvProperty.getFirstChild();
                    while (element != null) {
                        if (element.getNamespace().equals(XCM.NAMESPACE_PREFIX) && element.getName().equals("list-collection")) {
                            this._supportsMget = Boolean.TRUE;
                            break;
                        }
                        element = element.getNext();
                    }
                }
                catch (VcmFailure vcmFailure) {
                    LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
                }
            }
        }
        return this._supportsMget;
    }

    String getUserNameFromUserStore() throws VfsException {
        block5: {
            if (this.m_userNameFromUserStore != null && this.m_userNameFromUserStore.length() != 0) {
                return this.m_userNameFromUserStore;
            }
            if (this.m_userPricipalFilePath == null) {
                this.m_userPricipalFilePath = this.getAbsoluteRemotePath() + "principals/" + this.getContext().getUserName(this.getConnectionTemplateId()).toUpperCase();
            }
            try {
                IResourceFactory proxyFactory = ResourceFactoryManager.getInstance().getProxyFactory();
                IResource dvResource = proxyFactory.createResource(this.getConnectionTemplateId(), this.m_userPricipalFilePath, PathEncodingFlag.DECODED);
                IPropertyCacheControl propertyCacheControl = dvResource.getPropertyCacheControl();
                propertyCacheControl.clearAll();
                propertyCacheControl.addPropertyToCache(VfsXcmProperty.USER_MANAGEMENT_NAME.getCompletePropertyName());
                dvResource.refresh();
                IProperty dvProperty = dvResource.getProperty(VfsXcmProperty.USER_MANAGEMENT_NAME.getCompletePropertyName());
                if (dvProperty != null) {
                    this.m_userNameFromUserStore = dvProperty.getValue();
                    return this.m_userNameFromUserStore;
                }
            }
            catch (VcmFailure vcmFailure) {
                if (vcmFailure.getStatusCode() == 404) break block5;
                throw new VfsException("Checking user name from repository failed", vcmFailure);
            }
        }
        this.m_userNameFromUserStore = this.getContext().getUserName(this.getConnectionTemplateId()).toUpperCase();
        return this.m_userNameFromUserStore;
    }

    IActivityCollection[] getActivityCollections() throws VfsException {
        if (this.m_activityCollections.length == 0) {
            IRepositoryOptions dvOptions = RepositoryOptionsAccess.getInstance();
            try {
                this.m_activityCollections = dvOptions.getActivityCollectionSet(this.m_repositoryRootLocator.getConnectionTemplateId(), this.m_context.getUrl(this.m_repositoryRootLocator));
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Get the folder containing the activities on server failed: " + vcmFailure.getMessage(), vcmFailure);
            }
        }
        return this.m_activityCollections;
    }

    Map getActivityQueryOptions() throws VfsException {
        return this.m_repositoryOptions.getFunctionalityOptions(VfsRepositoryOptions.Functionality.ACTIVITY_QUERY);
    }

    Map getListCollectionReportOptions() throws VfsException {
        return this.m_repositoryOptions.getFunctionalityOptions(VfsRepositoryOptions.Functionality.LIST_COLLECTION_REPORT);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

