/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.PropertyFactoryAccess;
import com.tssap.dtr.client.lib.deltavlib.properties.IElement;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.vfs.IVfsProperty;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class VfsProperty
implements IVfsProperty {
    IResource _dvResource;
    IProperty m_dvProperty;
    IElement m_dvElement;
    public static final IVfsProperty[] NO_PROPERTIES = new IVfsProperty[0];

    public IResource getDvResource() {
        return this._dvResource;
    }

    VfsProperty(IResource dvResource, IProperty dvProperty) {
        this._dvResource = dvResource;
        this.m_dvProperty = dvProperty;
    }

    VfsProperty(IResource dvResource, IElement dvProperty) {
        this._dvResource = dvResource;
        this.m_dvElement = dvProperty;
    }

    public IVfsProperty[] getChildren() {
        if (!this.hasChildren()) {
            return NO_PROPERTIES;
        }
        ArrayList<VfsProperty> children = new ArrayList<VfsProperty>();
        IElement child = this.m_dvProperty != null ? this.m_dvProperty.getFirstChild() : this.m_dvElement.getFirstChild();
        while (child != null) {
            children.add(new VfsProperty(this._dvResource, child));
            child = child.getNext();
        }
        return children.toArray(new IVfsProperty[children.size()]);
    }

    public String getName() {
        return this.m_dvProperty != null ? this.m_dvProperty.getName() : this.m_dvElement.getName();
    }

    public String getNamespace() {
        return this.m_dvProperty != null ? this.m_dvProperty.getNamespace() : this.m_dvElement.getNamespace();
    }

    public String getValue() {
        String value;
        String string = value = this.m_dvProperty != null ? this.m_dvProperty.getValue() : this.m_dvElement.getValue();
        if (value == null) {
            value = "";
        }
        return value;
    }

    public boolean hasChildren() {
        return this.m_dvProperty != null ? this.m_dvProperty.getChildCount() > 0 : this.m_dvElement.getChildCount() > 0;
    }

    static IVfsProperty getProperty(IResource resource, String propertyName) throws VfsException {
        if (resource == null) {
            return null;
        }
        if (propertyName == null || propertyName.length() == 0) {
            throw new IllegalArgumentException("propertyName must be non-null and contain 1+ characters.");
        }
        try {
            IProperty dvProperty = resource.getProperty(propertyName);
            if (dvProperty == null) {
                String namespace;
                int nameStart = propertyName.indexOf(58) + 1;
                if (nameStart == 0) {
                    namespace = "DAV";
                } else {
                    namespace = propertyName.substring(0, nameStart - 1);
                    propertyName = propertyName.substring(nameStart);
                }
                return new VfsProperty(resource, PropertyFactoryAccess.getFactory().createProperty(namespace, propertyName));
            }
            return new VfsProperty(resource, dvProperty);
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting property failed.", vcmFailure);
        }
    }

    public static Map getProperties(IResource resource, String[] propertyNames) throws VfsException {
        if (propertyNames == null) {
            throw new IllegalArgumentException("propertyNames must be non-null.");
        }
        if (propertyNames.length == 0) {
            return Collections.EMPTY_MAP;
        }
        try {
            IProperty[] dvProperties = resource.getPropertySet(propertyNames);
            if (dvProperties == null || dvProperties.length == 0) {
                throw new VfsException("Getting properties failed.");
            }
            TreeMap<String, VfsProperty> map = new TreeMap<String, VfsProperty>();
            int i = 0;
            while (i < dvProperties.length) {
                IProperty dvProperty = dvProperties[i];
                if (dvProperty != null) {
                    map.put(dvProperty.getQualifiedName(), new VfsProperty(resource, dvProperty));
                }
                ++i;
            }
            return map;
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting properties failed.", vcmFailure);
        }
    }

    public String toString() {
        if (this.m_dvProperty != null) {
            return this.m_dvProperty.getQualifiedName();
        }
        if (this.m_dvElement != null) {
            return this.m_dvElement.getQualifiedName();
        }
        return "<unknown property>";
    }

    public int compareTo(Object o) {
        if (o == null) {
            return -2;
        }
        return this.toString().compareTo(o.toString());
    }
}

