/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityListener;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsCheckinCollision;
import com.tssap.dtr.client.lib.vfs.IVfsCollision;
import com.tssap.dtr.client.lib.vfs.IVfsCollisionListener;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItemListener;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItemListener2;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.IVfsManagerListener;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersionListener;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class VfsListenerHandler {
    private static HashSet m_vfsManagerListener = new HashSet();
    private HashSet m_activityListeners = new HashSet();
    private HashSet m_folderItemListeners = new HashSet();
    private HashSet m_versionListeners = new HashSet();
    private HashSet m_collisionListeners = new HashSet();
    private boolean m_delayedListening;
    private HashSet m_internalActivityListeners = new HashSet();
    private HashSet m_internalFolderItemListeners = new HashSet();
    private HashSet m_internalVersionListeners = new HashSet();
    private HashSet m_internalCollisionListeners = new HashSet();
    private VfsEventCollector m_eventCollector = new VfsEventCollector();
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$VfsListenerHandler == null ? (class$com$tssap$dtr$client$lib$vfs$impl$VfsListenerHandler = VfsListenerHandler.class$("com.tssap.dtr.client.lib.vfs.impl.VfsListenerHandler")) : class$com$tssap$dtr$client$lib$vfs$impl$VfsListenerHandler));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$VfsListenerHandler;

    void reset() {
        this.m_activityListeners.clear();
        this.m_folderItemListeners.clear();
        this.m_versionListeners.clear();
    }

    boolean isVfsInternalDelayedListeningTurnedOn() {
        return this.m_delayedListening || !this.m_internalActivityListeners.isEmpty() || !this.m_internalFolderItemListeners.isEmpty() || !this.m_internalVersionListeners.isEmpty();
    }

    synchronized void startVfsInternalDelayedListening() {
        if (this.isVfsInternalDelayedListeningTurnedOn()) {
            return;
        }
        this.m_delayedListening = true;
        this.addInternalActivityListener(this.getInternalEventCollector());
        this.addInternalFolderItemListener(this.getInternalEventCollector());
        this.addInternalVersionListener(this.getInternalEventCollector());
    }

    synchronized void stopVfsInternalDelayedListening() {
        if (!this.isVfsInternalDelayedListeningTurnedOn()) {
            return;
        }
        this.pureStopVfsInternalDelayedListening();
        this.fireCollectedEvents(this.getInternalEventCollector());
    }

    private void pureStopVfsInternalDelayedListening() {
        this.m_delayedListening = false;
        this.resetInternalActivityListeners();
        this.resetInternalFolderItemListeners();
        this.resetInternalVersionListeners();
    }

    void resetInternalListening() {
        throw new UnsupportedOperationException();
    }

    private void fireCollectedEvents(VfsEventCollector eventCollector) {
        Iterator collectedEventsIterator = eventCollector.getCollectedEvents();
        while (collectedEventsIterator.hasNext()) {
            VfsEvent event = (VfsEvent)collectedEventsIterator.next();
            if (event.getEventType() == VfsEventType.ACTIVITY_ITEMS_ADDED_OR_REMOVED) {
                this.fireEventActivityItemsAddedOrRemoved(event.getActivity());
                continue;
            }
            if (event.getEventType() == VfsEventType.ACTIVITY_STATE_CHANGED) {
                this.fireEventActivityStateChanged(event.getActivity(), event.getOldActivityState());
                continue;
            }
            if (event.getEventType() == VfsEventType.ACTIVITY_NAME_OR_DESCRIPTION_CHANGED) {
                this.fireEventActivityNameOrDescriptionChanged(event.getActivity());
                continue;
            }
            if (event.getEventType() == VfsEventType.BEFORE_ACTIVITY_CHECKIN) {
                this.fireEventBeforeCheckingInActivity(event.getActivity());
                continue;
            }
            if (event.getEventType() == VfsEventType.ACTIVITY_CREATED) {
                this.fireEventActivityCreated(event.getActivity());
                continue;
            }
            if (event.getEventType() == VfsEventType.ACTIVITY_DELETED) {
                this.fireEventActivityDeleted(event.getActivity(), event.getOldActivityState());
                continue;
            }
            if (event.getEventType() == VfsEventType.FOLDER_ITEMS_ACTIVITY_STATE_CHANGED) {
                this.fireEventFolderItemActivityStateChanged(event.getFolderItem().asActivityRecordedFolderItem(), event.getFolderItemActivityState());
                continue;
            }
            if (event.getEventType() == VfsEventType.FOLDER_ITEMS_CONTENT_CHANGED) {
                this.fireEventFolderItemContentChanged(event.m_absoluteLocalPath, event.m_manager, event.m_reason);
                continue;
            }
            if (event.getEventType() == VfsEventType.FOLDER_ITEMS_LOCATION_STATE_CHANGED) {
                this.fireEventFolderItemLocationStateChanged(event.getFolderItem(), event.getFolderItemLocationState());
                continue;
            }
            if (event.getEventType() == VfsEventType.ITEMS_ADDED_OR_REMOVED_IN_FOLDER) {
                this.fireEventFolderItemsAddedOrRemoved(event.getFolderItem().asGenericFolder());
                continue;
            }
            if (event.getEventType() == VfsEventType.VERSION_CHANGED_ON_FOLDER_ITEM) {
                this.fireEventVersionChanged(event.getFolderItem().asActivityRecordedFolderItem(), event.getVersion());
                continue;
            }
            if (event.getEventType() == VfsEventType.VERSION_DISCARDED) {
                this.fireEventVersionDiscarded(event.getFolderItem().asActivityRecordedFolderItem(), event.getCollision(), event.getVersion());
                continue;
            }
            if (event.getEventType() == VfsEventType.MERGE_VERSION_CREATED) {
                this.fireEventMergeVersionCreated(event.getFolderItem().asActivityRecordedFolderItem(), event.getCollision());
                continue;
            }
            throw new UnsupportedOperationException("Internal error: unknown event in internal event collection");
        }
        eventCollector.reset();
    }

    private VfsEventCollector getInternalEventCollector() {
        return this.m_eventCollector;
    }

    static void addVfsManagerListener(IVfsManagerListener listener) {
        m_vfsManagerListener.add(listener);
    }

    static void removeVfsManagerListener(IVfsManagerListener listener) {
        m_vfsManagerListener.remove(listener);
    }

    private static Iterator getVfsManagerListeners() {
        return m_vfsManagerListener.iterator();
    }

    void addActivityListener(IVfsActivityListener listener) {
        this.m_activityListeners.add(listener);
    }

    void removeActivityListener(IVfsActivityListener listener) {
        this.m_activityListeners.remove(listener);
    }

    private Iterator getActivityListeners() {
        return this.m_activityListeners.iterator();
    }

    private void addInternalActivityListener(IVfsActivityListener listener) {
        this.m_internalActivityListeners.add(listener);
    }

    private void removeInternalActivityListener(IVfsActivityListener listener) {
        this.m_internalActivityListeners.remove(listener);
    }

    private void resetInternalActivityListeners() {
        this.m_internalActivityListeners.clear();
    }

    private Iterator getInternalActivityListeners() {
        return this.m_internalActivityListeners.iterator();
    }

    void addFolderItemListener(IVfsFolderItemListener listener) {
        this.m_folderItemListeners.add(listener);
    }

    void removeFolderItemListener(IVfsFolderItemListener listener) {
        this.m_folderItemListeners.remove(listener);
    }

    private Iterator getFolderItemListeners() {
        return this.m_folderItemListeners.iterator();
    }

    private void addInternalFolderItemListener(IVfsFolderItemListener listener) {
        this.m_internalFolderItemListeners.add(listener);
    }

    private void removeInternalFolderItemListener(IVfsFolderItemListener listener) {
        this.m_internalFolderItemListeners.remove(listener);
    }

    private void resetInternalFolderItemListeners() {
        this.m_internalFolderItemListeners.clear();
    }

    private Iterator getInternalFolderItemListeners() {
        return this.m_internalFolderItemListeners.iterator();
    }

    void addVersionListener(IVfsVersionListener listener) {
        this.m_versionListeners.add(listener);
    }

    void removeVersionListener(IVfsVersionListener listener) {
        this.m_versionListeners.remove(listener);
    }

    private Iterator getVersionListeners() {
        return this.m_versionListeners.iterator();
    }

    private void addInternalVersionListener(IVfsVersionListener listener) {
        this.m_internalVersionListeners.add(listener);
    }

    private void removeInternalVersionListener(IVfsVersionListener listener) {
        this.m_internalVersionListeners.remove(listener);
    }

    private void resetInternalVersionListeners() {
        this.m_internalVersionListeners.clear();
    }

    private Iterator getInternalVersionListeners() {
        return this.m_internalVersionListeners.iterator();
    }

    void addCollisionListener(IVfsCollisionListener listener) {
        this.m_collisionListeners.add(listener);
    }

    void removeCollisionListener(IVfsCollisionListener listener) {
        this.m_collisionListeners.remove(listener);
    }

    private Iterator getCollisionListeners() {
        return this.m_collisionListeners.iterator();
    }

    private void addInternalCollisionListener(IVfsCollisionListener listener) {
        this.m_internalCollisionListeners.add(listener);
    }

    private void removeInternalCollisionListener(IVfsCollisionListener listener) {
        this.m_internalCollisionListeners.remove(listener);
    }

    private void resetInternalCollisionListeners() {
        this.m_internalCollisionListeners.clear();
    }

    private Iterator getInternalCollisionListeners() {
        return this.m_internalCollisionListeners.iterator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void fireEventVfsManagerCreated(VersionedFileSystemManager vfsManager) {
        LOCATION.pathT("fireEventVfsManagerCreated", "calling listeners ({0}), new manager's hashCode={1}", new Object[]{new Integer(m_vfsManagerListener.size()), new Integer(vfsManager.hashCode())});
        Iterator listenerIterator = VfsListenerHandler.getVfsManagerListeners();
        while (listenerIterator.hasNext()) {
            long elapsed;
            Object var7_5;
            IVfsManagerListener listener = (IVfsManagerListener)listenerIterator.next();
            long start = System.currentTimeMillis();
            try {
                try {
                    listener.created(vfsManager);
                }
                catch (Exception e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                    var7_5 = null;
                    elapsed = System.currentTimeMillis() - start;
                    LogUtil.logElapsedTime((long)elapsed, (String)("IVfsManagerListener.created(" + vfsManager.getCurrentContext() + ") called on " + listener));
                    continue;
                }
                var7_5 = null;
            }
            catch (Throwable throwable) {
                var7_5 = null;
                elapsed = System.currentTimeMillis() - start;
                LogUtil.logElapsedTime((long)elapsed, (String)("IVfsManagerListener.created(" + vfsManager.getCurrentContext() + ") called on " + listener));
                throw throwable;
            }
            elapsed = System.currentTimeMillis() - start;
            LogUtil.logElapsedTime((long)elapsed, (String)("IVfsManagerListener.created(" + vfsManager.getCurrentContext() + ") called on " + listener));
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void fireEventVfsManagerReleased(VersionedFileSystemManager vfsManager) {
        String METHOD = "fireEventVfsManagerReleased";
        LOCATION.pathT("fireEventVfsManagerReleased", "calling listeners ({0}), old manager's hashCode={1}", new Object[]{new Integer(m_vfsManagerListener.size()), new Integer(vfsManager.hashCode())});
        Iterator listenerIterator = VfsListenerHandler.getVfsManagerListeners();
        while (listenerIterator.hasNext()) {
            long elapsed;
            Object var8_6;
            IVfsManagerListener listener = (IVfsManagerListener)listenerIterator.next();
            long start = System.currentTimeMillis();
            try {
                try {
                    LOCATION.debugT("fireEventVfsManagerReleased", "for listener: " + listener);
                    listener.released(vfsManager);
                    LOCATION.debugT("fireEventVfsManagerReleased", "done for listener: " + listener);
                }
                catch (Exception e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                    var8_6 = null;
                    elapsed = System.currentTimeMillis() - start;
                    LogUtil.logElapsedTime((long)elapsed, (String)("IVfsManagerListener.released(" + vfsManager.getClientName() + ") called on " + listener));
                    continue;
                }
                var8_6 = null;
            }
            catch (Throwable throwable) {
                var8_6 = null;
                elapsed = System.currentTimeMillis() - start;
                LogUtil.logElapsedTime((long)elapsed, (String)("IVfsManagerListener.released(" + vfsManager.getClientName() + ") called on " + listener));
                throw throwable;
            }
            elapsed = System.currentTimeMillis() - start;
            LogUtil.logElapsedTime((long)elapsed, (String)("IVfsManagerListener.released(" + vfsManager.getClientName() + ") called on " + listener));
        }
        return;
    }

    void fireEventActivityCreated(IVfsActivity activity) {
        Iterator listenerIterator;
        if (this.getInternalActivityListeners().hasNext()) {
            listenerIterator = this.getInternalActivityListeners();
        } else {
            LOCATION.pathT("fireEventActivityCreated", "calling listeners ({0})", new Object[]{new Integer(this.m_activityListeners.size())});
            listenerIterator = this.getActivityListeners();
        }
        while (listenerIterator.hasNext()) {
            IVfsActivityListener listener = (IVfsActivityListener)listenerIterator.next();
            try {
                listener.created(activity);
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    void fireEventActivityDeleted(IVfsActivity activity, VfsActivityState oldState) {
        Iterator listenerIterator;
        if (this.getInternalActivityListeners().hasNext()) {
            listenerIterator = this.getInternalActivityListeners();
        } else {
            LOCATION.pathT("fireEventActivityDeleted", "calling listeners ({0})", new Object[]{new Integer(this.m_activityListeners.size())});
            listenerIterator = this.getActivityListeners();
        }
        while (listenerIterator.hasNext()) {
            IVfsActivityListener listener = (IVfsActivityListener)listenerIterator.next();
            try {
                listener.deleted(activity, oldState);
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    void fireEventActivityItemsAddedOrRemoved(IVfsActivity activity) {
        Iterator listenerIterator;
        if (this.getInternalActivityListeners().hasNext()) {
            listenerIterator = this.getInternalActivityListeners();
        } else {
            LOCATION.pathT("fireEventActivityItemsAddedOrRemoved", "calling listeners ({0})", new Object[]{new Integer(this.m_activityListeners.size())});
            listenerIterator = this.getActivityListeners();
        }
        while (listenerIterator.hasNext()) {
            IVfsActivityListener listener = (IVfsActivityListener)listenerIterator.next();
            try {
                listener.itemsAddedOrRemoved(activity);
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    void fireEventBeforeCheckingInActivity(IVfsActivity activity) {
        Iterator listenerIterator;
        if (this.getInternalActivityListeners().hasNext()) {
            listenerIterator = this.getInternalActivityListeners();
        } else {
            LOCATION.pathT("fireEventBeforeCheckingInActivity", "calling listeners ({0})", new Object[]{new Integer(this.m_activityListeners.size())});
            listenerIterator = this.getActivityListeners();
        }
        while (listenerIterator.hasNext()) {
            IVfsActivityListener listener = (IVfsActivityListener)listenerIterator.next();
            try {
                listener.beforeCheckin(activity);
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    void fireEventActivityStateChanged(IVfsActivity activity, VfsActivityState oldState) {
        Iterator listenerIterator;
        if (this.getInternalActivityListeners().hasNext()) {
            listenerIterator = this.getInternalActivityListeners();
        } else {
            LOCATION.pathT("fireEventActivityStateChanged", "calling listeners ({0})", new Object[]{new Integer(this.m_activityListeners.size())});
            listenerIterator = this.getActivityListeners();
        }
        while (listenerIterator.hasNext()) {
            IVfsActivityListener listener = (IVfsActivityListener)listenerIterator.next();
            try {
                listener.stateChanged(activity, oldState);
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    void fireEventActivityNameOrDescriptionChanged(IVfsActivity activity) {
        Iterator listenerIterator = this.getInternalActivityListeners().hasNext() ? this.getInternalActivityListeners() : this.getActivityListeners();
        while (listenerIterator.hasNext()) {
            IVfsActivityListener listener = (IVfsActivityListener)listenerIterator.next();
            try {
                listener.nameOrDescriptionChanged(activity);
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    void fireEventFolderItemContentChanged(String absoluteLocalPath, IVersionedFileSystemManager manager, IVfsFolderItemListener2.ContentChangeReasons reason) {
        Iterator listenerIterator;
        if (this.getInternalFolderItemListeners().hasNext()) {
            listenerIterator = this.getInternalFolderItemListeners();
        } else {
            LOCATION.pathT("fireEventFolderItemContentChanged", "calling {0} listeners", new Object[]{new Integer(this.m_folderItemListeners.size())});
            listenerIterator = this.getFolderItemListeners();
        }
        while (listenerIterator.hasNext()) {
            IVfsFolderItemListener listener = (IVfsFolderItemListener)listenerIterator.next();
            try {
                if (!(listener instanceof IVfsFolderItemListener2)) continue;
                ((IVfsFolderItemListener2)listener).contentChanged(absoluteLocalPath, manager, reason);
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    void fireEventFolderItemLocationStateChanged(IVfsFolderItem folderItem, VfsFolderItemLocationState oldState) {
        Iterator listenerIterator;
        if (this.getInternalFolderItemListeners().hasNext()) {
            listenerIterator = this.getInternalFolderItemListeners();
        } else {
            LOCATION.pathT("fireEventFolderItemLocationStateChanged", "calling listeners ({0})", new Object[]{new Integer(this.m_folderItemListeners.size())});
            listenerIterator = this.getFolderItemListeners();
        }
        while (listenerIterator.hasNext()) {
            IVfsFolderItemListener listener = (IVfsFolderItemListener)listenerIterator.next();
            try {
                listener.locationStateChanged(folderItem, oldState);
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    void fireEventFolderItemActivityStateChanged(IVfsActivityRecordedFolderItem folderItem, VfsFolderItemActivityState oldState) {
        Iterator listenerIterator;
        if (this.getInternalFolderItemListeners().hasNext()) {
            listenerIterator = this.getInternalFolderItemListeners();
        } else {
            LOCATION.pathT("fireEventFolderItemActivityStateChanged", "calling listeners ({0})", new Object[]{new Integer(this.m_folderItemListeners.size())});
            listenerIterator = this.getFolderItemListeners();
        }
        while (listenerIterator.hasNext()) {
            IVfsFolderItemListener listener = (IVfsFolderItemListener)listenerIterator.next();
            try {
                listener.activityStateChanged(folderItem, oldState);
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    void fireEventFolderItemsAddedOrRemoved(IVfsGenericFolder parentFolder) {
        Iterator listenerIterator;
        if (this.getInternalFolderItemListeners().hasNext()) {
            listenerIterator = this.getInternalFolderItemListeners();
        } else {
            LOCATION.pathT("fireEventFolderItemsAddedOrRemoved", "calling listeners ({0})", new Object[]{new Integer(this.m_folderItemListeners.size())});
            listenerIterator = this.getFolderItemListeners();
        }
        while (listenerIterator.hasNext()) {
            IVfsFolderItemListener listener = (IVfsFolderItemListener)listenerIterator.next();
            try {
                listener.itemsAddedOrRemoved(parentFolder);
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    void fireEventVersionChanged(IVfsActivityRecordedFolderItem folderItem, IVfsVersion oldVersion) {
        Iterator listenerIterator;
        if (this.getInternalVersionListeners().hasNext()) {
            listenerIterator = this.getInternalVersionListeners();
        } else {
            LOCATION.pathT("fireEventVersionChanged", "calling listeners ({0})", new Object[]{new Integer(this.m_versionListeners.size())});
            listenerIterator = this.getVersionListeners();
        }
        while (listenerIterator.hasNext()) {
            IVfsVersionListener listener = (IVfsVersionListener)listenerIterator.next();
            try {
                listener.versionOnFolderItemChanged(folderItem, oldVersion);
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    void fireEventVersionDiscarded(IVfsActivityRecordedFolderItem folderItem, IVfsCollision collision, IVfsVersion discardedVersion) {
        Iterator listenerIterator;
        if (this.getInternalVersionListeners().hasNext()) {
            listenerIterator = this.getInternalCollisionListeners();
        } else {
            LOCATION.pathT("fireEventVersionDiscarded", "calling listeners ({0})", new Object[]{new Integer(this.m_collisionListeners.size())});
            listenerIterator = this.getCollisionListeners();
        }
        while (listenerIterator.hasNext()) {
            IVfsCollisionListener listener = (IVfsCollisionListener)listenerIterator.next();
            try {
                listener.versionOnIntegrateCollisionDiscarded(folderItem, collision.getAsIntegrateCollision(), discardedVersion);
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    void fireEventActiveVersionAccepted(IVfsActivityRecordedFolderItem folderItem, IVfsCheckinCollision collision) {
        Iterator listenerIterator;
        if (this.getInternalVersionListeners().hasNext()) {
            listenerIterator = this.getInternalCollisionListeners();
        } else {
            LOCATION.pathT("fireEventActiveVersionAccepted", "calling listeners ({0})", new Object[]{new Integer(this.m_collisionListeners.size())});
            listenerIterator = this.getCollisionListeners();
        }
        while (listenerIterator.hasNext()) {
            IVfsCollisionListener listener = (IVfsCollisionListener)listenerIterator.next();
            try {
                listener.activeVersionAccepted(folderItem, collision);
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    void fireEventLocalVersionAccepted(IVfsActivityRecordedFolderItem folderItem, IVfsCheckinCollision collision) {
        Iterator listenerIterator;
        if (this.getInternalVersionListeners().hasNext()) {
            listenerIterator = this.getInternalCollisionListeners();
        } else {
            LOCATION.pathT("fireEventLocalVersionAccepted", "calling listeners ({0})", new Object[]{new Integer(this.m_collisionListeners.size())});
            listenerIterator = this.getCollisionListeners();
        }
        while (listenerIterator.hasNext()) {
            IVfsCollisionListener listener = (IVfsCollisionListener)listenerIterator.next();
            try {
                listener.localVersionAccepted(folderItem, collision);
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    void fireEventMergeVersionCreated(IVfsActivityRecordedFolderItem folderItem, IVfsCollision collision) {
        Iterator listenerIterator;
        if (this.getInternalVersionListeners().hasNext()) {
            listenerIterator = this.getInternalCollisionListeners();
        } else {
            LOCATION.pathT("fireEventMergeVersionCreated", "calling listeners ({0})", new Object[]{new Integer(this.m_collisionListeners.size())});
            listenerIterator = this.getCollisionListeners();
        }
        while (listenerIterator.hasNext()) {
            IVfsCollisionListener listener = (IVfsCollisionListener)listenerIterator.next();
            try {
                listener.mergeVersionOnIntegrateCollisionCreated(folderItem, collision.getAsIntegrateCollision());
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class VfsEventCollector
    implements IVfsActivityListener,
    IVfsFolderItemListener2,
    IVfsVersionListener {
        private ArrayList m_collectedEvents = new ArrayList();

        private VfsEventCollector() {
        }

        Iterator getCollectedEvents() {
            return ((AbstractList)this.m_collectedEvents).iterator();
        }

        void reset() {
            this.m_collectedEvents.clear();
        }

        public void beforeCheckin(IVfsActivity activity) {
            this.m_collectedEvents.add(new VfsEvent(VfsEventType.BEFORE_ACTIVITY_CHECKIN, activity));
        }

        public void created(IVfsActivity activity) {
            this.m_collectedEvents.add(new VfsEvent(VfsEventType.ACTIVITY_CREATED, activity));
        }

        public void deleted(IVfsActivity activity, VfsActivityState oldState) {
            this.m_collectedEvents.add(new VfsEvent(VfsEventType.ACTIVITY_DELETED, activity, oldState));
        }

        public void itemsAddedOrRemoved(IVfsActivity activity) {
            this.m_collectedEvents.add(new VfsEvent(VfsEventType.ACTIVITY_ITEMS_ADDED_OR_REMOVED, activity));
        }

        public void stateChanged(IVfsActivity activity, VfsActivityState oldState) {
            this.m_collectedEvents.add(new VfsEvent(VfsEventType.ACTIVITY_STATE_CHANGED, activity, oldState));
        }

        public void nameOrDescriptionChanged(IVfsActivity activity) {
            this.m_collectedEvents.add(new VfsEvent(VfsEventType.ACTIVITY_NAME_OR_DESCRIPTION_CHANGED, activity));
        }

        public void activityStateChanged(IVfsActivityRecordedFolderItem folderItem, VfsFolderItemActivityState oldState) {
            this.m_collectedEvents.add(new VfsEvent(VfsEventType.FOLDER_ITEMS_ACTIVITY_STATE_CHANGED, folderItem, oldState));
        }

        public void itemsAddedOrRemoved(IVfsGenericFolder folder) {
            this.m_collectedEvents.add(new VfsEvent(VfsEventType.ITEMS_ADDED_OR_REMOVED_IN_FOLDER, folder));
        }

        public void contentChanged(String absoluteLocalPath, IVersionedFileSystemManager manager, IVfsFolderItemListener2.ContentChangeReasons reason) {
            this.m_collectedEvents.add(new VfsEvent(VfsEventType.FOLDER_ITEMS_CONTENT_CHANGED, absoluteLocalPath, manager, reason));
        }

        public void locationStateChanged(IVfsFolderItem folderItem, VfsFolderItemLocationState oldState) {
            this.m_collectedEvents.add(new VfsEvent(VfsEventType.FOLDER_ITEMS_LOCATION_STATE_CHANGED, folderItem, oldState));
        }

        public void versionOnFolderItemChanged(IVfsActivityRecordedFolderItem folderItem, IVfsVersion oldVersion) {
            this.m_collectedEvents.add(new VfsEvent(VfsEventType.VERSION_CHANGED_ON_FOLDER_ITEM, folderItem, oldVersion));
        }

        public void versionDicardedOnCollision(IVfsActivityRecordedFolderItem folderItem, IVfsCollision collision, IVfsVersion discardedVersion) {
            this.m_collectedEvents.add(new VfsEvent(VfsEventType.VERSION_DISCARDED, folderItem, collision, discardedVersion));
        }

        public void mergeVersionCreatedOnCollision(IVfsActivityRecordedFolderItem folderItem, IVfsCollision collision) {
            this.m_collectedEvents.add(new VfsEvent(VfsEventType.MERGE_VERSION_CREATED, folderItem, collision));
        }
    }

    private static class VfsEventType {
        private String m_event = null;
        static final VfsEventType ACTIVITY_CREATED = new VfsEventType("ACTIVITY_CREATED");
        static final VfsEventType ACTIVITY_DELETED = new VfsEventType("ACTIVITY_DELETED");
        static final VfsEventType ACTIVITY_ITEMS_ADDED_OR_REMOVED = new VfsEventType("ACTIVITY_ITEMS_ADDED_OR_REMOVED");
        static final VfsEventType ACTIVITY_STATE_CHANGED = new VfsEventType("ACTIVITY_STATE_CHANGED");
        static final VfsEventType ACTIVITY_NAME_OR_DESCRIPTION_CHANGED = new VfsEventType("ACTIVITY_NAME_OR_DESCRIPTION_CHANGED");
        static final VfsEventType BEFORE_ACTIVITY_CHECKIN = new VfsEventType("BEFORE_ACTIVITY_CHECKIN");
        static final VfsEventType FOLDER_ITEMS_ACTIVITY_STATE_CHANGED = new VfsEventType("FOLDER_ITEMS_ACTIVITY_STATE_CHANGED");
        static final VfsEventType FOLDER_ITEMS_CONTENT_CHANGED = new VfsEventType("FOLDER_ITEMS_CONTENT_CHANGED");
        static final VfsEventType FOLDER_ITEMS_LOCATION_STATE_CHANGED = new VfsEventType("FOLDER_ITEMS_LOCATION_STATE_CHANGED");
        static final VfsEventType ITEMS_ADDED_OR_REMOVED_IN_FOLDER = new VfsEventType("ITEMS_ADDED_OR_REMOVED_IN_FOLDER");
        static final VfsEventType VERSION_CHANGED_ON_FOLDER_ITEM = new VfsEventType("VERSION_CHANGED_ON_FOLDER_ITEM");
        static final VfsEventType VERSION_DISCARDED = new VfsEventType("VERSION_DISCARDED");
        static final VfsEventType MERGE_VERSION_CREATED = new VfsEventType("MERGE_VERSION_CREATED ");

        VfsEventType(String event) {
            this.m_event = event;
        }

        public String toString() {
            return this.m_event;
        }
    }

    private static class VfsEvent {
        private VfsEventType m_eventType = null;
        private IVfsActivity m_activity = null;
        private VfsActivityState m_oldActivityState = null;
        private IVfsFolderItem m_folderItem = null;
        private VfsFolderItemActivityState m_folderItemActivityState = null;
        private VfsFolderItemLocationState m_folderItemLocationState = null;
        private IVfsVersion m_version = null;
        private IVfsCollision m_collision = null;
        private String m_absoluteLocalPath;
        private IVfsFolderItemListener2.ContentChangeReasons m_reason;
        private IVersionedFileSystemManager m_manager;

        VfsEvent(VfsEventType eventType, IVfsActivity activity) {
            this.m_eventType = eventType;
            this.m_activity = activity;
        }

        VfsEvent(VfsEventType eventType, IVfsActivity activity, VfsActivityState oldState) {
            this.m_eventType = eventType;
            this.m_activity = activity;
            this.m_oldActivityState = oldState;
        }

        VfsEvent(VfsEventType eventType, IVfsActivityRecordedFolderItem folderItem, VfsFolderItemActivityState oldState) {
            this.m_eventType = eventType;
            this.m_folderItem = folderItem;
            this.m_folderItemActivityState = oldState;
        }

        VfsEvent(VfsEventType eventType, IVfsFolderItem folderItem, VfsFolderItemLocationState oldState) {
            this.m_eventType = eventType;
            this.m_folderItem = folderItem;
            this.m_folderItemLocationState = oldState;
        }

        VfsEvent(VfsEventType eventType, String absoluteLocalPath, IVersionedFileSystemManager manager, IVfsFolderItemListener2.ContentChangeReasons reason) {
            this.m_eventType = eventType;
            this.m_absoluteLocalPath = absoluteLocalPath;
            this.m_manager = manager;
            this.m_reason = reason;
        }

        VfsEvent(VfsEventType eventType, IVfsGenericFolder folder) {
            this.m_eventType = eventType;
            this.m_folderItem = folder;
        }

        VfsEvent(VfsEventType eventType, IVfsActivityRecordedFolderItem folderItem, IVfsVersion oldVersion) {
            this.m_eventType = eventType;
            this.m_folderItem = folderItem;
            this.m_version = oldVersion;
        }

        VfsEvent(VfsEventType eventType, IVfsActivityRecordedFolderItem folderItem, IVfsCollision collision, IVfsVersion discardedVersion) {
            this.m_eventType = eventType;
            this.m_folderItem = folderItem;
            this.m_collision = collision;
            this.m_version = discardedVersion;
        }

        VfsEvent(VfsEventType eventType, IVfsActivityRecordedFolderItem folderItem, IVfsCollision collision) {
            this.m_eventType = eventType;
            this.m_folderItem = folderItem;
            this.m_collision = collision;
        }

        VfsEventType getEventType() {
            return this.m_eventType;
        }

        IVfsCollision getCollision() {
            return this.m_collision;
        }

        IVfsActivity getActivity() {
            return this.m_activity;
        }

        VfsActivityState getOldActivityState() {
            return this.m_oldActivityState;
        }

        IVfsFolderItem getFolderItem() {
            return this.m_folderItem;
        }

        VfsFolderItemActivityState getFolderItemActivityState() {
            return this.m_folderItemActivityState;
        }

        VfsFolderItemLocationState getFolderItemLocationState() {
            return this.m_folderItemLocationState;
        }

        IVfsVersion getVersion() {
            return this.m_version;
        }
    }
}

