/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.IActivity;
import com.tssap.dtr.client.lib.deltavlib.IVersion;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.IWorkingResource;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.xcm.CollisionState;
import com.tssap.dtr.client.lib.deltavlib.xcm.CollisionType;
import com.tssap.dtr.client.lib.deltavlib.xcm.IIntegrateCollision;
import com.tssap.dtr.client.lib.deltavlib.xcm.IPersistentCollision;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItemListener;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsMergeVersion;
import com.tssap.dtr.client.lib.vfs.IVfsProperty;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersionHistory;
import com.tssap.dtr.client.lib.vfs.IVfsVersionListener;
import com.tssap.dtr.client.lib.vfs.IVfsVersionRelation;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsCollisionCategory;
import com.tssap.dtr.client.lib.vfs.VfsCollisionState;
import com.tssap.dtr.client.lib.vfs.VfsCollisionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.VfsVersionRelationType;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivity;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsCollision;
import com.tssap.dtr.client.lib.vfs.impl.VfsFile;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolder;
import com.tssap.dtr.client.lib.vfs.impl.VfsRepository;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersion;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspace;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class VfsIntegrateCollision
extends VfsCollision
implements IVfsIntegrateCollision,
IVfsVersionListener,
IVfsFolderItemListener {
    private final IIntegrateCollision m_dvCollision;
    private final IPersistentCollision m_dvPersistentCollision;
    private IVfsVersion m_activeVersion;
    private IVfsVersion m_collidingVersion;
    private IVfsVersionHistory m_versionHistory;
    private IVfsIntegrateCollision.VfsIntegrateCollisionInternalState m_state;
    private IVfsWorkspace m_workspace;
    private IVfsActivity m_lockingActivity;
    private IVfsIntegrateCollision.VfsDiscardTargetVersion m_discardTarget;
    private VersionedFileSystemManager m_vfsManager;
    private static final IVfsActivityRecordedFolderItem[] EMPTY_PARTICIPANT_LIST = new IVfsActivityRecordedFolderItem[0];
    private static final boolean DEBUG = false;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$VfsIntegrateCollision == null ? (class$com$tssap$dtr$client$lib$vfs$impl$VfsIntegrateCollision = VfsIntegrateCollision.class$("com.tssap.dtr.client.lib.vfs.impl.VfsIntegrateCollision")) : class$com$tssap$dtr$client$lib$vfs$impl$VfsIntegrateCollision));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$VfsIntegrateCollision;

    VfsIntegrateCollision(VersionedFileSystemManager vfsManager, IIntegrateCollision dvCollision, IVfsWorkspace workspace) {
        super(vfsManager, dvCollision);
        this.m_vfsManager = vfsManager;
        this.m_dvCollision = dvCollision;
        this.m_dvPersistentCollision = dvCollision instanceof IPersistentCollision ? (IPersistentCollision)dvCollision : null;
        this.m_workspace = workspace;
        this.m_collidingVersion = new VfsVersion(this.getVersionedFileSystemManager(), this.m_dvCollision.getCollidingVersion());
        try {
            this.m_activeVersion = new VfsVersion(this.getVersionedFileSystemManager(), this.m_dvCollision.getCollisionResource().getActiveVersion());
        }
        catch (VcmFailure e) {
            this.m_activeVersion = new VfsVersion(this.getVersionedFileSystemManager(), this.m_dvCollision.getWorkspaceVersion());
        }
        if (this.m_dvCollision.getCollisionType() != CollisionType.NAME_CLASH) {
            this.m_state = IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.UNKNOWN;
            this.m_discardTarget = this.findDiscardTarget();
        } else {
            this.m_state = IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.OPEN;
        }
        this.m_versionHistory = null;
        vfsManager.addFolderItemListener(this);
        vfsManager.addVersionListener(this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.m_vfsManager.removeFolderItemListener(this);
    }

    public VersionedFileSystemManager getVersionedFileSystemManager() {
        if (this.m_vfsManager == null || this.m_vfsManager.isReleased()) {
            throw new IllegalStateException("Versioned file system manager was released");
        }
        return this.m_vfsManager;
    }

    private IVfsIntegrateCollision.VfsIntegrateCollisionInternalState findCollisionState() {
        CollisionState stateOfCollision;
        boolean openSuccessorFound = false;
        try {
            stateOfCollision = this.m_dvCollision.getCollisionResource().getCollisionState();
        }
        catch (VcmFailure e) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            return IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.OPEN;
        }
        if (stateOfCollision.equals(CollisionState.LOCKED)) {
            return IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.MERGE_ARROW_DRAWN;
        }
        if (stateOfCollision.equals(CollisionState.CLOSED)) {
            return IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.RESOLVED;
        }
        IVfsFile file = null;
        try {
            file = this.m_activeVersion.getCorrespondingFile(this.m_workspace);
            if (file.getActivityState().equals(VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT)) {
                return IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.MERGE_VERSION_PRESENT;
            }
            return IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.OPEN;
        }
        catch (VfsException e1) {
            LogUtil.logException((Location)LOCATION, (Throwable)e1);
            return IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.OPEN;
        }
    }

    public IVfsIntegrateCollision.VfsIntegrateCollisionInternalState getInternalState() {
        if (this.m_state == IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.UNKNOWN) {
            this.m_state = this.findCollisionState();
        }
        return this.m_state;
    }

    public IVfsMergeVersion createMergeVersion(IVfsActivity activity, IVfsWorkspace workspace) throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        this.checkParameterState(activity);
        this.checkParameterState(workspace);
        ((VfsActivity)activity).checkWorkspace(this.getWorkspace());
        try {
            ((VfsWorkspace)workspace).checkIsModifiable();
        }
        catch (VfsException e) {
            VfsException ex = new VfsException("Changes are not allowed because workspace is not modifiable", e);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, ex.getMessage());
            throw ex;
        }
        IVfsMergeVersion mergeVersion = this.getMergeVersion();
        if (mergeVersion != null) {
            return mergeVersion;
        }
        if (!this.m_activeVersion.isDeleted()) {
            IVfsFile mergeVersionFile = this.m_activeVersion.getCorrespondingFile(workspace);
            if (mergeVersionFile == null) {
                throw new VfsException("Unable to merge. File corresponding to the active version could not be found in the workspace : " + workspace.getBrowsePath());
            }
            if (mergeVersionFile.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                if (mergeVersionFile.getLocationState().equals(VfsFolderItemLocationState.SYNCED_TO_FORMER) || mergeVersionFile.getLocationState().equals(VfsFolderItemLocationState.SERVER_ONLY)) {
                    mergeVersionFile.sync();
                }
                mergeVersionFile.checkOutForEdit(activity);
            } else if (mergeVersionFile.getActivityState() != VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
                throw new VfsException("Unable to merge. File has been checked out for Delete");
            }
            IVfsVersion openVersion = this.getOpenSuccessorOfActiveVersion();
            mergeVersion = new VfsVersion.VfsMergeVersion((VfsVersion)openVersion, mergeVersionFile);
        } else {
            IVfsFile undeletedFile = (IVfsFile)((VfsWorkspace)this.getWorkspace()).solveCollisionByUndeletingActiveVcr(this.m_dvCollision.getVCR().getPersistentURL());
            undeletedFile.syncForce();
            undeletedFile.refreshState();
            undeletedFile.checkOutForEdit(activity);
            this.m_activeVersion = undeletedFile.refreshAndGetVersion();
            IVfsVersion openVersion = this.getOpenSuccessorOfActiveVersion();
            mergeVersion = new VfsVersion.VfsMergeVersion((VfsVersion)openVersion, undeletedFile);
        }
        this.m_lockingActivity = activity;
        this.m_state = IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.MERGE_VERSION_PRESENT;
        return mergeVersion;
    }

    private IVfsVersion getOpenSuccessorOfActiveVersion() {
        if (this.m_versionHistory == null) {
            this.m_versionHistory = this.m_activeVersion.getVersionHistoryWithRefresh();
        } else {
            this.m_versionHistory.refreshVersionSet();
        }
        IVfsVersionRelation[] successorRelations = this.m_activeVersion.getSuccessorRelationSet();
        int i = 0;
        while (i < successorRelations.length) {
            IVfsVersion successorVersion = this.m_versionHistory.getVersion(successorRelations[i].getTargetVersionId());
            if (successorVersion.isOpen() && successorVersion.isSyncedOnClient(this.m_workspace)) {
                return successorVersion;
            }
            ++i;
        }
        return null;
    }

    public void discardActiveVersion(IVfsActivity activity, IVfsWorkspace workspace) throws VfsException {
        this.discardActiveVersion(activity);
    }

    public void discardCollidingVersion(IVfsActivity activity, IVfsWorkspace workspace) throws VfsException {
        this.discardCollidingVersion(activity);
    }

    public void discardActiveVersion(IVfsActivity activity) throws VfsException {
        this.discardActiveVersion(activity, true);
    }

    public void discardCollidingVersion(IVfsActivity activity) throws VfsException {
        this.discardCollidingVersion(activity, true);
    }

    void discardActiveVersion(IVfsActivity activity, boolean doNotifyActivityListeners) throws VfsException {
        boolean oldActiveVersionWasDeleted;
        this.checkGeneralPreconditionForDiscard(activity);
        try {
            IVersion collidingVersion = this.m_dvCollision.getCollidingVersion();
            IVersion activeVersion = this.m_dvCollision.getVCR().getActiveVersion();
            this.checkSpecialPreconditionsForDiscard(activity, collidingVersion);
            activeVersion.discard(collidingVersion, ((VfsActivity)activity).getDeltaVActivity(), ((VfsWorkspace)this.m_workspace).getDvWorkspace());
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.SUCCEEDED, null, "Discard of active version completed :  " + activeVersion.getXCMDecodedPath() + " in workspace " + this.m_workspace.getAbsoluteRemotePath());
            this.refreshStatesAfterDiscard(activity, collidingVersion, doNotifyActivityListeners);
        }
        catch (VcmFailure e) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, null, "Discard failed : " + e.getMessage());
            throw new VfsException(e.getMessage());
        }
        IVfsActivityRecordedFolderItem folderItem = this.getActiveVersionFolderItem();
        boolean bl = oldActiveVersionWasDeleted = folderItem == null || folderItem.getLocationState() == VfsFolderItemLocationState.DELETED;
        if (oldActiveVersionWasDeleted) {
            this.refreshParentFolderAfterDiscardActive((VfsActivityRecordedFolderItem)folderItem);
        } else {
            this.refreshFolderItemAfterDiscardActive((VfsActivityRecordedFolderItem)folderItem);
        }
    }

    public void discardCollidingVersion(IVfsActivity activity, boolean doNotifyActivityListeners) throws VfsException {
        this.checkGeneralPreconditionForDiscard(activity);
        try {
            IVersion collidingVersion = this.m_dvCollision.getCollidingVersion();
            IVersion activeVersion = this.m_dvCollision.getVCR().getActiveVersion();
            this.checkSpecialPreconditionsForDiscard(activity, activeVersion);
            collidingVersion.discard(activeVersion, ((VfsActivity)activity).getDeltaVActivity(), ((VfsWorkspace)this.m_workspace).getDvWorkspace());
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.SUCCEEDED, null, "Discard of colliding version completed : " + collidingVersion.getXCMDecodedPath() + " in workspace " + this.m_workspace.getAbsoluteRemotePath());
            this.refreshStatesAfterDiscard(activity, activeVersion, doNotifyActivityListeners);
        }
        catch (VcmFailure e) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, null, "Discard failed : " + e.getMessage());
            throw new VfsException(e.getMessage());
        }
        IVfsActivityRecordedFolderItem folderItem = this.getActiveVersionFolderItem();
        try {
            if (folderItem != null) {
                this.getVersionedFileSystemManager().fireEventVersionDiscarded(folderItem, this, this.getCollidingVersion());
            }
        }
        catch (Exception x) {
            LogUtil.traceCaughtException((Location)LOCATION, (Throwable)x, (int)300);
        }
    }

    private void checkGeneralPreconditionForDiscard(IVfsActivity activity) throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        this.checkParameterState(activity);
        ((VfsActivity)activity).checkWorkspace(this.getWorkspace());
        try {
            ((VfsWorkspace)activity.getWorkspace()).checkIsModifiable();
        }
        catch (VfsException e) {
            VfsException ex = new VfsException("Changes are not allowed because workspace is not modifiable", e);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, ex.getMessage());
            throw ex;
        }
    }

    private void checkSpecialPreconditionsForDiscard(IVfsActivity activity, IVersion winningVersionAfterDiscard) throws VfsException {
        VfsVersion winningVersion = new VfsVersion(this.getVersionedFileSystemManager(), winningVersionAfterDiscard);
        IVfsFile correspondingFile = winningVersion.getCorrespondingFile(this.getWorkspace());
        if (correspondingFile != null) {
            try {
                ((VfsActivity)activity).checkPreconditionForCollisionResolving(correspondingFile.getAbsoluteRemotePath());
            }
            catch (VfsException x) {
                String errorMsg = "Not allowed: " + x.getMessage();
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.ERROR_LOG, this, errorMsg);
                throw new VfsException(errorMsg);
            }
        }
    }

    private void refreshStatesAfterDiscard(IVfsActivity activity, IVersion winningVersion, boolean doNotifyActivityListeners) throws VfsException {
        ((VfsActivity)activity).addActivityElement(this.getVersionedFileSystemManager(), winningVersion);
        try {
            if (((VfsActivity)activity).getNumberOfItems() == 1) {
                ((VfsWorkspace)this.m_workspace).addActivityToOpenActivityCache(activity);
            }
        }
        catch (VfsException e) {
            throw new VfsException("Get number of items of activity failed", e);
        }
        ((VfsWorkspace)this.m_workspace).setCurrentActivity(activity);
        this.m_lockingActivity = activity;
        this.m_discardTarget = this.findDiscardTarget();
        this.m_state = IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.DISCARD_ARROW_DRAWN;
        if (doNotifyActivityListeners) {
            try {
                this.getVersionedFileSystemManager().fireEventActivityItemsAddedOrRemoved(activity);
            }
            catch (Exception x) {
                LogUtil.traceCaughtException((Location)LOCATION, (Throwable)x, (int)300);
            }
        }
    }

    void refreshParentFolderAfterDiscardActive(VfsActivityRecordedFolderItem activityRecordedFolderItem) throws VfsException {
        try {
            if (!this.getCollidingVersion().isDeleted()) {
                if (activityRecordedFolderItem != null) {
                    IVfsGenericFolder parentFolder = activityRecordedFolderItem.getRealParent();
                    parentFolder.refreshFolderItems();
                    this.getVersionedFileSystemManager().fireEventVersionDiscarded(activityRecordedFolderItem, this, this.getActiveVersion());
                } else {
                    activityRecordedFolderItem = (VfsActivityRecordedFolderItem)this.getCollidingVersionFolderItem(this.getWorkspacePath(), this.m_workspace.getContext());
                    if (activityRecordedFolderItem != null) {
                        IVfsGenericFolder parentGenericFolder = activityRecordedFolderItem.getParent();
                        VfsFolder parentFolder = (VfsFolder)parentGenericFolder.asFolder();
                        parentFolder.addFolderItem(activityRecordedFolderItem);
                        this.getVersionedFileSystemManager().fireEventFolderItemsAddedOrRemoved(parentFolder);
                        this.getVersionedFileSystemManager().fireEventVersionDiscarded(activityRecordedFolderItem, this, this.getActiveVersion());
                    }
                }
            }
        }
        catch (Exception x) {
            LogUtil.traceCaughtException((Location)LOCATION, (Throwable)x, (int)300);
        }
    }

    /*
     * Unable to fully structure code
     */
    void refreshFolderItemAfterDiscardActive(VfsActivityRecordedFolderItem activityRecordedFolderItem) throws VfsException {
        if (!this.getCollidingVersion().isDeleted()) {
            try {
                if (activityRecordedFolderItem == null || (vcrResource = activityRecordedFolderItem.getVcrResource()) == null) ** GOTO lbl21
                vcrResource.refresh();
            }
            catch (VcmFailure vcmFailure) {
                ex = new VfsException("Refreshing DeltaV resource from repositoy failed: " + vcmFailure.getMessage(), vcmFailure);
                Logbook.getErrorChapter().println(ex.getMessage());
                throw ex;
            }
        } else if (activityRecordedFolderItem != null) {
            deletedVCR = VfsActivityRecordedFolderItem.createDeletedVcrResource((VfsWorkspace)this.m_workspace, activityRecordedFolderItem.getObjectID());
            try {
                if (deletedVCR != null) {
                    deletedVCR.refresh();
                    activityRecordedFolderItem.setVcrResource(deletedVCR);
                }
            }
            catch (VcmFailure vcmFailure) {
                ex = new VfsException("Refreshing DeltaV resource from repositoy failed: " + vcmFailure.getMessage(), vcmFailure);
                Logbook.getErrorChapter().println(ex.getMessage());
                throw ex;
            }
        }
lbl21:
        // 5 sources

        if (activityRecordedFolderItem != null) {
            activityRecordedFolderItem.refreshActiveVersion();
            activityRecordedFolderItem.refreshLocationState();
            if (activityRecordedFolderItem.isMounted() && activityRecordedFolderItem.getLocationState() != VfsFolderItemLocationState.SERVER_ONLY && activityRecordedFolderItem.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                activityRecordedFolderItem.sync();
            }
            try {
                this.getVersionedFileSystemManager().fireEventVersionDiscarded(activityRecordedFolderItem, this, this.getActiveVersion());
            }
            catch (Exception x) {
                LogUtil.traceCaughtException((Location)VfsIntegrateCollision.LOCATION, (Throwable)x, (int)300);
            }
        }
    }

    public IVfsMergeVersion getMergeVersion() {
        IVfsFile mergeVersionFile;
        this.getVersionedFileSystemManager().checkState();
        try {
            mergeVersionFile = this.m_activeVersion.getCorrespondingFile(this.m_workspace);
        }
        catch (VfsException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return null;
        }
        if (mergeVersionFile == null) {
            return null;
        }
        if (mergeVersionFile.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT) {
            IVfsVersion openSuccessor = this.getOpenSuccessorOfActiveVersion();
            return new VfsVersion.VfsMergeVersion((VfsVersion)openSuccessor, mergeVersionFile);
        }
        return null;
    }

    public IVfsVersion getCollidingVersion() {
        this.getVersionedFileSystemManager().checkState();
        return this.m_collidingVersion;
    }

    public VfsCollisionCategory getCollisionCategory() {
        this.getVersionedFileSystemManager().checkState();
        return VfsCollisionCategory.INTEGRATE_COLLISION;
    }

    public IVfsVersion getValidSourceVersion() {
        this.getVersionedFileSystemManager().checkState();
        return new VfsVersion(this.getVersionedFileSystemManager(), this.m_dvCollision.getWorkspaceVersion());
    }

    public IVfsVersion getWorkspaceVersion() {
        this.getVersionedFileSystemManager().checkState();
        return null;
    }

    public IVfsVersion getActiveVersion() {
        this.getVersionedFileSystemManager().checkState();
        return this.m_activeVersion;
    }

    public String getActiveVCRPath() {
        this.getVersionedFileSystemManager().checkState();
        return this.m_dvCollision.getVCR().getDecodedPath();
    }

    IVersionControlledResource getActiveVCR() {
        return this.m_dvCollision.getVCR();
    }

    public IVfsActivityRecordedFolderItem getActiveVersionFolderItem() {
        this.getVersionedFileSystemManager().checkState();
        try {
            return this.m_activeVersion.getCorrespondingFile(this.m_workspace);
        }
        catch (VfsException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return null;
        }
    }

    public IVfsActivityRecordedFolderItem getCollidingVersionFolderItem(String workspacePath, IVfsContext context) {
        this.getVersionedFileSystemManager().checkState();
        this.checkParameterState(context);
        try {
            return this.m_collidingVersion.getCorrespondingFile(workspacePath, context);
        }
        catch (VfsException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return null;
        }
    }

    public VfsCollisionType getCollisionType() {
        this.getVersionedFileSystemManager().checkState();
        CollisionType dvCollisionType = this.m_dvCollision.getCollisionType();
        if (dvCollisionType == CollisionType.PRED_SUCC) {
            return VfsCollisionType.PRED_SUCC;
        }
        if (dvCollisionType == CollisionType.NAME_CLASH) {
            return VfsCollisionType.NAME_CLASH;
        }
        if (dvCollisionType == CollisionType.CYCLIC_MERGE) {
            return VfsCollisionType.CYCLIC_MERGE;
        }
        throw new IllegalStateException("Unknown DV collision type:" + dvCollisionType);
    }

    public VfsCollisionState getCollisionState() {
        this.getVersionedFileSystemManager().checkState();
        if (this.m_dvPersistentCollision != null) {
            return VfsCollisionState.getEnumFromName(this.m_dvPersistentCollision.getCollisionState().getName());
        }
        return null;
    }

    public String getWorkspacePath() {
        this.getVersionedFileSystemManager().checkState();
        if (this.m_dvPersistentCollision != null) {
            return this.m_dvPersistentCollision.getWorkspace().getDecodedPath();
        }
        return null;
    }

    public IVfsWorkspace getWorkspace() {
        this.getVersionedFileSystemManager().checkState();
        return this.m_workspace;
    }

    public String getCreator() {
        this.getVersionedFileSystemManager().checkState();
        try {
            return this.m_dvCollision.getCollisionResource().getAuthor();
        }
        catch (VcmFailure e) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            return null;
        }
    }

    public Date getCreationDate() {
        this.getVersionedFileSystemManager().checkState();
        try {
            return this.m_dvCollision.getCollisionResource().created();
        }
        catch (VcmFailure e) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            return null;
        }
    }

    public IVfsActivity getIntegratedActivity() {
        this.getVersionedFileSystemManager().checkState();
        try {
            IActivity dvActivity = this.m_dvCollision.getCollisionResource().getIntegratedActivity();
            IVfsActivity activity = this.m_workspace.getRepository().getActivityById(dvActivity.getXCMObjectId());
            return activity;
        }
        catch (VcmFailure e) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            return null;
        }
        catch (VfsException e1) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e1.getMessage());
            return null;
        }
    }

    public String getIntegrationSequenceNumber() {
        this.getVersionedFileSystemManager().checkState();
        try {
            return this.m_dvCollision.getCollisionResource().getISN();
        }
        catch (VcmFailure e) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            return null;
        }
    }

    public IVfsActivity getLockingActivity() {
        this.getVersionedFileSystemManager().checkState();
        return this.m_lockingActivity;
    }

    public Date getResolutionDate() {
        this.getVersionedFileSystemManager().checkState();
        try {
            return this.m_dvCollision.getCollisionResource().getResolutionDate();
        }
        catch (VcmFailure e) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            return null;
        }
    }

    public IVfsActivity getResolvingActivity() {
        this.getVersionedFileSystemManager().checkState();
        try {
            return new VfsActivity((VfsRepository)this.m_workspace.getRepository(), this.m_dvCollision.getCollisionResource().getResolvingActivity());
        }
        catch (VcmFailure e) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            return null;
        }
    }

    public String getResolvingIntegrationSequenceNumber() {
        this.getVersionedFileSystemManager().checkState();
        try {
            return this.m_dvCollision.getCollisionResource().getResolvingISN();
        }
        catch (VcmFailure e) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            return null;
        }
    }

    public IVfsActivityRecordedFolderItem[] getParticipants() {
        this.getVersionedFileSystemManager().checkState();
        if (this.m_dvPersistentCollision != null) {
            // empty if block
        }
        return EMPTY_PARTICIPANT_LIST;
    }

    public String getPath() {
        this.getVersionedFileSystemManager().checkState();
        if (this.m_dvPersistentCollision != null) {
            return this.m_dvPersistentCollision.getCollisionResource().getDecodedPath();
        }
        return null;
    }

    void setWorkspace(IVfsWorkspace workspace) {
        this.m_workspace = workspace;
    }

    public void markAsResolved() throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        IVfsMergeVersion mergeVersion = this.getMergeVersion();
        if (mergeVersion == null) {
            throw new VfsException("No merge version exists for the collision");
        }
        try {
            if (this.m_dvCollision.getCollisionResource().getCollisionState().equals(CollisionState.LOCKED)) {
                throw new VfsException("Collision currently locked. Unable to mark as resolved.");
            }
        }
        catch (VcmFailure e1) {
            VfsException ex = new VfsException("Unable to determine state of collision : " + e1.getMessage(), e1);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, ex.getMessage());
            throw ex;
        }
        IVfsFile mergeVersionFile = (IVfsFile)((VfsVersion.VfsMergeVersion)mergeVersion).getActivityRecordedFolderItem();
        try {
            ((VfsWorkspace)mergeVersionFile.getWorkspace()).checkIsModifiable();
        }
        catch (VfsException e) {
            VfsException ex = new VfsException("Changes are not allowed because workspace is not modifiable", e);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, ex.getMessage());
            throw ex;
        }
        this.setAsMerged(mergeVersion, mergeVersionFile);
        this.m_state = IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.MERGE_ARROW_DRAWN;
    }

    private void setAsMerged(IVfsMergeVersion mergeVersion, IVfsFile mergeVersionFile) throws VfsException {
        IVersion[] existingPredecessors;
        IWorkingResource dvWorkingResource = ((VfsFile)mergeVersionFile).getDvWorkingResource();
        try {
            existingPredecessors = dvWorkingResource.getPredecessorSet();
        }
        catch (VcmFailure e) {
            throw new VfsException(e.getMessage());
        }
        IVersion[] dvPredecessorVersions = new IVersion[existingPredecessors.length + 1];
        int i = 0;
        while (i < existingPredecessors.length) {
            dvPredecessorVersions[i] = existingPredecessors[i];
            ++i;
        }
        dvPredecessorVersions[existingPredecessors.length] = ((VfsVersion)this.m_collidingVersion).getDvVersion();
        try {
            dvWorkingResource.setPredecessorSet(dvPredecessorVersions);
            this.getVersionedFileSystemManager().fireEventMergeVersionCreated(mergeVersionFile, this);
        }
        catch (VcmFailure e) {
            throw new VfsException(e.getMessage());
        }
    }

    public void revertMergeVersion() throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        IVfsMergeVersion mergeVersion = this.getMergeVersion();
        if (mergeVersion == null) {
            throw new VfsException("No merge version exists for the collision");
        }
        IVfsFile mergeVersionFile = (IVfsFile)((VfsVersion.VfsMergeVersion)mergeVersion).getActivityRecordedFolderItem();
        try {
            ((VfsWorkspace)mergeVersionFile.getWorkspace()).checkIsModifiable();
        }
        catch (VfsException e) {
            VfsException ex = new VfsException("Changes are not allowed because workspace is not modifiable", e);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, ex.getMessage());
            throw ex;
        }
        mergeVersionFile.uncheckout();
        this.m_lockingActivity = null;
        this.m_state = this.findCollisionState();
    }

    public IVfsIntegrateCollision.VfsDiscardTargetVersion getDiscardTargets() {
        this.getVersionedFileSystemManager().checkState();
        return this.m_discardTarget;
    }

    private IVfsIntegrateCollision.VfsDiscardTargetVersion findDiscardTarget() {
        return IVfsIntegrateCollision.VfsDiscardTargetVersion.NONE;
    }

    public void undoDiscardActiveVersion(IVfsActivity activity) throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        this.checkParameterState(activity);
        ((VfsActivity)activity).checkWorkspace(this.getWorkspace());
        try {
            ((VfsWorkspace)activity.getWorkspace()).checkIsModifiable();
        }
        catch (VfsException e) {
            VfsException ex = new VfsException("Changes are not allowed because workspace is not modifiable", e);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, ex.getMessage());
            throw ex;
        }
        VfsVersion activeVersion = (VfsVersion)this.getActiveVersion();
        VfsVersion collidingVersion = (VfsVersion)this.getCollidingVersion();
        this.internalUndoDiscard(activeVersion, collidingVersion, (VfsActivity)activity);
        VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.SUCCEEDED, null, "Undo discard of active version of collision completed");
    }

    public void undoDiscardCollidingVersion(IVfsActivity activity) throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        this.checkParameterState(activity);
        ((VfsActivity)activity).checkWorkspace(this.getWorkspace());
        try {
            ((VfsWorkspace)activity.getWorkspace()).checkIsModifiable();
        }
        catch (VfsException e) {
            VfsException ex = new VfsException("Changes are not allowed because workspace is not modifiable", e);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, ex.getMessage());
            throw ex;
        }
        VfsVersion activeVersion = (VfsVersion)this.getActiveVersion();
        VfsVersion collidingVersion = (VfsVersion)this.getCollidingVersion();
        this.internalUndoDiscard(collidingVersion, activeVersion, (VfsActivity)activity);
        VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.SUCCEEDED, null, "Undo discard colliding version of collision completed");
    }

    private void internalUndoDiscard(VfsVersion source, VfsVersion target, VfsActivity activity) {
        this.getVersionedFileSystemManager().checkState();
        this.checkParameterState(activity);
        this.checkParameterState(source);
        this.checkParameterState(target);
        if (target.getPredecessorRelations(source).length != 0 && (target.getPredecessorRelations(source).length > 1 || target.getPredecessorRelations(source)[0].getRelationType() == VfsVersionRelationType.DISCARD_MERGE)) {
            try {
                source.getDvVersion().undoDiscard(target.getDvVersion(), activity.getDeltaVActivity());
                this.m_lockingActivity = null;
                this.m_discardTarget = this.findDiscardTarget();
                this.m_state = this.findCollisionState();
            }
            catch (VcmFailure e) {
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, null, "Undo discard failed: " + e.getMessage());
                new VfsException(e.getMessage());
            }
        }
    }

    public String getActiveVersionDescription() {
        this.getVersionedFileSystemManager().checkState();
        return this.m_activeVersion.getLocationInGraph();
    }

    public String getCollidingVersionDescription() {
        this.getVersionedFileSystemManager().checkState();
        return this.m_collidingVersion.getLocationInGraph();
    }

    public String getInactiveVcrPath() {
        this.getVersionedFileSystemManager().checkState();
        return this.m_dvCollision.getInactiveVCR().getDecodedPath();
    }

    public IVfsFolderItem getFolderItemForInactiveVcr() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public IVfsVersion getCommonAncestor() {
        AncestorVertex[] balancedPathAncestors;
        AncestorVertex[] shortestPathAncestors;
        HashSet<AncestorVertex> activeBag = new HashSet<AncestorVertex>();
        HashSet<AncestorVertex> collidingBag = new HashSet<AncestorVertex>();
        HashSet<AncestorVertex> intersectingBag = new HashSet<AncestorVertex>();
        HashSet<AncestorVertex> verticesToBeAdded = new HashSet<AncestorVertex>();
        HashMap<String, AncestorVertex> activeMap = new HashMap<String, AncestorVertex>();
        int level = 1;
        AncestorVertex activeVertex = new AncestorVertex(this.m_activeVersion, false, 0, 0);
        AncestorVertex collidingVertext = new AncestorVertex(this.m_collidingVersion, false, 0, 0);
        activeBag.add(activeVertex);
        collidingBag.add(collidingVertext);
        activeMap.put(activeVertex.version.getUrl(), activeVertex);
        while (intersectingBag.size() == 0) {
            Iterator iter = activeBag.iterator();
            while (iter.hasNext()) {
                AncestorVertex element = (AncestorVertex)iter.next();
                if (element.visited) continue;
                IVfsVersion[] predecessors = element.version.getPredecessorSet();
                int i = 0;
                while (i < predecessors.length) {
                    AncestorVertex nextVertex = new AncestorVertex(predecessors[i], false, level, 0);
                    verticesToBeAdded.add(nextVertex);
                    activeMap.put(nextVertex.version.getUrl(), nextVertex);
                    ++i;
                }
                element.visited = true;
            }
            activeBag.addAll(verticesToBeAdded);
            verticesToBeAdded.clear();
            Iterator iter2 = collidingBag.iterator();
            while (iter2.hasNext()) {
                AncestorVertex element = (AncestorVertex)iter2.next();
                if (element.visited) continue;
                IVfsVersion[] predecessors = element.version.getPredecessorSet();
                int j = 0;
                while (j < predecessors.length) {
                    AncestorVertex nextVertex = new AncestorVertex(predecessors[j], false, 0, level);
                    verticesToBeAdded.add(nextVertex);
                    ++j;
                }
                element.visited = true;
            }
            collidingBag.addAll(verticesToBeAdded);
            verticesToBeAdded.clear();
            Iterator iter3 = collidingBag.iterator();
            while (iter3.hasNext()) {
                AncestorVertex element = (AncestorVertex)iter3.next();
                if (!this.containedInBag(activeBag, element)) continue;
                element.lengthFromActive = ((AncestorVertex)activeMap.get((Object)element.version.getUrl())).lengthFromActive;
                intersectingBag.add(element);
            }
            ++level;
        }
        AncestorVertex[] commonAncestors = ((AbstractCollection)intersectingBag).toArray(new AncestorVertex[intersectingBag.size()]);
        IVfsVersion commonAncestor = commonAncestors.length == 1 ? commonAncestors[0].version : ((shortestPathAncestors = this.getAncestorsWithShortestPath(commonAncestors)).length > 1 ? ((balancedPathAncestors = this.getAncestorsWithMostBalancedPath(shortestPathAncestors)).length > 1 ? VfsIntegrateCollision.getLowestVIDAncestor(balancedPathAncestors) : balancedPathAncestors[0].version) : shortestPathAncestors[0].version);
        return commonAncestor;
    }

    private boolean containedInBag(HashSet bag, AncestorVertex element) {
        Iterator iter = bag.iterator();
        while (iter.hasNext()) {
            AncestorVertex elementInBag = (AncestorVertex)iter.next();
            if (!elementInBag.equals(element)) continue;
            return true;
        }
        return false;
    }

    private AncestorVertex[] getAncestorsWithShortestPath(AncestorVertex[] commonAncestors) {
        ArrayList<AncestorVertex> shortestPathAncestors = new ArrayList<AncestorVertex>();
        int currentShortestPathLength = 0;
        currentShortestPathLength = commonAncestors[0].getTotalLength();
        shortestPathAncestors.add(commonAncestors[0]);
        int i = 1;
        while (i < commonAncestors.length) {
            if (commonAncestors[i].getTotalLength() < currentShortestPathLength) {
                shortestPathAncestors.clear();
                shortestPathAncestors.add(commonAncestors[i]);
                currentShortestPathLength = commonAncestors[i].getTotalLength();
            } else if (commonAncestors[i].getTotalLength() == currentShortestPathLength) {
                shortestPathAncestors.add(commonAncestors[i]);
            }
            ++i;
        }
        return shortestPathAncestors.toArray(new AncestorVertex[shortestPathAncestors.size()]);
    }

    private AncestorVertex[] getAncestorsWithMostBalancedPath(AncestorVertex[] shortestPathAncestors) {
        ArrayList<AncestorVertex> balancedPathAncestors = new ArrayList<AncestorVertex>();
        int currentShortestBalanceFactor = 0;
        int i = 0;
        while (i < shortestPathAncestors.length) {
            AncestorVertex ancestor = shortestPathAncestors[i];
            int balanceFactor = Math.abs(ancestor.lengthFromActive - ancestor.lengthFromColliding);
            if (balancedPathAncestors.size() == 0) {
                balancedPathAncestors.add(ancestor);
                currentShortestBalanceFactor = balanceFactor;
            } else if (balanceFactor < currentShortestBalanceFactor) {
                balancedPathAncestors.clear();
                balancedPathAncestors.add(ancestor);
                currentShortestBalanceFactor = balanceFactor;
            } else if (balanceFactor == currentShortestBalanceFactor) {
                balancedPathAncestors.add(ancestor);
            }
            ++i;
        }
        return balancedPathAncestors.toArray(new AncestorVertex[balancedPathAncestors.size()]);
    }

    private static IVfsVersion getLowestVIDAncestor(AncestorVertex[] balancedPathAncestors) {
        IVfsVersion ancestorWithLowestVID = balancedPathAncestors[0].version;
        int i = 1;
        while (i < balancedPathAncestors.length) {
            if (VfsIntegrateCollision.getVID(balancedPathAncestors[i].version).compareTo(VfsIntegrateCollision.getVID(ancestorWithLowestVID)) < 0) {
                ancestorWithLowestVID = balancedPathAncestors[i].version;
            }
            ++i;
        }
        return ancestorWithLowestVID;
    }

    private static String getVID(IVfsVersion version) {
        String versionURL = version.getUrl();
        return versionURL.substring(versionURL.length() - 32);
    }

    private void checkParameterState(IVfsWorkspace workspace) {
        if (workspace.getVersionedFileSystemManager() != this.getVersionedFileSystemManager()) {
            throw new IllegalArgumentException("Internal error: parameter with different versioned file system manager");
        }
    }

    private void checkParameterState(IVfsActivity activity) {
        if (activity.getVersionedFileSystemManager() != this.getVersionedFileSystemManager()) {
            throw new IllegalArgumentException("Internal error: parameter with different versioned file system manager");
        }
    }

    private void checkParameterState(IVfsVersion version) {
        if (version.getVersionedFileSystemManager() != this.getVersionedFileSystemManager()) {
            throw new IllegalArgumentException("Internal error: parameter with different versioned file system manager");
        }
    }

    private void checkParameterState(IVfsContext context) {
        if (context != this.getVersionedFileSystemManager().getCurrentContext()) {
            throw new IllegalArgumentException("Internal error: context parameter differs from context of versioned file system manager");
        }
    }

    public IVfsProperty[] getAllProperties() throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        return this.getVersionedFileSystemManager().getPropertiesFeature().getAllProperties(this.m_dvCollision.getCollisionResource());
    }

    public Map getProperties(String[] propertyNames) throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        return this.getVersionedFileSystemManager().getPropertiesFeature().getProperties(this.m_dvCollision.getCollisionResource(), propertyNames);
    }

    public IVfsProperty getProperty(String propertyName) throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        return this.getVersionedFileSystemManager().getPropertiesFeature().getProperty(this.m_dvCollision.getCollisionResource(), propertyName);
    }

    public String getUrl() {
        return this.m_dvCollision.getCollisionResource().getPersistentURL();
    }

    public void versionOnFolderItemChanged(IVfsActivityRecordedFolderItem folderItem, IVfsVersion oldVersion) {
        if (oldVersion != null && oldVersion.equals(this.m_activeVersion)) {
            try {
                IVfsVersion version = folderItem.refreshAndGetVersion();
                if (version != null) {
                    this.m_activeVersion = version;
                }
            }
            catch (VfsException e) {
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, null, "Failed to update active version of integrate collision: " + e.getMessage());
            }
        }
    }

    public void locationStateChanged(IVfsFolderItem folderItem, VfsFolderItemLocationState oldState) {
    }

    public void activityStateChanged(IVfsActivityRecordedFolderItem folderItem, VfsFolderItemActivityState oldState) {
        if (this.m_dvCollision.getCollisionType().equals(CollisionType.NAME_CLASH)) {
            return;
        }
        if ((this.m_state.equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.MERGE_ARROW_DRAWN) || this.m_state.equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.MERGE_VERSION_PRESENT)) && (oldState.equals(VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT) || oldState.equals(VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE))) {
            try {
                if (this.m_activeVersion.getObjectID().equalsIgnoreCase(folderItem.getObjectID())) {
                    try {
                        this.m_dvPersistentCollision.getCollisionResource().refresh();
                        this.m_state = this.findCollisionState();
                    }
                    catch (VcmFailure e1) {
                        VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, null, "Failed to update integrate collision state : " + e1.getMessage());
                    }
                }
            }
            catch (VfsException e) {
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, null, "Failed to update integrate collision state : " + e.getMessage());
            }
        }
    }

    public void itemsAddedOrRemoved(IVfsGenericFolder folder) {
    }

    public void acceptActiveResourceInNameClash(String activityDisplayName, String activityDescription) throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        if (this.m_dvCollision.getCollisionType().equals(CollisionType.NAME_CLASH)) {
            ((VfsWorkspace)this.m_workspace).solveNameClashByDeletingInactiveVcr(this, activityDisplayName, activityDescription);
            this.m_state = IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.RESOLVED;
        }
    }

    public Object[] getChildrenObjects() throws VfsException {
        return this.getVersionedFileSystemManager().getPropertiesFeature().getChildrenObjects(this.getActiveVCR());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class AncestorVertex {
        IVfsVersion version;
        boolean visited;
        int lengthFromActive;
        int lengthFromColliding;

        AncestorVertex(IVfsVersion version, boolean visited, int lengthFromActive, int lengthFromColliding) {
            this.version = version;
            this.visited = visited;
            this.lengthFromActive = lengthFromActive;
            this.lengthFromColliding = lengthFromColliding;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AncestorVertex)) {
                return false;
            }
            AncestorVertex vertex = (AncestorVertex)o;
            return this.version.equals(vertex.version);
        }

        int getTotalLength() {
            return this.lengthFromActive + this.lengthFromColliding;
        }
    }
}

