/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.tssap.dtr.client.lib.deltavlib.xcm.ICreatedResource;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityElement;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivity;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivityElement;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolder;
import java.util.Calendar;

class VfsInconsistentFolder
extends VfsFolder {
    private String m_absoluteRemotePath;
    private VfsException m_cause;
    private boolean m_released;

    private VfsInconsistentFolder(VfsException cause, VfsActivity activity, ICreatedResource dvNewResource) throws VfsException {
        super(activity, dvNewResource);
        this.m_cause = cause;
        this.m_absoluteRemotePath = super.getAbsoluteRemotePath();
        Logbook.getErrorChapter().println(this.m_cause.getMessage());
    }

    public VfsException getCauseOfInconsistency() {
        this.getVfsManager().checkState();
        return this.m_cause;
    }

    static VfsFolder pureUnsecuredGetVfsInconsistentFolder(VfsException cause, VfsActivity activity, ICreatedResource dvNewResource) throws VfsException {
        return new VfsInconsistentFolder(cause, activity, dvNewResource);
    }

    public boolean areLocalOnlyItemsBelow(boolean countAlsoItemsCheckedOutForCreate) throws VfsException {
        this.getVfsManager().checkState();
        throw new VfsException("Inconsistenct folder: " + this.getCauseOfInconsistency());
    }

    public void checkOutForEdit(IVfsActivity activity, int depth) throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct folder: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.EDIT, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void checkOutForEdit(IVfsActivity activity, int depth, boolean exclusive) throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct folder: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.EDIT, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void createAndCheckout(IVfsActivity activity, int depth) throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct folder: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.CREATE, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public VfsActionOnFolderItem[] getActionsForCurrentState() {
        this.getVfsManager().checkState();
        return new VfsActionOnFolderItem[]{VfsActionOnFolderItem.UNCHECKOUT};
    }

    public String[] getLocalPathsOfLocalOnlyItemsBelow(boolean includeAlsoItemsCheckedOutForCreate) throws VfsException {
        this.getVfsManager().checkState();
        throw new VfsException("Inconsistenct folder: " + this.getCauseOfInconsistency());
    }

    public boolean hasCheckedOutFolderItems() throws VfsException {
        this.getVfsManager().checkState();
        throw new VfsException("Inconsistenct folder: " + this.getCauseOfInconsistency());
    }

    public void removeFromClient() throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct folder: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void sync() throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct folder: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void syncForce() throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct folder: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void syncPreview() throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct folder: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void syncToDate(Calendar calendar) throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct folder: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void checkOutAndDelete(IVfsActivity activity) throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct folder: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void checkOutForEdit(IVfsActivity activity) throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct folder: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.EDIT, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void checkOutForEdit(IVfsActivity activity, boolean exclusive) throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct folder: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.EDIT, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void createAndCheckout(IVfsActivity activity) throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct folder: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.CREATE, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void move(IVfsActivity sourceActivity, IVfsActivity destinationActivity) throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct folder: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.MOVE, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void removeProperty(String name, IVfsActivity activity) throws VfsException {
        this.getVfsManager().checkState();
        throw new VfsException("Inconsistenct folder: " + this.getCauseOfInconsistency());
    }

    public void setProperty(String name, String value, IVfsActivity activity) throws VfsException {
        this.getVfsManager().checkState();
        throw new VfsException("Inconsistenct folder: " + this.getCauseOfInconsistency());
    }

    public boolean isReleased() {
        this.getVfsManager().checkState();
        return super.isReleased() || this.m_released;
    }

    void refreshFolderItemStateAfterUncheckout(VfsActivity activity) throws VfsException {
        super.refreshFolderItemStateAfterUncheckout(activity);
        IVfsActivityElement activityElement = activity.getActivityElement(this.getAbsoluteRemotePath());
        if (activityElement != null) {
            ((VfsActivityElement)activityElement).setInvalid(true);
        }
        this.setReleased(true);
    }

    void setReleased(boolean released) {
        this.m_released = released;
    }

    public String getAbsoluteRemotePath() {
        this.getVfsManager().checkState();
        String absoluteRemotePath = super.getAbsoluteRemotePath();
        if (absoluteRemotePath == null) {
            absoluteRemotePath = this.m_absoluteRemotePath;
        }
        return absoluteRemotePath;
    }

    boolean hasNewCreatedFolderItems() throws VfsException {
        this.getVfsManager().checkState();
        boolean hasNewCreatedFolderItems = super.hasNewCreatedFolderItems();
        if (hasNewCreatedFolderItems) {
            return hasNewCreatedFolderItems;
        }
        IVfsActivity[] openActivities = this.getOpenActivities();
        int i = 0;
        while (i < openActivities.length) {
            IVfsActivity openActivity = openActivities[i];
            IVfsActivityRecordedFolderItem[] activityElements = openActivity.getElementsFromOpenActivity();
            int j = 0;
            while (j < activityElements.length) {
                IVfsActivityRecordedFolderItem activityElement = activityElements[j];
                if (activityElement != this && activityElement.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE && activityElement.getAbsoluteRemotePath().startsWith(this.m_absoluteRemotePath)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

