/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICreatedResource;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityElement;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivity;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivityElement;
import com.tssap.dtr.client.lib.vfs.impl.VfsFile;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;

public class VfsInconsistentFile
extends VfsFile {
    private String m_absoluteRemotePath;
    private VfsException m_cause;
    private boolean m_released;

    private VfsInconsistentFile(VfsException cause, VfsActivity activity, ICreatedResource dvNewResource) throws VfsException {
        super(activity, dvNewResource);
        this.m_cause = cause;
        this.m_absoluteRemotePath = super.getAbsoluteRemotePath();
        Logbook.getErrorChapter().println(this.m_cause.getMessage());
    }

    public VfsException getCauseOfInconsistency() {
        this.getVfsManager().checkState();
        return this.m_cause;
    }

    static VfsFile pureUnsecuredGetVfsInconsistentFile(VfsException cause, VfsActivity activity, ICreatedResource dvNewResource) throws VfsException {
        return new VfsInconsistentFile(cause, activity, dvNewResource);
    }

    public VfsActionOnFolderItem[] getActionsForCurrentState() {
        this.getVfsManager().checkState();
        return new VfsActionOnFolderItem[]{VfsActionOnFolderItem.UNCHECKOUT};
    }

    public InputStream getContent() throws VfsException {
        this.getVfsManager().checkState();
        throw new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
    }

    public void getContent(OutputStream outputStream) throws VfsException {
        this.getVfsManager().checkState();
        throw new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
    }

    public String getMimeType() throws VfsException {
        this.getVfsManager().checkState();
        IResource dvResource = this.getNewestDeltaVResource();
        if (dvResource == null) {
            throw new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
        }
        try {
            return dvResource.getContentType();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting content type failed: " + this.getAbsoluteRemotePath(), vcmFailure);
        }
    }

    public void removeFromClient() throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void sync() throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void syncForce() throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void syncPreview() throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void syncTo(Calendar calendar) throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void syncToBranchSequenceNumber(int branchSequenceNumber) throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void syncToBranchSequenceNumber(String branchSequenceNumber) throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void syncToDate(Calendar date) throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void temporaryGetContent(OutputStream outputStream) throws VfsException {
        this.getVfsManager().checkState();
        throw new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
    }

    public void checkOutAndDelete(IVfsActivity activity) throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void checkOutForEdit(IVfsActivity activity) throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.EDIT, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void checkOutForEdit(IVfsActivity activity, boolean exclusive) throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.EDIT, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void createAndCheckout(IVfsActivity activity) throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.CREATE, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void download() throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.DOWNLOAD, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void forceDownload() throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.DOWNLOAD, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void forceUpload() throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.UPLOAD, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void upload() throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.UPLOAD, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void move(IVfsActivity sourceActivity, IVfsActivity destinationActivity) throws VfsException {
        this.getVfsManager().checkState();
        VfsException e = new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
        VfsActionRecorder.log(VfsActionType.MOVE, VfsActionStatus.FAILED, this, e.getMessage());
        throw e;
    }

    public void removeProperty(String name, IVfsActivity activity) throws VfsException {
        this.getVfsManager().checkState();
        throw new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
    }

    public void setProperty(String name, String value, IVfsActivity activity) throws VfsException {
        this.getVfsManager().checkState();
        throw new VfsException("Inconsistenct file: " + this.getCauseOfInconsistency());
    }

    public boolean isReleased() {
        this.getVfsManager().checkState();
        return super.isReleased() || this.m_released;
    }

    void refreshFolderItemStateAfterUncheckout(VfsActivity activity) throws VfsException {
        super.refreshFolderItemStateAfterUncheckout(activity);
        IVfsActivityElement activityElement = activity.getActivityElement(this.getAbsoluteRemotePath());
        if (activityElement != null) {
            ((VfsActivityElement)activityElement).setInvalid(true);
        }
        this.setReleased(true);
    }

    void setReleased(boolean released) {
        this.m_released = released;
    }

    public String getAbsoluteRemotePath() {
        this.getVfsManager().checkState();
        String absoluteRemotePath = super.getAbsoluteRemotePath();
        if (absoluteRemotePath == null) {
            absoluteRemotePath = this.m_absoluteRemotePath;
        }
        return absoluteRemotePath;
    }
}

