/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.ICollection;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.IVersion;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.PathEncodingFlag;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.ResourceFactoryManager;
import com.tssap.dtr.client.lib.exceptions.ExceptionCategory;
import com.tssap.dtr.client.lib.exceptions.ExceptionSeverity;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsAmbiguousFolder;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.IVfsProperty;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.IVfsRootFolder;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspaceFolder;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsExceptionCategory;
import com.tssap.dtr.client.lib.vfs.VfsFilterType;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemCategory;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.VfsRuntimeException;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.fileservice.LocalFileService;
import com.tssap.dtr.client.lib.vfs.impl.FolderItemCache;
import com.tssap.dtr.client.lib.vfs.impl.Util;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsAmbiguousFolder;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolder;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolderItemRelation;
import com.tssap.dtr.client.lib.vfs.impl.VfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersion;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspace;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspaceFolder;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncDB;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncEntry;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

abstract class VfsFolderItem
implements IVfsFolderItem {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$VfsFolderItem == null ? (class$com$tssap$dtr$client$lib$vfs$impl$VfsFolderItem = VfsFolderItem.class$("com.tssap.dtr.client.lib.vfs.impl.VfsFolderItem")) : class$com$tssap$dtr$client$lib$vfs$impl$VfsFolderItem));
    static final boolean REFRESH_DELTAV_RESOURCE = true;
    static final boolean DONT_REFRESH_DELTAV_RESOURCE = false;
    IResource m_dvVcr;
    IVirtualFile m_localFile;
    VfsFolderItemLocationState m_locationState;
    static final IVirtualFile NULL_LOCAL_FILE = new LocalFileService().constructFile("/NULL_LOCAL_FILE");
    static final IVirtualFile KEEP_LOCAL_FILE = new LocalFileService().constructFile("/KEEP_LOCAL_FILE");
    static final int DEFAULT_CONNECTION_TEMPLATE_ID = 0;
    static IVersionControlledResource NULL_DELTAV_RESOURCE = null;
    static IVersionControlledResource KEEP_DELTAV_RESOURCE = null;
    static final boolean FORCED_SYNC = true;
    static final boolean NO_FORCED_SYNC = false;
    static final boolean SYNC_PREVIEW = true;
    static final boolean NO_SYNC_PREVIEW = false;
    static final boolean ADAPT_SYNCSTATE_UPTO_LOCALROOT = true;
    static final boolean DONT_ADAPT_SYNCSTATE_UPTO_LOCALROOT = false;
    static final boolean NOTIFY_LISTENER = true;
    static final boolean NOT_NOTIFY_LISTENER = false;
    static final boolean REFRESH_ACTIVITY = true;
    static final boolean DONT_REFRESH_ACTIVITY = false;
    static final boolean REMOVE_FROM_CLIENT = true;
    static final boolean DONT_REMOVE_FROM_CLIENT = false;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$VfsFolderItem;

    static IVfsFolderItem createFolderItemRelatedToWorkspace(IVfsWorkspace workspace, String absoluteLocalPath, boolean includeWorkspaceFolder) throws VfsException {
        IVfsRemoteLocator locator = workspace.getContext().getRemoteLocator(absoluteLocalPath);
        if (locator == null) {
            return null;
        }
        String remoteWorkspacePath = workspace.getAbsoluteRemotePath();
        PathUtilities.PathRelations relation = PathUtilities.comparePaths(remoteWorkspacePath, locator.getAbsoluteRemotePath(), PathUtilities.REMOTE_FILESERVICE);
        if (relation == PathUtilities.PathRelations.IDENTICAL) {
            return workspace;
        }
        if (relation == PathUtilities.PathRelations.DIFFERENT) {
            return null;
        }
        if (relation == PathUtilities.PathRelations.FIRST_UNDER_SECOND && !includeWorkspaceFolder) {
            return null;
        }
        if (locator.getConnectionTemplateId() != ((VfsWorkspace)workspace).m_dvVcr.getConnectionTemplID()) {
            return null;
        }
        IVirtualFile localFile = workspace.getContext().getFileService().constructFile(absoluteLocalPath);
        VfsFolderItem folderItem = ((VersionedFileSystemManager)workspace.getVersionedFileSystemManager()).getFolderItemCache().getFolderItemWithLocalPath(localFile.getAbsolutePath());
        if (folderItem != null) {
            return folderItem;
        }
        if (relation == PathUtilities.PathRelations.FIRST_UNDER_SECOND) {
            IResource dvResource = Util.createDvResourceProxy(locator);
            if (dvResource == null || !VfsFolderItem.existsOnRepository(dvResource.getConnectionTemplID(), locator.getAbsoluteRemotePath())) {
                return null;
            }
            return VfsWorkspaceFolder.getVfsWorkspaceFolder((VersionedFileSystemManager)workspace.getVersionedFileSystemManager(), dvResource, localFile);
        }
        IResource dvResource = null;
        if (localFile.exists()) {
            dvResource = KEEP_DELTAV_RESOURCE;
        } else {
            dvResource = Util.createDvResourceProxy(locator);
            if (dvResource == null || !VfsFolderItem.existsOnRepository(dvResource.getConnectionTemplID(), locator.getAbsoluteRemotePath())) {
                return null;
            }
        }
        try {
            return VfsActivityRecordedFolderItem.getVfsActivityRecordedFolderItem(workspace, dvResource.getAsVersionControlled(), localFile);
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Check if DeltaV resource is version controlled failed", vcmFailure);
        }
    }

    IVfsRemoteLocator getRemoteLocator() {
        String canonicalAbsoluteRemotePath;
        String absoluteRemotePath = canonicalAbsoluteRemotePath = this.getAbsoluteRemotePath();
        if (this.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_FORMER || this.getLocationState() == VfsFolderItemLocationState.DELETED) {
            absoluteRemotePath = this.getVcrResource().getDecodedPath();
        }
        return new VfsRemoteLocator(this.getConnectionTemplateId(), absoluteRemotePath, canonicalAbsoluteRemotePath);
    }

    int getConnectionTemplateId() {
        int id = this.getConnectionTemplateId_noThrow();
        if (id >= 0) {
            return id;
        }
        throw new IllegalStateException("Internal error: no corresponding DeltaV resource available");
    }

    int getConnectionTemplateId_noThrow() {
        IVfsWorkspace workspace;
        if (this.m_dvVcr != null) {
            return this.m_dvVcr.getConnectionTemplID();
        }
        if (!(this instanceof IVfsWorkspace) && (workspace = this.getWorkspace()) != null) {
            return ((VfsWorkspace)workspace).getConnectionTemplateId();
        }
        return -1;
    }

    VfsFolderItem(IResource resource, IVirtualFile localFile) {
        if (resource != KEEP_DELTAV_RESOURCE && resource != NULL_DELTAV_RESOURCE) {
            this.m_dvVcr = resource;
        }
        if (localFile != KEEP_LOCAL_FILE && localFile != NULL_LOCAL_FILE) {
            this.m_localFile = localFile;
        }
    }

    String getPath() throws VfsException {
        if (this.m_dvVcr == null) {
            return null;
        }
        String path = null;
        try {
            path = this.m_dvVcr.getCanonicalPath();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Get canonical path of folder item failed", vcmFailure);
        }
        if (this instanceof IVfsGenericFolder) {
            return PathUtilities.assureTrailingSeparator(path, PathUtilities.REMOTE_FILESERVICE);
        }
        return PathUtilities.preventTrailingSeparator(path, PathUtilities.REMOTE_FILESERVICE);
    }

    public String getUrl() throws VfsException {
        this.getVfsManager().checkState();
        if (this.m_dvVcr != null) {
            return this.getUrl(this.m_dvVcr);
        }
        if (this.isMounted()) {
            IVfsRemoteLocator locator = this.getContext().getRemoteLocator(this.getLocalPath());
            String url = this.getContext().getUrl(locator);
            if (this.m_localFile.isDirectory()) {
                url = PathUtilities.assureTrailingSeparator(url, PathUtilities.REMOTE_FILESERVICE);
            }
            return url;
        }
        return null;
    }

    String getUrl(IResource dvResource) throws VfsException {
        String url = dvResource.getPersistentURL();
        if (this instanceof IVfsGenericFolder) {
            return PathUtilities.assureTrailingSeparator(url, PathUtilities.REMOTE_FILESERVICE);
        }
        if (this instanceof IVfsFile) {
            return PathUtilities.preventTrailingSeparator(url, PathUtilities.REMOTE_FILESERVICE);
        }
        return url;
    }

    IResource getNewestDeltaVResource() {
        return this.m_dvVcr;
    }

    public String getAbsoluteRemotePath() {
        this.getVfsManager().checkState();
        if (this.m_dvVcr != null) {
            String absoluteRemotePath = null;
            try {
                absoluteRemotePath = this.m_dvVcr.getCanonicalPath();
                if (!this.m_dvVcr.isFile()) {
                    absoluteRemotePath = PathUtilities.assureTrailingSeparator(absoluteRemotePath, PathUtilities.REMOTE_FILESERVICE);
                }
            }
            catch (VcmFailure vcmFailure) {
                LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
            }
            return absoluteRemotePath;
        }
        if (this.isMounted()) {
            IVfsContext context = this.getVersionedFileSystemManager().getCurrentContext();
            String absoluteRemotePath = context.getRemoteLocator(this.getLocalPath()).getAbsoluteRemotePath();
            if (!this.m_localFile.isFile()) {
                absoluteRemotePath = PathUtilities.assureTrailingSeparator(absoluteRemotePath, PathUtilities.REMOTE_FILESERVICE);
            }
            return absoluteRemotePath;
        }
        return null;
    }

    public String getName() {
        this.getVfsManager().checkState();
        String UNKNOWN_NAME = "?";
        if (this.m_dvVcr != null) {
            try {
                return this.m_dvVcr.getCanonicalName();
            }
            catch (VcmFailure vcmFailure) {
                LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
                return "?";
            }
        }
        if (this.isMounted()) {
            return this.m_localFile.getName();
        }
        IResource resource = this.getNewestDeltaVResource();
        if (resource != null) {
            try {
                return resource.getCanonicalName();
            }
            catch (VcmFailure vcmFailure) {
                LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
                return "?";
            }
        }
        return "?";
    }

    public String getDisplayName() throws VfsException {
        this.getVfsManager().checkState();
        IResource dvResource = this.getVcrResource();
        if (dvResource != null) {
            try {
                return dvResource.getDisplayName();
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Get display name failed", vcmFailure);
            }
        }
        if (this.isMounted()) {
            return this.m_localFile.getName();
        }
        throw new VfsException("Get display name failed (No VCR or local file)");
    }

    static String getAbsoluteLocalPath(IVirtualFile localFile, IResource resource, IVfsContext context, VfsFolderItemCategory folderItemCategory) {
        String absoluteLocalPath = null;
        if (localFile != null && localFile != KEEP_LOCAL_FILE && localFile != NULL_LOCAL_FILE) {
            absoluteLocalPath = localFile.getAbsolutePath();
        } else if (resource != null && resource != NULL_DELTAV_RESOURCE && resource != KEEP_DELTAV_RESOURCE) {
            if (context == null) {
                throw new IllegalArgumentException("Internal error: null context and null localFile");
            }
            try {
                absoluteLocalPath = context.getAbsoluteLocalPath(resource.getConnectionTemplID(), resource.getCanonicalPath());
            }
            catch (VcmFailure vcmFailure) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
            }
        }
        if (absoluteLocalPath == null) {
            return null;
        }
        if (folderItemCategory != VfsFolderItemCategory.FILE) {
            absoluteLocalPath = PathUtilities.assureTrailingSeparator(absoluteLocalPath, context.getFileService());
        }
        return absoluteLocalPath;
    }

    static String getAbsoluteLocalPath(IVirtualFile localFile, IResource dvResource, IVfsContext context) throws VfsException {
        VfsFolderItemCategory folderItemCategory = null;
        if (localFile != null && localFile != NULL_LOCAL_FILE && localFile != KEEP_LOCAL_FILE && localFile.exists()) {
            folderItemCategory = localFile.isDirectory() ? VfsFolderItemCategory.FOLDER : VfsFolderItemCategory.FILE;
        } else if (dvResource != null) {
            try {
                folderItemCategory = !dvResource.isFile() ? VfsFolderItemCategory.FOLDER : VfsFolderItemCategory.FILE;
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Get category (file or folder) of DeltaV resource failed", vcmFailure);
            }
        }
        if (folderItemCategory != null) {
            return VfsFolderItem.getAbsoluteLocalPath(localFile, dvResource, context, folderItemCategory);
        }
        return null;
    }

    public String getLocalPath() {
        this.getVfsManager().checkState();
        if (this.isMounted()) {
            if (!this.isFile()) {
                return PathUtilities.assureTrailingSeparator(this.m_localFile.getAbsolutePath(), this.getContext().getFileService());
            }
            return this.m_localFile.getAbsolutePath();
        }
        return null;
    }

    SyncDB getSyncDB() {
        SyncDB syncDB = this.getContext().getSyncDb(this.getLocalPath());
        return syncDB;
    }

    void setLocationState(VfsFolderItemLocationState locationState) {
        if (this instanceof IVfsGenericFolder && (locationState == VfsFolderItemLocationState.SYNCED_TO_LATEST || locationState == VfsFolderItemLocationState.SYNCED_TO_FORMER)) {
            locationState = VfsFolderItemLocationState.MOUNTED;
        }
        if (this.m_locationState != locationState) {
            VfsFolderItemLocationState oldState = this.m_locationState;
            this.m_locationState = locationState;
            if (oldState != null) {
                this.getVfsManager().fireEventFolderItemLocationStateChanged(this, oldState);
            }
        }
    }

    public VfsFolderItemLocationState getLocationState() {
        this.getVfsManager().checkState();
        if (this.m_locationState == null) {
            String path = this.getLocalPath() != null ? this.getLocalPath() : this.getAbsoluteRemotePath();
            throw new IllegalStateException("Internal error: location state is initial for resource: " + path);
        }
        if (this instanceof IVfsGenericFolder && (this.m_locationState == VfsFolderItemLocationState.SYNCED_TO_FORMER || this.m_locationState == VfsFolderItemLocationState.SYNCED_TO_LATEST)) {
            return VfsFolderItemLocationState.MOUNTED;
        }
        return this.m_locationState;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VfsFolderItem)) {
            return false;
        }
        if (this.isMounted()) {
            return super.equals(obj);
        }
        try {
            if (this.pureGetObjectID() == null) {
                return super.equals(obj);
            }
            return this.pureGetObjectID().equals(((VfsFolderItem)obj).pureGetObjectID());
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return super.equals(obj);
        }
    }

    public int hashCode() {
        if (this.isMounted()) {
            return super.hashCode();
        }
        try {
            if (this.pureGetObjectID() == null) {
                return super.hashCode();
            }
            return this.pureGetObjectID().hashCode();
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return super.hashCode();
        }
    }

    public abstract VfsActionOnFolderItem[] getActionsForCurrentState();

    public IVfsGenericFolder getParent() throws VfsException {
        this.getVfsManager().checkState();
        return this.getRealParent();
    }

    IVfsGenericFolder getRealParent() throws VfsException {
        FolderItemCache cache = this.getVfsManager().getFolderItemCache();
        int connectionTemplateId = this.getConnectionTemplateId();
        IVfsContext context = this.getVersionedFileSystemManager().getCurrentContext();
        IVfsRemoteLocator[] remoteLocators = context.getPossibleRemoteLocators(connectionTemplateId, PathUtilities.getParentPath(this.getBrowsePath(connectionTemplateId), PathUtilities.REMOTE_FILESERVICE, false));
        if (remoteLocators.length == 0) {
            return null;
        }
        if (remoteLocators.length != 1) {
            throw new UnsupportedOperationException("Multiple remote locator for a browse path can not yet be handled");
        }
        VfsFolderItem[] items = cache.getFolderItemsWithBrowsePath(remoteLocators[0]);
        if (items != null && items.length == 1) {
            return (IVfsGenericFolder)((Object)items[0]);
        }
        if (this instanceof IVfsActivityRecordedFolderItem) {
            IVfsWorkspace workspace = this.getWorkspace();
            if (this.m_dvVcr != null) {
                String decodedParentPath;
                String thisUrl = this.m_dvVcr.getPersistentURL();
                String parentUrl = PathUtilities.getParentPath(thisUrl, PathUtilities.REMOTE_FILESERVICE, false);
                try {
                    decodedParentPath = PathUtilities.getParentPath(this.m_dvVcr.getCanonicalPath(), PathUtilities.REMOTE_FILESERVICE, false);
                }
                catch (VcmFailure vcmFailure) {
                    throw new VfsException("Get canonical path of folder item failed", vcmFailure);
                }
                if (parentUrl == null) {
                    // empty if block
                }
                if (workspace.getUrl().equals(parentUrl)) {
                    return workspace;
                }
                IResourceFactory factory = ResourceFactoryManager.getInstance().getProxyFactory();
                int templateId = this.m_dvVcr.getConnectionTemplID();
                ICollection collection = null;
                try {
                    collection = factory.createCollection(templateId, decodedParentPath, PathEncodingFlag.DECODED);
                }
                catch (VcmFailure vcmFailure) {
                    LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
                    return null;
                }
                IVirtualFile localParent = NULL_LOCAL_FILE;
                if (this.m_localFile != null) {
                    String remoteParentPath = PathUtilities.getParentPath(this.getAbsoluteRemotePath(), PathUtilities.REMOTE_FILESERVICE, false);
                    if (this.getContext().getAbsoluteLocalPath(this.getConnectionTemplateId(), remoteParentPath) != null) {
                        localParent = this.m_localFile.getParentFile();
                    }
                }
                try {
                    VfsActivityRecordedFolderItem folderItem = VfsActivityRecordedFolderItem.getVfsActivityRecordedFolderItem(workspace, collection.getAsVersionControlled(), localParent);
                    if (folderItem.asGenericFolder() == null) {
                        throw new VfsException("Parent folder has name clash with local file");
                    }
                    return folderItem.asGenericFolder();
                }
                catch (VcmFailure vcmFailure) {
                    throw new VfsException("Get category (versioned or not) of DeltaV resource failed", vcmFailure);
                }
            }
            if (this.isMounted()) {
                IVfsRemoteLocator thisLocator = workspace.getContext().getRemoteLocator(this.m_localFile.getAbsolutePath());
                String parentPath = PathUtilities.getParentPath(thisLocator.getAbsoluteRemotePath(), PathUtilities.REMOTE_FILESERVICE, false);
                VfsRemoteLocator parentLocator = new VfsRemoteLocator(thisLocator.getConnectionTemplateId(), parentPath, parentPath);
                if (workspace.getAbsoluteRemotePath().equals(parentLocator.getAbsoluteRemotePath())) {
                    return workspace;
                }
                IResource resource = null;
                if (this.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) {
                    IResourceFactory factory = ResourceFactoryManager.getInstance().getLocatorFactory();
                    try {
                        resource = factory.createCollection(this.getConnectionTemplateId(), parentLocator.getAbsoluteRemotePath(), PathEncodingFlag.DECODED);
                    }
                    catch (VcmFailure vcmFailure) {
                        if (vcmFailure.getStatusCode() != 404) {
                            throw new VfsException("Get parent resource from repository failed", vcmFailure);
                        }
                        resource = NULL_DELTAV_RESOURCE;
                    }
                } else {
                    resource = Util.createDvResourceProxy(parentLocator);
                }
                try {
                    VfsActivityRecordedFolderItem folderItem;
                    IVirtualFile localParent = NULL_LOCAL_FILE;
                    if (this.isMounted() && context.getMountpointRelation(this.getAbsoluteRemotePath()) != IVfsContext.MountpointRelation.MOUNTPOINT) {
                        localParent = this.m_localFile.getParentFile();
                    }
                    if ((folderItem = VfsActivityRecordedFolderItem.getVfsActivityRecordedFolderItem(workspace, resource.getAsVersionControlled(), localParent)).asGenericFolder() == null) {
                        throw new VfsException("Parent folder has name clash with local file");
                    }
                    return folderItem.asGenericFolder();
                }
                catch (VcmFailure vcmFailure) {
                    throw new VfsException("Get category (versioned or not) of DeltaV resource failed", vcmFailure);
                }
            }
        } else if ((this instanceof IVfsWorkspace || this instanceof IVfsWorkspaceFolder) && this.m_dvVcr != null) {
            String decodedParentPath;
            try {
                decodedParentPath = PathUtilities.getParentPath(this.m_dvVcr.getCanonicalPath(), PathUtilities.REMOTE_FILESERVICE, false);
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Get canonical path of folder item failed", vcmFailure);
            }
            IResourceFactory factory = ResourceFactoryManager.getInstance().getProxyFactory();
            int templateId = this.m_dvVcr.getConnectionTemplID();
            ICollection collection = null;
            try {
                collection = factory.createCollection(templateId, decodedParentPath, PathEncodingFlag.DECODED);
            }
            catch (VcmFailure vcmFailure) {
                LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
                return null;
            }
            IVirtualFile localParent = NULL_LOCAL_FILE;
            if (this.isMounted() && context.getMountpointRelation(this.getAbsoluteRemotePath()) != IVfsContext.MountpointRelation.MOUNTPOINT) {
                localParent = this.m_localFile.getParentFile();
            }
            return VfsWorkspaceFolder.getVfsWorkspaceFolder(this.getVfsManager(), collection, localParent);
        }
        return null;
    }

    public void sync() throws VfsException {
        throw new VfsException("Sync is not available for this object type.");
    }

    public void removeFromClient() throws VfsException {
        throw new VfsException("Remove not available for this object type.");
    }

    public IVfsProperty[] getAllProperties() throws VfsException {
        this.getVfsManager().checkState();
        return this.getVfsManager().getPropertiesFeature().getAllProperties(this.getNewestDeltaVResource());
    }

    public String[] getModifiablePropertyNames() {
        this.getVfsManager().checkState();
        return this.getVfsManager().getPropertiesFeature().getModifiablePropertyNames(this);
    }

    public boolean isPropertyModifiable(String name) {
        this.getVfsManager().checkState();
        return this.getVfsManager().getPropertiesFeature().isPropertyModifiable(this, name);
    }

    public void refreshState() {
        int i = 0;
        int n = i + 1;
    }

    public void refreshAllProperties() throws VfsException {
        this.getVfsManager().checkState();
        this.getVfsManager().getPropertiesFeature().refreshAllProperties(this);
    }

    public IVfsProperty getProperty(String propertyName) throws VfsException {
        this.getVfsManager().checkState();
        return this.getVfsManager().getPropertiesFeature().getProperty(this.getNewestDeltaVResource(), propertyName);
    }

    public Map getProperties(String[] propertyNames) throws VfsException {
        this.getVfsManager().checkState();
        return this.getVfsManager().getPropertiesFeature().getProperties(this.getNewestDeltaVResource(), propertyNames);
    }

    public VfsFolderItemCategory getCategory() {
        this.getVfsManager().checkState();
        if (this instanceof IVfsFile) {
            return VfsFolderItemCategory.FILE;
        }
        if (this instanceof IVfsFolder) {
            return VfsFolderItemCategory.FOLDER;
        }
        if (this instanceof IVfsAmbiguousFolder) {
            return VfsFolderItemCategory.AMBIGUOUS_FOLDER;
        }
        if (this instanceof IVfsWorkspace) {
            return VfsFolderItemCategory.WORKSPACE;
        }
        if (this instanceof IVfsRootFolder) {
            return VfsFolderItemCategory.ROOT;
        }
        if (this instanceof IVfsWorkspaceFolder) {
            return VfsFolderItemCategory.WORKSPACE_FOLDER;
        }
        return VfsFolderItemCategory.UNKNOWN;
    }

    public abstract IVfsContext getContext();

    abstract IVfsWorkspace getWorkspace();

    static VfsFolderItemRelation checkIdentityOfRepresentedResource(VfsFolderItem folderItem, IResource resource, VfsFolderItemCategory category) throws VfsException {
        if (folderItem.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) {
            if (resource == null || resource == KEEP_DELTAV_RESOURCE || resource == NULL_DELTAV_RESOURCE) {
                return VfsFolderItemRelation.IDENTITY;
            }
            return VfsFolderItemRelation.DIFFERENT_LOCATION;
        }
        if (resource == null || resource == NULL_DELTAV_RESOURCE) {
            return VfsFolderItemRelation.DIFFERENT_LOCATION;
        }
        if (resource == KEEP_DELTAV_RESOURCE) {
            return VfsFolderItemRelation.IDENTITY;
        }
        if (folderItem.getCategory() != category) {
            return VfsFolderItemRelation.DIFFERENT_CATEGORY;
        }
        if (resource.getConnectionTemplID() != folderItem.getConnectionTemplateId()) {
            return VfsFolderItemRelation.DIFFERENT_CONNECTION;
        }
        try {
            if (!resource.getXCMObjectId().equals(folderItem.getObjectID())) {
                return VfsFolderItemRelation.DIFFERENT_OID;
            }
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Get object ID of DeltaV resource failed: " + resource.getDecodedPath(), vcmFailure);
        }
        return VfsFolderItemRelation.IDENTITY;
    }

    public IVfsRootFolder asRoot() {
        this.getVfsManager().checkState();
        if (this instanceof IVfsRootFolder) {
            return (IVfsRootFolder)((Object)this);
        }
        return null;
    }

    public IVfsWorkspaceFolder asWorkspaceFolder() {
        this.getVfsManager().checkState();
        if (this instanceof IVfsWorkspaceFolder) {
            return (IVfsWorkspaceFolder)((Object)this);
        }
        return null;
    }

    public IVfsWorkspace asWorkspace() {
        this.getVfsManager().checkState();
        if (this instanceof IVfsWorkspace) {
            return (IVfsWorkspace)((Object)this);
        }
        return null;
    }

    public IVfsFile asFile() {
        this.getVfsManager().checkState();
        if (this instanceof IVfsFile) {
            return (IVfsFile)((Object)this);
        }
        return null;
    }

    boolean isFile() {
        return this.asFile() != null;
    }

    public IVfsActivityRecordedFolderItem asActivityRecordedFolderItem() {
        this.getVfsManager().checkState();
        if (this instanceof IVfsActivityRecordedFolderItem) {
            return (IVfsActivityRecordedFolderItem)((Object)this);
        }
        return null;
    }

    public IVfsGenericFolder asGenericFolder() {
        this.getVfsManager().checkState();
        if (this instanceof IVfsGenericFolder) {
            return (IVfsGenericFolder)((Object)this);
        }
        return null;
    }

    public IVfsFolder asFolder() {
        this.getVfsManager().checkState();
        if (this instanceof IVfsFolder) {
            return (IVfsFolder)((Object)this);
        }
        return null;
    }

    public IVfsAmbiguousFolder asAmbiguousFolder() {
        this.getVfsManager().checkState();
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public IVirtualFile getLocalFile() {
        this.getVfsManager().checkState();
        return this.m_localFile;
    }

    boolean isMounted() {
        return this.m_localFile != null;
    }

    public String getBrowsePath() throws VfsException {
        this.getVfsManager().checkState();
        if (this.m_dvVcr != null) {
            return this.getBrowsePath(this.m_dvVcr.getConnectionTemplID());
        }
        return this.getBrowsePath(this.getContext().getRemoteLocator(this.getLocalPath()).getConnectionTemplateId());
    }

    String getBrowsePath(int connectionTemplateId) throws VfsException {
        IVfsRemoteLocator[] rootLocators = this.getContext().getBrowseRootRemoteLocators();
        int i = 0;
        while (i < rootLocators.length) {
            IVfsRemoteLocator rootLocator = rootLocators[i];
            if (rootLocator.getConnectionTemplateId() == connectionTemplateId && this.getPath().startsWith(rootLocator.getAbsoluteRemotePath())) {
                return this.getPath().substring(rootLocator.getAbsoluteRemotePath().length() - 1);
            }
            ++i;
        }
        return null;
    }

    static boolean existsOnRepository(int connectionTemplateId, String absoluteRemotePath) throws VfsException {
        IResourceFactory factory = ResourceFactoryManager.getInstance().getLocatorFactory();
        IResource dvResource = null;
        try {
            dvResource = factory.createResource(connectionTemplateId, absoluteRemotePath, PathEncodingFlag.DECODED);
        }
        catch (VcmFailure vcmFailure) {
            if (vcmFailure.getStatusCode() != 404) {
                throw new VfsException("Checking path on repository failed (" + vcmFailure.getMessage() + ").", vcmFailure);
            }
            return false;
        }
        return dvResource != null;
    }

    IResource getVcrResource() {
        return this.m_dvVcr;
    }

    void setVcrResource(IResource resource) {
        this.m_dvVcr = resource;
    }

    private String pureGetObjectID() throws VfsException {
        IResource dvResource = this.getAnyInitializedDvResource();
        if (dvResource == null) {
            dvResource = this.getNewestDeltaVResource();
        }
        if (dvResource == null) {
            return null;
        }
        try {
            return dvResource.getXCMObjectId();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Get object id of folder item failed: " + this.getPath(), vcmFailure);
        }
    }

    public String getObjectID() throws VfsException {
        this.getVfsManager().checkState();
        return this.pureGetObjectID();
    }

    IResource getAnyInitializedDvResource() {
        if (this.m_dvVcr != null && this.m_dvVcr.isInitialized()) {
            return this.m_dvVcr;
        }
        return null;
    }

    void internalRemoveProperty(IResource dvResource, String name) throws VfsException {
        try {
            dvResource.removeProperties(new String[]{name});
        }
        catch (VcmFailure e) {
            String cause = e.getStatusCode() == 404 ? "Property was not found" : (e.getStatusCode() == 403 ? "Not allowed to remove property" : e.getMessage());
            throw new VfsException(cause, e);
        }
    }

    public void syncForce() throws VfsException {
        throw new VfsException("Method syncForce is not available for this object type.");
    }

    public void syncToDate(Calendar calendar) throws VfsException {
        throw new VfsException("Method syncToDate(calendar) is not available for this object type.");
    }

    public void syncPreview() throws VfsException {
        throw new VfsException("Sync with preview is not available for this object type.");
    }

    void internalSync(boolean forceSync, boolean previewSync) throws VfsException {
        throw new VfsException("Internal sync is not available for this object type.");
    }

    VersionedFileSystemManager getVfsManager() {
        return (VersionedFileSystemManager)this.getVersionedFileSystemManager();
    }

    public abstract IVersionedFileSystemManager getVersionedFileSystemManager();

    void refreshLocationState() throws VfsException {
        SyncEntry syncEntry;
        if (!this.isMounted()) {
            this.setLocationState(VfsFolderItemLocationState.NOT_MOUNTED);
            return;
        }
        SyncDB syncDB = this.getVersionedFileSystemManager().getCurrentContext().getSyncDb(this.getLocalPath());
        SyncEntry syncEntry2 = syncEntry = syncDB == null ? null : syncDB.getEntry(this.getLocalPath());
        if (this.getVcrResource() == null) {
            if (!this.getLocalFile().exists()) {
                VfsException e = new VfsException("Local only folder item (maybe added to repository), but local file/folder does not exist: " + this.getLocalPath());
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.WARN_LOG, this, e.getMessage());
            }
            if (syncEntry == null || !syncEntry.isSynced()) {
                this.setLocationState(VfsFolderItemLocationState.LOCAL_ONLY);
            } else {
                this.setLocationState(VfsFolderItemLocationState.SYNCED_TO_FORMER);
            }
            return;
        }
        if (this.asActivityRecordedFolderItem() == null) {
            this.setLocationState(VfsFolderItemLocationState.MOUNTED);
            return;
        }
        if (syncEntry == null || !syncEntry.isSynced()) {
            if (this.getLocalFile().exists()) {
                if (!this.isFile() && syncDB != null) {
                    if (syncEntry == null) {
                        syncEntry = syncDB.createEntry(this.getLocalPath(), this.getObjectID());
                    }
                    try {
                        syncEntry.setVersionUrlAndRemoteSyncTime(this.getVcrResource().getAsVersionControlled().getActiveVersion().getPersistentURL(), this.getVcrResource().lastModified().getTime());
                        VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.INFO_LOG, this, "Reconstructed missed SyncDB entry");
                    }
                    catch (VcmFailure vcmFailure) {
                        VfsException e = new VfsException("Reconstructing SyncDB entry failed, because get active version of DeltaV resource failed", vcmFailure);
                        VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.WARN_LOG, this, e.getMessage());
                    }
                    this.setLocationState(VfsFolderItemLocationState.SYNCED_TO_LATEST);
                    return;
                }
                VfsException e = new VfsException("Internal error: no SyncDB entry for folder item which remote and locally exists: " + this.getLocalPath());
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.WARN_LOG, this, e.getMessage());
                throw e;
            }
            this.setLocationState(VfsFolderItemLocationState.SERVER_ONLY);
            return;
        }
        if (this.asActivityRecordedFolderItem() == null && !this.getLocalFile().exists()) {
            syncDB.removeEntry(this.getLocalPath());
            this.setLocationState(VfsFolderItemLocationState.SERVER_ONLY);
            return;
        }
        long referringTime = 0L;
        try {
            referringTime = this.getVcrResource().getAsVersionControlled().lastModified().getTime();
        }
        catch (VcmFailure vcmFailure) {
            VfsException e = new VfsException("Get lastModified for DeltaV resource failed: " + this.getLocalPath(), vcmFailure);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.WARN_LOG, this, e.getMessage());
        }
        if (syncEntry.isSynced(referringTime)) {
            this.setLocationState(VfsFolderItemLocationState.SYNCED_TO_LATEST);
        } else {
            this.setLocationState(VfsFolderItemLocationState.SYNCED_TO_FORMER);
        }
    }

    void adaptSyncStateForPathToLocalRoot() throws VfsException {
        IVfsGenericFolder parent = this.getRealParent();
        if (parent == null) {
            return;
        }
        VfsAmbiguousFolder ambiguousParent = (VfsAmbiguousFolder)parent.asAmbiguousFolder();
        VfsFolderItem parentFolder = null;
        if (ambiguousParent == null) {
            parentFolder = (VfsFolderItem)((Object)parent);
            if (parentFolder != null && !parentFolder.isMounted()) {
                parentFolder = null;
            }
        } else {
            parentFolder = ambiguousParent.getUnambiguousMountedFolder();
        }
        if (parentFolder != null) {
            parentFolder.setLocationState(VfsFolderItemLocationState.MOUNTED);
            SyncDB syncDB = parentFolder.getContext().getSyncDb(parentFolder.getLocalPath());
            SyncEntry syncEntry = syncDB.getEntry(parentFolder.getLocalPath());
            if (syncEntry == null) {
                syncEntry = syncDB.createEntry(parentFolder.getLocalPath(), "UNKNOWN_OBJECT_ID");
            }
            if (!syncEntry.isSynced()) {
                try {
                    IResource dvVcr = parentFolder.getVcrResource();
                    if (dvVcr != null) {
                        if (parentFolder.asWorkspace() != null) {
                            syncEntry.setVersionUrlAndRemoteSyncTime("UNKNOWN_VERSION_URL", 1L);
                        } else if (parentFolder.asFolder() != null) {
                            IVersion dvVersion = dvVcr.getAsVersionControlled().getActiveVersion();
                            VfsFolder folder = (VfsFolder)parentFolder;
                            folder.setSyncedVersion(new VfsVersion(this.getVfsManager(), dvVersion));
                            syncEntry.setVersionUrlAndRemoteSyncTime(folder.getSyncedVersion().getUrl(), folder.getSyncedVersion().getLastModifiedDate().getTime());
                        }
                    } else {
                        new VfsException("Internal error: adapt SyncDB failed, because DeltaV resource is not available for: " + parentFolder.getLocalPath());
                    }
                }
                catch (VcmFailure vcmFailure) {
                    new VfsException("Adapt SyncDB failed, because get active version failed: " + parentFolder.getLocalPath(), vcmFailure);
                }
            }
            parentFolder.adaptSyncStateForPathToLocalRoot();
        } else if ((parent.asWorkspace() != null || parent.asWorkspaceFolder() != null) && ((VfsFolderItem)((Object)parent)).isMounted()) {
            String parentAbsoluteLocalPath = parent.getLocalPath();
            SyncDB syncDB = this.getVersionedFileSystemManager().getCurrentContext().getSyncDb(parentAbsoluteLocalPath);
            if (syncDB != null) {
                SyncEntry entry = syncDB.getEntry(parentAbsoluteLocalPath);
                if (entry == null) {
                    entry = syncDB.createEntry(parentAbsoluteLocalPath, "UNKNOWN_OBJECT_ID");
                }
                entry.setVersionUrlAndRemoteSyncTime("UNKNOWN_VERSION_URL", 1L);
                ((VfsFolderItem)((Object)parent)).adaptSyncStateForPathToLocalRoot();
            }
        }
    }

    boolean isSuccessorOf(String absoluteRemotePath) {
        return this.getAbsoluteRemotePath().startsWith(absoluteRemotePath);
    }

    static void checkAndAdaptCachedFolderItem(VfsFolderItem folderItem, IResource resource, String absoluteLocalPath, VfsFolderItemCategory folderItemCategory) throws VfsException {
        VfsFolderItemRelation relation = VfsFolderItem.checkIdentityOfRepresentedResource(folderItem, resource, folderItemCategory);
        if (relation == VfsFolderItemRelation.IDENTITY) {
            if (resource != KEEP_DELTAV_RESOURCE) {
                folderItem.m_dvVcr = resource;
            }
            folderItem.refreshLocationState();
        } else {
            if (relation == VfsFolderItemRelation.DIFFERENT_CATEGORY) {
                throw new VfsException("Internal error: invalid folder item found in cache with local path: " + absoluteLocalPath);
            }
            if (relation == VfsFolderItemRelation.DIFFERENT_LOCATION) {
                if (folderItem.asActivityRecordedFolderItem() != null || folderItem.getLocationState() != VfsFolderItemLocationState.LOCAL_ONLY) {
                    throw new VfsException("Internal error: invalid folder item found in cache with local path: " + absoluteLocalPath);
                }
                if (folderItem.asFile() != null) {
                    throw new VfsException("Internal error: invalid folder item found in cache with local path: " + absoluteLocalPath);
                }
                folderItem.m_dvVcr = resource;
                folderItem.refreshLocationState();
            }
        }
    }

    void checkIsModifiable() throws VfsException {
        this.checkIsModifiable(ExceptionSeverity.INFO);
    }

    void checkIsModifiable(ExceptionSeverity severity) throws VfsException {
        VfsFilterType filterType = this.asActivityRecordedFolderItem() != null ? this.getWorkspace().getContext().getFilterType(this.getRemoteLocator()) : this.getContext().getFilterType(this.getRemoteLocator());
        if (filterType == VfsFilterType.READONLY) {
            String msg = this.asWorkspace() != null ? "Workspace '" + this.getDisplayName() + "' is set read-only by filter in client definition" : (this.asWorkspaceFolder() != null ? "Workspace folder '" + this.getDisplayName() + "' is set read-only by filter in client definition" : (this.asFile() != null ? "File '" + this.getDisplayName() + "' is set read-only by filter in client definition" : "Folder '" + this.getDisplayName() + "' is set read-only by filter in client definition"));
            throw new VfsException(severity, ExceptionCategory.ONE_ARGUMENT_PLACEHOLDER, new Object[]{msg}, null);
        }
    }

    static void checkIsVisible(IVfsContext context, IVfsRemoteLocator remoteLocator, String folderName) throws VfsException {
        VfsFilterType filterType;
        if (context.areFiltersDefined() && (filterType = context.getFilterType(remoteLocator)) == VfsFilterType.EXCLUDE) {
            throw new VfsException(ExceptionSeverity.INFO, VfsExceptionCategory.FOLDER_IS_EXCLUDED_BY_FILTER_IN_CLIENT_DEFINITION, new Object[]{folderName}, null);
        }
    }

    public boolean isModifiable() {
        try {
            this.checkIsModifiable();
        }
        catch (VfsException e) {
            LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
            return false;
        }
        return true;
    }

    static void refreshParentsOfDeletedItems(Map parentsAndDeletedItems) {
        Iterator iterator = parentsAndDeletedItems.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry currentParentEntry = iterator.next();
            IVfsGenericFolder folder = (IVfsGenericFolder)currentParentEntry.getKey();
            if (folder.getLocationState() == VfsFolderItemLocationState.DELETED) continue;
            HashMap deletedItems = (HashMap)currentParentEntry.getValue();
            if (folder.asFolder() != null) {
                ((VfsFolder)folder).removeFolderItems(deletedItems);
                continue;
            }
            if (folder.asWorkspace() != null) {
                ((VfsWorkspace)folder).removeFolderItems(deletedItems);
                continue;
            }
            if (folder.asWorkspaceFolder() == null) continue;
            ((VfsWorkspaceFolder)folder).removeFolderItems(deletedItems);
        }
    }

    static void removeFolderItemsFromParent(IVfsGenericFolder parentFolder, Map folderItems) {
        if (parentFolder.asFolder() != null) {
            ((VfsFolder)parentFolder).removeFolderItems(folderItems);
        } else if (parentFolder.asWorkspace() != null) {
            ((VfsWorkspace)parentFolder).removeFolderItems(folderItems);
        } else if (parentFolder.asWorkspaceFolder() != null) {
            ((VfsWorkspaceFolder)parentFolder).removeFolderItems(folderItems);
        }
    }

    static Collection condenseFolderItems(IVfsFolderItem[] folderItems) {
        TreeMap<String, IVfsFolderItem> sortedFolderItems = new TreeMap<String, IVfsFolderItem>();
        int i = 0;
        while (i < folderItems.length) {
            IVfsFolderItem folderItem = folderItems[i];
            sortedFolderItems.put(folderItem.getAbsoluteRemotePath(), folderItem);
            ++i;
        }
        Iterator sortedIterator = sortedFolderItems.keySet().iterator();
        String lastPath = null;
        while (sortedIterator.hasNext()) {
            String absoluteRemotePath = (String)sortedIterator.next();
            if (lastPath != null && absoluteRemotePath.startsWith(lastPath)) {
                sortedIterator.remove();
                continue;
            }
            lastPath = absoluteRemotePath;
        }
        return sortedFolderItems.values();
    }

    String getIdentifyingString() {
        String identifyingString;
        block3: {
            try {
                identifyingString = this.getBrowsePath();
            }
            catch (VfsException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
                if (this.isMounted()) {
                    identifyingString = this.getLocalPath();
                }
                identifyingString = this.getAbsoluteRemotePath();
                if (identifyingString != null && identifyingString.length() != 0) break block3;
                identifyingString = this.getName();
            }
        }
        return identifyingString;
    }

    void refreshForMountPointDeletion() throws VfsException {
        this.m_localFile = null;
        this.setLocationState(VfsFolderItemLocationState.NOT_MOUNTED);
    }

    public Object[] getChildrenObjects() throws VfsException {
        return this.getVfsManager().getPropertiesFeature().getChildrenObjects(this.getVcrResource());
    }

    public abstract boolean isReleased();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            KEEP_DELTAV_RESOURCE = ResourceFactoryManager.getInstance().getProxyFactory().createVCR(0, "/KEEP_DELTAV_RESOURCE", PathEncodingFlag.DECODED);
            NULL_DELTAV_RESOURCE = ResourceFactoryManager.getInstance().getProxyFactory().createVCR(0, "/NULL_DELTAV_RESOURCE", PathEncodingFlag.DECODED);
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsRuntimeException("Internal Error: Initialization of default objects failed.", vcmFailure);
        }
    }
}

