/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IWorkingResource;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICreatedResource;
import com.tssap.dtr.client.lib.exceptions.ExceptionCategory;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityElement;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsAmbiguousFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItemListener2;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemCategory;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.impl.FolderItemCache;
import com.tssap.dtr.client.lib.vfs.impl.FolderUtil;
import com.tssap.dtr.client.lib.vfs.impl.Util;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivity;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsListenerHandler;
import com.tssap.dtr.client.lib.vfs.impl.VfsXcmProperty;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncDB;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;

class VfsFolder
extends VfsActivityRecordedFolderItem
implements IVfsFolder {
    private WeakReference[] m_weakFolderItems = new WeakReference[0];
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$VfsFolder == null ? (class$com$tssap$dtr$client$lib$vfs$impl$VfsFolder = VfsFolder.class$("com.tssap.dtr.client.lib.vfs.impl.VfsFolder")) : class$com$tssap$dtr$client$lib$vfs$impl$VfsFolder));
    boolean m_isRefreshedOnce = false;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$VfsFolder;

    private VfsFolder(IVfsWorkspace workspace, IResource resource, IVirtualFile localFolder) throws VfsException {
        super(workspace, resource, localFolder);
    }

    VfsFolder(VfsActivity activity, ICreatedResource dvNewResource) throws VfsException {
        super(activity.getWorkspace(), VfsFolderItem.NULL_DELTAV_RESOURCE, VfsFolderItem.NULL_LOCAL_FILE);
        this.addDvNewResource(activity, dvNewResource);
        this.addActivityAndActivityState(activity, VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE);
    }

    static VfsFolder pureUnsecuredGetVfsFolder(IVfsWorkspace workspace, IResource dvResource, IVirtualFile localFile) throws VfsException {
        FolderItemCache folderItemCache = ((VersionedFileSystemManager)workspace.getVersionedFileSystemManager()).getFolderItemCache();
        VfsFolderItem folderItem = null;
        String absoluteLocalPath = VfsFolderItem.getAbsoluteLocalPath(localFile, dvResource, workspace.getContext(), VfsFolderItemCategory.FOLDER);
        if (absoluteLocalPath != null) {
            folderItem = folderItemCache.getFolderItemWithLocalPath(absoluteLocalPath);
        }
        if (folderItem != null) {
            VfsActivityRecordedFolderItem.checkAndAdaptCachedFolderItem(folderItem, dvResource, absoluteLocalPath, VfsFolderItemCategory.FOLDER);
        }
        if (folderItem == null) {
            boolean localRemoteNameClash = false;
            if (dvResource == VfsFolderItem.KEEP_DELTAV_RESOURCE) {
                dvResource = Util.createInitializedDvResource(workspace, absoluteLocalPath);
            } else if (localFile == VfsFolderItem.KEEP_LOCAL_FILE) {
                localFile = absoluteLocalPath != null ? workspace.getContext().getFileService().constructFile(absoluteLocalPath) : VfsFolderItem.NULL_LOCAL_FILE;
                localRemoteNameClash = VfsActivityRecordedFolderItem.checkLocalRemoteNameClash(workspace, localFile, dvResource);
            }
            if (localRemoteNameClash) {
                folderItem = new VfsFolder(workspace, VfsFolderItem.NULL_DELTAV_RESOURCE, localFile);
                try {
                    ((VfsActivityRecordedFolderItem)folderItem).setDvLocalRemoteNameClashVcr(dvResource.getAsVersionControlled());
                }
                catch (VcmFailure vcmFailure) {
                    VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, absoluteLocalPath, "Internal error: accessing DeltaV resource failed");
                    throw new VfsException("Internal error: accessing DeltaV resource failed", vcmFailure);
                }
            } else {
                folderItem = new VfsFolder(workspace, dvResource, localFile);
            }
            try {
                boolean doOverwrite = true;
                folderItemCache.addFolderItem(folderItem, doOverwrite);
            }
            catch (VfsException e) {
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, localFile.getAbsolutePath(), "Internal error");
                throw new VfsException("Internal error: Add folder to cache failed", e);
            }
        }
        return (VfsFolder)folderItem.asFolder();
    }

    public IVfsFolder createSubFolder(String name, IVfsActivity activity) {
        this.getVfsManager().checkState();
        throw new UnsupportedOperationException();
    }

    public IVfsAmbiguousFolder createAmbiguousClone() {
        this.getVfsManager().checkState();
        throw new UnsupportedOperationException();
    }

    public VfsActionOnFolderItem[] getActionsForCurrentState() {
        this.getVfsManager().checkState();
        return this.getVfsManager().getAllowedActionsFeature().getAllowedActionsForCurrentState(this);
    }

    void initializeChildren(IVfsFolderItem[] children) {
        WeakReference[] oldWeakFolderItems = this.m_weakFolderItems;
        boolean wasRefreshedOnce = this.m_isRefreshedOnce;
        this.m_weakFolderItems = new WeakReference[children.length];
        int i = 0;
        while (i < children.length) {
            this.m_weakFolderItems[i] = new WeakReference<IVfsFolderItem>(children[i]);
            ++i;
        }
        this.m_isRefreshedOnce = true;
        if (!wasRefreshedOnce) {
            return;
        }
        if (children.length != oldWeakFolderItems.length) {
            this.getVfsManager().fireEventFolderItemsAddedOrRemoved(this);
            return;
        }
        HashSet<IVfsFolderItem> remainingOldFolderItems = new HashSet<IVfsFolderItem>(oldWeakFolderItems.length * 2);
        int i2 = 0;
        while (i2 < oldWeakFolderItems.length) {
            IVfsFolderItem folderItem = (IVfsFolderItem)oldWeakFolderItems[i2].get();
            if (folderItem == null) {
                this.getVfsManager().fireEventFolderItemsAddedOrRemoved(this);
                return;
            }
            remainingOldFolderItems.add(folderItem);
            ++i2;
        }
        int i3 = 0;
        while (i3 < children.length) {
            IVfsFolderItem folderItem = children[i3];
            if (!remainingOldFolderItems.remove(folderItem)) {
                this.getVfsManager().fireEventFolderItemsAddedOrRemoved(this);
                return;
            }
            ++i3;
        }
        if (!remainingOldFolderItems.isEmpty()) {
            this.getVfsManager().fireEventFolderItemsAddedOrRemoved(this);
        }
    }

    public IVfsFolderItem[] refreshFolderItems() throws VfsException {
        this.getVfsManager().checkState();
        if (this.getLocationState() == VfsFolderItemLocationState.DELETED) {
            return new IVfsFolderItem[0];
        }
        IVfsFolderItem[] refreshedFolderItems = FolderUtil.getRefreshedFolderItems(this, true);
        this.initializeChildren(refreshedFolderItems);
        return refreshedFolderItems;
    }

    public IVfsFolderItem[] getFolderItems() {
        IVfsFolderItem[] folderItems;
        block8: {
            block7: {
                this.getVfsManager().checkState();
                if (!this.m_isRefreshedOnce) {
                    try {
                        this.refreshFolderItems();
                    }
                    catch (VfsException x) {
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                        if (x.getCategory() != ExceptionCategory.FORBIDDEN) break block7;
                        this.m_weakFolderItems = new WeakReference[0];
                        this.m_isRefreshedOnce = true;
                    }
                }
            }
            if (this.copyWeakFolderItemsToStrong(this.m_weakFolderItems, folderItems = new IVfsFolderItem[this.m_weakFolderItems.length])) {
                return folderItems;
            }
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.PENDING, this, "Items have been removed by GC, refreshing...");
            try {
                this.refreshFolderItems();
            }
            catch (VfsException e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                if (e.getCategory() != ExceptionCategory.FORBIDDEN) break block8;
                this.m_weakFolderItems = new WeakReference[0];
                this.m_isRefreshedOnce = true;
            }
        }
        folderItems = new IVfsFolderItem[this.m_weakFolderItems.length];
        if (this.copyWeakFolderItemsToStrong(this.m_weakFolderItems, folderItems)) {
            return folderItems;
        }
        IllegalStateException e = new IllegalStateException("Attention: can't get folder items.");
        LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)e, (int)500);
        return new IVfsFolderItem[0];
    }

    private boolean copyWeakFolderItemsToStrong(WeakReference[] sourceWeakFolderItems, IVfsFolderItem[] destinationFolderItems) {
        if (sourceWeakFolderItems.length != destinationFolderItems.length) {
            throw new IllegalArgumentException("Can't copy, sizes differ: srclen=" + sourceWeakFolderItems.length + ", destlen=" + destinationFolderItems.length);
        }
        int i = 0;
        while (i < sourceWeakFolderItems.length) {
            IVfsFolderItem folderItem = (IVfsFolderItem)sourceWeakFolderItems[i].get();
            if (folderItem == null) {
                return false;
            }
            destinationFolderItems[i] = folderItem;
            ++i;
        }
        return true;
    }

    public void removeFromClient() throws VfsException {
        this.getVfsManager().checkState();
        this.getVfsManager().getSyncRemoveFeature().removeFromClient(this);
    }

    public void createAndCheckout(IVfsActivity activity, int depth) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(activity);
        ((VfsActivity)activity).checkWorkspace(this.getWorkspace());
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Checkout is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        VfsListenerHandler listenerHandler = this.getVfsManager().getListenerHandler();
        boolean wasInternalDelayedListeningTurnedOn = listenerHandler.isVfsInternalDelayedListeningTurnedOn();
        if (!wasInternalDelayedListeningTurnedOn) {
            listenerHandler.startVfsInternalDelayedListening();
        }
        try {
            this.createAndCheckout(activity, depth, true);
            Object var6_7 = null;
            if (!wasInternalDelayedListeningTurnedOn) {
                listenerHandler.stopVfsInternalDelayedListening();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!wasInternalDelayedListeningTurnedOn) {
                listenerHandler.stopVfsInternalDelayedListening();
            }
            throw throwable;
        }
    }

    void createAndCheckout(IVfsActivity activity, int depth, boolean notifyListener) throws VfsException {
        boolean wasAlreadyCheckedOutInThisActivity = false;
        if (this.getLocationState() == VfsFolderItemLocationState.DELETED) {
            throw new VfsException("Checkout not possible: folder is deleted");
        }
        if (this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT || this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE) {
            if (this.checkCheckoutStatus(activity, this.getActivityState())) {
                wasAlreadyCheckedOutInThisActivity = true;
            }
        } else if (this.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            throw new VfsException("Checkout not possible: folder is " + this.getActivityState().getText());
        }
        if (this.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY && !wasAlreadyCheckedOutInThisActivity) {
            this.createAndCheckout(activity, false);
        }
        if (depth == 0) {
            if (notifyListener) {
                this.getVfsManager().fireEventActivityItemsAddedOrRemoved(activity);
            }
            return;
        }
        this.refreshFolderItems();
        IVfsFolderItem[] folderItems = this.getFolderItems();
        if (this.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY && !wasAlreadyCheckedOutInThisActivity) {
            int i = 0;
            while (i < folderItems.length) {
                VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)folderItems[i];
                IVfsFolder folder = folderItem.asFolder();
                if (folder == null) {
                    if (folderItem.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY && folderItem.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                        try {
                            folderItem.pureCreateAndCheckout(activity, this.getNewestDeltaVResource((VfsActivity)activity));
                        }
                        catch (VfsException e) {
                            LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)e, (int)500);
                        }
                    }
                } else {
                    try {
                        ((VfsFolder)folder).pureCreateAndCheckoutSubTree(activity, depth - 1, this.getNewestDeltaVResource((VfsActivity)activity));
                    }
                    catch (VfsException e) {
                        LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)e, (int)500);
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < folderItems.length) {
                VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)folderItems[i];
                VfsFolder folder = (VfsFolder)folderItem.asFolder();
                if (folder == null) {
                    if (folderItem.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY && folderItem.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                        try {
                            folderItem.createAndCheckout(activity, false);
                        }
                        catch (VfsException e) {
                            LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)e, (int)500);
                        }
                    }
                } else {
                    try {
                        folder.createAndCheckout(activity, depth - 1, false);
                    }
                    catch (VfsException e) {
                        LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)e, (int)500);
                    }
                }
                ++i;
            }
        }
        if (notifyListener) {
            this.getVfsManager().fireEventActivityItemsAddedOrRemoved(activity);
        }
    }

    private void pureCreateAndCheckoutSubTree(IVfsActivity activity, int depth, IResource newParentResource) throws VfsException {
        if (newParentResource == null) {
            VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, this, "Invalid new DeltaV resource");
            throw new VfsException("Internal Error: invalid new DeltaV resource");
        }
        this.pureCreateAndCheckout(activity, newParentResource);
        if (depth == 0) {
            return;
        }
        try {
            this.refreshFolderItems();
        }
        catch (VfsException e) {
            VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, this, "Skipping folder items in folder, because refresh failed");
            throw e;
        }
        IVfsFolderItem[] folderItems = this.getFolderItems();
        int i = 0;
        while (i < folderItems.length) {
            VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)folderItems[i];
            IVfsFolder folder = folderItem.asFolder();
            if (folder == null) {
                if (folderItem.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY && folderItem.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                    try {
                        folderItem.pureCreateAndCheckout(activity, this.getNewestDeltaVResource((VfsActivity)activity));
                    }
                    catch (VfsException e) {
                        LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)e, (int)500);
                    }
                }
            } else {
                try {
                    ((VfsFolder)folder).pureCreateAndCheckoutSubTree(activity, depth - 1, this.getNewestDeltaVResource((VfsActivity)activity));
                }
                catch (VfsException e) {
                    LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)e, (int)500);
                }
            }
            ++i;
        }
    }

    public void checkOutForEdit(IVfsActivity activity, int depth) throws VfsException {
        this.checkOutForEdit(activity, depth, false);
    }

    public void checkOutForEdit(IVfsActivity activity, int depth, boolean exclusive) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(activity);
        ((VfsActivity)activity).checkWorkspace(this.getWorkspace());
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Checkout is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.EDIT, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        if (depth == 0) {
            this.checkOutForEdit(activity, exclusive, true);
        } else {
            this.checkOutForEdit(activity, depth, exclusive, true);
        }
    }

    void checkOutForEdit(IVfsActivity activity, int depth, boolean exclusive, boolean notifyListener) throws VfsException {
        if (this.getLocationState() == VfsFolderItemLocationState.DELETED) {
            throw new VfsException("Checkout not possible: Folder is deleted");
        }
        if (this.asActivityRecordedFolderItem().getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
            throw new VfsException("Checkout not possible: Folder is checked out for delete");
        }
        IVfsActivity act = this.checkAndGetProperActivityForCheckout(activity);
        if (act == null) {
            throw new VfsException("Checkout not possible: activity is closed.");
        }
        if (act != activity) {
            activity = act;
        }
        if (depth <= 0) {
            return;
        }
        if (this.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_LATEST || this.getLocationState() == VfsFolderItemLocationState.MOUNTED) {
            this.refreshFolderItems();
            IVfsFolderItem[] folderItems = this.getFolderItems();
            int i = 0;
            while (i < folderItems.length) {
                VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)folderItems[i];
                IVfsFolder folder = folderItem.asFolder();
                if (folder == null) {
                    if (folderItem.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_LATEST && folderItem.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                        try {
                            folderItem.checkDiscardTargetVersionInOpenActivities(VfsActionType.EDIT);
                            folderItem.pureCheckOutForEdit(activity, exclusive, false);
                        }
                        catch (VfsException e) {
                            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                        }
                    } else if (folderItem.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                        VfsActionRecorder.log(VfsActionType.EDIT, VfsActionStatus.SKIPPED, folderItem, "File is already checked-out");
                    } else if (folderItem.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) {
                        VfsActionRecorder.log(VfsActionType.EDIT, VfsActionStatus.SKIPPED, folderItem, "File is local-only");
                    } else if (folderItem.getLocationState() == VfsFolderItemLocationState.SERVER_ONLY) {
                        VfsActionRecorder.log(VfsActionType.EDIT, VfsActionStatus.SKIPPED, folderItem, "File is server-only - file needs to be synced first");
                    } else if (folderItem.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_FORMER) {
                        VfsActionRecorder.log(VfsActionType.EDIT, VfsActionStatus.SKIPPED, folderItem, "File is out of date - file needs to be synced to latest version first");
                    }
                } else {
                    try {
                        ((VfsFolder)folder).checkOutForEdit(activity, depth - 1, exclusive, false);
                    }
                    catch (VfsException e) {
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                    }
                }
                ++i;
            }
        } else {
            VfsActionRecorder.log(VfsActionType.EDIT, VfsActionStatus.SKIPPED, this, "File is not synced- file needs to be synced to latest version first");
            new VfsException("Not synced folder items can not be checked out for edit:" + this.getLocalPath());
        }
        if (notifyListener) {
            this.getVfsManager().fireEventActivityItemsAddedOrRemoved(activity);
        }
    }

    void checkOutAndDelete_preliminaryIncompleteImplementation(boolean deleteLocalOnlyItems, IVfsActivity activity) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(activity);
        if (this.getLocationState() != VfsFolderItemLocationState.SYNCED_TO_LATEST && this.getLocationState() != VfsFolderItemLocationState.MOUNTED && this.getLocationState() != VfsFolderItemLocationState.SERVER_ONLY) {
            String message = "Folder hierarchy cannot be checkout for delete, because it is " + this.getLocationState().toString();
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, message);
            throw new VfsException(message + " : " + this.getLocalPath());
        }
        if (this.checkCheckoutStatus(activity, VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE)) {
            return;
        }
        ((VfsActivity)activity).checkWorkspace(this.getWorkspace());
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            String message = "Checkout is not allowed because workspace is not modifiable";
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, message);
            throw new VfsException(message + ": " + this.getWorkspace().getAbsoluteRemotePath(), ex);
        }
        if (this.getVfsManager().isSomethingCheckedOutUnderFolder(this)) {
            String message = "Folder and subtree cannot be deleted, because there is something checked out";
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, message);
            throw new VfsException(message + ": " + this.getLocalPath());
        }
        IVfsActivity[] openActivities = this.getWorkspace().getActivities(VfsActivityState.OPEN);
        int i = 0;
        while (i < openActivities.length) {
            IVfsActivityElement[] activityElements = openActivities[i].getElements();
            int j = 0;
            while (j < activityElements.length) {
                IVfsFolderItem correspondingFolderItem;
                IVfsVersion version = activityElements[j].getAsVersion();
                if (version != null && (correspondingFolderItem = version.getCorrespondingFolderItem(this.getWorkspace())) != null && ((VfsFolderItem)correspondingFolderItem).isSuccessorOf(this.getAbsoluteRemotePath())) {
                    String message = "Folder and subtree cannot be deleted, because there is an open conflict resolution contained in the activity \"" + ((VfsActivity)openActivities[i]).getIdentifyingString() + "\"";
                    VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, message);
                    throw new VfsException(message + ": " + this.getLocalPath());
                }
                ++j;
            }
            ++i;
        }
        IVfsGenericFolder parent = this.getRealParent();
        if (parent.asWorkspace() != null) {
            String message = "Deletion of folder and subtree is not allowed for folder that is directly located under workspace";
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, message);
            throw new VfsException(message + ": " + this.getLocalPath());
        }
        if (deleteLocalOnlyItems) {
            SyncDB syncDB = this.getContext().getSyncDb(this.getLocalPath());
            VfsFolder.deleteLocalOnlyItemsBelow(this.getLocalFile(), syncDB, this.getVfsManager());
        }
        this.removeFromClient();
        if (parent.asFolder() == null) {
            String message = "Internal error: Invalid parent folder item";
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, message);
            throw new VfsException(message + " of folder: " + this.getLocalPath());
        }
        this.checkoutAndDeleteUnderActivityRecordedFolder((VfsFolder)parent.asFolder(), activity, false);
        this.getVfsManager().fireEventActivityItemsAddedOrRemoved(activity);
    }

    private static void deleteLocalOnlyItemsBelow(IVirtualFile folder, SyncDB syncDB, VersionedFileSystemManager manager) throws VfsException {
        if (!folder.isDirectory()) {
            if (folder.isFile() && syncDB.getEntry(folder.getAbsolutePath()) == null && !folder.delete()) {
                throw new VfsException("Delete local only file failed: " + folder.getAbsolutePath());
            }
            return;
        }
        IVirtualFile[] children = folder.listFiles();
        int i = 0;
        while (i < children.length) {
            IVirtualFile child = children[i];
            if (child.isDirectory()) {
                VfsFolder.deleteLocalOnlyItemsBelow(child, syncDB, manager);
            } else if (child.isFile() && syncDB.getEntry(child.getAbsolutePath()) == null) {
                if (!child.delete()) {
                    throw new VfsException("Delete local only file failed: " + child.getAbsolutePath());
                }
                manager.fireEventFolderItemContentChanged(child.getAbsolutePath(), IVfsFolderItemListener2.ContentChangeReasons.CHECKED_OUT_FOR_DELETE);
            }
            ++i;
        }
        if (syncDB.getEntry(folder.getAbsolutePath()) == null) {
            children = folder.listFiles();
            if (children != null && children.length > 0) {
                throw new VfsException("Delete local only folder failed, because it is not empty: " + folder.getAbsolutePath());
            }
            if (!folder.delete()) {
                throw new VfsException("Delete local only folder failed: " + folder.getAbsolutePath());
            }
        }
    }

    public boolean isEmpty() throws VfsException {
        this.getVfsManager().checkState();
        IVfsFolderItem[] folderItems = this.getFolderItems();
        if (folderItems.length == 0) {
            return true;
        }
        int i = 0;
        while (i < folderItems.length) {
            if (folderItems[i].asActivityRecordedFolderItem() != null && !folderItems[i].asActivityRecordedFolderItem().isDeleted()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean hasNewCreatedFolderItems(VfsActivity activity) throws VfsException {
        if (this.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT || this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
            return false;
        }
        if (this.getFolderItems().length > 0) {
            IVfsFolderItem[] folderItems = this.getFolderItems();
            int i = 0;
            while (folderItems.length > i) {
                VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)folderItems[i];
                if (folderItem.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE && folderItem.isCheckedOut(activity)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    boolean hasNewCreatedFolderItems() throws VfsException {
        if (this.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT || this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
            return false;
        }
        if (this.getFolderItems().length > 0) {
            IVfsFolderItem[] folderItems = this.getFolderItems();
            int i = 0;
            while (folderItems.length > i) {
                if (folderItems[i].asActivityRecordedFolderItem().getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean hasCheckedOutFolderItems() throws VfsException {
        this.getVfsManager().checkState();
        IVfsActivity[] vfsOpenActivities = this.getWorkspace().getActivities(VfsActivityState.OPEN);
        int i = 0;
        while (i < vfsOpenActivities.length) {
            IVfsActivityRecordedFolderItem[] checkedOutFolderItems = vfsOpenActivities[i].getElementsFromOpenActivity();
            int j = 0;
            while (j < checkedOutFolderItems.length) {
                if (checkedOutFolderItems[j] != this && checkedOutFolderItems[j].getBrowsePath().startsWith(this.getBrowsePath())) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    boolean hasCheckedOutForDeleteFolderItems() throws VfsException {
        if (this.getActivityState() != VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT) {
            return false;
        }
        if (this.getFolderItems().length > 0) {
            IVfsFolderItem[] folderItems = this.getFolderItems();
            int i = 0;
            while (folderItems.length > i) {
                if (folderItems[i].asActivityRecordedFolderItem().getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    boolean hasCheckedOutForDeleteFolderItems(VfsActivity activity) throws VfsException {
        if (this.getActivityState() != VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT) {
            return false;
        }
        if (this.getFolderItems().length > 0) {
            IVfsFolderItem[] folderItems = this.getFolderItems();
            int i = 0;
            while (folderItems.length > i) {
                VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)folderItems[i];
                if (folderItem.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE && folderItem.isCheckedOut(activity)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    boolean hasFolderItemsOnServer() throws VfsException {
        if (this.isEmpty()) {
            return false;
        }
        IVfsFolderItem[] folderItems = this.getFolderItems();
        int i = 0;
        while (i < folderItems.length) {
            if (folderItems[i].getLocationState() != VfsFolderItemLocationState.LOCAL_ONLY) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void syncToDate(Calendar calendar) throws VfsException {
        this.getVfsManager().checkState();
        this.getVfsManager().getSyncRemoveFeature().syncToCalendar(this, calendar);
    }

    public void syncForce() throws VfsException {
        this.getVfsManager().checkState();
        this.getVfsManager().getSyncRemoveFeature().sync(this, true, false, true);
    }

    public void syncPreview() throws VfsException {
        this.getVfsManager().checkState();
        this.getVfsManager().getSyncRemoveFeature().sync(this, false, true, false);
    }

    public void sync() throws VfsException {
        this.getVfsManager().checkState();
        this.getVfsManager().getSyncRemoveFeature().sync(this, false, false, true);
    }

    void moveChildren(VfsActivity sourceActivity, VfsActivity destinationActivity) throws VfsException {
        IVfsActivityRecordedFolderItem[] activityElements = sourceActivity.getElementsFromOpenActivity();
        int i = 0;
        while (i < activityElements.length) {
            VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)activityElements[i];
            try {
                if (folderItem != this && folderItem.isSuccessorOf(this.getAbsoluteRemotePath()) && folderItem.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT) {
                    sourceActivity.pureMoveElement(folderItem, destinationActivity);
                }
            }
            catch (VfsException e) {
                LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)e, (int)500);
            }
            ++i;
        }
    }

    void removeFolderItems(Map folderItems) {
        this.m_weakFolderItems = FolderUtil.removeFolderItems(this.m_weakFolderItems, folderItems);
    }

    void addFolderItem(VfsFolderItem folderItem) {
        int i = 0;
        while (i < this.m_weakFolderItems.length) {
            VfsFolderItem containedFolderItem = (VfsFolderItem)this.m_weakFolderItems[i].get();
            if (containedFolderItem != null && containedFolderItem == folderItem) {
                return;
            }
            ++i;
        }
        WeakReference[] newItems = new WeakReference[this.m_weakFolderItems.length + 1];
        newItems[0] = new WeakReference<VfsFolderItem>(folderItem);
        System.arraycopy(this.m_weakFolderItems, 0, newItems, 1, this.m_weakFolderItems.length);
        this.m_weakFolderItems = newItems;
        this.getVfsManager().fireEventFolderItemsAddedOrRemoved(this);
    }

    boolean hasLocalOnlyFolderItems() {
        if (this.getLocationState() == VfsFolderItemLocationState.DELETED || this.getLocationState() == VfsFolderItemLocationState.NOT_MOUNTED || this.getLocationState() == VfsFolderItemLocationState.SERVER_ONLY) {
            return false;
        }
        if (this.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) {
            return this.getFolderItems().length > 0;
        }
        SyncDB syncDb = this.getContext().getSyncDb(this.getLocalPath());
        ArrayList<IVirtualFile> folders = new ArrayList<IVirtualFile>();
        folders.add(this.getLocalFile());
        while (!folders.isEmpty()) {
            int lastIndex = folders.size() - 1;
            IVirtualFile localFile = (IVirtualFile)folders.get(lastIndex);
            folders.remove(lastIndex);
            IVirtualFile[] children = localFile.listFiles();
            int i = 0;
            while (i < children.length) {
                IVirtualFile child = children[i];
                if (syncDb.getEntry(child.getAbsolutePath()) == null) {
                    return true;
                }
                if (child.isDirectory()) {
                    folders.add(child);
                }
                ++i;
            }
        }
        return false;
    }

    public void resetExclusiveCheckoutLock(int depth) throws VfsException {
        this.getVfsManager().checkState();
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Reset checkout lock is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        if (this.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.SKIPPED, this, "Folder is local only");
            return;
        }
        if (this.getLocationState() == VfsFolderItemLocationState.DELETED) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.SKIPPED, this, "Folder is deleted");
            return;
        }
        if (this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.SKIPPED, this, "Folder is checked out for delete");
            return;
        }
        VfsException caughtException = null;
        if (this.isExclusiveCheckedOut()) {
            try {
                this.resetExclusiveCheckoutLock();
            }
            catch (VfsException e) {
                caughtException = e;
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
        } else {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.SKIPPED, this, "Folder is not exclusive checked out");
        }
        if (depth <= 0) {
            return;
        }
        this.refreshFolderItems();
        IVfsFolderItem[] children = this.getFolderItems();
        int i = 0;
        while (i < children.length) {
            IVfsFolderItem child = children[i];
            if (child.asFile() != null) {
                try {
                    child.asFile().resetExclusiveCheckoutLock();
                }
                catch (VfsException e) {
                    caughtException = e;
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                }
            } else if (child.asFolder() != null) {
                try {
                    child.asFolder().resetExclusiveCheckoutLock(depth - 1);
                }
                catch (VfsException e) {
                    caughtException = e;
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                }
            }
            ++i;
        }
        if (caughtException != null) {
            throw caughtException;
        }
    }

    public void setExclusiveCheckoutLock(int depth) throws VfsException {
        this.getVfsManager().checkState();
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Set checkout lock is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        if (this.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.SKIPPED, this, "Folder is local only");
            return;
        }
        if (this.getLocationState() == VfsFolderItemLocationState.DELETED) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.SKIPPED, this, "Folder is deleted");
            return;
        }
        if (this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.SKIPPED, this, "Folder is checked out for delete");
            return;
        }
        VfsException caughtException = null;
        if (this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT && !this.isExclusiveCheckedOut()) {
            try {
                this.setExclusiveCheckoutLock();
            }
            catch (VfsException e) {
                caughtException = e;
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
        } else {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.SKIPPED, this, "Folder is not checked out for edit or already exclusive checked out");
        }
        if (depth <= 0) {
            return;
        }
        this.refreshFolderItems();
        IVfsFolderItem[] children = this.getFolderItems();
        int i = 0;
        while (i < children.length) {
            IVfsFolderItem child = children[i];
            if (child.asFile() != null) {
                if (child.asFile().getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT && !this.isExclusiveCheckedOut()) {
                    try {
                        child.asFile().setExclusiveCheckoutLock();
                    }
                    catch (VfsException e) {
                        caughtException = e;
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                    }
                } else {
                    VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.SKIPPED, this, "File is not checked out for edit");
                }
            } else if (child.asFolder() != null) {
                try {
                    child.asFolder().setExclusiveCheckoutLock(depth - 1);
                }
                catch (VfsException e) {
                    caughtException = e;
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                }
            }
            ++i;
        }
        if (caughtException != null) {
            throw caughtException;
        }
    }

    public boolean areLocalOnlyItemsBelow(boolean countAlsoItemsCheckedOutForCreate) throws VfsException {
        return FolderUtil.getPathsOfLocalOnlyFolderItemsBelow(this, countAlsoItemsCheckedOutForCreate).length > 0;
    }

    public String[] getLocalPathsOfLocalOnlyItemsBelow(boolean includeAlsoItemsCheckedOutForCreate) throws VfsException {
        return FolderUtil.getPathsOfLocalOnlyFolderItemsBelow(this, includeAlsoItemsCheckedOutForCreate);
    }

    void adjustBindindsOfWorkingCollection(IWorkingResource workingCollection) throws VfsException {
        this.getVfsManager().getPropertiesFeature().internalSetProperty(workingCollection, VfsXcmProperty.BINDING_SET.getCompletePropertyName(), "up-to-date");
    }

    void refreshForMountPointDeletion() throws VfsException {
        super.refreshForMountPointDeletion();
        if (this.isInvalid()) {
            return;
        }
        int numberOfRemovedFolderItems = 0;
        int i = 0;
        while (i < this.m_weakFolderItems.length) {
            IVfsFolderItem folderItem = (IVfsFolderItem)this.m_weakFolderItems[i].get();
            if (VfsActivityRecordedFolderItem.shouldFolderItemBeInvalidDueToMountPointDeletion(folderItem)) {
                this.m_weakFolderItems[i] = null;
                ++numberOfRemovedFolderItems;
            }
            ++i;
        }
        if (numberOfRemovedFolderItems > 0) {
            WeakReference[] weakFolderItems = new WeakReference[this.m_weakFolderItems.length - numberOfRemovedFolderItems];
            int j = 0;
            int i2 = 0;
            while (i2 < this.m_weakFolderItems.length) {
                if (this.m_weakFolderItems[i2] != null) {
                    weakFolderItems[j] = this.m_weakFolderItems[i2];
                    ++j;
                }
                ++i2;
            }
            this.m_weakFolderItems = weakFolderItems;
            this.getVfsManager().fireEventFolderItemsAddedOrRemoved(this);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

