/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.IFile;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IWorkingResource;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyCacheControl;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICreatedResource;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.EnvironmentVariables;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItemListener2;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemCategory;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.impl.FolderItemCache;
import com.tssap.dtr.client.lib.vfs.impl.Util;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivity;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersion;
import com.tssap.dtr.client.lib.vfs.impl.VfsXcmProperty;
import com.tssap.dtr.client.lib.vfs.impl.WrongCaseOfFolderPathUtil;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncDB;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncEntry;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Date;

class VfsFile
extends VfsActivityRecordedFolderItem
implements IVfsFile {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$VfsFile == null ? (class$com$tssap$dtr$client$lib$vfs$impl$VfsFile = VfsFile.class$("com.tssap.dtr.client.lib.vfs.impl.VfsFile")) : class$com$tssap$dtr$client$lib$vfs$impl$VfsFile));
    private String m_localFileContentsMD5 = null;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$VfsFile;

    private VfsFile(IVfsWorkspace workspace, IResource resource, IVirtualFile localFile) throws VfsException {
        super(workspace, resource, localFile);
    }

    VfsFile(VfsActivity activity, ICreatedResource dvNewResource) throws VfsException {
        super(activity.getWorkspace(), VfsFolderItem.NULL_DELTAV_RESOURCE, VfsFolderItem.NULL_LOCAL_FILE);
        this.addDvNewResource(activity, dvNewResource);
        this.addActivityAndActivityState(activity, VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE);
    }

    static VfsFile pureUnsecuredGetVfsFile(IVfsWorkspace workspace, IResource dvResource, IVirtualFile localFile) throws VfsException {
        FolderItemCache folderItemCache = ((VersionedFileSystemManager)workspace.getVersionedFileSystemManager()).getFolderItemCache();
        VfsFolderItem folderItem = null;
        String absoluteLocalPath = VfsFolderItem.getAbsoluteLocalPath(localFile, dvResource, workspace.getContext(), VfsFolderItemCategory.FILE);
        if (absoluteLocalPath != null) {
            folderItem = folderItemCache.getFolderItemWithLocalPath(absoluteLocalPath);
        }
        if (folderItem != null) {
            VfsActivityRecordedFolderItem.checkAndAdaptCachedFolderItem(folderItem, dvResource, absoluteLocalPath, VfsFolderItemCategory.FILE);
        }
        if (folderItem == null) {
            boolean localRemoteNameClash = false;
            if (dvResource == VfsFolderItem.KEEP_DELTAV_RESOURCE || localFile == VfsFolderItem.KEEP_LOCAL_FILE) {
                if (dvResource == VfsFolderItem.KEEP_DELTAV_RESOURCE) {
                    dvResource = Util.createInitializedDvResource(workspace, absoluteLocalPath);
                } else if (localFile == VfsFolderItem.KEEP_LOCAL_FILE) {
                    localFile = absoluteLocalPath != null ? workspace.getContext().getFileService().constructFile(absoluteLocalPath) : VfsFolderItem.NULL_LOCAL_FILE;
                }
                localRemoteNameClash = VfsActivityRecordedFolderItem.checkLocalRemoteNameClash(workspace, localFile, dvResource);
            }
            if (localRemoteNameClash) {
                folderItem = new VfsFile(workspace, VfsFolderItem.NULL_DELTAV_RESOURCE, localFile);
                try {
                    ((VfsActivityRecordedFolderItem)folderItem).setDvLocalRemoteNameClashVcr(dvResource.getAsVersionControlled());
                }
                catch (VcmFailure vcmFailure) {
                    VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, absoluteLocalPath, "Internal error: accessing DeltaV resource failed");
                    throw new VfsException("Internal error: accessing DeltaV resource failed", vcmFailure);
                }
            } else {
                folderItem = new VfsFile(workspace, dvResource, localFile);
            }
            try {
                boolean doOverwrite = true;
                folderItemCache.addFolderItem(folderItem, doOverwrite);
            }
            catch (VfsException e) {
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, absoluteLocalPath, "Internal error");
                throw new VfsException("Internal error: Add file to cache failed", e);
            }
        }
        return (VfsFile)folderItem.asFile();
    }

    public long getLength() throws VfsException {
        this.getVfsManager().checkState();
        if (this.isMounted() && this.m_localFile.exists()) {
            return this.m_localFile.length();
        }
        try {
            if (this.m_dvVcr != null) {
                return this.m_dvVcr.getSize();
            }
            IResource resource = this.getNewestDeltaVResource();
            if (resource != null) {
                return resource.getAsFile().getSize();
            }
            return 0L;
        }
        catch (Exception e) {
            throw new VfsException("Getting length failed.", e);
        }
    }

    public String getMimeType() throws VfsException {
        this.getVfsManager().checkState();
        if (this.m_dvVcr == null) {
            throw new VfsException("Could not get MIME type (no VCR).");
        }
        try {
            return this.m_dvVcr.getContentType();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting content type failed.", vcmFailure);
        }
    }

    public void temporaryGetContent(OutputStream outputStream) throws VfsException {
        this.getVfsManager().checkState();
        if (this.m_dvVcr == null) {
            throw new VfsException("Could not get content (no VCR).");
        }
        try {
            IFile file = this.m_dvVcr.getAsFile();
            if (file == null) {
                throw new VfsException("Could not get content (not a file?)");
            }
            file.getContent(outputStream);
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting content failed.", vcmFailure);
        }
    }

    public void syncToDate(Calendar date) throws VfsException {
        this.getVfsManager().checkState();
        this.getVfsManager().getSyncRemoveFeature().syncToCalendar(this, date, true);
    }

    public void syncTo(Calendar calendar) throws VfsException {
        this.getVfsManager().checkState();
        this.syncToDate(calendar);
    }

    public void removeFromClient() throws VfsException {
        this.getVfsManager().checkState();
        this.getVfsManager().getSyncRemoveFeature().removeFromClient(this);
    }

    public VfsActionOnFolderItem[] getActionsForCurrentState() {
        this.getVfsManager().checkState();
        return this.getVfsManager().getAllowedActionsFeature().getAllowedActionsForCurrentState(this);
    }

    public String toString() {
        this.getVfsManager().checkState();
        long length = 0L;
        try {
            length = this.getLength();
        }
        catch (VfsException x) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
        }
        return super.toString() + " (" + length + ")";
    }

    boolean pureFileUpload() throws VfsException {
        boolean fileWasHandledCorrectly = false;
        try {
            if (this.getDvWorkingResource() != null && this.getDvWorkingResource().markedForDeletion()) {
                fileWasHandledCorrectly = true;
                VfsActionRecorder.log(VfsActionType.UPLOAD, VfsActionStatus.SKIPPED, this, "File cannot be uploaded, it is checked out for delete");
                return fileWasHandledCorrectly;
            }
        }
        catch (VcmFailure vcmFailure) {
            new VfsException("Could not find out if folder item was checked out for delete", vcmFailure);
            return fileWasHandledCorrectly;
        }
        if (!this.equalsLocalAndNewestRemoteFileContent()) {
            fileWasHandledCorrectly = this.pureUnconditionalFileUpload();
        } else {
            fileWasHandledCorrectly = true;
            VfsActionRecorder.log(VfsActionType.UPLOAD, VfsActionStatus.SKIPPED, this, "File was not changed since last upload/download: last change on " + new Date(this.m_localFile.lastModified()));
        }
        return fileWasHandledCorrectly;
    }

    boolean pureUnconditionalFileUpload() throws VfsException {
        SyncEntry syncEntry = null;
        try {
            syncEntry = this.getOrReconstructSyncDBEntry();
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
        return this.pureUnconditionalFileUpload(syncEntry);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean pureUnconditionalFileUpload(SyncEntry syncEntry) throws VfsException {
        boolean fileWasUploaded = false;
        InputStream inputStream = null;
        if (this.m_localFile == null) {
            throw new IllegalStateException("No mount point for checked out file: " + this.getPath());
        }
        inputStream = this.getContext().getFileService().constructFileInputStream(this.m_localFile);
        IResource dvResource = this.getDvWorkingResource();
        if (dvResource == null && (dvResource = this.getDvNewResource()) == null) {
            throw new IllegalStateException("Internal error: no DeltaV resource available");
        }
        IFile dvFile = dvResource.getAsFile();
        if (dvFile == null) {
            throw new VfsException("Get DeltaV file resource failed");
        }
        String contentType = this.computeContentType();
        try {
            dvFile.setContent(inputStream, contentType, this.m_localFile.length());
        }
        catch (VcmFailure vcmFailure) {
            VfsActionRecorder.log(VfsActionType.UPLOAD, VfsActionStatus.PENDING, this, "First trial to upload content failed");
            try {
                try {
                    inputStream.close();
                }
                catch (IOException ignoreException) {
                    LogUtil.logException((Location)LOCATION, (Throwable)ignoreException);
                }
                inputStream = this.getContext().getFileService().constructFileInputStream(this.m_localFile);
                dvFile.setContent(inputStream, contentType, this.m_localFile.length());
            }
            catch (VcmFailure vcmFailure1) {
                throw new VfsException("Upload file content on repository failed", vcmFailure1);
            }
        }
        fileWasUploaded = true;
        VfsActionRecorder.log(VfsActionType.UPLOAD, VfsActionStatus.SUCCEEDED, this, null);
        if (syncEntry != null) {
            syncEntry.setLocalUploadTime(this.m_localFile.lastModified());
        } else {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.WARN_LOG, this, "Update SyncDB entry after upload failed");
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException ignoreException) {
            LogUtil.logException((Location)LOCATION, (Throwable)ignoreException);
        }
        Object var10_15 = null;
        if (inputStream == null) return fileWasUploaded;
        try {
            inputStream.close();
            return fileWasUploaded;
        }
        catch (IOException ignoreException) {
            LogUtil.logException((Location)LOCATION, (Throwable)ignoreException);
        }
        return fileWasUploaded;
        {
            catch (IllegalStateException e) {
                VfsActionRecorder.log(VfsActionType.UPLOAD, VfsActionStatus.FAILED, this, e.getMessage());
                throw e;
            }
            catch (VfsException e) {
                VfsActionRecorder.log(VfsActionType.UPLOAD, VfsActionStatus.FAILED, this, e.getMessage());
                throw e;
            }
            catch (FileNotFoundException e) {
                VfsActionRecorder.log(VfsActionType.UPLOAD, VfsActionStatus.FAILED, this, e.getMessage());
                LogUtil.logException((Location)LOCATION, (Throwable)e);
                Object var10_16 = null;
                if (inputStream == null) return fileWasUploaded;
                try {
                    inputStream.close();
                    return fileWasUploaded;
                }
                catch (IOException ignoreException) {
                    LogUtil.logException((Location)LOCATION, (Throwable)ignoreException);
                }
                return fileWasUploaded;
            }
            catch (VcmFailure vcmFailure) {
                VfsActionRecorder.log(VfsActionType.UPLOAD, VfsActionStatus.FAILED, this, vcmFailure.getMessage());
                throw new VfsException("Accessing DeltaV file resource failed", vcmFailure);
            }
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException ignoreException) {
                LogUtil.logException((Location)LOCATION, (Throwable)ignoreException);
            }
            throw throwable;
        }
    }

    public void getContent(OutputStream outputStream) throws VfsException {
        this.getVfsManager().checkState();
        if (this.isMounted() && this.m_localFile.exists()) {
            try {
                VfsFile.copyStreams(this.getContext().getFileService().constructFileInputStream(this.m_localFile), outputStream);
            }
            catch (FileNotFoundException e) {
                throw new VfsException("Get content from local file failed", e);
            }
        }
        try {
            this.temporaryGetContent(outputStream);
            outputStream.close();
        }
        catch (IOException e) {
            throw new VfsException("Get content from temporary local file failed", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    static void copyStreams(InputStream inputStream, OutputStream outputStream) throws VfsException {
        if (inputStream == null || outputStream == null) {
            return;
        }
        try {
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) > 0) {
                void var3_4;
                outputStream.write(buffer, 0, (int)var3_4);
            }
            inputStream.close();
            outputStream.close();
        }
        catch (IOException e) {
            throw new VfsException("Copying streams failed.", e);
        }
    }

    public InputStream getContent() throws VfsException {
        this.getVfsManager().checkState();
        if (this.isMounted() && this.m_localFile.exists()) {
            try {
                return this.getContext().getFileService().constructFileInputStream(this.m_localFile);
            }
            catch (FileNotFoundException e) {
                throw new VfsException("Get content from local file failed", e);
            }
        }
        try {
            IVirtualFile tmpFile = this.getContext().getFileService().createTempFile(this.getName(), null);
            OutputStream outputStream = this.getContext().getFileService().constructFileOutputStream(tmpFile);
            this.temporaryGetContent(outputStream);
            outputStream.close();
            tmpFile.deleteOnExit();
            return this.getContext().getFileService().constructFileInputStream(tmpFile);
        }
        catch (IOException e) {
            throw new VfsException("Get content from temporary local file failed", e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void download(boolean forceDownload) throws VfsException {
        if (!this.isMounted()) {
            throw new IllegalStateException("Internal error: no local file available for " + this.getPath());
        }
        outputStream = null;
        try {
            block26: {
                dvResource /* !! */  = this.getDvWorkingResource();
                if (dvResource /* !! */  == null && (dvResource /* !! */  = this.getDvNewResource()) == null) {
                    throw new IllegalStateException("Internal error: no DeltaV resource available");
                }
                dvFile = dvResource /* !! */ .getAsFile();
                if (dvFile == null) {
                    throw new VfsException("Get DeltaV file resource failed");
                }
                if (forceDownload || !this.equalsLocalAndNewestRemoteFileContent()) break block26;
                VfsActionRecorder.log(VfsActionType.DOWNLOAD, VfsActionStatus.SKIPPED, this, "File was not changed since last up/download ( last change: " + new Date(this.m_localFile.lastModified()) + " )");
                var9_7 = null;
                if (outputStream == null) return;
                ** GOTO lbl86
            }
            parent = this.getRealParent();
            if (parent.getLocalFile() != null && !parent.getLocalFile().exists()) {
                parent.getLocalFile().mkdirs();
                VfsActionRecorder.log(VfsActionType.DOWNLOAD, VfsActionStatus.PENDING, this, "Created path up to local root for downloading file");
            }
            outputStream = this.getContext().getFileService().constructFileOutputStream(this.m_localFile);
            try {
                dvFile.getContent(outputStream);
            }
            catch (VcmFailure vcmFailure) {
                VfsActionRecorder.log(VfsActionType.DOWNLOAD, VfsActionStatus.PENDING, this, "First trial to download content failed");
                try {
                    try {
                        outputStream.close();
                    }
                    catch (IOException ignoreException) {
                        LogUtil.logException((Location)VfsFile.LOCATION, (Throwable)ignoreException);
                    }
                    outputStream = this.getContext().getFileService().constructFileOutputStream(this.m_localFile);
                    dvFile.getContent(outputStream);
                }
                catch (VcmFailure vcmFailure1) {
                    throw new VfsException("Download file content from repository failed", vcmFailure1);
                }
            }
            WrongCaseOfFolderPathUtil.rememberWrongCaseOfFolderPathAfterLocalWrite(this.getContext(), this.m_localFile);
            VfsActionRecorder.log(VfsActionType.DOWNLOAD, VfsActionStatus.SUCCEEDED, this, null);
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException ignoreException) {
                LogUtil.logException((Location)VfsFile.LOCATION, (Throwable)ignoreException);
            }
            this.updateSyncDbAfterDownload();
            this.updateLocationStateAfterDownload();
            this.getVfsManager().fireEventFolderItemContentChanged(this.getLocalPath(), IVfsFolderItemListener2.ContentChangeReasons.DOWNLOADED);
            ** GOTO lbl92
        }
        catch (IllegalStateException e) {
            VfsActionRecorder.log(VfsActionType.DOWNLOAD, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        catch (VfsException e) {
            VfsActionRecorder.log(VfsActionType.DOWNLOAD, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        catch (FileNotFoundException e) {
            VfsActionRecorder.log(VfsActionType.DOWNLOAD, VfsActionStatus.FAILED, this, e.getMessage());
            LogUtil.logException((Location)VfsFile.LOCATION, (Throwable)e);
            var9_9 = null;
            if (outputStream == null) return;
            try {
                outputStream.close();
                return;
            }
            catch (IOException ignoreException) {
                LogUtil.logException((Location)VfsFile.LOCATION, (Throwable)ignoreException);
                return;
            }
        }
        catch (VcmFailure vcmFailure) {
            VfsActionRecorder.log(VfsActionType.DOWNLOAD, VfsActionStatus.FAILED, this, "Downloading remote content failed");
            throw new VfsException("Accessing DeltaV file resource failed", vcmFailure);
        }
        {
            catch (Throwable var8_22) {
                var9_10 = null;
                if (outputStream == null) throw var8_22;
                ** try [egrp 6[TRYBLOCK] [9 : 496->503)] { 
lbl81:
                // 1 sources

                outputStream.close();
                throw var8_22;
lbl83:
                // 1 sources

                catch (IOException ignoreException) {
                    LogUtil.logException((Location)VfsFile.LOCATION, (Throwable)ignoreException);
                }
                throw var8_22;
            }
lbl86:
            // 1 sources

            ** try [egrp 6[TRYBLOCK] [9 : 496->503)] { 
lbl87:
            // 1 sources

            outputStream.close();
            return;
lbl89:
            // 1 sources

            catch (IOException ignoreException) {
                LogUtil.logException((Location)VfsFile.LOCATION, (Throwable)ignoreException);
            }
            return;
lbl92:
            // 1 sources

            var9_8 = null;
            if (outputStream == null) return;
            try {}
            catch (IOException ignoreException) {}
            LogUtil.logException((Location)VfsFile.LOCATION, (Throwable)ignoreException);
            return;
            outputStream.close();
            return;
        }
    }

    private void updateSyncDbAfterDownload() {
        SyncEntry syncEntry;
        SyncDB syncDB = this.getSyncDB();
        SyncEntry syncEntry2 = syncEntry = syncDB == null ? null : syncDB.getEntry(this.getLocalPath());
        if (syncDB != null && syncEntry == null) {
            try {
                syncEntry = this.reconstructSyncDBEntry(syncDB);
            }
            catch (VfsException e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                return;
            }
        }
        if (syncEntry != null) {
            syncEntry.setLocalUploadTime(this.getLocalFile().lastModified());
        }
    }

    private void updateLocationStateAfterDownload() throws VfsException {
        if (this.getLocationState() == VfsFolderItemLocationState.SERVER_ONLY) {
            this.refreshLocationState();
        }
    }

    public void syncForce() throws VfsException {
        this.getVfsManager().checkState();
        this.getVfsManager().getSyncRemoveFeature().sync(this, true, false, true);
    }

    public void syncPreview() throws VfsException {
        this.getVfsManager().checkState();
        this.getVfsManager().getSyncRemoveFeature().sync(this, false, true, false);
    }

    public void sync() throws VfsException {
        this.getVfsManager().checkState();
        this.getVfsManager().getSyncRemoveFeature().sync(this, false, false, true);
    }

    public void syncToBranchSequenceNumber(String branchSequenceNumber) throws VfsException {
        this.getVfsManager().checkState();
        int bsn = Integer.parseInt(branchSequenceNumber);
        this.syncToBranchSequenceNumber(bsn);
    }

    public void syncToBranchSequenceNumber(int branchSequenceNumber) throws VfsException {
        this.getVfsManager().checkState();
        this.getVfsManager().getSyncRemoveFeature().syncToBranchSequenceNumber(this, branchSequenceNumber);
    }

    void refreshTimestampOnSyncedFile() throws VfsException {
        try {
            VfsFile.refreshTimestampOnSyncedFile(this.getLocalFile(), this.getVcrResource().lastModified());
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting lastModified from DeltaV resource failed", vcmFailure);
        }
    }

    static void refreshTimestampOnSyncedFile(IVirtualFile localFile, Date lastModified) {
        if (!EnvironmentVariables.USE_LOCAL_TIMESTAMP_FOR_SYNC) {
            localFile.setLastModified(lastModified.getTime());
        }
    }

    public boolean wasManuallySetWritable() {
        if (this.isMounted() && this.getLocationState() != VfsFolderItemLocationState.DELETED && this.getLocationState() != VfsFolderItemLocationState.LOCAL_ONLY && this.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT && this.getLocalFile().canWrite()) {
            this.getSyncDB().getSyncDbMget().setLastRemoteSyncTime(this.getLocalPath(), -1L);
            return true;
        }
        return false;
    }

    private String getLocalFileContentsMD5() {
        return this.m_localFileContentsMD5;
    }

    private String refreshLocalFileContentsMD5() {
        InputStream inputStream;
        if (!this.isMounted() || !this.getLocalFile().exists() || this.getLocalFile().isDirectory()) {
            return null;
        }
        try {
            inputStream = this.getContext().getFileService().constructFileInputStream(this.getLocalFile());
        }
        catch (FileNotFoundException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return null;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return null;
        }
        DigestInputStream digestInputStream = new DigestInputStream(inputStream, messageDigest);
        int readLength = 4096;
        byte[] buffer = new byte[readLength];
        try {
            while (digestInputStream.read(buffer) != -1) {
            }
            digestInputStream.close();
        }
        catch (IOException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return null;
        }
        this.m_localFileContentsMD5 = Encoder.toHexString((byte[])digestInputStream.getMessageDigest().digest());
        LOCATION.debugT("Computed MD5 sum ( " + this.m_localFileContentsMD5 + " ) of local file content for resource: " + this.getIdentifyingString());
        return this.m_localFileContentsMD5;
    }

    private boolean equalsLocalAndRemoteFileContentsMD5() throws VfsException {
        if (!this.isMounted() || !this.getLocalFile().exists() || this.getLocalFile().isDirectory()) {
            throw new VfsException("MD5 for local file cannot be computed because there is no local file for " + this.getBrowsePath());
        }
        if (this.getLocalFileContentsMD5() == null) {
            this.refreshLocalFileContentsMD5();
        }
        String remoteMD5 = this.getProperty(VfsXcmProperty.CONTENT_MD5.getCompletePropertyName()).getValue();
        return this.getLocalFileContentsMD5().equals(remoteMD5);
    }

    private boolean equalsLocalAndRemoteFileContentsMD5(IResource dvResource) throws VfsException {
        IProperty dvProperty;
        String remoteMD5;
        block5: {
            if (!this.isMounted() || !this.getLocalFile().exists() || this.getLocalFile().isDirectory()) {
                throw new VfsException("MD5 for local file cannot be computed because there is no local file for " + this.getBrowsePath());
            }
            if (this.getLocalFileContentsMD5() == null) {
                this.refreshLocalFileContentsMD5();
            }
            remoteMD5 = null;
            dvProperty = null;
            try {
                dvProperty = dvResource.getProperty(VfsXcmProperty.CONTENT_MD5.getCompletePropertyName());
            }
            catch (VcmFailure vcmFailure) {
                if (vcmFailure.getStatusCode() == 404) break block5;
                throw new VfsException("Getting MD5 of DeltaV resource failed: " + this.getIdentifyingString(), vcmFailure);
            }
        }
        if (dvProperty != null) {
            remoteMD5 = dvProperty.getValue();
        }
        return this.getLocalFileContentsMD5().equals(remoteMD5);
    }

    private boolean equalsLocalAndRemoteFileContent(IResource dvResource) throws VfsException {
        boolean isEqual = false;
        IPropertyCacheControl propCacheControl = dvResource.getPropertyCacheControl();
        if (dvResource instanceof IWorkingResource) {
            propCacheControl.resetAllProperties();
        }
        propCacheControl.addPropertyToCache(VfsXcmProperty.CONTENT_MD5.getCompletePropertyName());
        propCacheControl.addPropertyToCache(DAV.GETCONTENTLENGTH.qualifiedName);
        try {
            long size = dvResource.getAsFile().getSize();
            if (size == -1L) {
                throw new VfsException("Internal error: got -1 for size of version ( " + dvResource.getName() + " ) of resource: " + this.getIdentifyingString());
            }
            if (this.getLocalFile().length() == dvResource.getAsFile().getSize()) {
                this.refreshLocalFileContentsMD5();
                isEqual = this.equalsLocalAndRemoteFileContentsMD5(dvResource);
            }
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Refreshing properties of file from repository failed ( " + vcmFailure.getMessage() + " ): " + this.getBrowsePath(), vcmFailure);
        }
        if (dvResource instanceof IWorkingResource) {
            propCacheControl.clearProperty(VfsXcmProperty.CONTENT_MD5.getCompletePropertyName());
        }
        return isEqual;
    }

    boolean equalsLocalAndNewestRemoteFileContent() throws VfsException {
        return this.equalsLocalAndRemoteFileContent(this.getNewestDeltaVResource());
    }

    boolean equalsLocalAndOriginalRemoteFileContent() throws VfsException {
        if (this.getSyncedVersion() == null) {
            return false;
        }
        return this.equalsLocalAndRemoteFileContent(((VfsVersion)this.getSyncedVersion()).getDvVersion());
    }

    void resyncCheckedOutVersion() throws VfsException {
        if (this.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY || this.getLocationState() == VfsFolderItemLocationState.NOT_MOUNTED) {
            return;
        }
        if (this.getSyncedVersion() == null) {
            this.refreshAndGetVersion();
            if (this.getSyncedVersion() == null) {
                if (this.getLocationState() == VfsFolderItemLocationState.SERVER_ONLY) {
                    return;
                }
                throw new VfsException("Internal error: Get original version of unchecked out file failed");
            }
        }
        this.getVfsManager().getSyncRemoveFeature().pureSyncVersion(this.m_localFile, ((VfsVersion)this.getSyncedVersion()).getDvVersion(), this.getContext(), this.getVfsManager());
    }

    void removeCheckedOutVersionFromClient() throws VfsException {
        if (this.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_LATEST || this.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_FORMER) {
            this.getVfsManager().getSyncRemoveFeature().pureRemoveFileFromClient(this);
        }
    }

    public boolean hasIntegrateConflict() {
        if (this.m_dvVcr == null) {
            return false;
        }
        IProperty collisionSetProperty = null;
        try {
            this.m_dvVcr.refresh();
            collisionSetProperty = this.m_dvVcr.getProperty(XCM.COLLISION_SET.qualifiedName);
        }
        catch (VcmFailure e) {
            LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)e, (int)500);
            return false;
        }
        return collisionSetProperty != null && collisionSetProperty.getChildCount() > 0;
    }

    /*
     * Loose catch block
     */
    String computeContentType() {
        String contentType;
        block13: {
            contentType = URLConnection.getFileNameMap().getContentTypeFor(this.m_localFile.getName());
            if (contentType == null && this.m_localFile.exists()) {
                BufferedInputStream bi = null;
                bi = new BufferedInputStream(this.getContext().getFileService().constructFileInputStream(this.m_localFile));
                contentType = URLConnection.guessContentTypeFromStream(bi);
                Object var5_3 = null;
                try {
                    if (bi != null) {
                        bi.close();
                    }
                    break block13;
                }
                catch (IOException e2) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e2);
                }
                break block13;
                {
                    catch (IOException e) {
                        new VfsException("Get Mime type failed", e);
                        Object var5_4 = null;
                        try {
                            if (bi != null) {
                                bi.close();
                            }
                            break block13;
                        }
                        catch (IOException e2) {
                            LogUtil.logException((Location)LOCATION, (Throwable)e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    try {
                        if (bi != null) {
                            bi.close();
                        }
                    }
                    catch (IOException e2) {
                        LogUtil.logException((Location)LOCATION, (Throwable)e2);
                    }
                    throw throwable;
                }
            }
        }
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        return contentType;
    }

    void refreshForMountPointDeletion() throws VfsException {
        super.refreshForMountPointDeletion();
        if (this.isInvalid()) {
            return;
        }
        this.m_localFileContentsMD5 = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

