/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.tssap.dtr.client.lib.exceptions.ExceptionSeverity;
import com.tssap.dtr.client.lib.vfs.IVfsBasicProgressMonitor;
import com.tssap.dtr.client.lib.vfs.IVfsBatchedEventRunnable;
import com.tssap.dtr.client.lib.vfs.IVfsEventManager;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsExceptionCategory;
import com.tssap.dtr.client.lib.vfs.VfsRuntimeException;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import java.lang.reflect.InvocationTargetException;

class VfsEventManager
implements IVfsEventManager {
    private VersionedFileSystemManager m_vfsManager = null;
    private int m_eventBracketNumber = 0;

    VfsEventManager(VersionedFileSystemManager vfsManager) {
        this.m_vfsManager = vfsManager;
    }

    VersionedFileSystemManager getVfsManager() {
        return this.m_vfsManager;
    }

    private void addEventBracket() {
        VfsEventManager vfsEventManager = this;
        synchronized (vfsEventManager) {
            ++this.m_eventBracketNumber;
        }
        if (this.m_eventBracketNumber == 1) {
            this.getVfsManager().getListenerHandler().startVfsInternalDelayedListening();
        }
    }

    private void removeEventBracket() {
        VfsEventManager vfsEventManager = this;
        synchronized (vfsEventManager) {
            --this.m_eventBracketNumber;
        }
        if (!this.isEventNoficationBlockedByBrackets()) {
            this.getVfsManager().getListenerHandler().stopVfsInternalDelayedListening();
        }
    }

    private void cleanUpEventHandling() {
        throw new UnsupportedOperationException();
    }

    boolean isEventNoficationBlockedByBrackets() {
        return this.m_eventBracketNumber > 0;
    }

    public void run(IVfsBatchedEventRunnable vfsRunnable, IVfsBasicProgressMonitor vfsProgressMonitor) throws VfsException {
        this.addEventBracket();
        VfsException exception = null;
        try {
            try {
                vfsRunnable.run(vfsProgressMonitor);
            }
            catch (InvocationTargetException e) {
                exception = new VfsException(ExceptionSeverity.INFO, VfsExceptionCategory.OPERATION_ABORTED_BY_EXCEPTION, new Object[]{e.getMessage()}, new Throwable[]{e});
                throw exception;
            }
            catch (VfsRuntimeException e) {
                exception = new VfsException(ExceptionSeverity.INFO, VfsExceptionCategory.OPERATION_ABORTED_BY_EXCEPTION, new Object[]{e.getMessage()}, new Throwable[]{e});
                throw exception;
            }
            Object var7_4 = null;
            this.removeEventBracket();
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this.removeEventBracket();
            throw throwable;
        }
    }
}

