/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICollision;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsCheckinCollision;
import com.tssap.dtr.client.lib.vfs.IVfsCollision;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.VfsCollisionCategory;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersion;

abstract class VfsCollision
implements IVfsCollision {
    private VersionedFileSystemManager m_vfsManager = null;
    private ICollision m_dvCollision = null;
    private IVfsVersion m_CommonAncestor = null;
    private IVfsVersion m_ValideSrcVer = null;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$VfsCollision == null ? (class$com$tssap$dtr$client$lib$vfs$impl$VfsCollision = VfsCollision.class$("com.tssap.dtr.client.lib.vfs.impl.VfsCollision")) : class$com$tssap$dtr$client$lib$vfs$impl$VfsCollision));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$VfsCollision;

    VfsCollision(VersionedFileSystemManager vfsManager, ICollision dvCollision) {
        this.m_vfsManager = vfsManager;
        this.m_dvCollision = dvCollision;
    }

    VfsCollision(VersionedFileSystemManager vfsManager, IVfsFolderItem collidingVersionFI) {
        this.m_vfsManager = vfsManager;
        try {
            this.m_CommonAncestor = collidingVersionFI.asActivityRecordedFolderItem().refreshAndGetVersion();
        }
        catch (VfsException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
        try {
            this.m_ValideSrcVer = new VfsVersion(this.getVersionedFileSystemManager(), ((VfsFolderItem)collidingVersionFI).getVcrResource().getAsVersionControlled().getActiveVersion());
        }
        catch (VcmFailure e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
    }

    public IVfsVersion getValidSourceVersion() {
        this.getVersionedFileSystemManager().checkState();
        if (null == this.m_ValideSrcVer) {
            this.m_ValideSrcVer = new VfsVersion(this.getVersionedFileSystemManager(), this.m_dvCollision.getWorkspaceVersion());
        }
        return this.m_ValideSrcVer;
    }

    public IVfsVersion getCommonAncestor() {
        this.getVersionedFileSystemManager().checkState();
        if (null == this.m_CommonAncestor) {
            this.m_CommonAncestor = new VfsVersion(this.getVersionedFileSystemManager(), this.m_dvCollision.getOriginalVersion());
        }
        return this.m_CommonAncestor;
    }

    public IVfsCheckinCollision getAsCheckinCollision() {
        this.getVersionedFileSystemManager().checkState();
        if (this instanceof IVfsCheckinCollision) {
            return (IVfsCheckinCollision)((Object)this);
        }
        return null;
    }

    public IVfsIntegrateCollision getAsIntegrateCollision() {
        this.getVersionedFileSystemManager().checkState();
        if (this instanceof IVfsIntegrateCollision) {
            return (IVfsIntegrateCollision)((Object)this);
        }
        return null;
    }

    VersionedFileSystemManager getVersionedFileSystemManager() {
        if (this.m_vfsManager == null || this.m_vfsManager.isReleased()) {
            throw new IllegalStateException("Versioned file system manager was released");
        }
        return this.m_vfsManager;
    }

    public abstract VfsCollisionCategory getCollisionCategory();

    public abstract IVfsVersion getCollidingVersion();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

