/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.IVersion;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.IWorkingResource;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICheckinCollision;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsCheckinCollision;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsCollisionCategory;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsCollision;
import com.tssap.dtr.client.lib.vfs.impl.VfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersion;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspace;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncDB;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncEntry;

public class VfsCheckinCollision
extends VfsCollision
implements IVfsCheckinCollision {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$VfsCheckinCollision == null ? (class$com$tssap$dtr$client$lib$vfs$impl$VfsCheckinCollision = VfsCheckinCollision.class$("com.tssap.dtr.client.lib.vfs.impl.VfsCheckinCollision")) : class$com$tssap$dtr$client$lib$vfs$impl$VfsCheckinCollision));
    private ICheckinCollision m_dvCheckinCollision;
    private IVfsActivityRecordedFolderItem m_collidingVersionFI;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$VfsCheckinCollision;

    VfsCheckinCollision(VersionedFileSystemManager vfsManager, ICheckinCollision dvCollision) {
        super(vfsManager, dvCollision);
        this.m_dvCheckinCollision = dvCollision;
        this.m_collidingVersionFI = null;
    }

    VfsCheckinCollision(VersionedFileSystemManager vfsManager, IVfsFolderItem collidingVersionFI) {
        super(vfsManager, collidingVersionFI);
        this.m_collidingVersionFI = collidingVersionFI.asActivityRecordedFolderItem();
    }

    public IVfsVersion getCollidingVersion() {
        this.getVersionedFileSystemManager().checkState();
        return null;
    }

    public VfsCollisionCategory getCollisionCategory() {
        this.getVersionedFileSystemManager().checkState();
        return VfsCollisionCategory.CHECKIN_COLLISION;
    }

    public void acceptCollidingVersion() throws VfsException {
        IVersion[] existingPredecessors;
        VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)this.getFolderItemForCollidingVersion().asActivityRecordedFolderItem();
        this.getVersionedFileSystemManager().checkState();
        try {
            ((VfsWorkspace)this.m_collidingVersionFI.getWorkspace()).checkIsModifiable();
        }
        catch (VfsException e) {
            VfsException ex = new VfsException("Changes are not allowed because workspace is not modifiable", e);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, ex.getMessage());
            throw ex;
        }
        IWorkingResource dvWorkingResource = folderItem.getDvWorkingResource();
        try {
            existingPredecessors = dvWorkingResource.getPredecessorSet();
        }
        catch (VcmFailure e) {
            throw new VfsException(e.getMessage());
        }
        VfsVersion activeVersionOfCollision = (VfsVersion)this.getValidSourceVersion();
        IVfsWorkspace workspaceContainingCollision = folderItem.getWorkspace();
        boolean addAdditionalPredecessor = false;
        IVfsVersion versionWithMaxSeqNumber = null;
        if (!activeVersionOfCollision.getCreatorWorkspaceName().equalsIgnoreCase(workspaceContainingCollision.getAbsoluteRemotePath()) && (versionWithMaxSeqNumber = activeVersionOfCollision.getVersionHistory().getClosedVersionWithMaxSequenceNumber(workspaceContainingCollision)) != null) {
            boolean predecessorFound = false;
            int i = 0;
            while (i < existingPredecessors.length) {
                try {
                    if (existingPredecessors[i].getVersionId().equalsIgnoreCase(versionWithMaxSeqNumber.getVersionId())) {
                        predecessorFound = true;
                        break;
                    }
                }
                catch (VcmFailure e1) {
                    throw new VfsException("Unable to get VersionId of predecessor : " + e1.getMessage());
                }
                ++i;
            }
            addAdditionalPredecessor = !predecessorFound;
        }
        int numberOfPredecessors = addAdditionalPredecessor ? existingPredecessors.length + 2 : existingPredecessors.length + 1;
        IVersion[] dvPredecessorVersions = new IVersion[numberOfPredecessors];
        int i = 0;
        while (i < existingPredecessors.length) {
            dvPredecessorVersions[i] = existingPredecessors[i];
            ++i;
        }
        dvPredecessorVersions[existingPredecessors.length] = activeVersionOfCollision.getDvVersion();
        if (addAdditionalPredecessor) {
            dvPredecessorVersions[existingPredecessors.length + 1] = ((VfsVersion)versionWithMaxSeqNumber).getDvVersion();
        }
        try {
            dvWorkingResource.setPredecessorSet(dvPredecessorVersions);
        }
        catch (VcmFailure e) {
            throw new VfsException(e.getMessage());
        }
        folderItem.setSyncedVersion(activeVersionOfCollision);
        SyncDB syncDb = folderItem.getWorkspace().getContext().getSyncDb(folderItem.getLocalPath());
        SyncEntry syncEntry = syncDb.getEntry(folderItem.getLocalPath());
        try {
            long remoteSyncTime;
            folderItem.getVcrResource().refresh();
            IVersion refreshedActiveVersionOfVcr = folderItem.getVcrResource().getAsVersionControlled().getActiveVersion();
            if (refreshedActiveVersionOfVcr.getVersionId().equals(activeVersionOfCollision.getVersionId())) {
                remoteSyncTime = folderItem.getVcrResource().lastModified().getTime();
                folderItem.setLocationState(VfsFolderItemLocationState.SYNCED_TO_LATEST);
            } else {
                remoteSyncTime = activeVersionOfCollision.getLastModifiedDate().getTime();
                folderItem.setLocationState(VfsFolderItemLocationState.SYNCED_TO_FORMER);
                Logbook.getInfoChapter().println("There is a new conflict caused by a foreign check-in.");
            }
            syncEntry.setVersionUrlAndRemoteSyncTime(activeVersionOfCollision.getUrl(), remoteSyncTime);
        }
        catch (VcmFailure e) {
            throw new VfsException(e.getMessage());
        }
        this.getVersionedFileSystemManager().fireEventLocalVersionAccepted(this.m_collidingVersionFI, this);
    }

    public IVfsFolderItem getFolderItemForCollidingVersion() {
        this.getVersionedFileSystemManager().checkState();
        if (this.m_collidingVersionFI == null) {
            IVfsContext context = this.getVersionedFileSystemManager().getCurrentContext();
            try {
                IVersionControlledResource dv_vcr = this.m_dvCheckinCollision.getVCR();
                VfsRemoteLocator remoteLocator = new VfsRemoteLocator(dv_vcr.getConnectionTemplID(), dv_vcr.getDecodedPath(), dv_vcr.getCanonicalPath());
                String browsePath = context.getBrowsePath(remoteLocator);
                IVfsFolderItem folderItem = this.getVersionedFileSystemManager().getFolderItemByBrowsePath(browsePath);
                this.m_collidingVersionFI = folderItem.asActivityRecordedFolderItem();
            }
            catch (VcmFailure e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
            catch (VfsException e1) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e1);
            }
        }
        return this.m_collidingVersionFI;
    }

    public void uncheckoutCollidingVersion() throws VfsException {
        this.getVersionedFileSystemManager().checkState();
        if (this.getFolderItemForCollidingVersion() != null) {
            try {
                ((VfsWorkspace)this.m_collidingVersionFI.getWorkspace()).checkIsModifiable();
            }
            catch (VfsException e) {
                VfsException ex = new VfsException("Changes are not allowed because workspace is not modifiable", e);
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, ex.getMessage());
                throw ex;
            }
            this.m_collidingVersionFI.uncheckout();
            this.getVersionedFileSystemManager().fireEventActiveVersionAccepted(this.m_collidingVersionFI, this);
        }
    }

    public IVfsVersion getCommonAncestor() {
        this.getVersionedFileSystemManager().checkState();
        IVfsFolderItem folderItem = this.getFolderItemForCollidingVersion();
        if (folderItem != null) {
            try {
                return this.m_collidingVersionFI.refreshAndGetVersion();
            }
            catch (VfsException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
        return null;
    }

    public void acceptActiveVersion() throws VfsException {
        this.uncheckoutCollidingVersion();
        this.getFolderItemForCollidingVersion().sync();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

