/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.MultiMap;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsAmbiguousFolder;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.IVfsRootFolder;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspaceFolder;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemCategory;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.impl.FolderItemCache;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolder;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolderItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class VfsAmbiguousFolder
extends VfsFolderItem
implements IVfsAmbiguousFolder {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$VfsAmbiguousFolder == null ? (class$com$tssap$dtr$client$lib$vfs$impl$VfsAmbiguousFolder = VfsAmbiguousFolder.class$("com.tssap.dtr.client.lib.vfs.impl.VfsAmbiguousFolder")) : class$com$tssap$dtr$client$lib$vfs$impl$VfsAmbiguousFolder));
    VersionedFileSystemManager m_vfsManager = null;
    IVfsFolderItem[] m_folderItems = IVfsFolderItem.NO_ITEMS;
    IVfsGenericFolder[] m_unambiguousFolders;
    boolean m_isRefreshedOnce = false;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$VfsAmbiguousFolder;

    static IVfsFolderItem[] compactAmbiguousFolders(IVfsFolderItem[] folderItems) throws VfsException {
        if (folderItems.length == 0) {
            throw new VfsException("Internal error: no unambiguous folders");
        }
        VersionedFileSystemManager vfsManager = (VersionedFileSystemManager)folderItems[0].getVersionedFileSystemManager();
        ArrayList<IVfsFolderItem> unambiguousFiles = new ArrayList<IVfsFolderItem>();
        MultiMap bindingNames = new MultiMap();
        int i = 0;
        while (i < folderItems.length) {
            IVfsGenericFolder folder = folderItems[i].asGenericFolder();
            if (folder != null) {
                bindingNames.put(folder.getName(), folder);
            } else {
                unambiguousFiles.add(folderItems[i]);
            }
            ++i;
        }
        IVfsFolderItem[] compacted = new IVfsFolderItem[folderItems.length];
        int count = 0;
        Iterator keys = bindingNames.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Collection values = bindingNames.getAll(key);
            if (values.size() > 1) {
                IVfsGenericFolder[] items = new IVfsGenericFolder[values.size()];
                values.toArray(items);
                compacted[count++] = new VfsAmbiguousFolder(vfsManager, items);
                continue;
            }
            compacted[count++] = (IVfsFolderItem)values.iterator().next();
        }
        int i2 = 0;
        while (i2 < unambiguousFiles.size()) {
            IVfsFolderItem folderItem = (IVfsFolderItem)unambiguousFiles.get(i2);
            compacted[count++] = folderItem;
            ++i2;
        }
        folderItems = new IVfsFolderItem[count];
        System.arraycopy(compacted, 0, folderItems, 0, count);
        return folderItems;
    }

    VfsAmbiguousFolder(VersionedFileSystemManager vfsManager, IVfsGenericFolder[] unambiguousFolders) {
        super(unambiguousFolders.length > 0 ? ((VfsFolderItem)((Object)unambiguousFolders[0])).m_dvVcr : null, null);
        throw new UnsupportedOperationException("Ambiguous folders are not yet supported");
    }

    static VfsAmbiguousFolder not_finished_yet_getVfsAmbiguousFolder(IVfsGenericFolder[] unambiguousFolders) throws VfsException {
        if (unambiguousFolders.length == 0) {
            throw new VfsException("Internal error: no unambiguous folders");
        }
        VersionedFileSystemManager vfsManager = (VersionedFileSystemManager)unambiguousFolders[0].getVersionedFileSystemManager();
        FolderItemCache folderItemCache = vfsManager.getFolderItemCache();
        if (unambiguousFolders.length == 0) {
            throw new VfsException("Internal error: creation of ambiguous folder item failed");
        }
        String absoluteLocalPath = null;
        int i = 0;
        while (i < unambiguousFolders.length) {
            IVfsGenericFolder unambiguousFolder = unambiguousFolders[i];
            if (unambiguousFolder.getLocalFile() != null) {
                absoluteLocalPath = unambiguousFolder.getLocalFile().getAbsolutePath();
                break;
            }
            ++i;
        }
        VfsFolderItem folderItem = null;
        VfsAmbiguousFolder ambiguousFolder = null;
        if (absoluteLocalPath != null) {
            folderItem = folderItemCache.getFolderItemWithLocalPath(absoluteLocalPath);
            if (folderItem != null) {
                ambiguousFolder = (VfsAmbiguousFolder)folderItem.asAmbiguousFolder();
            }
        } else {
            int i2 = 0;
            while (i2 < unambiguousFolders.length) {
                VfsFolderItem unambiguousFolderItem = (VfsFolderItem)((Object)unambiguousFolders[i2]);
                VfsFolderItem[] folderItems = folderItemCache.getFolderItemsWithBrowsePath(unambiguousFolderItem.getRemoteLocator());
                int j = 0;
                while (j < folderItems.length) {
                    ambiguousFolder = (VfsAmbiguousFolder)folderItems[j].asAmbiguousFolder();
                    ++j;
                }
                ++i2;
            }
        }
        VfsAmbiguousFolder newFolderItem = new VfsAmbiguousFolder(vfsManager, unambiguousFolders);
        try {
            boolean doOverwrite = true;
            folderItemCache.addFolderItem(newFolderItem, doOverwrite);
        }
        catch (VfsException e) {
            throw new VfsException("Internal error: Add ambiguous folder item to cache failed", e);
        }
        return newFolderItem;
    }

    public IVfsContext getContext() {
        this.getVfsManager().checkState();
        return this.m_unambiguousFolders[0].getContext();
    }

    IVfsWorkspace getWorkspace() {
        return ((VfsFolderItem)((Object)this.m_unambiguousFolders[0])).getWorkspace();
    }

    int getConnectionTemplateId() {
        throw new IllegalStateException("Internal error: No unambiguous connection template id available");
    }

    public String getName() {
        this.getVfsManager().checkState();
        if (this.m_unambiguousFolders.length > 0) {
            return this.m_unambiguousFolders[0].getName();
        }
        return "? (ambiguous folder with no unambiguous folders!)";
    }

    public VfsActionOnFolderItem[] getActionsForCurrentState() {
        this.getVfsManager().checkState();
        return this.getVfsManager().getAllowedActionsFeature().getAllowedActionsForCurrentState(this);
    }

    public IVfsWorkspace[] getWorkspaces() {
        this.getVfsManager().checkState();
        ArrayList<IVfsWorkspace> unambiguousFolders = new ArrayList<IVfsWorkspace>();
        int i = 0;
        while (i < this.m_unambiguousFolders.length) {
            IVfsFolder folder = this.m_unambiguousFolders[i].asFolder();
            if (folder != null) {
                unambiguousFolders.add(folder.getWorkspace());
            }
            ++i;
        }
        IVfsWorkspace[] workspaces = new IVfsWorkspace[unambiguousFolders.size()];
        unambiguousFolders.toArray(workspaces);
        return workspaces;
    }

    public IVfsFolder getFolderForWorkspace(IVfsWorkspace workspace) {
        this.getVfsManager().checkState();
        this.checkParameterState(workspace);
        int i = 0;
        while (i < this.m_unambiguousFolders.length) {
            IVfsFolder folder = this.m_unambiguousFolders[i].asFolder();
            if (folder != null && folder.getWorkspace() == workspace) {
                return folder;
            }
            ++i;
        }
        return null;
    }

    public IVfsFolder createSubfolderForWorkspace(String name, IVfsWorkspace workspace) {
        this.getVfsManager().checkState();
        this.checkParameterState(workspace);
        return null;
    }

    public int getItemCount() {
        this.getVfsManager().checkState();
        return this.m_folderItems.length;
    }

    public IVfsFolderItem[] refreshFolderItems() throws VfsException {
        this.getVfsManager().checkState();
        ArrayList<IVfsFolderItem> allItems = new ArrayList<IVfsFolderItem>();
        int i = 0;
        while (i < this.m_unambiguousFolders.length) {
            IVfsGenericFolder unambiguousFolder = this.m_unambiguousFolders[i].asGenericFolder();
            unambiguousFolder.refreshFolderItems();
            IVfsFolderItem[] folderItems = unambiguousFolder.getFolderItems();
            List<IVfsFolderItem> asCollection = Arrays.asList(folderItems);
            allItems.addAll(asCollection);
            ++i;
        }
        IVfsFolderItem[] folderItems = new IVfsFolderItem[allItems.size()];
        allItems.toArray(folderItems);
        HashSet<IVfsFolderItem> oldFolderItems = new HashSet<IVfsFolderItem>(Arrays.asList(this.m_folderItems));
        this.m_folderItems = VfsAmbiguousFolder.compactAmbiguousFolders(folderItems);
        this.m_isRefreshedOnce = true;
        int i2 = 0;
        while (i2 < this.m_folderItems.length) {
            IVfsFolderItem folderItem = this.m_folderItems[i2];
            if (!oldFolderItems.remove(folderItem)) {
                this.getVfsManager().fireEventFolderItemsAddedOrRemoved(this);
                return this.m_folderItems;
            }
            ++i2;
        }
        if (!oldFolderItems.isEmpty()) {
            this.getVfsManager().fireEventFolderItemsAddedOrRemoved(this);
        }
        return this.m_folderItems;
    }

    public IVfsFolderItem[] getFolderItems() {
        this.getVfsManager().checkState();
        if (!this.m_isRefreshedOnce) {
            try {
                this.refreshFolderItems();
            }
            catch (VfsException x) {
                LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)x, (int)500);
            }
        }
        return this.m_folderItems;
    }

    public VfsFolderItemCategory getCategory() {
        this.getVfsManager().checkState();
        if (this.m_unambiguousFolders.length == 0) {
            return VfsFolderItemCategory.UNKNOWN;
        }
        IVfsGenericFolder folder = this.m_unambiguousFolders[0].asGenericFolder();
        if (folder instanceof IVfsFolder) {
            return VfsFolderItemCategory.AMBIGUOUS_FOLDER;
        }
        if (folder instanceof IVfsWorkspace) {
            return VfsFolderItemCategory.AMBIGUOUS_WORKSPACE;
        }
        if (folder instanceof IVfsWorkspaceFolder) {
            return VfsFolderItemCategory.AMBIGUOUS_WORKSPACE_FOLDER;
        }
        if (folder instanceof IVfsRootFolder) {
            return VfsFolderItemCategory.AMBIGUOUS_ROOT;
        }
        return VfsFolderItemCategory.UNKNOWN;
    }

    public VfsFolderItemLocationState getLocationState() {
        this.getVfsManager().checkState();
        int deletedCount = 0;
        int i = 0;
        while (i < this.m_unambiguousFolders.length) {
            IVfsGenericFolder unambiguousFolder = this.m_unambiguousFolders[i];
            if (unambiguousFolder.getLocationState() == VfsFolderItemLocationState.DELETED) {
                ++deletedCount;
            } else if (unambiguousFolder.getLocationState() != VfsFolderItemLocationState.NOT_MOUNTED) {
                this.setLocationState(VfsFolderItemLocationState.PARTLY_MOUNTED);
                return this.m_locationState;
            }
            ++i;
        }
        if (deletedCount == this.m_unambiguousFolders.length) {
            this.setLocationState(VfsFolderItemLocationState.DELETED);
        } else {
            this.setLocationState(VfsFolderItemLocationState.NOT_MOUNTED);
        }
        return this.m_locationState;
    }

    public void sync() throws VfsException {
        this.getVfsManager().checkState();
        int i = 0;
        while (i < this.m_unambiguousFolders.length) {
            IVfsGenericFolder unambiguousFolder = this.m_unambiguousFolders[i];
            unambiguousFolder.sync();
            ++i;
        }
        this.setLocationState(VfsFolderItemLocationState.SYNCED_TO_LATEST);
    }

    public void removeFromClient() {
        this.getVfsManager().checkState();
        boolean allUnambiguousFoldersRemoved = true;
        int i = 0;
        while (i < this.m_unambiguousFolders.length) {
            IVfsGenericFolder unambiguousFolder = this.m_unambiguousFolders[i];
            try {
                unambiguousFolder.removeFromClient();
            }
            catch (VfsException e) {
                allUnambiguousFoldersRemoved = false;
                LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)e, (int)500);
            }
            ++i;
        }
        if (allUnambiguousFoldersRemoved) {
            this.setLocationState(VfsFolderItemLocationState.SERVER_ONLY);
        }
    }

    public IVfsGenericFolder[] getUnambiguousFolders() {
        this.getVfsManager().checkState();
        return this.m_unambiguousFolders;
    }

    public String getBrowsePath() throws VfsException {
        this.getVfsManager().checkState();
        return this.m_unambiguousFolders[0].getBrowsePath();
    }

    public boolean isEmpty() throws VfsException {
        this.getVfsManager().checkState();
        if (this.m_folderItems.length == 0) {
            this.refreshFolderItems();
            if (this.m_folderItems.length == 0) {
                return true;
            }
        }
        return false;
    }

    public IVersionedFileSystemManager getVersionedFileSystemManager() {
        if (this.m_vfsManager == null || this.m_vfsManager.isReleased()) {
            throw new IllegalStateException("Versioned file system manager was released");
        }
        return this.m_vfsManager;
    }

    private void checkParameterState(IVfsWorkspace workspace) {
        if (workspace.getVersionedFileSystemManager() != this.getVersionedFileSystemManager()) {
            throw new IllegalArgumentException("Internal error: parameter with different versioned file system manager");
        }
    }

    VfsFolder getUnambiguousMountedFolder() {
        int i = 0;
        while (i < this.m_unambiguousFolders.length) {
            VfsFolder folder = (VfsFolder)this.m_unambiguousFolders[i].asFolder();
            if (folder != null && folder.isMounted()) {
                return folder;
            }
            ++i;
        }
        return null;
    }

    public void syncToDate(Calendar calendar) throws VfsException {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public boolean isReleased() {
        return this.m_vfsManager == null || this.m_vfsManager.isReleased();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

