/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.ConnectionPool;
import com.tssap.dtr.client.lib.deltavlib.IActivity;
import com.tssap.dtr.client.lib.deltavlib.ICheckedInResource;
import com.tssap.dtr.client.lib.deltavlib.ICheckedOutResource;
import com.tssap.dtr.client.lib.deltavlib.ICollection;
import com.tssap.dtr.client.lib.deltavlib.IFile;
import com.tssap.dtr.client.lib.deltavlib.IPersistentResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.IVersion;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.IWorkingResource;
import com.tssap.dtr.client.lib.deltavlib.IWorkspace;
import com.tssap.dtr.client.lib.deltavlib.PathEncodingFlag;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.ResourceFactoryManager;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyCacheControl;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICreatedResource;
import com.tssap.dtr.client.lib.exceptions.ExceptionCategory;
import com.tssap.dtr.client.lib.exceptions.ExceptionSeverity;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.pool.IConnectionPool;
import com.tssap.dtr.client.lib.protocol.pool.OutOfConnectionsException;
import com.tssap.dtr.client.lib.protocol.templates.TemplateException;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityElement;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsCheckinCollision;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItemListener2;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.IVfsProperty;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersionHistory;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsExceptionCategory;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemCategory;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.impl.FolderItemCache;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivity;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivityElement;
import com.tssap.dtr.client.lib.vfs.impl.VfsCheckinCollision;
import com.tssap.dtr.client.lib.vfs.impl.VfsFile;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolder;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolderItemRelation;
import com.tssap.dtr.client.lib.vfs.impl.VfsInconsistentFile;
import com.tssap.dtr.client.lib.vfs.impl.VfsInconsistentFolder;
import com.tssap.dtr.client.lib.vfs.impl.VfsListenerHandler;
import com.tssap.dtr.client.lib.vfs.impl.VfsRepository;
import com.tssap.dtr.client.lib.vfs.impl.VfsSpecialPaths;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersion;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersionHistory;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspace;
import com.tssap.dtr.client.lib.vfs.impl.VfsXcmProperty;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncDB;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncEntry;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

abstract class VfsActivityRecordedFolderItem
extends VfsFolderItem
implements IVfsActivityRecordedFolderItem {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$VfsActivityRecordedFolderItem == null ? (class$com$tssap$dtr$client$lib$vfs$impl$VfsActivityRecordedFolderItem = VfsActivityRecordedFolderItem.class$("com.tssap.dtr.client.lib.vfs.impl.VfsActivityRecordedFolderItem")) : class$com$tssap$dtr$client$lib$vfs$impl$VfsActivityRecordedFolderItem));
    private VfsWorkspace m_workspace;
    private IVersionControlledResource m_dvLocalRemoteNameClashVcr = null;
    private IVersionControlledResource m_dvReplacingVcr = null;
    private VfsVersion m_vfsActiveVersion = null;
    private VfsVersion m_vfsVersion = null;
    private HashMap m_dvNewResources = new HashMap();
    private HashMap m_dvWorkingResources = new HashMap();
    private HashMap m_activities = new HashMap();
    private VfsFolderItemActivityState m_activityState = VfsFolderItemActivityState.NOT_CHECKED_OUT;
    private IActivity[] singleActivityArray = new IActivity[1];
    private static final IVfsActivity[] ACTIVITIES = new IVfsActivity[0];
    static final boolean DONT_DEBUG_LOG_EXCEPTION = false;
    static final boolean DEBUG_LOG_EXCEPTION = true;
    private static final boolean CHECKED_OUT_BY_MY_USER = true;
    private static final boolean NOT_CHECKED_OUT_BY_MY_USER = false;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$VfsActivityRecordedFolderItem;

    VfsActivityRecordedFolderItem(IVfsWorkspace workspace, IResource resource, IVirtualFile localFile) throws VfsException {
        super(resource, localFile);
        this.m_workspace = (VfsWorkspace)workspace;
        this.refreshLocationState();
        if (this.getSyncedVersion() == null) {
            this.refreshSyncedVersion();
        }
    }

    VfsActivityRecordedFolderItem(IResource resource, IVirtualFile localFile) {
        super(resource, localFile);
    }

    IVersionControlledResource getDvLocalRemoteNameClashVcr() {
        if (this.asFolder() != null) {
            return null;
        }
        return this.getDvInternalLocalRemoteNameClashVcr();
    }

    IVersionControlledResource getDvInternalLocalRemoteNameClashVcr() {
        return this.m_dvLocalRemoteNameClashVcr;
    }

    void setDvLocalRemoteNameClashVcr(IVersionControlledResource dvLocalRemoteNameClashVcr) {
        if (this.m_dvLocalRemoteNameClashVcr != dvLocalRemoteNameClashVcr) {
            this.m_dvLocalRemoteNameClashVcr = dvLocalRemoteNameClashVcr;
            this.getVfsManager().fireEventFolderItemLocationStateChanged(this, this.getLocationState());
        }
    }

    boolean hasInternalLocalRemoteNameClash() {
        boolean hasLocalRemoteNameClash;
        boolean bl = hasLocalRemoteNameClash = this.m_dvLocalRemoteNameClashVcr != null;
        if (hasLocalRemoteNameClash) {
            this.getSyncDB().getSyncDbMget().setLastRemoteSyncTime(this.getLocalPath(), -1L);
        }
        return hasLocalRemoteNameClash;
    }

    public boolean hasLocalRemoteNameClash() {
        boolean hasLocalRemoteNameClash = this.hasInternalLocalRemoteNameClash();
        if (this.asFolder() != null) {
            hasLocalRemoteNameClash = false;
        }
        return hasLocalRemoteNameClash;
    }

    public boolean hasCheckinCollision() {
        return this.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT && (this.hasLocalRemoteNameClash() || this.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_FORMER);
    }

    IVersionControlledResource getDvReplacingVcr() {
        return this.m_dvReplacingVcr;
    }

    void setDvReplacingVcr(IVersionControlledResource dvReplacingVcr) {
        this.m_dvReplacingVcr = dvReplacingVcr;
    }

    private void replaceDvVcrByReplacingVcr() {
        if (this.m_dvReplacingVcr != null) {
            this.m_dvVcr = this.m_dvReplacingVcr;
            this.m_dvReplacingVcr = null;
        }
    }

    boolean hasReplacingVcr() {
        return this.m_dvReplacingVcr != null;
    }

    boolean hasActivityRecordedChangesIn(VfsActivity activity) throws VfsException {
        if (this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE || this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
            return true;
        }
        if (this.wasAPropertyTouchedIn(activity)) {
            return true;
        }
        if (this.asFile() != null && !((VfsFile)this).equalsLocalAndOriginalRemoteFileContent()) {
            return true;
        }
        return this.asFolder() != null && (((VfsFolder)this).hasCheckedOutForDeleteFolderItems(activity) || ((VfsFolder)this).hasNewCreatedFolderItems(activity));
    }

    private boolean wasAPropertyTouchedIn(VfsActivity activity) throws VfsException {
        IPropertyCacheControl propCacheControl = this.getNewestDeltaVResource().getPropertyCacheControl();
        propCacheControl.resetAllProperties();
        propCacheControl.addPropertyToCache(VfsXcmProperty.TOUCHED_PROPERTY.getCompletePropertyName());
        IVfsProperty touchedProperty = this.getProperty(VfsXcmProperty.TOUCHED_PROPERTY.getCompletePropertyName());
        this.getNewestDeltaVResource(activity).getPropertyCacheControl().clearProperty(VfsXcmProperty.TOUCHED_PROPERTY.getCompletePropertyName());
        if (touchedProperty == null || touchedProperty.getValue() == null || touchedProperty.getValue().equals("")) {
            return true;
        }
        return touchedProperty.getValue().equals("T");
    }

    static VfsActivityRecordedFolderItem searchVfsActivityRecordedFolderItem(IVfsWorkspace workspace, IVersionControlledResource dvResource, IVirtualFile localFile) throws VfsException {
        boolean dvResourceExists;
        boolean fileExists;
        block6: {
            fileExists = false;
            dvResourceExists = false;
            if (localFile != null && localFile != VfsFolderItem.NULL_LOCAL_FILE && localFile != VfsFolderItem.KEEP_LOCAL_FILE && localFile.exists()) {
                fileExists = true;
            } else {
                try {
                    if (dvResource != null && dvResource != VfsFolderItem.NULL_DELTAV_RESOURCE && dvResource != VfsFolderItem.KEEP_DELTAV_RESOURCE && (dvResource.isInitialized() || dvResource.getXCMObjectId() != null)) {
                        dvResourceExists = true;
                    }
                }
                catch (VcmFailure vcmFailure) {
                    if (vcmFailure.getStatusCode() == 404) break block6;
                    String msg = "Accessing DeltaV resource failed (server response: " + vcmFailure.getMessage() + " ) ";
                    VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, dvResource.getPersistentURL(), msg);
                    throw new VfsException(msg + ": " + dvResource.getPersistentURL(), vcmFailure);
                }
            }
        }
        if (fileExists || dvResourceExists) {
            return VfsActivityRecordedFolderItem.getVfsActivityRecordedFolderItem(workspace, dvResource, localFile);
        }
        return null;
    }

    static VfsActivityRecordedFolderItem getVfsActivityRecordedFolderItem(IVfsWorkspace workspace, IVersionControlledResource dvResource, IVirtualFile localFile) throws VfsException {
        VfsActivityRecordedFolderItem folderItem;
        VfsFolderItemCategory folderItemCategory;
        String path;
        try {
            path = localFile != null && localFile != VfsFolderItem.KEEP_LOCAL_FILE && localFile != VfsFolderItem.NULL_LOCAL_FILE ? localFile.getAbsolutePath() : (dvResource != null && (dvResource != VfsFolderItem.KEEP_DELTAV_RESOURCE || dvResource != VfsFolderItem.NULL_DELTAV_RESOURCE) ? dvResource.getCanonicalPath() : null);
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
            path = null;
        }
        if (workspace == null || dvResource == null || localFile == null) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, path, "Internal error");
            throw new VfsException("Internal error: factory method call with null dvResource");
        }
        IWorkspace dvWorkspace = ((VfsWorkspace)workspace).getDvWorkspace();
        if (dvWorkspace == VfsFolderItem.KEEP_DELTAV_RESOURCE || dvWorkspace == VfsFolderItem.NULL_DELTAV_RESOURCE) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, path, "Internal error");
            throw new VfsException("Internal error: factory method call with null dvResource");
        }
        if (dvResource != VfsFolderItem.KEEP_DELTAV_RESOURCE && dvResource != VfsFolderItem.NULL_DELTAV_RESOURCE && !dvResource.isInitialized()) {
            try {
                dvResource.getXCMObjectId();
            }
            catch (VcmFailure vcmFailure) {
                if (vcmFailure.getStatusCode() == 404) {
                    dvResource = VfsFolderItem.NULL_DELTAV_RESOURCE;
                }
                String msg = "Accessing DeltaV resource failed (server response: " + vcmFailure.getMessage() + ")";
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, path, msg);
                throw new VfsException(msg + ": " + path, vcmFailure);
            }
        }
        if (!(dvResource != VfsFolderItem.KEEP_DELTAV_RESOURCE && dvResource != VfsFolderItem.NULL_DELTAV_RESOURCE || localFile != VfsFolderItem.KEEP_LOCAL_FILE && localFile != VfsFolderItem.NULL_LOCAL_FILE)) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, path, "Internal error");
            throw new VfsException("Internal error: no resources given for creation of folder item");
        }
        VfsFolderItemCategory categoryForLocalFile = VfsActivityRecordedFolderItem.getFolderItemCategoryFor(localFile);
        VfsFolderItemCategory categoryForDvResource = VfsActivityRecordedFolderItem.getFolderItemCategoryFor(dvResource);
        VfsFolderItemCategory vfsFolderItemCategory = folderItemCategory = categoryForLocalFile != null ? categoryForLocalFile : categoryForDvResource;
        if (folderItemCategory == null) {
            String msg = "Get folder item failed, because local file and resource on repository don't exist";
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, path, msg);
            throw new VfsException(ExceptionSeverity.ERROR, VfsExceptionCategory.NOTFOUND_LOCAL_FILE_AND_RESOURRCE_ON_REPOSITORY, new Object[]{path}, null);
        }
        boolean localRemoteNameClash = VfsActivityRecordedFolderItem.checkLocalRemoteNameClash(workspace, localFile, dvResource, folderItemCategory, categoryForLocalFile, categoryForDvResource);
        if (folderItemCategory == VfsFolderItemCategory.FOLDER) {
            if (localRemoteNameClash) {
                folderItem = VfsFolder.pureUnsecuredGetVfsFolder(workspace, VfsFolderItem.NULL_DELTAV_RESOURCE, localFile);
                folderItem.setDvLocalRemoteNameClashVcr(dvResource);
            } else {
                folderItem = VfsFolder.pureUnsecuredGetVfsFolder(workspace, dvResource, localFile);
                folderItem.setDvLocalRemoteNameClashVcr(null);
            }
        } else if (localRemoteNameClash) {
            folderItem = VfsFile.pureUnsecuredGetVfsFile(workspace, VfsFolderItem.NULL_DELTAV_RESOURCE, localFile);
            folderItem.setDvLocalRemoteNameClashVcr(dvResource);
        } else {
            folderItem = VfsFile.pureUnsecuredGetVfsFile(workspace, dvResource, localFile);
            folderItem.setDvLocalRemoteNameClashVcr(null);
        }
        return folderItem;
    }

    private static VfsFolderItemCategory getFolderItemCategoryFor(IVirtualFile localFile) {
        if (localFile != VfsFolderItem.KEEP_LOCAL_FILE && localFile != VfsFolderItem.NULL_LOCAL_FILE) {
            if (localFile.isDirectory()) {
                return VfsFolderItemCategory.FOLDER;
            }
            if (localFile.isFile()) {
                return VfsFolderItemCategory.FILE;
            }
        }
        return null;
    }

    private static VfsFolderItemCategory getFolderItemCategoryFor(IResource dvResource) throws VfsException {
        if (dvResource != VfsFolderItem.KEEP_DELTAV_RESOURCE && dvResource != VfsFolderItem.NULL_DELTAV_RESOURCE) {
            try {
                if (dvResource.isCollection()) {
                    return VfsFolderItemCategory.FOLDER;
                }
                if (dvResource.isFile()) {
                    return VfsFolderItemCategory.FILE;
                }
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Get category (file / folder) of DeltaV resource failed  (server response: " + vcmFailure.getMessage() + ")", vcmFailure);
            }
        }
        return null;
    }

    static boolean checkLocalRemoteNameClash(IVfsWorkspace workspace, IVirtualFile localFile, IResource dvResource) throws VfsException {
        VfsFolderItemCategory folderItemCategory;
        VfsFolderItemCategory categoryForLocalFile = VfsActivityRecordedFolderItem.getFolderItemCategoryFor(localFile);
        VfsFolderItemCategory categoryForDvResource = VfsActivityRecordedFolderItem.getFolderItemCategoryFor(dvResource);
        VfsFolderItemCategory vfsFolderItemCategory = folderItemCategory = categoryForLocalFile != null ? categoryForLocalFile : categoryForDvResource;
        if (folderItemCategory == null) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, null, "Internal error");
            throw new VfsException("Internal error: Could not compute folder item category");
        }
        return VfsActivityRecordedFolderItem.checkLocalRemoteNameClash(workspace, localFile, dvResource, folderItemCategory, categoryForLocalFile, categoryForDvResource);
    }

    private static boolean checkLocalRemoteNameClash(IVfsWorkspace workspace, IVirtualFile localFile, IResource dvResource, VfsFolderItemCategory folderItemCategory, VfsFolderItemCategory categoryForLocalFile, VfsFolderItemCategory categoryForDvResource) throws VfsException {
        boolean localRemoteNameClash = false;
        String absoluteLocalPath = VfsFolderItem.getAbsoluteLocalPath(localFile, dvResource, workspace.getContext(), folderItemCategory);
        if (categoryForLocalFile == null) {
            if (categoryForDvResource == null) {
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, absoluteLocalPath, "Internal error");
                throw new VfsException("Internal error: Could not compute folder item category");
            }
        } else if (categoryForDvResource != null) {
            if (categoryForLocalFile != categoryForDvResource) {
                localRemoteNameClash = true;
            } else {
                SyncEntry syncEntry;
                SyncDB syncDB = workspace.getContext().getSyncDb(absoluteLocalPath);
                SyncEntry syncEntry2 = syncEntry = syncDB == null ? null : syncDB.getEntry(absoluteLocalPath);
                if (syncDB != null) {
                    if (syncEntry != null && dvResource != null && dvResource != VfsFolderItem.NULL_DELTAV_RESOURCE && dvResource != VfsFolderItem.KEEP_DELTAV_RESOURCE && !syncEntry.isSynced()) {
                        VfsActivityRecordedFolderItem.setDummySyncDataInSyncEntry(syncEntry);
                    }
                    if (syncEntry == null) {
                        if (!localFile.isFile()) {
                            FolderItemCache folderItemCache = ((VersionedFileSystemManager)workspace.getVersionedFileSystemManager()).getFolderItemCache();
                            VfsFolderItem cachedFolderItem = folderItemCache.getFolderItemWithLocalPath(absoluteLocalPath);
                            if (cachedFolderItem != null && cachedFolderItem.getCategory() == VfsFolderItemCategory.FOLDER && cachedFolderItem.asActivityRecordedFolderItem() != null && cachedFolderItem.asActivityRecordedFolderItem().getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE) {
                                localRemoteNameClash = true;
                            } else {
                                IWorkingResource dvWorkingResource = null;
                                ICreatedResource dvNewResource = null;
                                try {
                                    syncEntry = VfsActivityRecordedFolderItem.getOrReconstructSyncDBEntry(workspace.getContext(), localFile, dvResource, dvWorkingResource, dvNewResource, (VfsWorkspace)workspace);
                                    if (syncEntry == null) {
                                        VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.WARN_LOG, localFile, "Reconstructing SyncDB entry for folder failed");
                                        new VfsException("Reconstucting missed SyncDB entry for folder failed").printStackTrace();
                                    }
                                }
                                catch (VfsException ignoreAlreadyLogged) {
                                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
                                }
                            }
                        } else {
                            localRemoteNameClash = true;
                        }
                    }
                }
            }
        }
        return localRemoteNameClash;
    }

    void addDvNewResource(VfsActivity activity, ICreatedResource dvResource) {
        this.m_dvNewResources.put(activity, dvResource);
    }

    ICreatedResource removeDvNewResource(VfsActivity activity) {
        return (ICreatedResource)this.m_dvNewResources.remove(activity);
    }

    void addDvWorkingResource(VfsActivity activity, IWorkingResource workingResource) {
        this.m_dvWorkingResources.put(activity, workingResource);
    }

    IWorkingResource removeDvWorkingResource(VfsActivity activity) {
        return (IWorkingResource)this.m_dvWorkingResources.remove(activity);
    }

    public IVfsVersion getSyncedVersion() {
        this.getVfsManager().checkState();
        return this.m_vfsVersion;
    }

    void setSyncedVersion(VfsVersion version) {
        VfsVersion oldVersion = this.m_vfsVersion;
        this.m_vfsVersion = version;
        if (!this.equalVersions(version, oldVersion)) {
            this.getVfsManager().fireEventVersionChanged(this, oldVersion);
        }
    }

    private boolean equalVersions(IVfsVersion version1, IVfsVersion version2) {
        if (version1 != null) {
            if (version2 != null) {
                return version1.getUrl().equals(version2.getUrl());
            }
            return false;
        }
        return version2 == null;
    }

    void refreshSyncedVersion() throws VfsException {
        if (this.isMounted()) {
            SyncEntry syncEntry;
            SyncDB syncDb = this.getSyncDB();
            SyncEntry syncEntry2 = syncEntry = syncDb != null ? syncDb.getEntry(this.getLocalPath()) : null;
            if (syncEntry != null) {
                try {
                    String versionUrl = syncEntry.getVersionUrl();
                    if (versionUrl != null && versionUrl.length() > 0 && !versionUrl.equals("UNKNOWN_VERSION_URL")) {
                        URL url = new URL(versionUrl);
                        IResourceFactory factory = ResourceFactoryManager.getInstance().getProxyFactory();
                        IVersion dvVersion = factory.createVersion(this.getConnectionTemplateId(), url.getPath(), PathEncodingFlag.ENCODED);
                        this.setSyncedVersion(new VfsVersion(this.getVfsManager(), dvVersion));
                    }
                }
                catch (Exception e) {
                    throw new VfsException("Could not create version object.", e);
                }
            }
        }
    }

    int getConnectionTemplateId() {
        int id = super.getConnectionTemplateId_noThrow();
        if (id >= 0) {
            return id;
        }
        IWorkingResource dvWorkingResource = this.getDvWorkingResource();
        if (dvWorkingResource != null) {
            return dvWorkingResource.getConnectionTemplID();
        }
        ICreatedResource dvNewResource = this.getDvNewResource();
        if (dvNewResource != null) {
            return dvNewResource.getConnectionTemplID();
        }
        throw new IllegalStateException("Internal error: no corresponding DeltaV resource available");
    }

    static VfsActivityRecordedFolderItem getVfsFolderItemForActivityElement(IVfsWorkspace workspace, VfsActivity activity, IVersionControlledResource dvVcr, ICreatedResource dvNewResource, IWorkingResource dvWorkingResource) throws VfsException {
        VfsActivityRecordedFolderItem folderItem;
        IWorkspace dvWorkspace;
        block33: {
            IVersionControlledResource dvUpdatedResource = dvVcr != null ? dvVcr : VfsFolderItem.NULL_DELTAV_RESOURCE;
            IResource dvActivityElement = dvNewResource != null ? dvNewResource : dvWorkingResource;
            try {
                dvWorkspace = ((VfsWorkspace)workspace).m_dvVcr.getAsCollection().getAsWorkspace();
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Internal error: get DeltaV resource for workspace failed  (server response: " + vcmFailure.getMessage() + ")", vcmFailure);
            }
            String absoluteRemotePath = VfsActivityRecordedFolderItem.getAbsoluteRemotePathInWorkspace(dvVcr, dvWorkingResource, dvNewResource, dvWorkspace);
            String absoluteLocalPath = workspace.getContext().getAbsoluteLocalPath(activity.getDeltaVActivity().getConnectionTemplID(), absoluteRemotePath);
            IVirtualFile localFile = absoluteLocalPath == null ? VfsFolderItem.NULL_LOCAL_FILE : workspace.getContext().getFileService().constructFile(absoluteLocalPath);
            try {
                VfsException cause;
                if (dvActivityElement.isFile()) {
                    if (localFile != VfsFolderItem.NULL_LOCAL_FILE && localFile.exists()) {
                        if (!localFile.isFile()) {
                            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, localFile, "Name clash between local folder and checked out or added file");
                            throw new VfsException("Name clash between local folder and checked out or added file");
                        }
                        try {
                            SyncEntry syncEntry = VfsActivityRecordedFolderItem.getOrReconstructSyncDBEntry(workspace.getContext(), localFile, dvVcr, dvWorkingResource, dvNewResource, (VfsWorkspace)workspace);
                            if (syncEntry == null) {
                                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, localFile, "Reconstucting missed SyncDB entry for checked out file failed");
                                new VfsException("Reconstucting missed SyncDB entry for checked out file failed").printStackTrace();
                            }
                        }
                        catch (VfsException ignoreAlreadyLogged) {
                            LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
                        }
                    }
                    if (dvUpdatedResource == VfsFolderItem.NULL_DELTAV_RESOURCE && localFile == VfsFolderItem.NULL_LOCAL_FILE) {
                        cause = new VfsException(ExceptionSeverity.ERROR, VfsExceptionCategory.NO_MOUNTPOINT_FOR_ADDED_FILE, new Object[]{absoluteRemotePath}, new Throwable[0]);
                        folderItem = VfsInconsistentFile.pureUnsecuredGetVfsInconsistentFile(cause, activity, dvNewResource);
                    } else {
                        folderItem = VfsFile.pureUnsecuredGetVfsFile(workspace, dvUpdatedResource, localFile);
                    }
                    if (localFile != VfsFolderItem.NULL_LOCAL_FILE && localFile.exists()) {
                        if (dvWorkingResource != null && dvWorkingResource.markedForDeletion()) {
                            localFile.delete();
                            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.INFO_LOG, localFile, "Deleted local file for folder item that is checked out for delete");
                            folderItem.getVfsManager().fireEventFolderItemContentChanged(localFile.getAbsolutePath(), IVfsFolderItemListener2.ContentChangeReasons.CHECKED_OUT_FOR_DELETE);
                        } else if (!localFile.canWrite(true)) {
                            localFile.setWritable();
                            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.INFO_LOG, localFile, "Set local file writable for folder item that is checked out");
                        }
                    }
                    break block33;
                }
                if (dvActivityElement.isCollection()) {
                    if (localFile != VfsFolderItem.NULL_LOCAL_FILE && localFile.exists() && !localFile.isDirectory()) {
                        throw new VfsException("Name clash between local file and checked out or added folder");
                    }
                    if (dvUpdatedResource == VfsFolderItem.NULL_DELTAV_RESOURCE && localFile == VfsFolderItem.NULL_LOCAL_FILE) {
                        cause = new VfsException(ExceptionSeverity.ERROR, VfsExceptionCategory.NO_MOUNTPOINT_FOR_ADDED_FOLDER, new Object[]{absoluteRemotePath}, new Throwable[0]);
                        folderItem = VfsInconsistentFolder.pureUnsecuredGetVfsInconsistentFolder(cause, activity, dvNewResource);
                    } else {
                        folderItem = VfsFolder.pureUnsecuredGetVfsFolder(workspace, dvUpdatedResource, localFile);
                    }
                    break block33;
                }
                throw new VfsException("DeltaV resource type is unknown or not valid for an checked out resource");
            }
            catch (VfsException x) {
                if (x.getCategory() == VfsExceptionCategory.INTERNAL_ERROR_NO_LOCAL_FILE_AND_NO_DELTAV_RESOURCE_FOR_FOLDER_ITEM && dvNewResource != null) {
                    throw new VfsException(ExceptionSeverity.ERROR, VfsExceptionCategory.NO_MOUNTPOINT_FOR_ADDED_FILE, new Object[]{absoluteRemotePath}, new Throwable[]{x});
                }
                throw x;
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Get DeltaV resource type failed  (server response: " + vcmFailure.getMessage() + ")", vcmFailure);
            }
        }
        if (dvNewResource != null) {
            folderItem.addDvNewResource(activity, dvNewResource);
            folderItem.addActivityAndActivityState(activity, VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE);
            if (folderItem.getVcrResource() != null && VfsSpecialPaths.isRemotePathBasedOnObjectID((VfsRepository)folderItem.getWorkspace().getRepository(), folderItem.getVcrResource().getDecodedPath())) {
                IResourceFactory proxyFactory = ResourceFactoryManager.getInstance().getProxyFactory();
                try {
                    IVersionControlledResource dvRealVcr = proxyFactory.createVCR(dvNewResource.getConnectionTemplID(), VfsActivityRecordedFolderItem.getAbsoluteRemotePathInWorkspace(null, null, dvNewResource, dvWorkspace));
                    folderItem.setVcrResource(dvRealVcr);
                    folderItem.setDvLocalRemoteNameClashVcr(dvRealVcr);
                }
                catch (VcmFailure vcmFailure) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
                }
                catch (VfsException e) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                }
            }
        } else if (dvWorkingResource != null) {
            folderItem.addDvWorkingResource(activity, dvWorkingResource);
            try {
                if (dvWorkingResource.markedForDeletion()) {
                    folderItem.addActivityAndActivityState(activity, VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE);
                } else {
                    folderItem.addActivityAndActivityState(activity, VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT);
                }
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Find out if DeltaV resource was marked for deletion failed  (server response: " + vcmFailure.getMessage() + ")", vcmFailure);
            }
        }
        return folderItem;
    }

    public String getAbsoluteRemotePath() {
        this.getVfsManager().checkState();
        String path = super.getAbsoluteRemotePath();
        if (path == null) {
            try {
                path = this.getAbsoluteRemotePathInWorkspace();
            }
            catch (VfsException ignoreAlreadyLogged) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
            }
        }
        return path;
    }

    String getAbsoluteRemotePathInWorkspace() throws VfsException {
        return VfsActivityRecordedFolderItem.getAbsoluteRemotePathInWorkspace(this.getVcrResource(), this.getDvWorkingResource(), this.getDvNewResource(), this.m_workspace.getDvWorkspace());
    }

    static String getAbsoluteRemotePathInWorkspace(IResource dvVcr, IWorkingResource dvWorkingResource, ICreatedResource dvCreatedResource, IWorkspace dvWorkspace) throws VfsException {
        if (dvVcr != null && dvVcr.isInitialized()) {
            try {
                if (!dvVcr.isFile()) {
                    return PathUtilities.assureTrailingSeparator(dvVcr.getCanonicalPath(), PathUtilities.REMOTE_FILESERVICE);
                }
                return dvVcr.getCanonicalPath();
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Checking whether the resource is a file failed  (server response: " + vcmFailure.getMessage() + ")", vcmFailure);
            }
        }
        if (dvWorkingResource != null) {
            try {
                String path = PathUtilities.assureTrailingSeparator(dvWorkspace.getDecodedPath(), PathUtilities.REMOTE_FILESERVICE) + dvWorkingResource.getXCMPath().substring(1);
                if (!dvWorkingResource.isFile()) {
                    return PathUtilities.assureTrailingSeparator(path, PathUtilities.REMOTE_FILESERVICE);
                }
                return path;
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Get path of checked out folder item failed  (server response: " + vcmFailure.getMessage() + ")", vcmFailure);
            }
        }
        if (dvCreatedResource != null) {
            try {
                String path = PathUtilities.assureTrailingSeparator(dvWorkspace.getDecodedPath(), PathUtilities.REMOTE_FILESERVICE) + dvCreatedResource.getXCMPath().substring(1);
                if (!dvCreatedResource.isFile()) {
                    return PathUtilities.assureTrailingSeparator(path, PathUtilities.REMOTE_FILESERVICE);
                }
                return path;
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Get path of checked out folder item failed  (server response: " + vcmFailure.getMessage() + ")", vcmFailure);
            }
        }
        return null;
    }

    String getPath() throws VfsException {
        this.getVfsManager().checkState();
        String path = super.getPath();
        if (path != null) {
            return path;
        }
        int webLocatorLength = this.getContext().getWebLocator(this.getConnectionTemplateId_noThrow()).length();
        String url = this.getUrl();
        if (url == null) {
            throw new VfsException("Cannot calculate URL");
        }
        path = url.substring(webLocatorLength);
        return Encoder.decodePath((String)path);
    }

    public String getAuthor() throws VfsException {
        this.getVfsManager().checkState();
        try {
            IResource dvResource = this.getNewestDeltaVResource();
            if (dvResource != null) {
                return dvResource.getAuthor();
            }
            return null;
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting author failed.", vcmFailure);
        }
    }

    public Date getLastModifiedDate() throws VfsException {
        this.getVfsManager().checkState();
        try {
            if (this.asFile() != null) {
                IResource newestDvResource = this.getNewestDeltaVResource();
                if (newestDvResource != null) {
                    return newestDvResource.lastModified();
                }
            } else {
                Date latestLastModified = null;
                Iterator iterator = null;
                if (this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE) {
                    iterator = this.getDvNewResources();
                } else if (this.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                    iterator = this.getDvWorkingResources();
                }
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        IResource dvResource = (IResource)iterator.next();
                        if (latestLastModified != null && latestLastModified.getTime() >= dvResource.lastModified().getTime()) continue;
                        latestLastModified = dvResource.lastModified();
                    }
                }
                if (latestLastModified != null) {
                    return latestLastModified;
                }
                if (this.getSyncedVersion() != null) {
                    return ((VfsVersion)this.getSyncedVersion()).getDvVersion().lastModified();
                }
                if (this.getVcrResource() != null) {
                    return this.getVcrResource().lastModified();
                }
            }
            if (this.isMounted()) {
                return new Date(this.m_localFile.lastModified());
            }
            throw new VfsException("No remote last modified date or no local file.");
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting last modified date failed.", vcmFailure);
        }
    }

    public String getLastModifier() {
        this.getVfsManager().checkState();
        return null;
    }

    public boolean isDeleted() {
        this.getVfsManager().checkState();
        return this.getLocationState() == VfsFolderItemLocationState.DELETED;
    }

    public IVfsWorkspace getWorkspace() {
        this.getVfsManager().checkState();
        return this.m_workspace;
    }

    public VfsFolderItemActivityState getActivityState() {
        this.getVfsManager().checkState();
        return this.m_activityState;
    }

    public IVfsActivity[] getOpenActivities() {
        this.getVfsManager().checkState();
        if (this.m_activities.isEmpty()) {
            return new IVfsActivity[0];
        }
        return this.m_activities.values().toArray(ACTIVITIES);
    }

    Iterator getOpenActivitiesIterator() {
        return this.m_activities.values().iterator();
    }

    boolean isCheckedOut(VfsActivity activity) {
        return this.m_activities.get(activity.getAbsoluteRemotePath()) != null;
    }

    public boolean isCheckedOutByOthers() {
        this.getVfsManager().checkState();
        if (this.getVcrResource() != null) {
            try {
                Boolean checkedOut = this.getVcrResource().getAsVersionControlled().isCheckedOutByOthers();
                if (checkedOut != null) {
                    return checkedOut;
                }
            }
            catch (VcmFailure vcmFailure) {
                LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
            }
        }
        return false;
    }

    public String[] getOtherCheckouters() {
        this.getVfsManager().checkState();
        if (this.isCheckedOutByOthers()) {
            try {
                return this.getVcrResource().getAsVersionControlled().getOtherCheckoutersDisplayNames();
            }
            catch (VcmFailure vcmFailure) {
                LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
            }
        }
        return new String[0];
    }

    void checkParameterState(IVfsActivity activity) {
        if (activity.getVersionedFileSystemManager() != this.getVersionedFileSystemManager()) {
            throw new IllegalArgumentException("Internal error: parameter with different versioned file system manager");
        }
    }

    IVfsActivity checkAndGetProperActivityForCheckout(IVfsActivity activity) throws VfsException {
        if (activity.getState() == VfsActivityState.CLOSED) {
            if (this.m_workspace.getCurrentActivity() == activity) {
                this.m_workspace.setCurrentActivity(null);
            }
            if (!this.m_workspace.isDefaultActivityInitial() && this.m_workspace.getDefaultActivity() == activity) {
                this.m_workspace.resetDefaultActivity();
                return this.m_workspace.getDefaultActivity();
            }
            return null;
        }
        return activity;
    }

    public void createAndCheckout(IVfsActivity activity) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(activity);
        ((VfsActivity)activity).checkWorkspace(this.getWorkspace());
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Checkout is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        VfsListenerHandler listenerHandler = this.getVfsManager().getListenerHandler();
        if (listenerHandler.isVfsInternalDelayedListeningTurnedOn()) {
            this.createAndCheckout(activity, true);
        } else {
            listenerHandler.startVfsInternalDelayedListening();
            try {
                this.createAndCheckout(activity, true);
                Object var5_5 = null;
                listenerHandler.stopVfsInternalDelayedListening();
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                listenerHandler.stopVfsInternalDelayedListening();
                throw throwable;
            }
        }
    }

    void createAndCheckout(IVfsActivity activity, boolean notifyListener) throws VfsException {
        int num;
        IVfsActivity act1 = this.checkAndGetProperActivityForCheckout(activity);
        if (act1 == null) {
            VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, this, "Activity is closed");
            throw new VfsException("Checkout not possible: activity is closed.");
        }
        if (act1 != activity) {
            activity = act1;
        }
        if (this.getLocationState() == VfsFolderItemLocationState.DELETED) {
            VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, this, "Folder item is deleted");
            throw new VfsException("Checkout not possible: Folder item is deleted");
        }
        if (this.checkCheckoutStatus(activity, VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE)) {
            return;
        }
        IVfsGenericFolder parent = this.getRealParent();
        VfsFolder parentFolder = (VfsFolder)parent.asFolder();
        IVfsWorkspace workspace = parent.asWorkspace();
        if (parentFolder != null) {
            this.createAndCheckoutUnderActivityRecordedFolder(parentFolder, activity);
        } else {
            if (this.m_workspace != workspace) {
                VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, this, "Invalid workspace relation");
                throw new VfsException("Internal error: invalid workspace relation");
            }
            this.createAndCheckoutUnderWorkspace(workspace, activity);
        }
        try {
            num = ((VfsActivity)activity).getNumberOfItems();
        }
        catch (VfsException e) {
            throw new VfsException("Get number of items of activity failed", e);
        }
        if (num == 1) {
            this.m_workspace.addActivityToOpenActivityCache(activity);
        }
        this.m_workspace.setCurrentActivity(activity);
        if (notifyListener) {
            this.getVfsManager().fireEventActivityItemsAddedOrRemoved(activity);
        }
    }

    void pureCreateAndCheckout(IVfsActivity activity, IResource newParentResource) throws VfsException {
        this.pureCreateAndCheckoutUnderActivityRecordedFolder(newParentResource, activity);
    }

    private void pureCreateAndCheckoutUnderActivityRecordedFolder(IResource newParentResource, IVfsActivity activity) throws VfsException {
        String decodedAbsoluteRemotePath = PathUtilities.assureTrailingSeparator(newParentResource.getDecodedPath(), PathUtilities.REMOTE_FILESERVICE) + this.getName();
        if (this.asFile() == null) {
            decodedAbsoluteRemotePath = PathUtilities.assureTrailingSeparator(decodedAbsoluteRemotePath, PathUtilities.REMOTE_FILESERVICE);
        }
        ICreatedResource dvNewResource = null;
        if (this.asFile() != null) {
            dvNewResource = this.createFileResourceOnRepository(decodedAbsoluteRemotePath, ((VfsActivity)activity).getDeltaVActivity());
        } else if (this.asFolder() != null) {
            dvNewResource = this.createFolderResourceOnRepository(decodedAbsoluteRemotePath, ((VfsActivity)activity).getDeltaVActivity());
        }
        this.addDvNewResource((VfsActivity)activity, dvNewResource);
        this.addActivityAndActivityState(activity, VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE);
        ((VfsActivity)activity).addActivityElement(this);
        if (this.asFile() != null && !this.m_localFile.canWrite(true)) {
            this.m_localFile.setWritable();
        }
    }

    private void createAndCheckoutUnderActivityRecordedFolder(VfsFolder parentFolder, IVfsActivity activity) throws VfsException {
        if (VfsFolderItem.existsOnRepository(this.m_workspace.getConnectionTemplateId(), parentFolder.getAbsoluteRemotePath())) {
            try {
                parentFolder.checkOutForEdit(activity, false, false);
            }
            catch (VfsException x) {
                VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, this, "Checking-out of parent folder failed");
                throw new VfsException("Checkout the parent folder failed", x);
            }
        }
        try {
            parentFolder.createAndCheckout(activity, false);
        }
        catch (VfsException x) {
            VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, this, "Adding of parent folder failed");
            throw new VfsException("Checkout the parent folder failed", x);
        }
        IResource dvParentResource = parentFolder.getDvWorkingResource((VfsActivity)activity);
        if (dvParentResource == null) {
            dvParentResource = parentFolder.getDvNewResource((VfsActivity)activity);
        }
        this.pureCreateAndCheckoutUnderActivityRecordedFolder(dvParentResource, activity);
    }

    void createAndCheckoutUnderWorkspace(IVfsWorkspace workspace, IVfsActivity activity) throws VfsException {
        ICheckedOutResource dvCheckedOutResource;
        String decodedAbsoluteRemotePath = workspace.getAbsoluteRemotePath() + this.getName();
        if (this.asFile() == null) {
            decodedAbsoluteRemotePath = PathUtilities.assureTrailingSeparator(decodedAbsoluteRemotePath, PathUtilities.REMOTE_FILESERVICE);
        }
        IPersistentResourceFactory persistentFactory = ResourceFactoryManager.getInstance().getPersistenceFactory();
        ICheckedInResource dvCheckedInResource = null;
        if (this.asFile() != null) {
            IFile dvFile = this.createFileResourceOnRepository(decodedAbsoluteRemotePath, persistentFactory);
            try {
                dvCheckedInResource = dvFile.getAsVersionControlled().getAsCheckedIn();
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Internal error: invalid DeltaV resource", vcmFailure);
            }
        }
        if (this.asFolder() != null) {
            ICollection dvCollection = this.createFolderResourceOnRepository(decodedAbsoluteRemotePath, persistentFactory);
            try {
                dvCheckedInResource = dvCollection.getAsVersionControlled().getAsCheckedIn();
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Internal error: invalid DeltaV resource", vcmFailure);
            }
        }
        this.m_dvVcr = dvCheckedInResource;
        try {
            this.singleActivityArray[0] = ((VfsActivity)activity).getDeltaVActivity();
            if (dvCheckedInResource == null) {
                String message = "Checkout on repository failed (dvCheckedInResource is null)";
                VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, this, message);
                throw new VfsException(message);
            }
            dvCheckedOutResource = dvCheckedInResource.checkout(this.singleActivityArray, 2);
            VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.SUCCEEDED, this, null);
        }
        catch (VcmFailure vcmFailure) {
            VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, this, vcmFailure.getMessage());
            throw new VfsException("Checkout on repository failed", vcmFailure);
        }
        try {
            this.addDvWorkingResource((VfsActivity)activity, dvCheckedOutResource.getAsWorkingResource());
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Internal error: invalid working resource", vcmFailure);
        }
        this.addActivityAndActivityState(activity, VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT);
        this.setLocationState(VfsFolderItemLocationState.SYNCED_TO_LATEST);
        ((VfsActivity)activity).addActivityElement(this);
        String dvVersionUrl = null;
        long lastModified = 0L;
        try {
            IVersion dvVersion = this.m_dvVcr.getAsVersionControlled().getActiveVersion();
            dvVersionUrl = dvVersion.getPersistentURL();
            lastModified = this.m_dvVcr.lastModified().getTime();
        }
        catch (VcmFailure vcmFailure) {
            new VfsException("Initialize SyncDB entry entry failed");
        }
        SyncDB syncDb = this.getSyncDB();
        SyncEntry syncEntry = syncDb.createEntry(this.getLocalPath(), this.getObjectID());
        syncEntry.setVersionUrlAndRemoteSyncTime(dvVersionUrl, lastModified);
        if (!this.m_localFile.canWrite(true)) {
            this.m_localFile.setWritable();
        }
    }

    private IFile createFileResourceOnRepository(String decodedAbsoluteRemotePath, IPersistentResourceFactory persistentFactory) throws VfsException {
        IFile dvFile;
        String contentType = ((VfsFile)this).computeContentType();
        try {
            InputStream inputStream = this.getContext().getFileService().constructFileInputStream(this.m_localFile);
            try {
                dvFile = persistentFactory.createFile(this.m_workspace.getConnectionTemplateId(), decodedAbsoluteRemotePath, inputStream, contentType, this.m_localFile.length());
            }
            catch (VcmFailure vcmFailure) {
                VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.PENDING, this, "First trial to add failed");
                try {
                    inputStream.close();
                }
                catch (IOException ignore) {
                    LogUtil.logException((Location)LOCATION, (Throwable)ignore);
                }
                inputStream = this.getContext().getFileService().constructFileInputStream(this.m_localFile);
                dvFile = persistentFactory.createFile(this.m_workspace.getConnectionTemplateId(), decodedAbsoluteRemotePath, inputStream, contentType, this.m_localFile.length());
            }
            VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.SUCCEEDED, this, null);
            try {
                inputStream.close();
            }
            catch (IOException e) {
                new VfsException("Close input stream for new file failed", e);
            }
            SyncDB syncDb = this.getSyncDB();
            SyncEntry syncEntry = syncDb.getEntry(this.getLocalPath());
            if (syncEntry != null) {
                syncEntry.reset();
            } else {
                syncEntry = syncDb.createEntry(this.getLocalPath(), this.getObjectID());
            }
            syncEntry.setLocalUploadTime(this.m_localFile.lastModified());
        }
        catch (VcmFailure vcmFailure1) {
            if (vcmFailure1.getStatusCode() == 405) {
                VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, this, "File already exists in repository");
                throw new VfsException("File already exists on repository", vcmFailure1);
            }
            VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, this, vcmFailure1.getMessage());
            throw new VfsException("Create file resource on repository failed", vcmFailure1);
        }
        catch (FileNotFoundException x1) {
            VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, this, "Local file not found");
            throw new VfsException("Get input stream for new file failed", x1);
        }
        return dvFile;
    }

    private ICreatedResource createFileResourceOnRepository(String decodedAbsoluteRemotePath, IActivity dvActivity) throws VfsException {
        ICreatedResource dvFile;
        String contentType = ((VfsFile)this).computeContentType();
        try {
            InputStream inputStream = this.getContext().getFileService().constructFileInputStream(this.m_localFile);
            try {
                dvFile = dvActivity.addNewFile(decodedAbsoluteRemotePath, inputStream, contentType, this.m_localFile.length());
            }
            catch (VcmFailure vcmFailure) {
                if (vcmFailure.getStatusCode() == 405) {
                    throw vcmFailure;
                }
                LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
                VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.PENDING, this, "First trial to add failed");
                try {
                    inputStream.close();
                }
                catch (IOException ignoreException) {
                    LogUtil.logException((Location)LOCATION, (Throwable)ignoreException);
                }
                inputStream = this.getContext().getFileService().constructFileInputStream(this.m_localFile);
                dvFile = dvActivity.addNewFile(decodedAbsoluteRemotePath, inputStream, contentType, this.m_localFile.length());
            }
            VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.SUCCEEDED, this, null);
            try {
                inputStream.close();
            }
            catch (IOException e) {
                new VfsException("Close input stream for new file failed", e);
            }
            SyncDB syncDb = this.getSyncDB();
            SyncEntry syncEntry = syncDb.getEntry(this.getLocalPath());
            if (syncEntry != null) {
                syncEntry.reset();
            } else {
                try {
                    syncEntry = syncDb.createEntry(this.getLocalPath(), dvFile.getXCMObjectId());
                }
                catch (VcmFailure vcmFailure) {
                    LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
                    syncEntry = syncDb.createEntry(this.getLocalPath(), "UNKNOWN_OBJECT_ID");
                }
            }
            syncEntry.setLocalUploadTime(this.m_localFile.lastModified());
        }
        catch (VcmFailure vcmFailure1) {
            if (vcmFailure1.getStatusCode() == 405) {
                VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, this, "File already exists in repository");
                throw new VfsException("File already exists on repository" + vcmFailure1.getMessage(), vcmFailure1);
            }
            VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, this, vcmFailure1.getMessage());
            throw new VfsException("Create file resource on repository failed", vcmFailure1);
        }
        catch (FileNotFoundException x1) {
            VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, this, "Local file not found");
            throw new VfsException("Get input stream for new file failed", x1);
        }
        return dvFile;
    }

    private ICollection createFolderResourceOnRepository(String decodedAbsoluteRemotePath, IPersistentResourceFactory persistentFactory) throws VfsException {
        ICollection dvCollection;
        try {
            dvCollection = persistentFactory.createCollection(this.m_workspace.getConnectionTemplateId(), decodedAbsoluteRemotePath);
            VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.SUCCEEDED, this, null);
        }
        catch (VcmFailure vcmFailure) {
            if (vcmFailure.getStatusCode() == 405) {
                VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, this, "Folder already exists in repository");
                throw new VfsException("Folder already exists on repository", vcmFailure);
            }
            VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, this, vcmFailure.getMessage());
            throw new VfsException("Create folder resource on repository failed", vcmFailure);
        }
        return dvCollection;
    }

    private ICreatedResource createFolderResourceOnRepository(String decodedAbsoluteRemotePath, IActivity dvActivity) throws VfsException {
        ICreatedResource dvCollection;
        try {
            dvCollection = dvActivity.addNewCollection(decodedAbsoluteRemotePath);
            VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.SUCCEEDED, this, null);
        }
        catch (VcmFailure vcmFailure) {
            if (vcmFailure.getStatusCode() == 405) {
                VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, this, "Folder already exists in repository");
                throw new VfsException("Folder already exists on repository", vcmFailure);
            }
            VfsActionRecorder.log(VfsActionType.ADD, VfsActionStatus.FAILED, this, vcmFailure.getMessage());
            throw new VfsException("Create folder resource on repository failed", vcmFailure);
        }
        return dvCollection;
    }

    public void checkOutForEdit(IVfsActivity activity) throws VfsException {
        this.checkOutForEdit(activity, false);
    }

    public void checkOutForEdit(IVfsActivity activity, boolean exclusive) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(activity);
        ((VfsActivity)activity).checkWorkspace(this.getWorkspace());
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Checkout is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.EDIT, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        this.checkOutForEdit(activity, exclusive, true);
    }

    void checkOutForEdit(IVfsActivity activity, boolean exclusive, boolean notifyListener) throws VfsException {
        if (this.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_FORMER) {
            throw new UnsupportedOperationException("Checkout folder items which are synced to former version is still not supported");
        }
        IVfsActivity act1 = this.checkAndGetProperActivityForCheckout(activity);
        if (act1 == null) {
            VfsActionRecorder.log(VfsActionType.EDIT, VfsActionStatus.FAILED, this, "Activity is closed");
            throw new VfsException("Checkout not possible: activity is closed.");
        }
        if (act1 != activity) {
            activity = act1;
        }
        if (this.getLocationState() == VfsFolderItemLocationState.SERVER_ONLY) {
            VfsActionRecorder.log(VfsActionType.EDIT, VfsActionStatus.FAILED, this, "Folder item is remote");
            throw new VfsException("Checkout not possible: Folder item is remote");
        }
        if (this.getLocationState() == VfsFolderItemLocationState.DELETED) {
            VfsActionRecorder.log(VfsActionType.EDIT, VfsActionStatus.FAILED, this, "Folder item is deleted");
            throw new VfsException("Checkout not possible: Folder item is deleted");
        }
        if (this.checkCheckoutStatus(activity, VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT)) {
            return;
        }
        if (this.m_dvVcr == null) {
            VfsActionRecorder.log(VfsActionType.EDIT, VfsActionStatus.FAILED, this, "No DeltaV resource available");
            throw new VfsException("Internal error: no DeltaV resource available");
        }
        this.checkDiscardTargetVersionInOpenActivities(VfsActionType.EDIT);
        this.pureCheckOutForEdit(activity, exclusive, notifyListener);
    }

    void pureCheckOutForEdit(IVfsActivity activity, boolean exclusive, boolean notifyListener) throws VfsException {
        int num;
        VfsFile vfsFile;
        ICheckedOutResource dvCheckedOutResource;
        this.singleActivityArray[0] = ((VfsActivity)activity).getDeltaVActivity();
        int checkoutMode = exclusive ? 18 : 2;
        try {
            dvCheckedOutResource = this.m_dvVcr.getAsVersionControlled().getAsCheckedIn().checkout(this.singleActivityArray, checkoutMode);
            String details = null;
            if (this instanceof IVfsFile && this.asFile().isCheckedOutByOthers()) {
                details = "Note: the file is also checked-out by other users: " + Arrays.asList(this.asFile().getOtherCheckouters());
            }
            VfsActionRecorder.log(VfsActionType.EDIT, VfsActionStatus.SUCCEEDED, this, details);
            if (exclusive) {
                try {
                    this.getVcrResource().getAsVersionControlled().localExlusiveCheckoutUpdate(activity.getAbsoluteRemotePath());
                }
                catch (VcmFailure vcmFailure) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
                }
            }
        }
        catch (VcmFailure vcmFailure) {
            String details = null;
            if (vcmFailure.getStatusCode() == 409 && this.isCheckedOutByOthers()) {
                details = exclusive ? "Exclusive checkout not possible, because " + this.getCategory().getText() + " is checked-out by other users: " + Arrays.asList(this.getOtherCheckouters()) : (this.isExclusiveCheckedOutByOthers() ? "The " + this.getCategory().getText() + " is exclusively checked-out by another user: " + Arrays.asList(this.getOtherCheckouters()) : "The " + this.getCategory().getText() + " is checked-out-for-delete by another user: " + Arrays.asList(this.getOtherCheckouters()));
            }
            if (details == null) {
                details = "server response: " + vcmFailure.getMessage();
            }
            VfsActionRecorder.log(VfsActionType.EDIT, VfsActionStatus.FAILED, this, details);
            throw new VfsException("Checkout " + this.getCategory().getText() + " failed (" + details + "):" + this.getIdentifyingString(), vcmFailure);
        }
        if ((vfsFile = (VfsFile)this.asFile()) != null) {
            try {
                boolean updateNeeded;
                IVersion dvCheckedOutPredecessor = null;
                IVfsVersion syncedVersion = this.getSyncedVersion();
                String checkedOutVersionPath = dvCheckedOutResource.getAsWorkingResource().getCheckedOutVersionPath();
                if (checkedOutVersionPath == null) {
                    dvCheckedOutPredecessor = VfsVersionHistory.preliminary__getLatestPredecessor(dvCheckedOutResource.getAsWorkingResource(), (VfsWorkspace)this.getWorkspace());
                    checkedOutVersionPath = dvCheckedOutPredecessor.getDecodedPath();
                }
                boolean bl = updateNeeded = syncedVersion == null || !checkedOutVersionPath.equals(syncedVersion.getPath());
                if (updateNeeded) {
                    String details;
                    VfsFolderItemLocationState locationState;
                    this.getVcrResource().refresh();
                    VfsFolderItemLocationState vfsFolderItemLocationState = locationState = checkedOutVersionPath.equalsIgnoreCase(this.getActiveVersion().getPath()) ? VfsFolderItemLocationState.SYNCED_TO_LATEST : VfsFolderItemLocationState.SYNCED_TO_FORMER;
                    if (dvCheckedOutPredecessor == null) {
                        dvCheckedOutPredecessor = ResourceFactoryManager.getInstance().getProxyFactory().createVersion(this.getConnectionTemplateId(), checkedOutVersionPath);
                    }
                    this.getVfsManager().getSyncRemoveFeature().syncToVersion(vfsFile, dvCheckedOutPredecessor, false);
                    this.setLocationState(locationState);
                    if (locationState == VfsFolderItemLocationState.SYNCED_TO_LATEST) {
                        SyncEntry entry = this.getSyncDB().getEntry(this.getLocalPath());
                        entry.setVersionUrlAndRemoteSyncTime(dvCheckedOutPredecessor.getPersistentURL(), this.getVcrResource().lastModified().getTime());
                    }
                    String string = details = locationState == VfsFolderItemLocationState.SYNCED_TO_LATEST ? "Latest version was downloaded and checked-out. " : "Checked-out version was downloaded";
                    if (this.asFile() != null && this.asFile().isCheckedOutByOthers()) {
                        details = details + "Note: the file is also checked-out by other users.";
                    }
                    VfsActionRecorder.log(VfsActionType.EDIT, VfsActionStatus.SUCCEEDED, this, details);
                }
            }
            catch (VcmFailure vcmFailure) {
                new VfsException("Refresh checked out version failed, please download file: " + this.getLocalPath(), vcmFailure);
            }
        }
        if (this.asFile() != null) {
            SyncDB syncDb = this.getSyncDB();
            SyncEntry entry = syncDb.getEntry(this.getLocalPath());
            entry.setLocalUploadTime(this.m_localFile.lastModified());
        }
        try {
            this.addDvWorkingResource((VfsActivity)activity, dvCheckedOutResource.getAsWorkingResource());
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Internal error: invalid working resource", vcmFailure);
        }
        this.addActivityAndActivityState(activity, VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT);
        ((VfsActivity)activity).addActivityElement(this);
        try {
            num = ((VfsActivity)activity).getNumberOfItems();
        }
        catch (VfsException e) {
            throw new VfsException("Get number of items of activity failed", e);
        }
        if (num == 1) {
            this.m_workspace.addActivityToOpenActivityCache(activity);
        }
        this.m_workspace.setCurrentActivity(activity);
        if (this.asFile() != null && !this.m_localFile.canWrite(true) && !this.m_localFile.setWritable()) {
            VfsActionRecorder.log(VfsActionType.EDIT, VfsActionStatus.FAILED, this, "Set writable for local file failed");
        }
        if (notifyListener) {
            this.getVfsManager().fireEventActivityItemsAddedOrRemoved(activity);
        }
    }

    public boolean isExclusiveCheckedOut() throws VfsException {
        this.getVfsManager().checkState();
        String activityUrl = this.getExclusiveCheckoutActivityPath(true);
        return activityUrl != null && activityUrl.length() != 0;
    }

    public boolean isExclusiveCheckedOutByOthers() throws VfsException {
        this.getVfsManager().checkState();
        String activityUrl = this.getExclusiveCheckoutActivityPath(false);
        return activityUrl != null && activityUrl.length() != 0;
    }

    private String getExclusiveCheckoutActivityPath(boolean checkedOutByMyUser) throws VfsException {
        IProperty exclusiveCheckedOutProperty;
        if (this.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY || this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE || this.getLocationState() == VfsFolderItemLocationState.DELETED || VfsActivityRecordedFolderItem.isDvResourceDeleted(this.getVcrResource())) {
            return null;
        }
        if (checkedOutByMyUser && this.getActivityState() != VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT || !checkedOutByMyUser && this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT) {
            return null;
        }
        try {
            exclusiveCheckedOutProperty = this.getVcrResource().getAsVersionControlled().getProperty(VfsXcmProperty.EXCLUSIVE_CHECKOUT.getCompletePropertyName());
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException(ExceptionSeverity.INFO, ExceptionCategory.ONE_ARGUMENT_PLACEHOLDER, new Object[]{"Accessing exclusive checkout lock for DeltaV resource failed: " + this.getBrowsePath()}, new Throwable[]{vcmFailure});
        }
        return exclusiveCheckedOutProperty == null ? null : exclusiveCheckedOutProperty.getFirstChild().getValue();
    }

    public void resetExclusiveCheckoutLock() throws VfsException {
        this.getVfsManager().checkState();
        if (this.getActivityState() != VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.SKIPPED, this, "Folder item is not checked out for edit");
            return;
        }
        IVfsActivity[] activities = this.getOpenActivities();
        if (activities.length > 1) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.SKIPPED, this, "Folder is checked out in several activities");
            return;
        }
        if (!this.isExclusiveCheckedOut()) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.SKIPPED, this, "Folder item is not exclusive checked out");
            return;
        }
        this.setExclusiveCheckoutLock(this.getDvWorkingResource((VfsActivity)activities[0]), false);
    }

    public void setExclusiveCheckoutLock() throws VfsException {
        this.getVfsManager().checkState();
        if (this.getActivityState() != VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT) {
            String msg = "Folder item is not checked out for edit";
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, "Folder item is not checked out for edit");
            throw new VfsException("Folder item is not checked out for edit: " + this.getBrowsePath());
        }
        IVfsActivity[] activities = this.getOpenActivities();
        if (activities.length > 1) {
            String msg = "Folder item is checked out in several activities";
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, "Folder item is checked out in several activities");
            throw new VfsException("Folder item is checked out in several activities: " + this.getBrowsePath());
        }
        if (this.isCheckedOutByOthers()) {
            String msg = "Folder item is already checked out by other users " + Arrays.asList(this.getOtherCheckouters());
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, msg);
            throw new VfsException(msg + ": " + this.getBrowsePath());
        }
        this.setExclusiveCheckoutLock(this.getDvWorkingResource((VfsActivity)activities[0]), true);
    }

    private void setExclusiveCheckoutLock(IWorkingResource dvWorkingResource, boolean value) throws VfsException {
        try {
            this.getVfsManager().getPropertiesFeature().internalSetProperty(dvWorkingResource, VfsXcmProperty.IS_EXCLUSIVE_CHECKOUT.getCompletePropertyName(), value ? "true" : "false");
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.SUCCEEDED, this, value ? "Set checkout lock on folder item" : "Reset checkout lock on folder item");
        }
        catch (VfsException e) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, value ? "Setting checkout lock on folder item failed" : "Resetting checkout lock on folder item failed");
            throw e;
        }
        try {
            IVfsActivity onlyActivity = (IVfsActivity)this.m_activities.values().iterator().next();
            this.getVcrResource().getAsVersionControlled().localExlusiveCheckoutUpdate(value ? onlyActivity.getAbsoluteRemotePath() : null);
        }
        catch (VcmFailure vcmFailure) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, "Refreshing folder item failed");
            throw new VfsException("Refreshing folder item failed", vcmFailure);
        }
        this.getVfsManager().fireEventFolderItemActivityStateChanged(this, this.getActivityState());
    }

    void addActivityAndActivityState(IVfsActivity activity, VfsFolderItemActivityState activityState) throws VfsException {
        if (this.asFile() != null && !this.m_activities.isEmpty() && this.m_activities.get(activity.getAbsoluteRemotePath()) != activity) {
            IllegalStateException e = new IllegalStateException("Internal error: a file is checked out in several activities");
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
        this.m_activities.put(activity.getAbsoluteRemotePath(), activity);
        this.setActivityState(activityState);
    }

    void removeActivityAndResetActivityState(IVfsActivity activity) throws VfsException {
        this.m_activities.remove(activity.getAbsoluteRemotePath());
        if (this.m_activities.isEmpty()) {
            this.setActivityState(VfsFolderItemActivityState.NOT_CHECKED_OUT);
        }
    }

    void removeCheckedOutDvResource(VfsActivity activity) {
        if (this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE) {
            this.removeDvNewResource(activity);
        } else {
            this.removeDvWorkingResource(activity);
        }
    }

    boolean checkCheckoutStatus(IVfsActivity destinationActivity, VfsFolderItemActivityState destinationActivityState) throws VfsException {
        if (this.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            if (destinationActivityState != this.getActivityState()) {
                VfsException e = new VfsException("Folder item is " + this.getActivityState().getText());
                VfsActionRecorder.log(VfsActionType.map(destinationActivityState), VfsActionStatus.FAILED, this, e.getMessage());
                throw e;
            }
            if (this.isCheckedOut((VfsActivity)destinationActivity)) {
                return true;
            }
            if (this.asFile() != null) {
                VfsActionRecorder.log(VfsActionType.map(destinationActivityState), VfsActionStatus.FAILED, this, "Folder item is checked-out in another activity");
                throw new VfsException("File is checked out in another activity");
            }
            if (this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE || this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE) {
                VfsException e = new VfsException("Folder item is " + this.getActivityState().getText() + " in another activity");
                VfsActionRecorder.log(VfsActionType.map(destinationActivityState), VfsActionStatus.FAILED, this, e.getMessage());
                throw e;
            }
        }
        return false;
    }

    public void checkOutAndDelete(IVfsActivity activity) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(activity);
        ((VfsActivity)activity).checkWorkspace(this.getWorkspace());
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Checkout is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        this.checkOutAndDelete(activity, true, true);
    }

    void checkOutAndDelete(IVfsActivity activity, boolean notifyListener, boolean refreshActivity) throws VfsException {
        if (this.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_FORMER) {
            throw new UnsupportedOperationException("Checkout folder items which are synced to former version is still not supported");
        }
        IVfsActivity act1 = this.checkAndGetProperActivityForCheckout(activity);
        if (act1 == null) {
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, "Activity is closed");
            throw new VfsException("Checkout not possible: activity is closed.");
        }
        if (act1 != activity) {
            activity = act1;
        }
        if (this.m_dvVcr == null) {
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, "Local-only resource cannot be checked-out for delete.");
            throw new VfsException("Local-only resource cannot be checked-out for delete.");
        }
        VfsFolder folder = (VfsFolder)this.asFolder();
        if (folder != null && folder.hasFolderItemsOnServer()) {
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, "Remote folder is not empty");
            throw new VfsException("Folder still contains folder items on server");
        }
        if (this.getLocationState() == VfsFolderItemLocationState.DELETED) {
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, "Folder item is deleted");
            throw new VfsException("Checkout not possible: Folder item is deleted");
        }
        if (this.checkCheckoutStatus(activity, VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE)) {
            return;
        }
        if (this.getLocationState() != VfsFolderItemLocationState.SYNCED_TO_LATEST && this.getLocationState() != VfsFolderItemLocationState.SERVER_ONLY && this.getLocationState() != VfsFolderItemLocationState.MOUNTED) {
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, "Folder item must be synced to latest or server-only");
            throw new VfsException("Checkout not possible: Folder item is not synced");
        }
        this.checkDiscardTargetVersionInOpenActivities(VfsActionType.DELETE);
        IVfsGenericFolder parent = this.getRealParent();
        if (parent.asWorkspace() != null) {
            this.checkoutAndDeleteUnderWorkspace();
            if (notifyListener) {
                this.getVfsManager().fireEventFolderItemsAddedOrRemoved(parent);
            }
        } else if (parent.asFolder() != null) {
            this.checkoutAndDeleteUnderActivityRecordedFolder((VfsFolder)parent.asFolder(), activity, refreshActivity);
        } else {
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, "Invalid parent folder item");
            throw new VfsException("Internal error: invalid parent folder item");
        }
        if (notifyListener) {
            this.getVfsManager().fireEventActivityItemsAddedOrRemoved(activity);
        }
    }

    void checkoutAndDeleteUnderWorkspace() throws VfsException {
        if (this.asFolder() != null && !this.asFolder().isEmpty()) {
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, "Deletion of non-empty folder directly under the workspace is not allowed");
            throw new VfsException("Deletion of non-empty folder directly under the workspace is not allowed");
        }
        try {
            this.m_dvVcr.remove();
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.SUCCEEDED, this, "Deleted without checking-out - resource is directly under workspace");
        }
        catch (VcmFailure vcmFailure) {
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, vcmFailure.getMessage());
            throw new VfsException("Delete folder item failed", vcmFailure);
        }
        HashMap<String, VfsActivityRecordedFolderItem> folderItemsToRemove = new HashMap<String, VfsActivityRecordedFolderItem>(1);
        folderItemsToRemove.put(this.getAbsoluteRemotePath(), this);
        ((VfsWorkspace)this.getWorkspace()).removeFolderItems(folderItemsToRemove);
        VfsFolderItemLocationState oldLocationState = this.getLocationState();
        this.setLocationState(VfsFolderItemLocationState.DELETED);
        SyncDB syncDB = this.getSyncDB();
        syncDB.removeEntry(this.getLocalPath());
        if (oldLocationState != VfsFolderItemLocationState.SERVER_ONLY && !this.m_localFile.delete()) {
            if (this.asFile() != null) {
                throw new VfsException("Could not delete local file " + this.getLocalPath());
            }
            throw new VfsException("Could not delete local folder " + this.getLocalPath());
        }
        this.getVfsManager().fireEventFolderItemsAddedOrRemoved(this.getWorkspace());
        this.getVfsManager().fireEventFolderItemContentChanged(this.m_localFile.getAbsolutePath(), IVfsFolderItemListener2.ContentChangeReasons.CHECKED_OUT_FOR_DELETE);
    }

    void checkoutAndDeleteUnderActivityRecordedFolder(VfsFolder parentFolder, IVfsActivity activity, boolean refreshActivity) throws VfsException {
        try {
            parentFolder.checkOutForEdit(activity, false, false);
        }
        catch (VfsException x) {
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, "Checking-out parent folder failed");
            throw new VfsException("Checking-out parent folder failed", x);
        }
        IWorkingResource dvParentWorkingResource = parentFolder.getDvWorkingResource((VfsActivity)activity);
        this.pureCheckoutAndDeleteUnderActivityRecordedFolder(dvParentWorkingResource, activity, refreshActivity);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pureCheckoutAndDeleteUnderActivityRecordedFolder(IWorkingResource dvParentWorkingResource, IVfsActivity activity, boolean refreshActivity) throws VfsException {
        block24: {
            String decodedAbsoluteRemotePath = PathUtilities.assureTrailingSeparator(dvParentWorkingResource.getDecodedPath(), PathUtilities.REMOTE_FILESERVICE) + this.getName();
            if (this.asFolder() != null) {
                decodedAbsoluteRemotePath = PathUtilities.assureTrailingSeparator(decodedAbsoluteRemotePath, PathUtilities.REMOTE_FILESERVICE);
            }
            IResourceFactory proxyFactory = ResourceFactoryManager.getInstance().getProxyFactory();
            IResource dvResourceForDelete = null;
            IConnection connection = VfsActivityRecordedFolderItem.getConnection(this.m_dvVcr.getConnectionTemplID());
            int oldReadTimeout = connection.getSocketReadTimeout();
            int INFINITE_TIMEOUT = 0;
            connection.setSocketReadTimeout(INFINITE_TIMEOUT);
            try {
                try {
                    if (this.asFile() != null) {
                        dvResourceForDelete = proxyFactory.createFile(this.m_dvVcr.getConnectionTemplID(), decodedAbsoluteRemotePath, PathEncodingFlag.DECODED);
                    } else if (this.asFolder() != null) {
                        dvResourceForDelete = proxyFactory.createCollection(this.m_dvVcr.getConnectionTemplID(), decodedAbsoluteRemotePath, PathEncodingFlag.DECODED);
                    }
                    if (dvResourceForDelete != null) {
                        dvResourceForDelete.remove();
                    } else {
                        new VfsException("dvResourceForDelete is null");
                    }
                    VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.SUCCEEDED, this, null);
                }
                catch (VcmFailure vcmFailure) {
                    boolean secondTrialSucceeded = false;
                    if (vcmFailure.getStatusCode() == 404) {
                        VfsFolder parentFolder = (VfsFolder)this.getRealParent().asFolder();
                        try {
                            parentFolder.adjustBindindsOfWorkingCollection(dvParentWorkingResource);
                            if (dvResourceForDelete != null) {
                                dvResourceForDelete.remove();
                            } else {
                                new VfsException("dvResourceForDelete is null");
                            }
                            secondTrialSucceeded = true;
                            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.SUCCEEDED, this, null);
                        }
                        catch (VfsException e) {
                            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                        }
                        catch (VcmFailure vcmFailure1) {
                            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure1);
                        }
                    }
                    if (!secondTrialSucceeded) {
                        VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, vcmFailure.getMessage());
                        throw new VfsException("Delete folder item failed ( " + vcmFailure.getMessage() + " ): " + this.getLocalPath(), vcmFailure);
                    }
                    Object var16_11 = null;
                    connection.setSocketReadTimeout(oldReadTimeout);
                    break block24;
                }
                Object var16_10 = null;
            }
            catch (Throwable throwable) {
                Object var16_12 = null;
                connection.setSocketReadTimeout(oldReadTimeout);
                throw throwable;
            }
            connection.setSocketReadTimeout(oldReadTimeout);
        }
        if (refreshActivity) {
            ((VfsActivity)activity).refreshOpenActivityAndActivityElements();
        }
        this.m_workspace.setCurrentActivity(activity);
        if (this.getLocationState() != VfsFolderItemLocationState.SERVER_ONLY) {
            SyncEntry syncEntry;
            if (this.m_localFile.exists()) {
                if (!this.m_localFile.delete()) {
                    VfsException e = this.asFile() != null ? new VfsException("Could not delete local file " + this.getLocalPath()) : new VfsException("Could not delete local folder " + this.getLocalPath());
                    VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, e.getMessage());
                    throw e;
                }
                if (this.asFile() != null) {
                    this.getVfsManager().fireEventFolderItemContentChanged(this.getLocalPath(), IVfsFolderItemListener2.ContentChangeReasons.CHECKED_OUT_FOR_DELETE);
                }
            }
            if ((syncEntry = this.getOrReconstructSyncDBEntry()) != null) {
                syncEntry.setLocalUploadTime(1L);
            }
        }
    }

    static IConnection getConnection(int connectionTemplateId) throws VfsException {
        IConnection connection;
        try {
            IConnectionPool connectionPool = ConnectionPool.getInstance();
            connection = connectionPool.acquireConnection(connectionTemplateId);
            connectionPool.releaseConnection(connection, false);
        }
        catch (OutOfConnectionsException e) {
            throw new VfsException(e.getMessage(), e);
        }
        catch (TemplateException e) {
            throw new VfsException(e.getMessage(), e);
        }
        return connection;
    }

    void checkOutForUndelete_preliminaryUncompleteImplementation(IVfsActivity activity) throws VfsException {
        block13: {
            ICheckedOutResource dvCheckedOutResource;
            this.getVfsManager().checkState();
            this.checkParameterState(activity);
            if (this.getLocationState() != VfsFolderItemLocationState.DELETED) {
                UnsupportedOperationException e = new UnsupportedOperationException("Undelete is not possible because folder item is not deleted");
                VfsActionRecorder.log(VfsActionType.UNDELETE, VfsActionStatus.FAILED, this, e.getMessage());
                throw e;
            }
            IVfsActivity act1 = this.checkAndGetProperActivityForCheckout(activity);
            if (act1 == null) {
                VfsException e = new VfsException("Checkout for undelete is not possible because activity is closed");
                VfsActionRecorder.log(VfsActionType.UNDELETE, VfsActionStatus.FAILED, this, e.getMessage());
                throw e;
            }
            if (act1 != activity) {
                activity = act1;
            }
            if (this.asFile() != null && this.getLocalFile() != null && this.getLocalFile().exists()) {
                VfsException e = new VfsException("Undelete is not possible because local file already exists: ");
                VfsActionRecorder.log(VfsActionType.UNDELETE, VfsActionStatus.FAILED, this, e.getMessage());
                throw e;
            }
            this.checkDiscardTargetVersionInOpenActivities(VfsActionType.UNDELETE);
            this.singleActivityArray[0] = ((VfsActivity)activity).getDeltaVActivity();
            try {
                dvCheckedOutResource = this.m_dvVcr.getAsVersionControlled().getAsCheckedIn().checkout(this.singleActivityArray, 2);
                VfsActionRecorder.log(VfsActionType.EDIT, VfsActionStatus.SUCCEEDED, this, "Checked-out for undelete");
            }
            catch (VcmFailure vcmFailure) {
                VfsActionRecorder.log(VfsActionType.UNDELETE, VfsActionStatus.FAILED, this, vcmFailure.getMessage());
                throw new VfsException("Checkout folder item failed", vcmFailure);
            }
            if (this.asFile() != null) {
                try {
                    IVersion dvCheckedOutPredecessor = VfsVersionHistory.preliminary__getLatestPredecessor(dvCheckedOutResource.getAsWorkingResource(), (VfsWorkspace)this.getWorkspace());
                    if (dvCheckedOutPredecessor.markedAsDeleted()) break block13;
                    try {
                        dvCheckedOutResource.remove();
                    }
                    catch (VcmFailure vcmFailure1) {
                        LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure1);
                    }
                    throw new VfsException("Undelete was already done by another client");
                }
                catch (VcmFailure vcmFailure) {
                    try {
                        dvCheckedOutResource.remove();
                    }
                    catch (VcmFailure vcmFailure1) {
                        LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure1);
                    }
                    throw new VfsException("Undelete failed because get checked-out version failed");
                }
            }
        }
        ((VfsActivity)activity).addActivityElement(this);
        this.m_workspace.addActivityToOpenActivityCache(activity);
    }

    public void uncheckout() throws VfsException {
        this.getVfsManager().checkState();
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Uncheckout is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        if (this.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.FAILED, this, "Folder item is not checked-out");
            throw new VfsException("Uncheckout not possible: Folder item is not checked out");
        }
        if (this.getLocationState() == VfsFolderItemLocationState.DELETED) {
            VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.FAILED, this, "Folder item is deleted");
            throw new VfsException("Uncheckout not possible: folder item is deleted");
        }
        if (this.asFolder() != null) {
            VfsFolder folder = (VfsFolder)this.asFolder();
            if (folder.hasCheckedOutForDeleteFolderItems()) {
                VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.FAILED, this, "Folder still has children that were checked-out for delete");
                throw new VfsException("Uncheckout is not allowed: folder still has children that were checked out for delete");
            }
            if (folder.hasNewCreatedFolderItems()) {
                VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.FAILED, this, "Folder still has children that were added to repository");
                throw new VfsException("Uncheckout is not allowed: folder still has children that were added to the repository");
            }
        }
        HashMap previousActivities = new HashMap(this.m_activities);
        this.pureUncheckout();
        Iterator activityIterator = previousActivities.values().iterator();
        VersionedFileSystemManager vfsManager = this.getVfsManager();
        while (activityIterator.hasNext()) {
            vfsManager.fireEventActivityItemsAddedOrRemoved((VfsActivity)activityIterator.next());
        }
    }

    public void uncheckout(IVfsActivity activity) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(activity);
        this.uncheckout(activity, ActionOnLocalDisc.RESYNC_CHECKED_OUT_FILE_VERSION);
    }

    void uncheckout(IVfsActivity activity, ActionOnLocalDisc handleLocalFile) throws VfsException {
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Uncheckout is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        if (this.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.FAILED, this, "Folder item is not checked-out");
            throw new VfsException("Uncheckout not possible: Folder item is not checked out");
        }
        if (this.m_activities.get(activity.getAbsoluteRemotePath()) == null) {
            VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.FAILED, this, "Folder item is not checked-out in the specified activity");
            throw new VfsException("Uncheckout not possible: Folder item is not checked-out in the specified activity");
        }
        if (this.getLocationState() == VfsFolderItemLocationState.DELETED) {
            VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.FAILED, this, "Folder item is deleted");
            throw new VfsException("Uncheckout not possible: folder item is deleted");
        }
        if (this.asFolder() != null) {
            VfsFolder folder = (VfsFolder)this.asFolder();
            if (folder.hasCheckedOutForDeleteFolderItems((VfsActivity)activity)) {
                VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.FAILED, this, "Folder still has children that were checked-out for delete");
                throw new VfsException("Uncheckout is not allowed: folder still has children that were checked out for delete");
            }
            if (folder.hasNewCreatedFolderItems((VfsActivity)activity)) {
                VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.FAILED, this, "Folder still has children that were added to repository");
                throw new VfsException("Uncheckout is not allowed: folder still has children that were added to the repository");
            }
        }
        this.pureUncheckout((VfsActivity)activity, handleLocalFile);
        this.refreshInternalStateAfterUncheckout((VfsActivity)activity);
        this.getVfsManager().fireEventActivityItemsAddedOrRemoved(activity);
    }

    private void pureUncheckout() throws VfsException {
        Iterator activityIterator = this.m_activities.values().iterator();
        while (activityIterator.hasNext()) {
            VfsActivity activity = (VfsActivity)activityIterator.next();
            this.pureUncheckout(activity);
            this.refreshInternalStateAfterUncheckout(activity);
        }
    }

    void pureUncheckout(VfsActivity activity) throws VfsException {
        this.pureUncheckout(activity, ActionOnLocalDisc.RESYNC_CHECKED_OUT_FILE_VERSION);
    }

    void pureUncheckout(VfsActivity activity, ActionOnLocalDisc handleLocalFile) throws VfsException {
        boolean exclusive = this.isExclusiveCheckedOut();
        try {
            IWorkingResource dvWorkingResource = this.getDvWorkingResource(activity);
            if (dvWorkingResource != null) {
                dvWorkingResource.remove();
            } else {
                ICreatedResource dvNewResource = this.getDvNewResource(activity);
                dvNewResource.remove();
            }
            VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.SUCCEEDED, this, this.asFolder() != null ? "Folder and its folder items which were added or deleted" : null);
        }
        catch (VcmFailure vcmFailure) {
            VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.FAILED, this, vcmFailure.getMessage());
            throw new VfsException("Uncheckout the folder item failed", vcmFailure);
        }
        if (exclusive) {
            try {
                this.getVcrResource().getAsVersionControlled().localExlusiveCheckoutUpdate(null);
            }
            catch (VcmFailure vcmFailure) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
            }
        }
        this.refreshLocalFileSystemAfterUncheckout(handleLocalFile);
    }

    void refreshLocalFileSystemAfterUncheckout() throws VfsException {
        this.refreshLocalFileSystemAfterUncheckout(ActionOnLocalDisc.RESYNC_CHECKED_OUT_FILE_VERSION);
    }

    void refreshLocalFileSystemAfterUncheckout(ActionOnLocalDisc handleLocalFile) throws VfsException {
        if (!this.isMounted()) {
            return;
        }
        if (this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE) {
            return;
        }
        if (this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT) {
            if (this.asFile() != null) {
                if (handleLocalFile == ActionOnLocalDisc.RESYNC_CHECKED_OUT_FILE_VERSION) {
                    ((VfsFile)this.asFile()).resyncCheckedOutVersion();
                } else if (handleLocalFile == ActionOnLocalDisc.REMOVE_FILE_FROM_CLIENT) {
                    ((VfsFile)this.asFile()).removeCheckedOutVersionFromClient();
                } else {
                    this.getLocalFile().setReadOnly();
                }
            }
            return;
        }
        if (this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
            if (this.getLocationState() == VfsFolderItemLocationState.SERVER_ONLY) {
                return;
            }
            if (this.asFile() != null) {
                if (handleLocalFile == ActionOnLocalDisc.RESYNC_CHECKED_OUT_FILE_VERSION) {
                    try {
                        if (!this.m_localFile.createNewFile()) {
                            throw new VfsException("Recreate local file failed: can't overwrite existing file: " + this.getLocalPath());
                        }
                    }
                    catch (IOException e) {
                        throw new VfsException("Recreate local file failed: " + this.getLocalPath(), e);
                    }
                    ((VfsFile)this.asFile()).resyncCheckedOutVersion();
                }
            } else if (this.asFolder() != null) {
                if (handleLocalFile == ActionOnLocalDisc.RESYNC_CHECKED_OUT_FILE_VERSION) {
                    this.m_localFile.mkdirs();
                }
            } else {
                throw new VfsException("Internal error: illegal state of folder item that is checked out for delete: " + this.getLocalPath());
            }
            return;
        }
    }

    private void refreshInternalStateAfterUncheckout(VfsActivity activity) throws VfsException {
        this.refreshFolderItemStateAfterUncheckout(activity);
        IVfsActivityElement activityElement = activity.getActivityElement(this.getAbsoluteRemotePath());
        if (activityElement != null) {
            ((VfsActivityElement)activityElement).setInvalid(true);
        }
        activity.refreshActivityStateAfterUncheckout(this);
        this.refreshSyncDBEntryAfterUncheckout();
    }

    void refreshSyncDBEntryAfterUncheckout() {
        if (!this.isMounted()) {
            return;
        }
        if (this.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            SyncEntry syncEntry;
            SyncDB syncDB = this.getSyncDB();
            SyncEntry syncEntry2 = syncEntry = syncDB == null ? null : syncDB.getEntry(this.getLocalPath());
            if (syncEntry != null) {
                if (syncEntry.isSynced()) {
                    syncEntry.resetUploadTimestamp();
                    if (this.asFile() != null) {
                        syncDB.getSyncDbMget().setLastRemoteSyncTime(this.getLocalPath(), syncEntry.getRemoteSyncTime());
                    }
                } else {
                    syncDB.removeEntry(this.getLocalPath());
                }
            }
        }
    }

    void refreshFolderItemStateAfterUncheckout(VfsActivity activity) throws VfsException {
        if (this.removeDvWorkingResource(activity) == null) {
            this.removeDvNewResource(activity);
        }
        this.removeActivityAndResetActivityState(activity);
    }

    public void setProperty(String name, String value, IVfsActivity activity) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(activity);
        ((VfsActivity)activity).checkWorkspace(this.getWorkspace());
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Setting property is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        this.checkDiscardTargetVersionInOpenActivities(VfsActionType.UNSPECIFIED);
        this.getVfsManager().getPropertiesFeature().setProperty(this, name, value, activity);
    }

    public void removeProperty(String name, IVfsActivity activity) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(activity);
        ((VfsActivity)activity).checkWorkspace(this.getWorkspace());
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Removing property is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        this.checkDiscardTargetVersionInOpenActivities(VfsActionType.UNSPECIFIED);
        this.ensureCheckoutForPropertyHandling(activity);
        this.internalRemoveProperty(this.getNewestDeltaVResource((VfsActivity)activity), name);
    }

    void ensureCheckoutForPropertyHandling(IVfsActivity activity) throws VfsException {
        if (activity == null) {
            throw new IllegalArgumentException("Parameter activity must be non-null.");
        }
        if (this.getLocationState() == VfsFolderItemLocationState.DELETED) {
            throw new VfsException("Folder item cannot be changed, because it is deleted");
        }
        if (this.asActivityRecordedFolderItem().getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
            throw new VfsException("Folder item cannot be changed, because it is checked out for delete");
        }
        if (this instanceof IVfsFolder) {
            IVfsActivity[] activities = this.getOpenActivities();
            int i = 0;
            while (i < activities.length) {
                if (activity == activities[i]) {
                    return;
                }
                ++i;
            }
            this.checkOutForEdit(activity);
        } else if (this.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            this.checkOutForEdit(activity);
        }
    }

    public IVfsVersionHistory refreshAndGetVersionHistory() {
        this.getVfsManager().checkState();
        if (this.getSyncedVersion() != null) {
            return this.getSyncedVersion().getVersionHistory();
        }
        try {
            IResource resource = this.m_dvVcr;
            if (resource != null && resource.isVersioned()) {
                return new VfsVersionHistory(this.getVfsManager(), resource.getAsVersionControlled().getVersionHistory());
            }
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
        }
        catch (VfsException ignoreAlreadyLogged) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
        }
        return null;
    }

    public IVfsVersion refreshAndGetVersion(String versionSequenceNumber) {
        this.getVfsManager().checkState();
        return null;
    }

    ICreatedResource getDvNewResource() {
        if (this.m_dvNewResources.size() == 0) {
            return null;
        }
        Iterator iterator = this.m_dvNewResources.values().iterator();
        return (ICreatedResource)iterator.next();
    }

    ICreatedResource getDvNewResource(VfsActivity activity) {
        return (ICreatedResource)this.m_dvNewResources.get(activity);
    }

    Iterator getDvNewResources() {
        return this.m_dvNewResources.values().iterator();
    }

    IWorkingResource getDvWorkingResource() {
        if (this.m_dvWorkingResources.size() == 0) {
            return null;
        }
        Iterator iterator = this.m_dvWorkingResources.values().iterator();
        return (IWorkingResource)iterator.next();
    }

    IWorkingResource getDvWorkingResource(VfsActivity activity) {
        return (IWorkingResource)this.m_dvWorkingResources.get(activity);
    }

    Iterator getDvWorkingResources() {
        return this.m_dvWorkingResources.values().iterator();
    }

    public IVfsVersion refreshAndGetVersion() throws VfsException {
        this.getVfsManager().checkState();
        if (null == this.m_dvVcr) {
            return null;
        }
        if (!this.isMounted()) {
            try {
                return new VfsVersion(this.getVfsManager(), this.m_dvVcr.getAsVersionControlled().getActiveVersion());
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Get current version from repository failed", vcmFailure);
            }
        }
        SyncDB syncDb = this.getSyncDB();
        SyncEntry syncEntry = syncDb.getEntry(this.getLocalPath());
        if (syncEntry != null) {
            IVersion version;
            String versionUrl = syncEntry.getVersionUrl();
            if (versionUrl == null || versionUrl.length() == 0 || versionUrl.equals("UNKNOWN_VERSION_URL")) {
                throw new VfsException("Get version failed because of missed sync data, please sync again");
            }
            try {
                URL url = new URL(versionUrl);
                version = ResourceFactoryManager.getInstance().getProxyFactory().createVersion(this.m_dvVcr.getConnectionTemplID(), url.getPath(), PathEncodingFlag.ENCODED);
            }
            catch (MalformedURLException x) {
                throw new VfsException("Internal error: Get version failed because of malformed URL", x);
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Get DeltaV version resource failed", vcmFailure);
            }
            return new VfsVersion(this.getVfsManager(), version);
        }
        try {
            return new VfsVersion(this.getVfsManager(), this.m_dvVcr.getAsVersionControlled().getActiveVersion());
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Get DeltaV version resource failed", vcmFailure);
        }
    }

    public String getBrowsePath() throws VfsException {
        this.getVfsManager().checkState();
        int connectionTemplateId = this.getConnectionTemplateId();
        return this.getBrowsePath(connectionTemplateId);
    }

    String getBrowsePath(int connectionTemplateId) throws VfsException {
        IVfsRemoteLocator[] rootLocators = this.getWorkspace().getContext().getBrowseRootRemoteLocators();
        int i = 0;
        while (i < rootLocators.length) {
            IVfsRemoteLocator rootLocator = rootLocators[i];
            if (rootLocator.getConnectionTemplateId() == connectionTemplateId && this.getPath().startsWith(rootLocator.getAbsoluteRemotePath())) {
                return this.getPath().substring(rootLocator.getAbsoluteRemotePath().length() - 1);
            }
            ++i;
        }
        return null;
    }

    void refreshInternalStateAfterCheckin(String absoluteRemotePath, VfsVersion version, VfsActivity activity) throws VfsException {
        boolean wasDeleted = false;
        IWorkingResource dvWorkingResource = this.getDvWorkingResource(activity);
        if (dvWorkingResource != null) {
            try {
                wasDeleted = dvWorkingResource.markedForDeletion();
            }
            catch (VcmFailure vcmFailure) {
                this.removeActivityAndResetActivityState(activity);
                this.removeDvWorkingResource(activity);
                new VfsException("Check if DeltaV resource was deleted failed", vcmFailure);
            }
        }
        try {
            boolean isFirstVersion = false;
            if (this.m_dvVcr == null) {
                isFirstVersion = true;
                this.m_dvVcr = VfsActivityRecordedFolderItem.createVcrResource(absoluteRemotePath, this.m_workspace.getConnectionTemplateId());
            } else if (wasDeleted) {
                this.m_dvVcr = this.createDeletedVcrResource();
            }
            if (this.m_dvVcr != null) {
                this.m_dvVcr.getAsVersionControlled().localUpdate(version.getDvVersion(), isFirstVersion, activity.getDeltaVActivity());
            }
        }
        catch (VcmFailure vcmFailure) {
            this.removeActivityAndResetActivityState(activity);
            this.removeDvNewResource(activity);
            throw new VfsException("Get DeltaV resource failed", vcmFailure);
        }
        this.setSyncedVersion(version);
        VfsVersion activeVersion = null;
        if (!wasDeleted) {
            try {
                activeVersion = new VfsVersion(this.getVfsManager(), this.m_dvVcr.getAsVersionControlled().getActiveVersion());
            }
            catch (VcmFailure vcmFailure) {
                new VfsException("Get active version for checked in folder item failed: " + this.getLocalPath());
                activeVersion = version;
            }
        }
        this.setActiveVersion(activeVersion);
        if (this.removeDvWorkingResource(activity) == null) {
            this.removeDvNewResource(activity);
        }
        if (wasDeleted) {
            this.setLocationState(VfsFolderItemLocationState.DELETED);
        } else if (version.getPath().equals(activeVersion.getPath())) {
            this.setLocationState(VfsFolderItemLocationState.SYNCED_TO_LATEST);
        } else {
            this.setLocationState(VfsFolderItemLocationState.SYNCED_TO_FORMER);
        }
        this.removeActivityAndResetActivityState(activity);
    }

    static IResource createVcrResource(String absoluteRemotePath, int connectionTemplateId) throws VfsException {
        IResourceFactory factory = ResourceFactoryManager.getInstance().getProxyFactory();
        try {
            return factory.createVCR(connectionTemplateId, absoluteRemotePath, PathEncodingFlag.DECODED);
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Internal error: Creating DeltaV resource failed: " + absoluteRemotePath, vcmFailure);
        }
    }

    private IResource createDeletedVcrResource() throws VfsException {
        return VfsActivityRecordedFolderItem.createDeletedVcrResource(this.m_workspace, this.getObjectID());
    }

    static IResource createDeletedVcrResource(VfsWorkspace workspace, String objectId) throws VfsException {
        String deletedVcrPath = VfsSpecialPaths.getAbsoluteRemotePathOfDeletedVcr(workspace, objectId);
        return VfsActivityRecordedFolderItem.createVcrResource(deletedVcrPath, workspace.getConnectionTemplateId());
    }

    public String getUrl() throws VfsException {
        this.getVfsManager().checkState();
        String url = super.getUrl();
        if (url != null) {
            return url;
        }
        Logbook.getWarnChapter(2).println("No VCR and no local file.");
        IResource dvResource = this.getDvWorkingResource();
        if (dvResource == null) {
            dvResource = this.getDvNewResource();
        }
        if (dvResource != null) {
            String workspaceUrl = ((VfsWorkspace)this.getWorkspace()).m_dvVcr.getPersistentURL();
            try {
                IProperty xcmPath = dvResource.getProperty(VfsXcmProperty.XCM_PATH_PROPERTY_NAME);
                if (xcmPath != null && xcmPath.getValue() != null) {
                    return PathUtilities.assureTrailingSeparator(workspaceUrl, PathUtilities.REMOTE_FILESERVICE) + Encoder.encodePath((String)xcmPath.getValue().substring(1));
                }
            }
            catch (VcmFailure vcmFailure) {
                LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
            }
        }
        Logbook.getErrorChapter(2).println("No VCR and no local file and getting URL via new or working resource failed.");
        return null;
    }

    IResource getAnyInitializedDvResource() {
        IResource newResource;
        IResource workingResource;
        IResource resource = super.getAnyInitializedDvResource();
        if (resource == null && this.m_dvWorkingResources != null && this.m_dvWorkingResources.size() > 0 && (workingResource = (IResource)this.m_dvWorkingResources.values().iterator().next()) != null && workingResource.isInitialized()) {
            resource = workingResource;
        }
        if (resource == null && this.m_dvNewResources != null && this.m_dvNewResources.size() > 0 && (newResource = (IResource)this.m_dvNewResources.values().iterator().next()) != null && newResource.isInitialized()) {
            resource = newResource;
        }
        return resource;
    }

    IResource getNewestDeltaVResource() {
        ICreatedResource dvNewResource = this.getDvNewResource();
        if (dvNewResource != null) {
            return dvNewResource;
        }
        IWorkingResource dvWorkingResource = this.getDvWorkingResource();
        if (dvWorkingResource != null) {
            return dvWorkingResource;
        }
        if (this.getSyncedVersion() != null) {
            return ((VfsVersion)this.getSyncedVersion()).getDvVersion();
        }
        return super.getNewestDeltaVResource();
    }

    IResource getNewestDeltaVResource(VfsActivity activity) {
        ICreatedResource dvNewResource = this.getDvNewResource(activity);
        if (dvNewResource != null) {
            return dvNewResource;
        }
        IWorkingResource dvWorkingResource = this.getDvWorkingResource(activity);
        if (dvWorkingResource != null) {
            return dvWorkingResource;
        }
        if (this.getSyncedVersion() != null) {
            return ((VfsVersion)this.getSyncedVersion()).getDvVersion();
        }
        return super.getNewestDeltaVResource();
    }

    IResource _performance_hack_getNewestDeltaVResource() {
        ICreatedResource dvNewResource = this.getDvNewResource();
        if (dvNewResource != null) {
            return dvNewResource;
        }
        IWorkingResource dvWorkingResource = this.getDvWorkingResource();
        if (dvWorkingResource != null) {
            return dvWorkingResource;
        }
        return super.getNewestDeltaVResource();
    }

    public IVfsContext getContext() {
        this.getVfsManager().checkState();
        return this.getWorkspace().getContext();
    }

    public void forceUpload() throws VfsException {
        this.getVfsManager().checkState();
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Upload is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UPLOAD, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        if (this.getLocationState() == VfsFolderItemLocationState.DELETED || this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
            return;
        }
        IVfsFile vfsFile = this.asFile();
        if (vfsFile != null && this.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            ((VfsFile)vfsFile).pureUnconditionalFileUpload();
            return;
        }
        IVfsFolder vfsFolder = this.asFolder();
        if (vfsFolder != null) {
            IVfsFolderItem[] children = vfsFolder.getFolderItems();
            int i = 0;
            while (i < children.length) {
                VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)children[i];
                folderItem.forceUpload();
                ++i;
            }
        }
    }

    public void upload() throws VfsException {
        this.getVfsManager().checkState();
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Upload is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UPLOAD, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        if (this.getLocationState() == VfsFolderItemLocationState.DELETED || this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
            return;
        }
        if (this.asFolder() != null) {
            VfsException e = new VfsException("Upload is not available for folder hierarchy, please use upload on activity instead");
            VfsActionRecorder.log(VfsActionType.UPLOAD, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        IVfsFile vfsFile = this.asFile();
        if (vfsFile != null && this.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            ((VfsFile)vfsFile).pureFileUpload();
            return;
        }
    }

    private void setActiveVersion(IVfsVersion version) {
        this.m_vfsActiveVersion = (VfsVersion)version;
    }

    public IVfsVersion getActiveVersion() throws VfsException {
        this.getVfsManager().checkState();
        try {
            if (this.m_dvVcr == null || VfsActivityRecordedFolderItem.isDvResourceDeleted(this.m_dvVcr)) {
                this.m_vfsActiveVersion = null;
            } else if (this.m_vfsActiveVersion != null) {
                if (!this.m_vfsActiveVersion.getUrl().equals(this.m_dvVcr.getAsVersionControlled().getActiveVersion().getPersistentURL())) {
                    this.refreshActiveVersion();
                }
            } else {
                this.refreshActiveVersion();
            }
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Get version that is active in workspace " + this.getWorkspace().getBrowsePath() + " failed: " + this.getBrowsePath(), vcmFailure);
        }
        catch (VfsException e) {
            throw e;
        }
        return this.m_vfsActiveVersion;
    }

    IVfsVersion refreshActiveVersion() throws VfsException {
        if (this.m_dvVcr == null || VfsActivityRecordedFolderItem.isDvResourceDeleted(this.m_dvVcr)) {
            this.m_vfsActiveVersion = null;
        } else {
            try {
                this.m_vfsActiveVersion = new VfsVersion(this.getVfsManager(), this.m_dvVcr.getAsVersionControlled().getActiveVersion());
            }
            catch (VcmFailure e) {
                throw new VfsException("Get version that is active in workspace " + this.getWorkspace().getBrowsePath() + " failed: " + this.getBrowsePath(), e);
            }
        }
        return this.m_vfsActiveVersion;
    }

    public void forceDownload() throws VfsException {
        this.getVfsManager().checkState();
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Download is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.DOWNLOAD, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        this.internaldownload(true);
    }

    public void download() throws VfsException {
        this.getVfsManager().checkState();
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Download is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.DOWNLOAD, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        this.internaldownload(false);
    }

    private void internaldownload(boolean forceDownload) throws VfsException {
        if (this.getLocationState() == VfsFolderItemLocationState.DELETED || this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
            return;
        }
        if (this.asFolder() != null) {
            VfsException e = new VfsException("Download is not available for folder hierarchy, please use download on activity instead");
            VfsActionRecorder.log(VfsActionType.UPLOAD, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        IVfsFile vfsFile = this.asFile();
        if (vfsFile != null && this.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            ((VfsFile)vfsFile).download(forceDownload);
            return;
        }
    }

    void setActivityState(VfsFolderItemActivityState activityState) {
        if (this.m_activityState != activityState) {
            VfsFolderItemActivityState oldState = this.m_activityState;
            this.m_activityState = activityState;
            this.getVfsManager().fireEventFolderItemActivityStateChanged(this, oldState);
        }
    }

    public String getWorkspaceRelativePath() {
        this.getVfsManager().checkState();
        try {
            IWorkingResource dvWorkingResource = this.getDvWorkingResource();
            if (dvWorkingResource != null) {
                return dvWorkingResource.getXCMPath().substring(1);
            }
            ICreatedResource dvNewResource = this.getDvNewResource();
            if (dvNewResource != null) {
                return dvNewResource.getXCMPath().substring(1);
            }
            if (this.m_dvVcr != null) {
                try {
                    String workspaceUrl = PathUtilities.assureTrailingSeparator(this.getWorkspace().getUrl(), PathUtilities.REMOTE_FILESERVICE);
                    return Encoder.decodePath((String)this.m_dvVcr.getPersistentURL().substring(workspaceUrl.length()));
                }
                catch (VfsException x) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                }
            } else {
                IVfsRemoteLocator locator = this.getContext().getRemoteLocator(this.getLocalPath());
                if (locator != null) {
                    int toStrip = this.getWorkspace().getAbsoluteRemotePath().length();
                    return locator.getAbsoluteRemotePath().substring(toStrip);
                }
            }
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)new VfsException("Get workspace relative path on checked out resource failed", vcmFailure));
            return null;
        }
        try {
            if (this.getSyncedVersion() != null) {
                return this.getSyncedVersion().getWorkspaceRelativePath();
            }
            if (this.getActiveVersion() != null) {
                return this.getActiveVersion().getWorkspaceRelativePath();
            }
            return null;
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return null;
        }
    }

    public IVersionedFileSystemManager getVersionedFileSystemManager() {
        return this.m_workspace.getVersionedFileSystemManager();
    }

    public IVfsCheckinCollision getCheckinCollision() throws VfsException {
        this.getVfsManager().checkState();
        if (this.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_FORMER && (this.getDvWorkingResource() != null || this.getDvNewResource() != null)) {
            return new VfsCheckinCollision(this.getVfsManager(), this);
        }
        return null;
    }

    void refreshLocationState() throws VfsException {
        super.refreshLocationState();
        if (VfsActivityRecordedFolderItem.isDvResourceDeleted(this.getVcrResource())) {
            if (this.getLocationState() != VfsFolderItemLocationState.SYNCED_TO_FORMER) {
                this.setLocationState(VfsFolderItemLocationState.DELETED);
            }
            return;
        }
        if (this.getVcrResource() == null && (this.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_FORMER || this.getLocationState() == VfsFolderItemLocationState.MOUNTED)) {
            this.refreshSyncedVersion();
            if (this.getSyncedVersion() == null) {
                SyncDB syncDB = this.getSyncDB();
                syncDB.removeEntry(this.getLocalPath());
                this.setLocationState(VfsFolderItemLocationState.LOCAL_ONLY);
            } else {
                String objectID = this.getSyncedVersion().getObjectID();
                this.setVcrResource(VfsActivityRecordedFolderItem.createDeletedVcrResource((VfsWorkspace)this.getWorkspace(), objectID));
            }
            return;
        }
        if (!(this.getLocationState() != VfsFolderItemLocationState.SYNCED_TO_FORMER && this.getLocationState() != VfsFolderItemLocationState.SYNCED_TO_LATEST && this.getLocationState() != VfsFolderItemLocationState.MOUNTED || this.getLocalFile().exists())) {
            SyncDB syncDB = this.getSyncDB();
            SyncEntry syncEntry = syncDB.getEntry(this.getLocalPath());
            if (syncEntry.isUploaded()) {
                new VfsException("No local file/folder for folder item that has a SyncDB entry and is checked out: " + this.getLocalPath());
            } else if (this.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                syncDB.removeEntry(this.getLocalPath());
                this.setLocationState(VfsFolderItemLocationState.SERVER_ONLY);
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.INFO_LOG, this, "Removed SyncDB entry for folder item that locally does not exist");
                return;
            }
        }
    }

    IVersion getDvVersion(int integrationSequenceNumber) throws VfsException {
        IVersion dvVersion;
        String absoluteRemoteVersionPath = VfsSpecialPaths.getAbsoluteRemoteVersionPath(this, integrationSequenceNumber);
        try {
            dvVersion = ResourceFactoryManager.getInstance().getLocatorFactory().createVersion(this.getConnectionTemplateId(), absoluteRemoteVersionPath, PathEncodingFlag.DECODED);
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("DeltaV resouce not found  (server response: " + vcmFailure.getMessage() + ")", vcmFailure);
        }
        return dvVersion;
    }

    IVersion getDvVersion(String url) throws VfsException {
        IVersion dvVersion;
        String webLocator = this.getVersionedFileSystemManager().getCurrentContext().getWebLocator(this.getConnectionTemplateId());
        String encodedRemoteVersionPath = url.substring(webLocator.length());
        try {
            dvVersion = ResourceFactoryManager.getInstance().getLocatorFactory().createVersion(this.getConnectionTemplateId(), encodedRemoteVersionPath, PathEncodingFlag.ENCODED);
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("DeltaV resouce not found  (server response: " + vcmFailure.getMessage() + ")", vcmFailure);
        }
        return dvVersion;
    }

    public void move(IVfsActivity sourceActivity, IVfsActivity destinationActivity) throws VfsException {
        this.getVfsManager().checkState();
        this.checkParameterState(sourceActivity);
        this.checkParameterState(destinationActivity);
        ((VfsActivity)destinationActivity).checkWorkspace(this.getWorkspace());
        try {
            this.checkIsModifiable();
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Changing activities is not allowed because workspace is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.MOVE, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        if (sourceActivity == destinationActivity) {
            VfsActionRecorder.log(VfsActionType.MOVE, VfsActionStatus.SKIPPED, this, "Source and destination activity have been the same activity");
            return;
        }
        if (!sourceActivity.isOpen() || !destinationActivity.isOpen()) {
            VfsActionRecorder.log(VfsActionType.MOVE, VfsActionStatus.FAILED, this, "At least one of the activities is not open");
            throw new VfsException("Move not possible: At least one of the activities is not open");
        }
        if (!this.isCheckedOut((VfsActivity)sourceActivity)) {
            VfsActionRecorder.log(VfsActionType.MOVE, VfsActionStatus.FAILED, this, "Source activity does not contain the folder item");
            throw new VfsException("Source activity does not contain the folder item");
        }
        if (this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE && this.isParentCheckedOutFor(VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE)) {
            VfsActionRecorder.log(VfsActionType.MOVE, VfsActionStatus.FAILED, this, "Folder item is in a deleted hierarchy, only the whole hierarchy can be moved by moving the root of this hierarchy");
            throw new VfsException("Folder item is in a deleted hierarchy, only the whole hierarchy can be moved by moving the root of this hierarchy");
        }
        if (this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE && this.isParentCheckedOutFor(VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE)) {
            VfsActionRecorder.log(VfsActionType.MOVE, VfsActionStatus.FAILED, this, "Folder item is in a created hierarchy, only the whole hierarchy can be moved by moving the root of this hierarchy");
            throw new VfsException("Folder item is in a created hierarchy, only the whole hierarchy can be moved by moving the root of this hierarchy");
        }
        VfsFolder folder = (VfsFolder)this.asFolder();
        if (folder == null) {
            try {
                ((VfsActivity)destinationActivity).checkPreconditionConcerningCollisionResolving(this.asFile());
            }
            catch (VfsException x) {
                VfsException e = new VfsException("Not allowed: " + x.getMessage());
                VfsActionRecorder.log(VfsActionType.MOVE, VfsActionStatus.FAILED, this, e.getMessage());
                throw e;
            }
        } else if (this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT || this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
            IVfsActivityElement[] destElements = destinationActivity.getElements();
            int i = 0;
            while (i < destElements.length) {
                IVfsVersion version = destElements[i].getAsVersion();
                if (version != null) {
                    IVfsFile correspondingFile = version.getCorrespondingFile(this.getWorkspace());
                    if (correspondingFile != null) {
                        if (((VfsActivityRecordedFolderItem)((Object)correspondingFile)).isCheckedOut((VfsActivity)sourceActivity) && ((VfsActivityRecordedFolderItem)((Object)correspondingFile)).isSuccessorOf(this.getAbsoluteRemotePath())) {
                            String errorMessage = "Not allowed: The resource \"" + correspondingFile.getBrowsePath() + "\" has still an open conflict resolution in the destination activity \"" + ((VfsActivity)destinationActivity).getIdentifyingString() + "\"";
                            VfsActionRecorder.log(VfsActionType.MOVE, VfsActionStatus.FAILED, this, errorMessage);
                            throw new VfsException(errorMessage);
                        }
                    } else {
                        String errorMessage = "Checking precondition concerning conflict resolving failed: no corresponding file for version \"" + version.getUrl() + "\"";
                        VfsActionRecorder.log(VfsActionType.MOVE, VfsActionStatus.FAILED, this, errorMessage);
                        throw new VfsException(errorMessage);
                    }
                }
                ++i;
            }
        }
        ((VfsActivity)sourceActivity).pureMoveElement(this, (VfsActivity)destinationActivity);
        if (folder != null && this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT) {
            try {
                folder.moveChildren((VfsActivity)sourceActivity, (VfsActivity)destinationActivity);
            }
            catch (VfsException ignoreAlreadyLogged) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
            }
        }
        ((VfsActivity)sourceActivity).refreshAfterMove((VfsActivity)destinationActivity);
    }

    private boolean isParentCheckedOutFor(VfsFolderItemActivityState checkoutState) throws VfsException {
        IVfsGenericFolder parent = this.getRealParent();
        return parent.asActivityRecordedFolderItem() != null && parent.asActivityRecordedFolderItem().getActivityState() == checkoutState;
    }

    static void checkAndAdaptCachedFolderItem(VfsFolderItem folderItem, IResource resource, String absoluteLocalPath, VfsFolderItemCategory folderItemCategory) throws VfsException {
        VfsFolderItemRelation relation = VfsFolderItem.checkIdentityOfRepresentedResource(folderItem, resource, folderItemCategory);
        if (relation == VfsFolderItemRelation.IDENTITY) {
            if (resource == VfsFolderItem.NULL_DELTAV_RESOURCE) {
                folderItem.m_dvVcr = null;
            } else if (resource != VfsFolderItem.KEEP_DELTAV_RESOURCE) {
                folderItem.m_dvVcr = resource;
            }
            folderItem.refreshLocationState();
        } else {
            if (relation == VfsFolderItemRelation.DIFFERENT_CATEGORY) {
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, absoluteLocalPath, "Internal error");
                throw new VfsException("Internal error: invalid folder item found in cache with local path: " + absoluteLocalPath);
            }
            if (relation == VfsFolderItemRelation.DIFFERENT_LOCATION) {
                ((VfsActivityRecordedFolderItem)folderItem).refreshFolderItemWithDifferentLocation(resource);
            } else if (relation == VfsFolderItemRelation.DIFFERENT_OID) {
                ((VfsActivityRecordedFolderItem)folderItem).refreshFolderItemWithDifferentOid(resource);
            } else if (relation == VfsFolderItemRelation.DIFFERENT_CONNECTION) {
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, absoluteLocalPath, "Internal error");
                throw new VfsException("Internal error: invalid DeltaV resource for folder item: " + absoluteLocalPath);
            }
        }
    }

    private void refreshFolderItemWithDifferentOid(IResource resource) throws VfsException {
        if (this.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            if (this.asFolder() != null && this.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE) {
                return;
            }
            this.takeOverDvReplacingVcrAndRefresh(resource);
            return;
        }
        if (this.asFolder() != null) {
            this.takeOverDvVcrAndRefresh(resource);
            return;
        }
        if (this.getLocationState() == VfsFolderItemLocationState.DELETED) {
            this.takeOverDvVcrAndRefresh(resource);
            return;
        }
        if (this.getLocationState() == VfsFolderItemLocationState.NOT_MOUNTED || this.getLocationState() == VfsFolderItemLocationState.SERVER_ONLY) {
            this.takeOverDvVcrAndRefresh(resource);
            return;
        }
        if (this.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_FORMER || this.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_LATEST) {
            this.takeOverDvReplacingVcrAndRefresh(resource);
            return;
        }
        VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this.getBrowsePath(), "Internal error");
        throw new VfsException("Internal error: invalid folder item found in cache with local path: " + this.getBrowsePath());
    }

    void replaceDvVcrByReplacingVcrAndRefresh() throws VfsException {
        if (!this.hasReplacingVcr() || !this.isMounted()) {
            return;
        }
        if (this.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            throw new VfsException("File is " + this.getActivityState().getText() + ": " + this.getIdentifyingString());
        }
        try {
            if (this.getLocalFile().exists()) {
                this.getLocalFile().delete();
            }
        }
        catch (SecurityException e) {
            throw new VfsException("File cannot be accessed due to SecurityException (" + e.getMessage() + "): " + this.getIdentifyingString(), e);
        }
        this.getSyncDB().removeEntry(this.getLocalPath());
        this.replaceDvVcrByReplacingVcr();
        this.setActiveVersion(null);
        this.setSyncedVersion(null);
        this.setLocationState(VfsFolderItemLocationState.SERVER_ONLY);
    }

    private void takeOverDvReplacingVcrAndRefresh(IResource dvResource) throws VfsException {
        try {
            this.setDvReplacingVcr(dvResource.getAsVersionControlled());
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)vcmFailure, (int)500);
        }
        this.setVcrResource(this.createDeletedVcrResource());
        this.refreshLocationState();
    }

    private void takeOverDvVcrAndRefresh(IResource dvResource) throws VfsException {
        this.setActiveVersion(null);
        this.setSyncedVersion(null);
        if (this.isMounted()) {
            this.getSyncDB().removeEntry(this.getLocalPath());
        }
        if (dvResource == VfsFolderItem.NULL_DELTAV_RESOURCE) {
            this.setVcrResource(null);
        } else {
            this.setVcrResource(dvResource);
        }
        this.refreshLocationState();
    }

    private void refreshFolderItemWithDifferentLocation(IResource resource) throws VfsException {
        if (resource == VfsFolderItem.NULL_DELTAV_RESOURCE) {
            if (this.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_FORMER || this.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_LATEST || this.getLocationState() == VfsFolderItemLocationState.MOUNTED) {
                this.setVcrResource(this.createDeletedVcrResource());
                this.refreshLocationState();
                return;
            }
            if (this.getLocationState() == VfsFolderItemLocationState.DELETED) {
                if (this.getLocalFile().exists()) {
                    this.takeOverDvVcrAndRefresh(resource);
                } else {
                    LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception("Internal info: got different location for not-existing DeltaV resource and folder item with location state " + this.getLocationState() + ": " + this.getBrowsePath()), (boolean)true);
                }
                return;
            }
            this.setVcrResource(null);
            this.refreshLocationState();
            return;
        }
        if (resource == VfsFolderItem.KEEP_DELTAV_RESOURCE) {
            LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception("Internal info: got different location for unknown (KEEP) DeltaV resource and folder item with location state " + this.getLocationState() + ": " + this.getBrowsePath()), (boolean)true);
            this.setVcrResource(resource);
            this.refreshLocationState();
            return;
        }
        if (this.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) {
            if (this.asFolder() != null) {
                if (this.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                    this.setVcrResource(resource);
                    this.refreshLocationState();
                }
                return;
            }
        } else {
            LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception("Internal info: got different location for existing DeltaV resource and folder item with location state " + this.getLocationState() + ": " + this.getBrowsePath()), (boolean)true);
            this.setVcrResource(resource);
            this.refreshLocationState();
            return;
        }
        if (!this.getLocalFile().exists()) {
            if (this.hasLocalRemoteNameClash()) {
                this.setDvLocalRemoteNameClashVcr(null);
            }
            this.setVcrResource(resource);
            this.refreshLocationState();
        } else {
            try {
                this.setDvLocalRemoteNameClashVcr(resource.getAsVersionControlled());
            }
            catch (VcmFailure vcmFailure) {
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this.getLocalPath(), "Internal error: get resource type of DeltaV resource failed (server response: " + vcmFailure.getMessage() + ")");
                throw new VfsException("Internal error: get resource type of DeltaV resource failed: " + this.getLocalPath());
            }
        }
    }

    SyncEntry getOrReconstructSyncDBEntry() throws VfsException {
        SyncEntry syncEntry;
        SyncDB syncDB = this.getSyncDB();
        SyncEntry syncEntry2 = syncEntry = syncDB == null ? null : syncDB.getEntry(this.getLocalPath());
        if (syncEntry == null && syncDB != null) {
            syncEntry = this.reconstructSyncDBEntry(syncDB);
        }
        return syncEntry;
    }

    static SyncEntry getOrReconstructSyncDBEntry(IVfsContext context, IVirtualFile localFile, IResource dvVcrResource, IWorkingResource dvWorkingResource, ICreatedResource dvNewResource, VfsWorkspace workspace) throws VfsException {
        SyncEntry syncEntry;
        SyncDB syncDB = context.getSyncDb(localFile.getAbsolutePath());
        SyncEntry syncEntry2 = syncEntry = syncDB == null ? null : syncDB.getEntry(localFile.getAbsolutePath());
        if (syncEntry == null && syncDB != null) {
            syncEntry = VfsActivityRecordedFolderItem.reconstructSyncDBEntry(syncDB, localFile, dvVcrResource, dvWorkingResource, dvNewResource, workspace);
        } else if ((syncEntry = VfsActivityRecordedFolderItem.checkAndRepairSyncDBEntry(syncEntry, localFile, dvVcrResource, dvWorkingResource, dvNewResource, workspace)) == null) {
            if (syncDB != null) {
                syncDB.removeEntry(localFile.getAbsolutePath());
            } else {
                new VfsException("syncDB is null");
            }
        }
        return syncEntry;
    }

    private static SyncEntry checkAndRepairSyncDBEntry(SyncEntry syncEntry, IVirtualFile localFile, IResource dvVcrResource, IWorkingResource dvWorkingResource, ICreatedResource dvNewResource, VfsWorkspace workspace) throws VfsException {
        SyncEntry checkedSyncEntry = syncEntry;
        if (dvWorkingResource == null && dvNewResource == null) {
            if (syncEntry.isUploaded()) {
                syncEntry.resetUploadTimestamp();
                LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception("Reset upload timestamp in syncDB entry for folder item that is not checked out: " + localFile.getAbsolutePath()), (boolean)false);
            }
            if (!syncEntry.isSynced() && dvVcrResource != null) {
                if (localFile.isDirectory()) {
                    VfsActivityRecordedFolderItem.reconstructSyncDataInSyncEntry(syncEntry, dvVcrResource);
                    LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception("Reconstructed missed sync data in syncDB entry for folder that locally and remote exists: " + localFile.getAbsolutePath()), (boolean)false);
                }
                if (localFile.isFile()) {
                    LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception("Reconstructed dummy sync data in syncDB entry for file that locally and remote exists: " + localFile.getAbsolutePath()), (boolean)false);
                    VfsActivityRecordedFolderItem.setDummySyncDataInSyncEntry(syncEntry);
                }
                checkedSyncEntry = null;
            }
        } else {
            try {
                if (syncEntry.isUploaded()) {
                    if (dvWorkingResource != null && dvWorkingResource.markedForDeletion()) {
                        syncEntry.resetUploadTimestamp();
                        LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception("Reset upload timestamp in syncDB entry for folder item that is checked out for delete: " + localFile.getAbsolutePath()), (boolean)false);
                    }
                } else if (dvWorkingResource == null || !dvWorkingResource.markedForDeletion()) {
                    VfsActivityRecordedFolderItem.reconstructUploadDataInSyncEntry(syncEntry);
                    LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception("Reconstructed missed upload timestamp in syncDB entry for folder item that is checked out: " + localFile.getAbsolutePath()), (boolean)false);
                }
                if (syncEntry.isSynced()) {
                    if (dvNewResource != null) {
                        syncEntry.resetSyncData();
                        LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception("Reset sync data in syncDB entry for folder item that is checked out for create: " + localFile.getAbsolutePath()), (boolean)true);
                    }
                } else if (dvWorkingResource != null) {
                    VfsActivityRecordedFolderItem.reconstructSyncDataInSyncEntry(syncEntry, dvVcrResource, dvWorkingResource, workspace);
                    LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception("Reconstructed missed sync data in syncDB entry for folder item that is checked out: " + localFile.getAbsolutePath()), (boolean)false);
                }
            }
            catch (VcmFailure vcmFailure) {
                LogUtil.infoLogException((Location)LOCATION, (Throwable)vcmFailure, (boolean)false);
                LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception("Reconstruction of invalid SyncDB entry failed because get workspace of DeltaV working resource failed"), (boolean)false);
            }
        }
        return checkedSyncEntry;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SyncEntry reconstructSyncDBEntry(SyncDB syncDB, IVirtualFile localFile, IResource dvVcrResource, IWorkingResource dvWorkingResource, ICreatedResource dvNewResource, VfsWorkspace workspace) throws VfsException {
        SyncEntry syncEntry;
        IResource resourceWithObjectId = dvVcrResource != null ? dvVcrResource : (dvWorkingResource != null ? dvWorkingResource : (dvNewResource != null ? dvNewResource : (IResource)null));
        try {
            syncEntry = syncDB.createEntry(localFile.getAbsolutePath(), resourceWithObjectId.getXCMObjectId());
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
            syncEntry = syncDB.createEntry(localFile.getAbsolutePath(), "UNKNOWN_OBJECT_ID");
        }
        if (dvWorkingResource == null && dvNewResource == null) {
            if (dvVcrResource == null) {
                new VfsException("Internal error: can not recreate SyncDB entry for folder item which has no DeltaV resource and is not checked out for create").printStackTrace();
                return null;
            }
            VfsActivityRecordedFolderItem.reconstructSyncDataInSyncEntry(syncEntry, dvVcrResource);
        } else {
            try {
                if (dvWorkingResource == null || !dvWorkingResource.markedForDeletion()) {
                    VfsActivityRecordedFolderItem.reconstructUploadDataInSyncEntry(syncEntry);
                }
                if (dvWorkingResource != null) {
                    VfsActivityRecordedFolderItem.reconstructSyncDataInSyncEntry(syncEntry, dvVcrResource, dvWorkingResource, workspace);
                }
            }
            catch (VcmFailure vcmFailure) {
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.WARN_LOG, localFile, "Reconstruction of missed SyncDB entry failed because get workspace of DeltaV working resource failed (server response: " + vcmFailure.getMessage() + ")");
                throw new VfsException("Reconstruction of missed SyncDB entry failed because get workspace of DeltaV working resource failed", vcmFailure);
            }
            catch (VfsException e) {
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.WARN_LOG, localFile, e.getMessage());
                throw e;
            }
        }
        VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.INFO_LOG, localFile, "Reconstructed missed SyncDB entry");
        return syncEntry;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    SyncEntry reconstructSyncDBEntry(SyncDB syncDB) throws VfsException {
        try {
            SyncEntry syncEntry = syncDB.createEntry(this.getLocalPath(), this.getObjectID());
            if (this.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                if (this.getVcrResource() == null) {
                    new VfsException("Internal error: can not recreate SyncDB entry for folder item which has no DeltaV resource and is not checked out for create").printStackTrace();
                    return null;
                }
                VfsActivityRecordedFolderItem.reconstructSyncDataInSyncEntry(syncEntry, this.getVcrResource());
            } else {
                VfsActivityRecordedFolderItem.reconstructUploadDataInSyncEntry(syncEntry);
                if (this.getActivityState() != VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE) {
                    VfsActivityRecordedFolderItem.reconstructSyncDataInSyncEntry(syncEntry, this.getVcrResource(), this.getDvWorkingResource(), (VfsWorkspace)this.getWorkspace());
                }
            }
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.INFO_LOG, this, "Reconstructed missed SyncDB entry");
            return syncEntry;
        }
        catch (VfsException e) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.WARN_LOG, this, e.getMessage());
            throw e;
        }
    }

    private static void reconstructUploadDataInSyncEntry(SyncEntry syncEntry) {
        syncEntry.setLocalUploadTime(1L);
    }

    static void setDummySyncDataInSyncEntry(SyncEntry syncEntry) {
        syncEntry.setVersionUrlAndRemoteSyncTime("UNKNOWN_VERSION_URL", 1L);
        LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception("Reconstructed dummy entries for missed sync data in Sync Entry" + syncEntry.getAbsoluteLocalPath()), (boolean)false);
    }

    private static void reconstructSyncDataInSyncEntry(SyncEntry syncEntry, IResource dvVcrResource) throws VfsException {
        try {
            syncEntry.setVersionUrlAndRemoteSyncTime(dvVcrResource.getAsVersionControlled().getActiveVersion().getPersistentURL(), dvVcrResource.lastModified().getTime());
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Reconstruct SyncDB entry failed, because get active version of DeltaV resource failed (server response: " + vcmFailure.getMessage() + ")", vcmFailure);
        }
    }

    private static void reconstructSyncDataInSyncEntry(SyncEntry syncEntry, IResource dvVcrResource, IWorkingResource dvWorkingResource, VfsWorkspace workspace) throws VfsException {
        try {
            IVersion dvSyncedPredecessor = VfsVersionHistory.preliminary__getLatestPredecessor(dvWorkingResource, workspace);
            VfsVersion syncedPredecessor = new VfsVersion(workspace.getVfsManager(), dvSyncedPredecessor);
            long lastModified = dvVcrResource != null && dvVcrResource.getAsVersionControlled().getActiveVersion().getXCMObjectId() == syncedPredecessor.getObjectID() ? dvVcrResource.lastModified().getTime() : syncedPredecessor.getLastModifiedDate().getTime();
            syncEntry.setVersionUrlAndRemoteSyncTime(syncedPredecessor.getUrl(), lastModified);
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Reconstructing SyncDB entry failed because accessing DeltaV version failed (server response: " + vcmFailure.getMessage() + ")", vcmFailure);
        }
    }

    public boolean isReleased() {
        return this.m_workspace.isReleased() || this.isInvalid();
    }

    static boolean isDvResourceDeleted(IResource dvResource) {
        String deletedValue = null;
        try {
            IProperty deletedProperty = dvResource == null ? null : dvResource.getProperty(VfsXcmProperty.DELETED.getCompletePropertyName());
            deletedValue = deletedProperty == null ? null : deletedProperty.getValue();
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)vcmFailure);
        }
        return deletedValue != null && deletedValue.equals("T");
    }

    public boolean isInconsistent() {
        this.getVfsManager().checkState();
        return !this.isMounted() && this.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT;
    }

    public VfsException getCauseOfInconsistency() {
        this.getVfsManager().checkState();
        return null;
    }

    void refreshForMountPointDeletion() throws VfsException {
        if (this.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            throw new VfsException("Mount point cannot be deleted because resource below is " + this.getActivityState().getText() + ":  " + this.getIdentifyingString());
        }
        if (this.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) {
            if (this.m_dvLocalRemoteNameClashVcr == null) {
                this.m_localFile = null;
                this.m_locationState = VfsFolderItemLocationState.INVALID;
                return;
            }
            this.m_dvVcr = this.m_dvLocalRemoteNameClashVcr;
            this.m_dvLocalRemoteNameClashVcr = null;
        }
        super.refreshForMountPointDeletion();
        this.setSyncedVersion(null);
        this.replaceDvVcrByReplacingVcr();
    }

    public boolean isInvalid() {
        return this.getLocationState() == VfsFolderItemLocationState.INVALID;
    }

    void checkIsInvalid() throws VfsException {
        this.getVfsManager().checkState();
        if (this.isInvalid()) {
            throw new IllegalStateException("Mount Point for local only folder item was removed");
        }
    }

    static boolean shouldFolderItemBeInvalidDueToMountPointDeletion(IVfsFolderItem folderItem) {
        return folderItem != null && (folderItem.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY ? folderItem.asFile() == null || !folderItem.asFile().hasLocalRemoteNameClash() : folderItem.getLocationState() == VfsFolderItemLocationState.INVALID);
    }

    void checkDiscardTargetVersionInOpenActivities(VfsActionType actionType) throws VfsException {
        IVfsFile file = this.asFile();
        if (file != null) {
            IVfsActivity[] activities = this.getWorkspace().getActivities(VfsActivityState.OPEN);
            int i = 0;
            while (i < activities.length) {
                try {
                    ((VfsActivity)activities[i]).checkPreconditionConcerningCollisionResolving(file);
                }
                catch (VfsException x) {
                    VfsException e = new VfsException("Not allowed: " + x.getMessage());
                    VfsActionRecorder.log(actionType, VfsActionStatus.FAILED, this, e.getMessage());
                    throw e;
                }
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ActionOnLocalDisc {
        static final ActionOnLocalDisc REMOVE_FILE_FROM_CLIENT = new ActionOnLocalDisc("remove file");
        static final ActionOnLocalDisc RESYNC_CHECKED_OUT_FILE_VERSION = new ActionOnLocalDisc("resync checked out file version");
        static final ActionOnLocalDisc DONT_CHANGE_FILE_CONTENT = new ActionOnLocalDisc("dont change file content");
        private String m_action;

        private ActionOnLocalDisc(String action) {
            this.m_action = action;
        }
    }
}

