/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityElement;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsProperty;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivity;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolderItem;
import java.util.Date;
import java.util.Map;

final class VfsActivityElement
implements IVfsActivityElement {
    private boolean _invalid;
    private IVfsActivityRecordedFolderItem _folderItem;
    private IVfsVersion _version;
    private IVfsActivity _activity;

    VfsActivityElement(IVfsActivityRecordedFolderItem folderItem) {
        this._folderItem = folderItem;
    }

    VfsActivityElement(IVfsVersion version, IVfsActivity activity) throws VfsException {
        this._version = version;
        this._activity = activity;
    }

    public IVfsActivityRecordedFolderItem getAsActivityRecordedFolderItem() {
        return this._folderItem;
    }

    public IVfsVersion getAsVersion() {
        return this._version;
    }

    String getKeyForActivityCache() {
        if (this.getAsActivityRecordedFolderItem() != null) {
            return this.getAsActivityRecordedFolderItem().getAbsoluteRemotePath();
        }
        if (this.getAsVersion() != null) {
            return this.getAsVersion().getUrl();
        }
        return null;
    }

    public String getAuthor() throws VfsException {
        if (this.getAsActivityRecordedFolderItem() != null) {
            return this.getAsActivityRecordedFolderItem().getAuthor();
        }
        if (this.getAsVersion() != null) {
            return this.getAsVersion().getAuthor();
        }
        return null;
    }

    public Date getLastModifiedDate() throws VfsException {
        if (this.getAsActivityRecordedFolderItem() != null) {
            return this.getAsActivityRecordedFolderItem().getLastModifiedDate();
        }
        if (this.getAsVersion() != null) {
            return this.getAsVersion().getLastModifiedDate();
        }
        return null;
    }

    public String getLastModifier() {
        if (this.getAsActivityRecordedFolderItem() != null) {
            return this.getAsActivityRecordedFolderItem().getLastModifier();
        }
        if (this.getAsVersion() != null) {
            return this.getAsVersion().getLastModifier();
        }
        return null;
    }

    public String getWorkspaceRelativePath() {
        if (this.getAsActivityRecordedFolderItem() != null) {
            return this.getAsActivityRecordedFolderItem().getWorkspaceRelativePath();
        }
        if (this.getAsVersion() != null) {
            return this.getAsVersion().getWorkspaceRelativePath();
        }
        return null;
    }

    public boolean isDeleted() {
        if (this.getAsActivityRecordedFolderItem() != null) {
            return this.getAsActivityRecordedFolderItem().isDeleted();
        }
        if (this.getAsVersion() != null) {
            return this.getAsVersion().isDeleted();
        }
        return false;
    }

    public IVfsProperty[] getAllProperties() throws VfsException {
        if (this.getAsActivityRecordedFolderItem() != null) {
            return this.getAsActivityRecordedFolderItem().getAllProperties();
        }
        if (this.getAsVersion() != null) {
            return this.getAsVersion().getAllProperties();
        }
        return null;
    }

    public IVfsProperty getProperty(String propertyName) throws VfsException {
        if (this.getAsActivityRecordedFolderItem() != null) {
            return this.getAsActivityRecordedFolderItem().getProperty(propertyName);
        }
        if (this.getAsVersion() != null) {
            return this.getAsVersion().getProperty(propertyName);
        }
        return null;
    }

    public Map getProperties(String[] propertyNames) throws VfsException {
        if (this.getAsActivityRecordedFolderItem() != null) {
            return this.getAsActivityRecordedFolderItem().getProperties(propertyNames);
        }
        if (this.getAsVersion() != null) {
            return this.getAsVersion().getProperties(propertyNames);
        }
        return null;
    }

    public String getUrl() throws VfsException {
        if (this.getAsActivityRecordedFolderItem() != null) {
            return this.getAsActivityRecordedFolderItem().getUrl();
        }
        if (this.getAsVersion() != null) {
            return this.getAsVersion().getUrl();
        }
        return null;
    }

    void setActivity(IVfsActivity activity) {
        this._activity = activity;
    }

    public IVfsActivity[] getActivities() {
        if (this.getAsActivityRecordedFolderItem() != null) {
            return this.getAsActivityRecordedFolderItem().getOpenActivities();
        }
        if (this.getAsVersion() != null) {
            return new IVfsActivity[]{this._activity};
        }
        return null;
    }

    public IVfsWorkspace getWorkspace() {
        if (this.getAsActivityRecordedFolderItem() != null) {
            return this.getAsActivityRecordedFolderItem().getWorkspace();
        }
        IVfsActivity[] activities = this.getActivities();
        if (activities != null && activities[0] != null) {
            return activities[0].getWorkspace();
        }
        return null;
    }

    public String getWorkspaceUrl() throws VfsException {
        if (this.getAsActivityRecordedFolderItem() != null) {
            return this.getAsActivityRecordedFolderItem().getWorkspace().getUrl();
        }
        IVfsActivity[] activities = this.getActivities();
        if (activities != null && activities[0] != null) {
            return activities[0].getWorkspaceUrl();
        }
        return null;
    }

    void setVersion(IVfsVersion version) {
        this._version = version;
    }

    void setFolderItem(IVfsActivityRecordedFolderItem folderItem) {
        this._folderItem = folderItem;
    }

    public boolean isInvalid() {
        try {
            this.checkInvalid();
        }
        catch (IllegalStateException e) {
            return true;
        }
        return false;
    }

    void setInvalid(boolean invalid) {
        this._invalid = invalid;
    }

    private void checkInvalid() {
        if (!this._invalid) {
            IVfsActivityRecordedFolderItem folderItem = this.getAsActivityRecordedFolderItem();
            if (folderItem != null) {
                ((VfsFolderItem)((Object)folderItem)).getVfsManager().checkState();
            } else {
                IVfsVersion version = this.getAsVersion();
                if (version != null) {
                    ((VfsActivity)this._activity).getVfsManager().checkState();
                }
            }
        } else {
            throw new IllegalStateException("Activity element " + this.getKeyForActivityCache() + "was reverted.");
        }
    }

    public Object[] getChildrenObjects() throws VfsException {
        if (this.getAsActivityRecordedFolderItem() != null) {
            return this.getAsActivityRecordedFolderItem().getChildrenObjects();
        }
        return this.getAsVersion().getChildrenObjects();
    }
}

