/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.IActivity;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.IVersion;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.IWorkingResource;
import com.tssap.dtr.client.lib.deltavlib.IWorkspace;
import com.tssap.dtr.client.lib.deltavlib.PathEncodingFlag;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.PropertyFactoryAccess;
import com.tssap.dtr.client.lib.deltavlib.factory.ResourceFactoryManager;
import com.tssap.dtr.client.lib.deltavlib.properties.Converter;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.IMutableElement;
import com.tssap.dtr.client.lib.deltavlib.properties.IMutableProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyCacheControl;
import com.tssap.dtr.client.lib.deltavlib.xcm.ActivityCompositeDef;
import com.tssap.dtr.client.lib.deltavlib.xcm.ActivityReportFactory;
import com.tssap.dtr.client.lib.deltavlib.xcm.CollisionType;
import com.tssap.dtr.client.lib.deltavlib.xcm.EIntegrateOption;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityComposite;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityContent;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityQuery;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityReport;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICheckinCollision;
import com.tssap.dtr.client.lib.deltavlib.xcm.IClosedResource;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICreatedResource;
import com.tssap.dtr.client.lib.deltavlib.xcm.IIntegrateCollision;
import com.tssap.dtr.client.lib.deltavlib.xcm.IIntegration;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.exceptions.ExceptionSeverity;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.EnvironmentVariables;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.util.StringUtilities;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityElement;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsCheckinCollision;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsPropagationList;
import com.tssap.dtr.client.lib.vfs.IVfsProperty;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionOnActivity;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsExceptionCategory;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.VfsIntegrationMode;
import com.tssap.dtr.client.lib.vfs.VfsRuntimeException;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.impl.PropertiesFeature;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivityElement;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsCheckinCollision;
import com.tssap.dtr.client.lib.vfs.impl.VfsFile;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.impl.VfsListenerHandler;
import com.tssap.dtr.client.lib.vfs.impl.VfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.impl.VfsRepository;
import com.tssap.dtr.client.lib.vfs.impl.VfsRepositoryOptions;
import com.tssap.dtr.client.lib.vfs.impl.VfsSpecialPaths;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersion;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspace;
import com.tssap.dtr.client.lib.vfs.impl.VfsXcmClientProperty;
import com.tssap.dtr.client.lib.vfs.impl.VfsXcmProperty;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncDB;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;

final class VfsActivity
implements IVfsActivity,
IVfsPropagationList {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$VfsActivity == null ? (class$com$tssap$dtr$client$lib$vfs$impl$VfsActivity = VfsActivity.class$("com.tssap.dtr.client.lib.vfs.impl.VfsActivity")) : class$com$tssap$dtr$client$lib$vfs$impl$VfsActivity));
    static final boolean INITIALIZED = true;
    static final boolean NOT_INITIALIZED = false;
    static final String UNKNOWN_REPOSITORY_NAME = "unknown repository name";
    static final String UNKNOWN_REPOSITORY_ID = "unknown repository ID";
    static final boolean DONT_RETURN_PROPAGATION_LISTS = false;
    static final boolean RETURN_PROPAGATION_LISTS = true;
    static final boolean CONTAINING_ALSO_FILES = true;
    static final boolean NOT_CONTAINING_ALSO_FILES = false;
    static final boolean WITHOUT_PROPAGATION_REQUEST_ID = true;
    static final boolean NO_CONDITION_FOR_PROPAGATION_REQUEST_ID = false;
    static final String[] EMPTY_PROPERTIES_ARRAY = new String[0];
    private VersionedFileSystemManager m_vfsManager = null;
    private boolean m_isInvalid = false;
    private IActivity m_dvActivity = null;
    private HashMap m_activityElements = new HashMap();
    private HashMap m_integrationSet = new HashMap();
    private VfsRepository m_repository = null;
    private VfsWorkspace[] m_workspaceSet = new VfsWorkspace[1];
    private IWorkspace m_invisibleWorkspace;
    static final ActivityCompositeDef CLOSED_ACTIVITY_COMPOSITE_DEF;
    static final ActivityCompositeDef OPEN_ACTIVITY_COMPOSITE_DEF;
    static final ActivityCompositeDef EMPTY_ACTIVITY_COMPOSITE_DEF;
    static final boolean PUT_CHANGED_FILE_CONTENT = true;
    static final boolean DONT_PUT_CHANGED_FILE_CONTENT = false;
    static final String[] EMPTY_STRING_ARRAY;
    static final IVfsWorkspace[] EMPTY_WORKSPACE_ARRAY;
    static final IWorkspace[] EMPTY_DV_WORKSPACE_ARRAY;
    static final IVfsActivity[] EMPTY_ACTIVITY_ARRAY;
    private static final IVfsActivityRecordedFolderItem[] EMPTY_OPEN_ACTIVITY_ITEMS;
    private static final IVfsVersion[] EMPTY_CLOSED_ACTIVITY_ITEMS;
    private static final IVfsActivityElement[] EMPTY_ACTIVITY_ELEMENTS;
    private static final IVfsCheckinCollision[] EMPTY_CHECKIN_COLLISIONS;
    private static final VfsActionOnActivity[] EMPTY_ACTIONS_ARRAY;
    static final String[] DEFAULT_ACTIVITY_PROPERTY_NAME_ARRAY;
    static final String DEFAULT_ACTIVITY_PROPERTY_NAME;
    static final IProperty[] DEFAULT_ACTIVITY_PROPERTY_ARRAY;
    static final String EMPTY_NAME = "";
    private static final boolean DONT_SPECIAL_MANGLING_OF_FIRST_CHARACTER = false;
    private static final String[] hexValuesOfCharacters;
    static final String ACTIVITY_NAME_PREFIX = "act";
    static final String DEFAULT_ACTIVITY_NAME_PREFIX = "default";
    static final String DELETION_ACTIVITY_NAME_PREFIX = "default_hierarchical_deletion";
    static final String DISCARD_ACTIVITY_NAME_PREFIX = "default_immediate_discard";
    static final String NAMECLASH_ACTIVITY_NAME_PREFIX = "default_nameclash_deletion";
    static final String UNDELETION_ACTIVITY_NAME_PREFIX = "default_integratecollision_undeletion";
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$VfsActivity;

    VfsActivity(VfsRepository repository, IActivity dvActivity) {
        this.m_dvActivity = dvActivity;
        this.m_repository = repository;
        this.m_vfsManager = repository.getVersionedFileSystemManager();
    }

    VfsRepository getRepository() {
        return this.m_repository;
    }

    static void checkActivityName(String name, boolean loggingOn) throws VfsException {
        char firstCharacter = name.charAt(0);
        if (!('a' <= firstCharacter && firstCharacter <= 'z' || 'A' <= firstCharacter && firstCharacter <= 'Z' || firstCharacter == '_')) {
            if (loggingOn) {
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, null, "The activity name is invalid (must start with US-ASCII letter or '_'): " + name);
            }
            throw new VfsException("The activity name is invalid (must only start with US-ASCII letter or '_')");
        }
        int i = 1;
        while (i < name.length()) {
            char currentCharacter = name.charAt(i);
            if (!('a' <= currentCharacter && currentCharacter <= 'z' || 'A' <= currentCharacter && currentCharacter <= 'Z' || '0' <= currentCharacter && currentCharacter <= '9' || currentCharacter == '_' || currentCharacter == ' ')) {
                if (loggingOn) {
                    VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, null, "The activity name is invalid (must only contain US-ASCII letters, digits and '_', ' '): " + name);
                }
                throw new VfsException("The activity name is invalid (must only contain US-ASCII letters, digits and '_', ' ')");
            }
            ++i;
        }
    }

    private static String mangleActivityName(String name, boolean specialManglingOfFirstCharacter) {
        StringBuffer mangledActivityName = new StringBuffer(name.length());
        int nextCharacterIndex = 0;
        if (specialManglingOfFirstCharacter) {
            char firstCharacter = name.charAt(nextCharacterIndex);
            if (!('a' <= firstCharacter && firstCharacter <= 'z' || 'A' <= firstCharacter && firstCharacter <= 'Z' || firstCharacter == '_')) {
                mangledActivityName.append("_FC_");
            } else {
                mangledActivityName.append(firstCharacter);
                ++nextCharacterIndex;
            }
        }
        while (nextCharacterIndex < name.length()) {
            char currentCharacter = name.charAt(nextCharacterIndex);
            if (!('a' <= currentCharacter && currentCharacter <= 'z' || 'A' <= currentCharacter && currentCharacter <= 'Z' || '0' <= currentCharacter && currentCharacter <= '9' || currentCharacter == '_' || currentCharacter == ' ')) {
                mangledActivityName.append(hexValuesOfCharacters[currentCharacter]);
            } else {
                mangledActivityName.append(currentCharacter);
            }
            ++nextCharacterIndex;
        }
        return mangledActivityName.toString();
    }

    static String mangleUserName(String userName) {
        return VfsActivity.mangleActivityName(userName, false);
    }

    static String mangleRemotePath(String absoluteRemotePath) {
        int begin = absoluteRemotePath.charAt(0) == '/' ? 1 : 0;
        int end = absoluteRemotePath.charAt(absoluteRemotePath.length() - 1) == '/' ? absoluteRemotePath.length() - 1 : absoluteRemotePath.length();
        int len = end - begin;
        char[] pathWithoutLeadingAndTrailingSlash = new char[len];
        absoluteRemotePath.getChars(begin, end, pathWithoutLeadingAndTrailingSlash, 0);
        StringBuffer pathWithReplacedSlashes = new StringBuffer(len);
        pathWithReplacedSlashes.insert(0, pathWithoutLeadingAndTrailingSlash);
        int i = 0;
        while (i < pathWithReplacedSlashes.length()) {
            if (pathWithReplacedSlashes.charAt(i) == '/') {
                pathWithReplacedSlashes.setCharAt(i, '_');
            }
            ++i;
        }
        return VfsActivity.mangleActivityName(pathWithReplacedSlashes.toString(), false);
    }

    static String generateNameForActivityInWorkspace(IVfsWorkspace workspace) {
        return VfsActivity.generateNameForActivityInWorkspace(workspace, ACTIVITY_NAME_PREFIX);
    }

    static String generateNameForDefaultActivityInWorkspace(IVfsWorkspace workspace) {
        return VfsActivity.generateNameForActivityInWorkspace(workspace, DEFAULT_ACTIVITY_NAME_PREFIX);
    }

    static String generateNameForActivityInWorkspace(IVfsWorkspace workspace, String prefix) {
        String userName = VfsActivity.mangleUserName(workspace.getContext().getUserName(((VfsWorkspace)workspace).getConnectionTemplateId()));
        String currentTime = VfsActivity.getCurrentTimeInActivityFormat();
        String workspacePath = null;
        try {
            workspacePath = VfsActivity.mangleRemotePath(workspace.getBrowsePath());
        }
        catch (VfsException e) {
            LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
            workspacePath = VfsActivity.mangleRemotePath(workspace.getAbsoluteRemotePath());
        }
        if (prefix.length() + workspacePath.length() + userName.length() + currentTime.length() + 9 + 37 > 255) {
            workspacePath = VfsActivity.mangleActivityName(workspace.getName(), false);
        }
        return prefix + "_w_" + workspacePath + "_u_" + userName + "_t_" + currentTime;
    }

    public void setDisplayName(String displayName) throws VfsException {
        this.checkState();
        try {
            VfsWorkspace workspace = (VfsWorkspace)this.getWorkspace();
            if (workspace != null) {
                workspace.checkIsModifiable();
            }
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Changing activity is not allowed because workspace folder is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        if (displayName == null) {
            displayName = EMPTY_NAME;
        }
        try {
            this.m_dvActivity.setDisplayName(displayName);
            this.getVfsManager().fireEventActivityNameOrDescriptionChanged(this);
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Setting display name failed: " + vcmFailure.getMessage(), vcmFailure);
        }
    }

    public String getDisplayName() throws VfsException {
        this.getVfsManager().checkState();
        try {
            return this.m_dvActivity.getDisplayName();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting display name failed.", vcmFailure);
        }
    }

    public String getName() {
        this.getVfsManager().checkState();
        return this.m_dvActivity.getName();
    }

    String getIdentifyingString() {
        return VfsActivity.getIdentifyingString(this.getDeltaVActivity());
    }

    static String getIdentifyingString(IActivity dvActivity) {
        try {
            return dvActivity.getDisplayName() == null ? dvActivity.getName() : dvActivity.getDisplayName() + " ( " + dvActivity.getName() + " ) ";
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)vcmFailure, (int)500);
            return dvActivity.getName();
        }
    }

    public String getAbsoluteRemotePath() {
        this.checkState();
        return this.m_dvActivity.getDecodedPath();
    }

    public String getUrl() {
        this.checkState();
        return this.m_dvActivity.getPersistentURL();
    }

    public void setDescription(String description) throws VfsException {
        this.checkState();
        try {
            VfsWorkspace workspace = (VfsWorkspace)this.getWorkspace();
            if (workspace != null) {
                workspace.checkIsModifiable();
            }
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Changing activity is not allowed because workspace folder is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        if (!this.isOpen()) {
            throw new VfsException("Activity is not open: " + this.getIdentifyingString());
        }
        try {
            this.m_dvActivity.setComment(description);
            this.getVfsManager().fireEventActivityNameOrDescriptionChanged(this);
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Setting description failed.", vcmFailure);
        }
    }

    public String getDescription() throws VfsException {
        this.checkState();
        try {
            return this.m_dvActivity.getComment();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting description failed.", vcmFailure);
        }
    }

    public void delete() throws VfsException {
        this.checkState();
        try {
            VfsWorkspace workspace = (VfsWorkspace)this.getWorkspace();
            if (workspace != null) {
                workspace.checkIsModifiable();
            }
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Deleting activity is not allowed because workspace folder is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        if (this.isPropagationList()) {
            throw new IllegalStateException("Internal error: Found activity that actually is propagation list: " + this.getIdentifyingString());
        }
        String activityString = null;
        activityString = this.getIdentifyingString();
        if (!this.isEmpty()) {
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, "Activity is not empty");
            throw new VfsException("Activity is not empty");
        }
        VfsActivityState oldState = this.isOpen() ? VfsActivityState.OPEN : VfsActivityState.CLOSED;
        try {
            this.m_dvActivity.remove();
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.SUCCEEDED, this, "Deleted activity");
        }
        catch (VcmFailure vcmFailure) {
            VfsActionRecorder.log(VfsActionType.DELETE, VfsActionStatus.FAILED, this, "Deleting activity failed: " + activityString);
            throw new VfsException("Deleting activity failed.", vcmFailure);
        }
        this.refreshStateAfterDelete();
        this.getVfsManager().fireEventActivityDeleted(this, oldState);
    }

    private void refreshStateAfterDelete() {
        this.getRepository().removeEmptyActivity(this);
        this.setInvalid();
    }

    private void checkState() {
        this.getVfsManager().checkState();
        if (this.isInvalid()) {
            throw new IllegalStateException("Activity was already deleted");
        }
        if (this.m_dvActivity == null) {
            throw new IllegalStateException("Internal error: no DeltaV activity available");
        }
    }

    private void checkParameterState(IVfsWorkspace workspace) {
        if (workspace.getVersionedFileSystemManager() != this.getVersionedFileSystemManager()) {
            throw new IllegalArgumentException("Internal error: parameter with different versioned file system manager");
        }
    }

    public boolean isInvalid() {
        return this.m_isInvalid;
    }

    private void setInvalid() {
        this.m_isInvalid = true;
    }

    public boolean isReleased() {
        return this.m_vfsManager == null || this.m_vfsManager.isReleased();
    }

    public boolean containsOnlyFolders() throws VfsException {
        if (this.isOpen()) {
            IVfsActivityRecordedFolderItem[] activityElements = this.getElementsFromOpenActivity();
            int i = 0;
            while (i < activityElements.length) {
                IVfsActivityRecordedFolderItem activityElement = activityElements[i];
                if (activityElement.asFile() != null) {
                    return false;
                }
                ++i;
            }
        } else {
            IVfsVersion[] activityElements = this.getElementsFromClosedActivity();
            int i = 0;
            while (i < activityElements.length) {
                IVfsVersion activityElement = activityElements[i];
                if (activityElement.isFile()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public VfsActionOnActivity[] getActionsForCurrentState() throws VfsException {
        this.checkState();
        ArrayList<VfsActionOnActivity> actions = new ArrayList<VfsActionOnActivity>();
        actions.add(VfsActionOnActivity.HANDLE_PROPERTIES);
        actions.add(VfsActionOnActivity.REFRESH);
        if (this.isOpen()) {
            if (this.getWorkspace() != null && this.getWorkspace().isModifiable()) {
                if (this.isPropagationList()) {
                    return actions.toArray(EMPTY_ACTIONS_ARRAY);
                }
                if (this.isEmpty()) {
                    actions.add(VfsActionOnActivity.DELETE);
                } else {
                    actions.add(VfsActionOnActivity.CHECKIN);
                    actions.add(VfsActionOnActivity.UNCHECKOUT);
                    actions.add(VfsActionOnActivity.UNCHECKOUT_UNCHANGED_ITEMS);
                    actions.add(VfsActionOnActivity.UPLOAD);
                    actions.add(VfsActionOnActivity.FORCE_UPLOAD);
                    actions.add(VfsActionOnActivity.DOWNLOAD);
                    actions.add(VfsActionOnActivity.FORCE_DOWNLOAD);
                }
            }
        } else {
            actions.add(VfsActionOnActivity.INTEGRATE);
            actions.add(VfsActionOnActivity.ACTIVATE);
            actions.add(VfsActionOnActivity.CONSOLIDATE);
        }
        return actions.toArray(EMPTY_ACTIONS_ARRAY);
    }

    public boolean isCurrentActivity() {
        this.checkState();
        if (this == this.getWorkspace().getCurrentActivity()) {
            try {
                if (!this.isOpen()) {
                    ((VfsWorkspace)this.getWorkspace()).setCurrentActivity(null);
                    return false;
                }
            }
            catch (VfsException e) {
                LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
            }
            return true;
        }
        return false;
    }

    public boolean isDefaultActivity() throws VfsException {
        this.checkState();
        VfsWorkspace workspace = (VfsWorkspace)this.getWorkspace();
        if (workspace != null) {
            IVfsActivity activity = null;
            try {
                if (!workspace.isDefaultActivityInitial()) {
                    activity = workspace.getDefaultActivity();
                }
            }
            catch (VfsException e) {
                throw new VfsException("Get default activity of workspace failed", e);
            }
            if (this == activity) {
                return true;
            }
        }
        return false;
    }

    boolean isDvActivityDefaultActivity() {
        IProperty defaultActivity = null;
        try {
            defaultActivity = this.m_dvActivity.getProperty(DEFAULT_ACTIVITY_PROPERTY_NAME);
        }
        catch (VcmFailure vcmFailure) {
            if (vcmFailure.getStatusCode() != 404) {
                LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)vcmFailure, (int)500);
            }
            LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)vcmFailure, (int)300);
        }
        return defaultActivity != null;
    }

    public boolean isEmpty() throws VfsException {
        this.checkState();
        if (!this.m_activityElements.isEmpty()) {
            return false;
        }
        return VfsActivity.isDvActivityEmpty(this.m_dvActivity);
    }

    public boolean isOpen() throws VfsException {
        this.checkState();
        try {
            if (this.m_dvActivity.isClosed()) {
                return false;
            }
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting activity state from repository failed", vcmFailure);
        }
        return true;
    }

    IVfsActivityElement[] refreshOpenActivityAndActivityElements() throws VfsException {
        boolean new_realization = true;
        if (new_realization) {
            IActivityComposite activityComposite = null;
            try {
                activityComposite = this.m_dvActivity.createComposite(this.m_repository.getOpenActivityCompositeDef());
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Get content from open activity failed", vcmFailure);
            }
            this.m_dvActivity = activityComposite.getActivity();
            VfsWorkspace oldWorkspace = this.m_workspaceSet.length == 0 ? null : this.m_workspaceSet[0];
            VfsWorkspace newWorkspace = null;
            try {
                IWorkspace dvWorkspace = this.m_dvActivity.getWorkspace();
                if (dvWorkspace != null) {
                    newWorkspace = (VfsWorkspace)this.getRepository().getWorkspaceByPathFromCache(dvWorkspace.getDecodedPath());
                    if (newWorkspace == null) {
                        newWorkspace = (VfsWorkspace)this.getRepository().getWorkspaceByOIDFromCache(dvWorkspace.getXCMObjectId());
                    }
                    if (newWorkspace == null) {
                        throw new VfsException("Internal error: new workspace of activity is excluded by filter in client definition");
                    }
                }
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Get workspace of activity failed", vcmFailure);
            }
            IVfsActivityElement[] elements = this.refreshElementsFromOpenActivity(newWorkspace, activityComposite);
            if (this.m_activityElements.isEmpty()) {
                if (oldWorkspace != null) {
                    oldWorkspace.removeActivityFromOpenActivityCache(this);
                }
            } else if (oldWorkspace != newWorkspace) {
                if (oldWorkspace != null) {
                    if (this.isDefaultActivity()) {
                        oldWorkspace.resetDefaultActivity();
                    }
                    if (this.isCurrentActivity()) {
                        oldWorkspace.resetCurrentActivity();
                    }
                    oldWorkspace.removeActivityFromOpenActivityCache(this);
                }
                newWorkspace.addActivityToOpenActivityCache(this);
                if (this.isDvActivityDefaultActivity()) {
                    newWorkspace.initializeDefaultActivityOnWorkspace(this);
                }
            }
            return elements;
        }
        return this.refreshElementsFromOpenActivity(this.m_workspaceSet[0]);
    }

    IVfsActivityElement[] refreshElementsFromOpenActivity(IVfsWorkspace workspace, IActivityComposite activityComposite) throws VfsException {
        IActivityContent dvActivityContentSet = activityComposite.getActivityContentComponent();
        HashMap dvVcrSet = activityComposite.getVcrSet();
        return this.refreshElementsFromOpenActivity(workspace, dvActivityContentSet, dvVcrSet);
    }

    IVfsActivityElement[] refreshElementsFromOpenActivity(IVfsWorkspace workspace, IActivityContent dvActivityContentSet, HashMap dvVcrSet) throws VfsException {
        IVfsActivityElement[] elementsInOpenActivity;
        Iterator iterator;
        HashMap oldActivityElements = this.m_activityElements;
        this.m_activityElements = new HashMap();
        int checkedOutCount = 0;
        int createdCount = 0;
        int closedCount = 0;
        int count = 0;
        if (dvActivityContentSet != null) {
            checkedOutCount = dvActivityContentSet.checkedOutCount();
            createdCount = dvActivityContentSet.createdCount();
            closedCount = dvActivityContentSet.closedCount();
            count = checkedOutCount + createdCount + closedCount;
        }
        if (count == 0) {
            if (!oldActivityElements.isEmpty()) {
                iterator = oldActivityElements.values().iterator();
                while (iterator.hasNext()) {
                    VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)iterator.next();
                    folderItem.removeCheckedOutDvResource(this);
                    folderItem.removeActivityAndResetActivityState(this);
                }
            }
            elementsInOpenActivity = EMPTY_ACTIVITY_ELEMENTS;
        } else {
            elementsInOpenActivity = new IVfsActivityElement[count];
            IVersionControlledResource dvVcr = null;
            ICreatedResource dvNewResource = null;
            IWorkingResource dvWorkingResource = null;
            Throwable exception = null;
            int i = 0;
            while (i < checkedOutCount) {
                dvVcr = null;
                try {
                    dvWorkingResource = dvActivityContentSet.nextCheckOutResource().getAsWorkingResource();
                    if (dvWorkingResource != null) {
                        if (dvVcrSet != null && dvVcrSet.size() > 0) {
                            String vcrPath = dvWorkingResource.getUpdatedResourceDecodedPath();
                            if (vcrPath != null) {
                                dvVcr = (IVersionControlledResource)dvVcrSet.get(vcrPath);
                            }
                        } else {
                            dvVcr = dvWorkingResource.getUpdatedResource();
                        }
                    }
                }
                catch (VcmFailure vcmFailure) {
                    this.m_activityElements = oldActivityElements;
                    throw new VfsException("Get updated resource for a checked out resource failed: " + vcmFailure.getMessage(), vcmFailure);
                }
                VfsActivityRecordedFolderItem folderItem = VfsActivityRecordedFolderItem.getVfsFolderItemForActivityElement(workspace, this, dvVcr, dvNewResource, dvWorkingResource);
                String remotePath = folderItem.getAbsoluteRemotePath();
                if (!oldActivityElements.containsKey(remotePath)) {
                    IVfsActivity[] activities;
                    if (folderItem.asFolder() != null && (activities = folderItem.getOpenActivities()).length != 0 && activities[0] != null) {
                        elementsInOpenActivity[i] = ((VfsActivity)activities[0]).getActivityElement(folderItem.getAbsoluteRemotePath());
                    }
                } else {
                    elementsInOpenActivity[i] = (IVfsActivityElement)oldActivityElements.get(remotePath);
                    ((VfsActivityElement)elementsInOpenActivity[i]).setFolderItem(folderItem);
                }
                if (elementsInOpenActivity[i] == null) {
                    elementsInOpenActivity[i] = new VfsActivityElement(folderItem);
                }
                this.m_activityElements.put(((VfsActivityElement)elementsInOpenActivity[i]).getKeyForActivityCache(), elementsInOpenActivity[i]);
                ++i;
            }
            dvVcr = null;
            dvWorkingResource = null;
            int i2 = checkedOutCount;
            while (i2 < checkedOutCount + createdCount) {
                try {
                    dvNewResource = dvActivityContentSet.nextCreatedResource();
                }
                catch (VcmFailure vcmFailure) {
                    this.m_activityElements = oldActivityElements;
                    throw new VfsException("Get new created resource failed: " + vcmFailure.getMessage(), vcmFailure);
                }
                VfsActivityRecordedFolderItem folderItem = VfsActivityRecordedFolderItem.getVfsFolderItemForActivityElement(workspace, this, dvVcr, dvNewResource, dvWorkingResource);
                String remotePath = folderItem.getAbsoluteRemotePath();
                if (!oldActivityElements.containsKey(remotePath)) {
                    elementsInOpenActivity[i2] = new VfsActivityElement(folderItem);
                } else {
                    elementsInOpenActivity[i2] = (IVfsActivityElement)oldActivityElements.get(remotePath);
                    ((VfsActivityElement)elementsInOpenActivity[i2]).setFolderItem(folderItem);
                }
                this.m_activityElements.put(((VfsActivityElement)elementsInOpenActivity[i2]).getKeyForActivityCache(), elementsInOpenActivity[i2]);
                ++i2;
            }
            IClosedResource dvClosedResource = null;
            int i3 = checkedOutCount + createdCount;
            while (i3 < count) {
                try {
                    dvClosedResource = dvActivityContentSet.nextClosedResource();
                }
                catch (VcmFailure vcmFailure) {
                    this.m_activityElements = oldActivityElements;
                    throw new VfsException("Get closed resource failed: " + vcmFailure.getMessage(), vcmFailure);
                }
                VfsVersion version = new VfsVersion(this.getVfsManager(), dvClosedResource);
                String url = version.getUrl();
                if (!oldActivityElements.containsKey(url)) {
                    elementsInOpenActivity[i3] = new VfsActivityElement(version, this);
                } else {
                    elementsInOpenActivity[i3] = (IVfsActivityElement)oldActivityElements.get(url);
                    ((VfsActivityElement)elementsInOpenActivity[i3]).setVersion(version);
                }
                this.m_activityElements.put(((VfsActivityElement)elementsInOpenActivity[i3]).getKeyForActivityCache(), elementsInOpenActivity[i3]);
                ++i3;
            }
            if (exception != null) {
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, "Refreshing folder items in activity failed");
                throw new VfsException("Refreshing folder items in activity failed: " + this.getDisplayName() + " ( " + this.getName() + " ) ", exception);
            }
        }
        iterator = oldActivityElements.values().iterator();
        while (iterator.hasNext()) {
            IVfsActivityElement activityElement = (IVfsActivityElement)iterator.next();
            String key = ((VfsActivityElement)activityElement).getKeyForActivityCache();
            if (this.m_activityElements.containsKey(key)) continue;
            VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)activityElement.getAsActivityRecordedFolderItem();
            if (folderItem != null) {
                folderItem.removeCheckedOutDvResource(this);
                folderItem.removeActivityAndResetActivityState(this);
                if (folderItem.asFile() != null && folderItem.getLocalFile() != null && folderItem.getLocalFile().canWrite(false)) {
                    folderItem.getLocalFile().setReadOnly();
                }
            }
            ((VfsActivityElement)activityElement).setInvalid(true);
        }
        if (oldActivityElements.size() != this.m_activityElements.size()) {
            this.getVfsManager().fireEventActivityItemsAddedOrRemoved(this);
        } else {
            Set oldKeySet = oldActivityElements.keySet();
            oldKeySet.removeAll(this.m_activityElements.keySet());
            if (!oldKeySet.isEmpty()) {
                this.getVfsManager().fireEventActivityItemsAddedOrRemoved(this);
            }
        }
        return elementsInOpenActivity;
    }

    IVfsActivityElement[] refreshElementsFromOpenActivity(IVfsWorkspace workspace) throws VfsException {
        IActivityContent dvActivityContentSet = null;
        try {
            dvActivityContentSet = this.m_dvActivity.getContent();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Get activity elements from repository failed", vcmFailure);
        }
        return this.refreshElementsFromOpenActivity(workspace, dvActivityContentSet, null);
    }

    IVfsActivityElement getActivityElement(String key) {
        return (IVfsActivityElement)this.m_activityElements.get(key);
    }

    public IVfsActivityElement[] getElements() throws VfsException {
        this.checkState();
        if (this.isEmpty()) {
            return EMPTY_ACTIVITY_ELEMENTS;
        }
        if (!this.m_activityElements.isEmpty()) {
            return this.m_activityElements.values().toArray(new IVfsActivityElement[this.m_activityElements.size()]);
        }
        if (this.isOpen()) {
            return this.refreshOpenActivityAndActivityElements();
        }
        return this.refreshClosedActivityAndActivityElements();
    }

    public IVfsActivityRecordedFolderItem[] getElementsFromOpenActivity() throws VfsException {
        this.checkState();
        if (this.isPropagationList()) {
            throw new IllegalStateException("Internal error: Found activity that actually is propagation list: " + this.getIdentifyingString());
        }
        if (!this.isOpen()) {
            throw new VfsException("Activity is closed: " + this.getIdentifyingString());
        }
        if (this.isEmpty()) {
            return new IVfsActivityRecordedFolderItem[0];
        }
        if (this.m_activityElements.isEmpty()) {
            this.refreshOpenActivityAndActivityElements();
        }
        return this.getFolderItemsFromCachedActivityElements();
    }

    private IVfsActivityRecordedFolderItem[] getFolderItemsFromCachedActivityElements() {
        ArrayList<IVfsActivityRecordedFolderItem> folderItems = new ArrayList<IVfsActivityRecordedFolderItem>();
        Iterator iter = this.m_activityElements.values().iterator();
        while (iter.hasNext()) {
            IVfsActivityElement activityElement = (IVfsActivityElement)iter.next();
            IVfsActivityRecordedFolderItem folderItem = activityElement.getAsActivityRecordedFolderItem();
            if (folderItem == null) continue;
            folderItems.add(folderItem);
        }
        return folderItems.toArray(new IVfsActivityRecordedFolderItem[folderItems.size()]);
    }

    public IVfsVersion[] getElementsFromClosedActivity() throws VfsException {
        this.checkState();
        if (this.isOpen()) {
            throw new VfsException("Activity is open");
        }
        if (this.isEmpty()) {
            return EMPTY_CLOSED_ACTIVITY_ITEMS;
        }
        if (!this.m_activityElements.isEmpty()) {
            Iterator activityIterator = this.m_activityElements.values().iterator();
            IVfsVersion[] vfsVersions = new IVfsVersion[this.m_activityElements.size()];
            int i = 0;
            while (activityIterator.hasNext()) {
                Object element = activityIterator.next();
                if (!(element instanceof IVfsVersion)) {
                    this.refreshClosedActivityAndActivityElements();
                    break;
                }
                vfsVersions[i] = (IVfsVersion)element;
                ++i;
            }
            return this.getVersionsFromCachedActivityElements();
        }
        this.refreshClosedActivityAndActivityElements();
        return this.getVersionsFromCachedActivityElements();
    }

    private IVfsVersion[] getVersionsFromCachedActivityElements() {
        ArrayList<IVfsVersion> versions = new ArrayList<IVfsVersion>();
        Iterator iter = this.m_activityElements.values().iterator();
        while (iter.hasNext()) {
            IVfsActivityElement activityElement = (IVfsActivityElement)iter.next();
            IVfsVersion version = activityElement.getAsVersion();
            if (version == null) continue;
            versions.add(version);
        }
        return versions.toArray(new IVfsVersion[versions.size()]);
    }

    IVfsActivityElement[] refreshElementsFromClosedActivity(IActivityComposite activityComposite) throws VfsException {
        this.m_activityElements = new HashMap();
        IVersion[] dvVersions = activityComposite.getVersionSetComponent();
        if (dvVersions == null || dvVersions.length == 0) {
            return EMPTY_ACTIVITY_ELEMENTS;
        }
        IVfsActivityElement[] activityElements = new IVfsActivityElement[dvVersions.length];
        int i = 0;
        while (i < dvVersions.length) {
            activityElements[i] = new VfsActivityElement(new VfsVersion(this.getVfsManager(), dvVersions[i]), this);
            this.m_activityElements.put(activityElements[i].getUrl(), activityElements[i]);
            ++i;
        }
        return activityElements;
    }

    IVfsActivityElement[] refreshClosedActivityAndActivityElements() throws VfsException {
        IActivityComposite activityComposite = null;
        try {
            activityComposite = this.m_dvActivity.createComposite(CLOSED_ACTIVITY_COMPOSITE_DEF);
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Get version set from closed activity failed", vcmFailure);
        }
        this.m_dvActivity = activityComposite.getActivity();
        return this.refreshElementsFromClosedActivity(activityComposite);
    }

    int getNumberOfItems() throws VfsException {
        this.checkState();
        if (!this.m_activityElements.isEmpty()) {
            return this.m_activityElements.size();
        }
        if (VfsActivity.isDvActivityEmpty(this.m_dvActivity)) {
            return 0;
        }
        try {
            if (!this.m_dvActivity.isClosed()) {
                return this.refreshOpenActivityAndActivityElements().length;
            }
            String[] paths = this.m_dvActivity.getVersionsPaths();
            return paths != null ? paths.length : 0;
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Get content set of activity failed", vcmFailure);
        }
    }

    void addActivityElement(IVfsFolderItem folderItem) {
        IVfsActivityRecordedFolderItem activityRecordedFolderItem = folderItem.asActivityRecordedFolderItem();
        if (activityRecordedFolderItem != null) {
            this.m_activityElements.put(folderItem.getAbsoluteRemotePath(), new VfsActivityElement(activityRecordedFolderItem));
        }
    }

    void addActivityElement(IVersionedFileSystemManager vfsManager, IVersion dvVersion) throws VfsException {
        VfsActivityElement activityElement = new VfsActivityElement(new VfsVersion((VersionedFileSystemManager)vfsManager, dvVersion), this);
        this.m_activityElements.put(activityElement.getKeyForActivityCache(), activityElement);
    }

    void resetActivityElementsAndState() throws VfsException {
        Iterator elementIterator = this.m_activityElements.values().iterator();
        while (elementIterator.hasNext()) {
            IVfsActivityElement activityElement = (IVfsActivityElement)elementIterator.next();
            IVfsActivityRecordedFolderItem folderItem = activityElement.getAsActivityRecordedFolderItem();
            if (folderItem == null) continue;
            VfsActivityRecordedFolderItem folderItemImpl = (VfsActivityRecordedFolderItem)folderItem;
            folderItemImpl.refreshFolderItemStateAfterUncheckout(this);
            folderItemImpl.refreshLocalFileSystemAfterUncheckout();
            ((VfsActivityElement)activityElement).setInvalid(true);
        }
        this.m_activityElements.clear();
        this.refreshActivityWorkspaceStateAfterUncheckout();
    }

    void removeActivityElement(IVfsFolderItem folderItem) {
        this.m_activityElements.remove(folderItem.getAbsoluteRemotePath());
    }

    void removeActivityElement(IVfsVersion version) {
        this.m_activityElements.remove(version.getUrl());
    }

    public IVfsCheckinCollision[] checkIn() throws VfsException {
        this.checkState();
        try {
            VfsWorkspace workspace = (VfsWorkspace)this.getWorkspace();
            if (workspace != null) {
                workspace.checkIsModifiable();
            }
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Checking in activity is not allowed because workspace folder is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        if (this.isPropagationList()) {
            throw new IllegalStateException("Internal error: Found activity that actually is propagation list: " + this.getIdentifyingString());
        }
        VfsListenerHandler listenerHandler = this.getVfsManager().getListenerHandler();
        boolean wasInternalDelayedListeningTurnedOn = listenerHandler.isVfsInternalDelayedListeningTurnedOn();
        if (!wasInternalDelayedListeningTurnedOn) {
            listenerHandler.startVfsInternalDelayedListening();
        }
        try {
            IVfsCheckinCollision[] iVfsCheckinCollisionArray = this.checkIn(true);
            Object var5_6 = null;
            if (!wasInternalDelayedListeningTurnedOn) {
                listenerHandler.stopVfsInternalDelayedListening();
            }
            return iVfsCheckinCollisionArray;
        }
        catch (Throwable throwable) {
            block8: {
                Object var5_7 = null;
                if (wasInternalDelayedListeningTurnedOn) break block8;
                listenerHandler.stopVfsInternalDelayedListening();
            }
            throw throwable;
        }
    }

    public IVfsCheckinCollision[] checkInWithoutUpload() throws VfsException {
        this.checkState();
        try {
            VfsWorkspace workspace = (VfsWorkspace)this.getWorkspace();
            if (workspace != null) {
                workspace.checkIsModifiable();
            }
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Checking in activity is not allowed because workspace folder is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        if (this.isPropagationList()) {
            throw new IllegalStateException("Internal error: Found activity that actually is propagation list: " + this.getIdentifyingString());
        }
        VfsListenerHandler listenerHandler = this.getVfsManager().getListenerHandler();
        boolean wasInternalDelayedListeningTurnedOn = listenerHandler.isVfsInternalDelayedListeningTurnedOn();
        if (!wasInternalDelayedListeningTurnedOn) {
            listenerHandler.startVfsInternalDelayedListening();
        }
        try {
            IVfsCheckinCollision[] iVfsCheckinCollisionArray = this.checkIn(false);
            Object var5_6 = null;
            if (!wasInternalDelayedListeningTurnedOn) {
                listenerHandler.stopVfsInternalDelayedListening();
            }
            return iVfsCheckinCollisionArray;
        }
        catch (Throwable throwable) {
            block8: {
                Object var5_7 = null;
                if (wasInternalDelayedListeningTurnedOn) break block8;
                listenerHandler.stopVfsInternalDelayedListening();
            }
            throw throwable;
        }
    }

    private IVfsCheckinCollision[] checkIn(boolean doPutChangedFileContent) throws VfsException {
        String activityString = null;
        activityString = this.getIdentifyingString();
        if (this.isEmpty()) {
            VfsActionRecorder.log(VfsActionType.CHECKIN, VfsActionStatus.FAILED, this, "Activity is empty");
            throw new VfsException("Empty activity can not be checked in");
        }
        if (!this.isOpen()) {
            VfsActionRecorder.log(VfsActionType.CHECKIN, VfsActionStatus.FAILED, this, "Activity is closed");
            throw new VfsException("Closed activity can not be checked in");
        }
        if (doPutChangedFileContent) {
            if (this.m_activityElements.isEmpty()) {
                this.getElementsFromOpenActivity();
            }
            Iterator activityItemsIterator = this.m_activityElements.values().iterator();
            while (activityItemsIterator.hasNext()) {
                VfsFile vfsFile;
                IVfsActivityElement activityElement = (IVfsActivityElement)activityItemsIterator.next();
                IVfsActivityRecordedFolderItem folderItem = activityElement.getAsActivityRecordedFolderItem();
                if (folderItem == null || (vfsFile = (VfsFile)folderItem.asFile()) == null) continue;
                if (vfsFile.getLocalFile() == null && vfsFile.getActivityState() != VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
                    VfsException e = vfsFile.getCauseOfInconsistency();
                    if (e == null) {
                        e = new VfsException(ExceptionSeverity.ERROR, VfsExceptionCategory.NO_MOUNTPOINT_FOR_EDITED_FILE, new Object[]{vfsFile.getAbsoluteRemotePath()}, new Throwable[0]);
                    }
                    VfsActionRecorder.log(VfsActionType.CHECKIN, VfsActionStatus.FAILED, this, e.getMessage());
                    throw e;
                }
                try {
                    if (vfsFile.pureFileUpload()) continue;
                    String msg = "Uploading file failed";
                    VfsActionRecorder.log(VfsActionType.CHECKIN, VfsActionStatus.FAILED, this, msg);
                    throw new VfsException(msg + ": " + this.getName());
                }
                catch (VfsException e) {
                    VfsActionRecorder.log(VfsActionType.CHECKIN, VfsActionStatus.FAILED, this, e.getMessage());
                    throw new VfsException("Checking in activity failed: " + this.getName(), e);
                }
            }
        }
        this.getVfsManager().fireEventBeforeCheckingInActivity(this);
        HashSet<IVfsGenericFolder> parentsOfDeletedFolderItems = new HashSet<IVfsGenericFolder>();
        Iterator activityElementsIterator = this.m_activityElements.values().iterator();
        while (activityElementsIterator.hasNext()) {
            IVfsActivityElement activityElement = (IVfsActivityElement)activityElementsIterator.next();
            VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)activityElement.getAsActivityRecordedFolderItem();
            if (folderItem == null) continue;
            try {
                IWorkingResource dvWorkingResource = folderItem.getDvWorkingResource(this);
                if (dvWorkingResource == null || !dvWorkingResource.markedForDeletion()) continue;
                IVfsGenericFolder parent = folderItem.getRealParent();
                parentsOfDeletedFolderItems.add(parent);
            }
            catch (Exception e) {
                LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)e, (int)500);
            }
        }
        VfsActivityState oldState = this.isOpen() ? VfsActivityState.OPEN : VfsActivityState.CLOSED;
        ICheckinCollision[] dvCollisions = null;
        VfsException e = null;
        IConnection connection = VfsActivityRecordedFolderItem.getConnection(this.m_dvActivity.getConnectionTemplID());
        int oldReadTimeout = connection.getSocketReadTimeout();
        int INFINITE_TIMEOUT = 0;
        connection.setSocketReadTimeout(INFINITE_TIMEOUT);
        try {
            block27: {
                try {
                    dvCollisions = this.m_dvActivity.checkin(2);
                    if (dvCollisions != null && dvCollisions.length > 0) {
                        VfsActionRecorder.log(VfsActionType.CHECKIN, VfsActionStatus.FAILED, this, "Got check-in conflicts");
                        break block27;
                    }
                    VfsActionRecorder.log(VfsActionType.CHECKIN, VfsActionStatus.SUCCEEDED, this, null);
                }
                catch (VcmFailure vcmFailure) {
                    VfsActionRecorder.log(VfsActionType.CHECKIN, VfsActionStatus.FAILED, this, vcmFailure.getMessage());
                    e = new VfsException("Checkin of activity failed" + vcmFailure.getMessage(), vcmFailure);
                    try {
                        connection.setSocketReadTimeout(oldReadTimeout);
                        this.refreshStateAfterCheckin();
                    }
                    catch (VfsException e1) {
                        LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e1, (int)500);
                        throw new VfsException("Refresh internal state (default activity, cache, ...) failed", e);
                    }
                    throw e;
                }
            }
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            connection.setSocketReadTimeout(oldReadTimeout);
            throw throwable;
        }
        connection.setSocketReadTimeout(oldReadTimeout);
        if (dvCollisions == null || dvCollisions.length == 0) {
            this.refreshStateAfterCheckin();
            this.getVfsManager().fireEventActivityStateChanged(this, oldState);
            Iterator parentIterator = parentsOfDeletedFolderItems.iterator();
            while (parentIterator.hasNext()) {
                IVfsGenericFolder parentFolder = (IVfsGenericFolder)parentIterator.next();
                this.getVfsManager().fireEventFolderItemsAddedOrRemoved(parentFolder);
            }
        }
        IVfsCheckinCollision[] checkinCollisions = new VfsCheckinCollision[]{};
        if (dvCollisions != null && dvCollisions.length > 0) {
            checkinCollisions = new VfsCheckinCollision[dvCollisions.length];
            Logbook.getErrorChapter().println("Files with check-in conflict:");
            int i = 0;
            while (i < dvCollisions.length) {
                ICheckinCollision dvCollision = dvCollisions[i];
                checkinCollisions[i] = new VfsCheckinCollision(this.getVfsManager(), dvCollision);
                try {
                    VfsActivityRecordedFolderItem collidingFolderItem = null;
                    if (dvCollision.getCollisionType() == CollisionType.NAME_CLASH) {
                        String absoluteRemotePath = dvCollision.getVCR().getDecodedPath();
                        collidingFolderItem = (VfsActivityRecordedFolderItem)this.m_activityElements.get(absoluteRemotePath);
                        collidingFolderItem.setDvLocalRemoteNameClashVcr(dvCollision.getVCR());
                    } else {
                        IWorkingResource dvWorkingResource = dvCollision.getCollidingVersion().getAsWorkingResource();
                        String absoluteRemotePath = PathUtilities.assureTrailingSeparator(this.getWorkspace().getAbsoluteRemotePath(), PathUtilities.REMOTE_FILESERVICE) + dvWorkingResource.getXCMPath().substring(1);
                        collidingFolderItem = (VfsActivityRecordedFolderItem)this.m_activityElements.get(absoluteRemotePath);
                        collidingFolderItem.getVcrResource().refresh();
                        collidingFolderItem.refreshLocationState();
                    }
                    Logbook.getErrorChapter().println(collidingFolderItem.getName() + "   (" + collidingFolderItem.getBrowsePath() + ")");
                }
                catch (VcmFailure vcmFailure) {
                    new VfsException("Refresh folder item with check-in conflict failed" + vcmFailure.getMessage(), vcmFailure);
                }
                ++i;
            }
        }
        return checkinCollisions;
    }

    private void refreshStateAfterCheckin() throws VfsException {
        VfsWorkspace workspace = (VfsWorkspace)this.getWorkspace();
        try {
            if (!this.m_dvActivity.isClosed()) {
                return;
            }
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Refresh activity from repository failed", vcmFailure);
        }
        if (workspace.getCurrentActivity() == this) {
            workspace.setCurrentActivity(null);
        }
        if (!workspace.isDefaultActivityInitial() && workspace.pureGetDefaultActivity() == this) {
            workspace.resetDefaultActivity();
        }
        HashMap activityFolderItems = this.m_activityElements;
        this.refreshClosedActivityAndActivityElements();
        Iterator versionIterator = this.m_activityElements.values().iterator();
        HashMap<IVfsGenericFolder, HashMap<String, VfsActivityRecordedFolderItem>> parentsAndDeletedItems = new HashMap<IVfsGenericFolder, HashMap<String, VfsActivityRecordedFolderItem>>();
        while (versionIterator.hasNext()) {
            try {
                SyncDB syncDb;
                IVfsActivityElement element;
                IVfsActivityElement activityElement = (IVfsActivityElement)versionIterator.next();
                VfsVersion version = (VfsVersion)activityElement.getAsVersion();
                String absoluteRemotePath = version.getVcrPathForWorkspace(workspace);
                if (!version.isFile()) {
                    absoluteRemotePath = PathUtilities.assureTrailingSeparator(absoluteRemotePath, PathUtilities.REMOTE_FILESERVICE);
                }
                if ((element = (IVfsActivityElement)activityFolderItems.get(absoluteRemotePath)) == null) continue;
                VfsActivityRecordedFolderItem activityItem = (VfsActivityRecordedFolderItem)element.getAsActivityRecordedFolderItem();
                if (activityItem == null) {
                    VfsException e = new VfsException("Get path of activity element in workspace failed");
                    continue;
                }
                try {
                    activityItem.refreshInternalStateAfterCheckin(absoluteRemotePath, version, this);
                }
                catch (VfsException e) {
                    LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
                }
                try {
                    if (activityItem.getLocationState() == VfsFolderItemLocationState.DELETED) {
                        IVfsGenericFolder parent = activityItem.getRealParent();
                        HashMap<String, VfsActivityRecordedFolderItem> deletedItems = (HashMap<String, VfsActivityRecordedFolderItem>)parentsAndDeletedItems.get(parent);
                        if (deletedItems == null) {
                            deletedItems = new HashMap<String, VfsActivityRecordedFolderItem>();
                        }
                        deletedItems.put(activityItem.getAbsoluteRemotePath(), activityItem);
                        parentsAndDeletedItems.put(parent, deletedItems);
                    }
                }
                catch (VfsException e) {
                    LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
                }
                IVirtualFile localFile = activityItem.getLocalFile();
                if (localFile == null) continue;
                if (activityItem.getLocationState() != VfsFolderItemLocationState.DELETED && activityItem.asFile() != null) {
                    localFile.setReadOnly();
                    try {
                        ((VfsFile)activityItem.asFile()).refreshTimestampOnSyncedFile();
                    }
                    catch (VfsException e) {
                        LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
                    }
                }
                if ((syncDb = workspace.getContext().getSyncDb(localFile.getAbsolutePath())) == null) {
                    throw new VfsException("Internal error: No SyncDB found for checked out folder item:" + activityItem.getAbsoluteRemotePath());
                }
                if (activityItem.getLocationState() == VfsFolderItemLocationState.DELETED) {
                    syncDb.removeEntry(localFile.getAbsolutePath());
                    continue;
                }
                SyncEntry entry = syncDb.getEntry(localFile.getAbsolutePath());
                if (entry == null) {
                    entry = syncDb.createEntry(localFile.getAbsolutePath(), activityItem.getObjectID());
                } else {
                    entry.resetUploadTimestamp();
                }
                Date checkinDate = null;
                try {
                    checkinDate = this.m_dvActivity.lastModified();
                }
                catch (VcmFailure vcmFailure) {
                    new VfsException("Generated dummy SyncDB entry, because get last modified of activity failed", vcmFailure);
                    checkinDate = new Date(1L);
                }
                entry.setVersionUrlAndRemoteSyncTime(version.getUrl(), checkinDate.getTime());
                syncDb.getSyncDbMget().setLastRemoteSyncTime(localFile.getAbsolutePath(), checkinDate.getTime());
            }
            catch (VfsException x) {
                LogUtil.traceCaughtException((Location)LOCATION, (Throwable)x, (int)300);
            }
        }
        VfsFolderItem.refreshParentsOfDeletedItems(parentsAndDeletedItems);
        workspace.removeActivityFromOpenActivityCache(this);
    }

    static void repairOldOpenActivities(List oldOpenActivities, List newOpenActivities) {
        Iterator oldActivityIterator = oldOpenActivities.iterator();
        while (oldActivityIterator.hasNext()) {
            VfsActivity activity = (VfsActivity)oldActivityIterator.next();
            if (newOpenActivities.indexOf(activity) >= 0) continue;
            try {
                if (activity.isInvalid()) {
                    new VfsException("Found already deleted activity and refreshed internal state for this activity: " + activity.getDisplayName());
                    activity.refreshStateAfterDelete();
                    activity.getVfsManager().fireEventActivityDeleted(activity, VfsActivityState.OPEN);
                }
                activity.getDeltaVActivity().refresh();
                if (!activity.isOpen()) {
                    activity.refreshStateAfterCheckin();
                    continue;
                }
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, activity, "Refreshing state of activity failed");
                new VfsException("Internal error: inconsistent open activity found: " + activity.getIdentifyingString());
            }
            catch (VcmFailure vcmFailure) {
                if (vcmFailure.getStatusCode() == 404 && activity.getRepository().hasEmptyActivity(activity)) {
                    try {
                        new VfsException("Found already deleted activity and refreshed internal state for this activity: " + activity.getDisplayName());
                    }
                    catch (VfsException e) {
                        LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
                    }
                    activity.refreshStateAfterDelete();
                    activity.getVfsManager().fireEventActivityDeleted(activity, VfsActivityState.OPEN);
                    continue;
                }
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, activity, "Refreshing state of activity failed");
                LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)vcmFailure, (int)500);
            }
            catch (VfsException e) {
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, activity, "Refreshing state of folder items in closed activity failed");
                LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
            }
        }
    }

    void addWorkspace(IVfsWorkspace workspace) throws VfsException {
        this.checkState();
        this.m_workspaceSet[0] = (VfsWorkspace)workspace;
        if (this.getXcmClientWorkspace() != workspace) {
            this.setXcmClientWorkspace(workspace);
        }
    }

    void setWorkspaceForClosedActivity(IVfsWorkspace workspace) {
        this.m_workspaceSet[0] = (VfsWorkspace)workspace;
    }

    IWorkspace getInvisibleWorkspace() {
        return this.m_invisibleWorkspace;
    }

    void setInvisibleWorkspace(IWorkspace dvWorkspace) {
        this.m_invisibleWorkspace = dvWorkspace;
    }

    public String getWorkspaceUrl() throws VfsException {
        try {
            if (this.getWorkspace() != null) {
                return this.getWorkspace().getUrl();
            }
        }
        catch (IllegalStateException e) {
            LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)e, (int)300);
        }
        if (this.getInvisibleWorkspace() != null) {
            return this.getInvisibleWorkspace().getPersistentURL();
        }
        return null;
    }

    public boolean hasSpecialWorkspaceUrl() {
        IWorkspace dvWorkspace = this.getInvisibleWorkspace();
        if (dvWorkspace != null) {
            return VfsSpecialPaths.isSpecialWorkspacePath(this.getRepository(), dvWorkspace.getDecodedPath());
        }
        return false;
    }

    public String getWorkspaceDescription() throws VfsException {
        IWorkspace dvInvisibleWorkspace = this.getInvisibleWorkspace();
        if (dvInvisibleWorkspace == null) {
            return this.getWorkspaceUrl();
        }
        if (!VfsSpecialPaths.isSpecialWorkspacePath(this.getRepository(), dvInvisibleWorkspace.getDecodedPath())) {
            return dvInvisibleWorkspace.getPersistentURL();
        }
        IPropertyCacheControl dvPropertyCacheControl = dvInvisibleWorkspace.getPropertyCacheControl();
        if (dvPropertyCacheControl.getPropertyState("XCM:workspace-owner-repositoryid") == 4) {
            dvPropertyCacheControl.addPropertyToCache("XCM:workspace-owner-repositoryid");
        }
        if (dvPropertyCacheControl.getPropertyState("XCM:workspace-owner-repositoryname") == 4) {
            dvPropertyCacheControl.addPropertyToCache("XCM:workspace-owner-repositoryname");
        }
        String repositoryID = null;
        String repositoryName = null;
        try {
            IProperty repositoryIDProperty = dvInvisibleWorkspace.getProperty("XCM:workspace-owner-repositoryid");
            repositoryID = repositoryIDProperty == null ? null : repositoryIDProperty.getValue();
            IProperty repositoryNameProperty = dvInvisibleWorkspace.getProperty("XCM:workspace-owner-repositoryname");
            repositoryName = repositoryNameProperty == null ? null : repositoryNameProperty.getValue();
        }
        catch (VcmFailure vcmFailure) {
            if (vcmFailure.getStatusCode() != 404) {
                throw new VfsException("Getting repository ID and repository name failed (" + vcmFailure.getMessage() + ") for workspace: " + dvInvisibleWorkspace.getDecodedPath(), vcmFailure);
            }
            LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)vcmFailure, (int)300);
        }
        String workspacePath = null;
        try {
            workspacePath = dvInvisibleWorkspace.getDisplayName();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Get display name failed (" + vcmFailure.getMessage() + ") for workspace: " + dvInvisibleWorkspace.getDecodedPath(), vcmFailure);
        }
        return workspacePath + " in repository with " + (repositoryID == null ? UNKNOWN_REPOSITORY_ID : "ID " + repositoryID) + " (" + (repositoryName == null ? UNKNOWN_REPOSITORY_NAME : repositoryName) + ")";
    }

    public IVfsWorkspace getCreationWorkspace() throws VfsException {
        this.checkState();
        try {
            IWorkspace dvWorkspace = this.getDeltaVActivity().getWorkspace();
            IVfsWorkspace workspace = this.getRepository().getWorkspaceByPathFromCache(dvWorkspace.getDecodedPath());
            if (workspace == null) {
                workspace = this.getInvisibleWorkspace() != null ? null : this.getRepository().getWorkspaceByPathFromCache(dvWorkspace.getCanonicalPath());
            }
            return workspace;
        }
        catch (VcmFailure vcmFailure) {
            if (vcmFailure.getStatusCode() == 404) {
                LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)vcmFailure, (int)300);
                return null;
            }
            throw new VfsException("Getting creation workspace from DeltaV activity failed: " + this.getIdentifyingString(), vcmFailure);
        }
    }

    public String getCreationWorkspaceUrl() throws VfsException {
        this.checkState();
        IVfsWorkspace workspace = this.getCreationWorkspace();
        if (workspace != null) {
            return workspace.getUrl();
        }
        try {
            return this.getDeltaVActivity().getWorkspace().getPersistentURL();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting creation workspace from DeltaV activity failed: " + this.getIdentifyingString(), vcmFailure);
        }
    }

    public String getCreationWorkspaceAbsoluteRemotePath() throws VfsException {
        this.checkState();
        IVfsWorkspace workspace = this.getCreationWorkspace();
        if (workspace != null) {
            return workspace.getAbsoluteRemotePath();
        }
        try {
            return this.getDeltaVActivity().getWorkspace().getCanonicalPath();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting creation workspace from DeltaV activity failed: " + this.getIdentifyingString(), vcmFailure);
        }
    }

    private void setXcmClientWorkspace(IVfsWorkspace workspace) throws VfsException {
        IProperty[] properties = new IProperty[]{PropertyFactoryAccess.getFactory().createStringProperty(VfsXcmClientProperty.getNamespacePrefix(), VfsXcmClientProperty.WORKSPACE.getPropertyName(), workspace.getObjectID())};
        try {
            this.m_dvActivity.setProperties(properties);
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Set workspace on activity failed: " + vcmFailure.getMessage(), vcmFailure);
        }
    }

    IVfsWorkspace getXcmClientWorkspace() throws VfsException {
        return VfsActivity.getXcmClientWorkspaceForDvActivity(this.m_repository, this.m_dvActivity);
    }

    static IVfsWorkspace getXcmClientWorkspaceForDvActivity(VfsRepository repository, IActivity dvActivity) throws VfsException {
        IProperty property = null;
        try {
            property = dvActivity.getProperty(VfsXcmClientProperty.WORKSPACE.getCompletePropertyName());
        }
        catch (VcmFailure vcmFailure) {
            if (vcmFailure.getStatusCode() == 404) {
                LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)vcmFailure, (int)300);
                return null;
            }
            throw new VfsException("Accessing properties of DeltaV activity failed", vcmFailure);
        }
        if (property != null) {
            String oid = property.getValue();
            return repository.getWorkspaceByOIDFromCache(oid);
        }
        return null;
    }

    static VfsWorkspace getWorkspaceForDvActivity(VfsRepository repository, IActivity dvActivity) throws VfsException {
        VfsWorkspace workspace = (VfsWorkspace)VfsActivity.getXcmClientWorkspaceForDvActivity(repository, dvActivity);
        if (workspace != null) {
            return workspace;
        }
        repository.getVersionedFileSystemManager().getPropertiesFeature();
        if (PropertiesFeature.isPropertyDefinedForDvResource(VfsXcmClientProperty.WORKSPACE.getCompletePropertyName(), dvActivity)) {
            return null;
        }
        try {
            IWorkspace dvWorkspace = dvActivity.getWorkspace();
            if (dvWorkspace != null) {
                workspace = (VfsWorkspace)repository.getWorkspaceByPathFromCache(dvWorkspace.getDecodedPath());
                if (workspace != null) {
                    return workspace;
                }
                return (VfsWorkspace)repository.getWorkspaceByPathFromCache(dvWorkspace.getCanonicalPath());
            }
        }
        catch (VcmFailure vcmFailure) {
            if (vcmFailure.getStatusCode() == 403) {
                LogUtil.traceCaughtExceptionWithStackTrace((Location)LOCATION, (Throwable)vcmFailure, (int)300);
                Logbook.getErrorChapter().println("Filtered out activity of workspace where user has no access permission: " + VfsActivity.getIdentifyingString(dvActivity));
                return null;
            }
            throw new VfsException("Getting workspace for DeltaV activity failed", vcmFailure);
        }
        return null;
    }

    void removeWorkspace(IVfsWorkspace workspace) {
        this.checkState();
        this.m_workspaceSet[0] = null;
    }

    public IVfsWorkspace getWorkspace() {
        this.getVfsManager().checkState();
        if (this.m_workspaceSet.length == 0 || this.m_workspaceSet[0] == null) {
            try {
                IVfsWorkspace workspace = this.getXcmClientWorkspace();
                if (workspace != null) {
                    return workspace;
                }
            }
            catch (VfsException e) {
                LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
            }
            return null;
        }
        if (this.m_workspaceSet.length > 1) {
            IllegalStateException e = new IllegalStateException("The changelist is related to several workspaces");
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            throw e;
        }
        return this.m_workspaceSet[0];
    }

    public VfsActivityState getState() throws VfsException {
        this.checkState();
        return this.pureGetState();
    }

    private VfsActivityState pureGetState() throws VfsException {
        if (this.m_dvActivity == null) {
            throw new VfsException("Internal error: no DeltaV activity available");
        }
        try {
            if (this.m_dvActivity.isClosed()) {
                return VfsActivityState.CLOSED;
            }
            return VfsActivityState.OPEN;
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Get property " + VfsXcmProperty.VERSION_SET_STATE.getCompletePropertyName() + " failed", vcmFailure);
        }
    }

    public String getAuthor() throws VfsException {
        this.checkState();
        try {
            return this.m_dvActivity.getAuthor();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting author failed.", vcmFailure);
        }
    }

    public Date getCreationDate() throws VfsException {
        this.checkState();
        try {
            return this.m_dvActivity.created();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Get creation date failed", vcmFailure);
        }
    }

    public Date getCheckedInDate() throws VfsException {
        this.checkState();
        try {
            return this.m_dvActivity.lastModified();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Get checkin date failed", vcmFailure);
        }
    }

    IActivity getDeltaVActivity() {
        this.checkState();
        return this.m_dvActivity;
    }

    public void refresh() throws VfsException {
        this.checkState();
        try {
            this.getDeltaVActivity().refresh();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Refreshing DeltaV activity failed", vcmFailure);
        }
        if (this.isOpen()) {
            this.refreshOpenActivityAndActivityElements();
        } else {
            this.refreshClosedActivityAndActivityElements();
        }
    }

    public String toString() {
        this.getVfsManager().checkState();
        try {
            String text = this.getDisplayName();
            if (text == null) {
                text = this.getName();
            }
            return text;
        }
        catch (VfsException e) {
            LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
            return this.getName();
        }
    }

    void setDeltaVActivity(IActivity dvActivity) {
        this.m_dvActivity = dvActivity;
    }

    void markAsDefaultActivity() throws VfsException {
        try {
            this.m_dvActivity.setProperties(DEFAULT_ACTIVITY_PROPERTY_ARRAY);
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Set default activity on repository failed: " + vcmFailure.getMessage(), vcmFailure);
        }
    }

    void setInitialSetOfClientProperties(IVfsWorkspace workspace) throws VfsException {
        int num = 1;
        String clientFilter = this.getRepository().getContext().getClientFilter();
        if (clientFilter != null) {
            ++num;
        }
        IProperty[] properties = new IProperty[num];
        properties[0] = PropertyFactoryAccess.getFactory().createStringProperty(VfsXcmClientProperty.getNamespacePrefix(), VfsXcmClientProperty.WORKSPACE.getPropertyName(), workspace.getObjectID());
        if (clientFilter != null) {
            properties[1] = PropertyFactoryAccess.getFactory().createStringProperty(VfsXcmClientProperty.getNamespacePrefix(), VfsXcmClientProperty.CLIENT_ID.getPropertyName(), clientFilter);
        }
        try {
            this.m_dvActivity.setProperties(properties);
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Set client properties on activity failed: " + vcmFailure.getMessage(), vcmFailure);
        }
    }

    void unmarkAsDefaultActivity() throws VfsException {
        try {
            this.m_dvActivity.removeProperties(DEFAULT_ACTIVITY_PROPERTY_NAME_ARRAY);
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Reset default activity on repository failed", vcmFailure);
        }
    }

    public IVfsProperty getProperty(String propertyName) throws VfsException {
        this.checkState();
        return this.getVfsManager().getPropertiesFeature().getProperty(this.getDeltaVActivity(), propertyName);
    }

    public IVfsProperty[] getAllProperties() throws VfsException {
        this.checkState();
        return this.getVfsManager().getPropertiesFeature().getAllProperties(this.getDeltaVActivity());
    }

    public Map getProperties(String[] propertyNames) throws VfsException {
        this.checkState();
        return this.getVfsManager().getPropertiesFeature().getProperties(this.getDeltaVActivity(), propertyNames);
    }

    public String getObjectID() throws VfsException {
        this.checkState();
        return this.pureGetObjectId();
    }

    private String pureGetObjectId() throws VfsException {
        try {
            return this.m_dvActivity.getXCMObjectId();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Get object id of activity failed", vcmFailure);
        }
    }

    public String[] getPropertyNames() throws VfsException {
        this.checkState();
        return this.getVfsManager().getPropertiesFeature().getPropertyNames(this.getDeltaVActivity());
    }

    public void upload() throws VfsException {
        this.checkState();
        try {
            VfsWorkspace workspace = (VfsWorkspace)this.getWorkspace();
            if (workspace != null) {
                workspace.checkIsModifiable();
            }
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Uploading activity is not allowed because workspace folder is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        if (this.isPropagationList()) {
            throw new IllegalStateException("Internal error: Found activity that actually is propagation list: " + this.getIdentifyingString());
        }
        Iterator activityElementIterator = this.m_activityElements.values().iterator();
        while (activityElementIterator.hasNext()) {
            IVfsFile vfsFile;
            IVfsActivityElement activityElement = (IVfsActivityElement)activityElementIterator.next();
            IVfsActivityRecordedFolderItem folderItem = activityElement.getAsActivityRecordedFolderItem();
            if (folderItem == null || (vfsFile = folderItem.asFile()) == null) continue;
            ((VfsFile)vfsFile).pureFileUpload();
        }
    }

    public void forceUpload() throws VfsException {
        this.checkState();
        try {
            VfsWorkspace workspace = (VfsWorkspace)this.getWorkspace();
            if (workspace != null) {
                workspace.checkIsModifiable();
            }
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Uploading activity is not allowed because workspace folder is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UPLOAD, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        if (this.isPropagationList()) {
            throw new IllegalStateException("Internal error: Found activity that actually is propagation list: " + this.getIdentifyingString());
        }
        if (!this.pureforceUpload()) {
            VfsException e = new VfsException("Uploading activity failed, because uploading some of its files failed");
            VfsActionRecorder.log(VfsActionType.UPLOAD, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
    }

    private boolean pureforceUpload() throws VfsException {
        boolean allFilesWereHandledCorrectly = true;
        Iterator activityElementIterator = this.m_activityElements.values().iterator();
        while (activityElementIterator.hasNext()) {
            VfsFile vfsFile;
            block4: {
                IVfsActivityElement activityElement = (IVfsActivityElement)activityElementIterator.next();
                IVfsActivityRecordedFolderItem folderItem = activityElement.getAsActivityRecordedFolderItem();
                if (folderItem == null || (vfsFile = (VfsFile)folderItem.asFile()) == null) continue;
                try {
                    IWorkingResource dvWorkingResource = vfsFile.getDvWorkingResource();
                    if (dvWorkingResource != null && dvWorkingResource.markedForDeletion()) {
                        VfsActionRecorder.log(VfsActionType.UPLOAD, VfsActionStatus.SKIPPED, vfsFile, "File is checked-out for delete");
                    }
                    break block4;
                }
                catch (VcmFailure vcmFailure) {
                    new VfsException("Could not find out if folder item was checked out for delete", vcmFailure);
                }
                continue;
            }
            if (vfsFile.pureUnconditionalFileUpload()) continue;
            allFilesWereHandledCorrectly = false;
        }
        return allFilesWereHandledCorrectly;
    }

    public void download() throws VfsException {
        this.checkState();
        try {
            VfsWorkspace workspace = (VfsWorkspace)this.getWorkspace();
            if (workspace != null) {
                workspace.checkIsModifiable();
            }
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Downloading activity is not allowed because workspace folder is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        if (this.isPropagationList()) {
            throw new IllegalStateException("Internal error: Found activity that actually is propagation list: " + this.getIdentifyingString());
        }
        this.internaldownload(false);
    }

    private void internaldownload(boolean forceDownload) throws VfsException {
        Iterator activityElementIterator = this.m_activityElements.values().iterator();
        while (activityElementIterator.hasNext()) {
            IVfsFile vfsFile;
            IVfsActivityElement activityElement = (IVfsActivityElement)activityElementIterator.next();
            IVfsActivityRecordedFolderItem folderItem = activityElement.getAsActivityRecordedFolderItem();
            if (folderItem == null || (vfsFile = folderItem.asFile()) == null) continue;
            ((VfsFile)vfsFile).download(forceDownload);
        }
    }

    public void forceDownload() throws VfsException {
        this.checkState();
        try {
            VfsWorkspace workspace = (VfsWorkspace)this.getWorkspace();
            if (workspace != null) {
                workspace.checkIsModifiable();
            }
        }
        catch (VfsException ex) {
            VfsException e = new VfsException("Downloading activity is not allowed because workspace folder is not modifiable", ex);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
            throw e;
        }
        if (this.isPropagationList()) {
            throw new IllegalStateException("Internal error: Found activity that actually is propagation list: " + this.getIdentifyingString());
        }
        this.internaldownload(true);
    }

    public void uncheckout() throws VfsException {
        this.checkState();
        VfsWorkspace workspace = (VfsWorkspace)this.getWorkspace();
        try {
            if (workspace != null) {
                workspace.checkIsModifiable();
            }
        }
        catch (VfsException ex) {
            String msg = "Uncheckout activity is not allowed because workspace is not modifiable";
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, msg);
            throw new VfsException(msg + ": " + this.getDisplayName() + " in " + workspace.getBrowsePath(), ex);
        }
        if (this.isPropagationList()) {
            throw new IllegalStateException("Internal error: Found activity that actually is propagation list: " + this.getIdentifyingString());
        }
        if (!this.isOpen()) {
            String msg = "Activity is closed";
            VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.SKIPPED, this, msg);
            LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception(msg + ": " + this.getDisplayName()), (boolean)true);
            return;
        }
        if (this.isEmpty()) {
            String msg = "Activity is empty";
            VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.SKIPPED, this, msg);
            LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception(msg + ": " + this.getDisplayName()), (boolean)true);
            return;
        }
        Iterator activityElementsIterator = this.m_activityElements.values().iterator();
        HashMap<String, VfsActivityElement> checkedOutForEditItems = new HashMap<String, VfsActivityElement>();
        TreeMap<String, VfsActivityElement> otherCheckedOutFolderItems = new TreeMap<String, VfsActivityElement>();
        HashMap<String, VfsActivityElement> checkedOutVersions = new HashMap<String, VfsActivityElement>();
        while (activityElementsIterator.hasNext()) {
            VfsActivityElement activityElement = (VfsActivityElement)activityElementsIterator.next();
            IVfsActivityRecordedFolderItem folderItem = activityElement.getAsActivityRecordedFolderItem();
            if (folderItem != null) {
                if (folderItem.asFile() != null && folderItem.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT) {
                    checkedOutForEditItems.put(folderItem.getAbsoluteRemotePath(), activityElement);
                    continue;
                }
                otherCheckedOutFolderItems.put(folderItem.getAbsoluteRemotePath(), activityElement);
                continue;
            }
            if (activityElement.getAsVersion() == null) continue;
            checkedOutVersions.put(activityElement.getKeyForActivityCache(), activityElement);
        }
        this.pureUncheckOutForEditItems(checkedOutForEditItems);
        this.pureUncheckOutBasedOnCheckoutRoot(otherCheckedOutFolderItems);
        this.pureUncheckOutVersions(checkedOutVersions);
        this.refreshActivityWorkspaceStateAfterUncheckout();
        this.getVfsManager().fireEventActivityItemsAddedOrRemoved(this);
    }

    private void pureUncheckOutForEditItems(HashMap checkedOutForEditItems) {
        if (checkedOutForEditItems.isEmpty()) {
            return;
        }
        Iterator activityElementsIterator = checkedOutForEditItems.values().iterator();
        while (activityElementsIterator.hasNext()) {
            IVfsActivityElement activityElement = (IVfsActivityElement)activityElementsIterator.next();
            VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)activityElement.getAsActivityRecordedFolderItem();
            try {
                folderItem.pureUncheckout(this);
                this.m_activityElements.remove(folderItem.getAbsoluteRemotePath());
                folderItem.refreshFolderItemStateAfterUncheckout(this);
                folderItem.refreshSyncDBEntryAfterUncheckout();
                if (folderItem.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) continue;
                ((VfsActivityElement)activityElement).setInvalid(true);
            }
            catch (VfsException e) {
                LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
            }
        }
    }

    private void pureUncheckOutBasedOnCheckoutRoot(TreeMap checkedOutItemsBasedOnCheckoutRoot) {
        VfsActivityRecordedFolderItem folderItem;
        IVfsActivityElement activityElement;
        if (checkedOutItemsBasedOnCheckoutRoot.isEmpty()) {
            return;
        }
        Iterator activityElementIterator = checkedOutItemsBasedOnCheckoutRoot.values().iterator();
        IVfsActivityElement activityElementRoot = (IVfsActivityElement)activityElementIterator.next();
        VfsActivityRecordedFolderItem checkoutRoot = (VfsActivityRecordedFolderItem)activityElementRoot.getAsActivityRecordedFolderItem();
        try {
            checkoutRoot.pureUncheckout(this);
            this.m_activityElements.remove(checkoutRoot.getAbsoluteRemotePath());
            checkoutRoot.refreshFolderItemStateAfterUncheckout(this);
            checkoutRoot.refreshSyncDBEntryAfterUncheckout();
            if (checkoutRoot.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                ((VfsActivityElement)activityElementRoot).setInvalid(true);
            }
        }
        catch (VfsException e) {
            LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
        }
        while (activityElementIterator.hasNext()) {
            activityElement = (IVfsActivityElement)activityElementIterator.next();
            folderItem = (VfsActivityRecordedFolderItem)activityElement.getAsActivityRecordedFolderItem();
            if (folderItem.getActivityState() != VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT) continue;
            checkoutRoot = folderItem;
            try {
                checkoutRoot.pureUncheckout(this);
                this.m_activityElements.remove(checkoutRoot.getAbsoluteRemotePath());
                checkoutRoot.refreshFolderItemStateAfterUncheckout(this);
                checkoutRoot.refreshSyncDBEntryAfterUncheckout();
                if (checkoutRoot.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) continue;
                ((VfsActivityElement)activityElement).setInvalid(true);
            }
            catch (VfsException e) {
                LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
            }
        }
        activityElementIterator = checkedOutItemsBasedOnCheckoutRoot.values().iterator();
        while (activityElementIterator.hasNext()) {
            activityElement = (IVfsActivityElement)activityElementIterator.next();
            folderItem = (VfsActivityRecordedFolderItem)activityElement.getAsActivityRecordedFolderItem();
            if (folderItem.getActivityState() != VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE && folderItem.getActivityState() != VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) continue;
            IVfsGenericFolder vfsFolder = null;
            try {
                vfsFolder = folderItem.getRealParent();
            }
            catch (VfsException e) {
                LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
                continue;
            }
            if (vfsFolder.asActivityRecordedFolderItem() != null && ((VfsActivityRecordedFolderItem)((Object)vfsFolder)).isCheckedOut(this)) continue;
            try {
                folderItem.refreshLocalFileSystemAfterUncheckout();
                folderItem.refreshFolderItemStateAfterUncheckout(this);
                folderItem.refreshSyncDBEntryAfterUncheckout();
                this.m_activityElements.remove(folderItem.getAbsoluteRemotePath());
                if (folderItem.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) continue;
                ((VfsActivityElement)activityElement).setInvalid(true);
            }
            catch (VfsException e) {
                LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
            }
        }
    }

    private void pureUncheckOutVersions(Map checkedOutVersions) {
        if (checkedOutVersions.isEmpty()) {
            return;
        }
        Iterator activityElementsIterator = checkedOutVersions.values().iterator();
        while (activityElementsIterator.hasNext()) {
            IVfsActivityElement activityElement = (IVfsActivityElement)activityElementsIterator.next();
            IVfsVersion destinationVersion = activityElement.getAsVersion();
            try {
                ((VfsVersion)destinationVersion).undoDiscard(this, false, false);
            }
            catch (VfsException e) {
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, e.getMessage());
                LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
            }
        }
    }

    private void pureUncheckOutBasedOnCheckoutRoot_old(TreeMap checkedOutItemsBasedOnCheckoutRoot) {
        if (checkedOutItemsBasedOnCheckoutRoot.isEmpty()) {
            return;
        }
        Iterator activityElementIterator = checkedOutItemsBasedOnCheckoutRoot.values().iterator();
        boolean uncheckedOutRoot = false;
        VfsActivityRecordedFolderItem checkoutRoot = (VfsActivityRecordedFolderItem)activityElementIterator.next();
        try {
            checkoutRoot.pureUncheckout(this);
            uncheckedOutRoot = true;
            this.m_activityElements.remove(checkoutRoot.getAbsoluteRemotePath());
            checkoutRoot.refreshFolderItemStateAfterUncheckout(this);
            checkoutRoot.refreshSyncDBEntryAfterUncheckout();
        }
        catch (VfsException e) {
            LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
        }
        while (activityElementIterator.hasNext()) {
            VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)activityElementIterator.next();
            if (folderItem.getDvWorkingResource(this) != null && !folderItem.getAbsoluteRemotePath().startsWith(checkoutRoot.getAbsoluteRemotePath())) {
                checkoutRoot = folderItem;
                uncheckedOutRoot = false;
                try {
                    checkoutRoot.pureUncheckout(this);
                    uncheckedOutRoot = true;
                    this.m_activityElements.remove(checkoutRoot.getAbsoluteRemotePath());
                    checkoutRoot.refreshFolderItemStateAfterUncheckout(this);
                    checkoutRoot.refreshSyncDBEntryAfterUncheckout();
                }
                catch (VfsException e) {
                    LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
                }
                continue;
            }
            if (!uncheckedOutRoot) continue;
            try {
                folderItem.refreshLocalFileSystemAfterUncheckout();
                folderItem.refreshFolderItemStateAfterUncheckout(this);
                checkoutRoot.refreshSyncDBEntryAfterUncheckout();
                this.m_activityElements.remove(folderItem.getAbsoluteRemotePath());
            }
            catch (VfsException e) {
                LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
            }
        }
    }

    public void uncheckout_oldRealization() throws VfsException {
        this.checkState();
        Iterator activityElementsIterator = this.m_activityElements.values().iterator();
        ArrayList<VfsActivityRecordedFolderItem> uncheckedoutFolderItems = new ArrayList<VfsActivityRecordedFolderItem>(this.m_activityElements.size());
        boolean atLeastOneFailure = false;
        while (activityElementsIterator.hasNext()) {
            IWorkingResource dvWorkingResource;
            IVfsActivityElement activityElement = (IVfsActivityElement)activityElementsIterator.next();
            VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)activityElement.getAsActivityRecordedFolderItem();
            if (folderItem == null || (dvWorkingResource = folderItem.getDvWorkingResource(this)) == null) continue;
            try {
                dvWorkingResource.remove();
            }
            catch (VcmFailure vcmFailure) {
                atLeastOneFailure = true;
                VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.FAILED, folderItem, folderItem.asFolder() != null ? "Failed including new added files and folders below" : null);
                if (folderItem.asFile() != null) {
                    new VfsException("Uncheckout file failed: " + folderItem.getLocalFile().getAbsolutePath(), vcmFailure);
                    continue;
                }
                new VfsException("Uncheckout folder and the new added folders and files under this folder failed: " + folderItem.getLocalFile().getAbsolutePath(), vcmFailure);
                continue;
            }
            VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.SUCCEEDED, folderItem, null);
            uncheckedoutFolderItems.add(folderItem);
        }
        if (!atLeastOneFailure) {
            activityElementsIterator = this.m_activityElements.values().iterator();
            while (activityElementsIterator.hasNext()) {
                VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)activityElementsIterator.next();
                folderItem.refreshLocalFileSystemAfterUncheckout();
                folderItem.refreshFolderItemStateAfterUncheckout(this);
                folderItem.refreshSyncDBEntryAfterUncheckout();
            }
            this.m_activityElements.clear();
        } else {
            ArrayList keyList = new ArrayList(this.m_activityElements.keySet());
            Collections.sort(keyList);
            int i = 0;
            while (i < uncheckedoutFolderItems.size()) {
                VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)uncheckedoutFolderItems.get(i);
                String absoluteRemotePath = folderItem.getAbsoluteRemotePath();
                int pos = Collections.binarySearch(keyList, absoluteRemotePath);
                if (pos < 0) {
                    throw new VfsException("Internal error: inconsistent internal activity state");
                }
                folderItem.refreshLocalFileSystemAfterUncheckout();
                this.m_activityElements.remove(absoluteRemotePath);
                folderItem.refreshFolderItemStateAfterUncheckout(this);
                folderItem.refreshSyncDBEntryAfterUncheckout();
                int j = pos + 1;
                while (j < keyList.size()) {
                    String key = (String)keyList.get(j);
                    if (!key.startsWith(absoluteRemotePath)) break;
                    folderItem = (VfsActivityRecordedFolderItem)this.m_activityElements.remove(key);
                    folderItem.refreshLocalFileSystemAfterUncheckout();
                    folderItem.refreshFolderItemStateAfterUncheckout(this);
                    ++j;
                }
                ++i;
            }
        }
        this.refreshActivityWorkspaceStateAfterUncheckout();
        this.getVfsManager().fireEventActivityItemsAddedOrRemoved(this);
    }

    void refreshActivityStateAfterUncheckout(VfsActivityRecordedFolderItem folderItem) throws VfsException {
        this.m_activityElements.remove(folderItem.getAbsoluteRemotePath());
        this.refreshActivityWorkspaceStateAfterUncheckout();
    }

    void refreshActivityStateAfterUncheckouts(List folderItems) throws VfsException {
        int i = 0;
        while (i < folderItems.size()) {
            VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)folderItems.get(i);
            this.m_activityElements.remove(folderItem.getAbsoluteRemotePath());
            ++i;
        }
        this.refreshActivityWorkspaceStateAfterUncheckout();
    }

    void refreshActivityWorkspaceStateAfterUncheckout() throws VfsException {
        if (this.m_activityElements.isEmpty()) {
            try {
                if (!this.isEmpty()) {
                    this.m_dvActivity.refresh();
                }
            }
            catch (VfsException e1) {
                throw new VfsException("Get number of activity items failed", e1);
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Refresh DeltaV activity failed", vcmFailure);
            }
            VfsWorkspace workspace = this.m_workspaceSet[0];
            if (workspace != null) {
                workspace.removeActivityFromOpenActivityCache(this);
                this.removeWorkspace(workspace);
            }
        }
    }

    public IVfsCheckinCollision[] getCheckinCollisions() throws VfsException {
        this.checkState();
        if (this.isPropagationList()) {
            throw new IllegalStateException("Internal error: Found activity that actually is propagation list: " + this.getIdentifyingString());
        }
        if (!this.isOpen()) {
            throw new VfsException("Closed activity cannot have checkin collisions: " + this.getIdentifyingString());
        }
        ArrayList<VfsCheckinCollision> collisions = new ArrayList<VfsCheckinCollision>();
        Iterator iterator = this.m_activityElements.values().iterator();
        while (iterator.hasNext()) {
            IVfsActivityElement activityElement = (IVfsActivityElement)iterator.next();
            IVfsActivityRecordedFolderItem folderItem = activityElement.getAsActivityRecordedFolderItem();
            if (folderItem == null || folderItem.getLocationState() != VfsFolderItemLocationState.SYNCED_TO_FORMER) continue;
            collisions.add(new VfsCheckinCollision(this.getVfsManager(), folderItem));
        }
        return collisions.toArray(EMPTY_CHECKIN_COLLISIONS);
    }

    public IVersionedFileSystemManager getVersionedFileSystemManager() {
        return this.getVfsManager();
    }

    VersionedFileSystemManager getVfsManager() {
        if (this.m_vfsManager == null || this.m_vfsManager.isReleased()) {
            throw new IllegalStateException("Versioned file system manager was released(old manager's hashCode = " + (this.m_vfsManager != null ? this.m_vfsManager.hashCode() : 0) + ")");
        }
        return this.m_vfsManager;
    }

    public void syncContent(IVfsWorkspace workspace) throws VfsException {
        this.checkState();
        this.getVfsManager().getSyncRemoveFeature().syncActivityContent(this, workspace);
    }

    static String getCurrentTimeInActivityFormat() {
        Calendar gmtCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        gmtCalendar.setTime(new Date(System.currentTimeMillis()));
        String year = String.valueOf(gmtCalendar.get(1));
        String month = String.valueOf(gmtCalendar.get(2) + 1);
        if (month.length() == 1) {
            month = "0" + month;
        } else if (month.length() == 0) {
            month = "00";
        }
        String date = String.valueOf(gmtCalendar.get(5));
        if (date.length() == 1) {
            date = "0" + date;
        } else if (date.length() == 0) {
            date = "00";
        }
        String hour = String.valueOf(gmtCalendar.get(11));
        if (hour.length() == 1) {
            hour = "0" + hour;
        } else if (hour.length() == 0) {
            hour = "00";
        }
        String min = String.valueOf(gmtCalendar.get(12));
        if (min.length() == 1) {
            min = "0" + min;
        } else if (min.length() == 0) {
            min = "00";
        }
        String sec = String.valueOf(gmtCalendar.get(13));
        if (sec.length() == 1) {
            sec = "0" + sec;
        } else if (sec.length() == 0) {
            sec = "00";
        }
        return year + "_" + month + "_" + date + "_" + hour + "_" + min + "_" + sec + "_GMT";
    }

    void pureMoveElement(VfsActivityRecordedFolderItem folderItem, VfsActivity destinationActivity) throws VfsException {
        IResource dvResource = null;
        dvResource = folderItem.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE ? folderItem.getDvNewResource(this) : folderItem.getDvWorkingResource(this);
        IProperty[] properties = new IMutableProperty[]{PropertyFactoryAccess.getFactory().createProperty(VfsXcmProperty.getNamespacePrefix(), VfsXcmProperty.ACTIVITY_SET.getPropertyName())};
        IMutableElement element = PropertyFactoryAccess.getFactory().createDavElement("href");
        element.setValue(destinationActivity.getAbsoluteRemotePath());
        properties[0].addNextChild(element);
        try {
            dvResource.setProperties(properties);
        }
        catch (VcmFailure vcmFailure) {
            VfsActionRecorder.log(VfsActionType.MOVE, VfsActionStatus.FAILED, this, "Move folder item to other activity failed on repository: " + vcmFailure.getMessage());
            throw new VfsException("Move folder item to other activity failed on repository: " + vcmFailure.toString());
        }
    }

    void refreshAfterMove(VfsActivity destinationActivity) throws VfsException {
        String key;
        VfsActivityElement activityElement;
        HashMap oldSourceActivityElements = new HashMap(this.m_activityElements);
        HashMap oldDestinationActivityElements = new HashMap(destinationActivity.m_activityElements);
        VfsException e1 = null;
        try {
            this.refreshOpenActivityAndActivityElements();
        }
        catch (VfsException e) {
            e1 = e;
            LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
            VfsActionRecorder.log(VfsActionType.MOVE, VfsActionStatus.FAILED, this, "Refresh state of folder items and source activity failed");
        }
        try {
            destinationActivity.refreshOpenActivityAndActivityElements();
        }
        catch (VfsException e) {
            VfsActionRecorder.log(VfsActionType.MOVE, VfsActionStatus.FAILED, this, "Refresh state of folder items and source activity failed");
            throw e;
        }
        if (e1 != null) {
            throw e1;
        }
        Iterator iterator = oldSourceActivityElements.values().iterator();
        while (iterator.hasNext()) {
            activityElement = (VfsActivityElement)iterator.next();
            key = activityElement.getKeyForActivityCache();
            if (this.m_activityElements.get(key) != null || destinationActivity.m_activityElements.get(key) != null) continue;
            throw new VfsException("Internal error: activity element from source activity lost during move: " + key);
        }
        iterator = oldDestinationActivityElements.values().iterator();
        while (iterator.hasNext()) {
            activityElement = (VfsActivityElement)iterator.next();
            key = activityElement.getKeyForActivityCache();
            if (destinationActivity.m_activityElements.get(key) != null) continue;
            throw new VfsException("Internal error: activity element from source activity lost during move: " + key);
        }
        iterator = destinationActivity.m_activityElements.values().iterator();
        while (iterator.hasNext()) {
            activityElement = (VfsActivityElement)iterator.next();
            key = activityElement.getKeyForActivityCache();
            if (oldDestinationActivityElements.get(key) != null || oldSourceActivityElements.get(key) != null) continue;
            throw new VfsException("Internal error: additional activity element in destination activity after move: " + key);
        }
    }

    static VfsActivity getVfsActivityFromRepository(VfsRepository repository, String absoluteRemotePath, boolean returnPropagationList) throws VfsException {
        IActivity dvActivity = VfsActivity.createDvActivity(repository, absoluteRemotePath, true);
        if (dvActivity == null) {
            return null;
        }
        if (!VfsActivity.isDvActivityVisible(repository, dvActivity, VfsWorkspace.NULL_WORKSPACE)) {
            return null;
        }
        VfsActivity activity = new VfsActivity(repository, dvActivity);
        if (!VfsActivity.isDvActivityClosed(dvActivity) && !VfsActivity.isDvActivityEmpty(dvActivity)) {
            activity.getElementsFromOpenActivity();
        }
        if (VfsActivity.isDvActivityEmpty(dvActivity)) {
            repository.addEmptyActivity(activity);
        } else {
            IWorkspace dvWorkspace = null;
            VfsWorkspace workspace = null;
            try {
                dvWorkspace = dvActivity.getWorkspace();
                workspace = (VfsWorkspace)repository.getWorkspaceByPathFromCache(dvWorkspace.getDecodedPath());
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Getting workspace of activity failed: " + activity.getIdentifyingString(), vcmFailure);
            }
            if (workspace == null) {
                if (!VfsActivity.isDvActivityClosed(dvActivity)) {
                    throw new VfsException("Internal error: found open activity belonging to invisible workspace");
                }
                activity.setInvisibleWorkspace(dvWorkspace);
            } else if (activity.isOpen()) {
                workspace.addActivityToOpenActivityCache(activity);
            } else {
                activity.setWorkspaceForClosedActivity(workspace);
            }
        }
        return activity;
    }

    private static IActivity createDvActivity(VfsRepository repository, String absoluteRemotePath, boolean isInitialized) throws VfsException {
        IResourceFactory factory = ResourceFactoryManager.getInstance().getProxyFactory();
        try {
            IActivity dvActivity = factory.createActivity(repository.getConnectionTemplateId(), absoluteRemotePath, PathEncodingFlag.DECODED);
            IPropertyCacheControl propertyCacheControl = dvActivity.getPropertyCacheControl();
            propertyCacheControl.addPropertyToCache(VfsXcmClientProperty.WORKSPACE.getCompletePropertyName());
            propertyCacheControl.addPropertyToCache(VfsXcmClientProperty.CLIENT_ID.getCompletePropertyName());
            propertyCacheControl.addPropertyToCache(VfsXcmClientProperty.DEFAULT_ACTIVITY.getCompletePropertyName());
            if (isInitialized) {
                dvActivity.refresh();
            }
            return dvActivity;
        }
        catch (VcmFailure vcmFailure) {
            if (vcmFailure.getStatusCode() == 404) {
                LogUtil.traceCaughtException((Location)LOCATION, (Throwable)vcmFailure, (int)300);
                return null;
            }
            throw new VfsException("Getting activity from repository failed (" + vcmFailure.getMessage() + "): " + absoluteRemotePath, vcmFailure);
        }
    }

    private static boolean isDvActivityClosed(IActivity dvActivity) throws VfsException {
        try {
            if (dvActivity.isClosed()) {
                return true;
            }
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting activity state from repository failed: " + VfsActivity.getIdentifyingString(dvActivity), vcmFailure);
        }
        return false;
    }

    private static boolean isForeignDvActivity(VfsRepository repository, IActivity dvActivity) throws VfsException {
        try {
            if (dvActivity.getAuthor().equals(repository.getUserNameFromUserStore())) {
                return false;
            }
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting author of activity failed: " + VfsActivity.getIdentifyingString(dvActivity), vcmFailure);
        }
        return true;
    }

    private static boolean isDvActivityEmpty(IActivity dvActivity) throws VfsException {
        try {
            if (dvActivity.getWorkspace() == null) {
                return true;
            }
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting workspace of activity failed: " + VfsActivity.getIdentifyingString(dvActivity), vcmFailure);
        }
        return false;
    }

    static boolean isDvActivityVisible(VfsRepository repository, IActivity dvActivity, VfsWorkspace workspace) throws VfsException {
        try {
            IProperty property;
            if (dvActivity.isClosed()) {
                if (VfsActivity.isDvActivityEmpty(dvActivity)) {
                    Logbook.getInfoChapter(2).println("Closed activity is not visible because it is empty: " + VfsActivity.getIdentifyingString(dvActivity));
                    return false;
                }
                return true;
            }
            if (workspace == null) {
                IWorkspace dvWorkspace = dvActivity.getWorkspace();
                if (dvWorkspace != null) {
                    try {
                        VfsFolderItem.checkIsVisible(repository.getContext(), new VfsRemoteLocator(dvWorkspace.getConnectionTemplID(), dvWorkspace.getDecodedPath(), dvWorkspace.getCanonicalPath()), dvWorkspace.getName());
                    }
                    catch (VfsException e) {
                        LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
                        Logbook.getInfoChapter(2).println("Open activity is not visible due to not visible workspace ( " + dvWorkspace.getDecodedPath() + " ) : " + VfsActivity.getIdentifyingString(dvActivity));
                        return false;
                    }
                } else {
                    workspace = (VfsWorkspace)VfsActivity.getXcmClientWorkspaceForDvActivity(repository, dvActivity);
                    if (workspace == null) {
                        Logbook.getInfoChapter(2).println("Empty open activity is not visible due to not visible workspace: " + VfsActivity.getIdentifyingString(dvActivity));
                        return false;
                    }
                }
            }
            if (VfsActivity.isForeignDvActivity(repository, dvActivity)) {
                Logbook.getInfoChapter(2).println("Open activity is not visible due to foreign author ( " + dvActivity.getAuthor() + " ) : " + VfsActivity.getIdentifyingString(dvActivity));
                return false;
            }
            String clientID = repository.getContext().getClientFilter();
            if (!(clientID == null || (property = dvActivity.getProperty(VfsXcmClientProperty.CLIENT_ID.getCompletePropertyName())) != null && property.getValue().equals(clientID))) {
                Logbook.getInfoChapter(2).println("Open activity is not visible due to foreign client ID ( " + (property == null ? "no client ID" : property.getValue()) + " ) : " + VfsActivity.getIdentifyingString(dvActivity));
                return false;
            }
            return true;
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Accessing DeltaV activity failed: " + VfsActivity.getIdentifyingString(dvActivity), vcmFailure);
        }
    }

    void checkWorkspace(IVfsWorkspace checkoutWorkspace) throws VfsException {
        IVfsWorkspace xcmClientWorkspace = this.getXcmClientWorkspace();
        if (this.m_activityElements.isEmpty()) {
            if (xcmClientWorkspace != null) {
                if (xcmClientWorkspace != checkoutWorkspace) {
                    throw new VfsException("Activity belongs to another xcmClientWorkspace: " + xcmClientWorkspace.getBrowsePath());
                }
            } else {
                this.setXcmClientWorkspace(checkoutWorkspace);
            }
        } else {
            if (checkoutWorkspace != this.getWorkspace()) {
                throw new VfsException("Activity belongs to another xcmClientWorkspace: " + this.getWorkspace().getAbsoluteRemotePath());
            }
            if (xcmClientWorkspace == null || xcmClientWorkspace != checkoutWorkspace) {
                this.setXcmClientWorkspace(checkoutWorkspace);
            }
        }
    }

    public IVfsIntegrateCollision[] integrate(IVfsWorkspace targetWorkspace, VfsIntegrationMode mode) throws VfsException {
        this.checkState();
        this.checkParameterState(targetWorkspace);
        try {
            if (targetWorkspace != null) {
                ((VfsWorkspace)targetWorkspace).checkIsModifiable();
            }
        }
        catch (VfsException ex) {
            String msg = "Integrating activity is not allowed because workspace folder is not modifiable";
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, msg);
            throw new VfsException(msg, ex);
        }
        if (this.isOpen()) {
            throw new VfsException("Open activity cannot be integrated: " + this.getIdentifyingString());
        }
        try {
            EIntegrateOption integrateOption = mode == VfsIntegrationMode.FORCE_INTEGRATE_VERSION ? EIntegrateOption.FORCE_INTEGRATE_VERSION : EIntegrateOption.KEEP_WORKSPACE_VERSION;
            IIntegrateCollision[] dvCollisions = this.m_dvActivity.integrate(((VfsWorkspace)targetWorkspace).m_dvVcr.getAsCollection().getAsWorkspace(), integrateOption);
            if (dvCollisions == null) {
                return new IVfsIntegrateCollision[0];
            }
            IVfsIntegrateCollision[] collisions = new IVfsIntegrateCollision[dvCollisions.length];
            int i = 0;
            while (i < dvCollisions.length) {
                IIntegrateCollision dvCollision = dvCollisions[i];
                collisions[i] = new VfsIntegrateCollision(this.getVfsManager(), dvCollision, targetWorkspace);
                ++i;
            }
            return collisions;
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException(vcmFailure.getMessage(), vcmFailure);
        }
    }

    public void refreshIntegrations() throws VfsException {
        this.checkState();
        this.refreshIntegrationSet();
    }

    public int getIntegrationSequenceNumber(IVfsWorkspace workspace) throws VfsException {
        this.checkState();
        IIntegration dvIntegration = null;
        Iterator dvIntegrationsIterator = this.getIntegrationSet().keySet().iterator();
        while (dvIntegrationsIterator.hasNext()) {
            VfsWorkspace integrationWorkspace = (VfsWorkspace)dvIntegrationsIterator.next();
            if (integrationWorkspace != workspace) continue;
            dvIntegration = (IIntegration)this.getIntegrationSet().get(integrationWorkspace);
            break;
        }
        if (dvIntegration == null) {
            IVfsWorkspace[] integrationWorkspaces = this.getIntegrationWorkspaces();
            int i = 0;
            while (i < integrationWorkspaces.length) {
                IVfsWorkspace integrationWorkspace = integrationWorkspaces[i];
                if (integrationWorkspace == workspace) {
                    dvIntegration = this.getDvIntegration(workspace);
                    break;
                }
                ++i;
            }
        }
        if (dvIntegration != null) {
            try {
                return dvIntegration.getIsn();
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Getting ISN for activity ( " + this + " ) " + "in workspace ( " + workspace + " ) failed" + " ( " + vcmFailure.getMessage() + " )", vcmFailure);
            }
        }
        return -1;
    }

    public Date getIntegrationDate(IVfsWorkspace workspace) throws VfsException {
        this.checkState();
        IResource dvIntegration = null;
        Iterator dvIntegrationsIterator = this.getIntegrationSet().keySet().iterator();
        while (dvIntegrationsIterator.hasNext()) {
            VfsWorkspace integrationWorkspace = (VfsWorkspace)dvIntegrationsIterator.next();
            if (integrationWorkspace != workspace) continue;
            dvIntegration = (IIntegration)this.getIntegrationSet().get(integrationWorkspace);
            break;
        }
        if (dvIntegration == null) {
            IVfsWorkspace[] integrationWorkspaces = this.getIntegrationWorkspaces();
            int i = 0;
            while (i < integrationWorkspaces.length) {
                IVfsWorkspace integrationWorkspace = integrationWorkspaces[i];
                if (integrationWorkspace == workspace) {
                    dvIntegration = this.getDvIntegration(workspace);
                    break;
                }
                ++i;
            }
        }
        if (dvIntegration != null) {
            try {
                IProperty property = dvIntegration.getProperty(DAV.CREATIONDATE.qualifiedName);
                return Converter.parseHTTPDate(property.getValue());
            }
            catch (VcmFailure vcmFailure) {
                throw new VfsException("Getting intergation date for activity ( " + this + " ) " + "in workspace ( " + workspace + " ) failed" + " ( " + vcmFailure.getMessage() + " )", vcmFailure);
            }
        }
        return null;
    }

    private IIntegration getDvIntegration(IVfsWorkspace workspace) throws VfsException {
        try {
            IIntegration[] dvIntegrations = this.m_dvActivity.getIntegrationSet();
            String givenWorkspaceUrl = PathUtilities.preventTrailingSeparator(workspace.getUrl(), PathUtilities.REMOTE_FILESERVICE);
            int i = 0;
            while (i < dvIntegrations.length) {
                IIntegration dvIntegration = dvIntegrations[i];
                String integratedWorkspaceUrl = PathUtilities.preventTrailingSeparator(dvIntegration.getWorkspace().getPersistentURL(), PathUtilities.REMOTE_FILESERVICE);
                if (integratedWorkspaceUrl.equals(givenWorkspaceUrl)) {
                    return dvIntegration;
                }
                ++i;
            }
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting the integration objects for activity ( " + this + " ) " + "in workspace ( " + workspace + " ) failed" + " ( " + vcmFailure.getMessage() + ")", vcmFailure);
        }
        return null;
    }

    public IVfsWorkspace[] getIntegrationWorkspaces() throws VfsException {
        this.checkState();
        return this.refreshIntegrationSet().keySet().toArray(EMPTY_WORKSPACE_ARRAY);
    }

    public String[] getIntegrationWorkspacesUrls() throws VfsException {
        this.checkState();
        IWorkspace[] dvIntegrationWorkspaces = this.getDvIntegrationWorkspaces();
        String[] workspaceUrls = new String[dvIntegrationWorkspaces.length];
        int i = 0;
        while (i < dvIntegrationWorkspaces.length) {
            IWorkspace dvIntegrationWorkspace = dvIntegrationWorkspaces[i];
            workspaceUrls[i] = dvIntegrationWorkspace.getPersistentURL();
            ++i;
        }
        return workspaceUrls;
    }

    private IWorkspace[] getDvIntegrationWorkspaces() throws VfsException {
        IIntegration[] dvIntegrations;
        try {
            dvIntegrations = this.m_dvActivity.getIntegrationSet();
        }
        catch (VcmFailure vcmFailure) {
            String msg = "Getting integration workspaces of activity failed ( " + vcmFailure + " )";
            throw new VfsException(msg + ": " + this.getIdentifyingString(), vcmFailure);
        }
        this.updateIntegrationSet(dvIntegrations);
        ArrayList<IWorkspace> dvIntegrationWorkspaces = new ArrayList<IWorkspace>();
        int i = 0;
        while (i < dvIntegrations.length) {
            block5: {
                IIntegration dvIntegrationObject = dvIntegrations[i];
                IWorkspace dvWorkspace = null;
                try {
                    dvWorkspace = dvIntegrationObject.getWorkspace();
                }
                catch (VcmFailure vcmFailure) {
                    String msg = "Internal error: Getting one of the integration workspaces of activity failed";
                    new VfsException(msg + ": " + this.getIdentifyingString(), vcmFailure);
                    break block5;
                }
                dvIntegrationWorkspaces.add(dvWorkspace);
            }
            ++i;
        }
        return dvIntegrationWorkspaces.toArray(EMPTY_DV_WORKSPACE_ARRAY);
    }

    public boolean isIntegratedIn(IVfsWorkspace workspace) throws VfsException {
        this.checkState();
        if (workspace == null) {
            throw new IllegalArgumentException("Null workspace given");
        }
        this.checkParameterState(workspace);
        if (this.isOpen()) {
            throw new VfsException("Activity can not be integrated into a workspace because it is still open: " + this.getIdentifyingString());
        }
        Iterator dvIntegrationsIterator = this.getIntegrationSet().keySet().iterator();
        while (dvIntegrationsIterator.hasNext()) {
            VfsWorkspace integrationWorkspace = (VfsWorkspace)dvIntegrationsIterator.next();
            if (integrationWorkspace != workspace) continue;
            return true;
        }
        IVfsWorkspace[] integrationWorkspaces = this.getIntegrationWorkspaces();
        int i = 0;
        while (i < integrationWorkspaces.length) {
            IVfsWorkspace integrationWorkspace = integrationWorkspaces[i];
            if (integrationWorkspace == workspace) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isIntegratedIn(String workspaceUrl) throws VfsException {
        this.checkState();
        if (workspaceUrl == null || workspaceUrl.length() < 1) {
            throw new IllegalArgumentException("Empty workspace Url given");
        }
        if (this.isOpen()) {
            throw new VfsException("Activity can not be integrated into a workspace because it is still open: " + this.getIdentifyingString());
        }
        Iterator dvIntegrationsIterator = this.getIntegrationSet().keySet().iterator();
        while (dvIntegrationsIterator.hasNext()) {
            VfsWorkspace workspace = (VfsWorkspace)dvIntegrationsIterator.next();
            if (!workspace.getUrl().equals(workspaceUrl)) continue;
            return true;
        }
        String[] integrationWorkspaceUrls = this.getIntegrationWorkspacesUrls();
        int i = 0;
        while (i < integrationWorkspaceUrls.length) {
            String integrationWorkspaceUrl = integrationWorkspaceUrls[i];
            if (integrationWorkspaceUrl.equals(workspaceUrl)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Map getIntegrationSet() {
        return this.m_integrationSet;
    }

    private void updateIntegrationSet(IIntegration[] dvIntegrations) {
        VfsRepository repository = this.getRepository();
        this.m_integrationSet = new HashMap();
        int i = 0;
        while (i < dvIntegrations.length) {
            block4: {
                IIntegration dvIntegration = dvIntegrations[i];
                IWorkspace dvIntegrationWorkspace = null;
                try {
                    dvIntegrationWorkspace = dvIntegration.getWorkspace();
                }
                catch (VcmFailure vcmFailure) {
                    String msg = "Getting one of the integration workspaces of activity failed ( " + vcmFailure + " )";
                    new VfsException(msg + ": " + this.getIdentifyingString(), vcmFailure);
                    break block4;
                }
                IVfsWorkspace workspace = repository.getWorkspaceByPathFromCache(dvIntegrationWorkspace.getDecodedPath());
                if (workspace != null) {
                    this.m_integrationSet.put(workspace, dvIntegration);
                }
            }
            ++i;
        }
    }

    private Map refreshIntegrationSet() throws VfsException {
        IIntegration[] dvIntegrations;
        try {
            dvIntegrations = this.m_dvActivity.getIntegrationSet();
        }
        catch (VcmFailure vcmFailure) {
            String msg = "Getting integration workspaces of activity failed ( " + vcmFailure + " )";
            throw new VfsException(msg + ": " + this.getIdentifyingString(), vcmFailure);
        }
        this.updateIntegrationSet(dvIntegrations);
        return this.getIntegrationSet();
    }

    static IVfsActivity[] getActivities(VfsRepository repository, IActivityQuery activityQuery, String[] additionalProperties, boolean containingFiles) throws VfsException {
        ArrayList activities = new ArrayList();
        activities.addAll(VfsActivity.getOpenActivities(repository, activityQuery));
        activities.addAll(VfsActivity.getClosedActivities(repository, activityQuery, additionalProperties, containingFiles));
        return activities.toArray(EMPTY_ACTIVITY_ARRAY);
    }

    static Collection getOpenActivities(VfsRepository repository, IActivityQuery activityQuery) {
        ArrayList activities = new ArrayList();
        if (activityQuery.getClosedOnly()) {
            return activities;
        }
        return activities;
    }

    static Collection getClosedActivities(VfsRepository repository, IActivityQuery activityQuery, String[] additionalProperties, boolean containingFiles) throws VfsException {
        IActivityComposite[] activityComposite;
        if (activityQuery.getOpenedOnly()) {
            return new ArrayList();
        }
        IActivityReport activityReport = ActivityReportFactory.getInstance().createReport(repository.getConnectionTemplateId(), repository.getAbsoluteRemotePath());
        IActivity[] visibleClosedDvActivities = new IActivity[]{};
        boolean originalClosedOnly = activityQuery.getClosedOnly();
        boolean originalApplyToActivitiesContainingFiles = activityQuery.getApplyToActivitiesContainingFiles();
        activityQuery.setClosedOnly(true);
        String[] properties = StringUtilities.concatenateStringArrays(VfsActivity.CLOSED_ACTIVITY_COMPOSITE_DEF.activityProperties, additionalProperties);
        ActivityCompositeDef compositeDef = new ActivityCompositeDef();
        compositeDef.activityProperties = properties;
        if (containingFiles && repository.getActivityQueryOptions().containsKey(VfsRepositoryOptions.ActivityQueryOption.CONTAINS_FILES)) {
            activityQuery.applyToActivitiesContainingFiles(true);
        }
        try {
            Object var13_11;
            try {
                activityComposite = activityReport.select(activityQuery, compositeDef);
            }
            catch (VcmFailure vcmFailure) {
                if (vcmFailure.getStatusCode() != 404) {
                    throw new VfsException("Activity report failed" + vcmFailure.getMessage(), vcmFailure);
                }
                LogUtil.traceCaughtException((Location)LOCATION, (Throwable)vcmFailure, (int)300);
                activityComposite = new IActivityComposite[]{};
                var13_11 = null;
                activityQuery.setClosedOnly(originalClosedOnly);
                activityQuery.applyToActivitiesContainingFiles(originalApplyToActivitiesContainingFiles);
            }
            var13_11 = null;
            activityQuery.setClosedOnly(originalClosedOnly);
            activityQuery.applyToActivitiesContainingFiles(originalApplyToActivitiesContainingFiles);
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            activityQuery.setClosedOnly(originalClosedOnly);
            activityQuery.applyToActivitiesContainingFiles(originalApplyToActivitiesContainingFiles);
            throw throwable;
        }
        visibleClosedDvActivities = new IActivity[activityComposite.length];
        int i = 0;
        while (i < activityComposite.length) {
            visibleClosedDvActivities[i] = activityComposite[i].getActivity();
            ++i;
        }
        return VfsActivity.getClosedVfsActivities(repository, Arrays.asList(visibleClosedDvActivities));
    }

    static Collection getClosedVfsActivities(VfsRepository repository, Collection visibleClosedDvActivities) {
        ArrayList<VfsActivity> vfsActivities = new ArrayList<VfsActivity>(visibleClosedDvActivities.size());
        Iterator dvActivityIterator = visibleClosedDvActivities.iterator();
        while (dvActivityIterator.hasNext()) {
            IActivity dvActivity = (IActivity)dvActivityIterator.next();
            VfsActivity vfsActivity = new VfsActivity(repository, dvActivity);
            IWorkspace dvWorkspace = null;
            try {
                dvWorkspace = dvActivity.getWorkspace();
            }
            catch (VcmFailure vcmFailure) {
                VfsException e1 = new VfsException("Getting workspace of activity failed: " + vfsActivity.getIdentifyingString(), vcmFailure);
                String msg = "Getting closed activity failed";
                new VfsException(msg + ": " + VfsActivity.getIdentifyingString(dvActivity), e1);
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.SKIPPED_BUT_WARN, dvActivity, msg);
                continue;
            }
            if (dvWorkspace == null) continue;
            IVfsWorkspace creationWorkspace = repository.getWorkspaceByPathFromCache(dvWorkspace.getDecodedPath());
            if (creationWorkspace != null) {
                vfsActivity.setWorkspaceForClosedActivity(creationWorkspace);
            } else {
                vfsActivity.setInvisibleWorkspace(dvWorkspace);
            }
            vfsActivities.add(vfsActivity);
        }
        return vfsActivities;
    }

    public void uncheckoutUnchangedActivityElements() throws VfsException {
        this.checkState();
        VfsWorkspace workspace = (VfsWorkspace)this.getWorkspace();
        try {
            if (workspace != null) {
                workspace.checkIsModifiable();
            }
        }
        catch (VfsException ex) {
            String msg = "Uncheckout activity is not allowed because workspace is not modifiable";
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, this, msg);
            throw new VfsException(msg + ": " + this.getDisplayName() + " in " + workspace.getBrowsePath(), ex);
        }
        if (this.isPropagationList()) {
            throw new IllegalStateException("Internal error: Found activity that actually is propagation list: " + this.getIdentifyingString());
        }
        if (!this.isOpen()) {
            String msg = "Activity is closed";
            VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.SKIPPED, this, msg);
            LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception(msg + ": " + this.getDisplayName()), (boolean)true);
            return;
        }
        if (this.isEmpty()) {
            String msg = "Activity is empty";
            VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.SKIPPED, this, msg);
            LogUtil.infoLogException((Location)LOCATION, (Throwable)new Exception(msg + ": " + this.getDisplayName()), (boolean)true);
            return;
        }
        List unchangedActivityElements = this.getUnchangedItems();
        if (unchangedActivityElements.isEmpty()) {
            VfsActionRecorder.log(VfsActionType.UNCHECKOUT, VfsActionStatus.SKIPPED, this, "All activity items have been changed");
            return;
        }
        boolean atLeastOneUncheckoutDone = false;
        int i = 0;
        while (i < unchangedActivityElements.size()) {
            block13: {
                block12: {
                    VfsActivityRecordedFolderItem activityElement = (VfsActivityRecordedFolderItem)unchangedActivityElements.get(i);
                    try {
                        activityElement.pureUncheckout(this, VfsActivityRecordedFolderItem.ActionOnLocalDisc.DONT_CHANGE_FILE_CONTENT);
                        activityElement.refreshFolderItemStateAfterUncheckout(this);
                        activityElement.refreshSyncDBEntryAfterUncheckout();
                        IVfsActivityElement element = this.getActivityElement(activityElement.getAbsoluteRemotePath());
                        if (element == null) break block12;
                        ((VfsActivityElement)element).setInvalid(true);
                    }
                    catch (VfsException e) {
                        LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
                        break block13;
                    }
                }
                atLeastOneUncheckoutDone = true;
            }
            ++i;
        }
        if (atLeastOneUncheckoutDone) {
            this.refreshActivityStateAfterUncheckouts(unchangedActivityElements);
        }
        if (atLeastOneUncheckoutDone) {
            this.getVfsManager().fireEventActivityItemsAddedOrRemoved(this);
        }
    }

    public IVfsActivityRecordedFolderItem[] getUnchangedActivityElements() throws VfsException {
        this.checkState();
        if (this.isPropagationList()) {
            throw new IllegalStateException("Internal error: Found activity that actually is propagation list: " + this.getIdentifyingString());
        }
        return this.getUnchangedItems().toArray(EMPTY_OPEN_ACTIVITY_ITEMS);
    }

    private List getUnchangedItems() throws VfsException {
        ArrayList<VfsActivityRecordedFolderItem> unchangedActivityElements = new ArrayList<VfsActivityRecordedFolderItem>();
        IVfsActivityRecordedFolderItem[] activityElements = this.getElementsFromOpenActivity();
        int i = 0;
        while (i < activityElements.length) {
            VfsActivityRecordedFolderItem activityElement = (VfsActivityRecordedFolderItem)activityElements[i];
            if (!activityElement.hasActivityRecordedChangesIn(this)) {
                unchangedActivityElements.add(activityElement);
            }
            ++i;
        }
        return unchangedActivityElements;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VfsActivity)) {
            return false;
        }
        VfsActivity activityToCompareWith = (VfsActivity)obj;
        boolean sameObjectIds = false;
        try {
            sameObjectIds = this.pureGetObjectId().equals(activityToCompareWith.pureGetObjectId());
            if (this.pureGetState() == VfsActivityState.OPEN && sameObjectIds) {
                throw new VfsRuntimeException("Internal error: two instances of same open activity detected (" + this.getUrl() + ").");
            }
        }
        catch (VfsException e) {
            throw new VfsRuntimeException(e.getMessage(), e);
        }
        return sameObjectIds;
    }

    public int hashCode() {
        try {
            return this.pureGetObjectId().hashCode();
        }
        catch (VfsException e) {
            throw new VfsRuntimeException(e.getMessage(), e);
        }
    }

    public boolean isForeign() throws VfsException {
        this.checkState();
        return VfsActivity.isForeignDvActivity(this.getRepository(), this.getDeltaVActivity());
    }

    public IVfsActivity getAsClosedActivity() {
        this.checkState();
        try {
            if (!this.isOpen() && !VfsActivity.isPropagationList(this.getDeltaVActivity())) {
                return this;
            }
        }
        catch (VfsException e) {
            LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
            return null;
        }
        return null;
    }

    public IVfsPropagationList getAsPropagationList() {
        this.checkState();
        try {
            if (this.isPropagationList()) {
                return this;
            }
        }
        catch (VfsException e) {
            LogUtil.traceCaughtException((Location)LOCATION, (Throwable)e, (int)300);
            return null;
        }
        return null;
    }

    public IVfsVersion[] getElementsFromVersionSet() throws VfsException {
        return this.getElementsFromClosedActivity();
    }

    public Date getLastModified() throws VfsException {
        return this.getCheckedInDate();
    }

    private static boolean isPropagationList(IActivity dvActivity) throws VfsException {
        String resourceType = null;
        try {
            IProperty property = dvActivity.getProperty(VfsXcmProperty.RESOURCE_TYPE.getCompletePropertyName());
            resourceType = property == null ? null : property.getValue();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting type of version set failed (" + vcmFailure.getMessage() + "): " + dvActivity.getPath(), vcmFailure);
        }
        return resourceType != null && resourceType.equals("PROPAGATION_LIST");
    }

    private boolean isPropagationList() throws VfsException {
        return VfsActivity.isPropagationList(this.getDeltaVActivity());
    }

    public String getPropagationRequestID() throws VfsException {
        this.checkState();
        try {
            IProperty property = this.getDeltaVActivity().getProperty(VfsXcmProperty.PROPAGATION_REQUEST_ID.getCompletePropertyName());
            return property == null ? null : property.getValue();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting type of version set failed (" + vcmFailure.getMessage() + "): " + this.getIdentifyingString(), vcmFailure);
        }
    }

    void checkPreconditionForCollisionResolving(String absoluteRemotePathOfCorrespondingFolderItemToVersion) throws VfsException {
        if (this.m_activityElements.containsKey(absoluteRemotePathOfCorrespondingFolderItemToVersion)) {
            throw new VfsException("The corresponding file " + absoluteRemotePathOfCorrespondingFolderItemToVersion + " is already checked-out in the activity [" + this.getIdentifyingString() + "].");
        }
    }

    void checkPreconditionConcerningCollisionResolving(IVfsFile file) throws VfsException {
        Iterator iter = this.m_activityElements.values().iterator();
        while (iter.hasNext()) {
            IVfsActivityElement activityElement = (IVfsActivityElement)iter.next();
            IVfsVersion version = activityElement.getAsVersion();
            if (version == null) continue;
            IVfsFile vfsFile = version.getCorrespondingFile(this.getWorkspace());
            String path = file.getAbsoluteRemotePath();
            if (vfsFile == null || !vfsFile.getAbsoluteRemotePath().equals(path)) continue;
            throw new VfsException("A discard target version of the resource is already in the activity \"" + this.getIdentifyingString() + "\".");
        }
    }

    public Object[] getChildrenObjects() throws VfsException {
        return this.getVfsManager().getPropertiesFeature().getChildrenObjects(this.getDeltaVActivity());
    }

    public boolean isForceIntegrated(String workspaceRemotePath) throws VfsException {
        IResource dvIntegration = null;
        Iterator dvIntegrationsIterator = this.getIntegrationSet().keySet().iterator();
        while (dvIntegrationsIterator.hasNext()) {
            VfsWorkspace integrationWorkspace = (VfsWorkspace)dvIntegrationsIterator.next();
            if (!integrationWorkspace.getAbsoluteRemotePath().equalsIgnoreCase(workspaceRemotePath)) continue;
            dvIntegration = (IIntegration)this.getIntegrationSet().get(integrationWorkspace);
            break;
        }
        if (dvIntegration != null) {
            try {
                IProperty integrationOptions = dvIntegration.getProperty(XCM.INTEGRATION_OPTIONS.qualifiedName);
                if (integrationOptions != null && integrationOptions.getFirstChild() != null && integrationOptions.getFirstChild().getName().equalsIgnoreCase(XCM.FORCE_INTEGRATE.localName)) {
                    return true;
                }
            }
            catch (VcmFailure e) {
                throw new VfsException("Error occured while fetching Integration options : " + e.getMessage());
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String[] CLOSED_ACTIVITY_BASIS_PROPERTY_NAMES = new String[]{"DAV:displayname", "DAV:getlastmodified", "DAV:creator-displayname", VfsXcmProperty.VERSION_SET_STATE.getCompletePropertyName(), VfsXcmClientProperty.WORKSPACE.getCompletePropertyName(), VfsXcmClientProperty.DEFAULT_ACTIVITY.getCompletePropertyName(), VfsXcmClientProperty.CLIENT_ID.getCompletePropertyName(), VfsXcmProperty.OBJECT_ID.getCompletePropertyName(), VfsXcmProperty.RESOURCE_TYPE.getCompletePropertyName(), "DAV:workspace"};
        String[] CLOSED_ACTIVITY_CONTENT_PROPERTY_NAMES = new String[]{"DAV:displayname", "DAV:resourcetype", VfsXcmProperty.PATH.getCompletePropertyName(), VfsXcmProperty.DELETED.getCompletePropertyName(), VfsXcmProperty.OBJECT_ID.getCompletePropertyName(), "DAV:getetag", "DAV:creator-displayname", "DAV:getcontentlength", "DAV:getcontenttype", "DAV:getlastmodified", "DAV:displayname", VfsXcmProperty.SEQUENCE_NUMBER.getCompletePropertyName(), VfsXcmProperty.RESOURCE_ID.getCompletePropertyName()};
        CLOSED_ACTIVITY_COMPOSITE_DEF = new ActivityCompositeDef();
        VfsActivity.CLOSED_ACTIVITY_COMPOSITE_DEF.activityProperties = CLOSED_ACTIVITY_BASIS_PROPERTY_NAMES;
        VfsActivity.CLOSED_ACTIVITY_COMPOSITE_DEF.versionSetProperties = CLOSED_ACTIVITY_CONTENT_PROPERTY_NAMES;
        String[] OPEN_ACTIVITY_BASIS_PROPERTY_NAMES = new String[]{"DAV:displayname", "DAV:workspace", "DAV:creator-displayname", VfsXcmProperty.VERSION_SET_STATE.getCompletePropertyName(), VfsXcmClientProperty.WORKSPACE.getCompletePropertyName(), VfsXcmClientProperty.DEFAULT_ACTIVITY.getCompletePropertyName(), VfsXcmClientProperty.CLIENT_ID.getCompletePropertyName(), VfsXcmProperty.OBJECT_ID.getCompletePropertyName(), VfsXcmProperty.RESOURCE_TYPE.getCompletePropertyName()};
        String[] OPEN_ACTIVITY_CONTENT_PROPERTY_NAMES = new String[]{"DAV:displayname", "DAV:auto-update", "DAV:resourcetype", "DAV:getcontentlength", VfsXcmProperty.PATH.getCompletePropertyName(), VfsXcmProperty.DELETED.getCompletePropertyName(), VfsXcmProperty.OBJECT_ID.getCompletePropertyName(), VfsXcmProperty.HAS_FOREIGN_CHECKOUT.getCompletePropertyName(), VfsXcmProperty.RESOURCE_TYPE.getCompletePropertyName()};
        String[] OPEN_ACTIVITY_VCR_PROPERTY_NAMES = new String[]{VfsXcmProperty.OBJECT_ID.getCompletePropertyName(), VfsXcmProperty.PATH.getCompletePropertyName(), VfsXcmProperty.DELETED.getCompletePropertyName(), VfsXcmProperty.HAS_FOREIGN_CHECKOUT.getCompletePropertyName(), VfsXcmProperty.EXCLUSIVE_CHECKOUT.getCompletePropertyName(), "DAV:displayname", "DAV:resourcetype", "DAV:workspace", "DAV:getlastmodified", "DAV:creationdate", "DAV:creator-displayname", "DAV:checked-in", "DAV:getetag", "DAV:getcontentlength"};
        OPEN_ACTIVITY_COMPOSITE_DEF = new ActivityCompositeDef();
        VfsActivity.OPEN_ACTIVITY_COMPOSITE_DEF.activityProperties = OPEN_ACTIVITY_BASIS_PROPERTY_NAMES;
        VfsActivity.OPEN_ACTIVITY_COMPOSITE_DEF.activityContentProperties = OPEN_ACTIVITY_CONTENT_PROPERTY_NAMES;
        if (!EnvironmentVariables.FORCE_CLASSIC_OPEN_ACTIVITY_QUERY) {
            VfsActivity.OPEN_ACTIVITY_COMPOSITE_DEF.vcrProperties = OPEN_ACTIVITY_VCR_PROPERTY_NAMES;
        }
        String[] EMPTY_ACTIVITY_BASIS_PROPERTY_NAMES = new String[]{"DAV:displayname", VfsXcmProperty.ACTIVITY_CONTENT_SET.getCompletePropertyName(), VfsXcmProperty.VERSION_SET_STATE.getCompletePropertyName(), VfsXcmClientProperty.WORKSPACE.getCompletePropertyName(), VfsXcmClientProperty.DEFAULT_ACTIVITY.getCompletePropertyName(), VfsXcmClientProperty.CLIENT_ID.getCompletePropertyName(), VfsXcmProperty.RESOURCE_TYPE.getCompletePropertyName()};
        EMPTY_ACTIVITY_COMPOSITE_DEF = new ActivityCompositeDef();
        VfsActivity.EMPTY_ACTIVITY_COMPOSITE_DEF.activityProperties = EMPTY_ACTIVITY_BASIS_PROPERTY_NAMES;
        EMPTY_STRING_ARRAY = new String[0];
        EMPTY_WORKSPACE_ARRAY = new IVfsWorkspace[0];
        EMPTY_DV_WORKSPACE_ARRAY = new IWorkspace[0];
        EMPTY_ACTIVITY_ARRAY = new IVfsActivity[0];
        EMPTY_OPEN_ACTIVITY_ITEMS = new IVfsActivityRecordedFolderItem[0];
        EMPTY_CLOSED_ACTIVITY_ITEMS = new IVfsVersion[0];
        EMPTY_ACTIVITY_ELEMENTS = new IVfsActivityElement[0];
        EMPTY_CHECKIN_COLLISIONS = new IVfsCheckinCollision[0];
        EMPTY_ACTIONS_ARRAY = new VfsActionOnActivity[0];
        DEFAULT_ACTIVITY_PROPERTY_NAME_ARRAY = new String[]{VfsXcmClientProperty.DEFAULT_ACTIVITY.getCompletePropertyName()};
        DEFAULT_ACTIVITY_PROPERTY_NAME = VfsXcmClientProperty.DEFAULT_ACTIVITY.getCompletePropertyName();
        DEFAULT_ACTIVITY_PROPERTY_ARRAY = new IProperty[]{PropertyFactoryAccess.getFactory().createProperty(VfsXcmClientProperty.getNamespacePrefix(), VfsXcmClientProperty.DEFAULT_ACTIVITY.getPropertyName())};
        hexValuesOfCharacters = new String[]{"_00_", "_01_", "_02_", "_03_", "_04_", "_05_", "_06_", "_07_", "_08_", "_09_", "_0a_", "_0b_", "_0c_", "_0d_", "_0e_", "_0f_", "_10_", "_11_", "_12_", "_13_", "_14_", "_15_", "_16_", "_17_", "_18_", "_19_", "_1a_", "_1b_", "_1c_", "_1d_", "_1e_", "_1f_", "_20_", "_21_", "_22_", "_23_", "_24_", "_25_", "_26_", "_27_", "_28_", "_29_", "_2a_", "_2b_", "_2c_", "_2d_", "_2e_", "_2f_", "_30_", "_31_", "_32_", "_33_", "_34_", "_35_", "_36_", "_37_", "_38_", "_39_", "_3a_", "_3b_", "_3c_", "_3d_", "_3e_", "_3f_", "_40_", "_41_", "_42_", "_43_", "_44_", "_45_", "_46_", "_47_", "_48_", "_49_", "_4a_", "_4b_", "_4c_", "_4d_", "_4e_", "_4f_", "_50_", "_51_", "_52_", "_53_", "_54_", "_55_", "_56_", "_57_", "_58_", "_59_", "_5a_", "_5b_", "_5c_", "_5d_", "_5e_", "_5f_", "_60_", "_61_", "_62_", "_63_", "_64_", "_65_", "_66_", "_67_", "_68_", "_69_", "_6a_", "_6b_", "_6c_", "_6d_", "_6e_", "_6f_", "_70_", "_71_", "_72_", "_73_", "_74_", "_75_", "_76_", "_77_", "_78_", "_79_", "_7a_", "_7b_", "_7c_", "_7d_", "_7e_", "_7f_", "_80_", "_81_", "_82_", "_83_", "_84_", "_85_", "_86_", "_87_", "_88_", "_89_", "_8a_", "_8b_", "_8c_", "_8d_", "_8e_", "_8f_", "_90_", "_91_", "_92_", "_93_", "_94_", "_95_", "_96_", "_97_", "_98_", "_99_", "_9a_", "_9b_", "_9c_", "_9d_", "_9e_", "_9f_", "_a0_", "_a1_", "_a2_", "_a3_", "_a4_", "_a5_", "_a6_", "_a7_", "_a8_", "_a9_", "_aa_", "_ab_", "_ac_", "_ad_", "_ae_", "_af_", "_b0_", "_b1_", "_b2_", "_b3_", "_b4_", "_b5_", "_b6_", "_b7_", "_b8_", "_b9_", "_ba_", "_bb_", "_bc_", "_bd_", "_be_", "_bf_", "_c0_", "_c1_", "_c2_", "_c3_", "_c4_", "_c5_", "_c6_", "_c7_", "_c8_", "_c9_", "_ca_", "_cb_", "_cc_", "_cd_", "_ce_", "_cf_", "_d0_", "_d1_", "_d2_", "_d3_", "_d4_", "_d5_", "_d6_", "_d7_", "_d8_", "_d9_", "_da_", "_db_", "_dc_", "_dd_", "_de_", "_df_", "_e0_", "_e1_", "_e2_", "_e3_", "_e4_", "_e5_", "_e6_", "_e7_", "_e8_", "_e9_", "_ea_", "_eb_", "_ec_", "_ed_", "_ee_", "_ef_", "_f0_", "_f1_", "_f2_", "_f3_", "_f4_", "_f5_", "_f6_", "_f7_", "_f8_", "_f9_", "_fa_", "_fb_", "_fc_", "_fd_", "_fe_", "_ff_"};
    }
}

