/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.IVfsActionRecorderListener;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionEntry;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;

public class VfsActionRecorder
implements IVfsActionRecorder {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$VfsActionRecorder == null ? (class$com$tssap$dtr$client$lib$vfs$impl$VfsActionRecorder = VfsActionRecorder.class$("com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder")) : class$com$tssap$dtr$client$lib$vfs$impl$VfsActionRecorder));
    private HashSet m_listeners = new HashSet();
    private ArrayList m_actionEntries = new ArrayList();
    private long m_startTime;
    private long m_duration;
    private int m_filesSucceeded;
    private int m_filesSkipped;
    private int m_filesFailed;
    private long m_bytesSucceeded;
    private long m_bytesSkipped;
    private long m_bytesFailed;
    private int m_foldersSucceeded;
    private int m_foldersSkipped;
    private int m_foldersFailed;
    private static ThreadLocal g_actionRecorder = new ThreadLocal(){

        protected Object initialValue() {
            return new VfsActionRecorder();
        }
    };
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$VfsActionRecorder;

    private VfsActionRecorder() {
    }

    static void log(VfsActionType type, VfsActionStatus status, Object involvedObject, String details) {
        VfsActionRecorder.getInstance().internalLog(type, status, involvedObject, details);
    }

    static void log(VfsActionType type, VfsActionStatus status, Object involvedObject, String details, int involvedObjectType) {
        VfsActionRecorder.getInstance().internalLog(type, status, involvedObject, details, involvedObjectType);
    }

    public static VfsActionRecorder getInstance() {
        return (VfsActionRecorder)g_actionRecorder.get();
    }

    public Iterator getActionEntries(VfsActionType type, VfsActionStatus status, int involvedType, long startTime, long endTime) {
        ArrayList<IVfsActionRecorder.ActionEntry> matchingEntries = new ArrayList<IVfsActionRecorder.ActionEntry>();
        int i = 0;
        while (i < this.m_actionEntries.size()) {
            IVfsActionRecorder.ActionEntry entry = (IVfsActionRecorder.ActionEntry)this.m_actionEntries.get(i);
            if (!(type != null && type != entry.getType() || status != null && status != entry.getStatus() || involvedType != -1 && involvedType != entry.getInvolvedType() || entry.getTimestamp() < startTime || entry.getTimestamp() > endTime)) {
                matchingEntries.add(entry);
            }
            ++i;
        }
        return ((AbstractList)matchingEntries).iterator();
    }

    public void addActionRecorderListener(IVfsActionRecorderListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeActionRecorderListener(IVfsActionRecorderListener listener) {
        this.m_listeners.remove(listener);
    }

    public void start() {
        this.m_actionEntries.clear();
        this.m_startTime = System.currentTimeMillis();
        Logbook.getPlainChapter().println("");
    }

    public void finish() {
        this.updateStatistics();
        this.printStatistics();
        Logbook.getPlainChapter().println("");
        this.m_startTime = 0L;
    }

    void relogErrorsAndWarnings() {
        boolean problemsOccured = false;
        int i = 0;
        while (i < this.m_actionEntries.size()) {
            IVfsActionRecorder.ActionEntry entry = (IVfsActionRecorder.ActionEntry)this.m_actionEntries.get(i);
            if (entry.getStatus() == VfsActionStatus.FAILED || entry.getStatus() == VfsActionStatus.SKIPPED_BUT_WARN) {
                if (!problemsOccured) {
                    problemsOccured = true;
                    Logbook.getInfoChapter().println("--- Problem summary: ---");
                }
                this.logEntry(entry);
            }
            ++i;
        }
    }

    void appendCount(StringBuffer buffer, String subject, String verb, int itemCount, long byteCount) {
        if (itemCount > 0) {
            buffer.append(itemCount);
            buffer.append(" ");
            buffer.append(subject);
            if (itemCount != 1) {
                buffer.append("s");
            }
            buffer.append(" ");
            buffer.append(verb);
            if (byteCount > 0L) {
                buffer.append(" (");
                buffer.append(byteCount);
                buffer.append(" bytes)");
            }
            buffer.append(". ");
        }
    }

    void printStatistics() {
        this.relogErrorsAndWarnings();
        StringBuffer msg = new StringBuffer();
        this.appendTimestamp(System.currentTimeMillis(), msg);
        msg.append(" ==> ");
        this.appendDuration(msg);
        msg.append(" ");
        this.appendCount(msg, "file", "succeeded", this.m_filesSucceeded, this.m_bytesSucceeded);
        this.appendCount(msg, "file", "skipped", this.m_filesSkipped, this.m_bytesSkipped);
        this.appendCount(msg, "file", "failed", this.m_filesFailed, this.m_bytesFailed);
        this.appendCount(msg, "folder", "succeeded", this.m_foldersSucceeded, 0L);
        this.appendCount(msg, "folder", "skipped", this.m_foldersSkipped, 0L);
        this.appendCount(msg, "folder", "failed", this.m_foldersFailed, 0L);
        Logbook.getInfoChapter().println(msg);
    }

    private void appendDuration(StringBuffer msg) {
        msg.append("Finished in ");
        if (this.m_duration < 2000L) {
            msg.append(this.m_duration);
            msg.append("ms.");
        } else {
            long durationInSeconds = this.m_duration / 1000L;
            if (durationInSeconds >= 60L) {
                msg.append(durationInSeconds / 60L);
                msg.append(":");
                long seconds = durationInSeconds % 60L;
                if (seconds < 10L) {
                    msg.append("0");
                }
                msg.append(seconds);
                msg.append("min.");
            } else {
                msg.append(durationInSeconds);
                msg.append("s.");
            }
        }
    }

    void updateStatistics() {
        this.resetStatistics();
        this.m_duration = System.currentTimeMillis() - this.m_startTime;
        int i = 0;
        while (i < this.m_actionEntries.size()) {
            IVfsActionRecorder.ActionEntry entry = (IVfsActionRecorder.ActionEntry)this.m_actionEntries.get(i);
            if (entry.getInvolvedType() == 1) {
                if (entry.getStatus() == VfsActionStatus.SUCCEEDED) {
                    ++this.m_filesSucceeded;
                    this.m_bytesSucceeded += entry.getInvolvedFileSize();
                } else if (entry.getStatus() == VfsActionStatus.SKIPPED || entry.getStatus() == VfsActionStatus.SKIPPED_BUT_WARN) {
                    ++this.m_filesSkipped;
                    this.m_bytesSkipped += entry.getInvolvedFileSize();
                } else if (entry.getStatus() == VfsActionStatus.FAILED) {
                    ++this.m_filesFailed;
                    this.m_bytesFailed += entry.getInvolvedFileSize();
                } else if (entry.getStatus() != VfsActionStatus.PENDING && entry.getStatus() != VfsActionStatus.INTERRUPTED && entry.getStatus() != VfsActionStatus.PLAIN_LOG && entry.getStatus() != VfsActionStatus.INFO_LOG && entry.getStatus() != VfsActionStatus.WARN_LOG && entry.getStatus() != VfsActionStatus.ERROR_LOG) {
                    new IllegalStateException("WARNING: Unknown VfsActionStatus: " + entry.getStatus()).printStackTrace();
                }
            } else if (entry.getInvolvedType() == 2) {
                if (entry.getStatus() == VfsActionStatus.SUCCEEDED) {
                    ++this.m_foldersSucceeded;
                } else if (entry.getStatus() == VfsActionStatus.SKIPPED || entry.getStatus() == VfsActionStatus.SKIPPED_BUT_WARN) {
                    ++this.m_foldersSkipped;
                } else if (entry.getStatus() == VfsActionStatus.FAILED) {
                    ++this.m_foldersFailed;
                } else if (entry.getStatus() != VfsActionStatus.PENDING && entry.getStatus() != VfsActionStatus.INTERRUPTED && entry.getStatus() != VfsActionStatus.PLAIN_LOG && entry.getStatus() != VfsActionStatus.INFO_LOG && entry.getStatus() != VfsActionStatus.WARN_LOG && entry.getStatus() != VfsActionStatus.ERROR_LOG) {
                    new IllegalStateException("WARNING: Unknown VfsActionStatus: " + entry.getStatus()).printStackTrace();
                }
            }
            ++i;
        }
    }

    void resetStatistics() {
        this.m_duration = 0L;
        this.m_filesSucceeded = 0;
        this.m_filesSkipped = 0;
        this.m_filesFailed = 0;
        this.m_bytesSucceeded = 0L;
        this.m_bytesSkipped = 0L;
        this.m_bytesFailed = 0L;
        this.m_foldersSucceeded = 0;
        this.m_foldersSkipped = 0;
        this.m_foldersFailed = 0;
    }

    void internalLog(VfsActionType type, VfsActionStatus status, Object involvedObject, String details, int involvedObjectType) {
        VfsActionEntry actionEntry = new VfsActionEntry(type, status, involvedObject, details, involvedObjectType);
        if (this.m_startTime > 0L) {
            this.m_actionEntries.add(actionEntry);
        }
        this.logEntry(actionEntry);
        Iterator listeners = this.m_listeners.iterator();
        while (listeners.hasNext()) {
            IVfsActionRecorderListener listener = (IVfsActionRecorderListener)listeners.next();
            try {
                listener.logEntry(actionEntry);
            }
            catch (Exception e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    void internalLog(VfsActionType type, VfsActionStatus status, Object involvedObject, String details) {
        this.internalLog(type, status, involvedObject, details, -1);
    }

    private boolean hideEntry(IVfsActionRecorder.ActionEntry entry) {
        if ((entry.getType() == VfsActionType.SYNC || entry.getType() == VfsActionType.UPDATE || entry.getType() == VfsActionType.CREATE) && entry.getStatus() == VfsActionStatus.SUCCEEDED && entry.getInvolvedType() == 2) {
            return true;
        }
        return (entry.getType() == VfsActionType.SYNC || entry.getType() == VfsActionType.UPDATE || entry.getType() == VfsActionType.CREATE) && entry.getStatus() == VfsActionStatus.SKIPPED && entry.getInvolvedType() == 1;
    }

    private void logEntry(IVfsActionRecorder.ActionEntry entry) {
        StringBuffer msg = new StringBuffer();
        this.appendTimestamp(entry.getTimestamp(), msg);
        msg.append("  ");
        VfsActionType actionType = entry.getType();
        if (actionType == VfsActionType.UNSPECIFIED) {
            msg.append(entry.getStatus());
            msg.append(": ");
            msg.append(entry.getDetails());
            if (entry.getInvolvedDescription() != null) {
                msg.append("  =>");
            }
        } else {
            msg.append(actionType);
            if (entry.getDetails() != null && entry.getDetails().length() > 0 || entry.getStatus() != VfsActionStatus.SUCCEEDED) {
                msg.append("  (");
                if (entry.getStatus() != VfsActionStatus.SUCCEEDED) {
                    msg.append(entry.getStatus());
                    msg.append(": ");
                }
                if (entry.getDetails() != null && entry.getDetails().length() > 0) {
                    msg.append(entry.getDetails());
                }
                msg.append(")");
            }
        }
        if (entry.getInvolvedDescription() != null) {
            msg.append("  ");
            msg.append(entry.getInvolvedDescription());
        }
        String msgString = msg.toString();
        if (entry.getStatus() == VfsActionStatus.SUCCEEDED && entry.getType() == VfsActionType.EDIT && entry.getDetails() != null) {
            Logbook.getInfoChapter(this.hideEntry(entry) ? 2 : 3).println(msgString);
        } else if (entry.getStatus() == VfsActionStatus.SUCCEEDED || entry.getStatus() == VfsActionStatus.PENDING || entry.getStatus() == VfsActionStatus.PLAIN_LOG) {
            Logbook.getPlainChapter(this.hideEntry(entry) ? 2 : 3).println(msgString);
        } else if (entry.getStatus() == VfsActionStatus.SKIPPED || entry.getStatus() == VfsActionStatus.INFO_LOG) {
            Logbook.getInfoChapter(this.hideEntry(entry) ? 2 : 3).println(msgString);
        } else if (entry.getStatus() == VfsActionStatus.INTERRUPTED || entry.getStatus() == VfsActionStatus.SKIPPED_BUT_WARN || entry.getStatus() == VfsActionStatus.WARN_LOG) {
            Logbook.getWarnChapter(this.hideEntry(entry) ? 2 : 3).println(msgString);
        } else if (entry.getStatus() == VfsActionStatus.FAILED || entry.getStatus() == VfsActionStatus.ERROR_LOG) {
            Logbook.getErrorChapter(this.hideEntry(entry) ? 2 : 3).println(msgString);
        }
    }

    private void appendTimestamp(long timestamp, StringBuffer outputBuffer) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(timestamp));
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int milli = calendar.get(14);
        if (hour < 10) {
            outputBuffer.append("0");
        }
        outputBuffer.append(hour);
        outputBuffer.append(":");
        if (minute < 10) {
            outputBuffer.append("0");
        }
        outputBuffer.append(minute);
        outputBuffer.append(":");
        if (second < 10) {
            outputBuffer.append("0");
        }
        outputBuffer.append(second);
        outputBuffer.append(".");
        if (milli < 100) {
            outputBuffer.append("0");
            if (milli < 10) {
                outputBuffer.append("0");
            }
        }
        outputBuffer.append(milli);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

