/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import java.lang.ref.WeakReference;

class VfsActionEntry
implements IVfsActionRecorder.ActionEntry {
    private VfsActionType m_type;
    private VfsActionStatus m_status;
    private WeakReference m_involvedObject;
    private String m_details;
    private long m_timestamp;
    private int m_involvedType;
    private long m_involvedFileLength;
    private String m_involvedDescription;
    private static Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$VfsActionEntry == null ? (class$com$tssap$dtr$client$lib$vfs$impl$VfsActionEntry = VfsActionEntry.class$("com.tssap.dtr.client.lib.vfs.impl.VfsActionEntry")) : class$com$tssap$dtr$client$lib$vfs$impl$VfsActionEntry));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$VfsActionEntry;

    VfsActionEntry(VfsActionType type, VfsActionStatus status, Object involvedObject, String details, int involvedObjectType) {
        this.m_involvedType = involvedObjectType == -1 ? this.detectInvolvedType(involvedObject) : involvedObjectType;
        this.m_type = type;
        this.m_status = status;
        this.m_involvedObject = new WeakReference<Object>(involvedObject);
        this.m_details = details;
        this.m_timestamp = System.currentTimeMillis();
        if (this.m_involvedType == 1) {
            this.m_involvedFileLength = VfsActionEntry.getFileLength(involvedObject);
        }
        this.m_involvedDescription = this.detectInvolvedDescription(involvedObject);
    }

    VfsActionEntry(VfsActionType type, VfsActionStatus status, Object involvedObject, String details) {
        this(type, status, involvedObject, details, -1);
    }

    private int detectInvolvedType(Object involvedObject) {
        if (involvedObject instanceof IVfsFile) {
            return 1;
        }
        if (involvedObject instanceof IVirtualFile && !((IVirtualFile)involvedObject).isDirectory()) {
            return 1;
        }
        if (involvedObject instanceof IVirtualFile && ((IVirtualFile)involvedObject).isDirectory()) {
            return 2;
        }
        if (involvedObject instanceof IVfsGenericFolder) {
            return 2;
        }
        if (involvedObject instanceof IVfsActivity) {
            return 3;
        }
        return 0;
    }

    private String detectInvolvedDescription(Object involvedObject) {
        if (involvedObject == null) {
            return null;
        }
        StringBuffer msg = new StringBuffer();
        String quick = "";
        String detail = "";
        if (involvedObject instanceof IVfsFolderItem) {
            IVfsFolderItem folderItem = (IVfsFolderItem)involvedObject;
            quick = folderItem.getName();
            detail = folderItem.getLocalPath();
            if (detail == null) {
                try {
                    detail = folderItem.getBrowsePath();
                }
                catch (VfsException e) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                    detail = "unknown browse path (make sure the file is mounted)";
                }
            }
        } else if (involvedObject instanceof IVirtualFile) {
            IVirtualFile file = (IVirtualFile)involvedObject;
            quick = file.getName();
            detail = file.getAbsolutePath();
        } else if (involvedObject instanceof IVfsActivity) {
            IVfsActivity activity = (IVfsActivity)involvedObject;
            try {
                quick = activity.getDisplayName();
            }
            catch (VfsException e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                quick = "?";
            }
            detail = activity.getName();
        } else {
            return String.valueOf(involvedObject);
        }
        msg.append(quick);
        msg.append("   (");
        msg.append(detail);
        msg.append(")");
        return msg.toString();
    }

    public String getInvolvedDescription() {
        return this.m_involvedDescription;
    }

    public int getInvolvedType() {
        return this.m_involvedType;
    }

    public long getInvolvedFileSize() {
        return this.m_involvedFileLength;
    }

    public Object getInvolvedObject() {
        return this.m_involvedObject.get();
    }

    public VfsActionStatus getStatus() {
        return this.m_status;
    }

    public VfsActionType getType() {
        return this.m_type;
    }

    public String getDetails() {
        return this.m_details;
    }

    public long getTimestamp() {
        return this.m_timestamp;
    }

    private static long getFileLength(Object involvedFile) {
        if (involvedFile instanceof IVfsFile) {
            try {
                return ((IVfsFile)involvedFile).getLength();
            }
            catch (VfsException e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                return 0L;
            }
        }
        if (involvedFile instanceof IVirtualFile && ((IVirtualFile)involvedFile).isFile()) {
            return ((IVirtualFile)involvedFile).length();
        }
        return 0L;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

