/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.ConnectionPool;
import com.tssap.dtr.client.lib.deltavlib.ICollection;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.IWorkspace;
import com.tssap.dtr.client.lib.deltavlib.PathEncodingFlag;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.ResourceFactoryManager;
import com.tssap.dtr.client.lib.exceptions.ExceptionCategory;
import com.tssap.dtr.client.lib.exceptions.ExceptionSeverity;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.EnvironmentVariables;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.util.StringUtilities;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityListener;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsCheckinCollision;
import com.tssap.dtr.client.lib.vfs.IVfsCollision;
import com.tssap.dtr.client.lib.vfs.IVfsCollisionListener;
import com.tssap.dtr.client.lib.vfs.IVfsCollisionQuery;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsEventManager;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItemListener;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItemListener2;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.IVfsManagerListener;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.IVfsRepository;
import com.tssap.dtr.client.lib.vfs.IVfsRootFolder;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersionGraph;
import com.tssap.dtr.client.lib.vfs.IVfsVersionHistory;
import com.tssap.dtr.client.lib.vfs.IVfsVersionListener;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsExceptionCategory;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.VfsRuntimeException;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.impl.AllowedActionsFeature;
import com.tssap.dtr.client.lib.vfs.impl.FolderItemCache;
import com.tssap.dtr.client.lib.vfs.impl.FolderUtil;
import com.tssap.dtr.client.lib.vfs.impl.PropertiesFeature;
import com.tssap.dtr.client.lib.vfs.impl.SyncRemoveFeature;
import com.tssap.dtr.client.lib.vfs.impl.SyncRemoveFeatureClassic;
import com.tssap.dtr.client.lib.vfs.impl.SyncRemoveFeatureMget;
import com.tssap.dtr.client.lib.vfs.impl.Util;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsAmbiguousFolder;
import com.tssap.dtr.client.lib.vfs.impl.VfsCollisionQuery;
import com.tssap.dtr.client.lib.vfs.impl.VfsEventManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolder;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsListenerHandler;
import com.tssap.dtr.client.lib.vfs.impl.VfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.impl.VfsRepository;
import com.tssap.dtr.client.lib.vfs.impl.VfsSpecialPaths;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersionGraph;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspace;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspaceFolder;
import com.tssap.dtr.client.lib.vfs.impl.VfsXcmClientProperty;
import com.tssap.dtr.client.lib.vfs.impl.WrongCaseOfFolderPathUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class VersionedFileSystemManager
implements IVersionedFileSystemManager {
    private static HashMap m_vfsManagers;
    private IVfsContext m_context;
    private boolean m_invalid = false;
    private boolean m_initialized = false;
    private HashMap m_repositories = new HashMap();
    private HashMap m_workspaces = new HashMap();
    private FolderItemCache m_folderItemCache = null;
    private IVfsGenericFolder m_rootFolder = null;
    private final AllowedActionsFeature _allowedActionsFeature = new AllowedActionsFeature();
    private final PropertiesFeature _propertiesFeature = new PropertiesFeature();
    private final VfsListenerHandler m_listenerHandler = new VfsListenerHandler();
    private final VfsEventManager m_eventManager = new VfsEventManager(this);
    private static final IVfsRepository[] EMPTY_REPOSITORY_ARRAY;
    private static final IVfsWorkspace[] EMPTY_WORKSPACE_ARRAY;
    private static final boolean INCLUDE_WORKSPACE_FOLDER = true;
    private static final boolean NOT_INCLUDE_WORKSPACE_FOLDER = false;
    private static final boolean DO_REFRESH = true;
    private static final boolean DONT_REFRESH = false;
    private static final Location LOCATION;
    public static final String CLIENT_VERSION;
    private Object _delayedListeningStopper;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$VersionedFileSystemManager;

    private VersionedFileSystemManager() {
    }

    public static boolean hasVersionedFileSystemManager(IVfsContext context) {
        if (context == null) {
            return false;
        }
        return m_vfsManagers.get(context) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static IVersionedFileSystemManager getVersionedFileSystemManager(IVfsContext context) throws VfsException {
        VersionedFileSystemManager vfsManager;
        block19: {
            if (context == null) {
                throw new IllegalArgumentException("'context' must be non-null");
            }
            vfsManager = (VersionedFileSystemManager)m_vfsManagers.get(context);
            if (vfsManager != null && !vfsManager.isInitialized()) {
                throw new VfsException(ExceptionSeverity.ERROR, VfsExceptionCategory.PARALLEL_THREAD_ACCESS_DURING_INITIALIZATION_OF_VFS_MANAGER, new Object[]{context.getClientName()}, new Throwable[0]);
            }
            if (vfsManager != null) return vfsManager;
            long start = System.currentTimeMillis();
            VersionedFileSystemManager.pingCheck(context);
            VersionedFileSystemManager.clientVersionCheck(context);
            vfsManager = new VersionedFileSystemManager();
            VersionedFileSystemManager existingVfsManager = null;
            HashMap hashMap = m_vfsManagers;
            // MONITORENTER : hashMap
            existingVfsManager = (VersionedFileSystemManager)m_vfsManagers.get(context);
            if (existingVfsManager == null) {
                m_vfsManagers.put(context, vfsManager);
            }
            // MONITOREXIT : hashMap
            if (existingVfsManager != null) {
                if (existingVfsManager.isInitialized()) return existingVfsManager;
                throw new VfsException(ExceptionSeverity.ERROR, VfsExceptionCategory.PARALLEL_THREAD_ACCESS_DURING_INITIALIZATION_OF_VFS_MANAGER, new Object[]{context.getClientName()}, new Throwable[0]);
            }
            boolean exceptionOccured = true;
            Throwable savedException = null;
            try {
                try {
                    vfsManager.pureSetCurrentContext(context);
                    exceptionOccured = false;
                }
                catch (VfsRuntimeException e) {
                    throw new VfsException(e.getMessage(), e);
                }
                catch (VfsException e) {
                    if (e.getCategory() == VfsExceptionCategory.NO_MOUNTPOINT_FOR_ADDED_FILE) {
                        throw e;
                    }
                    savedException = e;
                    Object var12_8 = null;
                    long elapsed = System.currentTimeMillis() - start;
                    LogUtil.logElapsedTime((long)elapsed, (String)("VersionedFileSystemManager.getVersionedFileSystemManager(" + context + ")"));
                    if (exceptionOccured) {
                        m_vfsManagers.remove(context);
                        if (savedException != null) {
                            throw new VfsException("Getting VFS manager for client " + context.getClientName() + " failed: " + savedException.getMessage(), savedException);
                        }
                    }
                    break block19;
                }
                catch (Throwable e) {
                    savedException = e;
                    Object var12_9 = null;
                    long elapsed = System.currentTimeMillis() - start;
                    LogUtil.logElapsedTime((long)elapsed, (String)("VersionedFileSystemManager.getVersionedFileSystemManager(" + context + ")"));
                    if (exceptionOccured) {
                        m_vfsManagers.remove(context);
                        if (savedException != null) {
                            throw new VfsException("Getting VFS manager for client " + context.getClientName() + " failed: " + savedException.getMessage(), savedException);
                        }
                    }
                }
                Object var12_7 = null;
                long elapsed = System.currentTimeMillis() - start;
                LogUtil.logElapsedTime((long)elapsed, (String)("VersionedFileSystemManager.getVersionedFileSystemManager(" + context + ")"));
                if (exceptionOccured) {
                    m_vfsManagers.remove(context);
                    if (savedException != null) {
                        throw new VfsException("Getting VFS manager for client " + context.getClientName() + " failed: " + savedException.getMessage(), savedException);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                long elapsed = System.currentTimeMillis() - start;
                LogUtil.logElapsedTime((long)elapsed, (String)("VersionedFileSystemManager.getVersionedFileSystemManager(" + context + ")"));
                if (!exceptionOccured) throw throwable;
                m_vfsManagers.remove(context);
                if (savedException == null) throw throwable;
                throw new VfsException("Getting VFS manager for client " + context.getClientName() + " failed: " + savedException.getMessage(), savedException);
            }
        }
        vfsManager.setInitialized();
        VersionedFileSystemManager.fireEventVfsManagerCreated(vfsManager);
        return vfsManager;
    }

    private boolean isInitialized() {
        return this.m_initialized;
    }

    private void setInitialized() {
        this.m_initialized = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void clientVersionCheck(IVfsContext context) throws VfsException {
        String MIN_VERSION = VfsXcmClientProperty.MIN_CLIENT_VERSION.getCompletePropertyName();
        String MAX_VERSION = VfsXcmClientProperty.MAX_CLIENT_VERSION.getCompletePropertyName();
        String EXCLUDE_LIST = VfsXcmClientProperty.EXCLUDED_CLIENT_VERSIONS.getCompletePropertyName();
        String INCLUDE_LIST = VfsXcmClientProperty.INCLUDED_CLIENT_VERSIONS.getCompletePropertyName();
        IVfsRemoteLocator[] locators = context.getRootRemoteLocators();
        int i = 0;
        while (true) {
            long elapsed;
            Object var19_19;
            IVfsRemoteLocator rootLocator;
            long start;
            block18: {
                block17: {
                    if (i >= locators.length) {
                        return;
                    }
                    start = System.currentTimeMillis();
                    rootLocator = locators[i];
                    try {
                        String maxVersion;
                        String minVersion = context.getServerProperty(rootLocator, MIN_VERSION);
                        if (minVersion == null) {
                            minVersion = "";
                        }
                        if ((maxVersion = context.getServerProperty(rootLocator, MAX_VERSION)) == null) {
                            maxVersion = "~";
                        }
                        String excludeList = context.getServerProperty(rootLocator, EXCLUDE_LIST);
                        HashSet<String> excludedVersions = new HashSet<String>();
                        if (excludeList != null) {
                            BufferedReader bufferedReader = new BufferedReader(new StringReader(excludeList));
                            try {
                                String excludedversion = null;
                                while ((excludedversion = bufferedReader.readLine()) != null) {
                                    excludedVersions.add(excludedversion);
                                }
                            }
                            catch (IOException e) {
                                LogUtil.logException((Location)LOCATION, (Throwable)e);
                            }
                        }
                        String includeList = context.getServerProperty(rootLocator, INCLUDE_LIST);
                        HashSet<String> includedVersions = new HashSet<String>();
                        if (includeList != null) {
                            BufferedReader bufferedReader = new BufferedReader(new StringReader(includeList));
                            try {
                                String includedversion = null;
                                while ((includedversion = bufferedReader.readLine()) != null) {
                                    includedVersions.add(includedversion);
                                }
                            }
                            catch (IOException e) {
                                LogUtil.logException((Location)LOCATION, (Throwable)e);
                            }
                        }
                        if (VersionedFileSystemManager.containsRegardingWildcards(includedVersions, CLIENT_VERSION) && !VersionedFileSystemManager.containsRegardingWildcards(excludedVersions, CLIENT_VERSION)) {
                            var19_19 = null;
                            break block17;
                        }
                        if (CLIENT_VERSION.compareTo(minVersion) < 0 || CLIENT_VERSION.compareTo(maxVersion) > 0 || VersionedFileSystemManager.containsRegardingWildcards(excludedVersions, CLIENT_VERSION)) {
                            String string;
                            StringBuffer stringBuffer = new StringBuffer().append("DTR client (").append(CLIENT_VERSION).append(") is locked out for DTR server ").append(context.getUrl(rootLocator));
                            if (minVersion != "") {
                                string = " (try using " + minVersion + ").";
                                throw new VfsException(stringBuffer.append(string).toString());
                            }
                            string = ".";
                            throw new VfsException(stringBuffer.append(string).toString());
                        }
                        break block18;
                    }
                    catch (Throwable throwable) {
                        var19_19 = null;
                        elapsed = System.currentTimeMillis() - start;
                        LogUtil.logElapsedTime((long)elapsed, (String)("VersionedFileSystemManager.clientVersionCheck for " + context.getWebLocator(rootLocator.getConnectionTemplateId())));
                        throw throwable;
                    }
                }
                elapsed = System.currentTimeMillis() - start;
                LogUtil.logElapsedTime((long)elapsed, (String)("VersionedFileSystemManager.clientVersionCheck for " + context.getWebLocator(rootLocator.getConnectionTemplateId())));
                return;
            }
            var19_19 = null;
            elapsed = System.currentTimeMillis() - start;
            LogUtil.logElapsedTime((long)elapsed, (String)("VersionedFileSystemManager.clientVersionCheck for " + context.getWebLocator(rootLocator.getConnectionTemplateId())));
            ++i;
        }
    }

    private static boolean containsRegardingWildcards(Set patterns, String specimen) {
        Iterator iterator = patterns.iterator();
        while (iterator.hasNext()) {
            String pattern = (String)iterator.next();
            if (!StringUtilities.matchesWithAtmostOneStar(pattern, specimen)) continue;
            return true;
        }
        return false;
    }

    private static void pingCheck(IVfsContext context) throws VfsException {
        IVfsRemoteLocator[] locators = context.getRootRemoteLocators();
        int i = 0;
        while (i < locators.length) {
            long elapsed;
            Object var9_7;
            IVfsRemoteLocator locator = locators[i];
            long start = System.currentTimeMillis();
            try {
                int readTimeout = 5000;
                int status = context.httpPing(locator, 2, readTimeout, 20000);
                if (status == 401) {
                    status = context.httpPing(locator, 2, readTimeout, 0);
                    if (status != 200) {
                        throw new VfsException("User not authorized for server " + context.getWebLocator(locator.getConnectionTemplateId()) + locator.getAbsoluteRemotePath());
                    }
                } else if (status != 200) {
                    throw new VfsException("The server " + context.getWebLocator(locator.getConnectionTemplateId()) + locator.getAbsoluteRemotePath() + " is unavailable");
                }
                var9_7 = null;
            }
            catch (Throwable throwable) {
                var9_7 = null;
                elapsed = System.currentTimeMillis() - start;
                LogUtil.logElapsedTime((long)elapsed, (String)("VersionedFileSystemManager.pingCheck for " + context.getWebLocator(locator.getConnectionTemplateId())));
                throw throwable;
            }
            elapsed = System.currentTimeMillis() - start;
            LogUtil.logElapsedTime((long)elapsed, (String)("VersionedFileSystemManager.pingCheck for " + context.getWebLocator(locator.getConnectionTemplateId())));
            ++i;
        }
    }

    SyncRemoveFeature getSyncRemoveFeature() {
        if (EnvironmentVariables.FORCE_CLASSIC_SYNC) {
            return new SyncRemoveFeatureClassic();
        }
        IVfsRepository[] repositories = this.getRepositories();
        int i = 0;
        while (i < repositories.length) {
            VfsRepository repository = (VfsRepository)repositories[i];
            if (!repository.supportsMget()) {
                return new SyncRemoveFeatureClassic();
            }
            ++i;
        }
        return new SyncRemoveFeatureMget();
    }

    AllowedActionsFeature getAllowedActionsFeature() {
        return this._allowedActionsFeature;
    }

    PropertiesFeature getPropertiesFeature() {
        return this._propertiesFeature;
    }

    public static void releaseVersionedFileSystemManager(IVersionedFileSystemManager vfsManager) {
        VersionedFileSystemManager manager = (VersionedFileSystemManager)vfsManager;
        manager.checkState();
        String clientName = vfsManager.getCurrentContext().getClientName();
        manager.setInvalid();
        m_vfsManagers.remove(manager.m_context);
        manager.reset();
        VersionedFileSystemManager.fireEventVfsManagerReleased(manager);
        manager.m_listenerHandler.reset();
        LogUtil.debugLogException((Location)LOCATION, (Throwable)new Exception("Stack trace: Vfs Manager for client definition '" + clientName + "' has been released"));
    }

    private void setInvalid() {
        this.m_invalid = true;
    }

    public boolean isReleased() {
        return this.m_invalid;
    }

    void checkState() {
        if (this.m_invalid) {
            throw new IllegalStateException("Versioned file system manager for client \"" + this.getClientName() + "\" was released");
        }
    }

    private void checkParameterState(IVfsWorkspace workspace) {
        if (workspace.getVersionedFileSystemManager() != this) {
            throw new IllegalArgumentException("Internal error: parameter with different versioned file system manager");
        }
    }

    FolderItemCache getFolderItemCache() {
        this.checkState();
        return this.m_folderItemCache;
    }

    void setFolderItemCache(FolderItemCache folderItemCache) {
        this.checkState();
        this.m_folderItemCache = folderItemCache;
    }

    public IVfsContext getCurrentContext() {
        this.checkState();
        return this.m_context;
    }

    public void setCurrentContext(IVfsContext context) throws VfsException {
        this.checkState();
        if (context == null) {
            throw new IllegalArgumentException("Context must be non-null.");
        }
        this.reset();
        this.pureSetCurrentContext(context);
    }

    private void reset() {
        this.m_rootFolder = null;
        this.m_repositories = null;
        this.m_workspaces = null;
        this.m_folderItemCache.release();
        this.m_folderItemCache = null;
    }

    public String getClientName() {
        return this.m_context == null ? null : this.m_context.getClientName();
    }

    private void pureSetCurrentContext(IVfsContext context) throws VfsException {
        long start = System.currentTimeMillis();
        try {
            IVfsContext currentContext = this.getCurrentContext();
            if (context != currentContext && !context.equals(currentContext)) {
                this.m_context = context;
                this.m_rootFolder = null;
                FolderItemCache.refreshFolderItemCache(this, this.m_repositories, this.m_workspaces, context);
                this.refreshRepositories(this.m_context);
                this.m_workspaces.clear();
                this.getWorkspacesFromRepositories();
            }
            m_vfsManagers.put(context, this);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            long elapsed = System.currentTimeMillis() - start;
            LogUtil.logElapsedTime((long)elapsed, (String)("VersionedFileSystemManager.pureSetCurrentContext for " + context));
            throw throwable;
        }
        long elapsed = System.currentTimeMillis() - start;
        LogUtil.logElapsedTime((long)elapsed, (String)("VersionedFileSystemManager.pureSetCurrentContext for " + context));
    }

    void addWorkspaceToCache(VfsWorkspace workspace) throws VfsException {
        this.m_workspaces.put(workspace.getUrl(), workspace);
    }

    IVfsRootFolder createRootFolder(IVfsRemoteLocator locator) throws VfsException {
        IResourceFactory factory = ResourceFactoryManager.getInstance().getProxyFactory();
        ICollection collection = null;
        try {
            collection = factory.createCollection(locator.getConnectionTemplateId(), locator.getAbsoluteRemotePath(), PathEncodingFlag.DECODED);
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Unexpected Internal Error: createCollection failed", vcmFailure);
        }
        String absoluteLocalPath = this.getCurrentContext().getAbsoluteLocalPath(locator.getConnectionTemplateId(), locator.getAbsoluteRemotePath());
        IVirtualFile localFile = absoluteLocalPath == null ? VfsFolderItem.NULL_LOCAL_FILE : this.getCurrentContext().getFileService().constructFile(absoluteLocalPath);
        return VfsWorkspaceFolder.getVfsWorkspaceFolder(this, collection, localFile).asRoot();
    }

    public IVfsGenericFolder getRootFolder() {
        this.checkState();
        if (this.m_rootFolder == null) {
            try {
                this.m_rootFolder = this.getRootFolder(this.m_context.getBrowseRootRemoteLocators());
            }
            catch (VfsException ignoreAlreadyLogged) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
                return null;
            }
        }
        return this.m_rootFolder;
    }

    IVfsGenericFolder getRootFolder(IVfsRemoteLocator[] locators) throws VfsException {
        if (this.m_rootFolder == null) {
            if (locators.length == 1) {
                this.m_rootFolder = this.createRootFolder(locators[0]);
            } else {
                if (locators.length == 0) {
                    throw new VfsException("Root folder not found");
                }
                IVfsGenericFolder[] rootFolders = new IVfsRootFolder[locators.length];
                int num = 0;
                int lastFound = 0;
                int i = 0;
                while (i < locators.length) {
                    IVfsRemoteLocator locator = locators[i];
                    IVfsRootFolder rootFolder = this.createRootFolder(locator);
                    if (rootFolder != null) {
                        rootFolders[i] = rootFolder;
                        ++num;
                        lastFound = i;
                    }
                    ++i;
                }
                this.m_rootFolder = num > 1 ? new VfsAmbiguousFolder(this, rootFolders) : rootFolders[lastFound];
            }
        }
        return this.m_rootFolder;
    }

    public IVfsRepository[] getRepositories() {
        this.checkState();
        return this.m_repositories.values().toArray(EMPTY_REPOSITORY_ARRAY);
    }

    public IVfsWorkspace[] getWorkspaces() {
        this.checkState();
        return this.m_workspaces.values().toArray(EMPTY_WORKSPACE_ARRAY);
    }

    private void refreshRepositories(IVfsContext context) throws VfsException {
        IVfsRemoteLocator[] serverRoots = context.getRootRemoteLocators();
        this.m_repositories.clear();
        int i = 0;
        while (i < serverRoots.length) {
            VfsRepository repository = new VfsRepository(serverRoots[i], this, this.m_folderItemCache);
            this.m_repositories.put(repository.getUrl(), repository);
            ++i;
        }
    }

    void refreshWorkspaces() throws VfsException {
        VfsException exception = null;
        Iterator repositoryIterator = this.m_repositories.values().iterator();
        while (repositoryIterator.hasNext()) {
            VfsRepository vfsRepository = (VfsRepository)repositoryIterator.next();
            VfsRemoteLocator serverRoot = new VfsRemoteLocator(vfsRepository.getConnectionTemplateId(), vfsRepository.getAbsoluteRemotePath(), vfsRepository.getAbsoluteRemotePath());
            try {
                vfsRepository.refreshWorkspacesFromRepository(serverRoot);
            }
            catch (VfsException e) {
                exception = new VfsException("Refresh workspaces from repository failed:" + vfsRepository.getAbsoluteRemotePath(), e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void getWorkspacesFromRepositories() throws VfsException {
        Iterator repositoryIterator = this.m_repositories.values().iterator();
        while (repositoryIterator.hasNext()) {
            VfsRepository repository = (VfsRepository)repositoryIterator.next();
            IVfsWorkspace[] workspacesInRepository = repository.getWorkspaces();
            int i = 0;
            while (i < workspacesInRepository.length) {
                IVfsWorkspace iVfsWorkspace = workspacesInRepository[i];
                this.m_workspaces.put(iVfsWorkspace.getUrl(), iVfsWorkspace);
                ++i;
            }
        }
    }

    public String findLocalPath(String reference, IVfsWorkspace[] workspaces, String pathPrefix, String pathSeparator) {
        this.checkState();
        throw new UnsupportedOperationException("Not yet implemented. Do we need this?");
    }

    private void specialRefreshMountedFolderItem(VfsFolderItem folderItem) throws VfsException {
        throw new UnsupportedOperationException();
    }

    IVfsFolderItem getFolderItem(String absoluteLocalPath, boolean doRefresh) throws VfsException {
        throw new UnsupportedOperationException();
    }

    public IVfsFolderItem getFolderItem(String absoluteLocalPath) throws VfsException {
        this.checkState();
        IVirtualFile virtualFile = this.getCurrentContext().getFileService().constructFile(absoluteLocalPath);
        absoluteLocalPath = WrongCaseOfFolderPathUtil.getResolvedAbsoluteLocalPath(this.getCurrentContext(), virtualFile);
        IVfsFolderItem folderItem = this.getFolderItemFromCache(absoluteLocalPath);
        if (folderItem != null) {
            return folderItem;
        }
        IVfsWorkspace workspace = this.getWorkspaceForLocalPath(absoluteLocalPath);
        if (workspace != null) {
            String decodedAbsoluteRemoteParentPath = this.getCurrentContext().getRemoteLocator(absoluteLocalPath).getCanonicalAbsoluteRemotePath();
            decodedAbsoluteRemoteParentPath = PathUtilities.getParentPath(decodedAbsoluteRemoteParentPath, PathUtilities.REMOTE_FILESERVICE, false);
            VfsRepository repository = (VfsRepository)workspace.getRepository();
            IVfsGenericFolder folder = FolderUtil.getFolderAndInitializeChildren(repository, decodedAbsoluteRemoteParentPath);
            folderItem = this.getFolderItemFromCache(absoluteLocalPath);
            if (folderItem != null) {
                return folderItem;
            }
            folderItem = VfsFolderItem.createFolderItemRelatedToWorkspace(workspace, absoluteLocalPath, true);
        } else {
            IVfsContext context = this.getCurrentContext();
            IVfsRemoteLocator locator = context.getRemoteLocator(absoluteLocalPath);
            if (locator != null) {
                try {
                    String localPathToCheck = absoluteLocalPath;
                    IVfsRemoteLocator locatorToCheck = locator;
                    IVirtualFile localFile = context.getFileService().constructFile(absoluteLocalPath);
                    if (localFile.isFile()) {
                        localPathToCheck = PathUtilities.getParentPath(absoluteLocalPath, localFile.getFileService(), false);
                        locatorToCheck = context.getRemoteLocator(localPathToCheck);
                    }
                    VfsFolderItem.checkIsVisible(context, locatorToCheck, PathUtilities.getName(localPathToCheck, this.getCurrentContext().getFileService()));
                }
                catch (VfsException ignoreAlreadyLogged) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
                    return null;
                }
                IResourceFactory factory = ResourceFactoryManager.getInstance().getProxyFactory();
                ICollection resource = null;
                try {
                    resource = factory.createCollection(locator.getConnectionTemplateId(), locator.getAbsoluteRemotePath(), PathEncodingFlag.DECODED);
                }
                catch (VcmFailure vcmFailure) {
                    if (vcmFailure.getStatusCode() == 404) {
                        return null;
                    }
                    LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
                    throw new VfsException("Cannot get resource for local path \"" + absoluteLocalPath + "\": " + vcmFailure.getMessage(), vcmFailure);
                }
                return VfsWorkspaceFolder.getVfsWorkspaceFolder(this, resource, this.getCurrentContext().getFileService().constructFile(absoluteLocalPath));
            }
            folderItem = null;
        }
        return folderItem;
    }

    private VfsFolderItem getFolderItemFromCache(String absoluteLocalPath) {
        VfsFolderItem folderItem = this.getFolderItemCache().getFolderItemWithLocalPath(absoluteLocalPath);
        if (folderItem != null) {
            if (folderItem.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY && folderItem.getLocalFile().exists()) {
                return folderItem;
            }
            if (folderItem.getLocationState() != VfsFolderItemLocationState.DELETED) {
                return folderItem;
            }
        }
        return null;
    }

    static boolean exists(IResource resource) throws VfsException {
        try {
            resource.refresh();
            return true;
        }
        catch (VcmFailure vcmFailure) {
            if (vcmFailure.getStatusCode() == 404) {
                return false;
            }
            throw new VfsException("Refresh DeltaV resource failed", vcmFailure);
        }
    }

    VfsRepository getRepositoryByConnectionTemplateId(int connectionTemplateId) {
        Iterator repositories = this.m_repositories.values().iterator();
        while (repositories.hasNext()) {
            VfsRepository repository = (VfsRepository)repositories.next();
            if (repository.getConnectionTemplateId() != connectionTemplateId) continue;
            return repository;
        }
        return null;
    }

    IVfsFolderItem getFolderItemByBrowsePath(String browsePath, boolean doRefresh) throws VfsException {
        throw new UnsupportedOperationException();
    }

    public IVfsFolderItem getFolderItemByBrowsePath(String browsePath) throws VfsException {
        this.checkState();
        if (browsePath == null) {
            IllegalArgumentException e = new IllegalArgumentException("Null browsePath as argument for get folder by browse path");
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            throw e;
        }
        if (browsePath.startsWith("//")) {
            browsePath = browsePath.substring(1);
        }
        IVfsRemoteLocator[] browseRoots = this.m_context.getBrowseRootRemoteLocators();
        ArrayList<VfsWorkspace> existingFolderItems = new ArrayList<VfsWorkspace>();
        IResourceFactory factory = ResourceFactoryManager.getInstance().getProxyFactory();
        int i = 0;
        while (i < browseRoots.length) {
            block25: {
                IVfsRemoteLocator browseRoot = browseRoots[i];
                VfsRepository repository = this.getRepositoryByConnectionTemplateId(browseRoot.getConnectionTemplateId());
                if (repository == null) {
                    throw new IllegalStateException("Invalid configuration: no VfsRepository for connection template id.");
                }
                try {
                    String absoluteRemotePath = browseRoot.getAbsoluteRemotePath() + browsePath.substring(1);
                    IVirtualFile localFile = Util.getLocalFile(this.m_context, null, PathUtilities.getName(absoluteRemotePath, PathUtilities.REMOTE_FILESERVICE), browseRoot.getConnectionTemplateId(), PathUtilities.getParentPath(absoluteRemotePath, PathUtilities.REMOTE_FILESERVICE, false));
                    if (localFile == null) {
                        localFile = VfsFolderItem.NULL_LOCAL_FILE;
                    } else {
                        VfsFolderItem folderItem = this.getFolderItemCache().getFolderItemWithLocalPath(localFile.getAbsolutePath());
                        if (folderItem != null) {
                            return folderItem;
                        }
                    }
                    IResource dvResource = factory.createResource(browseRoot.getConnectionTemplateId(), absoluteRemotePath, PathEncodingFlag.DECODED);
                    if (!VersionedFileSystemManager.exists(dvResource)) {
                        dvResource = VfsFolderItem.NULL_DELTAV_RESOURCE;
                    }
                    IVfsWorkspace foundWorkspace = null;
                    if (dvResource != VfsFolderItem.NULL_DELTAV_RESOURCE) {
                        IWorkspace dvWorkspace = dvResource.getWorkspace();
                        if (dvWorkspace != null && (foundWorkspace = repository.getWorkspaceByPathFromCache(dvWorkspace.getDecodedPath())) == null) {
                            foundWorkspace = repository.getWorkspaceByOIDFromCache(dvWorkspace.getXCMObjectId());
                        }
                    } else {
                        IVfsWorkspace[] workspaces = this.getWorkspaces();
                        int j = 0;
                        while (j < workspaces.length) {
                            IVfsWorkspace workspace = workspaces[j];
                            String workspaceBrowsePath = workspace.getBrowsePath();
                            if (workspaceBrowsePath != null && browsePath.startsWith(workspaceBrowsePath)) {
                                foundWorkspace = workspace;
                                break;
                            }
                            ++j;
                        }
                    }
                    LOCATION.debugT("foundWorkspace={0}", new Object[]{foundWorkspace});
                    VfsFolderItem foundFolderItem = null;
                    if (dvResource != VfsFolderItem.NULL_DELTAV_RESOURCE && dvResource.isCollection()) {
                        if (dvResource.getAsCollection().isWorkspace()) {
                            foundFolderItem = VfsWorkspace.getVfsWorkspace(repository, dvResource, localFile);
                            if (foundFolderItem == null) break;
                            existingFolderItems.add((VfsWorkspace)foundFolderItem);
                            break;
                        }
                        if (!dvResource.isVersioned()) {
                            foundFolderItem = VfsWorkspaceFolder.getVfsWorkspaceFolder(this, dvResource, localFile);
                            if (foundFolderItem == null) break;
                            existingFolderItems.add((VfsWorkspace)foundFolderItem);
                            break;
                        }
                    }
                    if (foundWorkspace == null || localFile == VfsFolderItem.NULL_LOCAL_FILE && dvResource == VfsFolderItem.NULL_DELTAV_RESOURCE) break block25;
                    IVersionControlledResource dvVersionedResource = dvResource == VfsFolderItem.NULL_DELTAV_RESOURCE ? VfsFolderItem.NULL_DELTAV_RESOURCE : dvResource.getAsVersionControlled();
                    try {
                        foundFolderItem = VfsActivityRecordedFolderItem.searchVfsActivityRecordedFolderItem(foundWorkspace, dvVersionedResource, localFile);
                    }
                    catch (VfsException e) {
                        if (e.getCategory() == VfsExceptionCategory.NOTFOUND_LOCAL_FILE_AND_RESOURRCE_ON_REPOSITORY) {
                            LOCATION.debugT(e.getMessage());
                            break block25;
                        }
                        throw e;
                    }
                    LOCATION.debugT("foundFolderItem={0}", new Object[]{foundFolderItem});
                    existingFolderItems.add((VfsWorkspace)foundFolderItem);
                }
                catch (VcmFailure vcmFailure) {
                    if (vcmFailure.getStatusCode() == 404) break block25;
                    throw new VfsException("Could not get DeltaV resource", vcmFailure);
                }
            }
            ++i;
        }
        switch (existingFolderItems.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (IVfsFolderItem)existingFolderItems.get(0);
            }
        }
        throw new UnsupportedOperationException("Can't yet handle ambiguous folder items.");
    }

    public IVfsWorkspace[] getWorkspacesForLocalPath(String absoluteLocalPath) {
        IVfsWorkspace[] iVfsWorkspaceArray;
        this.checkState();
        try {
            absoluteLocalPath = this.getCurrentContext().getFileService().constructFile(absoluteLocalPath).getCanonicalPath();
        }
        catch (IOException x) {
            new VfsException("Could not get canonical filename.", x);
        }
        IVfsWorkspace workspace = this.getWorkspaceForLocalPath(absoluteLocalPath);
        if (workspace == null) {
            iVfsWorkspaceArray = new IVfsWorkspace[]{};
        } else {
            IVfsWorkspace[] iVfsWorkspaceArray2 = new IVfsWorkspace[1];
            iVfsWorkspaceArray = iVfsWorkspaceArray2;
            iVfsWorkspaceArray2[0] = workspace;
        }
        return iVfsWorkspaceArray;
    }

    IVfsWorkspace getWorkspaceForLocalPath(String canonicalAbsoluteLocalPath) {
        IVfsWorkspace[] workspaces = this.getWorkspaces();
        IVfsRemoteLocator locator = this.m_context.getRemoteLocator(canonicalAbsoluteLocalPath);
        if (locator == null) {
            return null;
        }
        String absoluteRemotePath = PathUtilities.assureTrailingSeparator(locator.getAbsoluteRemotePath(), PathUtilities.REMOTE_FILESERVICE);
        int i = 0;
        while (i < workspaces.length) {
            IVfsWorkspace workspace = workspaces[i];
            if (absoluteRemotePath.startsWith(workspace.getAbsoluteRemotePath())) {
                return workspace;
            }
            ++i;
        }
        return null;
    }

    public IVfsFolderItem getFolderItem(IVfsWorkspace workspace, String absoluteLocalPath) throws VfsException {
        this.checkState();
        this.checkParameterState(workspace);
        IVirtualFile virtualFile = this.getCurrentContext().getFileService().constructFile(absoluteLocalPath);
        absoluteLocalPath = WrongCaseOfFolderPathUtil.getResolvedAbsoluteLocalPath(this.getCurrentContext(), virtualFile);
        return VfsFolderItem.createFolderItemRelatedToWorkspace(workspace, absoluteLocalPath, false);
    }

    public IVfsWorkspace getWorkspaceByUrl(String url) {
        this.checkState();
        IVfsWorkspace workspace = (IVfsWorkspace)this.m_workspaces.get(PathUtilities.assureTrailingSeparator(url, PathUtilities.REMOTE_FILESERVICE));
        if (workspace == null) {
            LOCATION.debugT("No workspace found for " + url);
        }
        return workspace;
    }

    public IVfsFolderItem getFolderItemByObjectId(IVfsWorkspace workspace, String objectId) throws VfsException {
        return this.getFolderItemByBrowsePath(VfsSpecialPaths.getBrowsePath(workspace, objectId));
    }

    public IVfsActivity getActivityByName(String name) throws VfsException {
        this.checkState();
        Iterator repositoryIterator = this.m_repositories.values().iterator();
        while (repositoryIterator.hasNext()) {
            IVfsRepository vfsRepository = (IVfsRepository)repositoryIterator.next();
            IVfsActivity activity = vfsRepository.getActivityByName(name);
            if (activity == null) continue;
            return activity;
        }
        return null;
    }

    VfsListenerHandler getListenerHandler() {
        return this.m_listenerHandler;
    }

    public static void addVfsManagerListener(IVfsManagerListener listener) {
        VfsListenerHandler.addVfsManagerListener(listener);
    }

    public static void removeVfsManagerListener(IVfsManagerListener listener) {
        VfsListenerHandler.removeVfsManagerListener(listener);
    }

    public void addActivityListener(IVfsActivityListener listener) {
        this.checkState();
        this.getListenerHandler().addActivityListener(listener);
    }

    public void removeActivityListener(IVfsActivityListener listener) {
        if (this.isReleased()) {
            return;
        }
        this.getListenerHandler().removeActivityListener(listener);
    }

    public void addFolderItemListener(IVfsFolderItemListener listener) {
        this.checkState();
        this.getListenerHandler().addFolderItemListener(listener);
    }

    public void removeFolderItemListener(IVfsFolderItemListener listener) {
        if (this.isReleased()) {
            return;
        }
        this.getListenerHandler().removeFolderItemListener(listener);
    }

    public void addVersionListener(IVfsVersionListener listener) {
        this.checkState();
        this.getListenerHandler().addVersionListener(listener);
    }

    public void removeVersionListener(IVfsVersionListener listener) {
        if (this.isReleased()) {
            return;
        }
        this.getListenerHandler().removeVersionListener(listener);
    }

    public void addCollisionListener(IVfsCollisionListener listener) {
        this.checkState();
        this.getListenerHandler().addCollisionListener(listener);
    }

    public void removeCollisionListener(IVfsCollisionListener listener) {
        if (this.isReleased()) {
            return;
        }
        this.getListenerHandler().removeCollisionListener(listener);
    }

    static void fireEventVfsManagerCreated(VersionedFileSystemManager vfsManager) {
        VfsListenerHandler.fireEventVfsManagerCreated(vfsManager);
    }

    static void fireEventVfsManagerReleased(VersionedFileSystemManager vfsManager) {
        VfsListenerHandler.fireEventVfsManagerReleased(vfsManager);
    }

    void fireEventActivityCreated(IVfsActivity activity) {
        this.getListenerHandler().fireEventActivityCreated(activity);
    }

    void fireEventActivityDeleted(IVfsActivity activity, VfsActivityState oldState) {
        this.getListenerHandler().fireEventActivityDeleted(activity, oldState);
    }

    void fireEventActivityItemsAddedOrRemoved(IVfsActivity activity) {
        this.getListenerHandler().fireEventActivityItemsAddedOrRemoved(activity);
    }

    void fireEventBeforeCheckingInActivity(IVfsActivity activity) {
        this.getListenerHandler().fireEventBeforeCheckingInActivity(activity);
    }

    void fireEventActivityStateChanged(IVfsActivity activity, VfsActivityState oldState) {
        this.getListenerHandler().fireEventActivityStateChanged(activity, oldState);
    }

    void fireEventActivityNameOrDescriptionChanged(IVfsActivity activity) {
        this.getListenerHandler().fireEventActivityNameOrDescriptionChanged(activity);
    }

    void fireEventFolderItemContentChanged(String absoluteLocalPath, IVfsFolderItemListener2.ContentChangeReasons reason) {
        this.getListenerHandler().fireEventFolderItemContentChanged(absoluteLocalPath, this, reason);
    }

    void fireEventFolderItemLocationStateChanged(IVfsFolderItem folderItem, VfsFolderItemLocationState oldState) {
        this.getListenerHandler().fireEventFolderItemLocationStateChanged(folderItem, oldState);
    }

    void fireEventFolderItemActivityStateChanged(IVfsActivityRecordedFolderItem folderItem, VfsFolderItemActivityState oldState) {
        this.getListenerHandler().fireEventFolderItemActivityStateChanged(folderItem, oldState);
    }

    void fireEventFolderItemsAddedOrRemoved(IVfsGenericFolder parentFolder) {
        this.getListenerHandler().fireEventFolderItemsAddedOrRemoved(parentFolder);
    }

    void fireEventVersionChanged(IVfsActivityRecordedFolderItem folderItem, IVfsVersion oldVersion) {
        this.getListenerHandler().fireEventVersionChanged(folderItem, oldVersion);
    }

    void fireEventVersionDiscarded(IVfsActivityRecordedFolderItem folderItem, IVfsCollision collision, IVfsVersion discardedVersion) {
        this.getListenerHandler().fireEventVersionDiscarded(folderItem, collision, discardedVersion);
    }

    void fireEventActiveVersionAccepted(IVfsActivityRecordedFolderItem folderItem, IVfsCheckinCollision collision) {
        this.getListenerHandler().fireEventActiveVersionAccepted(folderItem, collision);
    }

    void fireEventLocalVersionAccepted(IVfsActivityRecordedFolderItem folderItem, IVfsCheckinCollision collision) {
        this.getListenerHandler().fireEventLocalVersionAccepted(folderItem, collision);
    }

    void fireEventMergeVersionCreated(IVfsActivityRecordedFolderItem folderItem, IVfsCollision collision) {
        this.getListenerHandler().fireEventMergeVersionCreated(folderItem, collision);
    }

    public boolean isSomethingCheckedOutUnderFolder(IVfsFolder folder) throws VfsException {
        return folder.hasCheckedOutFolderItems();
    }

    public void immediateHierarchicalDelete(IVfsActivityRecordedFolderItem folderItem) throws VfsException {
        VfsFolder folder = (VfsFolder)folderItem.asFolder();
        if (folder == null) {
            throw new IllegalArgumentException("Internal error: hierarchical checkout and delete is only applicable to folders");
        }
        IVfsWorkspace workspace = folder.getWorkspace();
        String activityName = "Immediate hierarchical deletion";
        String description = "Immediate hierarchical deletion: " + folder.getAbsoluteRemotePath();
        boolean deleteLocalOnlyItems = false;
        workspace.immediateMassDelete(new IVfsActivityRecordedFolderItem[]{folder}, deleteLocalOnlyItems, activityName, description);
    }

    public String getPrefixForNamespaceUri(String namespaceUri) {
        return this.getPropertiesFeature().getPrefixForNamespaceUri(namespaceUri);
    }

    public void registerNamespace(String namespacePrefix, String namespaceUri) throws VfsException {
        this.getPropertiesFeature().registerNamespace(namespacePrefix, namespaceUri);
    }

    public boolean isVfsInternalDelayedListeningTurnedOn() {
        return this.getListenerHandler().isVfsInternalDelayedListeningTurnedOn();
    }

    public void startDelayedListening() {
        String METHOD = "startDelayedListening";
        LOCATION.pathT("startDelayedListening");
        this.getListenerHandler().startVfsInternalDelayedListening();
    }

    public void stopDelayedListening(Object caller) {
        String METHOD = "stopDelayedListening";
        LOCATION.pathT("stopDelayedListening", "caller={0}", new Object[]{caller});
        if (this._delayedListeningStopper == null) {
            LogUtil.infoLogException((Location)LOCATION, (Throwable)new IllegalStateException("Method stopDelayedListening() can only be called if method willCallStopDelayedListening() was called before - ignoring."), (boolean)false);
            return;
        }
        if (this._delayedListeningStopper != caller) {
            LogUtil.infoLogException((Location)LOCATION, (Throwable)new IllegalStateException("Method stopDelayedListening() was called by " + caller + " (expected: " + this._delayedListeningStopper + ") - ignoring."), (boolean)false);
            return;
        }
        if (this.getVfsEventManager().isEventNoficationBlockedByBrackets()) {
            LogUtil.infoLogException((Location)LOCATION, (Throwable)new IllegalStateException("Method stopDelayedListening() called by " + caller + " is ignored because delayed listening is in use by batched eventing."), (boolean)false);
            return;
        }
        this.getListenerHandler().stopVfsInternalDelayedListening();
        this._delayedListeningStopper = null;
    }

    public void willCallStopDelayedListening(Object caller) {
        String METHOD = "willCallStopDelayedListening";
        LOCATION.pathT("willCallStopDelayedListening", "caller={0}", new Object[]{caller});
        if (this.getVfsEventManager().isEventNoficationBlockedByBrackets()) {
            LogUtil.infoLogException((Location)LOCATION, (Throwable)new IllegalStateException("Method willCallStopDelayedListening() called by " + caller + " is ignored because delayed listening is in use by batched eventing."), (boolean)false);
            return;
        }
        if (this._delayedListeningStopper != null) {
            LogUtil.infoLogException((Location)LOCATION, (Throwable)new IllegalStateException("Method willCallStopDelayedListening() called by " + caller + " was already called by " + this._delayedListeningStopper + " - ignoring."), (boolean)false);
            return;
        }
        this._delayedListeningStopper = caller;
    }

    public void mountPointCreated(String absoluteLocalPath) throws VfsException {
        IVfsWorkspace[] workspaces = this.getWorkspaces();
        int i = 0;
        while (i < workspaces.length) {
            VfsWorkspace workspace = (VfsWorkspace)workspaces[i];
            IVfsRemoteLocator locator = workspace.getRemoteLocator();
            String absoluteLocalPathForWorkspace = this.getCurrentContext().getAbsoluteLocalPath(locator.getConnectionTemplateId(), locator.getAbsoluteRemotePath());
            if (absoluteLocalPathForWorkspace != null) {
                IVirtualFile file;
                workspace.m_localFile = file = this.getCurrentContext().getFileService().constructFile(absoluteLocalPathForWorkspace);
                workspace.refreshLocationState();
            }
            ++i;
        }
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "[" + this.getClientName() + "]";
    }

    public IVfsEventManager getEventManager() {
        return this.m_eventManager;
    }

    VfsEventManager getVfsEventManager() {
        return this.m_eventManager;
    }

    public void prepareActionsForMountPointDeletion(String localPathOfMountPoint) throws VfsException {
        if (EnvironmentVariables.FORCE_CLASSIC_DELETE_MOUNTPOINT) {
            throw new VfsException("Fallback solution for deleting mount points is turned on.");
        }
        VfsListenerHandler listenerHandler = this.getListenerHandler();
        boolean wasInternalDelayedListeningTurnedOn = listenerHandler.isVfsInternalDelayedListeningTurnedOn();
        if (!wasInternalDelayedListeningTurnedOn) {
            listenerHandler.startVfsInternalDelayedListening();
        }
        try {
            VfsFolderItem folderItem;
            TreeMap folderItemTreeMap = this.getFolderItemCache().getFolderItemTreeWithLocalRoot(localPathOfMountPoint);
            Iterator folderItemIterator = folderItemTreeMap.values().iterator();
            while (folderItemIterator.hasNext()) {
                folderItem = (VfsFolderItem)folderItemIterator.next();
                if (folderItem.asActivityRecordedFolderItem() == null || folderItem.asActivityRecordedFolderItem().getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) continue;
                throw new VfsRuntimeException((ExceptionCategory)VfsExceptionCategory.CANT_DELETE_MOUNTPOINT_IF_THERE_ARE_STILL_CHECKED_OUT_RESOURCES, new Object[]{folderItem.getIdentifyingString()}, null);
            }
            folderItemIterator = folderItemTreeMap.values().iterator();
            while (folderItemIterator.hasNext()) {
                folderItem = (VfsFolderItem)folderItemIterator.next();
                folderItem.refreshForMountPointDeletion();
            }
            this.getFolderItemCache().removeFolderItemsWithLocalPath(folderItemTreeMap);
            Object var8_7 = null;
            if (!wasInternalDelayedListeningTurnedOn) {
                listenerHandler.stopVfsInternalDelayedListening();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!wasInternalDelayedListeningTurnedOn) {
                listenerHandler.stopVfsInternalDelayedListening();
            }
            throw throwable;
        }
    }

    public boolean isFolderItemAvailableFor(String absoluteLocalPath) {
        return this.getFolderItemCache().getFolderItemWithLocalPath(absoluteLocalPath) != null;
    }

    public IVfsVersionGraph getVersionGraph(IVfsVersionHistory vfsVersionHistory) {
        return new VfsVersionGraph(vfsVersionHistory);
    }

    public IVfsCollisionQuery getCollisionQuery() {
        return new VfsCollisionQuery();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (ConnectionPool.isMultiThreadingModeForDefaultPoolProvider()) {
            throw new IllegalStateException("VFS does not support multithreaded mode.");
        }
        m_vfsManagers = new HashMap();
        EMPTY_REPOSITORY_ARRAY = new IVfsRepository[0];
        EMPTY_WORKSPACE_ARRAY = new IVfsWorkspace[0];
        LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$VersionedFileSystemManager == null ? (class$com$tssap$dtr$client$lib$vfs$impl$VersionedFileSystemManager = VersionedFileSystemManager.class$("com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager")) : class$com$tssap$dtr$client$lib$vfs$impl$VersionedFileSystemManager));
        Properties properties = new Properties();
        InputStream inputStream = (class$com$tssap$dtr$client$lib$vfs$impl$VersionedFileSystemManager == null ? (class$com$tssap$dtr$client$lib$vfs$impl$VersionedFileSystemManager = VersionedFileSystemManager.class$("com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager")) : class$com$tssap$dtr$client$lib$vfs$impl$VersionedFileSystemManager).getResourceAsStream("vfs.properties");
        try {
            properties.load(inputStream);
        }
        catch (Exception e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
        CLIENT_VERSION = properties.getProperty("dtr.client.version", "~DEV DIRTY~");
    }
}

