/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.PathEncodingFlag;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.ResourceFactoryManager;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspace;

public class Util {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$Util == null ? (class$com$tssap$dtr$client$lib$vfs$impl$Util = Util.class$("com.tssap.dtr.client.lib.vfs.impl.Util")) : class$com$tssap$dtr$client$lib$vfs$impl$Util));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$Util;

    public static String assureTrailingFileSeparator(String path, String separator) {
        if (!path.endsWith(separator)) {
            return path + separator;
        }
        return path;
    }

    public static String preventTrailingFileSeparator(String path, String separator) {
        if (path.endsWith(separator)) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String assureTrailingSlash(String path) {
        return PathUtilities.assureTrailingSeparator(path, PathUtilities.REMOTE_FILESERVICE);
    }

    public static String preventLeadingSlash(String string) {
        return string.startsWith("/") ? string.substring(1) : string;
    }

    public static String preventTrailingColon(String string) {
        return string.endsWith(":") ? string.substring(0, string.length() - 1) : string;
    }

    static IResource createDvResourceProxy(IVfsRemoteLocator locator) {
        IResourceFactory factory = ResourceFactoryManager.getInstance().getProxyFactory();
        try {
            return factory.createResource(locator.getConnectionTemplateId(), locator.getAbsoluteRemotePath(), PathEncodingFlag.DECODED);
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
            return null;
        }
    }

    static IResource createDvResourceProxy(IVfsWorkspace workspace, String absoluteLocalPath) throws VfsException {
        IVfsRemoteLocator locator = workspace.getContext().getRemoteLocator(absoluteLocalPath);
        if (locator == null) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, absoluteLocalPath, "Internal error");
            throw new VfsException("Internal error: factory method call with not mounted local file");
        }
        if (locator.getConnectionTemplateId() != ((VfsWorkspace)workspace).m_dvVcr.getConnectionTemplID()) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, absoluteLocalPath, "Internal error");
            throw new VfsException("Internal error: factory method call with workspace not related to folder item");
        }
        return Util.createDvResourceProxy(locator);
    }

    static IResource createInitializedDvResource(IVfsWorkspace workspace, String absoluteLocalPath) throws VfsException {
        IResource dvResource = Util.createDvResourceProxy(workspace, absoluteLocalPath);
        if (!VersionedFileSystemManager.exists(dvResource)) {
            dvResource = VfsFolderItem.NULL_DELTAV_RESOURCE;
        }
        return dvResource;
    }

    static IVirtualFile getLocalFile(IVfsContext context, IVirtualFile parentFolder, String remoteChildName, int parentConnectionTemplateId, String parentAbsoluteRemotePath) {
        if (parentFolder != null) {
            return context.getFileService().constructFile(parentFolder, remoteChildName);
        }
        String absoluteRemotePath = parentAbsoluteRemotePath;
        absoluteRemotePath = !absoluteRemotePath.endsWith("/") ? absoluteRemotePath + "/" + remoteChildName : absoluteRemotePath + remoteChildName + "/";
        String absoluteLocalPath = context.getAbsoluteLocalPath(parentConnectionTemplateId, absoluteRemotePath);
        if (absoluteLocalPath != null) {
            return context.getFileService().constructFile(absoluteLocalPath);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

