/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IVersion;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.impl.SyncRemoveFeature;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolder;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersion;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncDB;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncEntry;
import java.util.ArrayList;
import java.util.HashMap;

class SyncRemoveFeatureClassic
extends SyncRemoveFeature {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$SyncRemoveFeatureClassic == null ? (class$com$tssap$dtr$client$lib$vfs$impl$SyncRemoveFeatureClassic = SyncRemoveFeatureClassic.class$("com.tssap.dtr.client.lib.vfs.impl.SyncRemoveFeatureClassic")) : class$com$tssap$dtr$client$lib$vfs$impl$SyncRemoveFeatureClassic));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$SyncRemoveFeatureClassic;

    SyncRemoveFeatureClassic() {
    }

    protected void syncMountedFolder(VfsFolder folder, boolean forceSync, boolean previewSync, boolean adaptSyncStateForPathToLocalRoot) throws VfsException {
        VfsFolderItemLocationState locationState = folder.getLocationState();
        if (locationState == VfsFolderItemLocationState.LOCAL_ONLY) {
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SKIPPED, folder, "Folder is " + VfsFolderItemLocationState.LOCAL_ONLY);
            return;
        }
        if (locationState == VfsFolderItemLocationState.DELETED) {
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SKIPPED, folder, "Folder is " + VfsFolderItemLocationState.DELETED);
            return;
        }
        if (folder.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SKIPPED, folder, "Folder is " + VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE);
            return;
        }
        long currentServerTime = folder.getWorkspace().getRepository().getServerTime().getTime();
        try {
            folder.refreshFolderItems();
        }
        catch (VfsException ignoreAlreadyLogged) {
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, folder, ignoreAlreadyLogged.getMessage());
            throw new VfsException("Sync (getting children) failed: " + folder.getBrowsePath());
        }
        IVfsFolderItem[] folderItems = folder.getFolderItems();
        ArrayList<VfsException> collectedExceptions = new ArrayList<VfsException>(folderItems.length);
        int i = 0;
        while (i < folderItems.length) {
            VfsFolderItem folderItem = (VfsFolderItem)folderItems[i];
            try {
                this.syncFolderItem(folderItem, forceSync, previewSync);
            }
            catch (VfsException ignoreAlreadyLogged) {
                collectedExceptions.add(ignoreAlreadyLogged);
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
            }
            if (Thread.currentThread().isInterrupted()) break;
            ++i;
        }
        if (VfsActivityRecordedFolderItem.isDvResourceDeleted(folder.m_dvVcr)) {
            this.removeDeletedFolder(folder);
            if (folder.getLocationState() == VfsFolderItemLocationState.DELETED) {
                HashMap<String, VfsFolder> folderItemsToRemove = new HashMap<String, VfsFolder>(1);
                folderItemsToRemove.put(folder.getAbsoluteRemotePath(), folder);
                IVfsGenericFolder parentFolder = folder.getRealParent();
                if (parentFolder != null) {
                    VfsFolderItem.removeFolderItemsFromParent(parentFolder, folderItemsToRemove);
                }
            }
            this.handleCollectedExceptions(collectedExceptions, folder);
            return;
        }
        if (!previewSync && folder.m_dvVcr != null) {
            folder.m_localFile.mkdirs();
            folder.setLocationState(VfsFolderItemLocationState.SYNCED_TO_LATEST);
            SyncDB syncDB = folder.getContext().getSyncDb(folder.getLocalPath());
            SyncEntry syncEntry = syncDB.getEntry(folder.getLocalPath());
            if (syncEntry == null) {
                syncEntry = syncDB.createEntry(folder.getLocalPath(), "UNKNOWN_OBJECT_ID");
            }
            IVersion dvVersion = null;
            try {
                IResource dvVcr = folder.getVcrResource();
                long lastModified = dvVcr.lastModified().getTime();
                if (!Thread.currentThread().isInterrupted()) {
                    syncDB.getSyncDbMget().setLastRemoteSyncTime(folder.getLocalPath(), currentServerTime);
                }
                dvVersion = dvVcr.getAsVersionControlled().getActiveVersion();
                folder.setSyncedVersion(new VfsVersion(folder.getVfsManager(), dvVersion));
                syncEntry.setVersionUrlAndRemoteSyncTime(dvVersion.getPersistentURL(), lastModified);
            }
            catch (VcmFailure vcmFailure) {
                new VfsException("Adapt SyncDB failed, because get active version failed: " + folder.getLocalPath(), vcmFailure);
            }
            if (adaptSyncStateForPathToLocalRoot) {
                folder.adaptSyncStateForPathToLocalRoot();
            }
        }
        this.handleCollectedExceptions(collectedExceptions, folder);
        if (!Thread.currentThread().isInterrupted()) {
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SUCCEEDED, folder, null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

