/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IVersion;
import com.tssap.dtr.client.lib.deltavlib.PathEncodingFlag;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.ResourceFactoryManager;
import com.tssap.dtr.client.lib.deltavlib.xcm.IVersionCollection;
import com.tssap.dtr.client.lib.deltavlib.xcm.VersionCollectionFactory;
import com.tssap.dtr.client.lib.exceptions.ExceptionCategory;
import com.tssap.dtr.client.lib.exceptions.ExceptionSeverity;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.util.TimeUtilities;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItemListener2;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersionHistory;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import com.tssap.dtr.client.lib.vfs.impl.FolderItemCache;
import com.tssap.dtr.client.lib.vfs.impl.FolderUtil;
import com.tssap.dtr.client.lib.vfs.impl.LazyBufferedFileOutputStream;
import com.tssap.dtr.client.lib.vfs.impl.Util;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsFile;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolder;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsSpecialPaths;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersion;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersionGraph;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspace;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspaceFolder;
import com.tssap.dtr.client.lib.vfs.impl.WrongCaseOfFolderPathUtil;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncDB;
import com.tssap.dtr.client.lib.vfs.syncdb.SyncEntry;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

abstract class SyncRemoveFeature {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$SyncRemoveFeature == null ? (class$com$tssap$dtr$client$lib$vfs$impl$SyncRemoveFeature = SyncRemoveFeature.class$("com.tssap.dtr.client.lib.vfs.impl.SyncRemoveFeature")) : class$com$tssap$dtr$client$lib$vfs$impl$SyncRemoveFeature));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$SyncRemoveFeature;

    SyncRemoveFeature() {
    }

    public void removeFromClient(VfsWorkspaceFolder workspaceFolder) throws VfsException {
        if (this.isNull(workspaceFolder)) {
            return;
        }
        IVfsFolderItem[] folderItems = workspaceFolder.getFolderItems();
        int i = 0;
        while (i < folderItems.length) {
            try {
                IVfsFolderItem folderItem = folderItems[i];
                if (folderItem.asWorkspaceFolder() != null) {
                    this.removeFromClient((VfsWorkspaceFolder)folderItem.asWorkspaceFolder());
                } else if (folderItem.asWorkspace() != null) {
                    this.removeFromClient((VfsWorkspace)folderItem.asWorkspace());
                } else {
                    LOCATION.warningT("Illegal folderitem type under workspacefolder detected: {0}", new Object[]{folderItem});
                }
            }
            catch (VfsException ignoreAlreadyLogged) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
            }
            ++i;
        }
        if (workspaceFolder.isMounted()) {
            IVirtualFile file = workspaceFolder.getLocalFile();
            String absoluteLocalPath = file.getAbsolutePath();
            if (file.exists() && file.list().length == 0 && file.delete()) {
                workspaceFolder.setLocationState(VfsFolderItemLocationState.SERVER_ONLY);
                SyncDB syncDB = workspaceFolder.getContext().getSyncDb(absoluteLocalPath);
                syncDB.removeEntry(absoluteLocalPath);
                syncDB.getSyncDbMget().setLastRemoteSyncTime(absoluteLocalPath, 0L);
            }
        }
    }

    public void removeFromClient(VfsWorkspace workspace) throws VfsException {
        if (this.isNull(workspace)) {
            return;
        }
        if (workspace.isMounted()) {
            Map checkedOutItemsByLocalPath = FolderUtil.constructCheckedOutItemsByLocalPathMap(workspace);
            IVirtualFile ioFolder = workspace.m_localFile;
            String absoluteLocalPath = PathUtilities.assureTrailingSeparator(workspace.getLocalPath(), true);
            SyncDB syncDB = workspace.getContext().getSyncDb(absoluteLocalPath);
            this.removeIoFolderFromClient(workspace.getVfsManager(), ioFolder, syncDB, checkedOutItemsByLocalPath, false);
            this.garbageCollectOrphanedSyncEntriesBelowFolder(workspace.getVfsManager(), ioFolder, syncDB, checkedOutItemsByLocalPath);
        } else {
            this.removeMountedFoldersBelowWorkspace(workspace);
        }
    }

    public void removeFromClient(VfsFolder folder) throws VfsException {
        if (this.isNull(folder)) {
            return;
        }
        if (folder.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) {
            VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.SKIPPED, folder, "Folder is " + VfsFolderItemLocationState.LOCAL_ONLY);
            return;
        }
        if (folder.isMounted()) {
            Map checkedOutItemsByLocalPath = FolderUtil.constructCheckedOutItemsByLocalPathMap(folder.getWorkspace());
            IVirtualFile ioFolder = folder.m_localFile;
            String absoluteLocalPath = PathUtilities.assureTrailingSeparator(folder.getLocalPath(), true);
            SyncDB syncDB = folder.getContext().getSyncDb(absoluteLocalPath);
            this.removeIoFolderFromClient(folder.getVfsManager(), ioFolder, syncDB, checkedOutItemsByLocalPath, false);
            this.garbageCollectOrphanedSyncEntriesBelowFolder(folder.getVfsManager(), ioFolder, syncDB, checkedOutItemsByLocalPath);
        } else {
            this.removeMountedFoldersBelowWorkspace(folder);
        }
    }

    public void removeFromClient(VfsFile file) {
        if (this.isNull(file)) {
            return;
        }
        if (file.getLocationState() == VfsFolderItemLocationState.DELETED) {
            VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.FAILED, file, "File cannot be removed because it is " + file.getLocationState());
            return;
        }
        if (file.isMounted()) {
            if (file.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.SKIPPED_BUT_WARN, file, "File is " + file.getActivityState());
                return;
            }
            Map checkedOutItemsByLocalPath = Collections.EMPTY_MAP;
            this.removeIoFileFromClient(file.getVfsManager(), file.m_localFile, file.getWorkspace().getContext().getSyncDb(Util.assureTrailingFileSeparator(file.getLocalPath(), file.getContext().getFileService().getSeparator())), checkedOutItemsByLocalPath, false);
        } else {
            VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.SKIPPED_BUT_WARN, file, "File is not mounted");
        }
    }

    private boolean isNull(VfsFolderItem folderItem) {
        if (folderItem == null) {
            LOCATION.warningT("Parameter folderItem is null.");
            return true;
        }
        return false;
    }

    private void removeMountedFoldersBelowWorkspace(IVfsGenericFolder genericFolder) throws VfsException {
        Collection mountPointFoldersBelow = FolderUtil.getMountPointFolderItemsBelow(genericFolder);
        Iterator iterator = mountPointFoldersBelow.iterator();
        while (iterator.hasNext()) {
            VfsFolderItem mountedFolderItem = (VfsFolderItem)iterator.next();
            try {
                if (mountedFolderItem.asWorkspaceFolder() != null) {
                    this.removeFromClient((VfsWorkspaceFolder)mountedFolderItem.asWorkspaceFolder());
                    continue;
                }
                if (mountedFolderItem.asWorkspace() != null) {
                    this.removeFromClient((VfsWorkspace)mountedFolderItem.asWorkspace());
                    continue;
                }
                if (mountedFolderItem.asFolder() != null) {
                    this.removeFromClient((VfsFolder)mountedFolderItem.asFolder());
                    continue;
                }
                if (mountedFolderItem.asFile() != null) {
                    this.removeFromClient((VfsFile)mountedFolderItem.asFile());
                    continue;
                }
                LOCATION.warningT("Unknown folder item type: {0}", new Object[]{mountedFolderItem});
            }
            catch (VfsException ignoreAlreadyLogged) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
            }
        }
    }

    void removeIoObjectFromClient(VersionedFileSystemManager manager, IVirtualFile ioFile, SyncDB syncDB, Map checkedOutItemsByLocalPath, boolean previewOnly) {
        if (ioFile.isDirectory()) {
            this.removeIoFolderFromClient(manager, ioFile, syncDB, checkedOutItemsByLocalPath, previewOnly);
        } else if (ioFile.isFile()) {
            this.removeIoFileFromClient(manager, ioFile, syncDB, checkedOutItemsByLocalPath, previewOnly);
        } else {
            LOCATION.warningT("IO-File does not exist or has unknown type: {0}", new Object[]{ioFile});
        }
    }

    private void removeIoFolderFromClient(VersionedFileSystemManager manager, IVirtualFile ioFile, SyncDB syncDB, Map checkedOutItemsByLocalPath, boolean previewOnly) {
        boolean isEmpty;
        IVirtualFile[] children;
        String absoluteLocalPath = ioFile.getAbsolutePath();
        IVfsActivityRecordedFolderItem activityRecordedFolderItem = (IVfsActivityRecordedFolderItem)checkedOutItemsByLocalPath.get(absoluteLocalPath);
        SyncEntry entry = syncDB.getEntry(absoluteLocalPath);
        boolean hasEntry = entry != null;
        boolean ioFolderExists = ioFile.exists();
        boolean isCheckedOut = activityRecordedFolderItem != null;
        boolean successfullyDeleted = false;
        if (!hasEntry && ioFolderExists) {
            VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.SKIPPED, ioFile, "Folder is " + VfsFolderItemLocationState.LOCAL_ONLY, 2);
            return;
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (!previewOnly && (children = ioFile.listFiles()) != null) {
            int i = 0;
            while (i < children.length) {
                this.removeIoObjectFromClient(manager, children[i], syncDB, checkedOutItemsByLocalPath, previewOnly);
                ++i;
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        boolean bl = ioFile.isDirectory() ? ioFile.list().length == 0 : (isEmpty = true);
        if (isCheckedOut) {
            VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.SKIPPED_BUT_WARN, ioFile, "Folder is " + activityRecordedFolderItem.getActivityState(), 2);
            return;
        }
        if (!isEmpty && !previewOnly) {
            VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.SKIPPED, ioFile, "Folder is not empty", 2);
            return;
        }
        if (!isCheckedOut && hasEntry && ioFolderExists && isEmpty && !previewOnly && !(successfullyDeleted = ioFile.delete())) {
            VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.FAILED, ioFile, null, 2);
            return;
        }
        if (!(ioFolderExists && !successfullyDeleted || isCheckedOut || previewOnly)) {
            syncDB.removeEntry(absoluteLocalPath);
            syncDB.getSyncDbMget().setLastRemoteSyncTime(absoluteLocalPath, 0L);
            VfsFolderItem folderItem = manager.getFolderItemCache().getFolderItemWithLocalPath(absoluteLocalPath);
            if (folderItem != null) {
                if (folderItem.asFolder() != null) {
                    ((VfsFolder)folderItem.asFolder()).setSyncedVersion(null);
                } else {
                    VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.PENDING, folderItem, "Reset synced version failed - folder expected (" + folderItem.getCategory() + ")", 2);
                }
                folderItem.setLocationState(VfsFolderItemLocationState.SERVER_ONLY);
            }
            if (successfullyDeleted) {
                VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.SUCCEEDED, ioFile, null, 2);
            }
            return;
        }
        if (previewOnly) {
            VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.SUCCEEDED, ioFile, "preview", 2);
            return;
        }
        throw new IllegalStateException("Unreachable point");
    }

    private void removeIoFileFromClient(VersionedFileSystemManager manager, IVirtualFile ioFile, SyncDB syncDB, Map checkedOutItemsByLocalPath, boolean previewOnly) {
        boolean isReadOnly;
        String absoluteLocalPath = ioFile.getAbsolutePath();
        IVfsActivityRecordedFolderItem activityRecordedFolderItem = (IVfsActivityRecordedFolderItem)checkedOutItemsByLocalPath.get(absoluteLocalPath);
        SyncEntry entry = syncDB.getEntry(absoluteLocalPath);
        boolean ioFileExists = ioFile.exists();
        boolean hasEntry = entry != null;
        boolean isCheckedOut = activityRecordedFolderItem != null;
        boolean bl = isReadOnly = !ioFile.canWrite(false);
        if (isCheckedOut) {
            VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.SKIPPED_BUT_WARN, ioFile, "File is " + activityRecordedFolderItem.getActivityState(), 1);
            return;
        }
        if (!hasEntry && ioFileExists) {
            VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.SKIPPED, ioFile, "File is " + VfsFolderItemLocationState.LOCAL_ONLY, 1);
            return;
        }
        if (!isReadOnly && ioFileExists) {
            VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.SKIPPED_BUT_WARN, ioFile, "File is writable", 1);
            return;
        }
        if (hasEntry && ioFileExists && !isCheckedOut && isReadOnly && !previewOnly) {
            boolean bl2 = ioFileExists = !ioFile.delete();
            if (ioFileExists) {
                VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.FAILED, ioFile, null, 1);
                return;
            }
        }
        if (!(ioFileExists || isCheckedOut || previewOnly)) {
            syncDB.removeEntry(absoluteLocalPath);
            syncDB.getSyncDbMget().setLastRemoteSyncTime(absoluteLocalPath, 0L);
            VfsFolderItem folderItem = manager.getFolderItemCache().getFolderItemWithLocalPath(absoluteLocalPath);
            if (folderItem != null) {
                if (folderItem.asFile() != null) {
                    ((VfsFile)folderItem.asFile()).setSyncedVersion(null);
                } else {
                    VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.PENDING, folderItem, "Reset synced version failed - file expected (" + folderItem.getCategory() + ")", 1);
                }
                folderItem.setLocationState(VfsFolderItemLocationState.SERVER_ONLY);
            }
            VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.SUCCEEDED, ioFile, null, 1);
            manager.fireEventFolderItemContentChanged(absoluteLocalPath, IVfsFolderItemListener2.ContentChangeReasons.REMOVED);
            return;
        }
        if (previewOnly) {
            VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.SUCCEEDED, ioFile, "preview", 1);
            return;
        }
        throw new IllegalStateException("Unreachable point");
    }

    private void garbageCollectOrphanedSyncEntriesBelowFolder(VersionedFileSystemManager manager, IVirtualFile ioFolder, SyncDB syncDB, Map checkedOutItemsByLocalPath) {
        String folderPath = ioFolder.getAbsolutePath();
        LOCATION.debugT("Collecting orphaned sync enries below {0} ...", new Object[]{folderPath});
        long startTime = System.currentTimeMillis();
        int total = 0;
        ArrayList<String> entriesToDelete = new ArrayList<String>();
        Iterator absoluteLocalPaths = syncDB.resourcePaths();
        while (absoluteLocalPaths.hasNext()) {
            ++total;
            String absoluteLocalPath = (String)absoluteLocalPaths.next();
            if (!absoluteLocalPath.startsWith(folderPath) || checkedOutItemsByLocalPath.containsKey(absoluteLocalPath) || manager.getCurrentContext().getFileService().constructFile(absoluteLocalPath).exists()) continue;
            entriesToDelete.add(absoluteLocalPath);
        }
        int i = 0;
        while (i < entriesToDelete.size()) {
            String absoluteLocalPath = (String)entriesToDelete.get(i);
            syncDB.removeEntry(absoluteLocalPath);
            syncDB.getSyncDbMget().setLastRemoteSyncTime(absoluteLocalPath, 0L);
            VfsFolderItem folderItem = manager.getFolderItemCache().getFolderItemWithLocalPath(absoluteLocalPath);
            if (folderItem != null) {
                if (folderItem.asFile() != null) {
                    ((VfsFile)folderItem.asFile()).setSyncedVersion(null);
                } else if (folderItem.asFolder() != null) {
                    ((VfsFolder)folderItem.asFolder()).setSyncedVersion(null);
                } else {
                    VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.PENDING, folderItem, "Reset synced version failed - activity recorded folder item expected (" + folderItem.getCategory() + ")");
                }
                folderItem.setLocationState(VfsFolderItemLocationState.SERVER_ONLY);
            }
            VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.PENDING, absoluteLocalPath, "Removed orphaned sync entry");
            ++i;
        }
        long endTime = System.currentTimeMillis();
        LOCATION.debugT("Collected {0} orphaned sync enries (out of {1}) below {2} in {3}ms.", new Object[]{new Integer(entriesToDelete.size()), new Integer(total), folderPath, new Long(endTime - startTime)});
    }

    public void syncActivityContent(IVfsActivity activity, IVfsWorkspace workspace) throws VfsException {
        if (activity.isOpen()) {
            throw new VfsException("Cannot sync activity if activity is open. Try download activity.");
        }
        IVfsVersion[] version = activity.getElementsFromClosedActivity();
        int j = 0;
        while (j < version.length) {
            VfsFile file;
            if (version[j].isFile() && (file = (VfsFile)version[j].getCorrespondingFile(workspace)) != null) {
                try {
                    this.syncToVersion(file, ((VfsVersion)version[j]).getDvVersion(), true);
                }
                catch (VfsException e) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                }
            }
            ++j;
        }
    }

    public void sync(VfsFolder folder, boolean forceSync, boolean previewSync, boolean adaptSyncStateForPathToLocalRoot) throws VfsException {
        if (folder.isMounted()) {
            this.syncMountedFolder(folder, forceSync, previewSync, adaptSyncStateForPathToLocalRoot);
        } else {
            this.syncNotMountedFolder(folder, forceSync, previewSync);
        }
    }

    private void syncNotMountedFolder(VfsFolder folder, boolean forceSync, boolean previewSync) throws VfsException {
        Collection mountPointFoldersBelow = FolderUtil.getMountPointFolderItemsBelow(folder);
        ArrayList<VfsException> collectedExceptions = new ArrayList<VfsException>(mountPointFoldersBelow.size());
        Iterator iterator = mountPointFoldersBelow.iterator();
        while (iterator.hasNext()) {
            VfsFolder mountedFolder = (VfsFolder)iterator.next();
            try {
                this.sync(mountedFolder, forceSync, previewSync, false);
            }
            catch (VfsException alreadyLogged) {
                collectedExceptions.add(alreadyLogged);
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)alreadyLogged);
            }
        }
        this.handleCollectedExceptions(collectedExceptions, folder);
    }

    protected abstract void syncMountedFolder(VfsFolder var1, boolean var2, boolean var3, boolean var4) throws VfsException;

    protected void removeDeletedFolder(VfsFolder folder) {
        String absoluteLocalPath = folder.getLocalPath();
        SyncDB syncDB = folder.getContext().getSyncDb(absoluteLocalPath);
        syncDB.removeEntry(absoluteLocalPath);
        if (folder.m_localFile.listFiles().length == 0) {
            if (folder.m_localFile.delete()) {
                VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.SUCCEEDED, folder, "Removed deleted folder");
                folder.setLocationState(VfsFolderItemLocationState.DELETED);
                folder.setSyncedVersion(null);
                VfsFolderItem parentFolder = folder.getVfsManager().getFolderItemCache().getFolderItemWithLocalPath(PathUtilities.getParentPath(absoluteLocalPath, true, false));
                if (parentFolder.asFolder() != null) {
                    HashMap<String, VfsFolder> map = new HashMap<String, VfsFolder>(1);
                    map.put(folder.getAbsoluteRemotePath(), folder);
                    ((VfsFolder)parentFolder.asFolder()).removeFolderItems(map);
                    folder.getVfsManager().fireEventFolderItemsAddedOrRemoved(parentFolder.asFolder());
                }
            } else {
                VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.SKIPPED, folder, "Could not remove deleted folder (maybe some other process locks it).");
                folder.setLocationState(VfsFolderItemLocationState.LOCAL_ONLY);
                folder.setSyncedVersion(null);
            }
        } else {
            VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.SKIPPED, folder, "Could not remove deleted folder, because it still contains local files");
            folder.setLocationState(VfsFolderItemLocationState.LOCAL_ONLY);
            folder.setSyncedVersion(null);
        }
    }

    private Map constructLocalFilesByNameMap(IVirtualFile parentFolder) {
        IVirtualFile[] currentChildren = parentFolder.listFiles();
        HashMap<String, IVirtualFile> localFilesByName = new HashMap<String, IVirtualFile>();
        if (currentChildren != null) {
            int i = 0;
            while (i < currentChildren.length) {
                IVirtualFile localFile = currentChildren[i];
                localFilesByName.put(localFile.getName(), localFile);
                ++i;
            }
        }
        return localFilesByName;
    }

    private void syncIoFolderToDvCollection(IVirtualFile currentFolder, IVersionCollection historicDvCollection, Map checkedOutItemsByLocalPath, SyncDB syncDB, IVfsWorkspace workspace) throws VfsException {
        Map currentLocalFilesByName = this.constructLocalFilesByNameMap(currentFolder);
        IVersion[] historicDvChildResources = new IVersion[]{};
        try {
            historicDvChildResources = historicDvCollection.listVersionMembers();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Could not get historic DV children", vcmFailure);
        }
        int i = 0;
        while (i < historicDvChildResources.length) {
            block12: {
                IVersion historicDvChildResource = historicDvChildResources[i];
                boolean isFile = false;
                try {
                    isFile = historicDvChildResource.isFile();
                }
                catch (VcmFailure vcmFailure) {
                    VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, historicDvChildResource.getDecodedPath(), "could not test whether file");
                    break block12;
                }
                if (isFile) {
                    this.syncIoFileToX(currentFolder, historicDvChildResource, currentLocalFilesByName, syncDB, checkedOutItemsByLocalPath, workspace);
                } else {
                    this.syncIoFolderToX(currentFolder, historicDvChildResource, currentLocalFilesByName, syncDB, checkedOutItemsByLocalPath, workspace);
                }
            }
            ++i;
        }
        FolderItemCache cache = ((VersionedFileSystemManager)workspace.getVersionedFileSystemManager()).getFolderItemCache();
        VfsFolderItem parentFolder = cache.getFolderItemWithLocalPath(currentFolder.getAbsolutePath());
        HashMap<String, VfsFolderItem> map = new HashMap<String, VfsFolderItem>();
        Iterator filesNotAvailableForGivenDate = currentLocalFilesByName.values().iterator();
        while (filesNotAvailableForGivenDate.hasNext()) {
            IVirtualFile file = (IVirtualFile)filesNotAvailableForGivenDate.next();
            this.removeIoObjectFromClient((VersionedFileSystemManager)workspace.getVersionedFileSystemManager(), file, syncDB, checkedOutItemsByLocalPath, false);
            VfsFolderItem folderItem = cache.getFolderItemWithLocalPath(file.getAbsolutePath());
            if (folderItem == null || folderItem.m_dvVcr != null && !VfsActivityRecordedFolderItem.isDvResourceDeleted(folderItem.m_dvVcr)) continue;
            map.put(folderItem.getAbsoluteRemotePath(), folderItem);
        }
        if (parentFolder != null) {
            if (parentFolder.asFolder() != null) {
                ((VfsFolder)parentFolder).removeFolderItems(map);
            } else if (parentFolder.asWorkspace() != null) {
                ((VfsWorkspace)parentFolder).removeFolderItems(map);
            }
            parentFolder.getVfsManager().fireEventFolderItemsAddedOrRemoved(parentFolder.asGenericFolder());
        }
    }

    private void syncIoFolderToX(IVirtualFile currentFolder, IVersion historicDvVersion, Map currentLocalFilesByName, SyncDB syncDB, Map checkedOutItemsByLocalPath, IVfsWorkspace workspace) {
        IVersionCollection historicDvVersionCollection = null;
        try {
            historicDvVersionCollection = VersionCollectionFactory.createVersionCollection(historicDvVersion.getConnectionTemplID(), historicDvVersion.getDecodedPath(), PathEncodingFlag.DECODED);
        }
        catch (VcmFailure vcmFailure) {
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, historicDvVersion.getDecodedPath(), "could not create versioned collection", 2);
            return;
        }
        try {
            this.syncIoFolderToDvCollection(workspace.getContext().getFileService().constructFile(currentFolder, historicDvVersion.getName()), historicDvVersionCollection, checkedOutItemsByLocalPath, syncDB, workspace);
        }
        catch (VfsException x) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, historicDvVersion.getDecodedPath(), x.getMessage(), 2);
            return;
        }
        IVirtualFile currentLocalFolder = workspace.getContext().getFileService().constructFile(currentFolder, historicDvVersion.getName());
        if (currentLocalFilesByName.containsKey(historicDvVersion.getName())) {
            currentLocalFilesByName.remove(historicDvVersion.getName());
        } else {
            currentLocalFolder.mkdirs();
        }
        SyncEntry entry = syncDB.getEntry(currentLocalFolder.getAbsolutePath());
        if (entry == null) {
            entry = syncDB.createEntry(currentLocalFolder.getAbsolutePath(), "UNKNOWN_OBJECT_ID");
        }
        Date historicDate = new Date(0L);
        try {
            historicDate = historicDvVersion.lastModified();
        }
        catch (VcmFailure vcmFailure) {
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.ERROR_LOG, historicDvVersion.getDecodedPath(), vcmFailure.getMessage(), 2);
        }
        entry.setVersionUrlAndRemoteSyncTime(historicDvVersion.getPersistentURL(), historicDate.getTime());
        syncDB.getSyncDbMget().setLastRemoteSyncTime(currentLocalFolder.getAbsolutePath(), historicDate.getTime());
        VfsFolderItem folderItem = ((VersionedFileSystemManager)workspace.getVersionedFileSystemManager()).getFolderItemCache().getFolderItemWithLocalPath(currentFolder.getAbsolutePath());
        if (folderItem != null && folderItem.asActivityRecordedFolderItem() != null) {
            VfsActivityRecordedFolderItem activityRecordedFolderItem = (VfsActivityRecordedFolderItem)folderItem.asActivityRecordedFolderItem();
            boolean needsUpdate = false;
            if (activityRecordedFolderItem.getSyncedVersion() != null) {
                if (activityRecordedFolderItem.getSyncedVersion().getLastModifiedDate().getTime() != historicDate.getTime()) {
                    needsUpdate = true;
                }
            } else {
                needsUpdate = true;
            }
            if (needsUpdate) {
                activityRecordedFolderItem.setSyncedVersion(new VfsVersion((VersionedFileSystemManager)workspace.getVersionedFileSystemManager(), historicDvVersion));
                activityRecordedFolderItem.setLocationState(VfsFolderItemLocationState.SYNCED_TO_FORMER);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void syncIoFileToX(IVirtualFile currentFolder, IVersion historicDvChildResource, Map currentLocalFilesByName, SyncDB syncDB, Map checkedOutItemsByLocalPath, IVfsWorkspace workspace) throws VfsException {
        if (currentLocalFilesByName.containsKey(historicDvChildResource.getName())) {
            IVirtualFile currentLocalFile = (IVirtualFile)currentLocalFilesByName.remove(historicDvChildResource.getName());
            SyncEntry entry = syncDB.getEntry(currentLocalFile.getAbsolutePath());
            if (entry != null && entry.isSynced()) {
                Date historicLastModified = null;
                try {
                    historicLastModified = historicDvChildResource.lastModified();
                }
                catch (VcmFailure vcmFailure) {
                    VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, currentLocalFile, "could not get last modified", 1);
                    return;
                }
                if (entry.getRemoteSyncTime() == historicLastModified.getTime()) {
                    VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SKIPPED, currentLocalFile, "already synced", 1);
                    return;
                }
                if (checkedOutItemsByLocalPath.get(currentLocalFile.getAbsolutePath()) != null) {
                    VfsActivityRecordedFolderItem folderItem = (VfsActivityRecordedFolderItem)checkedOutItemsByLocalPath.get(currentLocalFile.getAbsolutePath());
                    VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SKIPPED_BUT_WARN, folderItem, "File is " + folderItem.getActivityState());
                    return;
                }
                this.syncToVersion(currentLocalFile, historicDvChildResource, (VersionedFileSystemManager)workspace.getVersionedFileSystemManager(), syncDB);
                return;
            }
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SKIPPED_BUT_WARN, currentLocalFile, "File is " + VfsFolderItemLocationState.LOCAL_ONLY, 1);
            return;
        }
        IVirtualFile currentLocalFile = workspace.getContext().getFileService().constructFile(currentFolder, historicDvChildResource.getName());
        this.syncToVersion(currentLocalFile, historicDvChildResource, (VersionedFileSystemManager)workspace.getVersionedFileSystemManager(), syncDB);
    }

    public void syncToCalendar(VfsFolder folder, Calendar calendar) throws VfsException {
        if (!folder.isMounted()) {
            Collection mountPointFoldersBelow = FolderUtil.getMountPointFolderItemsBelow(folder);
            Iterator iterator = mountPointFoldersBelow.iterator();
            while (iterator.hasNext()) {
                VfsFolder mountedFolder = (VfsFolder)iterator.next();
                this.syncToCalendar(mountedFolder, calendar);
            }
        } else {
            IVersionCollection historicDvCollection = this.getDvVersionCollection(folder, calendar);
            if (historicDvCollection == null) {
                this.removeFromClient(folder);
            } else {
                IVirtualFile currentFolder = folder.getLocalFile();
                Map checkedOutItemsByLocalPath = FolderUtil.constructCheckedOutItemsByLocalPathMap(folder.getWorkspace());
                this.syncIoFolderToDvCollection(currentFolder, historicDvCollection, checkedOutItemsByLocalPath, folder.getSyncDB(), folder.getWorkspace());
                folder.adaptSyncStateForPathToLocalRoot();
            }
        }
    }

    protected void syncFolderItem(VfsFolderItem folderItem, boolean forceSync, boolean previewSync) throws VfsException {
        if (folderItem.asFolder() != null) {
            this.sync((VfsFolder)folderItem.asFolder(), forceSync, previewSync, false);
        } else if (folderItem.asFile() != null) {
            this.sync((VfsFile)folderItem.asFile(), forceSync, previewSync, false);
        } else if (folderItem.asWorkspace() != null) {
            this.sync((VfsWorkspace)folderItem.asWorkspace(), forceSync, previewSync);
        } else if (folderItem.asWorkspaceFolder() != null) {
            this.sync((VfsWorkspaceFolder)folderItem.asWorkspaceFolder(), forceSync, previewSync);
        } else {
            throw new IllegalStateException("Unknown folder item category: " + folderItem.getCategory());
        }
    }

    public void sync(VfsWorkspaceFolder workspaceFolder, boolean forceSync, boolean previewSync) throws VfsException {
        VfsWorkspaceFolder folderItem = workspaceFolder;
        VfsWorkspaceFolder genericFolder = workspaceFolder;
        this.syncWorkspaceOrWorkspaceFolder(folderItem, genericFolder, forceSync, previewSync);
    }

    private void syncWorkspaceOrWorkspaceFolder(VfsFolderItem asFolderItem, IVfsGenericFolder asGenericFolder, boolean forceSync, boolean previewSync) throws VfsException {
        if (asFolderItem.getLocationState() == VfsFolderItemLocationState.DELETED) {
            throw new VfsException("Folder is deleted");
        }
        VfsFolderItemLocationState oldState = asFolderItem.getLocationState();
        if (asFolderItem.isMounted()) {
            boolean created = asFolderItem.m_localFile.mkdirs();
            if (created) {
                asFolderItem.setLocationState(VfsFolderItemLocationState.SYNCED_TO_LATEST);
                asFolderItem.getVfsManager().fireEventFolderItemLocationStateChanged(asFolderItem, oldState);
            }
            try {
                asGenericFolder.refreshFolderItems();
            }
            catch (VfsException alreadyLogged) {
                VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, asFolderItem, alreadyLogged.getMessage());
                throw new VfsException("Sync (getting children) failed: " + asFolderItem.getBrowsePath());
            }
            IVfsFolderItem[] childrenFolderItems = asGenericFolder.getFolderItems();
            ArrayList<VfsException> collectedExceptions = new ArrayList<VfsException>(childrenFolderItems.length);
            int i = 0;
            while (i < childrenFolderItems.length) {
                VfsFolderItem childFolderItem = (VfsFolderItem)childrenFolderItems[i];
                try {
                    this.syncFolderItem(childFolderItem, forceSync, previewSync);
                }
                catch (VfsException ignoreAlreadyLogged) {
                    collectedExceptions.add(ignoreAlreadyLogged);
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
                }
                ++i;
            }
            asFolderItem.setLocationState(VfsFolderItemLocationState.SYNCED_TO_LATEST);
            SyncDB syncDB = asFolderItem.getContext().getSyncDb(asFolderItem.getLocalPath());
            SyncEntry syncEntry = syncDB.getEntry(asFolderItem.getLocalPath());
            if (syncEntry == null) {
                syncEntry = syncDB.createEntry(asFolderItem.getLocalPath(), "UNKNOWN_OBJECT_ID");
            }
            syncEntry.setVersionUrlAndRemoteSyncTime("UNKNOWN_VERSION_URL", 1L);
            asFolderItem.adaptSyncStateForPathToLocalRoot();
            this.handleCollectedExceptions(collectedExceptions, asFolderItem);
        } else {
            Collection mountPointFoldersBelow = FolderUtil.getMountPointFolderItemsBelow(asGenericFolder);
            ArrayList<VfsException> collectedExceptions = new ArrayList<VfsException>(mountPointFoldersBelow.size());
            Iterator iterator = mountPointFoldersBelow.iterator();
            while (iterator.hasNext()) {
                VfsFolder folder = (VfsFolder)iterator.next();
                try {
                    this.sync(folder, forceSync, previewSync, true);
                }
                catch (VfsException ignoreAlreadyLogged) {
                    collectedExceptions.add(ignoreAlreadyLogged);
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
                }
            }
            this.handleCollectedExceptions(collectedExceptions, asFolderItem);
        }
    }

    public void sync(VfsWorkspace workspace, boolean forceSync, boolean previewSync) throws VfsException {
        VfsWorkspace folderItem = workspace;
        VfsWorkspace genericFolder = workspace;
        this.syncWorkspaceOrWorkspaceFolder(folderItem, genericFolder, forceSync, previewSync);
    }

    protected void handleCollectedExceptions(ArrayList collectedExceptions, IVfsFolderItem folderItem) throws VfsException {
        switch (collectedExceptions.size()) {
            case 0: {
                break;
            }
            case 1: {
                throw (VfsException)collectedExceptions.get(0);
            }
            default: {
                throw new VfsException(ExceptionSeverity.INFO, ExceptionCategory.ONE_ARGUMENT_PLACEHOLDER, new Object[]{"Sync failures below: " + folderItem.getBrowsePath()}, collectedExceptions.toArray(new Throwable[collectedExceptions.size()]));
            }
        }
    }

    public void syncToCalendar(VfsWorkspace workspace, Calendar calendar) throws VfsException {
        VfsWorkspace asFolderItem = workspace;
        VfsWorkspace asGenericFolder = workspace;
        if (!asFolderItem.isMounted()) {
            Collection mountPointFoldersBelow = FolderUtil.getMountPointFolderItemsBelow(asGenericFolder);
            Iterator iterator = mountPointFoldersBelow.iterator();
            while (iterator.hasNext()) {
                VfsFolder mountedFolder = (VfsFolder)iterator.next();
                this.syncToCalendar(mountedFolder, calendar);
            }
        } else {
            IVersionCollection historicDvCollection = this.getDvVersionCollection(asGenericFolder, calendar);
            IVirtualFile currentFolder = asFolderItem.getLocalFile();
            Map checkedOutItemsByLocalPath = FolderUtil.constructCheckedOutItemsByLocalPathMap(workspace);
            this.syncIoFolderToDvCollection(currentFolder, historicDvCollection, checkedOutItemsByLocalPath, asFolderItem.getSyncDB(), workspace);
            asFolderItem.adaptSyncStateForPathToLocalRoot();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sync(VfsFile file, boolean forceSync, boolean previewSync, boolean adaptSyncStateForPathToLocalRoot) throws VfsException {
        if (!forceSync && file.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) {
            if (file.hasLocalRemoteNameClash()) {
                VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SKIPPED_BUT_WARN, file, "File has local-remote name clash");
                return;
            }
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SKIPPED, file, "File is " + file.getLocationState());
            return;
        }
        if (file.getLocationState() == VfsFolderItemLocationState.NOT_MOUNTED || file.getLocationState() == VfsFolderItemLocationState.DELETED) {
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SKIPPED, file, "File is " + file.getLocationState());
            return;
        }
        if (file.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            file.replaceDvVcrByReplacingVcrAndRefresh();
        }
        String absoluteLocalPath = file.getLocalPath();
        SyncDB syncDb = file.getWorkspace().getContext().getSyncDb(absoluteLocalPath);
        SyncEntry syncEntry = syncDb.getEntry(absoluteLocalPath);
        if (file.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            if (this.getShouldDate(file, syncEntry) != null) {
                VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SKIPPED_BUT_WARN, file, "File is " + file.getActivityState());
                return;
            }
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SKIPPED, file, "File is in sync");
            return;
        }
        if (VfsActivityRecordedFolderItem.isDvResourceDeleted(file.m_dvVcr)) {
            if (!previewSync) {
                this.removeDeletedFile(file, syncDb, false);
                return;
            }
            VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.SUCCEEDED, file, "preview-only");
            return;
        }
        Date shouldDate = null;
        if (!forceSync) {
            shouldDate = this.getShouldDate(file, syncEntry);
            if (shouldDate == null) {
                VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SKIPPED, file, "File is in sync");
                return;
            }
            if (file.m_localFile.canWrite(false)) {
                VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, file, "File is writable");
                throw new VfsException("Sync failed (file is writable): " + file.getLocalPath());
            }
        }
        boolean fileExisted = file.m_localFile.exists();
        if (!previewSync) {
            block36: {
                block37: {
                    IVirtualFile parentFolder = file.m_localFile.getParentFile();
                    parentFolder.mkdirs();
                    if (adaptSyncStateForPathToLocalRoot) {
                        file.adaptSyncStateForPathToLocalRoot();
                    }
                    if (fileExisted) {
                        file.m_localFile.setWritable();
                    }
                    String propfindEtag = null;
                    try {
                        propfindEtag = file.m_dvVcr.getEntityTag();
                    }
                    catch (VcmFailure vcmFailure) {
                        LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
                        VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, file, "Can't get entity tag from VCR for file: " + vcmFailure.getMessage());
                        throw new VfsException("Sync failed (can't get entity tag from VCR for file): " + file.getBrowsePath());
                    }
                    boolean gettingContentSucceeded = false;
                    try {
                        try {
                            try {
                                shouldDate = this.getContent(file, propfindEtag, shouldDate);
                            }
                            catch (VcmFailure vcmFailure) {
                                if (vcmFailure.getStatusCode() != 404) throw vcmFailure;
                                file.m_localFile.setReadOnly();
                                this.removeDeletedFile(file, syncDb, false);
                                Object var17_17 = null;
                                if (gettingContentSucceeded) return;
                                syncDb.getSyncDbMget().setLastRemoteSyncTime(absoluteLocalPath, 0L);
                                if (!file.m_localFile.exists()) {
                                    syncDb.removeEntry(file.getLocalPath());
                                    file.setLocationState(VfsFolderItemLocationState.SERVER_ONLY);
                                    return;
                                }
                                if (syncEntry == null) {
                                    syncEntry = syncDb.createEntry(absoluteLocalPath, file.getObjectID());
                                }
                                syncEntry.setVersionUrlAndRemoteSyncTime("UNKNOWN_VERSION_URL", 1L);
                                file.setLocationState(VfsFolderItemLocationState.SYNCED_TO_FORMER);
                                return;
                            }
                            catch (Exception e) {
                                LogUtil.logException((Location)LOCATION, (Throwable)e);
                                if (file.m_localFile.exists()) {
                                    file.m_localFile.setWritable();
                                }
                                propfindEtag = file.m_dvVcr.getEntityTag();
                                shouldDate = this.getContent(file, propfindEtag, shouldDate);
                            }
                            gettingContentSucceeded = true;
                            IVersion dvVersion = file.m_dvVcr.getAsVersionControlled().getActiveVersion();
                            file.setSyncedVersion(new VfsVersion(file.getVfsManager(), dvVersion));
                            String versionUrl = dvVersion.getPersistentURL();
                            if (syncEntry == null) {
                                syncEntry = syncDb.createEntry(absoluteLocalPath, file.getObjectID());
                            }
                            syncEntry.setVersionUrlAndRemoteSyncTime(versionUrl, shouldDate.getTime());
                            syncDb.getSyncDbMget().setLastRemoteSyncTime(absoluteLocalPath, shouldDate.getTime());
                            file.setLocationState(VfsFolderItemLocationState.SYNCED_TO_LATEST);
                            if (fileExisted) {
                                VfsActionRecorder.log(VfsActionType.UPDATE, VfsActionStatus.SUCCEEDED, file, null);
                                file.getVfsManager().fireEventFolderItemContentChanged(absoluteLocalPath, IVfsFolderItemListener2.ContentChangeReasons.UPDATED);
                            } else {
                                VfsActionRecorder.log(VfsActionType.CREATE, VfsActionStatus.SUCCEEDED, file, null);
                                file.getVfsManager().fireEventFolderItemContentChanged(absoluteLocalPath, IVfsFolderItemListener2.ContentChangeReasons.ADDED);
                            }
                        }
                        catch (IOException x) {
                            String msg = "Writing failed on file \"" + absoluteLocalPath + "\"";
                            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, file, "Writing local content failed (" + x.getMessage() + ")");
                            throw new VfsException(msg, x);
                        }
                        catch (VcmFailure vcmFailure) {
                            String msg = "Getting content failed for remote file \"" + absoluteLocalPath + "\"";
                            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, file, "Getting remote content failed (" + vcmFailure.getMessage() + ")");
                            throw new VfsException(msg, vcmFailure);
                        }
                        catch (VfsException e) {
                            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, file, e.getMessage());
                            throw e;
                        }
                        Object var17_18 = null;
                        if (gettingContentSucceeded) return;
                        syncDb.getSyncDbMget().setLastRemoteSyncTime(absoluteLocalPath, 0L);
                        if (!file.m_localFile.exists()) break block36;
                        if (syncEntry != null) break block37;
                    }
                    catch (Throwable throwable) {
                        Object var17_19 = null;
                        if (gettingContentSucceeded) throw throwable;
                        syncDb.getSyncDbMget().setLastRemoteSyncTime(absoluteLocalPath, 0L);
                        if (!file.m_localFile.exists()) {
                            syncDb.removeEntry(file.getLocalPath());
                            file.setLocationState(VfsFolderItemLocationState.SERVER_ONLY);
                            throw throwable;
                        }
                        if (syncEntry == null) {
                            syncEntry = syncDb.createEntry(absoluteLocalPath, file.getObjectID());
                        }
                        syncEntry.setVersionUrlAndRemoteSyncTime("UNKNOWN_VERSION_URL", 1L);
                        file.setLocationState(VfsFolderItemLocationState.SYNCED_TO_FORMER);
                        throw throwable;
                    }
                    syncEntry = syncDb.createEntry(absoluteLocalPath, file.getObjectID());
                }
                syncEntry.setVersionUrlAndRemoteSyncTime("UNKNOWN_VERSION_URL", 1L);
                file.setLocationState(VfsFolderItemLocationState.SYNCED_TO_FORMER);
                return;
            }
            syncDb.removeEntry(file.getLocalPath());
            file.setLocationState(VfsFolderItemLocationState.SERVER_ONLY);
            return;
        }
        if (fileExisted) {
            VfsActionRecorder.log(VfsActionType.UPDATE, VfsActionStatus.SUCCEEDED, file, "preview-only");
            return;
        }
        VfsActionRecorder.log(VfsActionType.CREATE, VfsActionStatus.SUCCEEDED, file, "preview-only");
    }

    public void syncToCalendar(VfsFile file, Calendar calendar, boolean adaptSyncStateForPathToLocalRoot) throws VfsException {
        IVersion dvVersion = this.getDvVersion(file, calendar);
        if (dvVersion != null) {
            this.syncToVersion(file, dvVersion, adaptSyncStateForPathToLocalRoot);
        } else {
            this.removeFromClient(file);
        }
    }

    private Date getShouldDate(VfsFile file, SyncEntry syncEntry) {
        Date shouldDate = null;
        try {
            shouldDate = file.m_dvVcr.lastModified();
        }
        catch (VcmFailure vcmFailure) {
            LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.ERROR_LOG, file, "Can't get lastmodified date from VCR for file");
            return null;
        }
        if (syncEntry != null && syncEntry.getRemoteSyncTime() >= shouldDate.getTime() && file.m_localFile.exists()) {
            return null;
        }
        return shouldDate;
    }

    private void removeDeletedFile(VfsFile file, SyncDB syncDB, boolean historicSync) {
        if (file.m_localFile.canWrite(false)) {
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, file, "File is writable");
            return;
        }
        file.m_localFile.delete();
        if (!historicSync) {
            if (!VfsActivityRecordedFolderItem.isDvResourceDeleted(file.m_dvVcr)) {
                try {
                    file.setVcrResource(VfsActivityRecordedFolderItem.createDeletedVcrResource((VfsWorkspace)file.getWorkspace(), file.getObjectID()));
                }
                catch (VfsException e) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                }
            }
            file.setLocationState(VfsFolderItemLocationState.DELETED);
        } else {
            syncDB.getSyncDbMget().setLastRemoteSyncTime(file.getLocalPath(), 0L);
        }
        syncDB.removeEntry(file.getLocalPath());
        VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.SUCCEEDED, file, null);
        if (!historicSync) {
            file.setLocationState(VfsFolderItemLocationState.DELETED);
            VfsFolderItem parentFolder = file.getVfsManager().getFolderItemCache().getFolderItemWithLocalPath(PathUtilities.getParentPath(file.getLocalPath(), true, false));
            if (parentFolder != null && parentFolder.asFolder() != null) {
                HashMap<String, VfsFile> map = new HashMap<String, VfsFile>(1);
                map.put(file.getAbsoluteRemotePath(), file);
                ((VfsFolder)parentFolder.asFolder()).removeFolderItems(map);
                file.getVfsManager().fireEventFolderItemsAddedOrRemoved(parentFolder.asFolder());
            }
        } else {
            file.setLocationState(VfsFolderItemLocationState.SERVER_ONLY);
        }
        file.setSyncedVersion(null);
        file.getVfsManager().fireEventFolderItemContentChanged(file.getLocalPath(), IVfsFolderItemListener2.ContentChangeReasons.REMOVED);
    }

    private Date getContent(VfsFile file, String propfindEtag, Date shouldDate) throws VcmFailure, IOException, VfsException {
        IOException ioException2;
        IVirtualFile localFile = file.m_localFile;
        IResource dvVcr = file.m_dvVcr;
        if (shouldDate == null && (shouldDate = dvVcr.lastModified()) == null) {
            localFile.setReadOnly();
            throw new VcmFailure("Could not get lastModified date.");
        }
        LazyBufferedFileOutputStream outputStream = new LazyBufferedFileOutputStream(localFile);
        boolean failed = false;
        try {
            String contentEtag = dvVcr.getAsFile().getContent(outputStream);
            outputStream.forceFlush();
            if (!propfindEtag.equals(contentEtag)) {
                dvVcr.refresh();
                String propfindEtag2 = dvVcr.getEntityTag();
                String contentEtag2 = dvVcr.getAsFile().getContent(new OutputStream(){

                    public void write(int b) throws IOException {
                    }
                });
                if (propfindEtag2.equals(propfindEtag) || contentEtag2.equals(contentEtag) && !contentEtag2.equals(propfindEtag2)) {
                    VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.WARN_LOG, file, "#### GET <etag> differs from PROPFIND <etag> ! ####");
                    VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.WARN_LOG, file, "PROPFIND 1 <etag> = " + propfindEtag);
                    VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.WARN_LOG, file, "GET        <etag> = " + contentEtag);
                    VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.WARN_LOG, file, "PROPFIND 2 <etag> = " + propfindEtag2);
                    VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.WARN_LOG, file, "GET retry  <etag> = " + contentEtag2);
                    failed = true;
                    throw new VfsException("Internal error: ETag problem occured.");
                }
                shouldDate = dvVcr.lastModified();
                throw new VfsException("Can't handle two consecutive (foreign) checkins when syncing " + file.getLocalPath() + ".");
            }
            Object var12_11 = null;
            ioException2 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            IOException ioException2 = null;
            try {
                outputStream.close();
                WrongCaseOfFolderPathUtil.rememberWrongCaseOfFolderPathAfterLocalWrite(file.getContext(), file.getLocalFile());
            }
            catch (IOException e) {
                Logbook.getErrorChapter().println("Closing file " + localFile.getAbsolutePath() + " failed.");
                ioException2 = e;
            }
            VfsFile.refreshTimestampOnSyncedFile(localFile, shouldDate);
            if (!localFile.setReadOnly()) {
                Logbook.getErrorChapter().println("Setting file " + localFile.getAbsolutePath() + " to read-only failed.");
            }
            if (ioException2 != null) {
                throw ioException2;
            }
            if (failed) {
                VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.WARN_LOG, file, "Removed because of ETag problem.");
                localFile.delete();
                file.setLocationState(VfsFolderItemLocationState.SERVER_ONLY);
            }
            throw throwable;
        }
        try {
            outputStream.close();
            WrongCaseOfFolderPathUtil.rememberWrongCaseOfFolderPathAfterLocalWrite(file.getContext(), file.getLocalFile());
        }
        catch (IOException e) {
            Logbook.getErrorChapter().println("Closing file " + localFile.getAbsolutePath() + " failed.");
            ioException2 = e;
        }
        VfsFile.refreshTimestampOnSyncedFile(localFile, shouldDate);
        if (!localFile.setReadOnly()) {
            Logbook.getErrorChapter().println("Setting file " + localFile.getAbsolutePath() + " to read-only failed.");
        }
        if (ioException2 != null) {
            throw ioException2;
        }
        if (failed) {
            VfsActionRecorder.log(VfsActionType.REMOVE, VfsActionStatus.WARN_LOG, file, "Removed because of ETag problem.");
            localFile.delete();
            file.setLocationState(VfsFolderItemLocationState.SERVER_ONLY);
        }
        return shouldDate;
    }

    private void syncToVersion(IVirtualFile ioFile, IVersion dvVersion, VersionedFileSystemManager manager, SyncDB syncDB) throws VfsException {
        try {
            if (!dvVersion.isFile()) {
                throw new VfsException("Not a file.");
            }
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Checking if file failed.", vcmFailure);
        }
        Date lastModified = null;
        try {
            lastModified = dvVersion.lastModified();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Could not get last modified date.", vcmFailure);
        }
        boolean updated = this.updateFileToVersionContent(ioFile, dvVersion, manager.getCurrentContext());
        String localPath = ioFile.getAbsolutePath();
        SyncEntry entry = syncDB.getEntry(localPath);
        if (entry == null) {
            try {
                entry = syncDB.createEntry(localPath, dvVersion.getXCMObjectId());
            }
            catch (VcmFailure vcmFailure) {
                LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
                entry = syncDB.createEntry(localPath, "UNKNOWN_OBJECT_ID");
            }
        }
        entry.setVersionUrlAndRemoteSyncTime(dvVersion.getPersistentURL(), lastModified.getTime());
        syncDB.getSyncDbMget().setLastRemoteSyncTime(localPath, lastModified.getTime());
        VfsFolder parentFolder = (VfsFolder)manager.getFolderItemCache().getFolderItemWithLocalPath(PathUtilities.getParentPath(localPath, true, false));
        VfsFolderItem folderItem = manager.getFolderItemCache().getFolderItemWithLocalPath(localPath);
        if (parentFolder != null && parentFolder.m_isRefreshedOnce) {
            folderItem = VfsActivityRecordedFolderItem.getVfsActivityRecordedFolderItem(parentFolder.getWorkspace(), VfsFolderItem.KEEP_DELTAV_RESOURCE, manager.getCurrentContext().getFileService().constructFile(localPath));
            parentFolder.addFolderItem(folderItem);
        }
        if (folderItem != null && folderItem.asFile() != null) {
            VfsFile file = (VfsFile)folderItem.asFile();
            try {
                if (VfsActivityRecordedFolderItem.isDvResourceDeleted(file.m_dvVcr) || lastModified.before(file.m_dvVcr.getAsVersionControlled().getActiveVersion().lastModified())) {
                    file.setLocationState(VfsFolderItemLocationState.SYNCED_TO_FORMER);
                } else {
                    file.setLocationState(VfsFolderItemLocationState.SYNCED_TO_LATEST);
                }
            }
            catch (VcmFailure e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
                file.setLocationState(VfsFolderItemLocationState.SYNCED_TO_FORMER);
            }
            file.setSyncedVersion(new VfsVersion(manager, dvVersion));
        }
        VfsActionRecorder.log(updated ? VfsActionType.UPDATE : VfsActionType.CREATE, VfsActionStatus.SUCCEEDED, ioFile, "to " + TimeUtilities.toTimeString(lastModified));
        if (updated) {
            manager.fireEventFolderItemContentChanged(localPath, IVfsFolderItemListener2.ContentChangeReasons.UPDATED);
        } else {
            manager.fireEventFolderItemContentChanged(localPath, IVfsFolderItemListener2.ContentChangeReasons.ADDED);
        }
    }

    public void syncToVersion(VfsFile file, IVersion version, boolean adaptSyncStateForPathToLocalRoot) throws VfsException {
        if (file.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY || file.getLocationState() == VfsFolderItemLocationState.DELETED) {
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SKIPPED, file, "file is " + file.getLocationState());
            return;
        }
        if (file.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SKIPPED_BUT_WARN, file, "file is " + file.getActivityState());
            return;
        }
        if (!file.isMounted()) {
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SKIPPED_BUT_WARN, file, "file is not mounted");
            return;
        }
        this.syncToVersion(file.getLocalFile(), version, file.getVfsManager(), file.getSyncDB());
        if (adaptSyncStateForPathToLocalRoot) {
            file.adaptSyncStateForPathToLocalRoot();
        }
    }

    /*
     * Loose catch block
     */
    private boolean updateFileToVersionContent(IVirtualFile localFile, IVersion dvVersion, IVfsContext context) throws VfsException {
        boolean existed;
        block13: {
            existed = localFile.exists();
            if (existed && localFile.canWrite(false)) {
                throw new VfsException("Cannot sync writable file.");
            }
            IVirtualFile parentFolder = localFile.getParentFile();
            parentFolder.mkdirs();
            if (localFile.exists()) {
                localFile.setWritable();
            }
            LazyBufferedFileOutputStream outputStream = new LazyBufferedFileOutputStream(localFile);
            Date lastModified = null;
            dvVersion.getAsFile().getContent(outputStream);
            outputStream.forceFlush();
            lastModified = dvVersion.lastModified();
            Object var11_8 = null;
            try {
                outputStream.close();
                WrongCaseOfFolderPathUtil.rememberWrongCaseOfFolderPathAfterLocalWrite(context, localFile);
            }
            catch (IOException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
            if (lastModified != null) {
                VfsFile.refreshTimestampOnSyncedFile(localFile, lastModified);
            }
            break block13;
            {
                catch (VcmFailure vcmFailure) {
                    throw new VfsException("Getting remote content failed.", vcmFailure);
                }
                catch (IOException e) {
                    throw new VfsException("Writing content to local file failed.", e);
                }
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                try {
                    outputStream.close();
                    WrongCaseOfFolderPathUtil.rememberWrongCaseOfFolderPathAfterLocalWrite(context, localFile);
                }
                catch (IOException e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                }
                if (lastModified != null) {
                    VfsFile.refreshTimestampOnSyncedFile(localFile, lastModified);
                }
                localFile.setReadOnly();
                throw throwable;
            }
        }
        localFile.setReadOnly();
        return existed;
    }

    private IVersion getDvVersion(VfsFile file, Calendar calendar) throws VfsException {
        String absoluteRemoteVersionPath = VfsSpecialPaths.getAbsoluteRemoteVersionPath(file.getWorkspace(), calendar, file.getWorkspaceRelativePath());
        IVersion dvVersion = null;
        try {
            dvVersion = ResourceFactoryManager.getInstance().getLocatorFactory().createVersion(file.getConnectionTemplateId(), absoluteRemoteVersionPath, PathEncodingFlag.DECODED);
        }
        catch (VcmFailure vcmFailure) {
            if (vcmFailure.getStatusCode() == 404) {
                return null;
            }
            throw new VfsException("DeltaV resource not found.", vcmFailure);
        }
        return dvVersion;
    }

    private IVersionCollection getDvVersionCollection(IVfsGenericFolder folder, Calendar calendar) throws VfsException {
        String absoluteRemoteVersionPath;
        if (folder.asWorkspace() != null) {
            absoluteRemoteVersionPath = VfsSpecialPaths.getAbsoluteRemoteVersionPath(folder.asWorkspace(), calendar, "");
        } else if (folder.asFolder() != null) {
            absoluteRemoteVersionPath = VfsSpecialPaths.getAbsoluteRemoteVersionPath(folder.asFolder().getWorkspace(), calendar, folder.asFolder().getWorkspaceRelativePath());
        } else {
            return null;
        }
        IVersionCollection dvCollection = null;
        try {
            dvCollection = VersionCollectionFactory.createVersionCollection(((VfsFolderItem)((Object)folder)).getConnectionTemplateId(), absoluteRemoteVersionPath, PathEncodingFlag.DECODED);
            dvCollection.isCollection();
        }
        catch (VcmFailure vcmFailure) {
            if (vcmFailure.getStatusCode() == 404) {
                return null;
            }
            throw new VfsException("DeltaV resource not found.", vcmFailure);
        }
        return dvCollection;
    }

    public void syncToBranchSequenceNumber(VfsFile file, int branchSequenceNumber) throws VfsException {
        if (file.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY || file.getLocationState() == VfsFolderItemLocationState.NOT_MOUNTED || file.getLocationState() == VfsFolderItemLocationState.DELETED) {
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SKIPPED, file, "file is " + file.getLocationState());
            return;
        }
        if (file == null) {
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, file, "no file (null)");
            return;
        }
        if (file.m_localFile.canWrite(false)) {
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SKIPPED, file, "file is writable");
            return;
        }
        int activeVersionSeqNum = file.getActiveVersion().getBranchSequenceNumber();
        int currentVersionSeqNum = file.refreshAndGetVersion().getBranchSequenceNumber();
        if (activeVersionSeqNum < branchSequenceNumber || branchSequenceNumber < 1) {
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.FAILED, file, "Invalid branch sequence number (" + branchSequenceNumber + "), valid range is [1," + activeVersionSeqNum + "]");
            return;
        }
        if (branchSequenceNumber == currentVersionSeqNum) {
            VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SKIPPED, file, "Already synced to branch sequence number " + branchSequenceNumber);
            return;
        }
        IVfsVersionHistory versionHistory = file.refreshAndGetVersionHistory();
        if (versionHistory == null) {
            throw new VfsException("Getting version history failed.");
        }
        VfsVersionGraph versionGraph = new VfsVersionGraph(versionHistory);
        VfsVersionGraph.VfsLineOfDescent lineOfDescent = null;
        try {
            lineOfDescent = (VfsVersionGraph.VfsLineOfDescent)versionGraph.getDescentLine(file.getActiveVersion().getCreatorWorkspaceName());
        }
        catch (VfsException ignoreAlreadyLogged) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)ignoreAlreadyLogged);
        }
        VfsVersionGraph.VfsLineOfDescent.VfsVersionElement element = (VfsVersionGraph.VfsLineOfDescent.VfsVersionElement)lineOfDescent.getRootElements()[0];
        int startSeq = 1;
        while (startSeq != branchSequenceNumber && element.getLineSuccessors().size() != 0) {
            element = (VfsVersionGraph.VfsLineOfDescent.VfsVersionElement)element.getLineSuccessors().get(0);
            ++startSeq;
        }
        VfsVersion version = (VfsVersion)element.getVersion();
        this.syncToVersion(file, version.getDvVersion(), true);
        VfsActionRecorder.log(VfsActionType.SYNC, VfsActionStatus.SUCCEEDED, file, "To branch sequence number " + branchSequenceNumber);
    }

    /*
     * Loose catch block
     */
    void pureSyncVersion(IVirtualFile localFile, IVersion dvVersion, IVfsContext context, VersionedFileSystemManager manager) throws VfsException {
        block11: {
            IVirtualFile parentFolder = localFile.getParentFile();
            parentFolder.mkdirs();
            localFile.setWritable();
            LazyBufferedFileOutputStream outputStream = new LazyBufferedFileOutputStream(localFile);
            Date lastModified = null;
            dvVersion.getAsFile().getContent(outputStream);
            outputStream.forceFlush();
            lastModified = dvVersion.lastModified();
            Object var11_8 = null;
            try {
                outputStream.close();
                WrongCaseOfFolderPathUtil.rememberWrongCaseOfFolderPathAfterLocalWrite(context, localFile);
            }
            catch (IOException e) {
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
            if (lastModified != null) {
                VfsFile.refreshTimestampOnSyncedFile(localFile, lastModified);
            }
            break block11;
            {
                catch (VcmFailure vcmFailure) {
                    throw new VfsException("Getting remote content failed.", vcmFailure);
                }
                catch (IOException e) {
                    throw new VfsException("Writing content to local file failed.", e);
                }
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                try {
                    outputStream.close();
                    WrongCaseOfFolderPathUtil.rememberWrongCaseOfFolderPathAfterLocalWrite(context, localFile);
                }
                catch (IOException e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                }
                if (lastModified != null) {
                    VfsFile.refreshTimestampOnSyncedFile(localFile, lastModified);
                }
                localFile.setReadOnly();
                manager.fireEventFolderItemContentChanged(localFile.getAbsolutePath(), IVfsFolderItemListener2.ContentChangeReasons.REVERTED);
                throw throwable;
            }
        }
        localFile.setReadOnly();
        manager.fireEventFolderItemContentChanged(localFile.getAbsolutePath(), IVfsFolderItemListener2.ContentChangeReasons.REVERTED);
    }

    void pureRemoveFileFromClient(VfsFile file) {
        Map checkedOutItemsByLocalPath = Collections.EMPTY_MAP;
        if (file.getLocalFile().canWrite()) {
            file.getLocalFile().setReadOnly();
        }
        this.removeIoFileFromClient(file.getVfsManager(), file.m_localFile, file.getWorkspace().getContext().getSyncDb(Util.assureTrailingFileSeparator(file.getLocalPath(), file.getContext().getFileService().getSeparator())), checkedOutItemsByLocalPath, false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

