/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.ICollection;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.PropertyFactoryAccess;
import com.tssap.dtr.client.lib.deltavlib.factory.ResourceFactoryManager;
import com.tssap.dtr.client.lib.deltavlib.properties.IMutableProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.NSPrefixBindingException;
import com.tssap.dtr.client.lib.deltavlib.properties.NSPrefixToUriMap;
import com.tssap.dtr.client.lib.deltavlib.properties.QualifiedName;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsProperty;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.impl.VersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.impl.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivity;
import com.tssap.dtr.client.lib.vfs.impl.VfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsFolderItem;
import com.tssap.dtr.client.lib.vfs.impl.VfsProperty;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersion;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspace;
import com.tssap.dtr.client.lib.vfs.impl.VfsWorkspaceFolder;
import com.tssap.dtr.client.lib.vfs.impl.VfsXcmClientProperty;
import com.tssap.dtr.client.lib.vfs.impl.VfsXcmProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class PropertiesFeature {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$vfs$impl$PropertiesFeature == null ? (class$com$tssap$dtr$client$lib$vfs$impl$PropertiesFeature = PropertiesFeature.class$("com.tssap.dtr.client.lib.vfs.impl.PropertiesFeature")) : class$com$tssap$dtr$client$lib$vfs$impl$PropertiesFeature));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$impl$PropertiesFeature;

    String[] getPropertyNames(IResource resource) throws VfsException {
        try {
            return resource.getPropertyNames();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Could not get property names", vcmFailure);
        }
    }

    IVfsProperty getProperty(IResource resource, String propertyName) throws VfsException {
        return VfsProperty.getProperty(resource, propertyName);
    }

    public String toString(IVfsActivityRecordedFolderItem folderItem, boolean useVcrInCase) throws VfsException {
        IResource resource;
        VfsActivityRecordedFolderItem internalFolderItem = (VfsActivityRecordedFolderItem)folderItem;
        if (useVcrInCase) {
            resource = internalFolderItem.getVcrResource();
        } else if (folderItem.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            resource = folderItem.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY ? internalFolderItem.getDvNewResource() : internalFolderItem.getDvWorkingResource();
        } else if (folderItem.getSyncedVersion() != null) {
            resource = ((VfsVersion)internalFolderItem.getSyncedVersion()).getDvVersion();
        } else if (folderItem.getActiveVersion() != null) {
            resource = ((VfsVersion)internalFolderItem.getActiveVersion()).getDvVersion();
        } else {
            return "?";
        }
        IVfsProperty property = this.getProperty(resource, VfsXcmProperty.RESOURCE_ID.getCompletePropertyName());
        if (property != null && property.hasChildren()) {
            return property.getChildren()[0].getValue();
        }
        return "?";
    }

    public IVfsProperty[] getAllVcrProperties(IVfsActivityRecordedFolderItem folderItem) throws VfsException {
        return this.getAllProperties(((VfsActivityRecordedFolderItem)folderItem).getVcrResource());
    }

    public IVfsProperty[] getAllVersionProperties(IVfsActivityRecordedFolderItem folderItem) throws VfsException {
        IResource resource;
        VfsActivityRecordedFolderItem internalFolderItem = (VfsActivityRecordedFolderItem)folderItem;
        if (folderItem.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
            resource = folderItem.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE ? internalFolderItem.getDvNewResource() : internalFolderItem.getDvWorkingResource();
        } else if (folderItem.getSyncedVersion() != null) {
            resource = ((VfsVersion)internalFolderItem.getSyncedVersion()).getDvVersion();
        } else if (folderItem.getActiveVersion() != null) {
            resource = ((VfsVersion)internalFolderItem.getActiveVersion()).getDvVersion();
        } else {
            return new IVfsProperty[0];
        }
        return this.getAllProperties(resource);
    }

    public IVfsProperty[] getAllProperties(IResource dvResource) throws VfsException {
        if (dvResource == null) {
            return new IVfsProperty[0];
        }
        VfsXcmClientProperty.NAMESPACE_URI.toString();
        QualifiedName[] qualifiedNames = new QualifiedName[]{};
        try {
            dvResource.getPropertyCacheControl().clearAll();
            qualifiedNames = dvResource.getQPropertyNames();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException("Getting property names failed (" + vcmFailure.getMessage() + ").", vcmFailure);
        }
        ArrayList<String> prefixedNames = new ArrayList<String>(qualifiedNames.length);
        int i = 0;
        while (i < qualifiedNames.length) {
            QualifiedName qualifiedName = qualifiedNames[i];
            String prefix = NSPrefixToUriMap.getOrGeneratePrefixForUri(qualifiedName.namespaceUri);
            prefixedNames.add(prefix + ":" + qualifiedName.localName);
            ++i;
        }
        String[] strings = prefixedNames.toArray(new String[prefixedNames.size()]);
        Map map = VfsProperty.getProperties(dvResource, strings);
        Iterator iterator = map.values().iterator();
        IVfsProperty[] properties = new IVfsProperty[map.values().size()];
        int i2 = 0;
        while (i2 < properties.length) {
            properties[i2] = (IVfsProperty)iterator.next();
            ++i2;
        }
        return properties;
    }

    Map getProperties(IResource resource, String[] propertyNames) throws VfsException {
        return VfsProperty.getProperties(resource, propertyNames);
    }

    void refreshAllProperties(VfsFolderItem folderItem) throws VfsException {
        try {
            folderItem.getNewestDeltaVResource().refresh();
        }
        catch (VcmFailure vcmFailure) {
            throw new VfsException(vcmFailure.getMessage(), vcmFailure);
        }
    }

    boolean isPropertyModifiable(VfsFolderItem folderItem, String name) {
        return false;
    }

    String[] getModifiablePropertyNames(VfsFolderItem folderItem) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    void internalSetProperty(IResource dvResource, String name, String value) throws VfsException {
        String namespacePrefix = null;
        String propertyName = name;
        int indexOfColon = propertyName.lastIndexOf(":");
        if (indexOfColon >= 0) {
            namespacePrefix = propertyName.substring(0, indexOfColon);
            propertyName = propertyName.substring(indexOfColon + 1);
        }
        if (namespacePrefix != null) {
            if (namespacePrefix.equals(VfsXcmClientProperty.NAMESPACE_URI) || namespacePrefix.equals("XCM_CLIENT")) {
                VfsException e = new VfsException("Setting property failed ( name '" + name + "', value '" + value + "' ), because properties with namespace/prefix '" + namespacePrefix + "' are protected");
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, dvResource, e.getMessage());
                throw e;
            }
            String registeredPrefix = NSPrefixToUriMap.getUriForPrefix(namespacePrefix);
            if (registeredPrefix == null) {
                VfsException ex = new VfsException("Setting property failed ( name '" + name + "', value '" + value + "' ), because namespace prefix '" + namespacePrefix + "' is not registered");
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, dvResource, ex.getMessage());
                throw ex;
            }
        }
        try {
            IProperty dvImmutableProperty = dvResource.getProperty(name);
            IMutableProperty dvProperty = dvImmutableProperty == null || !(dvImmutableProperty instanceof IMutableProperty) ? PropertyFactoryAccess.getFactory().createProperty(namespacePrefix, propertyName) : (IMutableProperty)dvImmutableProperty;
            dvProperty.setValue(value);
            try {
                dvResource.setProperties(new IProperty[]{dvProperty});
            }
            catch (VcmFailure e) {
                String cause = e.getStatusCode() == 404 ? "Property ( name '" + name + "', value '" + value + "' ) was not found" : (e.getStatusCode() == 403 ? "Not allowed to change/add the property ( name '" + name + "', value '" + value + "' )" : e.getMessage());
                VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, dvResource, cause);
                throw new VfsException(cause, e);
            }
        }
        catch (VcmFailure vcmFailure) {
            VfsException ex = new VfsException("Setting property '" + name + "' to value '" + value + "' failed.", vcmFailure);
            VfsActionRecorder.log(VfsActionType.UNSPECIFIED, VfsActionStatus.FAILED, dvResource, ex.getMessage());
            throw ex;
        }
    }

    void setProperty(VfsActivityRecordedFolderItem folderItem, String name, String value, IVfsActivity activity) throws VfsException {
        folderItem.ensureCheckoutForPropertyHandling(activity);
        this.internalSetProperty(folderItem.getNewestDeltaVResource((VfsActivity)activity), name, value);
    }

    void setProperty(VfsWorkspace workspace, String name, String value) throws VfsException {
        this.internalSetProperty(workspace.getDvWorkspace(), name, value);
    }

    void setProperty(VfsWorkspaceFolder workspaceFolder, String name, String value) throws VfsException {
        this.internalSetProperty(workspaceFolder.getVcrResource(), name, value);
    }

    String getPrefixForNamespaceUri(String namespaceUri) {
        return NSPrefixToUriMap.getPrefixForUri(namespaceUri);
    }

    void registerNamespace(String namespacePrefix, String namespaceUri) throws VfsException {
        try {
            NSPrefixToUriMap.bindPrefixToNamespace(namespacePrefix, namespaceUri);
        }
        catch (NSPrefixBindingException e) {
            throw new VfsException("Register namespace failed: prefix '" + namespacePrefix + "', uri '" + namespaceUri + "'", e);
        }
    }

    public void printInfoProperties(IVfsContext context) {
        Logbook.getPlainChapter().println("");
        Logbook.getPlainChapter().println("DTR Client ");
        Logbook.getPlainChapter().println("    Version: " + VersionedFileSystemManager.CLIENT_VERSION);
        if (context == null) {
            return;
        }
        IVfsRemoteLocator[] roots = context.getRootRemoteLocators();
        int i = 0;
        while (i < roots.length) {
            IVfsRemoteLocator root = roots[i];
            try {
                String maxVersion;
                IResource resource = ResourceFactoryManager.getInstance().getProxyFactory().createResource(root.getConnectionTemplateId(), root.getAbsoluteRemotePath());
                IProperty[] properties = resource.getPropertySet(VfsXcmClientProperty.VERSION_PROPERTIES);
                HashMap<String, String> map = new HashMap<String, String>();
                int j = 0;
                while (j < properties.length) {
                    IProperty property = properties[j];
                    map.put(property.getQualifiedName(), property.getValue());
                    ++j;
                }
                Logbook.getPlainChapter().println("DTR Server " + resource.getPersistentURL());
                PropertiesFeature.printIfAvailable("    Version: ", (String)map.get(VfsXcmProperty.SERVER_VERSION.getCompletePropertyName()));
                String minVersion = (String)map.get(VfsXcmClientProperty.MIN_CLIENT_VERSION.getCompletePropertyName());
                if (minVersion != "") {
                    PropertiesFeature.printIfAvailable("    Minimum accepted client version: ", minVersion);
                }
                if ((maxVersion = (String)map.get(VfsXcmClientProperty.MAX_CLIENT_VERSION.getCompletePropertyName())) != "~") {
                    PropertiesFeature.printIfAvailable("    Maximum accepted client version: ", maxVersion);
                }
                PropertiesFeature.printIfAvailable("    Excluded client version(s): ", (String)map.get(VfsXcmClientProperty.EXCLUDED_CLIENT_VERSIONS.getCompletePropertyName()));
                PropertiesFeature.printIfAvailable("    Included client version(s): ", (String)map.get(VfsXcmClientProperty.INCLUDED_CLIENT_VERSIONS.getCompletePropertyName()));
            }
            catch (VcmFailure vcmFailure) {
                LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
            }
            ++i;
        }
        Logbook.getPlainChapter().println("");
    }

    private static void printIfAvailable(String info, String value) {
        if (value != null && value.trim().length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(value, "\n");
            StringBuffer buffer = new StringBuffer();
            while (tokenizer.hasMoreTokens()) {
                buffer.append(tokenizer.nextToken());
                buffer.append(", ");
            }
            if (buffer.length() >= 2) {
                buffer.setLength(buffer.length() - 2);
            }
            Logbook.getPlainChapter().println(info + buffer.toString());
        }
    }

    public void printAllProperties(IResource resource) throws VfsException {
        PropertiesFeature.printProperties(this.getAllProperties(resource), "");
    }

    private static void printProperties(IVfsProperty[] properties, String indent) {
        Arrays.sort(properties);
        int i = 0;
        while (i < properties.length) {
            IVfsProperty property = properties[i];
            PropertiesFeature.printProperty(property, indent);
            ++i;
        }
    }

    private static void printProperty(IVfsProperty property, String indent) {
        String value = property.getValue();
        Logbook.getInfoChapter().println(indent + property + (value != null && value.length() > 0 ? " = " + property.getValue() : ""));
        PropertiesFeature.printProperties(property.getChildren(), indent + "    ");
    }

    static boolean isPropertyDefinedForDvResource(String completePropertyName, IResource dvResource) throws VfsException {
        int propertyState;
        block3: {
            propertyState = dvResource.getPropertyCacheControl().getPropertyState(completePropertyName);
            if (propertyState != 1) {
                try {
                    dvResource.getProperty(completePropertyName);
                }
                catch (VcmFailure vcmFailure) {
                    if (vcmFailure.getStatusCode() == 404) break block3;
                    throw new VfsException("Accessing property " + completePropertyName + " of DeltaV resource failed( " + vcmFailure.getMessage() + " ):" + dvResource.getDecodedPath(), vcmFailure);
                }
            }
        }
        return propertyState != 2;
    }

    public Object[] getChildrenObjects(IResource resource) {
        try {
            ICollection collection = resource.getAsCollection();
            if (collection != null) {
                return collection.listMembers();
            }
        }
        catch (VcmFailure vcmFailure) {
            // empty catch block
        }
        return new String[0];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

