/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.vfs.impl;

import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import java.io.IOException;
import java.io.OutputStream;

class LazyBufferedFileOutputStream
extends OutputStream {
    final int BUFFER_SIZE = 4096;
    IVirtualFile m_file;
    byte[] m_buffer = new byte[4096];
    int m_size = 0;
    OutputStream m_outputStream = null;

    LazyBufferedFileOutputStream(IVirtualFile file) {
        this.m_file = file;
    }

    void forceFlush() throws IOException {
        if (this.m_outputStream == null) {
            this.m_outputStream = this.m_file.getFileService().constructFileOutputStream(this.m_file);
        }
        this.m_outputStream.write(this.m_buffer, 0, this.m_size);
        this.m_outputStream.flush();
        this.m_size = 0;
    }

    public void flush() throws IOException {
        if (this.m_size > 0) {
            this.forceFlush();
        }
    }

    public void write(int b) throws IOException {
        this.m_buffer[this.m_size++] = (byte)b;
        if (this.m_size == 4096) {
            this.flush();
        }
    }

    public void close() throws IOException {
        this.flush();
        if (this.m_outputStream != null) {
            this.m_outputStream.close();
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int free = 4096 - this.m_size;
        int additionalBytes = len;
        int pos = off;
        while (additionalBytes > 0) {
            if (free >= additionalBytes) {
                System.arraycopy(b, pos, this.m_buffer, this.m_size, additionalBytes);
                this.m_size += additionalBytes;
                if (this.m_size == 4096) {
                    this.flush();
                }
                return;
            }
            System.arraycopy(b, pos, this.m_buffer, this.m_size, free);
            pos += free;
            additionalBytes -= free;
            this.m_size += free;
            this.flush();
            free = 4096;
        }
    }
}

